#include "g_local.h"

qboolean CheckTeamDamage (edict_t *targ, edict_t *attacker);

ctfgame_t ctfgame;
qboolean techspawn = false;

cvar_t *ctf;
cvar_t *ctf_forcejoin;
cvar_t *altgrapple;

char *ctf_statusbar =
"yb	-24 "

// health
"xv	0 "
"hnum "
"xv	50 "
"pic 0 "

// ammo
"if 8 "
"	xv	100 "
"	num 3 2 "
"	xv	150 "
"	pic 8 "
"endif "

// armor
"if 3 "
"	xv	200 "
"	num 3 4 "
"	xv	250 "
"	pic 3 "
"endif "

// selected item
"if 5 "
"	xv	296 "
"	pic 5 "
"endif "

"yb	-50 "

// timer
"if 6 "
  "xv 246 "
  "num 2 7 "
  "xv 296 "
  "pic 6 "
"endif "

//  frags
"xr	-50 "
"yt 2 "
"num 3 11 "

// Team Display
"if 20 "
" xr -80 "
" yt 2 "
" pic 20 "
"endif "

//tech
"yb -129 "
"if 22 "
  "xr -26 "
  "pic 22 "
"endif "

// red team
"yb -102 "
"if 16 "
  "xr -26 "
  "pic 16 "
"endif "

// blue team
"yb -75 "
"if 17 "
  "xr -26 "
  "pic 17 "
"endif "

// green team
"yb -102 "
"if 18 "
  "xl 2 "
  "pic 18 "
"endif "

// white team
"yb -75 "
"if 19 "
  "xl 2 "
  "pic 19 "
"endif "

// have flag graph
"if 21 "
  "yt 26 "
  "xr -24 "
  "pic 21 "
"endif "

// id view state
"if 23 "
  "xv 0 "
  "yb -58 "
  "string \"Viewing\" "
  "xv 64 "
  "stat_string 23 "
"endif "
;

static char *tnames[] = {
	"item_tech1", "item_tech2", "item_tech3", "item_tech4",
//	FIXME: Temporarily Removed the new Techs, Uncomment the next line to have them back
	"item_tech5", "item_tech6", "item_tech7", "item_tech8",
	NULL
};

void stuffcmd(edict_t *ent, char *s) 	
{
   	gi.WriteByte (11);	        
	gi.WriteString (s);
    gi.unicast (ent, true);	
}

/*--------------------------------------------------------------------------*/

/*
=================
findradius

Returns entities that have origins within a spherical area

findradius (origin, radius)
=================
*/
static edict_t *loc_findradius (edict_t *from, vec3_t org, float rad)
{
	vec3_t	eorg;
	int		j;

	if (!from)
		from = g_edicts;
	else
		from++;
	for ( ; from < &g_edicts[globals.num_edicts]; from++)
	{
		if (!from->inuse)
			continue;
#if 0
		if (from->solid == SOLID_NOT)
			continue;
#endif
		for (j=0 ; j<3 ; j++)
			eorg[j] = org[j] - (from->s.origin[j] + (from->mins[j] + from->maxs[j])*0.5);
		if (VectorLength(eorg) > rad)
			continue;
		return from;
	}

	return NULL;
}

static void loc_buildboxpoints(vec3_t p[8], vec3_t org, vec3_t mins, vec3_t maxs)
{
	VectorAdd(org, mins, p[0]);
	VectorCopy(p[0], p[1]);
	p[1][0] -= mins[0];
	VectorCopy(p[0], p[2]);
	p[2][1] -= mins[1];
	VectorCopy(p[0], p[3]);
	p[3][0] -= mins[0];
	p[3][1] -= mins[1];
	VectorAdd(org, maxs, p[4]);
	VectorCopy(p[4], p[5]);
	p[5][0] -= maxs[0];
	VectorCopy(p[0], p[6]);
	p[6][1] -= maxs[1];
	VectorCopy(p[0], p[7]);
	p[7][0] -= maxs[0];
	p[7][1] -= maxs[1];
}

static qboolean loc_CanSee (edict_t *targ, edict_t *inflictor)
{
	trace_t	trace;
	vec3_t	targpoints[8];
	int i;
	vec3_t viewpoint;

// bmodels need special checking because their origin is 0,0,0
	if (targ->movetype == MOVETYPE_PUSH)
		return false; // bmodels not supported

	loc_buildboxpoints(targpoints, targ->s.origin, targ->mins, targ->maxs);
	
	VectorCopy(inflictor->s.origin, viewpoint);
	viewpoint[2] += inflictor->viewheight;

	for (i = 0; i < 8; i++) {
		trace = gi.trace (viewpoint, vec3_origin, vec3_origin, targpoints[i], inflictor, MASK_SOLID);
		if (trace.fraction == 1.0)
			return true;
	}

	return false;
}

/*--------------------------------------------------------------------------*/

static gitem_t *flag1_item;
static gitem_t *flag2_item;
static gitem_t *flag3_item;
static gitem_t *flag4_item;

void CTFInit(void)
{
	ctf = gi.cvar("ctf", "1", CVAR_SERVERINFO);
	ctf_forcejoin = gi.cvar("ctf_forcejoin", "", 0);
	offhand = gi.cvar("offhand", "0", CVAR_SERVERINFO);
	midnight = gi.cvar("midnight", "0", CVAR_SERVERINFO|CVAR_LATCH);
	flag_drop = gi.cvar("flag_drop", "0", CVAR_SERVERINFO);
    multiple_carry = gi.cvar("multiple_carry", "0", CVAR_SERVERINFO|CVAR_LATCH);
	old_weap = gi.cvar("old_weap", "1", CVAR_SERVERINFO|CVAR_LATCH);
	competition = gi.cvar("competition", "0", CVAR_SERVERINFO|CVAR_LATCH);
	prematch = gi.cvar("prematch", "300", CVAR_SERVERINFO|CVAR_LATCH);
	matchlength = gi.cvar("matchlength", "20", CVAR_SERVERINFO);

	if (!flag1_item)
		flag1_item = FindItemByClassname("item_flag_team1");
	if (!flag2_item)
		flag2_item = FindItemByClassname("item_flag_team2");
	if (!flag3_item)
		flag3_item = FindItemByClassname("item_flag_team3");
	if (!flag4_item)
		flag4_item = FindItemByClassname("item_flag_team4");
	memset(&ctfgame, 0, sizeof(ctfgame));
	techspawn = false;
}

/*--------------------------------------------------------------------------*/

char *CTFTeamName(int team)
{
	switch (team) {
	case CTF_TEAM1:
		return "RED";
	case CTF_TEAM2:
		return "BLUE";
	case CTF_TEAM3:
		return "GREEN";
	case CTF_TEAM4:
		return "WHITE";
	}
	return "SPECTATOR";
}

char *CTFTargetTeamName(int team)
{
	switch (team) {
	case 1:
		return "RED";
	case 2:
		return "BLUE";
	case 3:
		return "GREEN";
	case 4:
		return "WHITE";
	}
	return "SPECTATOR";
}

char *CTFOtherTeamName(int team)
{
	switch (team) {
	case CTF_TEAM1:
		return "BLUE";
	case CTF_TEAM2:
		return "RED";
	}
	return "UKNOWN";
}

int CTFOtherTeam(int team)
{
	switch (team) {
	case CTF_TEAM1:
		return CTF_TEAM2;
	case CTF_TEAM2:
		return CTF_TEAM1;
	}
	return -1; // invalid value
}

/*--------------------------------------------------------------------------*/

edict_t *SelectRandomDeathmatchSpawnPoint (void);
edict_t *SelectFarthestDeathmatchSpawnPoint (void);
float	PlayersRangeFromSpot (edict_t *spot);

void CTFAssignSkin(edict_t *ent, char *s)
{
#if 0 //Damage Skin
	int playernum = ent-g_edicts-1;
	char *p;
	char t[64];

	Com_sprintf(t, sizeof(t), "%s", s);

	if ((p = strchr(t, '/')) != NULL)
		p[1] = 0;
	else
		strcpy(t, "male/");

	switch (ent->client->resp.ctf_team) {
	case CTF_TEAM1:
		gi.configstring (CS_PLAYERSKINS+playernum, va("%s\\%s%s", 
			ent->client->pers.netname, t, CTF_TEAM1_SKIN) );
		break;
	case CTF_TEAM2:
		gi.configstring (CS_PLAYERSKINS+playernum,
			va("%s\\%s%s", ent->client->pers.netname, t, CTF_TEAM2_SKIN) );
		break;
	case CTF_TEAM3:
		gi.configstring (CS_PLAYERSKINS+playernum, va("%s\\%s%s", 
			ent->client->pers.netname, t, CTF_TEAM3_SKIN) );
		break;
	case CTF_TEAM4:
		gi.configstring (CS_PLAYERSKINS+playernum,
			va("%s\\%s%s", ent->client->pers.netname, t, CTF_TEAM4_SKIN) );
		break;
	default:
		gi.configstring (CS_PLAYERSKINS+playernum, 
			va("%s\\%s", ent->client->pers.netname, s) );
		break;
	}
//	gi.cprintf(ent, PRINT_HIGH, "You have been assigned to %s team.\n", ent->client->pers.netname);
#endif
		DMGSKINSg_ctf_c(ent, s);
//Damage Skins
}

float CTFCountTeam(int team)
{
	edict_t		*player;
	int team1count = 0;
	int	team2count = 0;
    int team3count = 0;
	int team4count = 0;
	int i;

	for (i = 1; i <= maxclients->value; i++) {
		player = &g_edicts[i];

		if (!player->inuse)
			return 1;


		switch (player->client->resp.ctf_team) {
			case CTF_TEAM1:
				team1count++;
	                  break;
			case CTF_TEAM2:
				team2count++;
                  break;
			case CTF_TEAM3:
				team3count++;
                  break;
			case CTF_TEAM4:
				team4count++;
		}
	}
	if (team == 1)
		return team1count;
	if (team == 2)
		return team2count;
	if (team == 3)
		return team3count;
	if (team == 4)
		return team4count;
}





void CTFAssignTeam(gclient_t *who)
{
	edict_t		*player;
	int i;
	int lowteam = 1;
	int count[ 5 ];
	int team1count = 0, team2count = 0;
      int team3count = 0, team4count = 0;


	who->resp.ctf_state = CTF_STATE_START;

	if (!((int)dmflags->value & DF_CTF_FORCEJOIN)) {
		who->resp.ctf_team = CTF_NOTEAM;
		return;
	}

	for (i = 1; i <= maxclients->value; i++) {
		player = &g_edicts[i];

		if (!player->inuse || player->client == who)
			continue;

		switch (player->client->resp.ctf_team) {
		case CTF_TEAM1:
			team1count++;
                  break;
		case CTF_TEAM2:
			team2count++;
                  break;
		case CTF_TEAM3:
			team3count++;
                  break;
		case CTF_TEAM4:
			team4count++;
		}
	}

// Achilles - Here we figure out which team has the least number of players for forcejoin

	for ( i = 2; i <= num_teams; i++ )
	{ 
		  if( count[ i ] < count[ lowteam ] )
			  lowteam = i;
	}   
	who->resp.ctf_team = lowteam;
	

		
}

/*
================
SelectCTFSpawnPoint

go to a ctf point, but NOT the two points closest
to other players
================
*/
edict_t *SelectCTFSpawnPoint (edict_t *ent)
{
	edict_t	*spot, *spot1, *spot2;
	int		count = 0;
	int		selection;
	float	range, range1, range2;
	char	*cname;

	// Send off-handed Aliases Down to the clients
	stuffcmd(ent, "alias +grapple grapple ; alias -grapple ungrapple\n");
	stuffcmd(ent, "alias +hook grapple ; alias -hook ungrapple\n");

	if (ent->client->resp.ctf_state != CTF_STATE_START)
		if ( (int)(dmflags->value) & DF_SPAWN_FARTHEST)
			return SelectFarthestDeathmatchSpawnPoint ();
		else
			return SelectRandomDeathmatchSpawnPoint ();

	ent->client->resp.ctf_state = CTF_STATE_PLAYING;

	switch (ent->client->resp.ctf_team) {
	case CTF_TEAM1:
		cname = "info_player_team1";
		break;
	case CTF_TEAM2:
		cname = "info_player_team2";
		break;
	case CTF_TEAM3:
		cname = "info_player_team3";
		break;
	case CTF_TEAM4:
		cname = "info_player_team4";
		break;
	default:
		return SelectRandomDeathmatchSpawnPoint();
	}

	spot = NULL;
	range1 = range2 = 99999;
	spot1 = spot2 = NULL;

	while ((spot = G_Find (spot, FOFS(classname), cname)) != NULL)
	{
		count++;
		range = PlayersRangeFromSpot(spot);
		if (range < range1)
		{
			range1 = range;
			spot1 = spot;
		}
		else if (range < range2)
		{
			range2 = range;
			spot2 = spot;
		}
	}

	if (!count)
		return SelectRandomDeathmatchSpawnPoint();

	if (count <= 2)
	{
		spot1 = spot2 = NULL;
	}
	else
		count -= 2;

	selection = rand() % count;

	spot = NULL;
	do
	{
		spot = G_Find (spot, FOFS(classname), cname);
		if (spot == spot1 || spot == spot2)
			selection++;
	} while(selection--);

	return spot;
}

/*------------------------------------------------------------------------*/
/*
CTFFragBonuses

Calculate the bonuses for flag defense, flag carrier defense, etc.
Note that bonuses are not cumaltive.  You get one, they are in importance
order.
*/
void CTFFragBonuses(edict_t *targ, edict_t *inflictor, edict_t *attacker)
{
	int i;
	edict_t *ent;
	gitem_t *flag_item, *enemy_flag_item, *enemy_flag2_item, *enemy_flag3_item;
	int otherteam;
	edict_t *flag, *carrier;
	char *c;
	vec3_t v1, v2;

	otherteam = 0;

	// no bonus for fragging yourself
	if (!targ->client || !attacker->client || targ == attacker)
		return;



	// same team, if the flag at base, check to he has the enemy flag
	if (targ->client->resp.ctf_team == CTF_TEAM1) {
		flag_item = flag1_item;
		enemy_flag_item = flag2_item;
		enemy_flag2_item = flag3_item;
		enemy_flag3_item = flag4_item;
    }
	if (targ->client->resp.ctf_team == CTF_TEAM2) {
		flag_item = flag2_item;
		enemy_flag_item = flag1_item;
		enemy_flag2_item = flag3_item;
		enemy_flag3_item = flag4_item;
    }
	if (targ->client->resp.ctf_team == CTF_TEAM3) {
		flag_item = flag3_item;
		enemy_flag_item = flag1_item;
		enemy_flag2_item = flag2_item;
		enemy_flag3_item = flag4_item;
	} else {
		flag_item = flag4_item;
		enemy_flag_item = flag1_item;
		enemy_flag2_item = flag2_item;
		enemy_flag3_item = flag3_item;
	}

	// did the attacker frag the flag carrier?
	if (targ->client->pers.inventory[ITEM_INDEX(enemy_flag_item)] || targ->client->pers.inventory[ITEM_INDEX(enemy_flag2_item)] || targ->client->pers.inventory[ITEM_INDEX(enemy_flag3_item)]) {
		attacker->client->resp.ctf_lastfraggedcarrier = level.time;
		attacker->client->resp.score += CTF_FRAG_CARRIER_BONUS;
		gi.cprintf(attacker, PRINT_MEDIUM, "BONUS: %d points for fragging enemy flag carrier.\n",
			CTF_FRAG_CARRIER_BONUS);

		// the the target had the flag, clear the hurt carrier
		// field on the other team
		for (i = 1; i <= maxclients->value; i++) {
			ent = g_edicts + i;
			if (ent->inuse && ent->client->resp.ctf_team == otherteam)
				ent->client->resp.ctf_lasthurtcarrier = 0;
		}
		return;
	}

	if (targ->client->resp.ctf_lasthurtcarrier &&
		level.time - targ->client->resp.ctf_lasthurtcarrier < CTF_CARRIER_DANGER_PROTECT_TIMEOUT &&
		!attacker->client->pers.inventory[ITEM_INDEX(flag_item)]) {
		// attacker is on the same team as the flag carrier and
		// fragged a guy who hurt our flag carrier
		attacker->client->resp.score += CTF_CARRIER_DANGER_PROTECT_BONUS;
		gi.bprintf(PRINT_MEDIUM, "%s defends %s's flag carrier against an agressive enemy\n",
			attacker->client->pers.netname, 
			CTFTeamName(attacker->client->resp.ctf_team));
		return;
	}

	// flag and flag carrier area defense bonuses

	// we have to find the flag and carrier entities

	// find the flag
	switch (attacker->client->resp.ctf_team) {
	case CTF_TEAM1:
		c = "item_flag_team1";
		break;
	case CTF_TEAM2:
		c = "item_flag_team2";
		break;
    case CTF_TEAM3:
		c = "item_flag_team3";
		break;
	case CTF_TEAM4:
		c = "item_flag_team4";
		break;
	default:
		return;
	}

	flag = NULL;
	while ((flag = G_Find (flag, FOFS(classname), c)) != NULL) {
		if (!(flag->spawnflags & DROPPED_ITEM))
			break;
	}

	if (!flag)
		return; // can't find attacker's flag

	// find attacker's team's flag carrier
	for (i = 1; i <= maxclients->value; i++) {
		carrier = g_edicts + i;
		if (carrier->inuse && 
			carrier->client->pers.inventory[ITEM_INDEX(flag_item)])
			break;
		carrier = NULL;
	}

	// ok we have the attackers flag and a pointer to the carrier

	// check to see if we are defending the base's flag
	VectorSubtract(targ->s.origin, flag->s.origin, v1);
	VectorSubtract(attacker->s.origin, flag->s.origin, v2);

	if (VectorLength(v1) < CTF_TARGET_PROTECT_RADIUS ||
		VectorLength(v2) < CTF_TARGET_PROTECT_RADIUS ||
		loc_CanSee(flag, targ) || loc_CanSee(flag, attacker)) {
		// we defended the base flag
		attacker->client->resp.score += CTF_FLAG_DEFENSE_BONUS;
		if (flag->solid == SOLID_NOT)
			gi.bprintf(PRINT_MEDIUM, "%s defends the %s base.\n",
				attacker->client->pers.netname, 
				CTFTeamName(attacker->client->resp.ctf_team));
		else
			gi.bprintf(PRINT_MEDIUM, "%s defends the %s flag.\n",
				attacker->client->pers.netname, 
				CTFTeamName(attacker->client->resp.ctf_team));
		return;
	}

	if (carrier && carrier != attacker) {
		VectorSubtract(targ->s.origin, carrier->s.origin, v1);
		VectorSubtract(attacker->s.origin, carrier->s.origin, v1);

		if (VectorLength(v1) < CTF_ATTACKER_PROTECT_RADIUS ||
			VectorLength(v2) < CTF_ATTACKER_PROTECT_RADIUS ||
			loc_CanSee(carrier, targ) || loc_CanSee(carrier, attacker)) {
			attacker->client->resp.score += CTF_CARRIER_PROTECT_BONUS;
			gi.bprintf(PRINT_MEDIUM, "%s defends the %s's flag carrier.\n",
				attacker->client->pers.netname, 
				CTFTeamName(attacker->client->resp.ctf_team));
			return;
		}
	}
}

void CTFCheckHurtCarrier(edict_t *targ, edict_t *attacker)
{

	if (!targ->client || !attacker->client)
		return;

	if ( targ->client->pers.inventory[ITEM_INDEX(flag1_item)] || targ->client->pers.inventory[ITEM_INDEX(flag2_item)] || targ->client->pers.inventory[ITEM_INDEX(flag3_item)] || targ->client->pers.inventory[ITEM_INDEX(flag4_item)] )
		if (targ->client->resp.ctf_team != attacker->client->resp.ctf_team)

		attacker->client->resp.ctf_lasthurtcarrier = level.time;
}


/*------------------------------------------------------------------------*/

void CTFResetFlag(int ctf_team)
{
	char *c;
	edict_t *ent;

	switch (ctf_team) {
	case CTF_TEAM1:
		c = "item_flag_team1";
		break;
	case CTF_TEAM2:
		c = "item_flag_team2";
		break;
	case CTF_TEAM3:
		c = "item_flag_team3";
		break;
	case CTF_TEAM4:
		c = "item_flag_team4";
		break;
	default:
		return;
	}

	ent = NULL;
	while ((ent = G_Find (ent, FOFS(classname), c)) != NULL) {
		if (ent->spawnflags & DROPPED_ITEM)
			G_FreeEdict(ent);
		else {
			ent->svflags &= ~SVF_NOCLIENT;
			ent->solid = SOLID_TRIGGER;
			gi.linkentity(ent);
			ent->s.event = EV_ITEM_RESPAWN;
		}
	}
}

void CTFHasFlag(edict_t *who)
{
	if (level.time - who->client->ctf_lastflagmsg > 5) {
		gi.centerprintf(who, "You are already carrying an enemy flag!");
		who->client->ctf_lastflagmsg = level.time;
	}
}


void CTFResetFlags(void)
{
	CTFResetFlag(CTF_TEAM1);
	CTFResetFlag(CTF_TEAM2);
	CTFResetFlag(CTF_TEAM3);
	CTFResetFlag(CTF_TEAM4);
}

qboolean CTFPickup_Flag(edict_t *ent, edict_t *other)
{
	int ctf_team;
	int i;
	int targetflag; // This is just so we reset the flag that was captured, only.
	int n;
	edict_t *player;
	gitem_t *flag_item, *enemy_flag1_item, *enemy_flag2_item, *enemy_flag3_item, *enemy_flag4_item;

	n = 0;

	if (competition->value && matchtimer)
		return false;

	// figure out what team this flag is
	if (strcmp(ent->classname, "item_flag_team1") == 0)
		ctf_team = CTF_TEAM1;
	else if (strcmp(ent->classname, "item_flag_team2") == 0)
		ctf_team = CTF_TEAM2;
	else if (strcmp(ent->classname, "item_flag_team3") == 0)
		ctf_team = CTF_TEAM3;
	else if (strcmp(ent->classname, "item_flag_team4") == 0)
		ctf_team = CTF_TEAM4;
	else {
		gi.cprintf(ent, PRINT_HIGH, "Don't know what team the flag is on.\n");
		return false;
	}

	// same team, if the flag at base, check to he has the enemy flag
	if (ctf_team == CTF_TEAM1) {
		flag_item = flag1_item;
		enemy_flag1_item = flag1_item;
		enemy_flag2_item = flag2_item; // for Blue
		enemy_flag3_item = flag3_item; // Green
		enemy_flag4_item = flag4_item; // White
	} else if (ctf_team == CTF_TEAM2) {
		flag_item = flag2_item;
		enemy_flag2_item = flag2_item;
		enemy_flag1_item = flag1_item; // for Red
		enemy_flag3_item = flag3_item; // Green
		enemy_flag4_item = flag4_item; // White
	} else if (ctf_team == CTF_TEAM3) {
		flag_item = flag3_item;
		enemy_flag3_item = flag3_item;
		enemy_flag1_item = flag1_item; // for Red
		enemy_flag2_item = flag2_item; // Blue
		enemy_flag4_item = flag4_item; // White
	} else {
		flag_item = flag4_item;
		enemy_flag4_item = flag4_item;
		enemy_flag1_item = flag1_item; // for Red
		enemy_flag2_item = flag2_item; // Blue
		enemy_flag3_item = flag3_item; // Green
	}

	if (ctf_team == other->client->resp.ctf_team) {

		if (!(ent->spawnflags & DROPPED_ITEM)) {
			// the flag is at home base.  if the player has the enemy
			// flag, he's just won!
		
			if (other->client->pers.inventory[ITEM_INDEX(enemy_flag1_item)] ||
				other->client->pers.inventory[ITEM_INDEX(enemy_flag2_item)] ||
				other->client->pers.inventory[ITEM_INDEX(enemy_flag3_item)] ||
				other->client->pers.inventory[ITEM_INDEX(enemy_flag4_item)]) {
			
			if (other->client->pers.inventory[ITEM_INDEX(enemy_flag1_item)]) {
				gi.bprintf(PRINT_HIGH, "%s %s the %s flag!\n",
						other->client->pers.netname, GREENTEXT_CAPTURED, CTFTargetTeamName(1));
				other->client->pers.inventory[ITEM_INDEX(enemy_flag1_item)] = 0;
				targetflag = 1;
				CTFResetFlag(targetflag);
				n++;
			}
			if (other->client->pers.inventory[ITEM_INDEX(enemy_flag2_item)]) {
				gi.bprintf(PRINT_HIGH, "%s %s the %s flag!\n",
						other->client->pers.netname, GREENTEXT_CAPTURED, CTFTargetTeamName(2));
				other->client->pers.inventory[ITEM_INDEX(enemy_flag2_item)] = 0;
				targetflag = 2;
				CTFResetFlag(targetflag);
				n++;
			}
			if (other->client->pers.inventory[ITEM_INDEX(enemy_flag3_item)]) {
				gi.bprintf(PRINT_HIGH, "%s %s the %s flag!\n",
						other->client->pers.netname, GREENTEXT_CAPTURED, CTFTargetTeamName(3));
				other->client->pers.inventory[ITEM_INDEX(enemy_flag3_item)] = 0;
				targetflag = 3;
				CTFResetFlag(targetflag);
				n++;
			}
			if (other->client->pers.inventory[ITEM_INDEX(enemy_flag4_item)]) {
				gi.bprintf(PRINT_HIGH, "%s %s the %s flag!\n",
						other->client->pers.netname, GREENTEXT_CAPTURED, CTFTargetTeamName(4));
				other->client->pers.inventory[ITEM_INDEX(enemy_flag4_item)] = 0;
				targetflag = 4;
				CTFResetFlag(targetflag);
				n++;
			}
				
			ctfgame.last_flag_capture = level.time;
			ctfgame.last_capture_team = ctf_team;
			if (ctf_team == CTF_TEAM1)
			{
				ctfgame.team1 = ctfgame.team1 + n;
				gi.sound (ent, CHAN_RELIABLE+CHAN_NO_PHS_ADD+CHAN_VOICE, gi.soundindex("ctf/flagcap1.wav"), 1, ATTN_NONE, 0);
			}
			else if (ctf_team == CTF_TEAM2)
			{
				ctfgame.team2 = ctfgame.team2 + n;
				gi.sound (ent, CHAN_RELIABLE+CHAN_NO_PHS_ADD+CHAN_VOICE, gi.soundindex("ctf/flagcap2.wav"), 1, ATTN_NONE, 0);
			}
			else if (ctf_team == CTF_TEAM3)
			{
				ctfgame.team3 = ctfgame.team3 + n;
				gi.sound (ent, CHAN_RELIABLE+CHAN_NO_PHS_ADD+CHAN_VOICE, gi.soundindex("ctf/flagcap3.wav"), 1, ATTN_NONE, 0);
			}
			else
			{
				ctfgame.team4 = ctfgame.team4 + n;
				gi.sound (ent, CHAN_RELIABLE+CHAN_NO_PHS_ADD+CHAN_VOICE, gi.soundindex("ctf/flagcap4.wav"), 1, ATTN_NONE, 0);
			}

			// other gets another 10 frag bonus
			other->client->resp.score += CTF_CAPTURE_BONUS;
			if (n > 1)
				other->client->resp.score += CTF_CAPTURE_BONUS2;
			if (n > 2)
				other->client->resp.score += CTF_CAPTURE_BONUS3;


			// Ok, let's do the player loop, hand out the bonuses
			for (i = 1; i <= maxclients->value; i++) {
				player = &g_edicts[i];
				if (!player->inuse)
					continue;
				if (player->client->resp.ctf_team != other->client->resp.ctf_team)
					player->client->resp.ctf_lasthurtcarrier = -5;
				else if (player->client->resp.ctf_team == other->client->resp.ctf_team) {
					if (player != other)
					{
						player->client->resp.score += CTF_TEAM_BONUS;
						if (n > 2) // Give them a 20 Point buonus for a Triple Capture
 							player->client->resp.score += CTF_TEAM_BONUS2;
					}
					// award extra points for capture assists
					if (player->client->resp.ctf_lastreturnedflag + CTF_RETURN_FLAG_ASSIST_TIMEOUT > level.time) {
						gi.bprintf(PRINT_HIGH, "%s gets an %s for returning the flag!\n", player->client->pers.netname, GREENTEXT_ASSIST);
						player->client->resp.score += CTF_RETURN_FLAG_ASSIST_BONUS;
					}
					if (player->client->resp.ctf_lastfraggedcarrier + CTF_FRAG_CARRIER_ASSIST_TIMEOUT > level.time) {
						gi.bprintf(PRINT_HIGH, "%s gets an %s for fragging the flag carrier!\n", player->client->pers.netname, GREENTEXT_ASSIST);
						player->client->resp.score += CTF_FRAG_CARRIER_ASSIST_BONUS;
					}
				}
			}

			return false;
		}
		return false; // its at home base already
	}	
	// hey, its not home.  return it by teleporting it back
	gi.bprintf(PRINT_HIGH, "%s %s the %s flag!\n", 
		other->client->pers.netname, GREENTEXT_RETURNED, CTFTeamName(ctf_team));
	other->client->resp.score += CTF_RECOVERY_BONUS;
	other->client->resp.ctf_lastreturnedflag = level.time;
	gi.sound (ent, CHAN_RELIABLE+CHAN_NO_PHS_ADD+CHAN_VOICE, gi.soundindex("ctf/flagret.wav"), 1, ATTN_NONE, 0);
	//CTFResetFlag will remove this entity!  We must return false
	CTFResetFlag(ctf_team);
	return false;
}

    if (!multiple_carry->value) 
	{
		if (other->client->pers.inventory[ITEM_INDEX(enemy_flag1_item)] || 
			other->client->pers.inventory[ITEM_INDEX(enemy_flag2_item)] || 
			other->client->pers.inventory[ITEM_INDEX(enemy_flag3_item)] || 
			other->client->pers.inventory[ITEM_INDEX(enemy_flag4_item)]) {
			CTFHasFlag(other);
			return false;
		}
	}
	
	gi.bprintf(PRINT_HIGH, "%s %s the %s flag!\n",
		other->client->pers.netname, GREENTEXT_GRABBED, CTFTeamName(ctf_team));
		other->client->resp.score += CTF_FLAG_BONUS;

		other->client->pers.inventory[ITEM_INDEX(flag_item)] = 1;
		other->client->resp.ctf_flagsince = level.time;
	// pick up the flag
	// if it's not a dropped flag, we just make is disappear
	// if it's dropped, it will be removed by the pickup caller
	if (!(ent->spawnflags & DROPPED_ITEM)) {
		ent->flags |= FL_RESPAWN;
		ent->svflags |= SVF_NOCLIENT;
		ent->solid = SOLID_NOT;
	}
	return true;
}

static void CTFDropFlagTouch(edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	//owner (who dropped us) can't touch for two secs
	if (other == ent->owner && 
		ent->nextthink - level.time > CTF_AUTO_FLAG_RETURN_TIMEOUT-2)
		return;

	Touch_Item (ent, other, plane, surf);
}

static void CTFDropFlagThink(edict_t *ent)
{
	// auto return the flag
	// reset flag will remove ourselves
	if (strcmp(ent->classname, "item_flag_team1") == 0) {
		CTFResetFlag(CTF_TEAM1);
		gi.bprintf(PRINT_HIGH, "The %s flag has %s!\n",
			CTFTeamName(CTF_TEAM1), GREENTEXT_RETURNED);
	} else if (strcmp(ent->classname, "item_flag_team2") == 0) {
		CTFResetFlag(CTF_TEAM2);
		gi.bprintf(PRINT_HIGH, "The %s flag has %s!\n",
			CTFTeamName(CTF_TEAM2), GREENTEXT_RETURNED);
	} else if (strcmp(ent->classname, "item_flag_team3") == 0) {
		CTFResetFlag(CTF_TEAM3);
		gi.bprintf(PRINT_HIGH, "The %s flag has %s!\n",
			CTFTeamName(CTF_TEAM3), GREENTEXT_RETURNED);
	} else if (strcmp(ent->classname, "item_flag_team4") == 0) {
		CTFResetFlag(CTF_TEAM4);
		gi.bprintf(PRINT_HIGH, "The %s flag has %s!\n",
			CTFTeamName(CTF_TEAM4), GREENTEXT_RETURNED);
	}
}

// Called from PlayerDie, to drop the flag from a dying player
void CTFDeadDropFlag(edict_t *self)
{
	edict_t *dropped = NULL;

	if (!flag1_item || !flag2_item || !flag3_item || !flag4_item)
		CTFInit();

	if (self->client->pers.inventory[ITEM_INDEX(flag1_item)]) {
		dropped = Drop_Item(self, flag1_item);
		self->client->pers.inventory[ITEM_INDEX(flag1_item)] = 0;
		gi.bprintf(PRINT_HIGH, "%s %s the %s flag!\n",
			self->client->pers.netname, GREENTEXT_LOST, CTFTeamName(CTF_TEAM1));
		if (dropped) {
			dropped->velocity[0] = (rand() % 600) - 300;
			dropped->velocity[1] = (rand() % 600) - 300;
			dropped->think = CTFDropFlagThink;
			dropped->nextthink = level.time + CTF_AUTO_FLAG_RETURN_TIMEOUT;
			dropped->touch = CTFDropFlagTouch;
		}
	}

	if (self->client->pers.inventory[ITEM_INDEX(flag2_item)]) {
		dropped = Drop_Item(self, flag2_item);
		self->client->pers.inventory[ITEM_INDEX(flag2_item)] = 0;
		gi.bprintf(PRINT_HIGH, "%s %s the %s flag!\n",
			self->client->pers.netname, GREENTEXT_LOST, CTFTeamName(CTF_TEAM2));
		if (dropped) {
			dropped->think = CTFDropFlagThink;
			dropped->nextthink = level.time + CTF_AUTO_FLAG_RETURN_TIMEOUT;
			dropped->touch = CTFDropFlagTouch;
		}
	}
	if (self->client->pers.inventory[ITEM_INDEX(flag3_item)]) {
		dropped = Drop_Item(self, flag3_item);
		self->client->pers.inventory[ITEM_INDEX(flag3_item)] = 0;
		gi.bprintf(PRINT_HIGH, "%s %s the %s flag!\n",
			self->client->pers.netname, GREENTEXT_LOST, CTFTeamName(CTF_TEAM3));
		if (dropped) {
			dropped->think = CTFDropFlagThink;
			dropped->nextthink = level.time + CTF_AUTO_FLAG_RETURN_TIMEOUT;
			dropped->touch = CTFDropFlagTouch;
		}
	}
	if (self->client->pers.inventory[ITEM_INDEX(flag4_item)]) {
		dropped = Drop_Item(self, flag4_item);
		self->client->pers.inventory[ITEM_INDEX(flag4_item)] = 0;
		gi.bprintf(PRINT_HIGH, "%s %s the %s flag!\n",
			self->client->pers.netname, GREENTEXT_LOST, CTFTeamName(CTF_TEAM4));
		if (dropped) {
			dropped->think = CTFDropFlagThink;
			dropped->nextthink = level.time + CTF_AUTO_FLAG_RETURN_TIMEOUT;
			dropped->touch = CTFDropFlagTouch;
		}
	}

}

qboolean CTFDrop_Flag(edict_t *ent, gitem_t *item)
{
	if (ent->client->pers.inventory[ITEM_INDEX(flag1_item)] ||
		ent->client->pers.inventory[ITEM_INDEX(flag2_item)] ||
		ent->client->pers.inventory[ITEM_INDEX(flag3_item)] ||
		ent->client->pers.inventory[ITEM_INDEX(flag4_item)])
	{
		edict_t *flag;

		flag = Drop_Item(ent, item);
		flag->think = CTFDropFlagThink;
		flag->nextthink = level.time + CTF_AUTO_FLAG_RETURN_TIMEOUT;
		flag->touch = CTFDropFlagTouch;
		ent->client->pers.inventory[ITEM_INDEX(item)] = 0;
		return true;
	}
	return false;

}

static void CTFFlagThink(edict_t *ent)
{
	if (ent->solid != SOLID_NOT)
		ent->s.frame = 173 + (((ent->s.frame - 173) + 1) % 16);
	ent->nextthink = level.time + FRAMETIME;
}


void CTFFlagSetup (edict_t *ent)
{
	trace_t		tr;
	vec3_t		dest;
	float		*v;

	v = tv(-15,-15,-15);
	VectorCopy (v, ent->mins);
	v = tv(15,15,15);
	VectorCopy (v, ent->maxs);

	if (ent->model)
		gi.setmodel (ent, ent->model);
	else
		gi.setmodel (ent, ent->item->world_model);
	ent->solid = SOLID_TRIGGER;
	ent->movetype = MOVETYPE_TOSS;  
	ent->touch = Touch_Item;

	v = tv(0,0,-128);
	VectorAdd (ent->s.origin, v, dest);

	tr = gi.trace (ent->s.origin, ent->mins, ent->maxs, dest, ent, MASK_SOLID);
	if (tr.startsolid)
	{
		gi.dprintf ("CTFFlagSetup: %s startsolid at %s\n", ent->classname, vtos(ent->s.origin));
		G_FreeEdict (ent);
		return;
	}

	VectorCopy (tr.endpos, ent->s.origin);

	gi.linkentity (ent);

	ent->nextthink = level.time + FRAMETIME;
	ent->think = CTFFlagThink;
}

void CTFEffects(edict_t *player)
{
	player->s.effects &= (EF_FLAG1 | EF_FLAG2 | EF_FLAG3 | EF_FLAG4);
	if (player->health > 0) {
		if (player->client->pers.inventory[ITEM_INDEX(flag1_item)]) {
			player->s.effects |= EF_FLAG1;
		}
		if (player->client->pers.inventory[ITEM_INDEX(flag2_item)]) {
			player->s.effects |= EF_FLAG2;
		}
		if (player->client->pers.inventory[ITEM_INDEX(flag3_item)]) {
			player->s.effects |= EF_FLAG3;
		}
		if (player->client->pers.inventory[ITEM_INDEX(flag4_item)]) {
			player->s.effects |= EF_FLAG4;
		}
	}

	if (player->client->pers.inventory[ITEM_INDEX(flag1_item)])
		player->s.modelindex3 = gi.modelindex("players/male/flag1.md2");
	else if (player->client->pers.inventory[ITEM_INDEX(flag2_item)])
		player->s.modelindex3 = gi.modelindex("players/male/flag2.md2");
	else if (player->client->pers.inventory[ITEM_INDEX(flag3_item)])
		player->s.modelindex3 = gi.modelindex("players/male/flag3.md2");
	else if (player->client->pers.inventory[ITEM_INDEX(flag4_item)])
		player->s.modelindex3 = gi.modelindex("players/male/flag4.md2");
	else
		player->s.modelindex3 = 0;
}

// called when we enter the intermission
void CTFCalcScores(void)
{
	int i;

	ctfgame.total1 = ctfgame.total2 = 0;
    ctfgame.total3 = ctfgame.total4 = 0;
	for (i = 0; i < maxclients->value; i++) {
		if (!g_edicts[i+1].inuse)
			continue;
		if (game.clients[i].resp.ctf_team == CTF_TEAM1)
			ctfgame.total1 += game.clients[i].resp.score;
		if (game.clients[i].resp.ctf_team == CTF_TEAM2)
			ctfgame.total2 += game.clients[i].resp.score;
		if (game.clients[i].resp.ctf_team == CTF_TEAM3)
			ctfgame.total3 += game.clients[i].resp.score;
		if (game.clients[i].resp.ctf_team == CTF_TEAM4)
			ctfgame.total4 += game.clients[i].resp.score;
	}
}

void CTFID_f (edict_t *ent)
{
	if (ent->client->resp.id_state) {
		gi.cprintf(ent, PRINT_HIGH, "Disabling player identication display.\n");
		ent->client->resp.id_state = false;
	} else {
		gi.cprintf(ent, PRINT_HIGH, "Activating player identication display.\n");
		ent->client->resp.id_state = true;
	}
}

static void CTFSetIDView(edict_t *ent)
{
	vec3_t start, forward, end;
	trace_t tr;

	VectorCopy(ent->s.origin, start);
	start[2] += ent->viewheight;
	AngleVectors(ent->client->v_angle, forward, NULL, NULL);
	VectorMA(start, 8192, forward, end);
	tr = gi.trace(start, NULL, NULL, end, ent, MASK_SHOT|CONTENTS_SLIME|CONTENTS_LAVA);
	if (tr.ent->client)
	{
		// We don't want to display Bodies..
		if (tr.fraction < 1 && tr.ent && tr.ent->client && !tr.ent->deadflag)
		{
			ent->client->ps.stats[STAT_CTF_ID_VIEW] = CS_PLAYERSKINS + (tr.ent - g_edicts - 1);
			return;
		}
		
	}

}

void SetCTFStats(edict_t *ent) // AKA, This is the Statusbar / HUD display.
{
	gitem_t *tech;
	int i;
	int p1, p2;
    int p3, p4;
	edict_t *e;
	int t;

	p1 = p2 = p3 =p4 = 0;

	// logo headers for the frag display
	ent->client->ps.stats[STAT_CTF_TEAM1_HEADER] = gi.imageindex ("ctfsb1");
	ent->client->ps.stats[STAT_CTF_TEAM2_HEADER] = gi.imageindex ("ctfsb2");
	ent->client->ps.stats[STAT_CTF_TEAM3_HEADER] = gi.imageindex ("ctfsb3");
	ent->client->ps.stats[STAT_CTF_TEAM4_HEADER] = gi.imageindex ("ctfsb4");
	ent->client->ps.stats[STAT_CTF_JOINED_TEAM_PIC] = 0;
	
	t = 0;

	// if during intermission, we must blink the team header of the winning team
	if (level.intermissiontime && (level.framenum & 8)) { // blink 1/8th second
		// note that ctfgame.total[12] is set when we go to intermission
		if (ctfgame.team1 > ( ctfgame.team2 || ctfgame.team3 || ctfgame.team4 ))
			ent->client->ps.stats[STAT_CTF_TEAM1_HEADER] = 0;
		else if (ctfgame.team2 > ( ctfgame.team1 || ctfgame.team3 || ctfgame.team4 ))
			ent->client->ps.stats[STAT_CTF_TEAM2_HEADER] = 0;
		else if (ctfgame.team3 > ( ctfgame.team1 || ctfgame.team2 || ctfgame.team4 ))
			ent->client->ps.stats[STAT_CTF_TEAM3_HEADER] = 0;
		else if (ctfgame.team4 > ( ctfgame.team1 || ctfgame.team3 || ctfgame.team3 ))
			ent->client->ps.stats[STAT_CTF_TEAM4_HEADER] = 0;
		else
			t = 1;

		if (t = 1 && ctfgame.total1 > ( ctfgame.total2 || ctfgame.total3 || ctfgame.total4 )) // frag tie breaker
		    ent->client->ps.stats[STAT_CTF_TEAM1_HEADER] = 0;
		else if (t = 1 && ctfgame.total2 > ( ctfgame.total1 || ctfgame.total3 || ctfgame.total4 )) 
				ent->client->ps.stats[STAT_CTF_TEAM2_HEADER] = 0;
		else if (t = 1 && ctfgame.total3 > ( ctfgame.total1 || ctfgame.total2 || ctfgame.total4 )) 
				ent->client->ps.stats[STAT_CTF_TEAM3_HEADER] = 0;
		else if (t = 1 && ctfgame.total4 > ( ctfgame.total1 || ctfgame.total2 || ctfgame.total3 )) 
				ent->client->ps.stats[STAT_CTF_TEAM4_HEADER] = 0;
		else if (t = 1) { // tie game!
			ent->client->ps.stats[STAT_CTF_TEAM1_HEADER] = 0;
			ent->client->ps.stats[STAT_CTF_TEAM2_HEADER] = 0;
			ent->client->ps.stats[STAT_CTF_TEAM3_HEADER] = 0;
			ent->client->ps.stats[STAT_CTF_TEAM4_HEADER] = 0;
		}
	}

	// tech icon
	i = 0;
	ent->client->ps.stats[STAT_CTF_TECH] = 0;
	while (tnames[i]) {
		if ((tech = FindItemByClassname(tnames[i])) != NULL &&
			ent->client->pers.inventory[ITEM_INDEX(tech)]) {
			ent->client->ps.stats[STAT_CTF_TECH] = gi.imageindex(tech->icon);
			break;
		}
		i++;
	}

	// figure out what icon to display for team logos
	// three states:
	//   flag at base
	//   flag taken
	//   flag dropped
	p1 = gi.imageindex ("i_ctf1");
	e = G_Find(NULL, FOFS(classname), "item_flag_team1");
	if (e != NULL) {
		if (e->solid == SOLID_NOT) {
			int i;

			// not at base
			// check if on player
			p1 = gi.imageindex ("i_ctf1d"); // default to dropped
			for (i = 1; i <= maxclients->value; i++)
				if (g_edicts[i].inuse &&
					g_edicts[i].client->pers.inventory[ITEM_INDEX(flag1_item)]) {
					// enemy has it
					p1 = gi.imageindex ("i_ctf1t");
					break;
				}
		} else if (e->spawnflags & DROPPED_ITEM)
			p1 = gi.imageindex ("i_ctf1d"); // must be dropped
	}
	p2 = gi.imageindex ("i_ctf2");
	e = G_Find(NULL, FOFS(classname), "item_flag_team2");
	if (e != NULL) {
		if (e->solid == SOLID_NOT) {
			int i;

			// not at base
			// check if on player
			p2 = gi.imageindex ("i_ctf2d"); // default to dropped
			for (i = 1; i <= maxclients->value; i++)
				if (g_edicts[i].inuse &&
					g_edicts[i].client->pers.inventory[ITEM_INDEX(flag2_item)]) {
					// enemy has it
					p2 = gi.imageindex ("i_ctf2t");
					break;
				}
		} else if (e->spawnflags & DROPPED_ITEM)
			p2 = gi.imageindex ("i_ctf2d"); // must be dropped
	}

	if (num_teams >= 3)
	{
		p3 = gi.imageindex ("i_ctf3");
		e = G_Find(NULL, FOFS(classname), "item_flag_team3");
		if (e != NULL) {
			if (e->solid == SOLID_NOT) {
				int i;

				// not at base
				// check if on player
				p3 = gi.imageindex ("i_ctf3d"); // default to dropped
				for (i = 1; i <= maxclients->value; i++)
					if (g_edicts[i].inuse &&
						g_edicts[i].client->pers.inventory[ITEM_INDEX(flag3_item)]) {
						// enemy has it
						p3 = gi.imageindex ("i_ctf3t");
						break;
					} 
			} 
			else if (e->spawnflags & DROPPED_ITEM)
				p3 = gi.imageindex ("i_ctf3d"); // must be dropped
		}
	else
		p3 = 0;
	}

	if (num_teams == 4)
	{
		p4 = gi.imageindex ("i_ctf4");
		e = G_Find(NULL, FOFS(classname), "item_flag_team4");
		if (e != NULL) {
			if (e->solid == SOLID_NOT) {
				int i;
	
				// not at base
				// check if on player
				p4 = gi.imageindex ("i_ctf4d"); // default to dropped
				for (i = 1; i <= maxclients->value; i++)
					if (g_edicts[i].inuse &&
						g_edicts[i].client->pers.inventory[ITEM_INDEX(flag4_item)]) {
						// enemy has it
						p4 = gi.imageindex ("i_ctf4t");
						break;
					}
			} 
			else if (e->spawnflags & DROPPED_ITEM)
				p4 = gi.imageindex ("i_ctf4d"); // must be dropped
		}
	else
		p4 = 0;
	}

	ent->client->ps.stats[STAT_CTF_TEAM1_PIC] = p1;
	ent->client->ps.stats[STAT_CTF_TEAM2_PIC] = p2;
	ent->client->ps.stats[STAT_CTF_TEAM3_PIC] = p3;
	ent->client->ps.stats[STAT_CTF_TEAM4_PIC] = p4;

	if (ent->client->resp.ctf_team == CTF_TEAM1)
		ent->client->ps.stats[STAT_CTF_JOINED_TEAM_PIC] = gi.imageindex (("%s_i", ent->client->pers.skin));
	if (ent->client->resp.ctf_team == CTF_TEAM2)
		ent->client->ps.stats[STAT_CTF_JOINED_TEAM_PIC] = gi.imageindex (("%s_i", ent->client->pers.skin));
	if (ent->client->resp.ctf_team == CTF_TEAM3)
		ent->client->ps.stats[STAT_CTF_JOINED_TEAM_PIC] = gi.imageindex (("%s_i", ent->client->pers.skin));
	if (ent->client->resp.ctf_team == CTF_TEAM4)
		ent->client->ps.stats[STAT_CTF_JOINED_TEAM_PIC] = gi.imageindex (("%s_i", ent->client->pers.skin));

	if (ctfgame.last_flag_capture && level.time - ctfgame.last_flag_capture < 5) {
		if (ctfgame.last_capture_team == CTF_TEAM1)
			if (level.framenum & 8)
				ent->client->ps.stats[STAT_CTF_TEAM1_PIC] = p1;
			else
				ent->client->ps.stats[STAT_CTF_TEAM1_PIC] = 0;
		else if (ctfgame.last_capture_team == CTF_TEAM2)
			if (level.framenum & 8)
				ent->client->ps.stats[STAT_CTF_TEAM2_PIC] = p2;
			else
				ent->client->ps.stats[STAT_CTF_TEAM2_PIC] = 0;
		else if (ctfgame.last_capture_team == CTF_TEAM3)
			if (level.framenum & 8)
				ent->client->ps.stats[STAT_CTF_TEAM3_PIC] = p3;
			else
				ent->client->ps.stats[STAT_CTF_TEAM3_PIC] = 0;
		else if (ctfgame.last_capture_team == CTF_TEAM4)
			if (level.framenum & 8)
				ent->client->ps.stats[STAT_CTF_TEAM4_PIC] = p4;
			else
				ent->client->ps.stats[STAT_CTF_TEAM4_PIC] = 0;

	}


	ent->client->ps.stats[STAT_CTF_FLAG_PIC] = 0;
	if (ent->client->resp.ctf_team == CTF_TEAM1)
		if (ent->client->pers.inventory[ITEM_INDEX(flag2_item)] &&
			(level.framenum & 8))
		ent->client->ps.stats[STAT_CTF_FLAG_PIC] = gi.imageindex ("i_ctf2");
		if (ent->client->pers.inventory[ITEM_INDEX(flag3_item)] &&
			(level.framenum & 8))
		ent->client->ps.stats[STAT_CTF_FLAG_PIC] = gi.imageindex ("i_ctf3");
		if (ent->client->pers.inventory[ITEM_INDEX(flag4_item)] &&
			(level.framenum & 8))
		ent->client->ps.stats[STAT_CTF_FLAG_PIC] = gi.imageindex ("i_ctf4");

	if (ent->client->resp.ctf_team == CTF_TEAM2)
		if (ent->client->pers.inventory[ITEM_INDEX(flag1_item)] &&
			(level.framenum & 8))
		ent->client->ps.stats[STAT_CTF_FLAG_PIC] = gi.imageindex ("i_ctf1");
		if (ent->client->pers.inventory[ITEM_INDEX(flag3_item)] &&
			(level.framenum & 8))
		ent->client->ps.stats[STAT_CTF_FLAG_PIC] = gi.imageindex ("i_ctf3");
		if (ent->client->pers.inventory[ITEM_INDEX(flag4_item)] &&
			(level.framenum & 8))
		ent->client->ps.stats[STAT_CTF_FLAG_PIC] = gi.imageindex ("i_ctf4");

	if (ent->client->resp.ctf_team == CTF_TEAM3)
		if (ent->client->pers.inventory[ITEM_INDEX(flag2_item)] &&
			(level.framenum & 8))
		ent->client->ps.stats[STAT_CTF_FLAG_PIC] = gi.imageindex ("i_ctf2");
		if (ent->client->pers.inventory[ITEM_INDEX(flag1_item)] &&
			(level.framenum & 8))
		ent->client->ps.stats[STAT_CTF_FLAG_PIC] = gi.imageindex ("i_ctf1");
		if (ent->client->pers.inventory[ITEM_INDEX(flag4_item)] &&
			(level.framenum & 8))
		ent->client->ps.stats[STAT_CTF_FLAG_PIC] = gi.imageindex ("i_ctf4");

	if (ent->client->resp.ctf_team == CTF_TEAM4)
		if (ent->client->pers.inventory[ITEM_INDEX(flag2_item)] &&
			(level.framenum & 8))
		ent->client->ps.stats[STAT_CTF_FLAG_PIC] = gi.imageindex ("i_ctf2");
		if (ent->client->pers.inventory[ITEM_INDEX(flag3_item)] &&
			(level.framenum & 8))
		ent->client->ps.stats[STAT_CTF_FLAG_PIC] = gi.imageindex ("i_ctf3");
		if (ent->client->pers.inventory[ITEM_INDEX(flag1_item)] &&
			(level.framenum & 8))
		ent->client->ps.stats[STAT_CTF_FLAG_PIC] = gi.imageindex ("i_ctf1");

	ent->client->ps.stats[STAT_CTF_JOINED_TEAM_PIC] = 0;

	if (ent->client->resp.ctf_team == CTF_TEAM1)
		ent->client->ps.stats[STAT_CTF_JOINED_TEAM_PIC] = gi.imageindex ("i_ctf1");
	else if (ent->client->resp.ctf_team == CTF_TEAM2)
		ent->client->ps.stats[STAT_CTF_JOINED_TEAM_PIC] = gi.imageindex ("i_ctf2");
	else if (ent->client->resp.ctf_team == CTF_TEAM3)
		ent->client->ps.stats[STAT_CTF_JOINED_TEAM_PIC] = gi.imageindex ("i_ctf3");
	else if (ent->client->resp.ctf_team == CTF_TEAM4)
		ent->client->ps.stats[STAT_CTF_JOINED_TEAM_PIC] = gi.imageindex ("i_ctf4");


	ent->client->ps.stats[STAT_CTF_ID_VIEW] = 0;
	if (ent->client->resp.id_state)
		CTFSetIDView(ent);
}

/*------------------------------------------------------------------------*/

/*QUAKED info_player_team1 (1 0 0) (-16 -16 -24) (16 16 32)
potential team1 spawning position for ctf games
*/
void SP_info_player_team1(edict_t *self)
{
}

/*QUAKED info_player_team2 (0 0 1) (-16 -16 -24) (16 16 32)
potential team2 spawning position for ctf games
*/
void SP_info_player_team2(edict_t *self)
{
}
/*QUAKED info_player_team3 (1 0 0) (-16 -16 -24) (16 16 32)
potential team1 spawning position for ctf games
*/
void SP_info_player_team3(edict_t *self)
{
}

/*QUAKED info_player_team4 (0 0 1) (-16 -16 -24) (16 16 32)
potential team2 spawning position for ctf games
*/
void SP_info_player_team4(edict_t *self)
{
}


/*------------------------------------------------------------------------*/
/* GRAPPLE																  */
/*------------------------------------------------------------------------*/

// ent is player
void CTFPlayerResetGrapple(edict_t *ent)
{
	if (ent->client && ent->client->ctf_grapple)
		CTFResetGrapple(ent->client->ctf_grapple);
}

// self is grapple, not player
void CTFResetGrapple(edict_t *self)
{
	if (self->owner->client->ctf_grapple) {
		float volume = 1.0;
		gclient_t *cl;

		if (self->owner->client->silencer_shots)
			volume = 0.2;

		gi.sound (self->owner, CHAN_RELIABLE+CHAN_WEAPON, gi.soundindex("weapons/grapple/grreset.wav"), volume, ATTN_NORM, 0);
		cl = self->owner->client;
		cl->ctf_grapple = NULL;
		cl->ctf_grapplereleasetime = level.time;
		cl->ctf_grapplestate = CTF_GRAPPLE_STATE_FLY; // we're firing, not on hook
		cl->ps.pmove.pm_flags &= ~PMF_NO_PREDICTION;
		G_FreeEdict(self);
	}
}

void CTFGrappleTouch (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	float volume = 1.0;

	if (other == self->owner)
		return;

	if (self->owner->client->ctf_grapplestate != CTF_GRAPPLE_STATE_FLY)
		return;

	if (!CTFHasSuperGrapple(self->owner)) {
		if (surf && (surf->flags & SURF_SKY)) {
			CTFResetGrapple(self);
			return;
		}
	}

	VectorCopy(vec3_origin, self->velocity);

	PlayerNoise(self->owner, self->s.origin, PNOISE_IMPACT);

	if (other->takedamage) {
		T_Damage (other, self, self->owner, self->velocity, self->s.origin, plane->normal, self->dmg, 1, 0, MOD_GRAPPLE);
		CTFResetGrapple(self);
		return;
	}

	self->owner->client->ctf_grapplestate = CTF_GRAPPLE_STATE_PULL; // we're on hook
	self->enemy = other;

	self->solid = SOLID_NOT;

	if (self->owner->client->silencer_shots)
		volume = 0.2;

	gi.sound (self->owner, CHAN_RELIABLE+CHAN_WEAPON, gi.soundindex("weapons/grapple/grpull.wav"), volume, ATTN_NORM, 0);
	gi.sound (self, CHAN_WEAPON, gi.soundindex("weapons/grapple/grhit.wav"), volume, ATTN_NORM, 0);

	gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_SPARKS);
	gi.WritePosition (self->s.origin);
	if (!plane)
		gi.WriteDir (vec3_origin);
	else
		gi.WriteDir (plane->normal);
	gi.multicast (self->s.origin, MULTICAST_PVS);
}

// draw beam between grapple and self
void CTFGrappleDrawCable(edict_t *self)
{
	vec3_t	offset, start, end, f, r;
	vec3_t	dir;
	float	distance;

	// Achilles - I have seen this effect about 100 times playing various CTF Mods, I am sure
	// someone else has code identical to this. I may attempt a different effect on it though.
	if (altgrapple->value)
	{
		if (self->owner->client->ctf_grapplestate == CTF_GRAPPLE_STATE_FLY) {
		    gi.WriteByte(svc_temp_entity);
		    gi.WriteByte(TE_SPARKS);
		    gi.WritePosition(self->s.origin);
		    gi.WriteDir(self->s.angles);
		    gi.multicast(self->s.origin, MULTICAST_PVS);
		}
	}
	else
	{

	AngleVectors (self->owner->client->v_angle, f, r, NULL);
	VectorSet(offset, 16, 16, self->owner->viewheight-8);
	P_ProjectSource (self->owner->client, self->owner->s.origin, offset, f, r, start);

	VectorSubtract(start, self->owner->s.origin, offset);

	VectorSubtract (start, self->s.origin, dir);
	distance = VectorLength(dir);
	// don't draw cable if close
	if (distance < 64)
		return;

#if 0
	if (distance > 256)
		return;

	// check for min/max pitch
	vectoangles (dir, angles);
	if (angles[0] < -180)
		angles[0] += 360;
	if (fabs(angles[0]) > 45)
		return;

	trace_t	tr; //!!

	tr = gi.trace (start, NULL, NULL, self->s.origin, self, MASK_SHOT);
	if (tr.ent != self) {
		CTFResetGrapple(self);
		return;
	}
#endif

	// adjust start for beam origin being in middle of a segment
//	VectorMA (start, 8, f, start);

	VectorCopy (self->s.origin, end);
	// adjust end z for end spot since the monster is currently dead
//	end[2] = self->absmin[2] + self->size[2] / 2;

	gi.WriteByte (svc_temp_entity);
#if 1 //def USE_GRAPPLE_CABLE
	gi.WriteByte (TE_GRAPPLE_CABLE);
	gi.WriteShort (self->owner - g_edicts);
	gi.WritePosition (self->owner->s.origin);
	gi.WritePosition (end);
	gi.WritePosition (offset);
#else
	gi.WriteByte (TE_MEDIC_CABLE_ATTACK);
	gi.WriteShort (self - g_edicts);
	gi.WritePosition (end);
	gi.WritePosition (start);
#endif
	gi.multicast (self->s.origin, MULTICAST_PVS);
	}
	
}

void SV_AddGravity (edict_t *ent);

// pull the player toward the grapple
void CTFGrapplePull(edict_t *self)
{
	vec3_t hookdir, v;
	float vlen;

	if (strcmp(self->owner->client->pers.weapon->classname, "weapon_grapple") == 0 &&
		!self->owner->client->newweapon &&
		self->owner->client->weaponstate != WEAPON_FIRING &&
		self->owner->client->weaponstate != WEAPON_ACTIVATING) {
		CTFResetGrapple(self);
		return;
	}

	if (self->enemy) {
		if (self->enemy->solid == SOLID_NOT) {
			CTFResetGrapple(self);
			return;
		}
		if (self->enemy->solid == SOLID_BBOX) {
			VectorScale(self->enemy->size, 0.5, v);
			VectorAdd(v, self->enemy->s.origin, v);
			VectorAdd(v, self->enemy->mins, self->s.origin);
			gi.linkentity (self);
		} else
			VectorCopy(self->enemy->velocity, self->velocity);
		if (self->enemy->takedamage &&
			!CheckTeamDamage (self->enemy, self->owner)) {
			float volume = 1.0;

			if (self->owner->client->silencer_shots)
				volume = 0.2;

			T_Damage (self->enemy, self, self->owner, self->velocity, self->s.origin, vec3_origin, 1, 1, 0, MOD_GRAPPLE);
			gi.sound (self, CHAN_WEAPON, gi.soundindex("weapons/grapple/grhurt.wav"), volume, ATTN_NORM, 0);
		}
		if (self->enemy->deadflag) { // he died
			CTFResetGrapple(self);
			return;
		}
	}

	CTFGrappleDrawCable(self);

	if (self->owner->client->ctf_grapplestate > CTF_GRAPPLE_STATE_FLY) {

 // Achilles-  Commented Out, doing partial hack to make grapple a bit more useful

		// pull player toward grapple
		// this causes icky stuff with prediction, we need to extend
		// the prediction layer to include two new fields in the player
		// move stuff: a point and a velocity.  The client should add
		// that velociy in the direction of the point
		vec3_t forward, up;



		AngleVectors (self->owner->client->v_angle, forward, NULL, up);
		VectorCopy(self->owner->s.origin, v);
		v[2] += self->owner->viewheight;
		VectorSubtract (self->s.origin, v, hookdir);

		 vlen = VectorNormalize(hookdir);

 		if (CTFHasSuperGrapple(self))
			VectorScale(hookdir, CTF_SUPER_GRAPPLE_PULL_SPEED, hookdir);
		else
			VectorScale(hookdir, CTF_GRAPPLE_PULL_SPEED, hookdir);
		VectorCopy(hookdir, self->owner->velocity);


/*
		if (self->owner->client->ctf_grapplestate == CTF_GRAPPLE_STATE_PULL &&
			vlen < 64) {
			float volume = 1.0;

			if (self->owner->client->silencer_shots)
				volume = 0.2;

			self->owner->client->ps.pmove.pm_flags |= PMF_NO_PREDICTION;
		//	gi.sound (self->owner, CHAN_RELIABLE+CHAN_WEAPON, gi.soundindex("weapons/grapple/grhang.wav"), volume, ATTN_NORM, 0);
			self->owner->client->ctf_grapplestate = CTF_GRAPPLE_STATE_HANG;
		}

		VectorNormalize (hookdir);
		if (CTFHasSuperGrapple(self))
			VectorScale(hookdir, CTF_SUPER_GRAPPLE_PULL_SPEED, hookdir);
		else
			VectorScale(hookdir, CTF_GRAPPLE_PULL_SPEED, hookdir);
		VectorCopy(hookdir, self->owner->velocity);
		SV_AddGravity(self->owner);
*/	}
}

void CTFFireGrapple (edict_t *self, vec3_t start, vec3_t dir, int damage, int speed, int effect)
{
	edict_t	*grapple;
	trace_t	tr;

	VectorNormalize (dir);

	grapple = G_Spawn();
	VectorCopy (start, grapple->s.origin);
	VectorCopy (start, grapple->s.old_origin);
	vectoangles (dir, grapple->s.angles);
	VectorScale (dir, speed, grapple->velocity);
	grapple->movetype = MOVETYPE_FLYMISSILE;
	grapple->clipmask = MASK_SHOT;
	grapple->solid = SOLID_BBOX;
	grapple->s.effects |= effect;
	VectorClear (grapple->mins);
	VectorClear (grapple->maxs);
	grapple->s.modelindex = gi.modelindex ("models/weapons/grapple/hook/tris.md2");
//	grapple->s.sound = gi.soundindex ("misc/lasfly.wav");
	grapple->owner = self;
	grapple->touch = CTFGrappleTouch;
//	grapple->nextthink = level.time + FRAMETIME;
//	grapple->think = CTFGrappleThink;
	grapple->dmg = damage;
	self->client->ctf_grapple = grapple;
	self->client->ctf_grapplestate = CTF_GRAPPLE_STATE_FLY; // we're firing, not on hook
	gi.linkentity (grapple);

	tr = gi.trace (self->s.origin, NULL, NULL, grapple->s.origin, grapple, MASK_SHOT);
	if (tr.fraction < 1.0)
	{
		VectorMA (grapple->s.origin, -10, dir, grapple->s.origin);
		grapple->touch (grapple, tr.ent, NULL, NULL);
	}
}	

void CTFGrappleFire (edict_t *ent, vec3_t g_offset, int damage, int effect)
{
	vec3_t	forward, right;
	vec3_t	start;
	vec3_t	offset;
	float volume = 1.0;

	if (ent->client->ctf_grapplestate > CTF_GRAPPLE_STATE_FLY)
		return; // it's already out

	AngleVectors (ent->client->v_angle, forward, right, NULL);
//	VectorSet(offset, 24, 16, ent->viewheight-8+2);
	VectorSet(offset, 24, 8, ent->viewheight-8+2);
	VectorAdd (offset, g_offset, offset);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

	VectorScale (forward, -2, ent->client->kick_origin);
	ent->client->kick_angles[0] = -1;

	if (ent->client->silencer_shots)
		volume = 0.2;

	gi.sound (ent, CHAN_RELIABLE+CHAN_WEAPON, gi.soundindex("weapons/grapple/grfire.wav"), volume, ATTN_NORM, 0);
	if (CTFHasSuperGrapple(ent))
		CTFFireGrapple (ent, start, forward, damage, CTF_SUPER_GRAPPLE_SPEED, effect);
	else
		CTFFireGrapple (ent, start, forward, damage, CTF_GRAPPLE_SPEED, effect);

#if 0
	// send muzzle flash
	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_BLASTER);
	gi.multicast (ent->s.origin, MULTICAST_PVS);
#endif

	PlayerNoise(ent, start, PNOISE_WEAPON);
}


void CTFWeapon_Grapple_Fire (edict_t *ent)
{
	int		damage;

	damage = 10;
	CTFGrappleFire (ent, vec3_origin, damage, 0);
	ent->client->ps.gunframe++;
}

void CTFWeapon_Grapple (edict_t *ent)
{
	static int	pause_frames[]	= {10, 18, 27, 0};
	static int	fire_frames[]	= {6, 0};
	int prevstate;

	// if the the attack button is still down, stay in the firing frame
	if ((ent->client->buttons & BUTTON_ATTACK) && 
		ent->client->weaponstate == WEAPON_FIRING &&
		ent->client->ctf_grapple)
		ent->client->ps.gunframe = 9;

	if (!(ent->client->buttons & BUTTON_ATTACK) && 
		ent->client->ctf_grapple) {
		CTFResetGrapple(ent->client->ctf_grapple);
		if (ent->client->weaponstate == WEAPON_FIRING)
			ent->client->weaponstate = WEAPON_READY;
	}


	if (ent->client->newweapon && 
		ent->client->ctf_grapplestate > CTF_GRAPPLE_STATE_FLY &&
		ent->client->weaponstate == WEAPON_FIRING) {
		// he wants to change weapons while grappled
		ent->client->weaponstate = WEAPON_DROPPING;
		ent->client->ps.gunframe = 32;
	}

	prevstate = ent->client->weaponstate;
	Weapon_Generic (ent, 5, 9, 31, 36, pause_frames, fire_frames, 
		CTFWeapon_Grapple_Fire);

	// if we just switched back to grapple, immediately go to fire frame
	if (prevstate == WEAPON_ACTIVATING &&
		ent->client->weaponstate == WEAPON_READY &&
		ent->client->ctf_grapplestate > CTF_GRAPPLE_STATE_FLY) {
		if (!(ent->client->buttons & BUTTON_ATTACK))
			ent->client->ps.gunframe = 9;
		else
			ent->client->ps.gunframe = 5;
		ent->client->weaponstate = WEAPON_FIRING;
	}
}

void CTFTeam_f(edict_t *ent)
{
	char *t, *s;
	int desired_team;

	t = gi.args();

	if (!*t)
	{
		gi.cprintf(ent, PRINT_HIGH, "You are on the %s team.\n", CTFTeamName(ent->client->resp.ctf_team));
		return;
	}


	if (num_teams == 2)
	{
		if (Q_stricmp(t, "red") == 0)
			desired_team = CTF_TEAM1;
		else if (Q_stricmp(t, "blue") == 0)
			desired_team = CTF_TEAM2;
		else
			desired_team = CTF_NOTEAM;
	}

	if (num_teams == 3)
	{
		if (Q_stricmp(t, "red") == 0)
			desired_team = CTF_TEAM1;
		else if (Q_stricmp(t, "blue") == 0)
			desired_team = CTF_TEAM2;
		else if (Q_stricmp(t, "green") == 0)
			desired_team = CTF_TEAM3;
		else
			desired_team = CTF_NOTEAM;
	}

	if (num_teams == 4)
	{
		if (Q_stricmp(t, "red") == 0)
			desired_team = CTF_TEAM1;
		else if (Q_stricmp(t, "blue") == 0)
			desired_team = CTF_TEAM2;
		else if (Q_stricmp(t, "green") == 0)
			desired_team = CTF_TEAM3;
		else if (Q_stricmp(t, "white") == 0)
			desired_team = CTF_TEAM4;
		else
			desired_team = CTF_NOTEAM;
	}
	if (ent->client->resp.ctf_team == desired_team) {
		gi.cprintf(ent, PRINT_HIGH, "You are already on the %s team.\n",
			CTFTeamName(ent->client->resp.ctf_team));
		return;
	}

	if (desired_team == CTF_NOTEAM)
	{
		gi.cprintf(ent, PRINT_HIGH, "That team not available in this map. \n");
		return;
	}

////
	if (matchtimer)
	{
		ent->client->resp.ctf_team = desired_team;
		ent->client->resp.ctf_state = CTF_STATE_START;
		s = Info_ValueForKey (ent->client->pers.userinfo, "skin");
		CTFAssignSkin(ent, s);
	}

	if (!competition->value)
	{
		if (ent->solid == SOLID_NOT)
		{ // spectator
			PutClientInServer (ent);
			// add a teleportation effect
			ent->s.event = EV_PLAYER_TELEPORT;
			// hold in place briefly
			ent->client->ps.pmove.pm_flags = PMF_TIME_TELEPORT;
			ent->client->ps.pmove.pm_time = 14;
			gi.bprintf(PRINT_HIGH, "%s joined the %s team.\n",
			ent->client->pers.netname, CTFTeamName(desired_team));
		}

		ent->svflags = 0;
		ent->flags &= ~FL_GODMODE;
		ent->health = 0;
		player_die (ent, ent, ent, 100000, vec3_origin);
		// don't even bother waiting for death frames
		ent->deadflag = DEAD_DEAD;
		respawn (ent);
	
		ent->client->resp.score = 0;
	
		gi.bprintf(PRINT_HIGH, "%s changed to the %s team.\n",
			ent->client->pers.netname, CTFTeamName(desired_team));
	}

}

/*
==================
CTFScoreboardMessage
==================
*/
void CTFScoreboardMessage (edict_t *ent, edict_t *killer)
{
	char	entry[2048];
	char	string[2800];
	int		len;
	int		i, j, k;
	int		sorted[4][MAX_CLIENTS];
	int		sortedscores[4][MAX_CLIENTS];
	int		score, total[4], totalscore[4];
	int		last[4];
	gclient_t	*cl;
	edict_t		*cl_ent;
	int team;
	int maxsize = 1000;

	// sort the clients by team and score
	total[0] = total[1] = total[2] = total[3] = 0;
	last[0] = last[1] =  last[2] = last[3] = 0;
	totalscore[0] = totalscore[1] = totalscore[2] = totalscore[3] = 0;
	for (i=0 ; i<game.maxclients ; i++)
	{
		cl_ent = g_edicts + 1 + i;
		if (!cl_ent->inuse)
			continue;
		if (game.clients[i].resp.spectator == true)
			continue;
		else if (game.clients[i].resp.ctf_team == CTF_TEAM1)
			team = 0;
		else if (game.clients[i].resp.ctf_team == CTF_TEAM2)
			team = 1;
		else if (game.clients[i].resp.ctf_team == CTF_TEAM3)
			team = 2;
		else if (game.clients[i].resp.ctf_team == CTF_TEAM4)
			team = 3;
		else
			continue; // unknown team or spectating.

		score = game.clients[i].resp.score;
		for (j=0 ; j<total[team] ; j++)
		{
			if (score > sortedscores[team][j])
				break;
		}
		for (k=total[team] ; k>j ; k--)
		{
			sorted[team][k] = sorted[team][k-1];
			sortedscores[team][k] = sortedscores[team][k-1];
		}
		sorted[team][j] = i;
		sortedscores[team][j] = score;
		totalscore[team] += score;
		total[team]++;
	}

	// print level name and exit rules
	// add the clients in sorted order
	*string = 0;
	len = 0;

	// team one
	//This is where it sets up the text on top of the CTF Banner.. (xx/x     X)
	sprintf(string, "if 24 xv 8 yv 8 pic 24 endif " // Team 1 (Red)
		"xv 88 yv 30 string \"%3d\" "
		"xv 44 yv 30 string \"score\" "
		"xv 88 yv 10 string \"%3d\" " 
		"xv 44 yv 10 string \"caps\" "
		// Team 2 (Blue)
		"if 25 xv 168 yv 8 pic 25 endif "
		"xv 248 yv 30 string \"%3d\" "
		"xv 204 yv 30 string \"score\" "
		"xv 248 yv 10 string \"%3d\" " 
		"xv 204 yv 10 string \"caps\" "
		// Team 3 (Green)
		"if 26 xv 8 yv 126 pic 26 endif "
		"xv 88 yv 148 string \"%3d\" " 
		"xv 44 yv 148 string \"score\" "
		"xv 88 yv 128 string \"%3d\" " 
		"xv 44 yv 128 string \"caps\" "
		// Team 4 (White)
		"if 27 xv 168 yv 126 pic 27 endif "
		"xv 248 yv 148 string \"%3d\" "
		"xv 204 yv 148 string \"score\" "
		"xv 248 yv 128 string \"%3d\" " 
		"xv 204 yv 128 string \"caps\" ",
		totalscore[0], ctfgame.team1, 
		totalscore[1], ctfgame.team2, 
		totalscore[2], ctfgame.team3,
		totalscore[3], ctfgame.team4);

	len = strlen(string);

    // Everything with the Scoreboard works up to this point.. (I think, anyways.)

	for (i=0 ; i<16 ; i++)  
	{
		if (i >= total[0] && i >= total[1] && i >= total[2] && i >= total[3])
			break; // done, I think. <shrugs>

#if 0 //ndef NEW_SCORE
		// set up y
		sprintf(entry, "yv %d ", 42 + i * 8);
		if (maxsize - len > strlen(entry)) {
			strcat(string, entry);
			len = strlen(string);
		}
#else
		*entry = 0;
#endif  

		// left Upper side (Red Team)
		if (i < total[0]) {
			cl = &game.clients[sorted[0][i]];
			cl_ent = g_edicts + 1 + sorted[0][i];

#if 0 //ndef NEW_SCORE
			sprintf(entry+strlen(entry),
			"xv 0 %s \"%3d %3d %-12.12s\" ",
			(cl_ent == ent) ? "string2" : "string",
			cl->resp.score, 
			(cl->ping > 999) ? 999 : cl->ping, 
			cl->pers.netname);

			if (cl_ent->client->pers.inventory[ITEM_INDEX(flag2_item)])
				strcat(entry, "xv 56 picn sbfctf2 ");
			if (cl_ent->client->pers.inventory[ITEM_INDEX(flag3_item)])
				strcat(entry, "xv 56 picn sbfctf3 ");
			if (cl_ent->client->pers.inventory[ITEM_INDEX(flag4_item)])
				strcat(entry, "xv 56 picn sbfctf4 ");


#else
			sprintf(entry+strlen(entry),
				"ctf 0 %d %d %d %d ",
				42 + i * 8,
				sorted[0][i],
				cl->resp.score,
				cl->ping > 999 ? 999 : cl->ping);

			if (cl_ent->client->pers.inventory[ITEM_INDEX(flag2_item)])
				sprintf(entry + strlen(entry), "xv 56 yv %d picn sbfctf2 ",
					42 + i * 8);
			if (cl_ent->client->pers.inventory[ITEM_INDEX(flag3_item)])
				sprintf(entry + strlen(entry), "xv 56 yv %d picn sbfctf3 ",
					42 + i * 8);
			if (cl_ent->client->pers.inventory[ITEM_INDEX(flag4_item)])
				sprintf(entry + strlen(entry), "xv 56 yv %d picn sbfctf4 ",
					42 + i * 8);

#endif

			if (maxsize - len > strlen(entry)) {
				strcat(string, entry);
				len = strlen(string);
				last[0] = i;
			}
		}

		// left Lower side (Green Team)
		//NOTE!! This is basically just copy/pasted, so if it shits, it's not MY fault. :P
		if (i < total[2]) {
			cl = &game.clients[sorted[2][i]];
			cl_ent = g_edicts + 1 + sorted[2][i];

#if 0 //ndef NEW_SCORE
			sprintf(entry+strlen(entry),
			"xv 0 %s \"%3d %3d %-12.12s\" ",
			(cl_ent == ent) ? "string2" : "string",
			cl->resp.score, 
			(cl->ping > 999) ? 999 : cl->ping, 
			cl->pers.netname);

			if (cl_ent->client->pers.inventory[ITEM_INDEX(flag2_item)])
				strcat(entry, "xv 56 picn sbfctf2 ");
			if (cl_ent->client->pers.inventory[ITEM_INDEX(flag1_item)])
				strcat(entry, "xv 56 picn sbfctf1 ");
			if (cl_ent->client->pers.inventory[ITEM_INDEX(flag4_item)])
				strcat(entry, "xv 56 picn sbfctf4 ");


#else
			sprintf(entry+strlen(entry),
				"ctf 0 %d %d %d %d ",
				160 + i * 8,
				sorted[2][i],
				cl->resp.score,
				cl->ping > 999 ? 999 : cl->ping);

			if (cl_ent->client->pers.inventory[ITEM_INDEX(flag2_item)])
				sprintf(entry + strlen(entry), "xv 56 yv %d picn sbfctf2 ",
					160 + i * 8);
			if (cl_ent->client->pers.inventory[ITEM_INDEX(flag1_item)])
				sprintf(entry + strlen(entry), "xv 56 yv %d picn sbfctf1 ",
					160 + i * 8);
			if (cl_ent->client->pers.inventory[ITEM_INDEX(flag4_item)])
				sprintf(entry + strlen(entry), "xv 56 yv %d picn sbfctf4 ",
					160 + i * 8); // double Y constant to send it down twice as far.

#endif

			if (maxsize - len > strlen(entry)) {
				strcat(string, entry);
				len = strlen(string);
				last[2] = i;
			}
		}
		// right upper side (Blue Team)
		if (i < total[1]) {
			cl = &game.clients[sorted[1][i]];
			cl_ent = g_edicts + 1 + sorted[1][i];

#if 0 //ndef NEW_SCORE
			sprintf(entry+strlen(entry),
			"xv 160 %s \"%3d %3d %-12.12s\" ",
			(cl_ent == ent) ? "string2" : "string",
			cl->resp.score, 
			(cl->ping > 999) ? 999 : cl->ping, 
			cl->pers.netname);

			if (cl_ent->client->pers.inventory[ITEM_INDEX(flag1_item)])
				strcat(entry, "xv 216 picn sbfctf1 ");
			if (cl_ent->client->pers.inventory[ITEM_INDEX(flag3_item)])
				strcat(entry, "xv 216 picn sbfctf3 ");
			if (cl_ent->client->pers.inventory[ITEM_INDEX(flag4_item)])
				strcat(entry, "xv 216 picn sbfctf4 ");

#else

			sprintf(entry+strlen(entry),
				"ctf 160 %d %d %d %d ",
				42 + i * 8,
				sorted[1][i],
				cl->resp.score,
				cl->ping > 999 ? 999 : cl->ping);

			if (cl_ent->client->pers.inventory[ITEM_INDEX(flag1_item)])
				sprintf(entry + strlen(entry), "xv 216 yv %d picn sbfctf1 ",
					42 + i * 8);
			if (cl_ent->client->pers.inventory[ITEM_INDEX(flag3_item)])
				sprintf(entry + strlen(entry), "xv 216 yv %d picn sbfctf3 ",
					42 + i * 8);
			if (cl_ent->client->pers.inventory[ITEM_INDEX(flag4_item)])
				sprintf(entry + strlen(entry), "xv 216 yv %d picn sbfctf4 ",
					42 + i * 8);

#endif
			if (maxsize - len > strlen(entry)) {
				strcat(string, entry);
				len = strlen(string);
				last[1] = i;
			}
		}
		// right lower side (White Team)
		if (i < total[3]) {
			cl = &game.clients[sorted[3][i]];
			cl_ent = g_edicts + 1 + sorted[3][i];

#if 0 //ndef NEW_SCORE
			sprintf(entry+strlen(entry),
			"xv 160 %s \"%3d %3d %-12.12s\" ",
			(cl_ent == ent) ? "string2" : "string",
			cl->resp.score, 
			(cl->ping > 999) ? 999 : cl->ping, 
			cl->pers.netname);

			if (cl_ent->client->pers.inventory[ITEM_INDEX(flag1_item)])
				strcat(entry, "xv 216 picn sbfctf1 ");
			if (cl_ent->client->pers.inventory[ITEM_INDEX(flag2_item)])
				strcat(entry, "xv 216 picn sbfctf2 ");
			if (cl_ent->client->pers.inventory[ITEM_INDEX(flag3_item)])
				strcat(entry, "xv 216 picn sbfctf3 ");

#else

			sprintf(entry+strlen(entry),
				"ctf 160 %d %d %d %d ",
				160 + i * 8,
				sorted[3][i],
				cl->resp.score,
				cl->ping > 999 ? 999 : cl->ping);

			if (cl_ent->client->pers.inventory[ITEM_INDEX(flag1_item)])
				sprintf(entry + strlen(entry), "xv 216 yv %d picn sbfctf1 ",
					160 + i * 8);
			if (cl_ent->client->pers.inventory[ITEM_INDEX(flag2_item)])
				sprintf(entry + strlen(entry), "xv 216 yv %d picn sbfctf2 ",
					160 + i * 8);
			if (cl_ent->client->pers.inventory[ITEM_INDEX(flag3_item)])
				sprintf(entry + strlen(entry), "xv 216 yv %d picn sbfctf3 ",
					160 + i * 8);

#endif
			if (maxsize - len > strlen(entry)) {
				strcat(string, entry);
				len = strlen(string);
				last[3] = i;
			}
		}
	}

	// put in spectators if we have enough room
    // Spectators is too cramped with the scoreboard style.
/*	if (last[0] > last[1])
		j = last[0];
	else
		j = last[1];
	j = (j + 2) * 8 + 42;

	k = n = 0;
	if (maxsize - len > 50) {
		for (i = 0; i < maxclients->value; i++) {
			cl_ent = g_edicts + 1 + i;
			cl = &game.clients[i];
			if (!cl_ent->inuse ||
				cl_ent->solid != SOLID_NOT ||
				cl_ent->client->resp.ctf_team != CTF_NOTEAM)
				continue;

			if (!k) {
				k = 1;
				sprintf(entry, "xv 0 yv %d string2 \"Spectators\" ", j);
				strcat(string, entry);
				len = strlen(string);
				j += 8;
			}

			sprintf(entry+strlen(entry),
				"ctf %d %d %d %d %d ",
				(n & 1) ? 160 : 0, // x
				j, // y
				i, // playernum
				cl->resp.score,
				cl->ping > 999 ? 999 : cl->ping);
			if (maxsize - len > strlen(entry)) {
				strcat(string, entry);
				len = strlen(string);
			}
			
			if (n & 1)
				j += 8;
			n++;
		}
	}
*/
/*	if (total[0] - last[0] > 1) // couldn't fit everyone
		sprintf(string + strlen(string), "xv 8 yv %d string \"..and %d more\" ",
			42 + (last[0]+1)*8, total[0] - last[0] - 1);
	if (total[1] - last[1] > 1) // couldn't fit everyone
		sprintf(string + strlen(string), "xv 168 yv %d string \"..and %d more\" ",
			42 + (last[1]+1)*8, total[1] - last[1] - 1);
	if (total[2] - last[2] > 1) // couldn't fit everyone
		sprintf(string + strlen(string), "xv 168 yv %d string \"..and %d more\" ",
			84 + (last[2]+1)*8, total[2] - last[2] - 1);
	if (total[3] - last[3] > 1) // couldn't fit everyone
		sprintf(string + strlen(string), "xv 168 yv %d string \"..and %d more\" ",
			84 + (last[3]+1)*8, total[3] - last[3] - 1);
*/

	gi.WriteByte (svc_layout);
	gi.WriteString (string);
}


/*------------------------------------------------------------------------*/
/* TECH																	  */
/*------------------------------------------------------------------------*/

void CTFHasTech(edict_t *who)
{
	if (level.time - who->client->ctf_lasttechmsg > 2) {
		gi.centerprintf(who, "You already have a TECH powerup.");
		who->client->ctf_lasttechmsg = level.time;
	}
}

gitem_t *CTFWhat_Tech(edict_t *ent)
{
	gitem_t *tech;
	int i;

	i = 0;
	while (tnames[i]) {
		if ((tech = FindItemByClassname(tnames[i])) != NULL &&
			ent->client->pers.inventory[ITEM_INDEX(tech)]) {
			return tech;
		}
		i++;
	}
	return NULL;
}

gitem_t *CTFWhat_Flag(edict_t *ent)
{
	if (flag_drop->value)
	{
		if (ent->client->pers.inventory[ITEM_INDEX(flag1_item)])
			return flag1_item;
		else if (ent->client->pers.inventory[ITEM_INDEX(flag2_item)])
			return flag2_item;
		else if (ent->client->pers.inventory[ITEM_INDEX(flag3_item)])
			return flag3_item;
		else if (ent->client->pers.inventory[ITEM_INDEX(flag4_item)])
			return flag4_item;
	}
	return NULL;
}

qboolean CTFPickup_Tech (edict_t *ent, edict_t *other)
{
	gitem_t *tech;
	int i;

	if (competition->value && matchtimer)
		return false;

	i = 0;
	while (tnames[i]) {
		if ((tech = FindItemByClassname(tnames[i])) != NULL &&
			other->client->pers.inventory[ITEM_INDEX(tech)]) {
			CTFHasTech(other);
			return false; // has this one
		}
		i++;
	}
	
	// client only gets one tech
	other->client->pers.inventory[ITEM_INDEX(ent->item)]++;
	other->client->ctf_regentime = level.time;
	return true;
}

static void SpawnTech(gitem_t *item, edict_t *spot);

static edict_t *FindTechSpawn(void)
{
	edict_t *spot = NULL;
	int i = rand() % 16;

	while (i--)
		spot = G_Find (spot, FOFS(classname), "info_player_deathmatch");
	if (!spot)
		spot = G_Find (spot, FOFS(classname), "info_player_deathmatch");
	return spot;
}

static void TechThink(edict_t *tech)
{
	edict_t *spot;

	if ((spot = FindTechSpawn()) != NULL) {
		SpawnTech(tech->item, spot);
		G_FreeEdict(tech);
	} else {
		tech->nextthink = level.time + CTF_TECH_TIMEOUT;
		tech->think = TechThink;
	}
}

void CTFDrop_Tech(edict_t *ent, gitem_t *item)
{
	edict_t *tech;

	tech = Drop_Item(ent, item);
	tech->nextthink = level.time + CTF_TECH_TIMEOUT;
	tech->think = TechThink;
	ent->client->pers.inventory[ITEM_INDEX(item)] = 0;
}

void CTFDeadDropTech(edict_t *ent)
{
	gitem_t *tech;
	edict_t *dropped;
	int i;

	i = 0;
	while (tnames[i]) {
		if ((tech = FindItemByClassname(tnames[i])) != NULL &&
			ent->client->pers.inventory[ITEM_INDEX(tech)]) {
			dropped = Drop_Item(ent, tech);
			// hack the velocity to make it bounce random
			dropped->velocity[0] = (rand() % 600) - 300;
			dropped->velocity[1] = (rand() % 600) - 300;
			dropped->nextthink = level.time + CTF_TECH_TIMEOUT;
			dropped->think = TechThink;
			dropped->owner = NULL;
			ent->client->pers.inventory[ITEM_INDEX(tech)] = 0;
		}
		i++;
	}
}

static void SpawnTech(gitem_t *item, edict_t *spot)
{
	edict_t	*ent;
	vec3_t	forward, right;
	vec3_t  angles;

	ent = G_Spawn();

	ent->classname = item->classname;
	ent->item = item;
	ent->spawnflags = DROPPED_ITEM;
	ent->s.effects = item->world_model_flags;
	ent->s.renderfx = RF_GLOW;
	VectorSet (ent->mins, -15, -15, -15);
	VectorSet (ent->maxs, 15, 15, 15);
	gi.setmodel (ent, ent->item->world_model);
	ent->solid = SOLID_TRIGGER;
	ent->movetype = MOVETYPE_TOSS;  
	ent->touch = Touch_Item;
	ent->owner = ent;

	angles[0] = 0;
	angles[1] = rand() % 360;
	angles[2] = 0;

	AngleVectors (angles, forward, right, NULL);
	VectorCopy (spot->s.origin, ent->s.origin);
	ent->s.origin[2] += 16;
	VectorScale (forward, 100, ent->velocity);
	ent->velocity[2] = 300;

	ent->nextthink = level.time + CTF_TECH_TIMEOUT;
	ent->think = TechThink;

	gi.linkentity (ent);
}

static void SpawnTechs(edict_t *ent)
{
	gitem_t *tech;
	edict_t *spot;
	int i;

	i = 0;
	while (tnames[i]) {
		if ((tech = FindItemByClassname(tnames[i])) != NULL &&
			(spot = FindTechSpawn()) != NULL)
			SpawnTech(tech, spot);
		i++;
	}
}

// frees the passed edict!
void CTFRespawnTech(edict_t *ent)
{
	edict_t *spot;

	if ((spot = FindTechSpawn()) != NULL)
		SpawnTech(ent->item, spot);
	G_FreeEdict(ent);
}

void CTFSetupTechSpawn(void)
{
	edict_t *ent;

	if (techspawn || ((int)dmflags->value & DF_CTF_NO_TECH))
		return;

	ent = G_Spawn();
	ent->nextthink = level.time + 2;
	ent->think = SpawnTechs;
	techspawn = true;
}

int CTFApplyVampire(edict_t *attacker, int dmg)
{
	static gitem_t *tech = NULL;
	float volume = 1.0;

	if (attacker->client && attacker->client->silencer_shots)
		volume = 0.2;

	if (!tech)
		tech = FindItemByClassname("item_tech7");
	if (dmg && tech && attacker->client && attacker->client->pers.inventory[ITEM_INDEX(tech)]) {
		// make noise
	   	gi.sound(attacker, CHAN_VOICE, gi.soundindex("ctf/tech7.wav"), volume, ATTN_NORM, 0);
		return dmg / 2;
	}
	return 0;
}

int CTFApplyResistance(edict_t *ent, int dmg)
{
	static gitem_t *tech = NULL;
	float volume = 1.0;

	if (ent->client && ent->client->silencer_shots)
		volume = 0.2;

	if (!tech)
		tech = FindItemByClassname("item_tech1");
	if (dmg && tech && ent->client && ent->client->pers.inventory[ITEM_INDEX(tech)]) {
		// make noise
	   	gi.sound(ent, CHAN_VOICE, gi.soundindex("ctf/tech1.wav"), volume, ATTN_NORM, 0);
		return dmg / 2;
	}
	return dmg;
}

int CTFApplyStrength(edict_t *ent, int dmg)
{
	static gitem_t *tech = NULL;

	if (!tech)
		tech = FindItemByClassname("item_tech2");
	if (dmg && tech && ent->client && ent->client->pers.inventory[ITEM_INDEX(tech)]) {
		return dmg * 2;
	}
	return dmg;
}

qboolean CTFApplyStrengthSound(edict_t *ent)
{
	static gitem_t *tech = NULL;
	float volume = 1.0;

	if (ent->client && ent->client->silencer_shots)
		volume = 0.2;

	if (!tech)
		tech = FindItemByClassname("item_tech2");
	if (tech && ent->client &&
		ent->client->pers.inventory[ITEM_INDEX(tech)]) {
		if (ent->client->ctf_techsndtime < level.time) {
			ent->client->ctf_techsndtime = level.time + 1;
			if (ent->client->quad_framenum > level.framenum)
				gi.sound(ent, CHAN_VOICE, gi.soundindex("ctf/tech2x.wav"), volume, ATTN_NORM, 0);
			else
				gi.sound(ent, CHAN_VOICE, gi.soundindex("ctf/tech2.wav"), volume, ATTN_NORM, 0);
		}
		return true;
	}
	return false;
}


qboolean CTFApplyHaste(edict_t *ent)
{
	static gitem_t *tech = NULL;

	if (!tech)
		tech = FindItemByClassname("item_tech3");
	if (tech && ent->client &&
		ent->client->pers.inventory[ITEM_INDEX(tech)])
		return true;
	return false;
}

void CTFApplyHasteSound(edict_t *ent)
{
	static gitem_t *tech = NULL;
	float volume = 1.0;

	if (ent->client && ent->client->silencer_shots)
		volume = 0.2;

	if (!tech)
		tech = FindItemByClassname("item_tech3");
	if (tech && ent->client &&
		ent->client->pers.inventory[ITEM_INDEX(tech)] &&
		ent->client->ctf_techsndtime < level.time) {
		ent->client->ctf_techsndtime = level.time + 1;
		gi.sound(ent, CHAN_VOICE, gi.soundindex("ctf/tech3.wav"), volume, ATTN_NORM, 0);
	}
}

void CTFApplyRegeneration(edict_t *ent)
{
	static gitem_t *tech = NULL;
	qboolean noise = false;
	gclient_t *client;
//	int index;
	float volume = 1.0;

	client = ent->client;
	if (!client)
		return;

	if (ent->client->silencer_shots)
		volume = 0.2;

	if (!tech)
		tech = FindItemByClassname("item_tech4");
	if (tech && client->pers.inventory[ITEM_INDEX(tech)]) {
		if (client->ctf_regentime < level.time) {
			client->ctf_regentime = level.time;
			if (ent->health < 200) {
				ent->health += 5;
				if (ent->health > 200)
					ent->health = 200;
				client->ctf_regentime += 0.5;
				noise = true;
			}
/*			index = ArmorIndex (ent);
			if (index && client->pers.inventory[index] < 150) {
				client->pers.inventory[index] += 5;
				if (client->pers.inventory[index] > 150)
					client->pers.inventory[index] = 150;
				client->ctf_regentime += 0.5;
				noise = true;
			}
*/		}
		if (noise && ent->client->ctf_techsndtime < level.time) {
			ent->client->ctf_techsndtime = level.time + 1;
			gi.sound(ent, CHAN_VOICE, gi.soundindex("ctf/tech4.wav"), volume, ATTN_NORM, 0);
		}
	}
}

qboolean CTFHasRegeneration(edict_t *ent)
{
	static gitem_t *tech = NULL;

	if (!tech)
		tech = FindItemByClassname("item_tech4");
	if (tech && ent->client &&
		ent->client->pers.inventory[ITEM_INDEX(tech)])
		return true;
	return false;
}

qboolean CTFHasSuperGrapple(edict_t *ent)
{
	static gitem_t *tech = NULL;

	if (!tech)
		tech = FindItemByClassname("item_tech6");
	if (tech && ent->client &&
		ent->client->pers.inventory[ITEM_INDEX(tech)])
		return true;
	return false;
}


//ACHILLES - New Tech Code
void CTFApplyArmorGen(edict_t *ent)
{
	static gitem_t *tech = NULL;
	qboolean noise = false;
	gclient_t *client;
	int index;
	float volume = 1.0;

	client = ent->client;
	if (!client)
		return;

	if (ent->client->silencer_shots)
		volume = 0.2;

	if (!tech)
		tech = FindItemByClassname("item_tech5");
	if (tech && client->pers.inventory[ITEM_INDEX(tech)]) {
		if (client->ctf_argentime < level.time) {
			client->ctf_argentime = level.time;
			index = ArmorIndex (ent);
			if (index && client->pers.inventory[index] < 200) {
				client->pers.inventory[index] += 5;
				if (client->pers.inventory[index] > 200)
					client->pers.inventory[index] = 200;
				client->ctf_argentime += 0.5;
				noise = true;
			}
		}
		if (noise && ent->client->ctf_techsndtime < level.time) {
			ent->client->ctf_techsndtime = level.time + 1;
			gi.sound(ent, CHAN_VOICE, gi.soundindex("ctf/tech5.wav"), volume, ATTN_NORM, 0);
		}
	}

}

void CTFApplyCommando(edict_t *ent)
{
	static gitem_t *tech = NULL;
	gclient_t *client;
	float volume = 1.0;

	client = ent->client;
	if (!client)
		return;

	if (ent->client->silencer_shots)
		volume = 0.2;

	if (!tech)
		tech = FindItemByClassname("item_tech8");
	if (tech && client->pers.inventory[ITEM_INDEX(tech)]) {
		if (client->ctf_commtime < level.time) {
			client->ctf_commtime = level.time;
			if (Q_stricmp(ent->client->pers.weapon->pickup_name, "Shotgun") == 0 || Q_stricmp(ent->client->pers.weapon->pickup_name, "Super Shotgun") == 0) {
				if (client->pers.inventory[ITEM_INDEX(FindItem("shells"))] < client->pers.max_shells)
					client->pers.inventory[ITEM_INDEX(FindItem("shells"))] += 1;
				if (client->pers.inventory[ITEM_INDEX(FindItem("shells"))] > client->pers.max_shells)
					client->pers.inventory[ITEM_INDEX(FindItem("shells"))] = client->pers.max_shells;
				client->ctf_commtime += 0.9;
			} else if (Q_stricmp(ent->client->pers.weapon->pickup_name, "Machinegun") == 0 || Q_stricmp(ent->client->pers.weapon->pickup_name, "Chaingun") == 0) {
				if (client->pers.inventory[ITEM_INDEX(FindItem("bullets"))] < client->pers.max_bullets)
					client->pers.inventory[ITEM_INDEX(FindItem("bullets"))] += 1;
				if (client->pers.inventory[ITEM_INDEX(FindItem("bullets"))] > client->pers.max_bullets)
					client->pers.inventory[ITEM_INDEX(FindItem("bullets"))] = client->pers.max_bullets;
				client->ctf_commtime += 0.9;
			} else if (Q_stricmp(ent->client->pers.weapon->pickup_name, "HyperBlaster") == 0 || Q_stricmp(ent->client->pers.weapon->pickup_name, "BFG10K") == 0) {
				if (client->pers.inventory[ITEM_INDEX(FindItem("cells"))] < client->pers.max_cells)
					client->pers.inventory[ITEM_INDEX(FindItem("cells"))] += 1;
				if (client->pers.inventory[ITEM_INDEX(FindItem("cells"))] > client->pers.max_cells)
					client->pers.inventory[ITEM_INDEX(FindItem("cells"))] = client->pers.max_cells;
				client->ctf_commtime += 0.9;
			} else if (Q_stricmp(ent->client->pers.weapon->pickup_name, "Railgun") == 0) {
				if (client->pers.inventory[ITEM_INDEX(FindItem("slugs"))] < client->pers.max_slugs)
					client->pers.inventory[ITEM_INDEX(FindItem("slugs"))] += 1;
				if (client->pers.inventory[ITEM_INDEX(FindItem("slugs"))] > client->pers.max_slugs)
					client->pers.inventory[ITEM_INDEX(FindItem("slugs"))] = client->pers.max_slugs;
				client->ctf_commtime += 0.9;
			} else if (Q_stricmp(ent->client->pers.weapon->pickup_name, "Rocket Launcher") == 0) {
				if (client->pers.inventory[ITEM_INDEX(FindItem("rockets"))] < client->pers.max_rockets)
					client->pers.inventory[ITEM_INDEX(FindItem("rockets"))] += 1;
				if (client->pers.inventory[ITEM_INDEX(FindItem("rockets"))] > client->pers.max_rockets)
					client->pers.inventory[ITEM_INDEX(FindItem("rockets"))] = client->pers.max_rockets;
				client->ctf_commtime += 0.9;
			} else if (Q_stricmp(ent->client->pers.weapon->pickup_name, "Grenade Launcher") == 0 || Q_stricmp(ent->client->pers.weapon->pickup_name, "Grenades") == 0) {
				if (client->pers.inventory[ITEM_INDEX(FindItem("grenades"))] < client->pers.max_grenades)
					client->pers.inventory[ITEM_INDEX(FindItem("grenades"))] += 1;
				if (client->pers.inventory[ITEM_INDEX(FindItem("grenades"))] > client->pers.max_grenades)
					client->pers.inventory[ITEM_INDEX(FindItem("grenades"))] = client->pers.max_grenades;
				client->ctf_commtime += 0.9;
			} else {
				return;
			}


		}
	}

}


/*
======================================================================

SAY_TEAM

======================================================================
*/

// This array is in 'importance order', it indicates what items are
// more important when reporting their names.
struct {
	char *classname;
	int priority;
} loc_names[] = 
{
	{	"item_flag_team1",			1 },
	{	"item_flag_team2",			1 },
	{	"item_flag_team3",			1 },
	{	"item_flag_team4",			1 },
	{	"item_quad",				2 }, 
	{	"item_invulnerability",		2 },
	{	"weapon_bfg",				3 },
	{	"weapon_railgun",			4 },
	{	"weapon_rocketlauncher",	4 },
	{	"weapon_hyperblaster",		4 },
	{	"weapon_chaingun",			4 },
	{	"weapon_grenadelauncher",	4 },
	{	"weapon_machinegun",		4 },
	{	"weapon_supershotgun",		4 },
	{	"weapon_shotgun",			4 },
	{	"item_power_screen",		5 },
	{	"item_power_shield",		5 },
	{	"item_armor_body",			6 },
	{	"item_armor_combat",		6 },
	{	"item_armor_jacket",		6 },
	{	"item_silencer",			7 },
	{	"item_breather",			7 },
	{	"item_enviro",				7 },
	{	"item_adrenaline",			7 },
	{	"item_bandolier",			8 },
	{	"item_pack",				8 },
	{ NULL, 0 }
};


static void CTFSay_Team_Location(edict_t *who, char *buf)
{
	edict_t *what = NULL;
	edict_t *hot = NULL;
	float hotdist = 999999, newdist;
	vec3_t v;
	int hotindex = 999;
	int i;
	gitem_t *item;
	int nearteam = -1;
	edict_t *flag1, *flag2;
	qboolean hotsee = false;
	qboolean cansee;

	while ((what = loc_findradius(what, who->s.origin, 1024)) != NULL) {
		// find what in loc_classnames
		for (i = 0; loc_names[i].classname; i++)
			if (strcmp(what->classname, loc_names[i].classname) == 0)
				break;
		if (!loc_names[i].classname)
			continue;
		// something we can see get priority over something we can't
		cansee = loc_CanSee(what, who);
		if (cansee && !hotsee) {
			hotsee = true;
			hotindex = loc_names[i].priority;
			hot = what;
			VectorSubtract(what->s.origin, who->s.origin, v);
			hotdist = VectorLength(v);
			continue;
		}
		// if we can't see this, but we have something we can see, skip it
		if (hotsee && !cansee)
			continue;
		if (hotsee && hotindex < loc_names[i].priority)
			continue;
		VectorSubtract(what->s.origin, who->s.origin, v);
		newdist = VectorLength(v);
		if (newdist < hotdist || 
			(cansee && loc_names[i].priority < hotindex)) {
			hot = what;
			hotdist = newdist;
			hotindex = i;
			hotsee = loc_CanSee(hot, who);
		}
	}

	if (!hot) {
		strcpy(buf, "nowhere");
		return;
	}

	// we now have the closest item
	// see if there's more than one in the map, if so
	// we need to determine what team is closest
	what = NULL;
	while ((what = G_Find(what, FOFS(classname), hot->classname)) != NULL) {
		if (what == hot)
			continue;
		// if we are here, there is more than one, find out if hot
		// is closer to red flag or blue flag
		if ((flag1 = G_Find(NULL, FOFS(classname), "item_flag_team1")) != NULL &&
			(flag2 = G_Find(NULL, FOFS(classname), "item_flag_team2")) != NULL) {
			VectorSubtract(hot->s.origin, flag1->s.origin, v);
			hotdist = VectorLength(v);
			VectorSubtract(hot->s.origin, flag2->s.origin, v);
			newdist = VectorLength(v);
			if (hotdist < newdist)
				nearteam = CTF_TEAM1;
			else if (hotdist > newdist)
				nearteam = CTF_TEAM2;
		}
		break;
	}

	if ((item = FindItemByClassname(hot->classname)) == NULL) {
		strcpy(buf, "nowhere");
		return;
	}

	// in water?
	if (who->waterlevel)
		strcpy(buf, "in the water ");
	else
		*buf = 0;

	// near or above
	VectorSubtract(who->s.origin, hot->s.origin, v);
	if (fabs(v[2]) > fabs(v[0]) && fabs(v[2]) > fabs(v[1]))
		if (v[2] > 0)
			strcat(buf, "above ");
		else
			strcat(buf, "below ");
	else
		strcat(buf, "near ");

	if (nearteam == CTF_TEAM1)
		strcat(buf, "the red ");
	else if (nearteam == CTF_TEAM2)
		strcat(buf, "the blue ");
	else
		strcat(buf, "the ");

	strcat(buf, item->pickup_name);
}

static void CTFSay_Team_Armor(edict_t *who, char *buf)
{
	gitem_t		*item;
	int			index, cells;
	int			power_armor_type;

	*buf = 0;

	power_armor_type = PowerArmorType (who);
	if (power_armor_type)
	{
		cells = who->client->pers.inventory[ITEM_INDEX(FindItem ("cells"))];
		if (cells)
			sprintf(buf+strlen(buf), "%s with %i cells ",
				(power_armor_type == POWER_ARMOR_SCREEN) ?
				"Power Screen" : "Power Shield", cells);
	}

	index = ArmorIndex (who);
	if (index)
	{
		item = GetItemByIndex (index);
		if (item) {
			if (*buf)
				strcat(buf, "and ");
			sprintf(buf+strlen(buf), "%i units of %s",
				who->client->pers.inventory[index], item->pickup_name);
		}
	}

	if (!*buf)
		strcpy(buf, "no armor");
}

static void CTFSay_Team_Health(edict_t *who, char *buf)
{
	if (who->health <= 0)
		strcpy(buf, "dead");
	else
		sprintf(buf, "%i health", who->health);
}

static void CTFSay_Team_Tech(edict_t *who, char *buf)
{
	gitem_t *tech;
	int i;

	// see if the player has a tech powerup
	i = 0;
	while (tnames[i]) {
		if ((tech = FindItemByClassname(tnames[i])) != NULL &&
			who->client->pers.inventory[ITEM_INDEX(tech)]) {
			sprintf(buf, "the %s", tech->pickup_name);
			return;
		}
		i++;
	}
	strcpy(buf, "no powerup");
}

static void CTFSay_Team_Weapon(edict_t *who, char *buf)
{
	if (who->client->pers.weapon)
		strcpy(buf, who->client->pers.weapon->pickup_name);
	else
		strcpy(buf, "none");
}

static void CTFSay_Team_Sight(edict_t *who, char *buf)
{
	int i;
	edict_t *targ;
	int n = 0;
	char s[1024];
	char s2[1024];

	*s = *s2 = 0;
	for (i = 1; i <= maxclients->value; i++) {
		targ = g_edicts + i;
		if (!targ->inuse || 
			targ == who ||
			!loc_CanSee(targ, who))
			continue;
		if (*s2) {
			if (strlen(s) + strlen(s2) + 3 < sizeof(s)) {
				if (n)
					strcat(s, ", ");
				strcat(s, s2);
				*s2 = 0;
			}
			n++;
		}
		strcpy(s2, targ->client->pers.netname);
	}
	if (*s2) {
		if (strlen(s) + strlen(s2) + 6 < sizeof(s)) {
			if (n)
				strcat(s, " and ");
			strcat(s, s2);
		}
		strcpy(buf, s);
	} else
		strcpy(buf, "no one");
}

void CTFSay_Team(edict_t *who, char *msg)
{
	char outmsg[1024];
	char buf[1024];
	int i;
	char *p;
	edict_t *cl_ent;

	outmsg[0] = 0;

	if (*msg == '\"') {
		msg[strlen(msg) - 1] = 0;
		msg++;
	}

	for (p = outmsg; *msg && (p - outmsg) < sizeof(outmsg) - 1; msg++) {
		if (*msg == '%') {
			switch (*++msg) {
				case 'l' :
				case 'L' :
					CTFSay_Team_Location(who, buf);
					strcpy(p, buf);
					p += strlen(buf);
					break;
				case 'a' :
				case 'A' :
					CTFSay_Team_Armor(who, buf);
					strcpy(p, buf);
					p += strlen(buf);
					break;
				case 'h' :
				case 'H' :
					CTFSay_Team_Health(who, buf);
					strcpy(p, buf);
					p += strlen(buf);
					break;
				case 't' :
				case 'T' :
					CTFSay_Team_Tech(who, buf);
					strcpy(p, buf);
					p += strlen(buf);
					break;
				case 'w' :
				case 'W' :
					CTFSay_Team_Weapon(who, buf);
					strcpy(p, buf);
					p += strlen(buf);
					break;

				case 'n' :
				case 'N' :
					CTFSay_Team_Sight(who, buf);
					strcpy(p, buf);
					p += strlen(buf);
					break;

				default :
					*p++ = *msg;
			}
		} else
			*p++ = *msg;
	}
	*p = 0;

	if ( strlen(outmsg) > 150)       // new line added
      outmsg[150] = 0;              // new line added

	for (i = 0; i < maxclients->value; i++) {
		cl_ent = g_edicts + 1 + i;
		if (!cl_ent->inuse)
			continue;
		if (cl_ent->client->resp.ctf_team == who->client->resp.ctf_team)
			gi.cprintf(cl_ent, PRINT_CHAT, "(%s): %s\n", 
				who->client->pers.netname, outmsg);
	}
}


/*-----------------------------------------------------------------------*/
/*QUAKED misc_ctf_banner (1 .5 0) (-4 -64 0) (4 64 248) TEAM2
The origin is the bottom of the banner.
The banner is 248 tall.
*/
static void misc_ctf_banner_think (edict_t *ent)
{
	ent->s.frame = (ent->s.frame + 1) % 16;
	ent->nextthink = level.time + FRAMETIME;
}

void SP_misc_ctf_banner (edict_t *ent)
{
	ent->movetype = MOVETYPE_NONE;
	ent->solid = SOLID_NOT;
	ent->s.modelindex = gi.modelindex ("models/ctf/banner/tris.md2");
	if (ent->spawnflags & 1) // team2
		ent->s.skinnum = 1;
	else if (ent->spawnflags & 2) // team3
		ent->s.skinnum = 2;
	else if (ent->spawnflags & 4) // team 4
		ent->s.skinnum = 3;

	ent->s.frame = rand() % 16;
	gi.linkentity (ent);

	ent->think = misc_ctf_banner_think;
	ent->nextthink = level.time + FRAMETIME;
}

/*QUAKED misc_ctf_small_banner (1 .5 0) (-4 -32 0) (4 32 124) TEAM2
The origin is the bottom of the banner.
The banner is 124 tall.
*/
void SP_misc_ctf_small_banner (edict_t *ent)
{
	ent->movetype = MOVETYPE_NONE;
	ent->solid = SOLID_NOT;
	ent->s.modelindex = gi.modelindex ("models/ctf/banner/small.md2");
	if (ent->spawnflags & 1) // team2
		ent->s.skinnum = 1;
	else if (ent->spawnflags & 2) // team3
		ent->s.skinnum = 2;
	else if (ent->spawnflags & 4) // team 4
		ent->s.skinnum = 3;

	ent->s.frame = rand() % 16;
	gi.linkentity (ent);

	ent->think = misc_ctf_banner_think;
	ent->nextthink = level.time + FRAMETIME;
}


/*-----------------------------------------------------------------------*/

void CTFJoinTeam(edict_t *ent, int desired_team)
{
	char *s;

	PMenu_Close(ent);

	if (matchtimer || !competition->value)
	{
		ent->client->resp.ctf_team = desired_team;
		ent->client->resp.ctf_state = CTF_STATE_START;
		s = Info_ValueForKey (ent->client->pers.userinfo, "skin");
		CTFAssignSkin(ent, s);
	}

	if (!competition->value)
	{
		ent->flags &= ~FL_GODMODE;
		PutClientInServer (ent);
		// add a teleportation effect
		ent->s.event = EV_PLAYER_TELEPORT;
		// hold in place briefly
		ent->client->ps.pmove.pm_flags = PMF_TIME_TELEPORT;
		ent->client->ps.pmove.pm_time = 14;
		ent->svflags &= ~SVF_NOCLIENT;
		gi.bprintf(PRINT_HIGH, "%s joined the %s team.\n",
		ent->client->pers.netname, CTFTeamName(desired_team));
	}
}

void CTFJoinTeam1(edict_t *ent, pmenu_t *p)
{
	CTFJoinTeam(ent, CTF_TEAM1);
}

void CTFJoinTeam2(edict_t *ent, pmenu_t *p)
{
	CTFJoinTeam(ent, CTF_TEAM2);
}

void CTFJoinTeam3(edict_t *ent, pmenu_t *p)
{
	CTFJoinTeam(ent, CTF_TEAM3);
}

void CTFJoinTeam4(edict_t *ent, pmenu_t *p)
{
	CTFJoinTeam(ent, CTF_TEAM4);
}

void CTFChaseCam(edict_t *ent, pmenu_t *p)
{
	int i;
	edict_t *e;

	if (ent->client->chase_target) {
		ent->client->chase_target = NULL;
		PMenu_Close(ent);
		return;
	}

	for (i = 1; i <= maxclients->value; i++) {
		e = g_edicts + i;
		if (e->inuse && e->solid != SOLID_NOT) {
			ent->client->chase_target = e;
			PMenu_Close(ent);
			ent->client->update_chase = true;
			break;
		}
	}
}

void CTFReturnToMain(edict_t *ent, pmenu_t *p)
{
	PMenu_Close(ent);
	CTFOpenJoinMenu(ent);
}

void CTFCredits(edict_t *ent, pmenu_t *p);

void DeathmatchScoreboard (edict_t *ent);

void CTFShowScores(edict_t *ent, pmenu_t *p)
{
	PMenu_Close(ent);

	ent->client->showscores = true;
	ent->client->showinventory = false;
	DeathmatchScoreboard (ent);
}

pmenu_t creditsmenu[] = {
	{ "*Quake II",						PMENU_ALIGN_CENTER, NULL, NULL },
	{ "*4-Team Capture the Flag",		PMENU_ALIGN_CENTER, NULL, NULL },
	{ NULL,								PMENU_ALIGN_CENTER, NULL, NULL },
	{ "*Programming",					PMENU_ALIGN_CENTER, NULL, NULL }, 
	{ "Charles Mabbott ",				PMENU_ALIGN_CENTER, NULL, NULL },
	{ "*Additional Programning",		PMENU_ALIGN_CENTER, NULL, NULL },
	{ "Bob Timpko, Kai Kenner",			PMENU_ALIGN_CENTER, NULL, NULL },
	{ "Avi Rozen, Nathan O'Sullivan",	PMENU_ALIGN_CENTER, NULL, NULL },
	{ "The Code Exchange and Qdevels",	PMENU_ALIGN_CENTER, NULL, NULL },
	{ "*Skins",							PMENU_ALIGN_CENTER, NULL, NULL },
	{ "Patrick Curry, Rowan Crawford",	PMENU_ALIGN_CENTER, NULL, NULL },
	{ "*Sound",							PMENU_ALIGN_CENTER, NULL, NULL },
	{ "Arden Gaitlen Andrews",	 		PMENU_ALIGN_CENTER, NULL, NULL },
	{ "Michael Brown, John Herring",	PMENU_ALIGN_CENTER, NULL, NULL },
	{ "Edward Mattie, Allen VanMeter",	PMENU_ALIGN_CENTER, NULL, NULL },
	{ "Special Thanks to Dave Kirsh",	PMENU_ALIGN_CENTER, NULL, NULL },
	{ NULL,								PMENU_ALIGN_CENTER, NULL, NULL },
	{ "Return to Main Menu",			PMENU_ALIGN_LEFT, NULL, CTFReturnToMain }
};


pmenu_t joinmenu[] = {
	{ "*Quake II",			PMENU_ALIGN_CENTER, NULL, NULL },
	{ "*4-Team Capture the Flag",	PMENU_ALIGN_CENTER, NULL, NULL },
	{ NULL,					PMENU_ALIGN_CENTER, NULL, NULL },
	{ NULL,					PMENU_ALIGN_CENTER, NULL, NULL },
	{ "Join Red Team",		PMENU_ALIGN_LEFT, NULL, CTFJoinTeam1 },
	{ NULL,					PMENU_ALIGN_LEFT, NULL, NULL },
	{ "Join Blue Team",		PMENU_ALIGN_LEFT, NULL, CTFJoinTeam2 },
	{ NULL,					PMENU_ALIGN_LEFT, NULL, NULL },
	{ "Join Green Team",		PMENU_ALIGN_LEFT, NULL, CTFJoinTeam3 },
	{ NULL,					PMENU_ALIGN_LEFT, NULL, NULL },
	{ "Join White Team",		PMENU_ALIGN_LEFT, NULL, CTFJoinTeam4 },
	{ NULL,					PMENU_ALIGN_LEFT, NULL, NULL },
	{ NULL,					PMENU_ALIGN_LEFT, NULL, NULL },
	{ "Credits",			PMENU_ALIGN_LEFT, NULL, CTFCredits },
	{ NULL,					PMENU_ALIGN_LEFT, NULL, NULL },
	{ "v" CTF_STRING_VERSION,	PMENU_ALIGN_RIGHT, NULL, NULL },
};

int CTFUpdateJoinMenu(edict_t *ent)
{
	static char levelname[32];
	static char team1players[32];
	static char team2players[32];
	static char team3players[32];
	static char team4players[32];
	int num1, num2, num3, num4, i;
	int highteam;
	int count[ 5 ];

	joinmenu[4].text = "Join Red Team";
	joinmenu[4].SelectFunc = CTFJoinTeam1;
	joinmenu[6].text = "Join Blue Team";
	joinmenu[6].SelectFunc = CTFJoinTeam2;
	joinmenu[8].text = "Join Green Team";
	joinmenu[8].SelectFunc = CTFJoinTeam3;
	joinmenu[10].text = "Join White Team";
	joinmenu[10].SelectFunc = CTFJoinTeam4;

	if (ctf_forcejoin->string && *ctf_forcejoin->string) {
		if (Q_stricmp(ctf_forcejoin->string, "red") == 0) {
			joinmenu[6].text = NULL;
			joinmenu[6].SelectFunc = NULL;
			joinmenu[8].text = NULL;
			joinmenu[8].SelectFunc = NULL;
			joinmenu[10].text = NULL;
			joinmenu[10].SelectFunc = NULL;
		} else if (Q_stricmp(ctf_forcejoin->string, "blue") == 0) {
			joinmenu[4].text = NULL;
			joinmenu[4].SelectFunc = NULL;
			joinmenu[8].text = NULL;
			joinmenu[8].SelectFunc = NULL;
			joinmenu[10].text = NULL;
			joinmenu[10].SelectFunc = NULL;
		} else if (Q_stricmp(ctf_forcejoin->string, "green") == 0) {
			joinmenu[4].text = NULL;
			joinmenu[4].SelectFunc = NULL;
			joinmenu[6].text = NULL;
			joinmenu[6].SelectFunc = NULL;
			joinmenu[10].text = NULL;
			joinmenu[10].SelectFunc = NULL;
		} else if (Q_stricmp(ctf_forcejoin->string, "white") == 0) {
			joinmenu[4].text = NULL;
			joinmenu[4].SelectFunc = NULL;
			joinmenu[6].text = NULL;
			joinmenu[6].SelectFunc = NULL;
			joinmenu[8].text = NULL;
			joinmenu[8].SelectFunc = NULL;
		}
	}

	if (num_teams == 3)
	{
		joinmenu[10].text = NULL;
		joinmenu[10].SelectFunc = NULL;
	}
	if (num_teams == 2)
	{
		joinmenu[8].text = NULL;
		joinmenu[8].SelectFunc = NULL;
		joinmenu[10].text = NULL;
		joinmenu[10].SelectFunc = NULL;
    }
		joinmenu[12].text = NULL;

	levelname[0] = '*';
	if (g_edicts[0].message)
		strncpy(levelname+1, g_edicts[0].message, sizeof(levelname) - 2);
	else
		strncpy(levelname+1, level.mapname, sizeof(levelname) - 2);
	levelname[sizeof(levelname) - 1] = 0;

	num1 = num2 = num3 = num4 = 0;
	for (i = 0; i < maxclients->value; i++) {
		if (!g_edicts[i+1].inuse)
			continue;
		if (game.clients[i].resp.ctf_team == CTF_TEAM1)
			num1++;
		else if (game.clients[i].resp.ctf_team == CTF_TEAM2)
			num2++;
		else if (game.clients[i].resp.ctf_team == CTF_TEAM3)
			num3++;
		else if (game.clients[i].resp.ctf_team == CTF_TEAM4)
			num4++;

	}

	sprintf(team1players, "  (%d players)", num1);
	sprintf(team2players, "  (%d players)", num2);
	sprintf(team3players, "  (%d players)", num3);
	sprintf(team4players, "  (%d players)", num4);

	joinmenu[2].text = levelname;
	if (joinmenu[4].text)
		joinmenu[5].text = team1players;
	else
		joinmenu[5].text = NULL;
	if (joinmenu[6].text)
		joinmenu[7].text = team2players;
	else
		joinmenu[7].text = NULL;
	if (joinmenu[8].text)
		joinmenu[9].text = team3players;
	else
		joinmenu[9].text = NULL;
	if (joinmenu[10].text)
		joinmenu[11].text = team4players;
	else
		joinmenu[11].text = NULL;
	
/*	if (num1 > num2)
		return CTF_TEAM1;
	else if (num2 > num1)
		return CTF_TEAM1;
	return (rand() & 1) ? CTF_TEAM1 : CTF_TEAM2; 
*/
	highteam = CTF_TEAM1;

 for ( i = 2; i <= num_teams; i++ )
 { 
  if( count[ i ] > count[ highteam ] )
   highteam = i;
 }   
 return highteam;

}

void CTFOpenJoinMenu(edict_t *ent)
{
	int team;

	team = CTFUpdateJoinMenu(ent);
	if (ent->client->chase_target)
		team = 8;
	else if (team == CTF_TEAM1)
		team = 4;
	else if (team == CTF_TEAM2)
		team = 6;
	else if (team == CTF_TEAM3)
		team = 8;
	else
		team = 10;
	PMenu_Open(ent, joinmenu, team, sizeof(joinmenu) / sizeof(pmenu_t));
}

void CTFCredits(edict_t *ent, pmenu_t *p)
{
	PMenu_Close(ent);
	PMenu_Open(ent, creditsmenu, -1, sizeof(creditsmenu) / sizeof(pmenu_t));
}

qboolean CTFStartClient(edict_t *ent)
{
	if (ent->client->resp.ctf_team != CTF_NOTEAM)
		return false;

	if (!((int)dmflags->value & DF_CTF_FORCEJOIN)) {
		// start as 'observer'
		ent->client->pers.spectator = 1;
	if (!competition->value || matchtimer)
		CTFOpenJoinMenu(ent);
	}
	return false;
}

qboolean CTFCheckRules(void)
{
	if (capturelimit->value && 
		(ctfgame.team1 >= capturelimit->value ||
		 ctfgame.team2 >= capturelimit->value ||
		 ctfgame.team3 >= capturelimit->value ||
		 ctfgame.team4 >= capturelimit->value)) {
		gi.bprintf (PRINT_HIGH, "Capturelimit hit.\n");
		return true;
	}
	return false;
}

/*--------------------------------------------------------------------------
 * just here to help old map conversions
 *--------------------------------------------------------------------------*/

static void old_teleporter_touch (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	edict_t		*dest;
	int			i;
	vec3_t		forward;

	if (!other->client)
		return;
	dest = G_Find (NULL, FOFS(targetname), self->target);
	if (!dest)
	{
		gi.dprintf ("Couldn't find destination\n");
		return;
	}

//ZOID
	CTFPlayerResetGrapple(other);
//ZOID

	// unlink to make sure it can't possibly interfere with KillBox
	gi.unlinkentity (other);

	VectorCopy (dest->s.origin, other->s.origin);
	VectorCopy (dest->s.origin, other->s.old_origin);
//	other->s.origin[2] += 10;

	// clear the velocity and hold them in place briefly
	VectorClear (other->velocity);
	other->client->ps.pmove.pm_time = 160>>3;		// hold time
	other->client->ps.pmove.pm_flags |= PMF_TIME_TELEPORT;

	// draw the teleport splash at source and on the player
	self->enemy->s.event = EV_PLAYER_TELEPORT;
	other->s.event = EV_PLAYER_TELEPORT;

	// set angles
	for (i=0 ; i<3 ; i++)
		other->client->ps.pmove.delta_angles[i] = ANGLE2SHORT(dest->s.angles[i] - other->client->resp.cmd_angles[i]);

	other->s.angles[PITCH] = 0;
	other->s.angles[YAW] = dest->s.angles[YAW];
	other->s.angles[ROLL] = 0;
	VectorCopy (dest->s.angles, other->client->ps.viewangles);
	VectorCopy (dest->s.angles, other->client->v_angle);

	// give a little forward velocity
	AngleVectors (other->client->v_angle, forward, NULL, NULL);
	VectorScale(forward, 200, other->velocity);

	// kill anything at the destination
	if (!KillBox (other))
	{
	}

	gi.linkentity (other);
}

/*QUAKED trigger_teleport (0.5 0.5 0.5) ?
Players touching this will be teleported
*/
void SP_trigger_teleport (edict_t *ent)
{
	edict_t *s;
	int i;

	if (!ent->target)
	{
		gi.dprintf ("teleporter without a target.\n");
		G_FreeEdict (ent);
		return;
	}

	ent->svflags |= SVF_NOCLIENT;
	ent->solid = SOLID_TRIGGER;
	ent->touch = old_teleporter_touch;
	gi.setmodel (ent, ent->model);
	gi.linkentity (ent);

	// noise maker and splash effect dude
	s = G_Spawn();
	ent->enemy = s;
	for (i = 0; i < 3; i++)
		s->s.origin[i] = ent->mins[i] + (ent->maxs[i] - ent->mins[i])/2;
	s->s.sound = gi.soundindex ("world/hum1.wav");
	gi.linkentity(s);
	
}

/*QUAKED info_teleport_destination (0.5 0.5 0.5) (-16 -16 -24) (16 16 32)
Point trigger_teleports at these.
*/
void SP_info_teleport_destination (edict_t *ent)
{
	ent->s.origin[2] += 16;
}

void ScoreHolder_Cleanup(edict_t *self)
{
	gi.TagFree(self->target);
	G_FreeEdict(self);
}

void CTF_Disconnect(edict_t *ent)
{
	edict_t *sh;
	sh = G_Spawn();
	sh->classname = "score_holder";
	sh->count = ent->client->resp.score;
	sh->target = gi.TagMalloc(16, TAG_LEVEL);
	strcpy(sh->target, ent->client->pers.netname);
	sh->spawnflags = ent->client->resp.ctf_team;
	sh->think = ScoreHolder_Cleanup;
	sh->nextthink = level.time + 5 * 60;
}

qboolean CTF_Reconnect(edict_t *ent)
{
	edict_t *sh = NULL;
	while (sh = G_Find(sh, FOFS(classname), "score_holder"))
	{
		if (strcmp(sh->target, Info_ValueForKey(ent->client->pers.userinfo, "name")) == 0)
		{
			ent->client->resp.score = sh->count;
			ent->client->resp.ctf_team = sh->spawnflags;
			ScoreHolder_Cleanup(sh);
			return(true);
		}
	}
	return(false);
}