# include "g_local.h"



/*QUAKED info_player_team1 (1 0 0) (-16 -16 -24) (16 16 32)
Spawningpunkt fr CAPHOLD Team 1
*/
void SP_info_player_team1(edict_t *self)
{
}

/*QUAKED info_player_team2 (0 0 1) (-16 -16 -24) (16 16 32)
Spawningpunkt fr CAPHOLD Team 2
*/
void SP_info_player_team2(edict_t *self)
{
}


char *caphold_statusbar =

"yb	-24 " // 24 Pixel nach unten

// health
"xv	0 "	
"hnum "
"xv	50 "
"pic 0 "

// ammo
"if 2 "
"	xv	100 "
"	anum "
"	xv	150 "
"	pic 2 "
"endif "

// armor
"if 4 "
"	xv	200 "
"	rnum "
"	xv	250 "
"	pic 4 "
"endif "

// selected item
"if 6 "
"	xv	296 "
"	pic 6 "
"endif "

"yb	-50 "

// picked up item
"if 7 "
"	xv	0 "
"	pic 7 "
"	xv	26 "
"	yb	-42 "
"	stat_string 8 "
"	yb	-50 "
"endif "

// timer
"if 9 "
  "xv 246 "
  "num 2 10 "
  "xv 296 "
  "pic 9 "
"endif "

//  help / weapon icon 
"if 11 "
  "xv 148 "
  "pic 11 "
"endif "

//  frags
"xr -50 "
"yt  2 "
"num 3 14 "

// red team
"yb -102 "
"if 17 "
  "xr -45 "
  "pic 17 "
"endif "
"xr -19 "
"num 1 18 "

//joined Team
"if 22 "
  "yb -104 "
  "xr -47 "
  "pic 22 "
"endif "

// blue team
"yb -75 "
"if 19 "
"xr -45 "
"pic 19 "
"endif "
"xr -19 "
"num 1 20 "

// joined Team
"if 23 "
  "yb -77 "
  "xr -47 "
  "pic 23 "
"endif "

// id view state
"if 27 "
  "xv 0 "
  "yb -58 "
  "string \"Viewing\" "
  "xv 64 "
  "stat_string 27 "
"endif "

// Points Team 1 (Red Team)
"yb -102 "
"xr	-98 "
"num 3 28 "

// Points Team 2 (Blue Team)
"yb -75 "
"xr	-98 "
"num 3 29 "

// Classicon
// red team
"yb -30 "
"if 26 "
  "xr -30 "
  "pic 26 "
"endif "
;


// Misc Flag
void misc_flag_think (edict_t *ent)
{
	
	ent->s.frame = (ent->s.frame + 1) % 16;  
	ent->nextthink = level.time + FRAMETIME;
}


void SP_misc_flag (edict_t *ent)
{
	ent->movetype = MOVETYPE_STOP;
	ent->solid = SOLID_BBOX;
	ent->s.modelindex = gi.modelindex ("models/flags/flag.md2");
	ent->s.skinnum = 2;
	
	// ent->s.effects |= EF_FLAG1; Flagge enthlt effekt 

	ent->s.frame = rand() % 16;
	gi.linkentity (ent);

	ent->think = misc_flag_think;
	ent->nextthink = level.time + FRAMETIME;
}

// Misc Flag 

// Misc Banner
static void misc_ctf_banner_think (edict_t *ent)
{
	ent->s.frame = (ent->s.frame + 1) % 16;
	ent->nextthink = level.time + FRAMETIME;
}

void SP_misc_banner_big (edict_t *ent)
{
	ent->movetype = MOVETYPE_NONE;
	ent->solid = SOLID_NOT;
	ent->s.modelindex = gi.modelindex ("models/banner/big.md2");
	ent->s.skinnum = 2;

	ent->s.frame = rand() % 16;
	gi.linkentity (ent);

	ent->think = misc_ctf_banner_think;
	ent->nextthink = level.time + FRAMETIME;
}

/*QUAKED misc_ctf_small_banner (1 .5 0) (-4 -32 0) (4 32 124) TEAM2
The origin is the bottom of the banner.
The banner is 124 tall.
*/
void SP_misc_banner_small (edict_t *ent)
{
	ent->movetype = MOVETYPE_NONE;
	ent->solid = SOLID_NOT;
	ent->s.modelindex = gi.modelindex ("models/banner/small.md2");
	ent->s.skinnum = 2;

	ent->s.frame = rand() % 16;
	gi.linkentity (ent);

	ent->think = misc_ctf_banner_think;
	ent->nextthink = level.time + FRAMETIME;
}

// Misc Banner

// ************************************  MC Killer misc_tree Anfang

void misc_tree_think (edict_t *ent)
{
	
	ent->s.frame = (ent->s.frame + 1) % 1;
	ent->nextthink = level.time + FRAMETIME;
}

void SP_misc_tree (edict_t *ent)
{
	ent->movetype = MOVETYPE_STOP;
	ent->solid = SOLID_BBOX;
	ent->s.modelindex = gi.modelindex ("models/tree/tree.md2");
	ent->s.skinnum = 0;
		
	ent->s.frame = rand() % 1;
	gi.linkentity (ent);

	ent->think = misc_tree_think;
	ent->nextthink = level.time + FRAMETIME;
}

// ************************************  MC Killer misc_tree Ende


// ****Funktion um alle Flaggen mit dem gleichen Targetname zu finden (maximal 8)

edict_t *G_PickFlag (char *targetname) 
{
	edict_t	*ent = NULL;
	int		num_choices = 0;
	edict_t	*choice[MAXFLAGS];

	
	if (!targetname)
	{
		gi.dprintf("G_PickFlag called with NULL targetname\n");
		return NULL;
	}

	while(1)
	{
		ent = G_Find (ent, FOFS(targetname), targetname);
		if (!ent)
			break;
		choice[num_choices++] = ent;

		if (num_choices == MAXFLAGS)

			break;
	}

	if (!num_choices)
	{
		gi.dprintf("G_PickTarget: target %s not found\n", targetname);
		return NULL;
	}

	if (!num_choices)
	{
		gi.dprintf("G_PickFlag: target %s not found\n", targetname);
		return NULL;
	}

	return choice[num_choices];
}

void CHAssignSkin(edict_t *ent, char *s)
{

	int playernum = ent-g_edicts-1;
	char *p;
	char t[64];
		
	
// MC Killer

//	gi.dprintf("Skin : %s \n",s);
//	gi.dprintf("resp.ctf_team : %d \n",ent->client->resp.ctf_team);

	Com_sprintf(t, sizeof(t), "%s", s);
	if ((p = strrchr(t, '/')) != NULL)
		p[1] = 0;
	else
		strcpy(t, "male/");
// MC Killer
	switch (ent->client->resp.ctf_team)
	{
	case CH_TEAM1:
		if (ent->client->judas_active == 1) // Judas activiert ?!?
			gi.configstring (CS_PLAYERSKINS+playernum, va("%s\\%s%s", 
			ent->client->pers.netname, t, CH_TEAM2_SKIN) );
		else
			gi.configstring (CS_PLAYERSKINS+playernum, va("%s\\%s%s", 
			ent->client->pers.netname, t, CH_TEAM1_SKIN) );
		
		break;

	case CH_TEAM2:
		if (ent->client->judas_active == 1) // Judas activiert ?!?
			gi.configstring (CS_PLAYERSKINS+playernum, va("%s\\%s%s", 
			ent->client->pers.netname, t, CH_TEAM1_SKIN) );
		else
			gi.configstring (CS_PLAYERSKINS+playernum, va("%s\\%s%s", 
			ent->client->pers.netname, t, CH_TEAM2_SKIN) );
		
		break;

	default:
		gi.configstring (CS_PLAYERSKINS+playernum, 
			va("%s\\%s", ent->client->pers.netname, s) );

		break;
	}

}

void SetCHStats(edict_t *ent)
{

	ent->client->ps.stats[STAT_CAPHOLD_TEAM1_HEADER] = gi.imageindex ("chsb1"); //Header fr Scoreanzeige Team 1
	ent->client->ps.stats[STAT_CAPHOLD_TEAM2_HEADER] = gi.imageindex ("chsb2"); //Header fr Scoreanzeige Team 2

	ent->client->ps.stats[STAT_CAPHOLD_TEAM1_PIC] = gi.imageindex ("i_ch1");
	ent->client->ps.stats[STAT_CAPHOLD_TEAM2_PIC] = gi.imageindex ("i_ch2");

    ent->client->ps.stats[STAT_CAPHOLD_CLASSICON] = gi.imageindex (ent->client->resp.ch_classicon);	// Spielerklassenicon

	ent->client->ps.stats[STAT_CAPHOLD_TEAM1_POINTS] = capholdgame.pointsteam1; // Punkte Team 1 anzeigen
	ent->client->ps.stats[STAT_CAPHOLD_TEAM2_POINTS] = capholdgame.pointsteam2; // Punkte Team 2 anzeigen
	ent->client->ps.stats[STAT_CAPHOLD_TEAM1_FLAGS] = capholdgame.flag_team1;	// Anzahl der Flaggen Team 1
	ent->client->ps.stats[STAT_CAPHOLD_TEAM2_FLAGS] = capholdgame.flag_team2;	// Anzahl der Flaggen Team 2

	ent->client->ps.stats[STAT_CAPHOLD_JOINED_TEAM1_PIC] = 0;	// Rahmen Team 1
	ent->client->ps.stats[STAT_CAPHOLD_JOINED_TEAM2_PIC] = 0;	// Rahmen Team 2

	// In welchem Team ist der Spieler ?
	if (ent->client->resp.ctf_team == CH_TEAM1)
		ent->client->ps.stats[STAT_CAPHOLD_JOINED_TEAM1_PIC] = gi.imageindex ("i_chj");
	else if (ent->client->resp.ctf_team == CH_TEAM2)
		ent->client->ps.stats[STAT_CAPHOLD_JOINED_TEAM2_PIC] = gi.imageindex ("i_chj");

// MC Killer Caphold Items
	if (ent->client->judas_active==1)
	{
		ent->client->ps.stats[STAT_TIMER_ICON] = gi.imageindex ("p_judas");
		ent->client->ps.stats[STAT_TIMER] = (ent->client->judas_framenum - level.framenum)/10;
	} 

	if (ent->client->detector_active==1)
	{
		ent->client->ps.stats[STAT_TIMER_ICON] = gi.imageindex ("p_detector");
		ent->client->ps.stats[STAT_TIMER] = (ent->client->detector_framenum - level.framenum)/10;
	} 

// MC Killer Caphold Items Ende

}

/*
==================
CTFScoreboardMessage
==================
*/
void CHScoreboardMessage (edict_t *ent, edict_t *killer)
{
	char	entry[1024];
	char	string[1400];
	int		len;
	int		i, j, k, n;
	int		sorted[2][MAX_CLIENTS];
	int		sortedscores[2][MAX_CLIENTS];
	int		score, total[2], totalscore[2];
	int		last[2];
	gclient_t	*cl;
	edict_t		*cl_ent;
	int team;
	int maxsize = 1000;

	// sort the clients by team and score
	total[0] = total[1] = 0;
	last[0] = last[1] = 0;
	totalscore[0] = totalscore[1] = 0;
	for (i=0 ; i<game.maxclients ; i++)
	{
		cl_ent = g_edicts + 1 + i;
		if (!cl_ent->inuse)
			continue;
		if (game.clients[i].resp.ctf_team == CTF_TEAM1)
			team = 0;
		else if (game.clients[i].resp.ctf_team == CTF_TEAM2)
			team = 1;
		else
			continue; // unknown team?

		score = game.clients[i].resp.score;
		for (j=0 ; j<total[team] ; j++)
		{
			if (score > sortedscores[team][j])
				break;
		}
		for (k=total[team] ; k>j ; k--)
		{
			sorted[team][k] = sorted[team][k-1];
			sortedscores[team][k] = sortedscores[team][k-1];
		}
		sorted[team][j] = i;
		sortedscores[team][j] = score;
		totalscore[team] += score;
		total[team]++;
	}
// MC Killer
		totalscore[0] = capholdgame.pointsteam1;
		totalscore[1] = capholdgame.pointsteam2;
// MC Killer

	// print level name and exit rules
	// add the clients in sorted order
	*string = 0;
	len = 0;


	// team one
	sprintf(string, 
		"if 24 xv 8 yv 8 pic 24 endif "
		"xv 40 yv 28 string \"%4d/%-3d\" "
		"xv 98 yv 12 num 2 18 "
		"if 25 xv 168 yv 8 pic 25 endif "
		"xv 200 yv 28 string \"%4d/%-3d\" "
		"xv 256 yv 12 num 2 20 ",
		totalscore[0], total[0],
		totalscore[1], total[1]);
	len = strlen(string);

	for (i=0 ; i<16 ; i++)
	{
		if (i >= total[0] && i >= total[1])
			break; // we're done

#if 0 //ndef NEW_SCORE
		// set up y
		sprintf(entry, "yv %d ", 42 + i * 8);
		if (maxsize - len > strlen(entry)) {
			strcat(string, entry);
			len = strlen(string);
		}
#else
		*entry = 0;
#endif

		// left side
		if (i < total[0]) {
			cl = &game.clients[sorted[0][i]];
			cl_ent = g_edicts + 1 + sorted[0][i];

#if 0 //ndef NEW_SCORE
			sprintf(entry+strlen(entry),
			"xv 0 %s \"%3d %3d %-12.12s\" ",
			(cl_ent == ent) ? "string2" : "string",
			cl->resp.score, 
			(cl->ping > 999) ? 999 : cl->ping, 
			cl->pers.netname);

		
#else
			sprintf(entry+strlen(entry),
				"ctf 0 %d %d %d %d ",
				42 + i * 8,
				sorted[0][i],
				cl->resp.score,
				cl->ping > 999 ? 999 : cl->ping);

#endif

			if (maxsize - len > strlen(entry)) {
				strcat(string, entry);
				len = strlen(string);
				last[0] = i;
			}
		}

		// right side
		if (i < total[1]) {
			cl = &game.clients[sorted[1][i]];
			cl_ent = g_edicts + 1 + sorted[1][i];

#if 0 //ndef NEW_SCORE
			sprintf(entry+strlen(entry),
			"xv 160 %s \"%3d %3d %-12.12s\" ",
			(cl_ent == ent) ? "string2" : "string",
			cl->resp.score, 
			(cl->ping > 999) ? 999 : cl->ping, 
			cl->pers.netname);

		

#else

			sprintf(entry+strlen(entry),
				"ctf 160 %d %d %d %d ",
				42 + i * 8,
				sorted[1][i],
				cl->resp.score,
				cl->ping > 999 ? 999 : cl->ping);


#endif
			if (maxsize - len > strlen(entry)) {
				strcat(string, entry);
				len = strlen(string);
				last[1] = i;
			}
		}
	}

	// put in spectators if we have enough room
	if (last[0] > last[1])
		j = last[0];
	else
		j = last[1];
	j = (j + 2) * 8 + 42;

	k = n = 0;
	if (maxsize - len > 50) {
		for (i = 0; i < maxclients->value; i++) {
			cl_ent = g_edicts + 1 + i;
			cl = &game.clients[i];
			if (!cl_ent->inuse ||
				cl_ent->solid != SOLID_NOT ||
				cl_ent->client->resp.ctf_team != CTF_NOTEAM)
				continue;

			if (!k) {
				k = 1;
				sprintf(entry, "xv 0 yv %d string2 \"Spectators\" ", j);
				strcat(string, entry);
				len = strlen(string);
				j += 8;
			}

			sprintf(entry+strlen(entry),
				"ctf %d %d %d %d %d ",
				(n & 1) ? 160 : 0, // x
				j, // y
				i, // playernum
				cl->resp.score,
				cl->ping > 999 ? 999 : cl->ping);
			if (maxsize - len > strlen(entry)) {
				strcat(string, entry);
				len = strlen(string);
			}
			
			if (n & 1)
				j += 8;
			n++;
		}
	}

	if (total[0] - last[0] > 1) // couldn't fit everyone
		sprintf(string + strlen(string), "xv 8 yv %d string \"..and %d more\" ",
			42 + (last[0]+1)*8, total[0] - last[0] - 1);
	if (total[1] - last[1] > 1) // couldn't fit everyone
		sprintf(string + strlen(string), "xv 168 yv %d string \"..and %d more\" ",
			42 + (last[1]+1)*8, total[1] - last[1] - 1);

	gi.WriteByte (svc_layout);
	gi.WriteString (string);
}

void Caphold_Think(edict_t *ent)
{
	
	char *s;

//================= Rune of Judas

	if(ent->client->judas_active == 1)
	{
		if(ent->client->judas_framenum == level.framenum)
		{
			s = Info_ValueForKey (ent->client->pers.userinfo, "skin");

			gi.dprintf("Rune of Judas dektiviert\n");

			if (ent->client->resp.ctf_team == CH_TEAM2)
				strcpy(s, "male/ch_b");

			if (ent->client->resp.ctf_team == CH_TEAM1)
				strcpy(s, "male/ch_r");

			ent->client->judas_framenum = 0;
			ent->client->judas_active = 0;

			CHAssignSkin(ent, s);
		}
	}
	
}

