/*==========================================================================
 * 
 * Project : QuakeForge
 * Author  : Terry 'Mongoose' Hendrix II
 * Website : http://www.westga.edu/~stu7440
 * Email   : stu7440@westga.edu
 * Object  : qw_interface
 * Comments: See source file for comments
 *
 * Notes   :  The QW faux client code is based on code from:
 *           GENEBOT QUAKEWORLD SERVER SOURCE CODE DISTRIBUTION
 *           --------------------------------------------------
 *           AUTHOR:            Rich Whitehouse
 *           CONTACT:           thefatal@telefragged.com
 *           HOMEPAGE:          http://www.telefragged.com/thefatal/ 
 *           RELEASE NUMBER:    1
 *
 *
 *-- History ---------------------------------------------------------- 
 * 
 * See source file for history
 ==========================================================================*/

#ifdef QW_AI_PLAYERS_ALLOWED

#ifndef _QUAKEFORGE_QW_INTERFACE_H
#define _QUAKEFORGE_QW_INTERFACE_H 

#include "qwsvdef.h"

/* Globals contained in this object */

extern float  ADDTIME;     
extern float  OLDBOTS;     
extern float  BOTS;        
extern int    HACKIT;      
extern int    DONTADD;    
extern int    MSECNUM;     
extern float  MSECDEL;     
extern float  MSECVAL;     

/* Functions contained in this object */

edict_t *ED_ClientAlloc(void);

void SV_WritePlayersToBot(client_t *client, edict_t *clent, 
                          byte *pvs, sizebuf_t *msg);

void SV_WriteEntitiesToBot (client_t *client, sizebuf_t *msg);

qboolean SVC_DirectBotConnect (client_t *newcl, edict_t *botent);

void SetNetName(client_t *cl, char *constname);

char *GetUserInfo(client_t *cl);

void Bot_Spawn(void);

void Bot_SpawnLevel(void);

float vlen2(vec3_t v);

void vectoanglesbot(vec3_t vec, vec3_t ang);

void Bot_Remove(client_t *thisclient);

void Bot_RemoveLevel(client_t *thisclient);

void Cmd_RemoveBot(void);

void Bot_Think();

void Bot_ChangeWeapon(client_t *client, int weapon_flag);

void Bot_SV_Say(char *s, ...);

#endif
#endif
