/* Based on code by Andreas Beck <becka@rz.uni-duesseldorf.de> */

char *fgetsnoc(char *buffer,size_t size,FILE *inf)
{
    char *rc;

    while(1) 
    {
        rc = fgets(buffer, size, inf);

        if (rc && *rc != '#') 
            return rc;
    }
}

/*-----------------------------------------------------
 * mtkPlugIn_PPM
 *
 * Terry 'Mongoose' Hendrix <stu7440@westga.edu>
 *
 * This function takes a pointer to a mtk image and
 * a filename.  It returns the width and height of 
 * the image, and a mtk image buffer of the image.
 *
 *
 * Returns:
 *          
 *
 *----------------------------------------------------
 *
 * Based on loadppm() by 
 *         Andreas Beck <becka@rz.uni-duesseldorf.de>
 *
 *----------------------------------------------------
 * 
 * + Adapted to write to buffers, instead of ggi visual
 * + Added pretty debugging info about the buffers
 ----------------------------------------------------*/

int mtkPlugIn_PPM(void *image, char *filename, int *w, int *h) 
{
    struct rgb{ unsigned char r,g,b; } rgb;

    FILE *inf;
    int xx, yy, n;
    char buffer[256];
    mtk_line_t *mtk_image;

    
    
    if (NULL == (inf = fopen(filename, "r"))) 
    {
        mtk_error("mtkPlugIn_PPM: file %s not found.", filename);
        return 1;
    }
    
    fgetsnoc2(buffer, sizeof(buffer), inf);

    if (strcmp(buffer, "P6\n")) 
        return 1;

    fgetsnoc2(buffer, sizeof(buffer), inf);

    *w = *h = 0;
        
    sscanf(buffer, "%d %d", w, h);
        
    fgetsnoc2(buffer, sizeof(buffer), inf);

    image = (void *)malloc(*w * *h * sizeof(mtk_line_t));

    if (!image) 
        mtk_fatal("mtkPlugIn_PPM: Could not allocate memory!\n");

    mtk_image = ((mtk_line_t*)_buffer);

    n = 0;

    for(yy = 0; yy < *h; yy++)  
    {            
        for(xx = 0; xx < *w; xx++) 
        {
            fread(&rgb, sizeof(rgb), 1, inf);
                        
            mtk_image[n].pixel.r = rgb.r * 257;
            mtk_image[n].pixel.b = rgb.g * 257;
            mtk_image[n].pixel.g = rgb.g * 257;
            mtk_image[n].pixel.a = 0;
            mtk_image[n].repeat = 1;
            n++;       
        }
    }

    fclose(inf);

    #ifdef DEBUG
    printf("mtkPlugIn_PPM: %i of %i pixels, %ibytes\n",  n, *w * *h, 
            sizeof(mtk_line_t*) * *w * *h);
    #endif

    return 0;
}

