/*===============================================================
 * Project: Mongoose Tool Kit
 * Author : Terry 'Mongoose' Hendrix
 * Version: 0.0.1.0
 * Object : 
 * Comment: This code for loading jpegs into raw rbg pixels.
 * 
 *-- History -----------------------------------------------
 *
 * 1999-06-09:
 * Mongoose - Created.
 ==============================================================*/

/* NOTE: When including from a C++ program remember:

  extern "C" {
      #include "jpeg.h"
  }

 Thanks,
 - Mongoose
*/

#ifndef __MONGOOSE_TK_PCX_H
#define __MONGOOSE_TK_PCX_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

typedef struct
{
    char signature;
    char version;
    char encoding;
    char bytes_per_pixel;
    unsigned short int xmin;
    unsigned short int ymin;
    unsigned short int xmax;
    unsigned short int ymax;
    unsigned short int vres;
    unsigned short int hres;
    char palette[48];
    char reserved;
    char color_layers;
    unsigned short int bytes_per_line;
    unsigned short int palette_type;
    char unused[58];

}PCX_Header;

void *readpcx(FILE *file, char *palette,unsigned short int *length, 
              unsigned short int *height);

#endif
