#include "pcx.h"
#include "ag_pallete.c"

void Convert_Pal_From_Md2(void *image, int w, int h)
{
   int i, j;
   unsigned char c;

   printf(" |- Converting from Q2 to Q pal.");

   j = w * h;

   for(i = 0; i < j; i++)
   {
      c = (((unsigned char*)image)[i]);

      //(((unsigned char*)image)[i]) = 254; /* Glowing white */

      (((unsigned char*)image)[i]) = auto_gen_pal_converter(c); 

      //printf("%c -> %c\n", c, (((char*)image)[i]));
   }

   printf(" [Done]\n");
}

void readpcximage(FILE *file, void *target, int size)
{
    unsigned char buf;
    unsigned int counter;
    int i = 0;

    while(i <= size)  /* Image not entirely read? */
     {
         /* Get one byte */
         fread(&buf,1,1,file);
         /* Check the 2 most significant bits */
         if ((buf&192)==192)
         {
              /* We have 11xxxxxx */
              counter=(buf&63);       /* Number of times to repeat next byte */
              fread(&buf,1,1,file);     /* Get next byte */
              for(;counter>0;counter--) /* and copy it counter times */
              {
                  ((char*)target)[i]=buf;
                  i++;   /* increase the number of bytes written */
              }
         }
         else
         {
              /* Just copy the byte */
              ((char*)target)[i]=buf;
              i++;   /* Increase the number of bytes written */
         }
     }
}

/* Returns NULL if failed, otherwise a pointer to the loaded image */
void *readpcx(FILE *file, char *palette,unsigned short int *length, 
              unsigned short int *height)
{
    PCX_Header header;
    void *target;


    fseek(file,0,SEEK_SET);
    fread(&header,sizeof(PCX_Header),1,file);   /* read the header */

    /* Check if this file is in pcx format */
    if((header.signature!=0x0a)||(header.version!=5))
    {
        printf("Can't handle this version of PCX, ot it's not PCX.\n");
        return(NULL);
    }
    else
    {  
        /* Return height and length */
        *length=header.xmax+1-header.xmin;
        *height=header.ymax+1-header.ymin;

        /* Allocate the sprite buffer */
        target=(void *)malloc((*length)*(*height));

        if (!target)
	{
	   printf("readpcx: Malloc failed!!\n");
	   return NULL;
	}

        /* Read the image */
        readpcximage(file,target,(*length)*(*height));
        fseek(file,-768,SEEK_END);

        /* Get the palette */
        //fread(palette,1,768,file);

        /* PCX succesfully read! */
        return(target);
    }
}

#ifdef TEST_PCX
int main(int argc, char *argv[])
{
   FILE *f;
   void *image;
   short int w, h, i, j;
   unsigned char c;
   int scale = 1;      
   int r = 0;      


   if (argc > 2)
      scale = atoi(argv[2]); 

   if (argc > 3)
      r = atoi(argv[3]); 

   if (argc > 1)
   {
      f = fopen(argv[1], "r");
      image = readpcx(f, NULL, &w, &h);

      fprintf(stdout,"PCX %s is %ix%i, rendered @ 1:%i.<br>\n", 
              argv[1], w, h, scale);
      if (r)
      {
	fprintf(stdout, "ASCII codes <u>were</u> reversed.<br>\n");
      }

      fprintf(stdout,"Generated by ");
      fprintf(stdout,"<a href=\"http://www.westga.edu/~stu7440/projects\">");
      fprintf(stdout,"MDDC</a> PCX test by ");
      fprintf(stdout,"<a href=\"emailto:stu7440@westga\">Mongoose</a><br>\n");


      /* Mongoose: output ascii image in html format  =)  */
      if (image)
      {
         fprintf(stdout,"<pre>\n");

         for(j = 0; j < h; j+=scale)
         {
           for(i = 0; i < w; i+=scale)
	   {
	      c = (((unsigned char*)image)[i + j * w]);

              if (r)
                 c = 255 - c; /* Mongoose: reverse video, er ascii code */  

              switch(c)
	      {
              case '\n':
              case '\v':
              case '\t':
		 c = '2';
		 break;
	      }

   	      fprintf(stdout, "%c", c);
	   }

	   fprintf(stdout, "<br>");         
         }

         for(i = 0; i < w; i+=scale)
	    fprintf(stdout, ".");
       
         printf("</pre>\n<br>");

	free(image);
      }

      if (f)
	fclose(f); 
   }

   return 0;
}
#endif
