/*==========================================================================
 * 
 * Project : Quake2 Model loader contrib for quakeforge 
 * Author  : Terry 'Mongoose' Hendrix II
 * Website : http://www.westga.edu/~stu7440
 * Email   : stu7440@westga.edu
 * Object  : NA
 * Comments: This is the quake2 model loader module.
 *
 *           See file COPYING for license details.
 *
 *           Based on viewmd2 (c) Michael K Vance, 1999  
 *                                briareos@lokigames.com
 *                                mkv102@psu.edu
 *
 *           Based on Meddle (c) Brian Martin 1996
 *                               brian@phyast.pitt.edu
 *
 *           Based on Quake (c) id Software 1995 
 *
 *-- History ---------------------------------------------------------- 
 *
 * See the source file's header.
 ==========================================================================*/


#ifndef __QUAKEFORGE_MONGOOSE_MDDC_H
#define __QUAKEFORGE_MONGOOSE_MDDC_H


///MDL////////////////////////////////////////////////////////////
#define MDL_IDPOLYGON         0x4F504449
#define MDL_ALIAS_VERSION     6
#define MDL_ALIAS_ONSEAM      0x0020
#define MDL_DT_FACES_FRONT    0x0010

typedef float  vec_t;
typedef vec_t  vec3_t[3];

typedef enum 
{ 
   ST_SYNC = 0, 
   ST_RAND 
} synctype_t;


typedef struct 
{
   int             onseam;          /* 0 or 0x20 */ 
   int             s;               /* position (X), horizontally  
                                          in range [0,skinwidth] */
   int             t;               /* position (Y), vertically 
                                          in range [0,skinheight] */
} stvert_t;

typedef struct dtriangle_s 
{
   int   facesfront;
   int   vertindex[3];

} dtriangle_t;

typedef struct 
{
   int             ident;           /* 0x4F504449 = "IDPO" for IDPOLYGON */
   int             version;         /* Version = 6 */
   vec3_t          scale;           /* Model scale factors. */
   vec3_t          scale_origin;    /* Model origin. */
   float           boundingradius;  /* Model bounding radius.*/
   vec3_t          eyeposition;     /* Eye position (useless?) */
   int             numskins;        /* the number of skin textures */
   int             skinwidth;       /* Width of skin texture 
				          must be multiple of 8 (4 maybe) */
   int             skinheight;      /* Height of skin texture
				          must be multiple of 8 (4 maybe) */
   int             numverts;        /* Number of vertices */
   int             numtris;         /* Number of triangles surfaces */
   int             numframes;       /* Number of frames */
   synctype_t      synctype;        /* 0 = synchron, 1 = random */
   int             flags;           /* 0 (see Alias models) */
   float           size;            /* average size of triangles */

} mdl_t;

///below is non-id code////////////////////

typedef struct trivertex_s
{
   unsigned char    v[3];
   unsigned char    lightnormalindex;

} trivertex_t;

typedef struct QuakeModel_GSkin_s
{
   unsigned char *bitmap;

} QuakeModel_GSkin_t;

typedef struct QuakeModel_Skin_s
{
   unsigned type;
   unsigned char *bitmap;
   unsigned num_gskins;
   float *gskin_interval;
   QuakeModel_GSkin_t *gskin;

} QuakeModel_Skin_t;

typedef struct QuakeModel_MFrame_s
{
   trivertex_t   bboxmin;   /* lightnormal isn't used */
   trivertex_t   bboxmax;   /* lightnormal isn't used */
   char          name[16];  /* frame name from grabbing */
   trivertex_t  *tv;

} QuakeModel_MFrame_t;

typedef struct QuakeModel_MFrame_Group_s
{
   unsigned num_gsframes;
   trivertex_t   bboxmin;   /* lightnormal isn't used */
   trivertex_t   bboxmax;   /* lightnormal isn't used */
   float *gsframe_interval;
   QuakeModel_MFrame_t *gsframe;

} QuakeModel_MFrame_Group_t;

typedef struct QuakeModel_Frame_s
{
   unsigned type;
   QuakeModel_MFrame_Group_t  gframe;
   QuakeModel_MFrame_t        sframe;

} QuakeModel_Frame_t;

typedef struct QuakeModel_s
{
   mdl_t header;

   stvert_t *vertex;
   dtriangle_t *triangle;

  // non id structs below

   QuakeModel_Skin_t *skin;
   QuakeModel_Frame_t *frame;
   unsigned cur_skin;
   unsigned blocks;
   int tcolor;
   int bcolor;

} QuakeModel_t;

/////MD2////////////////////////////////////////////////////////////
#define MD2_IDALIASHEADER  ( '2' << 24 ) + ( 'P' << 16 ) + ( 'D' << 8 ) + 'I'
#define MD2_ALIAS_VERSION  8
#define MD2_MAX_TRIANGLES  4096
#define MD2_MAX_VERTS      2048
#define MD2_MAX_FRAMES     512
#define MD2_MAX_MD2SKINS   32
#define MD2_MAX_SKINNAME   64


typedef struct BoundingBox_s
{
    float xMin;
    float xMax;
    float yMin;
    float yMax;
    float zMin;
    float zMax;

} BoundingBox_t;

typedef struct TexCoordsIndex_s
{
    short s;
    short t;

} TexCoordsIndex_t;

typedef struct TriangleIndex_s
{
    short v[3];
    short st[3];

} TriangleIndex_t;

typedef struct VertexIndex_s
{
    float x;
    float y;
    float z;
    unsigned char normal;

} VertexIndex_t;

typedef struct  AliasFrame_s
{
    float scale[3];
    float translate[3];
    char name[16];
    VertexIndex_t* verts;

} AliasFrame_t;

typedef struct QuakeModel2_s
{
    int numXYZ;
    int numTris;
    int numFrames;
    TexCoordsIndex_t *texCoords;
    TriangleIndex_t *tris;
    AliasFrame_t *frames;
    int *commands;
    BoundingBox_t *bbox;
    int skinW;
    int skinH;
    int numST;

} QuakeModel2_t;


QuakeModel2_t *QuakeModel2_New(char *filename);
void QuakeModel2_Delete(QuakeModel2_t *q2m);
AliasFrame_t *QuakeModel2_getFrame(QuakeModel2_t *q2m,int);
TriangleIndex_t *QuakeModel2_getTriangle(QuakeModel2_t *q2m,int);
BoundingBox_t *QuakeModel2_getBoundingBox(QuakeModel2_t *q2m);
float QuakeModel2_getRadius(QuakeModel2_t *q2m);
int QuakeModel2_getNumFrames(QuakeModel2_t *q2m);
int QuakeModel2_getNumTris(QuakeModel2_t *q2m);
int QuakeModel2_getNumVertices(QuakeModel2_t *q2m);    
void QuakeModel2_getTexCoords(QuakeModel2_t *q2m,short*, short*, int, int);    


#endif
