#include <stdio.h>
#include <stdlib.h>


int main (int argc, char *argv[])
{
   FILE *from, *to, *out;
   unsigned char cf, ct;
   int i;
   char done[256];


   for(i = 0; i < 256; i++)
      done[i] = 0;
        
   if (argc != 3)
     return 0;

   from = fopen(argv[1], "r");
   to = fopen(argv[2], "r");
   out = fopen("ag_pallete.c", "w");

   if (!from || !to || !out)
      return 0;

   fprintf(out, "unsigned char auto_gen_pal_converter(unsigned char c)\n");
   fprintf(out, "{\n\n");
   fprintf(out, "   switch(c)\n   {\n");

   for(;;)
   {
      if (fscanf(from, "%c", &cf) == EOF || fscanf(to, "%c", &ct) == EOF)
      {
          fclose(from);
          fclose(to);
          break;
      }
      else if (cf != ct && done[cf] == 0)
      {
         done[cf] = 1;

         i = cf;
         fprintf(out, "   case %i:\n", i);

         i = ct;
         fprintf(out, "      c = %i;\n      break;\n", i);
      }
   }

   fprintf(out, "   }\n\n   return c;\n}\n");

   return 0;
}
