//==============================================================================
// CONSTANTS		 
//==============================================================================

float FRIEND_BASE = 0;
float ENEMY_BASE = 1;

// bits for self.observer_flag
float PLAYER_NO_TARGET = 1;
float PLAYER_USING_CAMERA = 2;
float PLAYER_ALWAYS_ESCORT = 4;

//==============================================================================
//==============================================================================
// times
float CAMPING_TIME = 120;		// 2 minutes
float ESCORT_TIME = 120;		// 2 minutes
// not used float ATTACK_DEFEND_TIME = 60;

//==============================================================================
// values for bot_action field
//==============================================================================
float BOT_FIGHTING = 1;
float BOT_MOVING = 2;
float BOT_STANDING = 3;

//==============================================================================
// values for bot_plan field
//==============================================================================
float BOT_ATTACK = 1;
float BOT_DEFEND = 2;
float BOT_ROAM = 3;


//==============================================================================
// flags for registered cvar
//==============================================================================
//float BOT_CUSTOM_SOUNDS = 2;		// use different sounds for cap/take

//==============================================================================
//==============================================================================
// CTFBOT EXTRAS [[[
entity() PlayerDropRune;
void() RuneStatus;
void () RuneThink;					
// CTFBOT EXTRAS ]]]

void() DetailedScoresBroadcast;
void(entity requester) DetailedScores;
void(entity requester, entity player) DetailedPlayerScores;

//==============================================================================
//==============================================================================
void(entity item)BotEvade;
float () Bot_BestWeapon;
float(entity bot, entity item) IsGoodItem;
entity(float radius) FindNearbyItem;
entity () FindNearbyEnemy;
void() BotJump;
float() BotShouldJump;
void() MoveBot;
float(entity targ) EntityInFieldOfView;
float() MaybeFight;
void () MaybeChangeYaw;
void(float perfect_accuracy) BotLeadTarget;
void(float perfect_accuracy) BotFireWeapon;
void() BotMoveTowardTarget;
void(float change_yaw) BotMoveTowardGoal;
void() ContinueFighting;
void() BotPreThink;
void() BotPostThink;
void() BotThink;
void() BotIsDead;
void () BotSelfDeActivate;
void () Bot_Precache;
entity(entity bot) TeamCaptureSpawnBot;
entity (string name, float botteam, float bskill) BotCreate; 
void () BotRespawn;
void (entity to) BotList;

void () MoveWhileFiring;

float(entity item) IsImmovableGettableItem;

void () BotAnimationThink;

void() Bot_WeaponFrame;
float () CheckBotImpulseCommands;
float () CheckExtraImpulseCommands;
void () bot_pain;

float () IsExactlyOnePlayer;

void (string st) BotSay;

void (entity player) BotSayEscort;
void () BotSayDefense;
void () BotSayDammit;
void () BotSaySomething;

void (float fteam) SpawnFlag;
void () SpawnBaseStockpile;

void () PrintEntityListBSP;
void () PrintEntityListCode;

void() DropDown;

void (float make_visible) SetWaypointsVisible;
void (float make_visible) SetDebugMarkersVisible;
void (vector org) MoveDebugMarker;

entity (float bskill) CreateRedBot;
entity (float bskill) CreateBlueBot;
void (float fteam) RemoveBestBot;

void (float fteam) StartNewPath;
void (vector org, float fteam) SpawnNextWaypoint;
void () PrintWaypoints;
entity (vector org, float fteam, float wpnum, float use_sprite) SpawnWaypointNum;
void (vector org) SpawnDeathmatchStart;

void () PrintCloseWaypoint;
void (float fteam) ReportIn;

void (float fteam) AllBotsAttack;
void (float fteam) AllBotsDefend;
void (float fteam) MoreBotsAttack;
void (float fteam) MoreBotsDefend;
void (float fteam) MoreBotsRoam;
void () OrderCamping;
void () OrderEscort;

void(string mname)SpawnWaypointsForMap;

void () SwitchBotNames;
void (entity bot) RandomNormalName;

void () InitCPU;
void () RecalcCPU;
void () IncreaseCPU;
void () DecreaseCPU;

void () IncreaseBotPing;
void () DecreaseBotPing;

void () ToggleWaypoints;

void () BroadcastMVP;
void () ToggleAllConsoles;

float() StepUpZ;

void (float broadcst) PrintFragList;

void (float force_update) SetPlayerViewPoint;
void () SetPlayerViewpointNow;
void()ToggleCamera;
void() WatchNextPlayerOrBot;
void () ToggleAutoCamera;
void () ToggleFOVControl;

void () BotKeepTeamsEven;

void () StartNewGeneralPath;
void (vector org) SpawnNextGeneralWaypoint;

entity(float dweapon, entity throwto) TossWeaponBackpack;
void () OrderDropStuff;
float (float enemy_base, float change_yaw) MoveTowardBase;
void () SpawnEvenTeamEntity;

float (float fteam) IsHumanOnTeam;

void (float fteam) PrintTeamStatus;
entity (entity head) FindNextPlayerOrBot;

float (float fteam) TeamHasFlag;

void () BotSayStart2;
void (string st) BotSayMiddle;
void () BotSayEnd;
void () BotSayTeamStart2;
void (string st) BotSayTeamMiddle;
void () BotSayTeamEnd;

void () RemoveClosestWaypoint;
float() ShouldReleaseHook;

void () SpawnFollowEntity;
void (entity p) BPrintFrags;

void (float f) dprintfloat;
void (float f) bprintfloat;
void (entity s, float f) sprintfloat;
void (string st) sprint2;
void (vector v) dprintvector;

float () GetNumHumans;
float (float fteam) GetNumPlayersOnTeam;
float (float fteam) GetNumHumansOnTeam;
void () SpawnBotColorMapEntity;

//void () InvasionSpawnBots;

void () PrintWaypointList;

void (float fteam) PlayFlagTakenSound;
void (float fteam) PlayFlagCaptureSound;

void(entity player) ActivateHolo;

float (entity p) IsPlayerOrBot;

void (vector org) spawn_tfog;
float() crandom;
void() BecomeExplosion;

void() TeamFlagStatusReport;
void (vector org, float timeout, float fteam) SpawnTempWaypoint;
void () FakeStatusBar;
void () BlinkEnts;

void () DecreaseLight;
void () IncreaseLight;

void (entity flag_carrier, entity throwto) TossFlag;
void () OrderTossFlag;
void () StartAttackSequence;
void () StopAttackSequence;
void (float force_update) PrepareAttackAnnouncements;