/*===============================================================
 * Project: Darkbot II 
 * Author : Terry 'Mongoose' Hendrix
 * Website: http://www.westga.edu/~stu7440/
 * Email  : stu7440@westga.edu
 * Version: Prototype
 * Object : item_reg
 * Comment: This is where items are registried for darkbot's
 *          item knowelge database. Currently uses array data 
 *          sturcture to reduce overhead and lookup. 
 * TODO   : Seperate the item registry into AMMO, HEALTH, WEAPON, 
 *          ARMOR, KEY, CUSTOM.  Add fuzzy weights into a struct 
 *          field that contains pointer to edict_t and the fuzzy 
 *          weight.
 *
 *-- Copyright ----------------------------------------------
 * Copyright (C) 1999 Terry Hendrix II.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 * 
 *-- History -----------------------------------------------
 *
 * 1999-07-06:
 * Mongoose - Cleaned up code/comments for public release
 *
 * 1999-05-10:
 * Mongoose - Fixed all known bugs
 *
 * 1999-05-07:
 * Mongoose - Created
 ==============================================================*/


#include "g_local.h"
#include "item_reg.h"

edict_t* ITEM_LIST[ITEM_MAX];       /* Item database data structure */
int ITEM_COUNT = 0;                 /* Not used, we no longer defrag list */


void reg_item_db(edict_t *item)
{
    reg_item_array(item);
}

void unreg_item_db(edict_t *item)
{
    unreg_item_array(item);
}

void reset_item_array()
{
    int i;

    ITEM_COUNT = 0;

    for (i = 0; i < ITEM_MAX; i++)
        ITEM_LIST[i] = 0;

    #ifdef BOT_DEBUG_ITEM_REG
    gi.dprintf("Darkbot: ItemList cleared.\n");
    #endif
}

void reg_item_array(edict_t *item)
{
    char done = 0;
    int i = 0;

    for (i = 0; i < ITEM_MAX; i++)
    {
        if (ITEM_LIST[i] == 0)
	{
            ITEM_LIST[i] = item;

            #ifdef BOT_DEBUG_ITEM_REG
            gi.dprintf("Darkbot: Item[%i] = %s.\n", i, item->classname);
            #endif

            return;
	}
    }

    gi.dprintf("Darkbot: not enough space to ireg %s.\n", i, item->classname);
}

void unreg_item_array(edict_t *item)
{
    int i;

    for (i = 0; i < ITEM_MAX; i++)
    {
        if (ITEM_LIST[i] == item)
	{
            ITEM_LIST[i] = 0;

            #ifdef BOT_DEBUG_ITEM_REG
            gi.dprintf("Darkbot: Item[%i], %s deleted.\n",i, item->classname);
            #endif

            return;
        }
    }

    #ifdef BOT_DEBUG_ITEM_REG
    gi.dprintf("Darkbot: Item[%i], %s not in ireg.\n", i, item->classname);
    #endif
}


