/*===============================================================
 * Project: Darkbot II 
 * Author : Terry 'Mongoose' Hendrix
 * Website: http://www.westga.edu/~stu7440/
 * Email  : stu7440@westga.edu
 * Version: Prototype
 * Object : enemy_reg
 * Comment: This is where enemies are registried for darkbot's
 *          potential enemy knowelge database. Currently uses 
 *          array data sturcture to reduce overhead and lookup. 
 *
 *          Define BOT_DEBUG_ENEMY_REG for debugging this object.
 *
 *-- Copyright ----------------------------------------------
 * Copyright (C) 1999 Terry Hendrix II.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 ==============================================================*/

#ifndef __MONGOOSE_ENEMY_REG_H
#define __MONGOOSE_ENEMY_REG_H


#define ENEMY_MAX 128    /* Assumed max enemies possible in a game at once */

void reset_enemy_db();
/*--------------------------------------------
 Created  : 990507
 Author   : Terry 'Mongoose' Hendrix II
 Inputs   : None
 Returns  : Nothing
 Purpose  : Clears enemy list. (wrapper)
 --------------------------------------------*/

void reg_enemy_db(edict_t *enemy);
/*--------------------------------------------
 Created  : 990507
 Author   : Terry 'Mongoose' Hendrix II
 Inputs   : enemy - The edict to add to the
                    list.
 Returns  : Nothing
 Purpose  : Add edict to enemy list. (wrapper)
 --------------------------------------------*/

void unreg_enemy_db(edict_t *enemy);
/*--------------------------------------------
 Created  : 990507
 Author   : Terry 'Mongoose' Hendrix II
 Inputs   : enemy - The edict to delete from
                    the list.
 Returns  : Nothing
 Purpose  : Delete edict from enemy list.
            (wrapper)
 --------------------------------------------*/

void reset_enemy_array();
/*--------------------------------------------
 Created  : 990507
 Author   : Terry 'Mongoose' Hendrix II
 Inputs   : None
 Returns  : Nothing
 Purpose  : Clears enemy list for arrays.
 --------------------------------------------*/

void reg_enemy_array(edict_t *enemy);
/*--------------------------------------------
 Created  : 990507
 Author   : Terry 'Mongoose' Hendrix II
 Inputs   : enemy - The edict to add to the
                    list.
 Returns  : Nothing
 Purpose  : Add edict to enemy list array.
 --------------------------------------------*/

void unreg_enemy_array(edict_t *enemy);
/*--------------------------------------------
 Created  : 990507
 Author   : Terry 'Mongoose' Hendrix II
 Inputs   : enemy - The edict to delete from
                    the list.
 Returns  : Nothing
 Purpose  : Delete edict from enemy list array.
 --------------------------------------------*/

#endif


