/*===============================================================
 * Project: Darkbot II 
 * Author : Terry 'Mongoose' Hendrix
 * Website: http://www.westga.edu/~stu7440/
 * Email  : stu7440@westga.edu
 * Version: Prototype
 * Object : enemy_reg
 * Comment: This is where enemies are registried for darkbot's
 *          potential enemy knowelge database. Currently uses 
 *          array data sturcture to reduce overhead and lookup. 
 *
 *-- Copyright ----------------------------------------------
 * Copyright (C) 1999 Terry Hendrix II.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 * 
 *-- History -----------------------------------------------
 *
 * 1999-07-06:
 * Mongoose - Cleaned up code/comments for public release
 *
 * 1999-05-10:
 * Mongoose - Fixed all known bugs
 *
 * 1999-05-07:
 * Mongoose - Created
 ==============================================================*/

#include "g_local.h"
#include "enemy_reg.h"

edict_t* ENEMY_LIST[ENEMY_MAX];    /* Enemy database data structure */
int ENEMY_COUNT = 0;               /* Not used, we no longer defrag list */


void reset_enemy_db()
{
    reset_enemy_array();
}

void reg_enemy_db(edict_t *enemy)
{
    reg_enemy_array(enemy);
}

void unreg_enemy_db(edict_t *enemy)
{
    unreg_enemy_array(enemy);
}

void reset_enemy_array()
{
    int i;

    ENEMY_COUNT = 0;


    /* Kind of stupid for an array of structs */
    for (i = 0; i < ENEMY_MAX; i++)
        ENEMY_LIST[i] = 0;

    #ifdef BOT_DEBUG_ENEMY_REG
    gi.dprintf("Darkbot: EnemyList cleared.\n");
    #endif
}

void reg_enemy_array(edict_t *enemy)
{
    char done = 0;
    int i = 0;

    for (i = 0; i < ENEMY_MAX; i++)
    {
        if (ENEMY_LIST[i] == 0)
	{
            ENEMY_LIST[i] = enemy;
            #ifdef BOT_DEBUG_ENEMY_REG
            gi.dprintf("Darkbot: Enemy[%i] = %s.\n", i, enemy->classname);
            #endif
            return;
	}
    }

    #ifdef BOT_DEBUG_ENEMY_REG
    gi.dprintf("Darkbot: not enough space to ereg %s.\n", i, enemy->classname);
    #endif
}

void unreg_enemy_array(edict_t *enemy)
{
    int i;

    for (i = 0; i < ENEMY_MAX; i++)
    {
        if (ENEMY_LIST[i] == enemy)
	{
            ENEMY_LIST[i] = 0;
            #ifdef BOT_DEBUG_ENEMY_REG
            gi.dprintf("Darkbot: Enemy[%i], %s deleted.\n",i,enemy->classname);
            #endif
            return;
        }
    }

    #ifdef BOT_DEBUG_ENEMY_REG
    gi.dprintf("Darkbot: Enemy[%i], %s not in ereg.\n", i, enemy->classname);
    #endif
}

