/*===============================================================
 * Project: Darkbot II 
 * Author : Terry 'Mongoose' Hendrix
 * Website: http://www.westga.edu/~stu7440/
 * Email  : stu7440@westga.edu
 * Version: Prototype
 * Object : data_reg
 * Comment: This is where data is registried for darkbot's
 *          agents. Currently uses array data sturcture to 
 *          reduce overhead and lookup. 
 *
 *-- Copyright ----------------------------------------------
 * Copyright (C) 1999 Terry Hendrix II.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 ==============================================================*/

#ifndef __MONGOOSE_DATA_REG_H
#define __MONGOOSE_DATA_REG_H

#define MAX_BOTS 16

struct bot_data_s
{
    char path[512];
    int  last_visited;
    int  item_hack;
    char inuse;
    char id[8];
    int  pos;
};

typedef struct bot_data_s bot_data_t;


void reg_data_db(edict_t *bot);
/*--------------------------------------------
 Created  : 990507
 Author   : Terry 'Mongoose' Hendrix II
 Inputs   : bot - client using agent database.
 Returns  : Nothing
 Purpose  : Client spawns.
            Agent data registers with client.
 --------------------------------------------*/

void unreg_data_db(edict_t *bot);
/*--------------------------------------------
 Created  : 990507
 Author   : Terry 'Mongoose' Hendrix II
 Inputs   : bot - client using agent database.
 Returns  : Nothing
 Purpose  : Client is dead. 
            Agent removes itself.
 --------------------------------------------*/

#endif 



