/*===============================================================
 * Project: Darkbot II 
 * Author : Terry 'Mongoose' Hendrix
 * Website: http://www.westga.edu/~stu7440/
 * Email  : stu7440@westga.edu
 * Version: Prototype
 * Object : data_reg
 * Comment: This is where data is registried for darkbot's
 *          agents. Currently uses array data sturcture to 
 *          reduce overhead and lookup. 
 *
 *-- Copyright ----------------------------------------------
 * Copyright (C) 1999 Terry Hendrix II.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 * 
 *-- History -----------------------------------------------
 *
 * 1999-07-10:
 * Mongoose - Cleaned up code/comments for public release
 *
 * 1999-05-07:
 * Mongoose - Created
 ==============================================================*/


#include "g_local.h"
#include "data_reg.h"


bot_data_t BOT_DATA[MAX_BOTS];

void reg_data_db(edict_t *bot)
{
    int i;

    for (i = 0; i < MAX_BOTS; i++)
    {
        if (BOT_DATA[i].inuse == 0)
	{
            BOT_DATA[i].inuse = 1;
            BOT_DATA[i].last_visited = -1;

            sprintf(BOT_DATA[i].id, "%i", i);

            bot->target = BOT_DATA[i].id;
     
            return;
	}
    }

    printf("BOT_DATA full!\n");
}

void unreg_data_db(edict_t *bot)
{
    int i = atoi(bot->target);

    if (i < MAX_BOTS)
        BOT_DATA[i].inuse = 0;  
}
