// Everything in here was written by Matt Ownby
// for the Balance of Power (aka High-Ping Heaven) mod

// Other files modified are:

// p_client.c
// g_combat.c
// p_view.c
// g_local.h
// g_svcmds.c
// g_cmds.c
// g_save.c

// To find lines modified thruout source, search for "MATT"

#include "g_local.h"
#include "bop_fnc.h"
#include "bop_var.h"
#include "bop_mod.h"


int anti_lpb(edict_t *attacker, edict_t *target, int damage)
{

// This function adjusts the amount of damage that a HPB does to an LPB
// It is called when a client takes damage

	int delta_ping = 0;
	float x = 0.0, adjust = 0.0;
	gclient_t *aclient = attacker->client;
	gclient_t *tclient = target->client;
	int result = damage;

	if (!((laghelp_str == 0.0)
		|| (!attacker->client)
		|| (OnSameTeam(target, attacker))
		|| (!target->client)))
		// ie if NONE of these conditions are met...
	{
		delta_ping = aclient->ping - tclient->ping;
		// difference in pings of attacker & target

		if (delta_ping>=min_delta_ping)
		{
			if (delta_ping>max_delta_ping)
			{
				delta_ping = max_delta_ping;
			}

			x = ((float)delta_ping/max_delta_ping)*(NINETYDEGS);
			adjust = (laghelp_str*sin(x))+1;

			result *= adjust;

			if (bop_verbose)
			{
				gi.cprintf(attacker, PRINT_HIGH, "Your damage increased from %d ", damage);
				gi.cprintf(target, PRINT_HIGH, "Damage to you increased from %d ", damage);
				gi.cprintf(attacker, PRINT_HIGH, " to %d [1:%f]\n", result, adjust);
				gi.cprintf(target, PRINT_HIGH, " to %d [1:%f]\n", result, adjust);
			}

			aclient->strength_framenum = level.framenum + bop_flareup;
			// have them flareup a nice blue...
		} // end if delta_ping >= min_delta_ping
	} // end if we should even bother adjusting damage

	return(result);

}


int pro_hpb(edict_t *attacker, edict_t *target, int damage)
{

// This function adjusts the amount of resistance that an HPB gains against
// an LPB.  It is called when a client takes damage

  int delta_ping = 0;
  float x = 0.0, adjust = 0.0;
  gclient_t *aclient = attacker->client;
  gclient_t *tclient = target->client;
  char s[81] = { 0 };
  int result = damage;

  if (!((laghelp_rst == 0.0)
		|| (!attacker->client)
		|| (OnSameTeam(target, attacker))
		|| (!target->client)))
		// ie if NONE of these conditions are met...
  {
	  delta_ping = tclient->ping - aclient->ping;
	  // difference in pings of target & attacker

	  if (delta_ping>=min_delta_ping)
	  {
		  if (delta_ping>max_delta_ping)
		  {
			  delta_ping = max_delta_ping;
		  }

		  x = ((float)delta_ping/max_delta_ping)*(NINETYDEGS);
		  adjust = (laghelp_rst*sin(x))+1;

		  result /= adjust;

		  if (bop_verbose)
		  {
			  gi.cprintf(attacker, PRINT_HIGH, "Damage to your target reduced from %d ", damage);
			  gi.cprintf(target, PRINT_HIGH, "Damage to you reduced from %d ", damage);
			  gi.cprintf(attacker, PRINT_HIGH, " to %d [1:%f]\n", result, adjust);
			  gi.cprintf(target, PRINT_HIGH, " to %d [1:%f]\n", result, adjust);
		  }

		  if ( (!adjust_resistance(attacker, target, &damage)) && (result<damage) )
			  // If attacker is using the railgun, there is no resistance
		  {
			  if (bop_verbose)
			  {
				  gi.cprintf(attacker, PRINT_HIGH, "You hit for %d damage\n", damage);
			  }
			  result = damage;
		  }
		  else
		  {
			  tclient->resistance_framenum = level.framenum + bop_flareup;
			  // Make them flash red to indicate lag help...
		  }
	  } // end if (delta_ping >= min_delta_ping)
  } // end if we should even bother adjusting damage...

  return(result);

}


void protecthpb(edict_t *attacker, edict_t *ent)
{

// Function: Check to see if they are lagged out,
// and if they are, give them lag sickness...

  gclient_t *client = ent->client;

  if (!((!client)	// entity is not a client
	  || ((ent == attacker) && (no_suicide_protect))
		// no suicide protection enabled
	  || ((!attacker->client) && (no_slag_protect))))
	    // no non-client protection enabled
	  // ie if none of the above conditions are true
  {

	  if (!((client->invincible_framenum > level.framenum)
		  // they are invincible
		  || (client->protecthpb_framenum > level.framenum)))
		    // they already have lag sickness
	  // ie if none of the above conditions are true
	  {

		  if (lagged_out(ent))
		  {	// if they're lagged out, give them L.S.
			  client->protecthpb_framenum = level.framenum + bop_deadtime;
			  client->invincible_framenum = level.framenum + bop_getawaytime;
#ifdef BOP_CTF
			  CTFDeadDropFlag(ent);	// lagged out players drop the flag
#endif
			  if (bopsickremove) {
				  gi.WriteByte(svc_muzzleflash);
				  gi.WriteShort(ent-g_edicts);
				  gi.WriteByte(MZ_LOGOUT);
				  gi.multicast(ent->s.origin, MULTICAST_PVS);
				  ent->movetype = MOVETYPE_NOCLIP;
				  ent->solid = SOLID_NOT;
				  ent->svflags |= SVF_NOCLIENT;
				  ent->client->bop_i[0] = 1;	// mark them as lagged out...
				  gi.bprintf(PRINT_HIGH, "%s lagged out\n", ent->client->pers.netname);
			  } // end if BoP turns lagged players into observers
		  } // end if they are lagged out
	  } // end if they are a candidate for lag sickness (check 2)
  } // end if they are a candidate for lag sickness (check 1)
}



qboolean lagged_out(edict_t *ent)
{

  int lod = 0;
  gclient_t *client = ent->client;
  qboolean result = false;

// Pre-Condition: ent->client exists (otherwise it will crash)

// Returns:
// True if client is determined to be lagged out
// False if client is not lagged out

// This function needs to be called every frame (this is handled
// by do_bop_frame)

  if (ent->health > 0)
	  // they must be alive to lag out... =)
  {

	  if (level.time - client->respawn_time < 1.0)
	  // if they have just respawned, reset their lagged counter
	  {
		  client->last_recorded_ping = client->ping;
		  client->lag_detect_framenum = level.framenum; // reset-it
	  }

	  else if (client->ping == 0)
		  // If their ping is 0, they have cl_nodelta
		  // enabled, which means we can't detect lag
		  // we'll give them 3 nice warnings...
	  {
		  switch ((level.framenum - client->resp.enterframe) / 10) {
		  case 30:	// 30 seconds...
		  case 60:	// 1 minute.. you get the idea...
		  case 90:
			  if (lag_msg(ent))
			  {
				  gi.centerprintf(ent, "It is advised that you type\ncl_nodelta 0\nat the console!  You will be\nnotified three times");
				  break;
			  }
		  }
	  }
	  else if (client->ping > lag_threshold)
	  {
        if (bop_verbose)
		{
                gi.cprintf(NULL, PRINT_HIGH, "Client's ping has exceeded threshold\n");
		}
		result = true;	// their ping is too high, they are lagged
		client->grace_framenum = level.framenum + grace_time;	// give them a grace period
	  }

	  else
	    // Here is the code to check for packet loss
	    // Packet loss can be detected because a client's ping freezes
	  {
		  lod = lagged_out_detect;
		  if (client->ping < 50)    // ie, if they're an LPB
		  {
			  lod *=3;                // perform a check 3 times as long
                                // the lower the ping the more likely
                                //  it is that the ping won't fluctuate
		  }

		  if (client->last_recorded_ping == client->ping)
			  // if their ping appears to be frozen...
		  {
			  if (level.framenum - client->lag_detect_framenum > lod)
				  // if their ping has been frozen too long...
			  {
				  result = true; // prolonged packet loss
				  client->grace_framenum = level.framenum + grace_time;
			  }
		  }
		  else
			  // their ping has fluctuated, they are ok...
		  {
			  client->last_recorded_ping = client->ping;
			  client->lag_detect_framenum = level.framenum; // reset-it
		  }
	  }	// end portion to check for packet loss
  }	// end portion that runs if client is alive

  if (client->grace_framenum > level.framenum)
	  // if they have only recently stopped lagging
	  // and they are still protected by our grace period
  {
	  result = true;	// then still consider them lagged out
  }

  return(result);

}



qboolean pent_from_lag(edict_t *ent)
{

	// Pre-Condition: ent->client must exist
	// Returns true if client has invulnerability because
	// they have lag sickness (ie they are lagged out)

	qboolean result = false;

	if ((ent->client->invincible_framenum > level.framenum) &&
		(ent->client->protecthpb_framenum > level.framenum))
	{
		result = true;
	}
	
	return(result);

}



int lag_sickness(edict_t *ent)
{

// Pre-Condition: ent->client must exist
// Returns the number of seconds remaining of lag sickness

  int result = 0;
  int difference = 0;

  difference = ent->client->protecthpb_framenum - level.framenum;
  if (difference > lagsicktime)
  {
        result = (difference - lagsicktime) / 10;
  }

  return(result);

}



qboolean lag_msg(edict_t *ent)
{

// Pre-Condition: ent->client must exist or we cra$h

// Purpose: To make sure server can't flood the client
// returns true if it's okay to send client a message
// returns false if they've had a message too recently

  qboolean result = false;

  if (abs(ent->client->lagmsg_framenum - level.framenum) > msg_interval)
  {
	  ent->client->lagmsg_framenum = level.framenum;
	  result = true;
  }

  return(result);

}


qboolean short_lag_msg(edict_t *ent)
{

// Same as lag_msg function except it only pauses for a shorter interval

  qboolean result = false;

  if (abs(ent->client->lagmsg_framenum - level.framenum) > short_msg_interval)
  {
	  ent->client->lagmsg_framenum = level.framenum;
	  result = true;
  }

  return(result);

}

qboolean lag_sick_notice(edict_t *ent)
{

// returns true if they have lag sickness (ie they can't fire!)
// returns false if it's okay for them to fire

	qboolean result = false;
	int i = 0;

	i = lag_sickness(ent);
	if (i || pent_from_lag(ent))
	{
		if (lag_msg(ent)) {
			gi.sound(ent, CHAN_VOICE, gi.soundindex("misc/secret.wav"), 1, ATTN_NORM, 0);
			if (pent_from_lag(ent)) {
				gi.centerprintf(ent, "You've got lag sickness!\n\nYou are frozen until you\n\nstop lagging out...");
			}
			else
			{
				gi.centerprintf(ent,"You've got lag sickness\nfor %d more seconds\n", i);
			}
		}
		result = true;
	}
	return(result);

}



void do_bop_frame(edict_t *ent)
{

// called from ClientBeginServerFrame

	gclient_t *client = ent->client;
	edict_t *other = 0;
	qboolean blocked = false;
	int i = 0;
	int lod = lagged_out_detect;

	lagged_out(ent);	// refresh lagged_out each frame...


	if (client->ping < 50)
			// lower pings tend to not fluctuate as much...
	{
		lod = lod * 2;
	}

	if (pent_from_lag(ent)) {
		if (lagged_out(ent)) {	// if they're still lagging...
			// make it so they don't lose their powerups
			client->invincible_framenum = level.framenum + bop_getawaytime;
			client->protecthpb_framenum = level.framenum + bop_deadtime;
				// reset their countdown...
			client->quad_framenum++;	
			client->breather_framenum++;
			client->enviro_framenum++;
		}
		else if (bopsickremove)
		{
			if (short_lag_msg(ent))
			{
				i = (client->invincible_framenum - level.framenum)/10;
				gi.centerprintf(ent, "You lagged out but were saved\n\nGet ready to re-enter the game\n\n%i", i);
				// give them the countdown hehe...
			}
		}
	}

	else if (ent->client->bop_i[0]) // ie, if they're an observer
	{
			other = NULL;
			blocked = 0;
			while ((other = findradius(other, ent->s.origin, 80)) != NULL)
			{
				if (!strcmp(other->classname, "player") && other->client)
				{
					blocked = 1;
					break;
				}
			}
			if (!blocked)
			{
				KillBox(ent);	// telefrag just in case =)
				if (ent->health>0)
				{
					ent->svflags &= ~SVF_NOCLIENT;
					ent->movetype = MOVETYPE_WALK;
					ent->solid = SOLID_BBOX;
				}
				gi.WriteByte(svc_muzzleflash);
				gi.WriteShort(ent-g_edicts);
				gi.WriteByte(MZ_LOGIN);
				gi.multicast(ent->s.origin, MULTICAST_PVS);
				gi.bprintf(PRINT_HIGH, "%s re-entered the game\n", ent->client->pers.netname);
				client->bop_i[0] = 0;	// back in the fray...
			}
			else {
				if (lag_msg(ent))
				{
					gi.centerprintf(ent, "%s is in your way!\n", other->client->pers.netname);
				}
				client->invincible_framenum++;
				client->protecthpb_framenum++;
			}
	}	// end if they're detected to be an observer w/ sickness

	else if (bopmanageobservers && (ent->svflags & SVF_NOCLIENT) 
			&& (ent->movetype != MOVETYPE_NOCLIP))
	{
			if (ent->health>0)	// only do this if they're alive
			{
				ent->svflags &= ~SVF_NOCLIENT;
				// make sure they are not an invisible man
			}
	}

	else if ((!ent->svflags & SVF_NOCLIENT)
		&& (level.framenum - client->lag_detect_framenum > (lod * 3)))
	{
		// if they are visible...
		// AND
		// if they are lagging out for a long time and they have
		// not yet been removed from the game, automatically remove
		// them because their connection has become unstable

		protecthpb(ent, ent); // suicide protection needs to be enabled
	}

}



void do_bop_client_frame(edict_t *ent, usercmd_t *ucmd)
{

// called from ClientThink...

	if (pent_from_lag(ent) || ent->client->bop_i[0])
	{
			ucmd->forwardmove = 0;	// don't let them move
			ucmd->sidemove = 0;
			ucmd->upmove = 0;
			if (ucmd->buttons)
			{
				lag_sick_notice(ent);
				ucmd->buttons = 0;	// clear all buttons... (no firing)
			}
	}
	else if (lagged_out(ent) && ucmd->buttons & BUTTON_ATTACK)
			// if they fire, they lose their grace time...
	{
		ent->client->grace_framenum = level.framenum;
	}
}



void do_greeting(edict_t *ent)
{

// Pre-Conditions: ent->client must exist

	char stage[81] = { 0 }, gmstr[81] = { 0 };

    if (!BOP_STAGE)
	{
		strcpy(stage, "Alpha Release (Bugs may exist)");
	}
	else if (BOP_STAGE==1)
	{
		strcpy(stage, "Beta Release");
	}
	else
	{
		strcpy(stage, "Public Release");
	}

	get_mode_name (gmstr);

	gi.centerprintf(ent, "Server running Balance of Power %.2f\n\n%s\n\nBOP set to %s mode\n\nFor help type 'cmd bophelp'\n\nLatest stable version at:\nwww.planetquake.com/bop/", BOP_VERSION, stage, gmstr);

}

void get_mode_name (char *gmstr) {

// Puts the game mode name in gmstr

  switch(game_mode)
  {
	case 0:	// normal
		if ((laghelp_str == n_laghelp_str) && (laghelp_rst == n_laghelp_rst)
		   && (max_delta_ping == n_max_delta_ping)
		   && (min_delta_ping == n_min_delta_ping))
		{
		  strcpy(gmstr, "NORMAL");
		}
		else
		{
		  strcpy(gmstr, "Customized NORMAL");
		}
		break;
	case 1:	// expert
		if ((laghelp_str == x_laghelp_str) && (laghelp_rst == x_laghelp_rst)
		    && (max_delta_ping == x_max_delta_ping)
		    && (min_delta_ping == x_min_delta_ping))
		{
		  strcpy(gmstr, "EXPERT");
		}
		else
		{
		  strcpy(gmstr, "Customized EXPERT");
		}
		break;
	case 2: // Tournament
		if ((!laghelp_str) && (!laghelp_rst))
		{
		  strcpy(gmstr, "ANTI PHONE-JACK");
		}
		else
		{
		  strcpy(gmstr, "Cust. PHONE-JACK");
		}
		break;
	case 3: // Unknown
		strcpy(gmstr, "UNKNOWN (Bug)");
		break;
  }

}

void bopinit()
{

// Pre-Conditions: None, really
// Function called from g_save.c
// Purpose: To initialize the bop cvar so that Gamespy will detect BOP
//	servers
//	Also, to read the bop.ini file and setup any parameters found

#define BI_LENGTH 81
#define BI_FILENAMES 4

  cvar_t *gamedircv;
  char *gamedir;
  char s2[10], s1[BI_LENGTH], cmd2[BI_LENGTH], path[81];
  char *filename[BI_FILENAMES] = { "bop.ini", "bop.cfg",
			"./bop/bop.ini", "./bop/bop.cfg" };

  char *s;
  int ch, i, j, n;
  FILE *F;	// old file handling, but it's simple and we only do it
		// once so speed is not a concern

  sprintf(s2, "v%.2f", BOP_VERSION);
  gi.cvar("bop", s2, CVAR_SERVERINFO);	// set us up for gamespy tabs!

  gamedircv = gi.cvar("gamedir", "bop", CVAR_SERVERINFO);	// get our dir
  gamedir = gamedircv->string;

  strcpy(path, filename[0]);
  s = path;
  n = 0;
  while (s != NULL)
  {
   F = fopen(s, "r");	// open for read only...
   if (F)
   {
    gi.cprintf(0, PRINT_HIGH, "%s file found, processing...\n", s);
    ch = 0;
    i = 0;
    while (ch !=EOF)
	{	// ch = EOF at end of file OR an error...
      ch = getc(F);	// get a character...
      if ((ch == 10) || (ch == 13) || (i>BI_LENGTH-2))
		  // if the character is a carriage return, line feed
		  // or if the line is too long
	  {
		  s1[i] = 0; // terminate the string and get ready to process...
		  if (i)
		  {	// if the line isn't blank...
			  for (i=0; i<strlen(s1); i++)
			  {
				  if (s1[i]==' ')
				  {
					  break;
				  }
			  }
			  if (s1[0] != '/' && s1[1] != '/')
			  {	// check for, and ignore comments
				  if (i == strlen(s1))
				  {
					  process_bop_cmds(s1, NULL);	// no second arg...
				  }
				  else
				  {
					  j = 0;
					  s1[i++] = 0;	// terminate the s1 string...
					  while (s1[i])
					  {
						  cmd2[j++] = s1[i++];
					  }
					  cmd2[j] = 0;	// terminate the cmd2 string...
					  process_bop_cmds(s1, cmd2);
				  }
			  }
		  }
		  i = 0;
	  }
	  else
	  {
		  s1[i++] = ch;	// throw it in our string...
	  }
	};
	fclose(F);	// end of file, we're done...
	s = NULL;
   }
   else {
    gi.dprintf("%s file not found\n", s);
    if (strncmp(path, filename[n], strlen(filename[n]))==0)
	{
		// ie, if we tried without the path...
		strcpy(path, gamedir);
		strcat(path, "/");
		strcat(path, filename[n]);
		// then try with the path this time...
    }
    else if (strncmp(path, gamedir, strlen(gamedir))==0)
	{
		// ie, if we tried it WITH the path...
		n++;
		if (n<=BI_FILENAMES-1)
		{
			strcpy(path, filename[n]);	// start over with a new file
		}
		else
		{
			s = NULL;
			gi.dprintf("No bop.ini or bop.cfg file found, using defaults\n");
		}
    }
    else
	{
		s = NULL;
		gi.dprintf("BUG IN bopinit() PLEASE REPORT TO bop@planetquake.com\n");
    }
   }	// end else
  };

// Post-Conditions: BOP cvar set so our Gamespy tab will work nicely

}



void check_effects(edict_t *ent)
{

	// cause client to flash blue or red
	// (see pro_hpb and anti_lpb functions)

  if (!bop_invisible)
	// no fx if the mod is invisible
  {
	  if (ent->client->strength_framenum > level.framenum)
	  {
		  ent->s.effects |= EF_QUAD;
	  }
	  if (ent->client->resistance_framenum > level.framenum)
	  {
		  ent->s.effects |= EF_PENT;
	  }
	  if (lagged_out(ent) && !pent_from_lag(ent))
		  // show lagged-out players as ghosts
	  {
		  ent->s.renderfx |= RF_TRANSLUCENT;
	  }
  }

}



qboolean bop_showicon(edict_t *ent)
{

// Display the quad/pent in the corner if they are getting lag help

  gclient_t *client = ent->client;
  qboolean result = true;

  if (client->strength_framenum > level.framenum)
  {
    client->ps.stats[STAT_SELECTED_ICON] = gi.imageindex("p_quad");
  }
  else if (client->resistance_framenum > level.framenum)
  {
    client->ps.stats[STAT_SELECTED_ICON] = gi.imageindex("p_invulnerability");
  }
  else
  {
    result = false;
  }

  return(result);

}



void check_4_lagpent(edict_t *attacker, edict_t *target)
{

// Purpose of function: To alert people of a lag sick player that
//	they may be attacking

// Pre-Conditions: None that aren't obvious

  if ((attacker->client) && (!bop_invisible))
  {
	  if (pent_from_lag(target) && lag_msg(attacker))
	  {
		  gi.sound(attacker, CHAN_VOICE, gi.soundindex("misc/secret.wav"), 1, ATTN_NORM, 0);
		  if (!target->client->bop_i[0])
		  {  // if target didn't become an observer
			  if (lagged_out(target))
			  {
				  gi.centerprintf(attacker, "%s is frozen!\n", target->client->pers.netname);
			  }
			  else
			  {
				  gi.centerprintf(attacker, "%s has lag sickness\n\n(type 'bophelp' for more info)", target->client->pers.netname);
			  }
		  }
	  }
  }

// Post-Conditions: If target has lag pent, informs attacker of such

}


qboolean adjust_resistance(edict_t *attacker, edict_t *target, int *dmg) {

// Returns 1 if the user should get some resistance help
// Returns 0 if user is on his/her own
// d returns the normal suggested damage value (100 for railgun)

// Pre-Conditions: attacker and target MUST exist

// NOTE: This only takes into account the weapon of the attacker
// If the attacker is using a railgun, no resistance is granted

  char *weap = "";
  qboolean result = true;

  if (attacker->client->pers.weapon)
  {
	weap = attacker->client->pers.weapon->classname;

	if (Q_stricmp(weap,"weapon_railgun")==0)
	{
		*dmg = 100;	// normal railgun damage is 100...
		if (bop_verbose) {
			gi.cprintf(target, PRINT_HIGH, "Damage to you will be at least %d (railgun)\n", *dmg);
			gi.cprintf(attacker, PRINT_HIGH, "Damage to your target at least %d (railgun)\n", *dmg);
		}
		result = false;	// don't give them any extra resistance
	}
  }

  return(result);

}


void reset_bop_counters(edict_t *ent)
{

// called from player_die() inside p_client.c

	gclient_t *client = ent->client;

	client->strength_framenum = 0;
	client->resistance_framenum = 0;
	client->protecthpb_framenum = 0;	// no lag sickness when dead
	if (bopsickremove)
	{
		ent->svflags &= ~SVF_NOCLIENT;	// make sure they're put back to normal
	}

}

void bophelp(edict_t *ent)
{

  if (!ent->client->bopmenu)
  {
    ent->client->bopmenu = 1;	// start them with help screen #1
    ent->client->showscores = true;
    refresh_bop_menu(ent);
    gi.unicast(ent, true);
  }
  else
  {
    adv_bop_menu(ent);
  }

}

void refresh_bop_menu(edict_t *ent)
{

  char string[1024];
  char s[81], s1[81];

  if ((bop_invisible) && (ent->client->bopmenu==1))
	ent->client->bopmenu = 2;	// skip first menu if it's invis...
  strcpy(string, "xv 32 yv 8 picn inventory yv 32 xv 64 string2 \"Balance of Power Help\" ");
  if (ent->client->bopmenu==1) {
   strcat(string, "yv 48 xv 64 string2 \"The Rules:\" ");
   strcat(string, "yv 64 xv 64 string \"High ping players may\" ");
   strcat(string, "yv 72 xv 64 string \"inflict more damage and\" ");
   strcat(string, "yv 80 xv 64 string \"absorb extra damage when\" ");
   strcat(string, "yv 88 xv 64 string \"they fight LPB's.\" ");
   strcat(string, "yv 104 xv 64 string \"HPB's flash red and blue\" ");
   strcat(string, "yv 112 xv 64 string \"to indicate resistance\" ");
   strcat(string, "yv 120 xv 64 string \"and strength adjustments\" ");
   strcat(string, "yv 128 xv 64 string \"respectively.\" ");
   strcat(string, "yv 144 xv 104 string2 \"--Press Enter--\" ");
  }
  else if (ent->client->bopmenu==2) {
    strcat(string, "yv 48 xv 64 string2 \"Lag Sickness:\" ");
    strcat(string, "yv 64 xv 64 string \"If you experience unusual\" ");
    strcat(string, "yv 72 xv 64 string \"lag, BoP will protect you\" ");
    strcat(string, "yv 80 xv 64 string \"from enemy attacks for a\" ");
    strcat(string, "yv 88 xv 64 string \"certain period of time.\" ");
    strcat(string, "yv 104 xv 64 string \"The price of this shield\" ");
    strcat(string, "yv 112 xv 64 string \"is a condition called lag\" ");
    strcat(string, "yv 120 xv 64 string \"sickness which prevents\" ");
    strcat(string, "yv 128 xv 64 string \"weapon usage temporarily.\" ");
    strcat(string, "yv 144 xv 104 string2 \"--Press Enter--\" ");
  }
  else {
    strcat(string, "yv 48 xv 64 string2 \"Server Specific Settings:\" ");
    strcat(string, "yv 64 xv 64 string \"This server is set to\" ");
    get_mode_name(s);
    sprintf(s1, "yv 72 xv 64 string2 \"BOP %s mode\" ", s);
    strcat(string, s1);
    if (!laghelp_rst)
      strcat(string, "yv 88 xv 64 string \"HPB resistance is DISABLED\" ");
    else {
      sprintf(s, "yv 88 xv 64 string \"HPB resistance is %0.2f:1\" ", laghelp_rst+1);
      strcat(string, s);
    }
    if (!laghelp_str)
      strcat(string, "yv 104 xv 64 string \"HPB strength is DISABLED\" ");
    else {
      sprintf(s, "yv 104 xv 64 string \"HPB strength is %0.2f:1\" ", laghelp_str+1);
      strcat(string, s);
    }
    sprintf(s, "yv 128 xv 64 string \"After %0.1f seconds of\" ", (float) lagged_out_detect/10);
    strcat(string, s);
    strcat(string, "yv 136 xv 64 string \"phone-jack, you're\" ");
    strcat(string, "yv 144 xv 64 string \"lag sickness prone.\" ");
  }
  gi.WriteByte(svc_layout);
  gi.WriteString(string);

}

void adv_bop_menu(edict_t *ent) {

// advances the bop menu to the next section...

  ent->client->bopmenu++;
  if (ent->client->bopmenu > 3) {
	ent->client->bopmenu = 0;
	ent->client->showscores = 0;
  }
  else {
	refresh_bop_menu(ent);
	gi.unicast(ent, true);
  }

}

void bopreport(edict_t *ent) {

// gives the user the BOP report screen...

  ent->client->bopmenu = 3;	// start them on the report screen...
  ent->client->showscores = true;
  refresh_bop_menu(ent);
  gi.unicast(ent, true);

}

qboolean bop_client_cmds(edict_t *ent, char *cmd, char *sec_arg) {

// called by g_cmds.c to process client bop-specific commands

	if (Q_stricmp (cmd, "lagstats") == 0)
		Cmd_lagstats(ent);
	else if (Q_stricmp (cmd, "bophelp") == 0) {
	  if (!nobophelp)
	    bophelp(ent);
	  else {
	    if (lag_msg(ent))
	      gi.cprintf(ent, PRINT_HIGH, "Bop help menu disabled\n");
	  }
	}
	else
		return(false);	// unknown command...

	return(true);	// we found a command to execute..

}

qboolean process_bop_cmds(char *cmd, char *sec_arg) {

// called by g_svcmds.c to process bop specific commands
// also called by bopinit()

	strncpy(bop_twoarg, sec_arg, 80);	// copy the second arg into our
					// awaiting array...

	if (Q_stricmp (cmd, "laghelp_str") == 0)
		sv_laghelp_str();
	else if (Q_stricmp (cmd, "laghelp_rst") == 0)
		sv_laghelp_rst();
	else if (Q_stricmp (cmd, "nobophelp") == 0)
		sv_nobophelp();
	else if (Q_stricmp (cmd, "bopsickremove") == 0)
		sv_bopsickremove();
	else if (Q_stricmp (cmd, "laghelp") == 0)
		sv_laghelp_old();
	else if (Q_stricmp (cmd, "lagcap_str") == 0)
		sv_lagcap_str();
	else if (Q_stricmp (cmd, "lagcap_rst") == 0)
		sv_lagcap_rst();
	else if (Q_stricmp (cmd, "gamemode") == 0)
		sv_gamemode();
        else if (Q_stricmp (cmd, "pingmax") == 0)
                sv_pingmax();
        else if (Q_stricmp (cmd, "pingmin") == 0)
                sv_pingmin();
	else if (Q_stricmp (cmd, "lagbare") == 0)
		sv_lagbare();
	else if (Q_stricmp (cmd, "lagpent") == 0)
		sv_lagpent();
	else if (Q_stricmp (cmd, "lagsick") == 0)
		sv_lagsick();
	else if (Q_stricmp (cmd, "lagpeak") == 0)
		sv_lagpeak();
	else if (Q_stricmp (cmd, "lagtimeout") == 0)
		sv_lagtimeout();
	else if (Q_stricmp (cmd, "lagsuicide") == 0)
		sv_lagsuicide();
	else if (Q_stricmp (cmd, "lagslag") == 0)
		sv_lagslag();
	else if (Q_stricmp (cmd, "lagverbose") == 0)
		sv_verbose();
	else if (Q_stricmp (cmd, "laginvisible") == 0)
		sv_invisible();
	else if (Q_stricmp (cmd, "bopmanageobservers") == 0)
		sv_bopmanageobservers();
	else if (Q_stricmp (cmd, "sv") == 0)
		gi.cprintf(0, PRINT_HIGH, "An 'sv' was received that should not be there, try again!\n");
	else
	  return(false);	// unknown command...

	return(true);	// otherwise, return true...

}

void sv_gamemode() {

  int i;
  char s[20];

  i = getargi();

  if ((i>2) || (i<0))
	i = 0;	// default to normal mode...

  game_mode = i;

  switch(i) {
	case 0:	// normal mode
		max_delta_ping = n_max_delta_ping;
		min_delta_ping = n_min_delta_ping;
		laghelp_str = n_laghelp_str;
		laghelp_rst = n_laghelp_rst;
		strcpy(s, "NORMAL");
		break;
	case 1: // expert mode
		max_delta_ping = x_max_delta_ping;
		min_delta_ping = x_min_delta_ping;
		laghelp_str = x_laghelp_str;
		laghelp_rst = x_laghelp_rst;
		strcpy(s, "EXPERT");
		break;
	case 2:	// tournament mode
		max_delta_ping = t_max_delta_ping;
		min_delta_ping = t_min_delta_ping;
		laghelp_str = t_laghelp_str;
		laghelp_rst = t_laghelp_rst;
		strcpy(s, "TOURNAMENT");
		break;
	default:
		gi.cprintf(0, PRINT_HIGH, "Bug in Gamemode func!\n");
		break;
  }
  gi.cprintf(0, PRINT_HIGH, "BOP is now set to %s mode.\n", s);

}

void sv_laghelp_str() {

  float f;

  f = getargf();
  if (f>=0)
	laghelp_str = f;

  gi.cprintf(NULL, PRINT_HIGH, "Strength bonus cannot exceed %f:1\n", laghelp_str+1);

  if (laghelp_str > 5)
	gi.cprintf(NULL, PRINT_HIGH,"Caution: High numbers may crash the server!\n");
  else if (laghelp_str > 1)
	gi.cprintf(NULL, PRINT_HIGH,"Caution: Much higher and lagged players can gib LPB's with a blaster\n");
  else if (!laghelp_str)
        gi.cprintf(NULL, PRINT_HIGH,"Notice: You have DISABLED HPB strength adjustment!\n");

}

void sv_laghelp_rst() {

  float f;

  f = getargf();
  if (f>=0)
	laghelp_rst = f;

  gi.cprintf(NULL, PRINT_HIGH, "Resistance bonus cannot exceed %f:1\n", laghelp_rst+1);

  if (laghelp_rst > 5)
	gi.cprintf(NULL, PRINT_HIGH,"Caution: High numbers may crash the server!\n");
  else if (laghelp_rst > 1)
	gi.cprintf(NULL, PRINT_HIGH,"Caution: Much higher and lagged players will be impossible to frag\n");
  else if (!laghelp_rst)
        gi.cprintf(NULL, PRINT_HIGH,"Notice: You have DISABLED HPB resistance adjustment!\n");

}

void sv_nobophelp() {

  int i;

  i = getargi();
  nobophelp = i;

  if (!i)
	gi.cprintf(NULL, PRINT_HIGH, "Bop Help Menu ENABLED\n");
  else
	gi.cprintf(NULL, PRINT_HIGH, "Bop Help Menu DISABLED\n");

}

void sv_bopsickremove() {

  int i;

  i = getargi();
  bopsickremove = i;

  if (i)
	gi.cprintf(NULL, PRINT_HIGH, "Lag sick players will become observers temporarily\n");
  else
	gi.cprintf(NULL, PRINT_HIGH, "Lag sick players will get stay visible\n");

}

void sv_laghelp_old() {

// Old laghelp, obsolete

  gi.cprintf(NULL, PRINT_HIGH, "Notice: sv laghelp is now an obsolete command.\n");
  gi.cprintf(NULL, PRINT_HIGH, "Try sv laghelp_str and sv laghelp_rst!\n");

}

void sv_lagcap_str() {

// Purpose: Sets the lag cap for strength


  gi.cprintf(NULL, PRINT_HIGH, "Lag strength cap is obsolete!  Use laghelp_str as your cap\n");

}

void sv_lagcap_rst() {

// Purpose: Sets the lag cap for resistance

  gi.cprintf(NULL, PRINT_HIGH, "Lag resistance cap is obsolete!  Use laghelp_rst as your cap\n");

}

void sv_pingmax() {

  int i;

  i = getargi();
  if (i>0)
    max_delta_ping = i;

  gi.cprintf(NULL, PRINT_HIGH, "Max Delta Ping is %d\n", max_delta_ping);

}

void sv_pingmin() {

  int i;

  i = getargi();
  if (i>0)
    min_delta_ping = i;

  gi.cprintf(NULL, PRINT_HIGH, "Min Delta Ping is %d\n", min_delta_ping);

}

void sv_lagbare() {

  int i;

  i = getargi();

  if (i)
	bop_deadtime = i*10;	// convert it to frames

  gi.cprintf(NULL, PRINT_HIGH, "LagBare time is %d seconds\n",((int)bop_deadtime/10));
  gi.cprintf(NULL, PRINT_HIGH, "Make sure you check the value of lagsick!\n");

}

void sv_lagpent() {

  int i;

  i = getargi();

  if (i)
	bop_getawaytime = i*10;

  gi.cprintf(NULL, PRINT_HIGH, "Lagpent will now last for %d seconds\n",(int)bop_getawaytime/10);
  gi.cprintf(NULL, PRINT_HIGH, "Make sure you check the value for lagsick!\n");

}

void sv_lagsick() {

  int i = getargi();

  if ((i) && (i<((bop_deadtime-bop_getawaytime)/10)))
	lagsicktime = bop_deadtime-bop_getawaytime-(i*10);
  else
	i = (bop_deadtime-bop_getawaytime-lagsicktime)/10;
  gi.cprintf(NULL, PRINT_HIGH, "Lagsick set for %d seconds (%f actual)\n",i, lagsicktime);

}

void sv_lagpeak() {

  int i = getargi();

  if (i)
	lag_threshold = i;
  gi.cprintf(NULL, PRINT_HIGH, "You'll get lag pent if your ping exceeds %d\n", lag_threshold);
  gi.cprintf(NULL, PRINT_HIGH, "See also 'sv lagtimeout'\n");

}

void sv_lagtimeout() {

  int i = getargi();

  if (i)
	lagged_out_detect = i;
  gi.cprintf(NULL, PRINT_HIGH, "Users will get lagpent after %d frames of ping-freeze (10 frames = 1 second)\n", lagged_out_detect);

}

void sv_lagsuicide() {

  char *s = "Suicide lag protection ";

  gi.cprintf(NULL, PRINT_HIGH, "%s", s);
  no_suicide_protect = !getargi();
  if (no_suicide_protect)
	gi.cprintf(NULL, PRINT_HIGH, "DISABLED\n");
  else
	gi.cprintf(NULL, PRINT_HIGH, "ENABLED\n");

}

void sv_lagslag() {

  char *s = "Lag non-player protection ";

  gi.cprintf(NULL, PRINT_HIGH, "%s", s);
  no_slag_protect = !getargi();
  if (no_slag_protect)
	gi.cprintf(NULL, PRINT_HIGH, "DISABLED\n");
  else
	gi.cprintf(NULL, PRINT_HIGH, "ENABLED\n");

}

void sv_verbose() {

  char *s = "Verbose messaging ";

  gi.cprintf(NULL, PRINT_HIGH, "%s", s);
  bop_verbose = getargi();
  if (bop_verbose)
    gi.cprintf(NULL, PRINT_HIGH, "ENABLED\n");
  else
    gi.cprintf(NULL, PRINT_HIGH, "DISABLED\n");

}

void sv_invisible() {

  char *s = "BOP Quake2 mod is now ";
  gi.cprintf(NULL, PRINT_HIGH, "%s", s);
  bop_invisible = getargi();
  if (bop_invisible)
    gi.cprintf(NULL, PRINT_HIGH, "INVISIBLE\n");
  else
    gi.cprintf(NULL, PRINT_HIGH, "VISIBLE\n"); 

}

void sv_bopmanageobservers() {

  int i;

  i = getargi();

  bopmanageobservers = i;
  gi.cprintf(0, PRINT_HIGH, "BOP Observer Managing is %i\n", i);

}

void Cmd_lagstats(edict_t *ent) {

// Used to get a cryptic dump of all bop config variables

  char s[250];

  if (lag_msg(ent)) {
    sprintf(s, "BoP running:\nLHS=%f\nLHR=%f\nLB=%f\nLPt=%f\nLPk=%d\nMiDP=%d MxDP=%d\nLS=%f\nNSuP=%d\nNSlP=%d\nLV=%d\nMI=%d\n",
    laghelp_str, laghelp_rst, bop_deadtime, bop_getawaytime, lag_threshold, min_delta_ping,
    max_delta_ping, lagsicktime, no_suicide_protect, no_slag_protect,
    bop_verbose, bop_invisible);

    gi.cprintf(ent, PRINT_HIGH, "%s",s); 
  }

}

float getargf() {

  char *s;

  s = bop_twoarg;

  return(atof(s));

}

int getargi() {

  char *s;

  s = bop_twoarg;

  return(atoi(s));

}


qboolean isBopInvisible()
// returns bop_invisible
{

	return(bop_invisible);

}


void LagObituary (edict_t *self, edict_t *inflictor, edict_t *attacker)
{
	int			mod;
	char		*message;
	char		*message2;
        qboolean	s_is_quad, a_is_quad=0;	// matt's addition
	qboolean	ff;


	if (self->client)
	  s_is_quad = (self->client->quad_framenum > level.framenum);
	if (attacker->client)
	  a_is_quad = (attacker->client->quad_framenum > level.framenum);
	// Matt's stuff here...

	if (coop->value && attacker->client)
		meansOfDeath |= MOD_FRIENDLY_FIRE;

	if (deathmatch->value || coop->value)
	{
		ff = meansOfDeath & MOD_FRIENDLY_FIRE;
		mod = meansOfDeath & ~MOD_FRIENDLY_FIRE;
		message = NULL;
		message2 = "";

		switch (mod)
		{
		case MOD_SUICIDE:
			message = "dies the lonely death";
			break;
		case MOD_FALLING:
			if (IsFemale(self))
			  message = "fell into her boots";
			else
			  message = "fell into his boots";
			break;
		case MOD_CRUSH:
			message = "was crushed like a grapefruit";
			break;
		case MOD_WATER:
			message = "forgot to grab a rebreather";
			break;
		case MOD_SLIME:
			message = "melted";
			break;
		case MOD_LAVA:
			message = "can't exist on slag alone";
			break;
		case MOD_EXPLOSIVE:
		case MOD_BARREL:
			message = "was blown up";
			break;
		case MOD_EXIT:
			message = "found a way out";
			break;
		case MOD_TARGET_LASER:
			message = "got abdominal surgery";
			break;
		case MOD_TARGET_BLASTER:
			message = "got electrocuted";
			break;
		case MOD_BOMB:
		case MOD_SPLASH:
		case MOD_TRIGGER_HURT:
			message = "died the death";
			break;
		}
		if (attacker == self)
		{
			switch (mod)
			{
			case MOD_HELD_GRENADE:
                                if (IsFemale(self))
                                  message = "got stuck to her grenade";
                                else
                                  message = "got stuck to his grenade";
				break;
			case MOD_HG_SPLASH:
			case MOD_G_SPLASH:
				message = "tried to put the pin back in";
				break;
			case MOD_R_SPLASH:
                                if (s_is_quad)
                                  message = "got too quad happy";
                                else
                                  message = "becomes bored with life";
				break;
			case MOD_BFG_BLAST:
                                message = "pointed the BFG the wrong way";
				break;
			default:
				if (IsFemale(self))
					message = "cracked her own pate";
				else
					message = "cracked his own pate";
				break;
			}
		}
		if (message)
		{
			gi.bprintf (PRINT_MEDIUM, "%s %s.\n", self->client->pers.netname, message);
			if (deathmatch->value)
                                self->client->resp.score--;     // lose a frag if you kill yourself
			self->enemy = NULL;
			return;
		}

		self->enemy = attacker;
		if (attacker && attacker->client)
		{
		// ie, if they don't have pent...
                  if (attacker->client->invincible_framenum<=level.framenum) {
			switch (mod)
			{
			case MOD_BLASTER:
				message = "was humiliated by";
                                message2 = "'s blaster";
				break;
			case MOD_SHOTGUN:
				message = "was picked-off by";
				break;
			case MOD_SSHOTGUN:
				message = "was blown away by";
				message2 = "'s super shotgun";
				break;
			case MOD_MACHINEGUN:
                                message = "was machine-gunned by";
				break;
			case MOD_CHAINGUN:
				message = "was sawn in half by";
				message2 = "'s chaingun";
				break;
			case MOD_GRENADE:
				message = "ate";
				message2 = "'s pineapple";
				break;
			case MOD_G_SPLASH:
                                message = "was snagged by";
				message2 = "'s grenade";
				break;
			case MOD_ROCKET:
                                if (a_is_quad) {
                                    if (IsFemale(self))
                                      message = "got her world rocked by";
                                    else
                                      message = "got his world rocked by";
                                    message2 = "'s quad rocket";
                                }
                                else if (self->health<-40) {
                                  message = "was gibbed by";
                                  message2 = "'s rocket";
				}
				else {
                                  message = "ate";
                                  message2 = "'s rocket";
				}
				break;
			case MOD_R_SPLASH:
                                if (a_is_quad) {
                                  message = "was obliterated by";
                                  message2 = "'s quad rocket";
                                }
                                else if (self->health<-40) {
				  message = "was gibbed into meat chunks by";
				  message2 = "'s rocket";
				}
				else {
				  message = "ate";
				  message2 = "'s rocket";
				}
				break;
			case MOD_HYPERBLASTER:
                                message = "was melted by";
				message2 = "'s hyperblaster";
				break;
			case MOD_RAILGUN:
				message = "was railed by";
				break;
			case MOD_BFG_LASER:
				message = "saw the pretty lights from";
				message2 = "'s BFG";
				break;
			case MOD_BFG_BLAST:
				if (a_is_quad) {
				  message = "didn't feel a thing as";
				  if (IsFemale(self))
				    message2 = "'s quad BFG ripped her body apart";
				  else
				    message2 = "'s quad BFG ripped his body apart";
				}
				else {
				  message = "intercepted";
				  message2 = "'s big green ball";
				}
				break;
			case MOD_BFG_EFFECT:
				if (a_is_quad) {
				  if (IsFemale(self)) {
				    message = "sprinted like a madwoman from";
				    message2 = "'s quad BFG and got vaporized for her trouble";
				  }
				  else {
				    message = "sprinted like a madman from";
				    message2 = "'s quad BFG and got vaporized for his trouble";
				  }
				}
				else {
				  message = "couldn't hide from";
				  message2 = "'s BFG";
				}
				break;
			case MOD_HANDGRENADE:
                                message = "played catch with";
                                message2 = "'s handgrenade";
				break;
			case MOD_HG_SPLASH:
				message = "cartwheeled over";
				message2 = "'s handgrenade";
				break;
			case MOD_HELD_GRENADE:
				message = "feels";
				message2 = "'s pain";
				break;
			case MOD_TELEFRAG:
				message = "was caught trespassing on";
				message2 = "'s pad";
				break;
			}
                  }
                  else {
                    if (IsFemale(attacker))
                      message = "forgot to run from pent-girl";
                    else
                      message = "forgot to run from pent-boy";
                  }
                  if (message)
                  {
				gi.bprintf (PRINT_MEDIUM,"%s %s %s%s\n", self->client->pers.netname, message, attacker->client->pers.netname, message2);
				if (deathmatch->value)
				{
					if (ff)
						attacker->client->resp.score--;
					else
                                                attacker->client->resp.score++;  // gain a point if you frag someone
				}
				return;
                  }
		}
	}

	gi.bprintf (PRINT_MEDIUM,"%s died.\n", self->client->pers.netname);
	if (deathmatch->value)
		self->client->resp.score--;
}
