#include "g_local.h"
#include "m_player.h"
#include "q_devels.h"

//===============================================================
//	Ball control functions: Jumpball and Inbounds
//===============================================================

#define IDLE_TIME 7

void Cmd_Ballmove_f (edict_t *ent)
{
	edict_t 	*ball = g_edicts;


	//find ball edicts
	for ( ; ball < &g_edicts[globals.num_edicts]; ball++)
	{
		if((!ball->inuse) || (Q_stricmp(ball->classname,"basketball") != 0))
			continue;
		if (ball->wait < IDLE_TIME)
		{
			gi.cprintf(ent, PRINT_HIGH, "Jumpball not allowed yet\n");
			return;
		}

		G_FreeEdict(ball);
		Jumpball();
		return;
	}
	gi.cprintf(ent, PRINT_HIGH	, "Ball not free\n");
}

void Cmd_Autoshoot_f (edict_t *ent)
{
	if(deathmatch->value)
		gi.cprintf(ent, PRINT_HIGH, "Server only can set autoshoot\n");
	else
	{
		if( (int)dmflags->value & DF_AUTO_SHOOT)
		{
			dmflags->value += DF_AUTO_SHOOT;
			gi.bprintf(PRINT_HIGH, "Autoshoot is off\n");
		}
		else
		{
			dmflags->value -= DF_AUTO_SHOOT;
			gi.bprintf(PRINT_HIGH, "Autoshoot is on\n");
		}
	}
}

void Jumpball()
{
	static int poss = TEAM1;

	if (poss == TEAM1)
	{
		gi.bprintf(PRINT_HIGH, "Jumpball, possession goes to %s\n",team1name->string);
		Inbound(TEAM1);
		poss = TEAM2;
	}
	else if (poss == TEAM2)
	{
		gi.bprintf(PRINT_HIGH, "Jumpball, possession goes to %s\n",team2name->string);
		Inbound(TEAM2);
		poss = TEAM1;
	}
}

qboolean Court_Zone (edict_t *ent)
{
	edict_t *zone;

	zone = G_Find (NULL, FOFS(classname), "func_court");
	
	if (!zone)
	{
		//gi.dprintf("No court zone found\n");
		return true;
	}
	
	//check to see if in zone box
	if (ent->s.origin[0] > zone->absmin[0])
		if (ent->s.origin[1] > zone->absmin[1])
			if (ent->s.origin[2] > zone->absmin[2])
				if (ent->s.origin[0] < zone->absmax[0])
					if (ent->s.origin[1] < zone->absmax[1])
						if (ent->s.origin[2] < zone->absmax[2])
							return true;
	
	return false;		// all clear
}

void Create_ball(int team)
{

	edict_t	*bball;
	edict_t *dest;

	if(team == TEAM1)
		dest = G_Find (NULL, FOFS(targetname), "inbound1");
	else if(team == TEAM2)
		dest = G_Find (NULL, FOFS(targetname), "inbound2");

	if (!dest)
	{
		gi.dprintf ("Couldn't find inbound destination\n");
		return;
	}
	
	bball = G_Spawn();
	VectorCopy (dest->s.origin, bball->s.origin);
	VectorSet (bball->avelocity, 300, 300, 300);
	bball->movetype = MOVETYPE_BALLBOUNCE;
	bball->clipmask = MASK_BBALL;
	bball->solid = SOLID_BBOX;
	VectorSet (bball->mins, 0,0,-10);
	VectorSet (bball->maxs, 0,0,0);
	bball->s.modelindex = gi.modelindex ("models/objects/bball/tris.md2");
	bball->owner = NULL;
	bball->touch = Basketball_Touch;
	bball->nextthink = level.time + .1;
	bball->think = Sitting_Think;
	bball->classname = "basketball";
	bball->spawnflags = 1;
	bball->timestamp = 0;
	bball->s.effects = EF_HYPERBLASTER;

	// draw the teleport splash at the destination
	bball->s.event = EV_PLAYER_TELEPORT;

	gi.linkentity (bball);

}

void Inbound(int team)
{
	int i;
	edict_t *player = g_edicts;
	edict_t *other = NULL;
	edict_t		*dest;

	//search for other team member on court first
	for (i = 0; i < game.maxclients; i++)
	{
		player++;
		if((!player->inuse) || (!player->client) || (player->health <= 0)
			|| (!Court_Zone(player)) )
			continue;
		if(player->client->resp.team == team)
		{
			other = player;
			break;
		}
	}

	//search for other team member anywhere
	for (i = 0; i < game.maxclients; i++)
	{
		player++;
		if((!player->inuse) || (!player->client) || (player->health <= 0))
			continue;
		if(player->client->resp.team == team)
		{
			other = player;
			break;
		}
	}

	//search for anyone
	if(!other)
	{
		if(deathmatch->value)
			gi.bprintf(PRINT_HIGH,"Found no one on other team to inbound\n");
		player = g_edicts;
		for(i=0;i < game.maxclients; i++)
		{
			player++;
			if((!player->inuse) || (!player->client) || (player->health <= 0))
				continue;
			other = player;
			break;
		}
	}
	
	//no one is found, make new ball
	if(!other)
	{
		gi.bprintf(PRINT_HIGH, "Found no one to inbound ball\n");
		Create_ball(team);
		return;
	}

	//give them ball
	if (other->client->pers.inventory[ITEM_INDEX(FindItem("BasketBalls"))] == 0)//M.S.Fix use add_ammo?
		other->client->pers.inventory[ITEM_INDEX(FindItem("Basketballs"))]++;

	//don't teleport in single player, so we're done
	if(!deathmatch->value)
		return;

	if(team == TEAM1)
		dest = G_Find (NULL, FOFS(targetname), "inbound1");
	else
		dest = G_Find (NULL, FOFS(targetname), "inbound2");

	if (!dest)
	{
		gi.dprintf ("Couldn't find inbound destination\n");
		return;
	}

	// unlink to make sure it can't possibly interfere with KillBox
	gi.unlinkentity (other);

	VectorCopy (dest->s.origin, other->s.origin);
	VectorCopy (dest->s.origin, other->s.old_origin);
	other->s.origin[2] += 9;

	// clear the velocity and hold them in place briefly
	VectorClear (other->velocity);
	other->client->ps.pmove.pm_time = 160>>3;		// hold time
	other->client->ps.pmove.pm_flags |= PMF_TIME_TELEPORT;

	// draw the teleport splash at the destination
	other->s.event = EV_PLAYER_TELEPORT;

	// set angles
	for (i=0 ; i<3 ; i++)
		other->client->ps.pmove.delta_angles[i] = ANGLE2SHORT(dest->s.angles[i] - other->client->resp.cmd_angles[i]);

	other->s.angles[PITCH] = 0;
	other->s.angles[YAW] = dest->s.angles[YAW];
	other->s.angles[ROLL] = 0;
	VectorCopy (dest->s.angles, other->client->ps.viewangles);
	VectorCopy (dest->s.angles, other->client->v_angle);

	// kill anything at the destination
	if (!KillBox (other))
	{
	}

	//change their weapon to hands
	other->client->newweapon = FindItem("Hands");
	ChangeWeapon(other);
	
	gi.linkentity (other);
}


//==============================================================
//	BBall Weapons
//==============================================================

//From p_weapon.c, needed in functions
void P_ProjectSource (gclient_t *client, vec3_t point, vec3_t distance, vec3_t forward, vec3_t right, vec3_t result)
{
	vec3_t	_distance;

	VectorCopy (distance, _distance);
	if (client->pers.hand == LEFT_HANDED)
		_distance[1] *= -1;
	else if (client->pers.hand == CENTER_HANDED)
		_distance[1] = 0;
	G_ProjectSource (point, _distance, forward, right, result);
}

#define BBALL_TIMER			3.0
#define BBALL_MINSPEED		400.0
#define BBALL_MAXSPEED		800.0
#define STEAL_RANGE 		50.0
#define PICKUP_RANGE		50.0

void Weapon_Bball (edict_t *ent)
{
	qboolean hasball;
	
	if(ent->client->pers.inventory[ent->client->ammo_index])
		hasball = true;
	else
		hasball = false;
	
	if (ent->client->weaponstate == WEAPON_DROPPING)
	{
		if (ent->client->ps.gunframe == BBALL_DEACTIVATE_LAST
			|| ent->client->ps.gunframe == HAND_DEACTIVATE_LAST)
		{
			ChangeWeapon (ent);
			return;
		}
		//for vwep (Hentai)
		else if((BBALL_DEACTIVATE_LAST - ent->client->ps.gunframe) == 4
			|| (HAND_DEACTIVATE_LAST - ent->client->ps.gunframe) == 4)
		{
			ent->client->anim_priority = ANIM_REVERSE;
			if(ent->client->ps.pmove.pm_flags & PMF_DUCKED)
			{
				ent->s.frame = FRAME_crpain4+1;
				ent->client->anim_end = FRAME_crpain1;
			}
			else
			{
				ent->s.frame = FRAME_pain304+1;
				ent->client->anim_end = FRAME_pain301;
				
			}
		}
		//vwep

		ent->client->ps.gunframe++;
		return;
	}

	if (ent->client->weaponstate == WEAPON_ACTIVATING)
	{
		if(!hasball && ent->client->ps.gunframe == 0)
			ent->client->ps.gunframe = HAND_ACTIVATE_FIRST;
				
		if (ent->client->ps.gunframe == BBALL_ACTIVATE_LAST)
		{
			ent->client->weaponstate = WEAPON_READY;
			ent->client->ps.gunframe = BBALL_IDLE_FIRST;
			return;
		}
		if (ent->client->ps.gunframe == HAND_ACTIVATE_LAST)
		{
			ent->client->weaponstate = WEAPON_READY;
			ent->client->ps.gunframe = HAND_IDLE_FIRST;
			return;
		}

		ent->client->ps.gunframe++;
		return;
	}
	
	if ((ent->client->newweapon) && (ent->client->weaponstate != WEAPON_FIRING))
	{
		ent->client->weaponstate = WEAPON_DROPPING;
		if(hasball)
			ent->client->ps.gunframe = BBALL_DEACTIVATE_FIRST;
		else
			ent->client->ps.gunframe = HAND_DEACTIVATE_FIRST;
		
		return;
	}

	if (ent->client->weaponstate == WEAPON_READY)
	{
		if (hasball && ent->client->ps.gunframe > HAND_FIRE_LAST)
			ent->client->ps.gunframe = BBALL_IDLE_FIRST;

		if (!hasball && ent->client->ps.gunframe < HAND_FIRE_FIRST)
			ent->client->ps.gunframe = HAND_IDLE_FIRST;
		
		if ( ((ent->client->latched_buttons|ent->client->buttons) & BUTTON_ATTACK) )
		{
			ent->client->latched_buttons &= ~BUTTON_ATTACK;
			if (hasball)
			{
				ent->client->ps.gunframe = BBALL_FIRE_FIRST + 1;
				ent->client->weaponstate = WEAPON_FIRING;
				ent->client->bball_time = 0;
				
				ent->client->anim_priority = ANIM_ATTACK;
				if (ent->client->ps.pmove.pm_flags & PMF_DUCKED)
				{
					//ent->s.frame = FRAME_crattak1-1;
					//ent->client->anim_end = FRAME_crattak9;
				}
				else
				{
					ent->s.frame = FRAME_ballshot1-1;
					ent->client->anim_end = FRAME_ballshot4;
				}

			}
			else
			{
				ent->client->ps.gunframe = HAND_FIRE_FIRST + 1;
				ent->client->weaponstate = WEAPON_STEALING;

			}
			return;
		}

		if(ent->client->ps.gunframe == HAND_IDLE_LAST)
			return;

		// Ridah, added, with lower volume, and attenuation
		if(ent->client->ps.gunframe == BBALL_DRIBBLE_FRAME)
			gi.sound (ent, CHAN_WEAPON, gi.soundindex ("weapons/bball1a.wav"), 0.2, 3, 0);
		
		if (++ent->client->ps.gunframe > BBALL_IDLE_LAST)
			ent->client->ps.gunframe = BBALL_IDLE_FIRST;
	
		// Ridah, if running, speed up 
		if (VectorLength( ent->velocity ) > 160)
		{
			// Ridah, added, with lower volume, and attenuation
			if(ent->client->ps.gunframe == BBALL_DRIBBLE_FRAME)
				gi.sound (ent, CHAN_WEAPON, gi.soundindex ("weapons/bball1a.wav"), 0.2, 3, 0);

			if (++ent->client->ps.gunframe > BBALL_IDLE_LAST)
				ent->client->ps.gunframe = BBALL_IDLE_FIRST;
		}
		
		return;
	}

	if (ent->client->weaponstate == WEAPON_FIRING)
	{

		if (ent->client->ps.gunframe == BBALL_FIRE_FIRST + 1)
		{
			if (!ent->client->bball_time)
			{
				ent->client->bball_time = level.time + BBALL_TIMER + 0.2;
			}
			// they waited too long, fire it
			if (!ent->client->grenade_blew_up && level.time >= ent->client->bball_time)
			{
				ent->client->weapon_sound = 0;
				ent->client->grenade_blew_up = true;
			}

			if (ent->client->buttons & BUTTON_ATTACK && !ent->client->grenade_blew_up
				&& !((int)dmflags->value & DF_AUTO_SHOOT))
			{
          		if (!(ent->client->ps.pmove.pm_flags & PMF_DUCKED))
					ent->s.frame = FRAME_ballshot2;
				ent->client->ball_meter++;
				return;
			}

			if (ent->client->grenade_blew_up)
			{
				if (level.time >= ent->client->bball_time)
				{
					ent->client->ps.gunframe = BBALL_FIRE_FIRST + 2;
					ent->client->grenade_blew_up = false;
				}
				else
				{
					return;
				}
			}
		}

		if (ent->client->ps.gunframe == BBALL_FIRE_FIRST + 2)
		{
			ent->client->ball_meter = 0;
			ent->client->weapon_sound = 0;
			weapon_bball_fire (ent);
		}

		if ((ent->client->ps.gunframe == BBALL_FIRE_LAST) && (level.time < ent->client->bball_time))
			return;

		if ((ent->client->ps.gunframe == BBALL_FIRE_LAST) && (!hasball))
		{
			ent->client->ps.gunframe = HAND_IDLE_FIRST;
			ent->client->weaponstate = WEAPON_READY;
			return;
		}

		ent->client->ps.gunframe++;


		if (ent->client->ps.gunframe == BBALL_IDLE_FIRST)
			ent->client->weaponstate = WEAPON_READY;
	}

	if (ent->client->weaponstate == WEAPON_STEALING)
	{
		if(ent->client->ps.gunframe > HAND_FIRE_FIRST + 4
			&& ent->client->ps.gunframe < HAND_FIRE_FIRST + 9)
			weapon_bball_steal(ent);

		ent->client->ps.gunframe++;
		if(ent->client->ps.gunframe == HAND_IDLE_FIRST)
			ent->client->weaponstate = WEAPON_READY;
	}
}

#define OPEN_FOR_DUNK 100.0

qboolean dunk_check (edict_t *ent)
{
	int i;
	edict_t *blip;

	for (i=0; i<maxclients->value; i++)
	{
		vec3_t vec;

		blip = &g_edicts[i+1];

		if (!blip->inuse)
			continue;
		if (blip->health <= 0)
			continue;

		VectorSubtract( ent->s.origin, blip->s.origin, vec );
		
		if ((VectorLength( vec ) < OPEN_FOR_DUNK)
			&& (blip->client->resp.team != ent->client->resp.team))
			return false;
	}

	return true;
}

void weapon_bball_dunk (edict_t *ent, edict_t *rim)
{
	int i;
	vec3_t rim_front, point, forward;
	
	//find rim front
	AngleVectors(rim->s.angles,forward,NULL,NULL);
	VectorInverse(forward);
	VectorScale(forward, 48, point);
	VectorAdd(rim->s.origin, point, rim_front);
	
	// unlink to make sure it can't possibly interfere with stuff
	gi.unlinkentity (ent);
	
	// set angles
	for (i=0 ; i<3 ; i++)
		ent->client->ps.pmove.delta_angles[i] = ANGLE2SHORT(rim->s.angles[i] - ent->client->resp.cmd_angles[i]);
	
	ent->s.angles[PITCH] = 0;
	ent->s.angles[YAW] = rim->s.angles[YAW];
	ent->s.angles[ROLL] = 0;
	VectorCopy (rim->s.angles, ent->client->ps.viewangles);
	VectorCopy (rim->s.angles, ent->client->v_angle);

	//move player to front of rim
	ent->s.origin[0] = rim_front[0];
	ent->s.origin[1] = rim_front[1];
	ent->s.old_origin[0] = rim_front[0];
	ent->s.old_origin[1] = rim_front[1];
	
	// clear the velocity
	VectorClear (ent->velocity);
	ent->client->ps.pmove.pm_time = 160>>3;	// hold time
	ent->client->ps.pmove.pm_flags |= PMF_TIME_TELEPORT;
	
	gi.linkentity(ent);

	//jump now (according to height difference)
	//M.S.Fix (this should consider acceleration, but close enough?)
	ent->velocity[2] = 3.5*(rim_front[2] - ent->s.origin[2]);

	//play dunk animation
	ent->client->anim_priority = ANIM_DUNK;
	ent->s.frame = FRAME_balldunk01;
	ent->client->anim_end = FRAME_balldunk10;
}

#define DUNK_RANGE 75.0

void weapon_bball_fire (edict_t *ent)
{
	edict_t	*rim;
	vec3_t point1, point2, length;
	vec3_t	offset;
	vec3_t	forward, right;
	vec3_t	start;
	float	distance;
	float	timer;
	float	speed;
	vec3_t	shooter;
	float	diff;

	VectorSet(offset, 8, 8, ent->viewheight-8);
	AngleVectors (ent->client->v_angle, forward, right, NULL);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);
	
	timer = ent->client->bball_time - level.time;
	speed = BBALL_MINSPEED + (BBALL_TIMER - timer) * ((BBALL_MAXSPEED - BBALL_MINSPEED) / BBALL_TIMER);

	VectorCopy (ent->s.origin, shooter);
	
	//find distance
	if (ent->client->resp.team == TEAM1)
		rim = G_Find (NULL, FOFS(targetname), "rim1");
	else
		rim = G_Find (NULL, FOFS(targetname), "rim2");

	if (!rim)
	{
		gi.dprintf ("Couldn't find rim marker\n");
	}
	else
	{
		VectorCopy(start, point1);
		point1[2] = 0;
		VectorCopy(rim->s.origin, point2);
		point2[2] = 0;
		
		VectorSubtract(point2, point1, length);
		distance = VectorLength(length);
	}
	
	//do dunk if close enough
	if ( !((int)dmflags->value & DF_NO_DUNKS) && distance < DUNK_RANGE
		&& dunk_check(ent) && rim)
	{
		weapon_bball_dunk(ent, rim);
		return;
	}
		
	//separate modes
	if ( (int)dmflags->value & DF_AUTO_SHOOT)
	{
		vec3_t temp, l_angles;
		float angle, height, random, p_angle;
	
		if (!rim)
		{
			gi.dprintf ("Must have rim marker for autoshoot\n");
			gi.sound (ent, CHAN_BODY, gi.soundindex ("player/male/bump1.wav"), 1, ATTN_NORM, 0);
			return;
		}
	
		vectoangles(length, l_angles);
		p_angle = anglemod(ent->s.angles[1] - l_angles[1]);
	
		if (p_angle < 45 || p_angle > 315)
		{
			if (distance < 125.0)
				angle = (4*M_PI)/9.0;
			else if (distance < 225.0)
				angle = (7.0*M_PI)/18.0;
			else if (distance < 425.0)
				angle = M_PI/3.0;
			else
				angle = (5*M_PI)/18.0;

			VectorNormalize2(length, temp);
			temp[2] = tan(angle);
			VectorNormalize2(temp, forward);
			height = rim->s.origin[2] - start[2] + 36;

			if (d_bball->value)
				gi.bprintf(PRINT_HIGH, "Real distance: %f Height: %f Angle: %f\n",distance, height, angle);
	
			if (distance < 350)
				distance += distance * .01;
			else
				distance += distance * .025;

			speed = distance / (cos(angle)*sqrt(2.0*(1.0/sv_gravity->value)*(distance*tan(angle)-height)));

			if (difficulty->value > 10)
				diff = 10;
			else if (difficulty->value < 0)
				diff = 0;
			else
				diff = difficulty->value;

			random = ((random()/10.0) - .05) * ((3.0/10.0) * (diff + 1) + (7.0/10.0));
			speed += distance * random;
		
			if(speed > BBALL_MAXSPEED)
				speed = BBALL_MAXSPEED;
			
			if (d_bball->value)
				gi.bprintf(PRINT_HIGH, "Fixed distance: %f Speed %f Random: %f\n",distance, speed, random);
	
			fire_bball(ent, start, forward, speed, shooter, true);
			ent->client->pers.inventory[ent->client->ammo_index]--;
			ent->client->bball_time = level.time + 1.0;
		}
		else
		{
			fire_bball (ent, start, forward, speed, shooter, false);
			ent->client->pers.inventory[ent->client->ammo_index]--;
			ent->client->bball_time = level.time + 1.0;
		}

	}
	else
	{
		fire_bball (ent, start, forward, speed, shooter, false);
		ent->client->pers.inventory[ent->client->ammo_index]--;
		ent->client->bball_time = level.time + 1.0;
	}
}

void Cmd_Passball_f (edict_t *ent)
{
	vec3_t	offset, temp;
	vec3_t	forward, right;
	vec3_t	start;
	vec3_t	shooter;

	if (ent->client->weaponstate == WEAPON_FIRING  ||
		ent->client->anim_priority == ANIM_DUNK)
		return;
		
	if ((Q_stricmp (ent->client->pers.weapon->pickup_name,"Hands") == 0)
		&& (ent->client->pers.inventory[ent->client->ammo_index] > 0))
	{
		VectorSet(offset, 8, 8, ent->viewheight-8);
		VectorCopy(ent->client->v_angle,temp);
		temp[0] = -15.0;
		AngleVectors (temp, forward, right, NULL);
		P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);
		VectorCopy (ent->s.origin, shooter);

		fire_bball (ent, start, forward, 800, shooter, true);

		ent->client->pers.inventory[ent->client->ammo_index]--;
	}
}


// Fire_bball function
void fire_bball (edict_t *self, vec3_t start, vec3_t aimdir, float speed, vec3_t shooter, qboolean autoshot)
{
	edict_t	*bball;
	vec3_t	dir;
	vec3_t	forward, right, up;

	vectoangles (aimdir, dir);
	AngleVectors (dir, forward, right, up);

	bball = G_Spawn();
	VectorCopy (shooter, bball->pos1);
	VectorCopy (start, bball->s.origin);
	VectorScale (aimdir, speed, bball->velocity);
	if (!autoshot)
	{
		VectorMA (bball->velocity, 200 + crandom() * 10.0, up, bball->velocity);
		VectorMA (bball->velocity, crandom() * 10.0, right, bball->velocity);
	}
	VectorSet (bball->avelocity, 300, 300, 300);
	bball->movetype = MOVETYPE_BALLBOUNCE;
	bball->clipmask = MASK_BBALL;
	bball->solid = SOLID_BBOX;
	VectorSet (bball->mins, 0,0,-10);
	VectorSet (bball->maxs, 0,0,0);
	bball->s.modelindex = gi.modelindex ("models/objects/bball/tris.md2");
	bball->owner = self;
	bball->touch = Basketball_Touch;
	bball->nextthink = level.time + .1;
	bball->think = Sitting_Think;
	bball->classname = "basketball";
	bball->spawnflags = 1;
	bball->timestamp = 0;
	if(deathmatch->value)
		bball->s.effects = EF_HYPERBLASTER;

	gi.sound (self, CHAN_WEAPON, gi.soundindex ("weapons/hgrent1a.wav"), 1, ATTN_NORM, 0);
	gi.linkentity (bball);
}


void weapon_bball_steal(edict_t *ent)
{
	vec3_t	offset;
	vec3_t	forward, right;
	vec3_t	start;

	VectorSet(offset, 8, 8, ent->viewheight-8);
	AngleVectors (ent->client->v_angle, forward, right, NULL);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

	steal_bball (ent, start, forward);
}


void steal_bball(edict_t *ent, vec3_t start, vec3_t aimdir)
{
	trace_t 	tr; //detect whats in front of you up to range "vec3_t end"
	vec3_t 	end;

	// Figure out what is in front of us, if anything
	VectorMA (start, STEAL_RANGE, aimdir, end);  //calculates the range vector
	tr = gi.trace (ent->s.origin, NULL, NULL, end, ent, MASK_SHOT);
								// figures out what is in front of the player up till "end"
	// Figure out what to do about what we hit, if anything
	if (tr.fraction < 1.0)
	{
		if (tr.ent->client && tr.ent->health > 0)
		{
			if (tr.ent->client->pers.inventory[ITEM_INDEX(FindItem("Basketballs"))])
			{
				//check some conditions
				if(tr.ent->client->pers.weapon &&
					(Q_stricmp (tr.ent->client->pers.weapon->pickup_name,"Hands") == 0))
				{
					if(tr.ent->client->anim_priority == ANIM_DUNK)
						return;
					if(tr.ent->client->weaponstate == WEAPON_FIRING)
						return;
				}				
				
				//steal ball
				tr.ent->client->pers.inventory[ITEM_INDEX(FindItem("Basketballs"))]--;
				if (ent->client->pers.inventory[ITEM_INDEX(FindItem("BasketBalls"))] == 0)//M.S.Fix use add_ammo?
					ent->client->pers.inventory[ITEM_INDEX(FindItem("Basketballs"))]++;
			}
		}
	}
}


//===============================================================
//	Basketball Actions
//===============================================================

static void Basketball_Touch (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	int points;
	
	if (surf && (surf->flags & SURF_SLICK))
	{
		if (surf->value == 1)
		{
			points = PointValue(TEAM1,ent->pos1);
			level.ballteam1 += points;
			gi.bprintf(PRINT_HIGH, "%s scores %i points for the %s\n",ent->owner->client->pers.netname ,points, team1name->string);
			ent->owner->client->resp.score += points;
			G_FreeEdict (ent);
			Inbound(TEAM2);
			return;
		}
		else if (surf->value == 2)
		{
			points = PointValue(TEAM2,ent->pos1);
			level.ballteam2 += points;
			gi.bprintf(PRINT_HIGH, "%s scores %i points for the %s\n",ent->owner->client->pers.netname, points, team2name->string);
			ent->owner->client->resp.score += points;
			G_FreeEdict (ent);
			Inbound(TEAM1);
			return;
		}
	}

	if (!other->takedamage || !other->client)
	{
		gi.sound (ent, CHAN_VOICE, gi.soundindex ("weapons/bball1a.wav"), 1, ATTN_NORM, 0);
		return;
	}

	if (other->client->pers.inventory[ITEM_INDEX(FindItem("BasketBalls"))] == 0)//M.S.Fix use add_ammo?
		other->client->pers.inventory[ITEM_INDEX(FindItem("Basketballs"))]++;//add ball M.S.

	G_FreeEdict (ent);
}

static void Sitting_Think (edict_t *ent)
{
	edict_t *blip = NULL;
	static int message = 1;
	int i;

	ent->think = Sitting_Think;

	if (!ent->timestamp)
	{
		ent->timestamp = level.time;
		message = 1;
	}

	// Ridah, modified for speed
	for (i=0; i<maxclients->value; i++)
	{
		vec3_t vec;

		blip = &g_edicts[i+1];

		if (!blip->inuse)
			continue;
		if (blip->health <= 0)
			continue;

		VectorSubtract( ent->s.origin, blip->s.origin, vec );
		if (VectorLength( vec ) > PICKUP_RANGE)
			continue;
		//check for owner first so we don't crash!
		if ((ent->owner) && (blip->s.number == ent->owner->s.number) && ((level.time - ent->timestamp) < .5))
			continue;
		if (blip->client->pers.inventory[ITEM_INDEX(FindItem("BasketBalls"))] == 0)//M.S.Fix use add_ammo?
			blip->client->pers.inventory[ITEM_INDEX(FindItem("Basketballs"))]++;//add ball M.S.

		G_FreeEdict (ent);

		return;
	}
	// Ridah, done.

	ent->wait = level.time - ent->timestamp;
	if (ent->wait > IDLE_TIME && message)
	{
		gi.bprintf(PRINT_HIGH, "Call jumpball if basketball is stuck\n");
		message = 0;
	}

	ent->nextthink = level.time + .1;

}


#define THREE_DISTANCE	350

int PointValue(int team, vec3_t shooter)
{
	//find point value of shot
	edict_t	*rim;
	vec3_t length,point1,point2;

	if (team == TEAM1)
		rim = G_Find (NULL, FOFS(targetname), "rim1");
	else
		rim = G_Find (NULL, FOFS(targetname), "rim2");

	if (!rim)
	{
		gi.dprintf ("Couldn't find rim marker\n");
		return 2;
	}
	else
	{
		VectorCopy(shooter, point1);
		point1[2] = 0;
		VectorCopy(rim->s.origin, point2);
		point2[2] = 0;

		VectorSubtract(point1, point2, length);
		
		if (VectorLength(length) >= THREE_DISTANCE)
			return 3;
		else
			return 2;
	}
}


//================================================================
//	Court, Scoreboard and begin game drop ball
//================================================================

/*QUAKED func_court (.5 .5 .5) ?
court area

*/
void func_court_think(edict_t *self)
{
	int i;
	edict_t *blip;
	
	if(!((int)dmflags->value & DF_KEEP_IN_COURT))
		return;
	
	for (i=0; i<maxclients->value; i++)
	{
		blip = &g_edicts[i+1];

		if (!blip->inuse)
			continue;
		if (blip->health <= 0)
			continue;
		
		//see if player with ball is in court
		if(blip->client->pers.inventory[ITEM_INDEX(FindItem("BasketBalls"))]
			&& !Court_Zone(blip))
		{
			// remove ball, kill him, then inbound
			blip->client->pers.inventory[ITEM_INDEX(FindItem("BasketBalls"))] = 0;
			
			T_Damage (blip, blip, blip, vec3_origin, blip->s.origin, vec3_origin, 100000, 0, DAMAGE_NO_PROTECTION, MOD_BALL_LEAVE);

			if(blip->client->resp.team == TEAM1)
				Inbound(TEAM2);
			else
				Inbound(TEAM1);
		}
	}

	//half-second should be enough
	self->nextthink = level.time + .5;
}

void SP_func_court(edict_t *self)
{
	if(!deathmatch->value)
	{
		self->think = NULL;
		return;
	}
	
	gi.setmodel (self, self->model);
	self->svflags = SVF_NOCLIENT;

	self->think = func_court_think;

	self->nextthink = level.time + .5;
}

/*QUAKED func_scoreclock (0 0 1) (-8 -8 -8) (8 8 8) TIMER_UP TIMER_DOWN START_OFF MULTI_USE
target a target_string with this

*/

#define	CLOCK_MESSAGE_SIZE	16

// don't let field width of any clock messages change, or it
// could cause an overwrite after a game load

static void func_scoreclock_format_countdown (edict_t *self)
{
	int minutes, seconds, countdown;

	countdown = (60*timelimit->value - (level.time - self->timestamp));

	if(countdown >0)
	{
		minutes = countdown/60;
		seconds = countdown%60;
	}
	else
	{
		minutes = seconds = 0;
	}
	
	Com_sprintf(self->message, CLOCK_MESSAGE_SIZE, "%2i:%2i", minutes, seconds);

	if (self->message[3] == ' ')
		self->message[3] = '0';
}

void func_scoreclock_think (edict_t *self)
{
	func_scoreclock_format_countdown (self);
	
	if (!self->enemy)
	{
		self->enemy = G_Find (NULL, FOFS(targetname), self->target);
		if (!self->enemy)
			return;
	}

	self->enemy->message = self->message;
	self->enemy->use (self->enemy, self, self);

	self->nextthink = level.time + 1;
}

void SP_func_scoreclock (edict_t *self)
{
	if (!self->target)
	{
		gi.dprintf("%s with no target at %s\n", self->classname, vtos(self->s.origin));
		G_FreeEdict (self);
		return;
	}

	self->message = gi.TagMalloc (CLOCK_MESSAGE_SIZE, TAG_LEVEL);
	self->timestamp = level.time;

	self->think = func_scoreclock_think;
	self->nextthink = level.time + 1;
}

/*QUAKED func_score (0 0 1) (-8 -8 -8) (8 8 8)
target a target_string with this

"style"	1	Team1's Score
		2	Team2's Score

*/

#define	CLOCK_MESSAGE_SIZE	16

// don't let field width of any clock messages change, or it
// could cause an overwrite after a game load

static void func_score_format_countdown (edict_t *self)
{
	if (self->style == 1)
	{
		Com_sprintf (self->message, CLOCK_MESSAGE_SIZE, "%3i", level.ballteam1);
		return;
	}
	else if (self->style == 2)
		Com_sprintf (self->message, CLOCK_MESSAGE_SIZE, "%3i", level.ballteam2);
}

void func_score_think (edict_t *self)
{
	func_score_format_countdown (self);
	
	if (!self->enemy)
	{
		self->enemy = G_Find (NULL, FOFS(targetname), self->target);
		if (!self->enemy)
			return;
	}

	self->enemy->message = self->message;
	self->enemy->use (self->enemy, self, self);
	
	self->nextthink = level.time + 1;
}

void SP_func_score (edict_t *self)
{
	if (!self->target)
	{
		gi.dprintf("%s with no target at %s\n", self->classname, vtos(self->s.origin));
		G_FreeEdict (self);
		return;
	}

	self->message = gi.TagMalloc (CLOCK_MESSAGE_SIZE, TAG_LEVEL);

	self->think = func_score_think;

	self->nextthink = level.time + 1;
}


/*QUAKED misc_dropball (0 0 1) (-8 -8 -8) (8 8 8)
*/

void misc_dropball_drop(edict_t *self)
{
	edict_t	*bball;

	bball = G_Spawn();
	VectorCopy (self->s.origin, bball->s.origin);
	VectorSet (bball->avelocity, 300, 300, 300);
	bball->movetype = MOVETYPE_BALLBOUNCE;
	bball->clipmask = MASK_BBALL;
	bball->solid = SOLID_BBOX;
	VectorSet (bball->mins, 0,0,-10);
	VectorSet (bball->maxs, 0,0,0);
	bball->s.modelindex = gi.modelindex ("models/objects/bball/tris.md2");
	bball->owner = self;
	bball->touch = Basketball_Touch;
	bball->nextthink = level.time + .1;
	bball->think = Sitting_Think;
	bball->classname = "basketball";
	bball->spawnflags = 1;
	bball->timestamp = 0;
	bball->s.effects = EF_HYPERBLASTER;

	gi.linkentity (bball);
}

void misc_dropball_timer(edict_t *self)
{
	static int timer = 10;
	int i;
	edict_t *joe_bloggs;

	if (!--timer)
	{
		misc_dropball_drop(self);
		return;
	}

	//for next map
	if (timer < 0 )
		timer = 9;

	for_each_player(joe_bloggs,i)
	{
		gi.centerprintf (joe_bloggs, "Jumpball in %i seconds\n", timer);
	}
		
	self->nextthink = level.time + 1;
}


void misc_dropball_think(edict_t *self)
{
	int size1 = 0;
	int size2 = 0;
	int i;
	
	for (i = 0; i < maxclients->value; i++)
	{
		if (!g_edicts[i+1].inuse)
			continue;
		if (game.clients[i].resp.team == TEAM1)
			size1++;
		else if (game.clients[i].resp.team == TEAM2)
			size2++;
	}	
	
	if( (int)dmflags->value & DF_EVEN_JUMPBALL)
	{
		if((size1 && size2) || d_bball->value)
			self->think = misc_dropball_timer;
	}
	else if(size1 || size2 || d_bball->value)
		self->think = misc_dropball_timer;

	self->nextthink = level.time + 1;
}

void SP_misc_dropball (edict_t *self)
{
	if (!deathmatch->value)
	{
		G_FreeEdict (self);
		return;
	}
	else
	{
		self->think = misc_dropball_think;
		self->nextthink = level.time + 1;
	}
}
