/*
 *Tic Tac Toe 1.2 Copyright(C) 2000 Joseph Garvin
 *Written By: Tetrazome
 *Made in Y2K (Like everyone else's, my computer exploded)
 *RELEASED UNDER GNU GENERAL PUBLIC LICENSE
 *This program was succesfully debugged and completed on 2-7-Y2K (1.0 on 2-2-Y2K)
 *Feel free to edit this source code and play with it, but acknowledge ownership and copyright!
 *However, please read gnu.txt for information on the limitations to distribution.
 *(gnu.txt is included in zip file this source code came with)
 *
 *444 lines of code, compared to v1.0's 782. (including comments)
*/

#include <iostream.h>
#include <stdlib.h>
#include <time.h>
#include "tttai2.hpp"

void main()
{
	char board[9]; //The board
	char player = '0'; //Current active player
	char player1 = '0'; //First player
	char player2 = '0'; //Second player
	char comp = '0'; //Computer player
	char keepplaying = '0'; // Keep playing?
	USHORT stale = 0; //Turns on if stalemate
	USHORT win = 0; //Turns on if someone won
	char gofirst = 0; //Human or computer goes first?
	char mode = 0; //Used to decide mode, p vs p or p vs c

	do
	{

	for(USHORT count = 0; count < 9; count++) //The manual loop
	{
		board[count] = '0' + count;
	}

	srand((unsigned)time(0));//Activates random for computer's random character

	cout << "TicTacToe 1.1\nBy: Tetrazome\nChoose mode\n";
	cout << "\n1. Player vs. Player\n2. Player vs. Computer (Always wins or ties)\n\n";

	do
	{
	cin >> mode;
	}while(mode != '1' && mode != '2');

	if(mode == '1')
	{
			cout << "Now pick your character. (instead of plain 'o X and Os.\n";
			cout << "But don't pick 0-8!\n\n";
			cout << "Player 1, please choose a character by entering a letter.\n";
			do
			{
				cin >> player1;
			}while(!Check08(board, player1));
			cout << "Player 2, please choose a character by entering a letter.\n";
			do
			{
				cin >> player2;
			}while(!Check08(board, player2));
	}

	if(mode == '2')
	{
		cout << "\nWho will go first, you or the computer?\n";
		cout << "\n1. Player\n2. Computer\n";

		do
		{
		cin >> gofirst;
		}while(gofirst != '1' && gofirst != '2');

		cout << "\nThe computer will randomly choose a character: ";
		do
		{
			comp = (char) rand() % 256; //Randomly generates computer character
		}while(!Check08(board, comp));
		cout << comp;

		cout << "\nHuman, pick your character.\n";
		do
		{
			cin >> player2;
		}while(!Check08(board, player2));
	}

	if(gofirst == '0' || gofirst == '1')
	{
		player = player2;
	}

	if(gofirst == '2')
	{
		player = comp;
	}

	do
	{
		cout << "\n";
		DrawBoard(board);
		cout << "Go Player " << player << "\n";

		if(mode == '1')
			Input(board, player, player1, player2);

		if(mode == '2' && player == player2)
			Input(board, player, comp, player2);

		if(mode == '2' && player == comp)
			AI(board, comp, player2);

		win = CheckWin(board, player);
		stale++;

		if(stale == 9)
		{
			win = 2;
		}

		if(!win)
		{
			switch(mode)
			{
				case '1':

				if(player == player1) //Switches players
					player = player2;
				else
					player = player1;

				break;

				case '2':

				if(player == comp)
					player = player2;
				else
					player = comp;

				break;
			}
		}
	}while(!win);

	if(CheckWin(board, player) == 1)
	{
		cout << "\n";
		DrawBoard(board);
		cout << player << " wins!\n\n";

		cout << "Would you like to play again?\n";

		cin >> keepplaying;
	}
	else
	{
		cout << "\n";
		DrawBoard(board);
		cout << "You tied, you're too smart for each other.\n\n";

		cout << "Would you like to play again? (Y, N)\n";

		cin >> keepplaying;
	}

	}while(keepplaying == 'Y');
}

void Input(char board[], const char player, const char player1, const char player2)
{
	char move = 0;

	do
	{
		cin >> move;
	}while( (board[move] == player1 || board[move] == player2) && (move > '8' || move < '0') );

	board[move] = player;
}

void DrawBoard(const char board[])
{ 
	 for(USHORT count = 0; count < 3; count++)
    { 
		  for(USHORT count2 = 0; count2 < 3; count2++)
        {
				cout << "|" << board[count * 3 + count2];
		  }
        cout << "|";
		  cout << "\n-------\n";
	 }
}

USHORT CheckWin(const char board[], const char player)
{
	for(USHORT count = 0; count <= 6; count+=3)
	{
		if((board[count] == player && board[count+1] == player && board[count+2] == player) || (board[count] == player && board[count+3] == player && board[count+6] == player))
		{
			return 1;
		}
	}

	if((board[0] == player && board[4] == player && board[8] == player) || (board[2] == player && board[4] == player && board[6] == player))
	{
		return 1;
	}

   return 0;
}

USHORT Check08(const char board[], const char playerX)
{
	for(USHORT count = 0; count < 9; count++)
	{
		if(board[count] == playerX)
		{
			return 0;
		}
	}

	return 1;
}

USHORT AI(char board[], const char comp, const char player2)
{
	USHORT count = 0;

   /////////Start left to right/////////
	for(count = 0; count <= 6; count += 3)
	{
		if( (board[count] == player2) && (board[count+1] == player2) && (board[count+2] != comp && board[count+2] != player2) )
		{
			board[count+2] = comp;
			return 0;
		}//Checking for player

		if( (board[count] == comp) && (board[count+1] == comp) && (board[count+2] != comp && board[count+2] !=player2) )
		{

			board[count+2] = comp;
			return 0;
		}//Checking for computer
	}
	/////////End left to right/////////

   /////////Start right to left/////////
	for(count = 2; count <= 8; count += 3)
	{
		if( (board[count] == player2) && (board[count - 1] == player2) && (board[count - 2] != comp && board[count - 2] != player2) )
		{
			board[count - 2] = comp;
	 		return 0;
		}//Checking for player

		if( (board[count] == comp) && (board[count - 1] == comp) && (board[count - 2] != comp && board[count - 2] !=player2) )
		{
			board[count - 2] = comp;
			return 0;
		}//Checking for computer
	}
	/////////End right to left/////////

	/////////Start top to bottom/////////
	for(count = 0; count <= 2; count++)
	{
		if( (board[count] == player2) && (board[count + 3] == player2) && (board[count + 6] != comp && board[count + 6] != player2) )
		{
					board[count + 6] = comp;
					return 0;
		}

		if( (board[count] == comp) && (board[count + 3] == comp) && (board[count + 6] != comp && board[count + 6] != player2) )
		{
			board[count + 6] = comp;
			return 0;
		}
	}
   /////////End top to bottom/////////


	/////////Start bottom to top/////////
	for(count = 6; count <= 8; count++)
	{
		if( (board[count] == player2) && (board[count - 3] == player2) && (board[count - 6] != comp && board[count - 6] != player2) )
		{
			board[count - 6] = comp;
			return 0;
		}//Checking for player

		if( (board[count] == comp) && (board[count - 3] == comp) && (board[count - 6] != comp && board[count - 6] != player2) )
		{
			board[count - 6] = comp;
			return 0;
		}//Checking for computer
	}
   /////////End bottom to top/////////


	/////////Start top left to bottom right/////////
	count = 2;
	if( (board[count] == player2) && (board[count + 2] == player2) && (board[count + 4] != comp && board[count + 4] != player2) )
	{
		board[count + 4] = comp;
		return 0;
	}//Checking for player
															 
	if( (board[count] == comp) && (board[count + 2] == comp) && (board[count + 4] != comp && board[count + 4] != player2) )
	{
		board[count + 4] = comp;
		return 0;
	}//Checking for computer
	/////////End top left to bottom right/////////


	/////////Start top right to bottom left/////////
	count = 0;
	if( (board[count] == player2) && (board[count + 4] == player2) && (board[count + 8] != comp && board[count + 8] != player2) )
	{
		board[count + 8] = comp;
		return 0;
	}// Checking for player

	if( (board[count] == comp) && (board[count + 4] == comp) && (board[count + 8] != comp && board[count + 8] != player2) )
	{
		board[count + 8] = comp;
		return 0;
	}// Checking for computer
   /////////End of top right to bottom left/////////


	count = 8;
	if( (board[count] == player2) && (board[count - 4] == player2) && (board[count - 8] != comp && board[count - 8] != player2) )
	{
		board[count - 8] = comp;
		return 0;
	}

	if( (board[count] == comp ) && (board[count - 4] == comp) && (board[count - 8] != comp && board[count - 8] != player2) )
	{
		board[count - 8] = comp;
		return 0;
	}//For checking bottom left to top right


	/////////Start between top and bottom/////////
   count = 6;
	for(count = 6; count <= 8; count++)
	{
		if( (board[count] == player2) && (board[count - 6] == player2) && (board[count - 3] != comp && board[count - 3] != player2))
		{
			board[count - 3] = comp;
			return 0;
		} //For checking player

		if( (board[count] == comp) && (board[count - 6] == comp) && (board[count - 3] != comp && board[count - 3] != player2) )
		{
			board[count - 3] = comp;
			return 0;
		} //For checking computer
	}
   /////////End between top and bottom/////////


	/////////Start between left and right/////////
	for(count = 0; count <= 6; count += 3)
	{
		if( (board[count] == player2) && (board[count + 2] == player2) && (board[(count + 2)/2] != comp && board[(count + 2)/2] != player2) )
		{
			board[(count + 2)/2] = comp;
			return 0;
		} //For checking player

		if( (board[count] == comp) && (board[count + 2] == comp) && (board[(count + 2)/2] != comp && board[(count + 2)/2] != player2) )
		{
			board[(count + 2)/2] = comp;
			return 0;
		} //For checking computer
	}
   /////////End between left and right/////////


	/////////Start between top left and bottom right/////////
	count = 0;
	if(board[count] == player2 && board[count + 8] == player2 && board[(count + 8)/2] != comp && board[(count + 8)/2] != player2)
	{
		board[(count + 8)/2] = comp;
		return 0;
	} //For checking player

	count = 6;
	if(board[count] == player2 && board[count + 2] == player2 && board[(count + 2)/2] != comp && board[(count + 2)/2] != player2)
	{
		board[(count + 2)/2] = comp;
		return 0;
	} //For checking computer
	/////////End between top left and bottom right/////////


	/////////Start bottom right to top left/////////
	count = 6;
	if( (board[count] == player2) && (board[count - 2] == player2) && (board[count - 4] != comp) )
	{
		board[count - 4] = comp;
		return 0;
	} //For checking player

	if( (board[count] == comp) && (board[count - 2] == comp) && (board[count - 4] != comp && board[count - 4] != player2) )
	{
		board[count - 4] = comp;
		return 0;
	} //For checking computer
	/////////End bottom right to top left/////////


	if(board[4] != comp && board[4] != player2)
	{
		board[4] = comp;
		return 0;
	} //Take the center if not taken!


	srand((USHORT)time(0)); //Activate Randimization

	count = 0;
	do //If no advantageous move, go randomly
	{
		count = rand() % 9; //Randomize between 0 and 8
	} while(board[count] == comp || board[count] == player2);

	board[count] = comp;
	return 0;
}
