#include "newproject.h"

#define VERSION "1.0"

int main (int argc, char *argv[])
{
  char basepath[1024];
  int  localedit = 0; //edit the g_local.h file?
  int  publicedit = 0; //edit the bg_local.h file?
  int  overwrite = 0; //overwrite an existing mod?
  
  msg(va("NewMod %s by Mark \"WarZone\" Smeltzer", VERSION));
  msg("--------------------------------------\n");

  //get and store the starting directory
  getbasepath(argv[0], basepath, 1024); //right now this isn't even being used.. but it might be useful later
 
  if (argc < 4)
  {
    helpmsg();
  } else {
    char *current;
    int i = 4;

    for (i = 4; i < argc; i++) {
      current = strlwr(argv[i]);
      msg(current);
      if (strcmp("localedit", current) == 0)
      {
        localedit = 1;
      } 
      else if (strcmp("publicedit", current) == 0)
      {
        publicedit = 1;
      }
      else if (strcmp("overwrite", current) == 0)
      {
        overwrite = 1;
      }
    }
    
    if (badsource()) {
      errormsg(ERROR_BAD_SOURCE);
    } else {

      if (!direxists(argv[ARG_Q3_PATH]))
      { //make sure the path to Q3A exists
        errormsg(ERROR_BAD_Q3_PATH);
      } 
      else if (subdirexists(argv[ARG_MOD_NAME], argv[ARG_Q3_PATH]) && !overwrite) 
      { //test to see if the mod already exists!
        errormsg(ERROR_BAD_MOD_NAME);
      }
      else
      { //start coping stuff over,,
        if (subdirexists(argv[ARG_MOD_NAME], argv[ARG_Q3_PATH]))
        {
          char in = '\0';
          msg(va("%s is about to be overwritten. Are you sure you want to do this? [Y / N]", argv[ARG_MOD_NAME]));
          
          while (in != 'N' && in != 'n' && in != 'Y' && in != 'y')
            in = getch();

          if (in == 'N' || in == 'n')
          {
            msg("Aborting..");
            return 0; //premature exit
          }
        }
        
        msg("Creating directories...");
        msg(va("  %s\\%s", argv[ARG_Q3_PATH], argv[ARG_MOD_NAME]));

        // only continue if the mod path is created successfully
        if (createsubdir(argv[ARG_MOD_NAME], argv[ARG_Q3_PATH]) || overwrite)
        {
          //create the main mod directory...
          msg(va("  %s", argv[ARG_MOD_PATH]));
          createdir(argv[ARG_MOD_PATH]);

          //create the sub directories
          msg(va("  %s\\game", argv[ARG_MOD_PATH]));
          createsubdir("game", argv[ARG_MOD_PATH]);
          msg(va("  %s\\cgame", argv[ARG_MOD_PATH]));
          createsubdir("cgame", argv[ARG_MOD_PATH]);
          msg(va("  %s\\ui", argv[ARG_MOD_PATH]));
          createsubdir("ui", argv[ARG_MOD_PATH]);

          msg("\n=============\n");

          //copy over the source files
          msg("Copying Project files..");
          copyfiles(copyPROJECTfiles, argv[ARG_MOD_PATH], "");
          msg("Copying Server files..");
          copyfiles(copyGAMEfiles, argv[ARG_MOD_PATH], "game");
          msg("Copying Client files..");
          copyfiles(copyCGAMEfiles, argv[ARG_MOD_PATH], "cgame");
          msg("Copying User Interface files..");
          copyfiles(copyUIfiles, argv[ARG_MOD_PATH], "ui");

          msg("\n=============\n");
          
          //create new q3asm script files
          msg("Creating new compilation scripts..");
          createq3asm(buildGAMEfiles, argv[ARG_MOD_PATH], argv[ARG_Q3_PATH], argv[ARG_MOD_NAME], "game", "qagame");
          createq3asm(buildCGAMEfiles, argv[ARG_MOD_PATH], argv[ARG_Q3_PATH], argv[ARG_MOD_NAME], "cgame", "cgame");
          createq3asm(buildUIfiles, argv[ARG_MOD_PATH], argv[ARG_Q3_PATH], argv[ARG_MOD_NAME], "ui", "ui");

          msg("\n=============\n");
          
          //create a play it.bat to load the mod
          msg("Creating \"play it.bat\"...");
          newstartbatch (argv[ARG_MOD_NAME], argv[ARG_MOD_PATH], argv[ARG_Q3_PATH]);

          msg("\n=============\n");

          if (localedit)
          {
            msg("Searching g_local.h for GAMEVERSION definition...");
            if (updatedefinition (va("%s\\game\\g_local.h", argv[ARG_MOD_PATH]), "GAMEVERSION", argv[ARG_MOD_NAME]) == 1)
            {
              msg("Updating g_local.h...");
              msg("Done.");
            } else {
              msg("Not found. You will need to manually edit this file.");
              getch();
            }

            msg("\n=============\n");
          }

          if (publicedit)
          {
            msg("Searching bg_public.h for GAME_VERSION definition...");
            if (updatedefinition (va("%s\\game\\bg_public.h", argv[ARG_MOD_PATH]), "GAME_VERSION", va("%s-1",argv[ARG_MOD_NAME])) == 1)
            {
              msg("Updating bg_public.h...");
              msg("Done.");
            } else {
              msg("Not found. You will need to manually edit this file.");
              getch();
            }

            msg("\n=============\n");
          }

          //all done!
          msg("Task complete");
        } else {
          errormsg(ERROR_UNKNOWN); //couldnt create the mod directory?
        }
      }
    }
  }
  
  return 0;
}

/*
============
va

does a varargs printf into a temp buffer, so I don't need to have
varargs versions of all text functions.
FIXME: make this buffer size safe someday
============

Ripped from Quake2 source... I use this function in all my projects!
I did make one slight modification, I added an array of buffers, rather than one buffer.
*/
typedef char astring[1024];
#define VA_BUFFER_SIZE 20
char *va(char *format, ...)
{
	va_list		argptr;
  static int counter;
	static astring buffer[VA_BUFFER_SIZE];
	
	counter = (counter + 1) % VA_BUFFER_SIZE;

  va_start (argptr, format);
	vsprintf (buffer[counter], format,argptr);
	va_end (argptr);

  return buffer[counter];	
}

//generic print function..
void msg (char *text)
{
  printf("%s\n", text);
}

//help text that is displayed when improper input is given
void helpmsg (void)
{
  msg("Program syntax:");
  msg("newmod <modname> <sourcepath> <q3path> <options..>\n");
  msg("Example:");
  msg("newmod mymod c:\\mymod C:\\\"Program Files\"\\\"Quake III Arena\"\n");
  msg("This would create a new code set from the current source code in the");
  msg("path \"c:\\mymod\" and add a \"mymod\" directory to your Q3A directory.");
  msg("\nValid Options:");
  msg("overwrite  - allows NewMod to overwrite an existing mod. Not Recommended.");
  msg("localedit  - NewMod will edit the g_local.h file to set GAMEVERSION properly.");
  msg("   If NewMod doesn't make this edit, you must do so by hand. To run your mod,");
  msg("   Q3A requires that GAME_VERSION be set to your mod's \"modname\". Recommended.");
  msg("publicedit - NewMod will edit the bg_public.h file to set GAME_VERSION properly");
  msg("   Changing this variable is required by, and only by, mods which make");
  msg("   changes to the cgame, or ui modules. Not Recommended.");
}

//this function checks the current directory structure for the required source files
//return 1 if invalid source
//return 0 if valid
int badsource (void)
{ //FIXME: a better test would be to check the build*.dat
  if (direxists("game") && 
      direxists("cgame") &&
      direxists("ui"))
    return 0;
  return 1;
}

//lets the user know if an error has occured.
void errormsg (int error)
{
  char *out;
  
  switch (error) {
  case ERROR_BAD_SOURCE:
    out = "The source code is invalid. Please install a fresh copy of the source code and try again.";
    break;
  case ERROR_BAD_MOD_NAME:
    out = "The mod name you have chosen already exists in your Q3A directory. Please choose a different name.";
    break;
  default:
    out = "Unknown error.";
  }

  msg("The following error was encountered:");
  msg(out);
}

/*======
returns a 1 if a path exists
======*/
int direxists(char *path)
{
  char dir[1024];
  int retval;

  getcwd(dir, 1024);

  retval = chdir(path);
  
  //return to previous directory
  chdir(dir);

  return retval == 0;
}

//returns a 1 if a directory exists in a given path
int subdirexists(char *dir, char *path)
{
  return direxists(va("%s\\%s", path, dir));
}

//attempts to create a new directory
int createdir (char *path)
{
  return mkdir(path) == 0;
}

//attempts to create a new directory in a given path
int createsubdir (char *dir, char *path)
{
  return createdir(va("%s\\%s", path, dir));
}

/*========
Copies files listed in the filelist to modpath\dir
========*/
void copyfiles(char *filelist, char *path, char *dir)
{
  FILE *input;
  char filename[80];
  FILE *in;
  FILE *out;
  char buffer[512];

  input = fopen(filelist, "r");
  
  while (fgets (filename, sizeof(char) * sizeof(filename), input) != NULL)
  {
    //remove the last character because its a line break
    filename[strlen(filename) - 1] = '\0';

    if (strlen(filename) < 2)
      continue; // a while name has to be at least 2 chars long, prevents crashes

    if (strlen(dir) > 0)
    {
      in = fopen(va("%s\\%s", dir, filename), "r");
      out = fopen(va("%s\\%s\\%s", path, dir, filename), "w+");
    } else {
      in = fopen(filename, "r");
      out = fopen(va("%s\\%s", path, filename), "w+");
    }
    if (in != NULL && out != NULL)
    {
      while (fgets (buffer, sizeof(char) * sizeof(buffer), in) != NULL)
        fputs(buffer, out);

      fclose(in);
      fclose(out);
      msg(va("  %s Copied", filename));
    } else {
      msg(va("  Error copying %s", filename));
    }
  }

  fclose (input);
}

/*========
Creates a dir.q3asm in modpath\dir file that will compile filelist and put the QVM in q3path\modname
========*/
void createq3asm(char *filelist, char *modpath, char *q3path, char *modname, char *dir, char *qvm)
{
  FILE *input;
  FILE *out;
  char buffer[512];

  input = fopen(filelist, "r");

  out = fopen(va("%s\\%s\\%s.q3asm", modpath, dir, dir), "w+");
    
  fputs (va("-o \"%s\\%s\\vm\\%s\"\n", q3path, modname, qvm), out);
  /*==========
  Outputs: -o "q3path\modname\qvm" 
  ==========*/
  
  while (fgets (buffer, sizeof(char) * sizeof(buffer), input) != NULL)
    fputs(buffer, out);

  fclose (out);
  fclose (input);
}

//not used currently, but still a cool function.
void getbasepath (char *prog, char *path, int length)
{
  getcwd(path, length);
/*  
  //the following code work's but has a different effect
  //it returns the path to the executable rather than the current working directory
  int size = strlen(prog);
  char *curr = prog;
  int i;

  for (i = 0; i < size && i < length - 1; i++)
    curr++;
  
  while (*curr != '\\')
  {
    curr--;
    size--;
  }

  strncpy(path, prog, size);

  curr = path;
  for (i = 0; i < size; i++)
    curr++;
  
  *curr = '\0';
*/
}

/*========
Creates a play it.bat file that will load the new mod into Q3A
========*/
void newstartbatch (char *modname, char *modpath, char *q3path)
{
  FILE *out;

  out = fopen(va("%s\\play it.bat", modpath), "w+");
    
  fputs("@echo off\n", out);
  fputs(va("%c:\n", q3path[0]), out);
  fputs(va("cd %s\n", q3path), out);
  fputs(va("quake3.exe +set fs_game \"%s\"\n", modname), out);
    
  fclose (out);
}

typedef char oneline[512];

typedef struct {
  int lines;
  char **text;
} file_t;

void readfile (file_t *file, char *filename)
{
  FILE *fp;
  oneline buffer;
  int i = 0;

  memset(file, 0, sizeof(file_t));

  fp = fopen(filename, "r");

  while (fgets (buffer, sizeof(char) * sizeof(buffer), fp) != NULL)
    file->lines++;
  
  file->text = (char **) malloc(sizeof(char *) * file->lines);
  for (i = 0; i < file->lines; i++)
    file->text[i] = (char *) malloc(sizeof(char) * sizeof(oneline));

  //start at the beginning of the file
  fseek (fp, (long) 0, 0);

  i = 0;
  while (fgets (buffer, sizeof(char) * sizeof(buffer), fp) != NULL)
    strcpy((*file).text[i++], buffer);

  fclose(fp);
}

void savefile (file_t *file, char *filename)
{
  FILE *fp;
  int i;

  fp = fopen(filename, "w+");
  
  if (fp == NULL)
  {
    msg(va("couldn't open %s!?", filename));
    return;
  }

  for (i = 0; i < file->lines; i++)
  {
    if (file->text[i] != NULL && strlen(file->text[i]) > 0)
      fputs(file->text[i], fp);
  }

  fclose(fp);
}

int updatedefinition (char *filename_temp, char *definition, char *newvalue_temp)
{
  file_t file;
  int i;
  int found = 0;
  oneline filename;
  oneline newvalue;

  strcpy (filename, filename_temp);
  strcpy (newvalue, newvalue_temp);

  readfile (&file, filename);

  for (i = 0; i < file.lines; i++)
  {
    if (strncmp(file.text[i], va("#define %s ", definition), strlen(va("#define %s ", definition))) == 0 || //space, space
        strncmp(file.text[i], va("#define\t%s\t", definition), strlen(va("#define\t%s\t", definition))) == 0 || //tab, tab
        strncmp(file.text[i], va("#define\t%s ", definition), strlen(va("#define\t%s ", definition))) == 0 ||  //tab, space
        strncmp(file.text[i], va("#define %s\t", definition), strlen(va("#define %s\t", definition))) == 0)  //space, tab
    { //found a #define... time to update it
      strcpy(file.text[i], va("#define\t%s\t\"%s\"\n", definition, newvalue));
      found = 1;
      break; //assuming it is #define'ed only once
    }
  }

  savefile (&file, filename);

  return found;
}

