#include "newproject.h"

#define VERSION "1.0"

int main (int argc, char *argv[])
{
  char basepath[1024];
  
  
  msg(va("NewMod %s by Mark \"WarZone\" Smeltzer", VERSION));
  msg("--------------------------------------\n");

  //get and store the starting directory
  getbasepath(argv[0], basepath, 1024); //right now this isn't even being used.. but it might be useful later
 
  if (argc != 4)
  {
    helpmsg();
  } else {

    if (badsource()) {
      errormsg(ERROR_BAD_SOURCE);
    } else {

      if (!direxists(argv[ARG_Q3_PATH]))
      { //make sure the path to Q3A exists
        errormsg(ERROR_BAD_Q3_PATH);
      } 
      else if (subdirexists(argv[ARG_MOD_NAME], argv[ARG_Q3_PATH])) 
      { //test to see if the mod already exists!
        errormsg(ERROR_BAD_MOD_NAME);
      }
      else
      { //start coping stuff over,,
        msg("Creating directories...");
        msg(va("  %s\\%s", argv[ARG_Q3_PATH], argv[ARG_MOD_NAME]));

        // only continue if the mod path is created successfully
        if (createsubdir(argv[ARG_MOD_NAME], argv[ARG_Q3_PATH]))
        {
          //create the main mod directory...
          msg(va("  %s", argv[ARG_MOD_PATH]));
          createdir(argv[ARG_MOD_PATH]);

          //create the sub directories
          msg(va("  %s\\game", argv[ARG_MOD_PATH]));
          createsubdir("game", argv[ARG_MOD_PATH]);
          msg(va("  %s\\cgame", argv[ARG_MOD_PATH]));
          createsubdir("cgame", argv[ARG_MOD_PATH]);
          msg(va("  %s\\ui", argv[ARG_MOD_PATH]));
          createsubdir("ui", argv[ARG_MOD_PATH]);

          msg("\n=============\n");

          //copy over the source files
          msg("Copying Project files..");
          copyfiles(copyPROJECTfiles, argv[ARG_MOD_PATH], "");
          msg("Copying Server files..");
          copyfiles(copyGAMEfiles, argv[ARG_MOD_PATH], "game");
          msg("Copying Client files..");
          copyfiles(copyCGAMEfiles, argv[ARG_MOD_PATH], "cgame");
          msg("Copying User Interface files..");
          copyfiles(copyUIfiles, argv[ARG_MOD_PATH], "ui");

          msg("\n=============\n");
          
          //create new q3asm script files
          msg("Creating new compilation scripts..");
          createq3asm(buildGAMEfiles, argv[ARG_MOD_PATH], argv[ARG_Q3_PATH], argv[ARG_MOD_NAME], "game", "qagame");
          createq3asm(buildCGAMEfiles, argv[ARG_MOD_PATH], argv[ARG_Q3_PATH], argv[ARG_MOD_NAME], "cgame", "cgame");
          createq3asm(buildUIfiles, argv[ARG_MOD_PATH], argv[ARG_Q3_PATH], argv[ARG_MOD_NAME], "ui", "ui");

          msg("\n=============\n");
          
          //create a play it.bat to load the mod
          msg("Creating \"play it.bat\"...");
          newstartbatch (argv[ARG_MOD_NAME], argv[ARG_MOD_PATH], argv[ARG_Q3_PATH]);

          msg("\n=============\n");

          //all done!
          msg("Task complete");
        } else {
          errormsg(ERROR_UNKNOWN); //couldnt create the mod directory?
        }
      }
    }
  }
  
  return 0;
}

/*
============
va

does a varargs printf into a temp buffer, so I don't need to have
varargs versions of all text functions.
FIXME: make this buffer size safe someday
============

Ripped from Quake2 source... I use this function in all my projects!
*/
char *va(char *format, ...)
{
	va_list		argptr;
	static char		string[1024];
	
	va_start (argptr, format);
	vsprintf (string, format,argptr);
	va_end (argptr);

	return string;	
}

//generic print function..
void msg (char *text)
{
  cout << text << endl; //this one line can be changed to a printf call to convert this C++ program to a standard C program
}

//help text that is displayed when improper input is given
void helpmsg (void)
{
  msg("Program syntax:");
  msg("newmod <modname> <sourcepath> <q3path>\n");
  msg("Example:");
  msg("newmod mymod c:\\mymod C:\\\"Program Files\"\\\"Quake III Arena\"\n");
  msg("This would create a new code set from the current source code in the");
  msg("path \"c:\\mymod\" and add a \"mymod\" directory to your Q3A directory.");
}

//this function checks the current directory structure for the required source files
//return 1 if invalid source
//return 0 if valid
int badsource (void)
{ //FIXME: a better test would be to check the build*.dat
  if (direxists("game") && 
      direxists("cgame") &&
      direxists("ui"))
    return 0;
  return 1;
}

//lets the user know if an error has occured.
void errormsg (int error)
{
  char *out;
  
  switch (error) {
  case ERROR_BAD_SOURCE:
    out = "The source code is invalid. Please install a fresh copy of the source code and try again.";
    break;
  case ERROR_BAD_MOD_NAME:
    out = "The mod name you have chosen already exists in your Q3A directory. Please choose a different name.";
    break;
  default:
    out = "Unknown error.";
  }

  msg("The following error was encountered:");
  msg(out);
}

/*======
returns a 1 if a path exists
======*/
int direxists(char *path)
{
  char dir[1024];
  int retval;

  getcwd(dir, 1024);

  retval = chdir(path);
  
  //return to previous directory
  chdir(dir);

  return retval == 0;
}

//returns a 1 if a directory exists in a given path
int subdirexists(char *dir, char *path)
{
  return direxists(va("%s\\%s", path, dir));
}

//attempts to create a new directory
int createdir (char *path)
{
  return mkdir(path) == 0;
}

//attempts to create a new directory in a given path
int createsubdir (char *dir, char *path)
{
  return createdir(va("%s\\%s", path, dir));
}

/*========
Copies files listed in the filelist to modpath\dir
========*/
void copyfiles(char *filelist, char *path, char *dir)
{
  FILE *input;
  char filename[80];
  FILE *in;
  FILE *out;
  char buffer[512];

  input = fopen(filelist, "r");
  
  while (fgets (filename, sizeof(char) * sizeof(filename), input) != NULL)
  {
    //remove the last character because its a line break
    filename[strlen(filename) - 1] = '\0';

    if (strlen(filename) < 2)
      continue; // a while name has to be at least 2 chars long, prevents crashes

    if (strlen(dir) > 0)
    {
      in = fopen(va("%s\\%s", dir, filename), "r");
      out = fopen(va("%s\\%s\\%s", path, dir, filename), "w+");
    } else {
      in = fopen(filename, "r");
      out = fopen(va("%s\\%s", path, filename), "w+");
    }
    if (in != NULL && out != NULL)
    {
      while (fgets (buffer, sizeof(char) * sizeof(buffer), in) != NULL)
        fputs(buffer, out);

      fclose(in);
      fclose(out);
      msg(va("  %s Copied", filename));
    } else {
      msg(va("  Error copying %s", filename));
    }
  }

  fclose (input);
}

/*========
Creates a dir.q3asm in modpath\dir file that will compile filelist and put the QVM in q3path\modname
========*/
void createq3asm(char *filelist, char *modpath, char *q3path, char *modname, char *dir, char *qvm)
{
  FILE *input;
  FILE *out;
  char buffer[512];

  input = fopen(filelist, "r");

  out = fopen(va("%s\\%s\\%s.q3asm", modpath, dir, dir), "w+");
    
  fputs (va("-o \"%s\\%s\\vm\\%s\"\n", q3path, modname, qvm), out);
  /*==========
  Outputs: -o "q3path\modname\qvm" 
  ==========*/
  
  while (fgets (buffer, sizeof(char) * sizeof(buffer), input) != NULL)
    fputs(buffer, out);

  fclose (out);
  fclose (input);
}

//not used currently, but still a cool function.
void getbasepath (char *prog, char *path, int length)
{
  getcwd(path, length);
/*  
  //the following code work's but has a different effect
  //it returns the path to the executable rather than the current working directory
  int size = strlen(prog);
  char *curr = prog;
  int i;

  for (i = 0; i < size && i < length - 1; i++)
    curr++;
  
  while (*curr != '\\')
  {
    curr--;
    size--;
  }

  strncpy(path, prog, size);

  curr = path;
  for (i = 0; i < size; i++)
    curr++;
  
  *curr = '\0';
*/
}

/*========
Creates a play it.bat file that will load the new mod into Q3A
========*/
void newstartbatch (char *modname, char *modpath, char *q3path)
{
  FILE *out;

  out = fopen(va("%s\\play it.bat", modpath), "w+");
    
  fputs("@echo off\n", out);
  fputs(va("%c:\n", q3path[0]), out);
  fputs(va("cd %s\n", q3path), out);
  fputs(va("quake3.exe +set fs_game \"%s\"\n", modname), out);
    
  fclose (out);
}