//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "Main.h"
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TMainForm *MainForm;
TRegistry *reg;
int GameSpeed;
char TempString[256];
//---------------------------------------------------------------------------
void TMainForm::SetControls(void)
{
  SpeedTB->Position = GameSpeed;
  sprintf(TempString, "Current Speed: %d", GameSpeed);
  Label1->Caption = TempString;
  switch (GameSpeed)
  {
  	case 4:
    	SpeedRG->ItemIndex = 0;
      break;
  	case 8:
    	SpeedRG->ItemIndex = 1;
      break;
  	case 10:
    	SpeedRG->ItemIndex = 2;
      break;
    case 15:
    	SpeedRG->ItemIndex = 3;
      break;
    case 20:
    	SpeedRG->ItemIndex = 4;
      break;
    case 255:
    	SpeedRG->ItemIndex = 5;
      break;
    default:
    	SpeedRG->ItemIndex = -1;
      break;
  }
}

//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormCreate(TObject *Sender)
{
	reg = new TRegistry;
  if (reg)
  {
		reg->RootKey = HKEY_CURRENT_USER;
    if (reg->RootKey != HKEY_CURRENT_USER)
    {
	 		MessageBoxEx(MainForm->Handle, (const char *)"Root Key Error", (const char *)"AOESpeed",
  	 		MB_OK | MB_ICONERROR | MB_APPLMODAL, MAKELANGID(LANG_NEUTRAL, SUBLANG_SYS_DEFAULT));
		  Application->Terminate();
    }
    if (reg->OpenKey("\\Software\\Microsoft\\Games\\Age of Empires\\1.00", false))
    {
    	try
      {
				GameSpeed = reg->ReadInteger("Game Speed");
      }
      catch (ERegistryException &E)
      {
		  	MessageBoxEx(MainForm->Handle, E.Message.c_str(), (const char *)"AOESpeed",
    			MB_OK | MB_ICONERROR | MB_APPLMODAL, MAKELANGID(LANG_NEUTRAL, SUBLANG_SYS_DEFAULT));
        Application->Terminate();
      }
      reg->CloseKey();
    }
	  else
  	{
	 		MessageBoxEx(MainForm->Handle, (const char *)"Registry Error", (const char *)"AOESpeed",
  	 		MB_OK | MB_ICONERROR | MB_APPLMODAL, MAKELANGID(LANG_NEUTRAL, SUBLANG_SYS_DEFAULT));
		  Application->Terminate();
  	}
  }
  else
  {
	 	MessageBoxEx(MainForm->Handle, (const char *)"Memory Allocation Error", (const char *)"AOESpeed",
  	 	MB_OK | MB_ICONERROR | MB_APPLMODAL, MAKELANGID(LANG_NEUTRAL, SUBLANG_SYS_DEFAULT));
	  Application->Terminate();
  }
  SetControls();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::SpeedTBChange(TObject *Sender)
{
	GameSpeed = SpeedTB->Position;
  SetControls();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::SpeedRGClick(TObject *Sender)
{
  switch (SpeedRG->ItemIndex)
  {
  	case 0:
    	GameSpeed = 4;
      break;
  	case 1:
    	GameSpeed = 8;
      break;
  	case 2:
    	GameSpeed = 10;
      break;
    case 3:
    	GameSpeed = 15;
      break;
    case 4:
    	GameSpeed = 20;
      break;
    case 5:
    	GameSpeed = 255;
      break;
  }
	SetControls();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::OkBtnClick(TObject *Sender)
{
  if (reg)
  {
		reg->RootKey = HKEY_CURRENT_USER;
    if (reg->RootKey != HKEY_CURRENT_USER)
    {
	 		MessageBoxEx(MainForm->Handle, (const char *)"Root Key Error", (const char *)"AOESpeed",
  	 		MB_OK | MB_ICONERROR | MB_APPLMODAL, MAKELANGID(LANG_NEUTRAL, SUBLANG_SYS_DEFAULT));
		  Application->Terminate();
    }
    if (reg->OpenKey("Software\\Microsoft\\Games\\Age of Empires\\1.00", false))
    {
    	try
      {
				reg->WriteInteger("Game Speed", GameSpeed);
      }
      catch (ERegistryException &E)
      {
		  	MessageBoxEx(MainForm->Handle, E.Message.c_str(), (const char *)"AOESpeed",
    			MB_OK | MB_ICONERROR | MB_APPLMODAL, MAKELANGID(LANG_NEUTRAL, SUBLANG_SYS_DEFAULT));
        Application->Terminate();
      }
      reg->CloseKey();
    }
	  else
  	{
	 		MessageBoxEx(MainForm->Handle, (const char *)"Registry Error", (const char *)"AOESpeed",
  	 		MB_OK | MB_ICONERROR | MB_APPLMODAL, MAKELANGID(LANG_NEUTRAL, SUBLANG_SYS_DEFAULT));
		  Application->Terminate();
  	}
  }
  else
  {
	 	MessageBoxEx(MainForm->Handle, (const char *)"Memory Allocation Error", (const char *)"AOESpeed",
  	 	MB_OK | MB_ICONERROR | MB_APPLMODAL, MAKELANGID(LANG_NEUTRAL, SUBLANG_SYS_DEFAULT));
	  Application->Terminate();
  }
  delete reg;
	Application->Terminate();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::CancelBtnClick(TObject *Sender)
{
	delete reg;
	Application->Terminate();
}
//---------------------------------------------------------------------------