#!/bin/sh
# type chmod +x server.sh if you can't run this
# ./server.sh to run

cd ..

echo ALLIANCE BETA 06
echo To start a server, select one of the following:
echo 1 - Menu
echo 2 - CTF
echo 3 - Combat CTF
echo 4 - Combat DM
echo 5 - Railgun CTF
echo 6 - CTF '(dedicated)'
echo 7 - Combat CTF '(dedicated)'
echo 8 - Combat DM '(dedicated)'
echo 9 - Railgun CTF '(dedicated)'

# if arg 1 is nonzero in length:    
if [ -n "$1" ]
    then REPLY=$1
else
    read REPLY
fi

if [ $REPLY = 1 ]
then ./quake3.x86 +set fs_game alliance +set fs_basepath $(/bin/pwd) 
fi

if [ $REPLY = 2 ]
then ./quake3.x86 +set fs_game alliance +exec ctf.cfg +set g_gametype 4  +set fs_basepath $(/bin/pwd) +vstr d1
fi

if [ $REPLY = 3 ]
then ./quake3.x86 +set fs_game alliance +exec combat_ctf.cfg +set g_gametype 4  +set fs_basepath $(/bin/pwd) +vstr d1
fi

if [ $REPLY = 4 ]
then ./quake3.x86 +set fs_game alliance +exec combat_dm.cfg  +set fs_basepath $(/bin/pwd) +vstr d1
fi

if [ $REPLY = 5 ]
then ./quake3.x86 +set fs_game alliance +exec railgun_ctf.cfg  +set fs_basepath $(/bin/pwd) +vstr d1
fi

if [ $REPLY = 6 ]
then ./quake3.x86 +set dedicated 2 +set fs_game alliance +exec ctf.cfg +set g_gametype 4  +set fs_basepath $(/bin/pwd) +vstr d1
fi

if [ $REPLY = 7 ] 
then ./quake3.x86 +set dedicated 2 +set fs_game alliance +exec combat_ctf.cfg +set g_gametype 4  +set fs_basepath $(/bin/pwd) +vstr d1
fi

if [ $REPLY = 8 ] 
then ./quake3.x86 +set dedicated 2 +set fs_game alliance +exec combat_dm.cfg  +set fs_basepath $(/bin/pwd) +vstr d1
fi

if [ $REPLY = 9 ]
then ./quake3.x86 +set dedicated 2 +set fs_game alliance +exec railgun_ctf.cfg  +set fs_basepath $(/bin/pwd) +vstr d1
fi
