/* Aftershock 3D rendering engine
 * Copyright (C) 1999 Stephen C. Taylor
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "util.h"
#include "bsp.h"
#include "render.h"
#include "tex.h"
#include "mesh.h"
#include "shader.h"
#include "skybox.h"
#include "entity.h"
#include "md3.h"
#include "mapent.h"

int r_nummodels, r_numverts, r_numplanes, r_numleafs, r_numnodes;
int r_numshaders, r_numfaces, r_numlfaces, r_numelems;
int r_lightmapsize;
int r_addshaderstart;

model_t *r_models;
vertex_t *r_verts;
plane_t *r_planes;
leaf_t *r_leafs;
node_t *r_nodes;
shaderref_t *r_shaderrefs;
face_t *r_faces;
int *r_lfaces;
int *r_elems;
byte_t *r_lightmapdata;
visibility_t *r_visibility;

vec3_t r_eyepos;
vec3_t r_eyedir;
float r_eye_az, r_eye_el;
float r_eyefov;
int r_eyecluster;
int r_lockpvs = 0;
double g_frametime;

uint_t *r_textures;
int r_lodbias = 0;
float r_gamma = 1.0;

uint_t *r_lightmaptex;
int r_numlightmaptex;

float r_subdivisiontol = 20;
int r_maxmeshlevel = 5;
int r_nummeshes;
mesh_t *r_meshes;

int r_numtextures;
shader_t *r_shaders;
texfile_t *r_texfiles;

skybox_t *r_skybox;

int g_numentities;

int r_nummd3models;
md3model_t *r_md3models;

int g_mapent_numclasses;
int g_mapent_numinst;
mapent_class_t *g_mapent_class;
mapent_inst_t *g_mapent_inst;
