/* Aftershock 3D rendering engine
 * Copyright (C) 1999 Stephen C. Taylor
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include <GL/glut.h>
#include "uicommon.h"

static double starttime;

static void
display(void)
{
    double time;

    time = (double)glutGet(GLUT_ELAPSED_TIME) / 1000.0 - starttime;
    ui_display(time);
    glutSwapBuffers();
}

static void
mouse(int button, int state, int x, int y)
{
    ui_mouse_down(x, y);
}

static void
key_down(unsigned char key, int x, int y)
{
    ui_key_down(key);
}

static void
key_up(unsigned char key, int x, int y)
{
    ui_key_up(key);
}

static void
idle(void)
{
    display();
}

int
main(int argc, char **argv)
{
    glutInit(&argc, argv);
    glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);
    glutInitWindowSize(VIEWPORT_W, VIEWPORT_H);
    glutInitWindowPosition(50, 50);
    glutCreateWindow("Aftershock");

    glutDisplayFunc(display);
    glutMouseFunc(mouse);
    glutMotionFunc(ui_mouse_motion);
    glutKeyboardFunc(key_down);
    glutKeyboardUpFunc(key_up);
    glutIdleFunc(idle);

    ui_init(argc, argv);

    starttime = (double)glutGet(GLUT_ELAPSED_TIME) / 1000.0;
    
    glutMainLoop();

    ui_finish();
    return 0;
}
