// s_tfortmap.c
// This was created in attempt to 
// help map creators
#include "g_local.h"

void Perform_GoalFunction (edict_t *ent, edict_t *other, int ctf_team);
void info_tfgoal_touch (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf);

void TF_UseTargets (edict_t *ent, edict_t *activator)
{
	edict_t *t;

//
// kill killtargets
//
	if (ent->killtarget)
	{
		t = NULL;
		while ((t = G_Find (t, FOFS(targetname), ent->killtarget)))
		{
			G_FreeEdict (t);
			if (!ent->inuse)
			{
				gi.dprintf("entity was removed while using killtargets\n");
				return;
			}
		}
	}

//
// fire targets
//
	if (ent->target)
	{
		t = NULL;
		while ((t = G_Find (t, FOFS(targetname), ent->target)))
		{
			// doors fire area portals in a specific way
			if (!Q_stricmp(t->classname, "func_areaportal") &&
				(!Q_stricmp(ent->classname, "func_door") || !Q_stricmp(ent->classname, "func_door_rotating")))
				continue;

			if (t == ent)
			{
				gi.dprintf ("WARNING: Entity used itself.\n");
			}
			else
			{
				if (t->use)
					t->use (t, ent, activator);
			}
			if (!ent->inuse)
			{
				gi.dprintf("entity was removed while using targets\n");
				return;
			}
		}
	}
}

void goal_wait (edict_t *ent)
{
	Perform_GoalFunction (ent, ent->target_ent, ent->count);

	if (ent->target)
		TF_UseTargets (ent, ent->activator);

	ent->touch = info_tfgoal_touch;
}

void enable_goal (edict_t *ent)
{
	ent->owner->touch = info_tfgoal_touch;
	G_FreeEdict (ent);
}

void goal_activate (edict_t *ent)
{
	// already been triggered
	if (ent->nextthink)
		return;

	if (ent->wait && !ent->creator)
	{
		edict_t *toucher;

		toucher = G_Spawn ();
		toucher->owner = ent;
		toucher->think = enable_goal;
		toucher->nextthink = level.time + ent->wait;
		
		ent->touch = NULL;
		ent->creator = toucher;
	}

	if (ent->delay)
	{
		ent->think = goal_wait;
		ent->nextthink = level.time + ent->delay;
		return;
	}

	goal_wait (ent);
}

qboolean AP_MeetsCriteria (edict_t *ent, edict_t *other)
{
	if (ent->playerclass)
		if (other->playerclass != ent->playerclass)
			return false;

	if (ent->ripstate && other->client)
		if (other->client->resp.s_team != ent->ripstate)
			return false;

	return true;
}

void Use_Goal (edict_t *ent, edict_t *other, edict_t *activator)
{
	ent->target_ent = other;
	ent->activator = activator;
	goal_activate (ent);
}

void info_tfgoal_touch (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	if (!G_ClientExists (other))
		return;

	if (!AP_MeetsCriteria)
		return;

	Use_Goal (ent, other, other);
}

void info_tfgoal (edict_t *self)
{
	float		*v;

	v = tv(-15,-15,-15);
	VectorCopy (v, self->mins);
	v = tv(15,15,15);
	VectorCopy (v, self->maxs);

	self->s.skinnum = 0;
	self->solid = SOLID_TRIGGER;
	self->movetype = MOVETYPE_TOSS;  
	self->touch = info_tfgoal_touch;
	self->count = self->ripstate;
	self->nextthink = level.time + FRAMETIME;

	if (self->model)
		gi.setmodel (self, self->model);

	gi.linkentity (self);

	if ((self->count == 1) && (!flag1_goal))
		flag1_goal = self;
	else if ((self->count == 2) && (!flag2_goal))
		flag2_goal = self;
}

#define BONUSTYPE_CAPTURE		1
#define BONUSTYPE_PLAYERFRAG	2
#define BONUSTYPE_TEAMFRAG		3

void Bonuses (edict_t *self, edict_t *other)
{
	int bonusval;

	if (!self->bonustype)
		return;

    if ((int)tflags->value & RF_NO_FRAG)
		return;

	if (self->bonustype == BONUSTYPE_CAPTURE)
	{
		gi.bprintf(PRINT_HIGH, "%s got the capture bonus!\n",other->client->pers.netname);

		if (self->bonusval)
			bonusval = self->bonusval;
		else
			bonusval = 1;

		if (other->client->resp.s_team == 1)
			bp_team1 += bonusval;
		else
			bp_team2 += bonusval;

		gi.sound (self, CHAN_RELIABLE+CHAN_NO_PHS_ADD+CHAN_VOICE, gi.soundindex("ctf/flagcap.wav"), 1, ATTN_NONE, 0);
	}
	else if (self->bonustype == BONUSTYPE_PLAYERFRAG)
	{
		gi.bprintf(PRINT_HIGH, "%s got the frag bonus!\n", other->client->pers.netname);

		if (self->bonusval)
			other->client->resp.score += self->bonusval;
		else
			other->client->resp.score++;

		gi.sound (self, CHAN_RELIABLE+CHAN_NO_PHS_ADD+CHAN_VOICE, gi.soundindex("ctf/flagcap.wav"), 1, ATTN_NONE, 0);
	}
}