#include "g_local.h"
#include "m_player.h"

void Grenade_Explode (edict_t *ent);
void sentry_die (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point);
#define CTF_FLAG_BONUS			level.FLAG_TAKE_BONUS	// what you get for picking up enemy flag

void Grenade_Die (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point)
{
	G_FreeEdict (self);
}

/*----------------------------------------
  SP_LaserSight

  Create/remove the laser sight entity
-----------------------------------------*/

void	pre_target_laser_think (edict_t *self);

static void P_ProjectSource (gclient_t *client, vec3_t point, vec3_t distance, vec3_t forward, vec3_t right, vec3_t result)
{
	vec3_t	_distance;

	VectorCopy (distance, _distance);
	if (client->pers.hand == LEFT_HANDED)
		_distance[1] *= -1;
	else if (client->pers.hand == CENTER_HANDED)
		_distance[1] = 0;
	G_ProjectSource (point, _distance, forward, right, result);
}

void SP_LaserSight(edict_t *self)
{
	edict_t *lss;

	if (self->client->lasersight)
		return;

	lss = G_Spawn ();
	lss->movetype = MOVETYPE_NOCLIP;
	lss->solid = SOLID_NOT;
	lss->classname = "lasersight";
	lss->owner = self;
	lss->s.modelindex = gi.modelindex ("models/objects/spots/spotr.md2");
	lss->prethink = LaserSightThink;
	lss->s.renderfx |= RF_FULLBRIGHT;
 
	gi.linkentity (lss);
}

/*
===============================
LaserSightThink

Updates the sights position, angle, and shape
is the lasersight entity
==============================
*/

void LaserSightThink (edict_t *self)
{
	vec3_t start,end,endp,offset;
	vec3_t forward,right,up;
	trace_t tr;

	if (!self->owner->inuse || !self->owner->client->lasersight)
	{
		G_FreeEdict (self);
		return;
	}

	AngleVectors (self->owner->client->v_angle, forward, right, up);

	VectorSet(offset, 24, 6, self->owner->viewheight-7);
	P_ProjectSource (self->owner->client, self->owner->s.origin, offset, forward, right, start);
	VectorMA (start, 8192, forward,end);

	tr = gi.trace (start, NULL, NULL, end, self->owner, MASK_SHOT);

	if (tr.fraction != 1)
	{
		VectorMA(tr.endpos, -4, forward, endp);
		VectorCopy(endp, tr.endpos);
	}

	vectoangles(tr.plane.normal, self->s.angles);
	VectorCopy(tr.endpos, self->s.origin);

	gi.linkentity (self);
}

void SP_misc_teleporter_dest (edict_t *ent);

/*
===========================
=### UTILITY FUNCTIONS ###=
===========================
*/

void info_player_team1 (edict_t *ent)
{
}

void info_player_team2 (edict_t *ent)
{
}

void Spawn_TeamPoint (edict_t *ent)
{
	edict_t *spot;
    vec3_t forward;

	spot = G_Spawn();
	spot->owner = ent;

    AngleVectors(ent->client->v_angle, forward, NULL, NULL);
    VectorMA(ent->s.origin, 100, forward, spot->s.origin); 

	if (ent->client->resp.s_team == 2)
		info_player_team2 (spot);
	else if (ent->client->resp.s_team == 1)
		info_player_team1 (spot);
	else
		return;

	spot->health = 30;
	spot->gib_health = -30;
	spot->takedamage = DAMAGE_YES;
	spot->monsterinfo.aiflags = AI_NOSTEP;
	spot->think = M_droptofloor;
	spot->nextthink = level.time + 2 * FRAMETIME;
    SP_misc_teleporter_dest(spot);
}

/*
======================================
This modification allows use of Quake I -style teleports in Quake II
created by Toni Wilen <twilen@sci.fi> (26.12.1997)
======================================
*/

void teleporter_touch2(edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	edict_t		*dest;
	int			i;
	vec3_t		forward;

	if (!other->client)
		return;
	dest = G_Find (NULL, FOFS(targetname), self->target);
	if (!dest)
	{
		gi.dprintf ("Couldn't find destination\n");
		return;
	}

	if (self->ripstate && (other->client->resp.s_team != self->ripstate))
		return;

	// unlink to make sure it can't possibly interfere with KillBox
	gi.unlinkentity (other);

	VectorCopy (dest->s.origin, other->s.origin);
	VectorCopy (dest->s.origin, other->s.old_origin);
//	other->s.origin[2] += 10;

	// clear the velocity and hold them in place briefly
	VectorClear (other->velocity);
	other->client->ps.pmove.pm_time = 160>>3;		// hold time
	other->client->ps.pmove.pm_flags |= PMF_TIME_TELEPORT;

	// draw the teleport splash at source and on the player
	self->enemy->s.event = EV_PLAYER_TELEPORT;
	other->s.event = EV_PLAYER_TELEPORT;

	// set angles
	for (i=0 ; i<3 ; i++)
		other->client->ps.pmove.delta_angles[i] = ANGLE2SHORT(dest->s.angles[i] - other->client->resp.cmd_angles[i]);

	other->s.angles[PITCH] = 0;
	other->s.angles[YAW] = dest->s.angles[YAW];
	other->s.angles[ROLL] = 0;
	VectorCopy (dest->s.angles, other->client->ps.viewangles);
	VectorCopy (dest->s.angles, other->client->v_angle);

	// give a little forward velocity
	AngleVectors (other->client->v_angle, forward, NULL, NULL);
	VectorScale(forward, 200, other->velocity);

	// kill anything at the destination
	if (!KillBox (other))
	{
	}

	gi.linkentity (other);
}

// ### TEAMPLAY FUNCTIONS ### //

//========================================
// Ent joins Blue Team

char *CTFTeamName(int team);

void JoinTeam (edict_t *ent, int s_team)
{
	if (ent->client->resp.s_team > 0)
		return;

	gi.bprintf (PRINT_MEDIUM,"%s joined %s team\n", ent->client->pers.netname, CTFTeamName (s_team));

	ent->client->resp.s_team = s_team;
	ent->rockets = s_team;
}

void Self_Origin (edict_t *ent)
{
     gi.cprintf (ent, PRINT_HIGH, "Location : %s.\nAngles : %s.\n", vtos(ent->s.origin), vtos (ent->s.angles));
}

//========================================
// Prints Teammates classes
void PrintOtherClass (edict_t *ent)
{
	edict_t *players;
	qboolean found = false;
	int i;

    for (i = 1; i <= maxclients->value; i ++)
	{
		players = &g_edicts[i];

		if (!players->playerclass)
			continue;
		
		if (players->client->resp.s_team == ent->client->resp.s_team && ent != players && players->client->resp.s_team != 0)
		{
			gi.cprintf (ent, PRINT_HIGH, "%s's class is %s\n", players->client->pers.netname, players->playerclasss);
			found = true;
		}
	}

	if (!found)
		gi.cprintf (ent, PRINT_HIGH, "There is nobody on your team\n");
}

//========================================
// Returns team name
char *GetTeamName (int team)
{
	if (team == 1)
		return "red";
	else if (team == 2)
		return "blue";
	else
		return "\"\"";
}

//========================================
// Prints fmt to self enemy's team
void eprintf (edict_t *self, edict_t *ignore, int mod, int printlevel, char *fmt, ...) // not really used yet
{
    va_list ap;
    static char st[100];
	int i;
	edict_t *players;

    va_start (ap, fmt);
    vsprintf (st, fmt, ap);
    va_end (ap);

	for (i = 1; i <= maxclients->value; i++)
	{
		players = &g_edicts[i];

		if (!players->inuse)
			continue;
		if (!players->client)
			continue;
		if (players->client->resp.s_team == self->client->resp.s_team)
			continue;
		if (players == ignore)
			continue;

		(mod) ? gi.centerprintf (players, "%s", st) : gi.cprintf (players, printlevel, "%s", st);
	}
}

//========================================
// Prints fmt to ALL
void centerprint_all (char *fmt, ...)
{
    va_list ap;
    static char st[100];
    edict_t *ent;
	int i;

    va_start (ap, fmt);
    vsprintf (st, fmt, ap);
    va_end (ap);

	for_each_player (ent, i)
            gi.centerprintf(ent, "%s", st);
}

//========================================
// Prints fmt to self's team
void tprintf (edict_t *self, edict_t *ignore, int mod, int printlevel, char *fmt, ...)
{
    va_list ap;
    static char st[100];
	int i;
	edict_t *players;

    va_start (ap, fmt);
    vsprintf (st, fmt, ap);
    va_end (ap);

	for (i = 1; i <= maxclients->value; i++)
	{
		players = &g_edicts[i];

		if (!players->inuse)
			continue;
		if (!players->client)
			continue;
		if (players == ignore)
			continue;
		if (players->client->resp.s_team != self->client->resp.s_team)
			continue;

		(mod) ? gi.centerprintf (players, "%s", st) : gi.cprintf (players, printlevel, "%s", st);
	}
}

////////////////////////////////////////////////
// Maps stuff                                //
//////////////////////////////////////////////

void target_kill (edict_t *self)
{
	int i;
	edict_t *players;

	for_each_player (players, i)
	{
		if (self->ripstate)
		{
			if (players->client->resp.s_team == self->ripstate)
      			T_Damage (players, self, self, vec3_origin, players->s.origin, vec3_origin, 10000, 10000, 0, 39);
		}
		else
  			T_Damage (players, self, self, vec3_origin, players->s.origin, vec3_origin, 10000, 10000, 0, 39);
	}

	self->speed = 0;
}

void kill_think (edict_t *self)
{
	if (!self->speed)
		return;

	self->think = target_kill;
	self->nextthink = level.time + self->delay;
	self->prethink = NULL;
}

void trigger_kill (edict_t *self)
{
	self->prethink = kill_think;
	self->speed = 0;

	gi.linkentity(self);
}

/*--------------------------------------------------------------------------
 * just here to help old map conversions
 *--------------------------------------------------------------------------*/

static void old_teleporter_touch (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	edict_t		*dest;
	int			i;
	vec3_t		forward;

	if (!other->client)
		return;
	if (!AP_MeetsCriteria (self, other))
		return;

	dest = G_Find (NULL, FOFS(targetname), self->target);
	if (!dest)
	{
		gi.dprintf ("Couldn't find destination\n");
		return;
	}

	// unlink to make sure it can't possibly interfere with KillBox
	gi.unlinkentity (other);

	VectorCopy (dest->s.origin, other->s.origin);
	VectorCopy (dest->s.origin, other->s.old_origin);
//	other->s.origin[2] += 10;

	// clear the velocity and hold them in place briefly
	VectorClear (other->velocity);
	other->client->ps.pmove.pm_time = 160>>3;		// hold time
	other->client->ps.pmove.pm_flags |= PMF_TIME_TELEPORT;

	// draw the teleport splash at source and on the player
	self->enemy->s.event = EV_PLAYER_TELEPORT;
	other->s.event = EV_PLAYER_TELEPORT;

	// set angles
	for (i=0 ; i<3 ; i++)
		other->client->ps.pmove.delta_angles[i] = ANGLE2SHORT(dest->s.angles[i] - other->client->resp.cmd_angles[i]);

	other->s.angles[PITCH] = other->s.angles[ROLL] = 0;
	other->s.angles[YAW] = dest->s.angles[YAW];

	VectorCopy (dest->s.angles, other->client->ps.viewangles);
	VectorCopy (dest->s.angles, other->client->v_angle);

	// give a little forward velocity
	AngleVectors (other->client->v_angle, forward, NULL, NULL);
	VectorScale(forward, 200, other->velocity);

	// kill anything at the destination
	if (!KillBox (other))
	{
	}

	gi.linkentity (other);
}

/*QUAKED trigger_teleport (0.5 0.5 0.5) ?
Players touching this will be teleported
*/
void SP_trigger_teleport (edict_t *ent)
{
	edict_t *s;
	int i;

	if (!ent->target)
	{
		gi.dprintf ("teleporter without a target.\n");
		G_FreeEdict (ent);
		return;
	}

	ent->svflags |= SVF_NOCLIENT;
	ent->solid = SOLID_TRIGGER;
	ent->touch = old_teleporter_touch;

//	if (ent->model)
		gi.setmodel (ent, ent->model);

	gi.linkentity (ent);

	// noise maker and splash effect dude
	s = G_Spawn();
	ent->enemy = s;
	for (i = 0; i < 3; i++)
		s->s.origin[i] = ent->mins[i] + (ent->maxs[i] - ent->mins[i])/2;
	s->s.sound = gi.soundindex ("world/hum1.wav");
	gi.linkentity(s);
	
}

/*QUAKED info_teleport_destination (0.5 0.5 0.5) (-16 -16 -24) (16 16 32)
Point trigger_teleports at these.
*/
void SP_info_teleport_destination (edict_t *ent)
{
	ent->s.origin[2] += 16;
}

