#include "g_local.h"

void SelectSpawnPoint      (edict_t *ent, vec3_t origin, vec3_t angles);
void ClientUserinfoChanged (edict_t *ent, char *userinfo);
void PrintOtherClass       (edict_t *ent);
void Set_ClassEquipment    (gclient_t *client, int j);
void strcpy_ (char *s, char *fmt, ...);
void Rip_SkinHim(edict_t *ent);
void sentry_expl(edict_t *self);

cla_name cla_names[] = 
{
	{	"scout",	        		PC_SCOUT	},
	{	"sniper",    				PC_SNIPER	}, 
	{	"soldier",             		PC_SOLDIER	},
	{	"hwguy",	             	PC_HWGUY	},
	{	"demoman",	             	PC_DEMOMAN	},
	{	"medic",	             	PC_MEDIC	},
	{	"pyro",              		PC_PYRO		},
	{   "engineer",                 PC_ENGINEER }, 
	{   "spy",                      PC_SPY		}, 
	{	NULL,						0			}
};

char *gr_type (edict_t *ent, int i)
{
	if (!ent->client)
		return NULL;

	if (!ent->playerclass || ent->deadflag == DEAD_DEAD)
		return NULL;

	if (!i)
	{
		switch (ent->playerclass)
		{
		case PC_SCOUT:
			return "Flash";
		break;

		default:
			return "Normal";
		break;
		}
	}
	else
	{
		switch (ent->playerclass)
		{
		case PC_SCOUT:
		case PC_MEDIC:
			return "Concussion";
		break;

		case PC_SNIPER:
			return "Flare";
		break;

		case PC_SOLDIER:
			return "Nail";
		break;

		case PC_HWGUY:
		case PC_DEMOMAN:
			return "Mirv";
		break;

		case PC_ENGINEER:
			return "EMP";
		break;

		case PC_PYRO:
			return "Napalm";
		break;

		case PC_SPY:
			return "Gas";
		break;
		}
	}

	return "Not recognized";
}

void ValidateClass (int i)
{
	if (i <= 0)
		i = PC_SCOUT;
	else if (i > 9)
		i = PC_SPY;
}

void sparks (edict_t *ent)
{
	// send effect
	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_LOGIN);
	gi.multicast (ent->s.origin, MULTICAST_PVS);
}

char *SetClassName (edict_t *ent)
{
	switch (ent->bullets)
	{
		case PC_SCOUT:
			return "scout";
		case PC_SNIPER:
			return "sniper";
		case PC_SOLDIER:
			return "soldier";
		case PC_HWGUY:
			return "hwguy";
		case PC_DEMOMAN:
			return "demoman";
		case PC_MEDIC:
			return "medic";
		case PC_PYRO:
			return "pyro";
        case PC_ENGINEER:
			return "engineer";
        case PC_SPY:
			return "spy";
		default:
			return "";
	}
}

void Print_ClassProperties (edict_t *ent)
{
	switch (ent->playerclass)
	{
	   case PC_SCOUT:
			gi.centerprintf (ent,"SCOUT\n\nWeapons:\nShotgun, Machinegun\nGrenades: %s and %s\n\nArmor: %i.\nSpeed: %i.\n", gr_type(ent, 0), gr_type(ent, 1), ent->client->pers.max_armor, ent->ClassSpeed[0]);
	   break;
	   case PC_SNIPER:
			gi.centerprintf (ent,"SNIPER\n\nWeapons:\nMachinegun, Sniper Rifle\nGrenades: %s and %s\n\nArmor: %i.\nSpeed: %i.\n", gr_type(ent, 0), gr_type(ent, 1), ent->client->pers.max_armor, ent->ClassSpeed[0]);
	   break;
	   case PC_SOLDIER:
			gi.centerprintf (ent,"SOLDIER\n\nWeapons:\nShotgun, Super Shotgun, Rocket Launcher\nGrenades: %s and %s\n\n\nArmor: %i.\nSpeed: %i.\n", gr_type(ent, 0), gr_type(ent, 1), ent->client->pers.max_armor, ent->ClassSpeed[0]);
	   break;
	   case PC_HWGUY:
			gi.centerprintf (ent,"HWGUY\n\nWeapons:\nShotgun, Super Shotgun, Assault Cannon\nGrenades: %s and %s\n\nArmor: %i.\nSpeed: %i.\n", gr_type(ent, 0), gr_type(ent, 1), ent->client->pers.max_armor, ent->ClassSpeed[0]);
	   break;
	   case PC_DEMOMAN:
			gi.centerprintf (ent,"DEMOMAN\n\nWeapons:\nShotgun, Grenade Launcher, Pipe Launcher\nGrenades: %s and %s\n\nArmor: %i.\nSpeed: %i.\n", gr_type(ent, 0), gr_type(ent, 1), ent->client->pers.max_armor, ent->ClassSpeed[0]);
	   break;
	   case PC_MEDIC:
			gi.centerprintf (ent,"MEDIC\n\nWeapon:\nShotgun, Super Shotgun, Bioweapon, Chaingun\nGrenades: %s and %s\n\nArmor: %i.\nSpeed: %i.\n", gr_type(ent, 0), gr_type(ent, 1), ent->client->pers.max_armor, ent->ClassSpeed[0]);
	   break;
	   case PC_PYRO:
			gi.centerprintf (ent,"PYRO\n\nWeapons:\nShotgun, Incendiary Cannon, Flamethrower\nGrenades: %s and %s\n\nArmor: %i.\nSpeed: %i.\n", gr_type(ent, 0), gr_type(ent, 1), ent->client->pers.max_armor, ent->ClassSpeed[0]);
	   break;
	   case PC_ENGINEER:
			gi.centerprintf (ent,"ENGINEER\n\nWeapons:\nSuper Shotgun, Railgun\nGrenades: %s and %s\nArmor: %i.\nSpeed: %i.\n", gr_type(ent, 0), gr_type(ent, 1), ent->client->pers.max_armor, ent->ClassSpeed[0]);
	   break;
	   case PC_SPY:
			gi.centerprintf (ent,"SPY\n\nWeapons:\nShotgun, Super Shotgun, Tranquiliser Gun, Knife\nGrenades: %s and %s\nArmor: %i.\nSpeed: %i.\n", gr_type(ent, 0), gr_type(ent, 1), ent->client->pers.max_armor, ent->ClassSpeed[0]);
	   break;
	}
}

//
// Removes all timers belonging to player
//
void RemoveAllTimers (edict_t *ent)
{
	ent->client->ColorTime = 0;
	ent->client->DisguiseTime = 0;
	ent->client->GasedTime = 0;
	ent->client->DrunkTime = 0;
	ent->client->infection_time = 0;
	ent->client->tranq_time = 0;
	ent->client->last_infect_time = 0;
}

void Set_ClassEquipment (gclient_t *client, int j)
{
	inventory_t inventory = inventories[j];

	memset (&client->pers, 0, sizeof(client->pers));

	// max ammo
	client->pers.health = client->pers.max_health = inventory.max_health;
	client->pers.max_bullets = inventory.max_bullets;
	client->pers.max_shells = inventory.max_shells;
	client->pers.max_rockets = inventory.max_rockets;
	client->pers.max_slugs = inventory.max_slugs;
	client->pers.max_cells = inventory.max_cells;
	client->pers.grenades_left[0] = inventory.grenades_left1;

	if (j == PC_DEMOMAN || j == PC_PYRO)
		client->pers.grenades_left[1] = (!dragontf->value) ? 2 : 4;
	else
		client->pers.grenades_left[1] = inventory.grenades_left2;

	client->pers.max_grenades = inventory.max_grenades;

	// ammo at start
	client->pers.inventory[ITEMLIST_BULLETS] = inventory.sta_bullets;
	client->pers.inventory[ITEMLIST_SHELLS] = inventory.sta_shells;
	client->pers.inventory[ITEMLIST_ROCKETS] = inventory.sta_rockets;
	client->pers.inventory[ITEMLIST_SLUGS] = inventory.sta_slugs;
	client->pers.inventory[ITEMLIST_CELLS] = inventory.sta_cells;
	client->pers.inventory[ITEMLIST_GRENADES] = inventory.sta_grenades;

	if (j == PC_MEDIC)
		client->pers.inventory[ITEMLIST_MEDIKIT] = 50;

	// ammo at start : special handling
	client->pers.inventory[ITEMLIST_DETPACK] = (j == PC_DEMOMAN);

	// weapons
	client->pers.inventory[inventory.weapon1] = 1;
	client->pers.inventory[inventory.weapon2] = 1;
	client->pers.lastweapon = (inventory.weapon1 + itemlist);
	client->pers.weapon = (inventory.weapon2 + itemlist);

	// weapons : special handling
	if (inventory.weapon3)
		client->pers.inventory[inventory.weapon3] = 1;

	if (inventory.weapon4)
		client->pers.inventory[inventory.weapon4] = 1;

   	client->pers.inventory[ITEMLIST_AXE] = (j != PC_SPY && j != PC_MEDIC && j != PC_ENGINEER) ? 1 : 0;

	// armor
	client->pers.max_armor = inventory.armorm;
	client->pers.armortype = (inventory.armort + itemlist)->tag;
	client->pers.inventory[inventory.armort] = inventory.armorq;

	client->pers.connected = true;
}
   
void ClassFunction (edict_t *ent, int i)
{
	vec3_t	spawn_origin, spawn_angles;
	client_persistant_t	saved;
	client_respawn_t	resp;
	int d, o;
	char		userinfo[MAX_INFO_STRING];
	vec3_t	mins = {-16, -16, -24};
	vec3_t	maxs = {16, 16, 32};

	ValidateClass (i);

	if (ent->deadflag != DEAD_DEAD && ent->lastclass)
	{
		for (d = 0; cla_names[d].nextpc; d++)
		{
			if (cla_names[d].num == i)
			{
       			 if (ent->lastclass != cla_names[d].num)
					 gi.cprintf (ent, PRINT_HIGH, "After dying you will return as a %s\n", cla_names[d].nextpc);

				  ent->lastclass = cla_names[d].num;
				  ent->ripstate &= ~STATE_RANDOM;
                  return;
			}
		}
	} 

    SelectSpawnPoint (ent, spawn_origin, spawn_angles);
    
	resp = ent->client->resp;

	memcpy (userinfo, ent->client->pers.userinfo, sizeof(userinfo));
	Set_ClassEquipment (ent->client, i);
    ClientUserinfoChanged (ent, userinfo);

	// clear everything but the persistant data
	saved = ent->client->pers;
	memset (ent->client, 0, sizeof(*ent->client));
	ent->client->pers = saved;
    ent->client->resp = resp;

	if (ent->client->pers.health <= 0)
		Set_ClassEquipment (ent->client, i);

	FetchClientEntData (ent);

	ent->model = "players/male/tris.md2";
	ent->client = &game.clients[ent-g_edicts-1];
	ent->s.frame = 0;
	ent->burnout = 0;
    ent->style = 1;
	ent->groundentity = NULL;
	ent->takedamage = DAMAGE_AIM;
	ent->movetype = MOVETYPE_WALK;
	ent->viewheight = 22;
	ent->inuse = true;
	ent->solid = SOLID_BBOX;
	ent->deadflag = DEAD_NO;
	ent->air_finished = level.time + 7;
	ent->clipmask = MASK_PLAYERSOLID;
	ent->pain = player_pain;
	ent->die = player_die;
	ent->waterlevel = 0;
	ent->watertype = 0;
	ent->flags &= ~FL_NO_KNOCKBACK;
	ent->svflags &= ~SVF_DEADMONSTER;
	ent->svflags &= ~SVF_NOCLIENT;
	o = ent->playerclass;
	ent->lastclass = i;
	ent->client->gr_type = 1;
	ent->playerclass = ent->lastclass;
	ent->client->respawn_time = level.time;
	ent->ripstate = 0;
	ent->client->pers.autozoom = false;
	ent->client->grenade_time = 0;
	ent->rockets = ent->client->resp.s_team;
	ent->bullets = ent->playerclass;
	ent->client->attacker = NULL;
	ent->client->last_saveme_sound = 0;
	ent->building = NULL;
	ent->client->last_regenerate = level.time;

	VectorCopy (mins, ent->mins);
	VectorCopy (maxs, ent->maxs);
	VectorClear (ent->velocity);

	// clear playerstate values
	memset (&ent->client->ps, 0, sizeof(ent->client->ps));

	stuffcmd (ent, "fov 90\n");
	ent->client->ps.fov = 90;
	ent->client->ps.gunindex = gi.modelindex(ent->client->pers.weapon->view_model);
	ent->client->ps.pmove.origin[0] = spawn_origin[0]*8;
	ent->client->ps.pmove.origin[1] = spawn_origin[1]*8;
	ent->client->ps.pmove.origin[2] = spawn_origin[2]*8;

	if (ent->playerclass != PC_HWGUY)
		ent->mass = 200;
	else
		ent->mass = 500;

	// clear entity state values
	ent->s.effects = 0;
	ent->s.modelindex = 255;		// will use the skin specified model
	ent->s.modelindex2 = 255;
	VectorCopy (spawn_origin, ent->s.origin);
	ent->s.origin[2] += 2;	// make sure off ground

	// set the delta angle
	for (d = 0; d < 3; d++)
		ent->client->ps.pmove.delta_angles[d] = ANGLE2SHORT(spawn_angles[d] - ent->client->resp.cmd_angles[d]);

	ent->s.angles[PITCH] = ent->s.angles[ROLL] = 0;
	ent->s.angles[YAW] = spawn_angles[YAW];

	VectorCopy (ent->s.angles, ent->client->ps.viewangles);
	VectorCopy (ent->s.angles, ent->client->v_angle);

	gi.unlinkentity (ent);

	if (!KillBox (ent))
	{	// could't spawn in?
	}

	gi.linkentity (ent);

	if (o != i)
	{
		if (o)
			num_classes[ent->client->resp.s_team][o]--;

		num_classes[ent->client->resp.s_team][i]++;

		Rip_SetSpeed (ent);
		Rip_SetSkin (ent);
		Rip_SkinHim (ent);

		ent->playerclasss = SetClassName (ent);
    	tprintf (ent, ent, MOD_NORMAL, PRINT_HIGH, "%s's class is %s\n", ent->client->pers.netname, ent->playerclasss);
		PrintOtherClass (ent);
   		Print_ClassProperties(ent);

		if (atoi(Info_ValueForKey (ent->client->pers.userinfo, "exec_class")))
		{
			stuffcmd (ent, "exec ");
			stuffcmd (ent, ent->playerclasss);
			stuffcmd (ent, ".cfg\n");
		}
	}

	// force the current weapon up
	ent->client->newweapon = ent->client->pers.weapon;
	ChangeWeapon (ent);

	// add a teleportation effect
	ent->s.event = EV_PLAYER_TELEPORT;
	ent->ripstate |= STATE_SKIN;
}

void Rip_SkinHim (edict_t *ent)
{
	gi.configstring (CS_PLAYERSKINS+(ent-g_edicts-1), va("%s\\%s", ent->client->pers.netname, ent->skincheck) );
	ent->ripstate |= STATE_SKIN;
}

void Rip_SetSkin (edict_t *ent)
{
	char *skins[] = 
	{
		"",
		"scout/tfscout_r",
		"sniper/tfsniper_r",
		"male/tfsold_r",
		"heavy/tfhwguy_r",
		"male/tfdemo_r",
		"female/tfmedic_r",
		"pyro/tfpyro_r",
		"male/tfeng_r",
		"spy/tfspy_r",
		"scout/tfscout_b",
		"sniper/tfsniper_b",
		"male/tfsold_b",
		"heavy/tfhwguy_b",
		"male/tfdemo_b",
		"female/tfmedic_b",
		"pyro/tfpyro_b",
		"male/tfeng_b",
		"spy/tfspy_b",
		""
	};

	Com_sprintf (ent->skincheck, sizeof(ent->skincheck), skins[ent->bullets + (ent->rockets == 2)*9]);

   	// combine name and skin into a configstring
    gi.configstring (CS_PLAYERSKINS+(ent-g_edicts-1), va("%s\\%s", ent->client->pers.netname, ent->skincheck) );

	stuffcmd (ent, "skin ");
	stuffcmd (ent, ent->skincheck);
	stuffcmd (ent, "\n");

	ent->s.skinnum = ent - g_edicts - 1;

	ent->ripstate |= STATE_SKIN;
	Info_SetValueForKey (ent->client->pers.userinfo, "gender", (ent->playerclass != PC_MEDIC) ? "male" : "female");
}

void stuffcmd_speed (edict_t *ent, char s[4], qboolean x)
{
	stuffcmd (ent, x ? "cl_sidespeed " : "cl_forwardspeed ");
	stuffcmd (ent, s);
	stuffcmd (ent, "\n");
}
    
void Rip_SetSpeed (edict_t *ent)
{
	char s[4];

    switch (ent->playerclass)
	{
    	case 0:
			ent->ClassSpeed[0] = ent->ClassSpeed[1] = 225;
		break;
        case PC_SCOUT:
			ent->ClassSpeed[0] = ent->ClassSpeed[1] = 320;
	    break;
        case PC_SNIPER:
		case PC_DEMOMAN:
			ent->ClassSpeed[0] = ent->ClassSpeed[1] = 260;
		break;
		case PC_SOLDIER:
			ent->ClassSpeed[0] = ent->ClassSpeed[1] = 240;
	    break;
        case PC_HWGUY:
			ent->ClassSpeed[0] = 200;
			ent->ClassSpeed[1] = 150;
        break;
        case PC_MEDIC:
			ent->ClassSpeed[0] = ent->ClassSpeed[1] = 290;
        break;
		case PC_PYRO:
		case PC_ENGINEER:
        case PC_SPY:
		default:
			ent->ClassSpeed[0] = 280;
			ent->ClassSpeed[1] = 250;
		break;
	} 

	// 2nd, check for spy hit
	if (ent->client->tranq_time > level.time)
	{
		ent->ClassSpeed[0] /= 1.5;
		ent->ClassSpeed[1] /= 1.5;
	}

	// 3d, check for snipering
	if (ent->ripstate & STATE_ZOOM)
		ent->ClassSpeed[0] = ent->ClassSpeed[1] = 80;

	// 4th, check for leg wounds
	if (ent->leg_damage)
	{
		ent->leg_damage %= 6;

		// reduce speed by 10% per leg wound
    	ent->ClassSpeed[0] *= ((10 - ent->leg_damage) / 10);
		ent->ClassSpeed[1] *= ((10 - ent->leg_damage) / 10);
	}

	// 5th, check for detpack or disarming
	if ((ent->ripstate & STATE_DETPACK) || (ent->ripstate & STATE_DISARMING))
		ent->ClassSpeed[0] = ent->ClassSpeed[1] = 0;

	strcpy_ (s, "%i", ent->ClassSpeed[0]);
	stuffcmd_speed (ent, s, false);

	strcpy_ (s, "%i", ent->ClassSpeed[1]);
	stuffcmd_speed (ent, s, true);
}

qboolean T_Heal (edict_t *e, int healamount, qboolean ignore)
{
	if (e->health <= 0)
		return false;

	if ((!ignore) && (e->health >= e->client->pers.max_health))
		return false;

	e->health = e->health + healamount;

	if ((!ignore) && (e->health >= e->client->pers.max_health))
		e->health = e->client->pers.max_health;
		
	if (e->health > 250)
		e->health = 250;

	if (e->leg_damage)
	{
		if (e->health > 95)
			e->leg_damage = 0;
		else
			e->leg_damage = e->leg_damage - ceil(e->health / 20);

		if (e->leg_damage < 1)
			e->leg_damage = 0;

		Rip_SetSpeed(e);
	}

	return true;
}
