#include "g_local.h" 

// david.hillier2@virgin.net
// Fears remote system 
// ------------------- 

qboolean ValidMap (char *mymap, char *maplist) 
{ 
    char *p = strstr (maplist, mymap); 

    return (p != NULL);
}

void Cmd_vote_f (edict_t *ent) 
{
	char *s = gi.args();

    if (!level.vote_active) 
    { 
		gi.cprintf (ent, PRINT_HIGH, "No active votes.\n"); 
		return; 
    } 

	if (ent->client->resp.vote_taken) 
    { 
		gi.cprintf (ent, PRINT_HIGH, "You've already voted.\n"); 
		return; 
    } 

    if (!s) 
    { 
		gi.cprintf (ent, PRINT_HIGH, "Type Vote .\n"); 
		return; 
    } 

    if (Q_stricmp(s, "yes") == 0) 
    { 
		gi.cprintf (ent, PRINT_HIGH, "Voted Yes.\n"); 
		level.vote_number++; 
		ent->client->resp.vote_taken = true; 
    } 

    if (Q_stricmp(s, "no") == 0) 
    { 
		gi.cprintf (ent, PRINT_HIGH, "Voted No.\n"); 
		ent->client->resp.vote_taken = true; 
    } 
	
	gi.bprintf (PRINT_HIGH, "There are currently %i 'Yes' votes.\n", level.vote_number); 
} 

void Cmd_warp_f (edict_t *ent) 
{ 
	char *s = gi.args(); 
	
	if (sv_votepercent->value > 100) 
    { 
		gi.cprintf (ent, PRINT_HIGH, "Voting Disabled.\n"); 
		return; 
    } 

    if (level.vote_active) 
    { 
		gi.cprintf (ent, PRINT_HIGH, "Vote already in progress.\n"); 
		return; 
    } 

	if (!ValidMap(s, sv_maplist->string)) 
    { 
		gi.cprintf (ent, PRINT_HIGH, "Type warp *map name* to change level.\n"); 
		return; 
    } 

    // Activate Vote 
    level.vote_active = true; 
    level.vote_time = level.time + 30; 
    level.vote_number = 0; 

    // Vote for yourself 
    level.vote_number = 1; 
    ent->client->resp.vote_taken = true; 

    // Set the nextmap 
    strcpy (level.vote_nextmap, s); 
	gi.bprintf (PRINT_HIGH, "Type 'vote yes' to change the map to %s...", level.vote_nextmap);
	gi.bprintf (PRINT_HIGH, "...and 'vote no' to stay on the same level.\n");
} 

void vote_think (void) 
{ 
    int i, numplayers = 0; 
    edict_t *player;
	float remaining; 

	if (!level.vote_active) 
    { 
		for (i = 1; i <= maxclients->value; i++) 
		{ 
			if ((player = &g_edicts[i]) && player->inuse) 
				player->client->resp.vote_taken = false; 
		} 
		
		return; 
    } 

    if (level.vote_time < level.time) 
    { 
		gi.bprintf (PRINT_HIGH, "The vote is over.\n"); 
		level.vote_active = false; 
		return; 
    } 

	for (i = 0; i < maxclients->value; i++) 
    { 
		if ((player = &g_edicts[i+1]) && player->inuse) 
			 numplayers++;
    } 

	if ((sv_votepercent) && (level.vote_number > numplayers * (sv_votepercent->value / 100))) 
	{ 
		level.vote_active = false; 

		// Vote Achieved 
		gi.bprintf (PRINT_HIGH, "Vote Achieved. Warping %s.\n", level.vote_nextmap); 
		strcpy (level.nextmap,level.vote_nextmap); 
		EndDMLevel ();
		return;
    } 

    remaining = level.vote_time - level.time; 

	if (remaining == 20 || remaining == 10 || remaining == 5)
		gi.bprintf (PRINT_HIGH, "%i seconds left on vote. %i votes, %i needed\n",  remaining, level.vote_number,(int)numplayers * (sv_votepercent->value / 100)); 
}