#include "g_local.h"

void Concussion_Explode (edict_t *ent);
void Plasma_Explode (edict_t *ent);
void Rail_Grenade_Explode (edict_t *ent);
void Smoke_Grenade_Explode (edict_t *ent);
void Cluster_Explode (edict_t *ent);
void Zylon_Grenade(edict_t *ent);
void EMPGrenadeExplode (edict_t *ent);
void muzzleflash (edict_t *ent, int mz_);
void FlareGrenadeExplode (edict_t *self);
void NailGrenadeExplode (edict_t *self);
void T_RadiusBounce (edict_t *inflictor, edict_t *attacker, float bounce, edict_t *ignore);
void Pipebomb_Touch (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf);
void Pipebomb_Explode (edict_t *ent);

qboolean loc_CanSee (edict_t *targ, edict_t *inflictor);

#define         FLASH_RADIUS                    400
#define         BLIND_FLASH                     50      // Time of blindness in FRAMES
   
void f_g_touch (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	if (other == self->owner)
		return;

	if (surf && (surf->flags & SURF_SKY))
	{
		G_FreeEdict (self);
		return;
	}

	gi.sound (self, CHAN_VOICE, gi.soundindex ("weapons/grenlb1b.wav"), 1, ATTN_NORM, 0);

	self->movetype = MOVETYPE_NONE;
	self->s.sound = 0;
	VectorClear (self->velocity);
	VectorClear (self->avelocity);

	gi.linkentity (self);
}

void Flash_Explode (edict_t *ent)
{
    vec3_t v;
    edict_t *target;
    float Distance;

    // Move it off the ground so people are sure to see it
	ent->s.origin[2] += 10;

    target = NULL;
    while ((target = findradius(target, ent->s.origin, FLASH_RADIUS)) != NULL)
    {
          if (!target->client)
              continue;       // It's not a player
          if (!visible(ent, target))
              continue;       // The grenade can't see it
          if (!infront(target, ent))
              continue;       // It's not facing it
	      if (teamplay->value && target->client->resp.s_team == ent->ripstate)
		      continue;

		  T_Damage (target, ent, ent->owner, vec3_origin, target->s.origin, vec3_origin, 60, 0, DAMAGE_NO_PROTECTION|DAMAGE_RADIUS, MOD_GREN_FLASH);

          // Find distance
          VectorSubtract(ent->s.origin, target->s.origin, v);
          Distance = VectorLength(v);

          if (Distance < 200)
		      Distance = 20;
		  else if (Distance < 400)
              Distance = 15;

#ifdef INTERNET
          // Increment the blindness counter
          target->client->blindTime = level.time + Distance - 5;
#endif

#ifdef LAN
          // Increment the blindness counter
          target->client->blindTime = level.time + Distance;
#endif
	}

    // Blow up the grenade
    G_Explosion(ent);
	G_FreeEdict(ent);
}

void Gas_Explode (edict_t *ent)
{
    vec3_t v;
    edict_t *target;
    float Distance;

    // Move it off the ground so people are sure to see it
	ent->s.origin[2] += 10;

    target = NULL;

    while ((target = findradius(target, ent->s.origin, FLASH_RADIUS)) != NULL)
	{ 
        if (!target->client)
            continue;       // It's not a player
        if (!visible(ent, target))
            continue;       // The grenade can't see it
        if (!infront(target, ent))
            continue;       // It's not facing it
		if (teamplay->value && target->client->resp.s_team == ent->ripstate)
			continue;

        T_Damage (target, ent, ent->owner, target->velocity, target->s.origin, vec3_origin, 10, 0, DAMAGE_NO_ARMOR, MOD_GAS);

        // Find distance
        VectorSubtract(ent->s.origin, target->s.origin, v);
        Distance = VectorLength(v);
  
		if (Distance < 200)
		    Distance = 20;
		else if (Distance < 400)
            Distance = 15;

        // Increment the blindness counter
#ifdef INTERNET
        target->client->GasedTime = level.time + Distance - 5;
#endif

#ifdef LAN
        target->client->GasedTime = level.time + Distance;
#endif
	 }

    // Blow up the grenade
    G_Explosion(ent);
	G_FreeEdict (ent);
}

/*
=================
check_dodge

This is a support routine used when a client is firing
a non-instant attack weapon.  It checks to see if a
monster's dodge function should be called.
=================
*/
static qboolean	is_quad;

static void check_dodge (edict_t *self, vec3_t start, vec3_t dir, int speed)
{
	vec3_t	end;
	vec3_t	v;
	trace_t	tr;
	float	eta;

	// easy mode only ducks one quarter the time
	if (skill->value == 0)
	{
		if (random() > 0.25)
			return;
	}
	VectorMA (start, 8192, dir, end);
	tr = gi.trace (start, NULL, NULL, end, self, MASK_SHOT);
	if ((tr.ent) && (tr.ent->svflags & SVF_MONSTER) && (tr.ent->health > 0) && (tr.ent->monsterinfo.dodge) && infront(tr.ent, self))
	{
		VectorSubtract (tr.endpos, start, v);
		eta = (VectorLength(v) - tr.ent->maxs[0]) / speed;
		tr.ent->monsterinfo.dodge (tr.ent, self, eta);
	}
}


/*
=================
fire_hit

Used for all impact (hit/punch/slash) attacks
=================
*/

qboolean fire_hit (edict_t *self, vec3_t aim, int damage, int kick)
{
	trace_t		tr;
	vec3_t		forward, right, up;
	vec3_t		v;
	vec3_t		point;
	float		range;
	vec3_t		dir;

	//see if enemy is in range
	VectorSubtract (self->enemy->s.origin, self->s.origin, dir);
	range = VectorLength(dir);
	if (range > aim[0])
		return false;

	if (aim[1] > self->mins[0] && aim[1] < self->maxs[0])
	{
		// the hit is straight on so back the range up to the edge of their bbox
		range -= self->enemy->maxs[0];
	}
	else
	{
		// this is a side hit so adjust the "right" value out to the edge of their bbox
		if (aim[1] < 0)
			aim[1] = self->enemy->mins[0];
		else
			aim[1] = self->enemy->maxs[0];
	}

	VectorMA (self->s.origin, range, dir, point);

	tr = gi.trace (self->s.origin, NULL, NULL, point, self, MASK_SHOT);
	if (tr.fraction < 1)
	{
		if (!tr.ent->takedamage)
			return false;
		// if it will hit any client/monster then hit the one we wanted to hit
		if ((tr.ent->svflags & SVF_MONSTER) || (tr.ent->client))
			tr.ent = self->enemy;
	}

	AngleVectors(self->s.angles, forward, right, up);
	VectorMA (self->s.origin, range, forward, point);
	VectorMA (point, aim[1], right, point);
	VectorMA (point, aim[2], up, point);
	VectorSubtract (point, self->enemy->s.origin, dir);

	// do the damage
	T_Damage (tr.ent, self, self, dir, point, vec3_origin, damage, kick/2, DAMAGE_NO_KNOCKBACK, MOD_HIT);

	if (!(tr.ent->svflags & SVF_MONSTER) && (!tr.ent->client))
		return false;

	// do our special form of knockback here
	VectorMA (self->enemy->absmin, 0.5, self->enemy->size, v);
	VectorSubtract (v, point, v);
	VectorNormalize (v);
	VectorMA (self->enemy->velocity, kick, v, self->enemy->velocity);
	if (self->enemy->velocity[2] > 0)
		self->enemy->groundentity = NULL;
	return true;
}

void eject_shell (edict_t *self);

/*
=================
fire_lead

This is an internal support routine used for bullet/pellet based weapons.
=================
*/
static void fire_lead (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int kick, int te_impact, int hspread, int vspread, int mod)
{
	trace_t		tr;
	vec3_t		dir;
	vec3_t		forward, right, up;
	vec3_t		end;
	float		r;
	float		u;
	vec3_t		water_start;
	qboolean	water = false;
	int			content_mask = MASK_SHOT | MASK_WATER;

	tr = gi.trace (self->s.origin, NULL, NULL, start, self, MASK_SHOT);
	if (!(tr.fraction < 1.0))
	{
		vectoangles (aimdir, dir);
		AngleVectors (dir, forward, right, up);

		r = crandom()*hspread;
		u = crandom()*vspread;
		VectorMA (start, 8192, forward, end);
		VectorMA (end, r, right, end);
		VectorMA (end, u, up, end);

		if (gi.pointcontents (start) & MASK_WATER)
		{
			water = true;
			VectorCopy (start, water_start);
			content_mask &= ~MASK_WATER;
		}

		tr = gi.trace (start, NULL, NULL, end, self, content_mask);

		// see if we hit water
		if (tr.contents & MASK_WATER)
		{
			int		color;

			water = true;
			VectorCopy (tr.endpos, water_start);

			if (!VectorCompare (start, tr.endpos))
			{
				if (tr.contents & CONTENTS_WATER)
				{
					if (strcmp(tr.surface->name, "*brwater") == 0)
						color = SPLASH_BROWN_WATER;
					else
						color = SPLASH_BLUE_WATER;
				}
				else if (tr.contents & CONTENTS_SLIME)
					color = SPLASH_SLIME;
				else if (tr.contents & CONTENTS_LAVA)
					color = SPLASH_LAVA;
				else
					color = SPLASH_UNKNOWN;

				if (color != SPLASH_UNKNOWN)
				{
					gi.WriteByte (svc_temp_entity);
					gi.WriteByte (TE_SPLASH);
					gi.WriteByte (8);
					gi.WritePosition (tr.endpos);
					gi.WriteDir (tr.plane.normal);
					gi.WriteByte (color);
					gi.multicast (tr.endpos, MULTICAST_PVS);
				}

				// change bullet's course when it enters water
				VectorSubtract (end, start, dir);
				vectoangles (dir, dir);
				AngleVectors (dir, forward, right, up);
				r = crandom()*hspread*2;
				u = crandom()*vspread*2;
				VectorMA (water_start, 8192, forward, end);
				VectorMA (end, r, right, end);
				VectorMA (end, u, up, end);
			}

			// re-trace ignoring water this time
			tr = gi.trace (water_start, NULL, NULL, end, self, MASK_SHOT);
		}
	}

	// send gun puff / flash
	if (!((tr.surface) && (tr.surface->flags & SURF_SKY)))
	{
		if (tr.fraction < 1.0)
		{
			if (tr.ent->takedamage)
				T_Damage (tr.ent, self, self, aimdir, tr.endpos, tr.plane.normal, damage, kick, DAMAGE_BULLET, mod);
			else
			{
				if (strncmp (tr.surface->name, "sky", 3) != 0)
				{
					gi.WriteByte (svc_temp_entity);
					gi.WriteByte (te_impact);
					gi.WritePosition (tr.endpos);
					gi.WriteDir (tr.plane.normal);
					gi.multicast (tr.endpos, MULTICAST_PVS);
				}
			}
		}
	}

	// if went through water, determine where the end and make a bubble trail
	if (water)
	{
		vec3_t	pos;

		VectorSubtract (tr.endpos, water_start, dir);
		VectorNormalize (dir);
		VectorMA (tr.endpos, -2, dir, pos);
		if (gi.pointcontents (pos) & MASK_WATER)
			VectorCopy (pos, tr.endpos);
		else
			tr = gi.trace (pos, NULL, NULL, water_start, tr.ent, MASK_WATER);

		VectorAdd (water_start, tr.endpos, pos);
		VectorScale (pos, 0.5, pos);

		gi.WriteByte (svc_temp_entity);
		gi.WriteByte (TE_BUBBLETRAIL);
		gi.WritePosition (water_start);
		gi.WritePosition (tr.endpos);
		gi.multicast (pos, MULTICAST_PVS);
	}
}


/*
=================
fire_bullet

Fires a single round.  Used for machinegun and chaingun.  Would be fine for
pistols, rifles, etc....
=================
*/
void fire_bullet (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int kick, int hspread, int vspread, int mod)
{
	fire_lead (self, start, aimdir, damage, kick, TE_GUNSHOT, hspread, vspread, mod);
	eject_shell(self);
}

/*
=================
fire_shotgun

Shoots shotgun pellets.  Used by shotgun and super shotgun.
=================
*/
void fire_shotgun (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int kick, int hspread, int vspread, int count, int mod)
{
	int		i;

	for (i = 0; i < count; i++)
	{
		fire_lead (self, start, aimdir, damage, kick, TE_SHOTGUN, hspread, vspread, mod);
      	eject_shell(self);
	}
}


void Mirv_Explode (edict_t *ent)
{
	vec3_t		origin;

	ent->s.origin[2] += 10;

	// FIXME: if we are onground then raise our Z just a bit since we are a point?
	if (ent->enemy)
	{
		float	points;
		vec3_t	v;
		vec3_t	dir;

		VectorAdd (ent->enemy->mins, ent->enemy->maxs, v);
		VectorMA (ent->enemy->s.origin, 0.5, v, v);
		VectorSubtract (ent->s.origin, v, v);
		points = ent->dmg - 0.5 * VectorLength (v);
		VectorSubtract (ent->enemy->s.origin, ent->s.origin, dir);
		T_Damage (ent->enemy, ent, ent->owner, dir, ent->s.origin, vec3_origin, (int)points, (int)points, DAMAGE_RADIUS, MOD_MIRV);
	}

	T_RadiusDamage(ent, ent->owner, ent->dmg, ent->enemy, ent->dmg_radius, MOD_MIRV);

	VectorMA (ent->s.origin, -0.02, ent->velocity, origin);

	G_Explosion (ent);
	G_FreeEdict (ent);
}

void Grenade_Explode (edict_t *ent)
{
	vec3_t		origin;
	int			mod;

	//FIXME: if we are onground then raise our Z just a bit since we are a point?
	if (ent->enemy)
	{
		float	points;
		vec3_t	v;
		vec3_t	dir;

		VectorAdd (ent->enemy->mins, ent->enemy->maxs, v);
		VectorMA (ent->enemy->s.origin, 0.5, v, v);
		VectorSubtract (ent->s.origin, v, v);
		points = ent->dmg - 0.5 * VectorLength (v);
		VectorSubtract (ent->enemy->s.origin, ent->s.origin, dir);
		if (ent->spawnflags & 1)
			mod = MOD_HANDGRENADE;
		else
			mod = MOD_GRENADE;
		T_Damage (ent->enemy, ent, ent->owner, dir, ent->s.origin, vec3_origin, (int)points, (int)points, DAMAGE_RADIUS, mod);
	}

	if (ent->spawnflags & 2)
		mod = MOD_HELD_GRENADE;
	else if (ent->spawnflags & 1)
		mod = MOD_HG_SPLASH;
	else
		mod = MOD_G_SPLASH;
	T_RadiusDamage(ent, ent->owner, ent->dmg, ent->enemy, ent->dmg_radius, mod);

	VectorMA (ent->s.origin, -0.02, ent->velocity, origin);

	G_Explosion (ent);
	G_FreeEdict (ent);
}

static void Grenade_Touch (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	if (other == ent->owner)
		return;

	if (surf && (surf->flags & SURF_SKY))
	{
		G_FreeEdict (ent);
		return;
	}


	if (ent->owner->playerclass == PC_SOLDIER || ent->classname == "pipebomb")
	{
		if (ent->spawnflags & 1)
		{
			if (random() > 0.5)
				gi.sound (ent, CHAN_VOICE, gi.soundindex ("weapons/hgrenb1a.wav"), 1, ATTN_NORM, 0);
			else
				gi.sound (ent, CHAN_VOICE, gi.soundindex ("weapons/hgrenb2a.wav"), 1, ATTN_NORM, 0);
		}
		else
      		gi.sound (ent, CHAN_VOICE, gi.soundindex ("weapons/grenlb1b.wav"), 1, ATTN_NORM, 0);

	    return;
	}


	if (!other->takedamage)
	{
		if (ent->spawnflags & 1)
		{
			if (random() > 0.5)
				gi.sound (ent, CHAN_VOICE, gi.soundindex ("weapons/hgrenb1a.wav"), 1, ATTN_NORM, 0);
			else
				gi.sound (ent, CHAN_VOICE, gi.soundindex ("weapons/hgrenb2a.wav"), 1, ATTN_NORM, 0);
		}
		else
		{
			gi.sound (ent, CHAN_VOICE, gi.soundindex ("weapons/grenlb1b.wav"), 1, ATTN_NORM, 0);
		}
		return;
	}

	ent->enemy = other;
	ent->think (ent); // why explode ?
}

/*
=================
fire_grenade
=================
*/

void fire_grenade2 (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius, qboolean held);

void fire_grenade (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius)
{
	edict_t	*grenade;
	vec3_t	dir;
	vec3_t	forward, right, up;

	vectoangles (aimdir, dir);
	AngleVectors (dir, forward, right, up);

	grenade = G_Spawn();
	VectorCopy (start, grenade->s.origin);
	VectorScale (aimdir, speed, grenade->velocity);
	VectorMA (grenade->velocity, 200 + crandom() * 10.0, up, grenade->velocity);
	VectorMA (grenade->velocity, crandom() * 10.0, right, grenade->velocity);
	VectorSet (grenade->avelocity, 300, 300, 300);
	grenade->movetype = MOVETYPE_BOUNCE;
	grenade->clipmask = MASK_SHOT;
	grenade->solid = SOLID_BBOX;
	grenade->s.effects |= EF_GRENADE;
	VectorClear (grenade->mins);
	VectorClear (grenade->maxs);
	grenade->s.modelindex = gi.modelindex ("models/objects/grenade/tris.md2");
	grenade->owner = self;
	grenade->touch = Grenade_Touch;
	grenade->nextthink = level.time + timer;
	grenade->think = Grenade_Explode;
	grenade->dmg = damage;
	grenade->dmg_radius = damage_radius;
   	grenade->classname = "grenade";

	gi.linkentity (grenade);
}

void fire_grenade2 (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius, qboolean held)
{
	edict_t	*grenade;
	vec3_t	dir;
	vec3_t	forward, right, up;
	char *models[] = 
	{
		"",
		"models/objects/concuss/tris.md2",
		"models/objects/laser/tris.md2",
		"models/objects/nailgren/tris.md2",
		"models/objects/mirv/tris.md2",
		"models/objects/mirv/tris.md2",
		"models/objects/concuss/tris.md2",
		"models/objects/napalm/tris.md2",
		"models/objects/nailgren/tris.md2",
		"models/objects/emp/tris.md2",
		"models/objects/grenade3/tris.md2"
	};

    if ((self->playerclass == PC_PYRO) && !self->client->gr_type)
	{
		fire_flamegrenade2 (self, start, aimdir, damage, speed, timer, damage_radius, held);
		return;
	}

	vectoangles (aimdir, dir);
	AngleVectors (dir, forward, right, up);

	grenade = G_Spawn();
	VectorCopy (start, grenade->s.origin);
	VectorScale (aimdir, speed, grenade->velocity);
	VectorMA (grenade->velocity, 200 + crandom() * 10.0, up, grenade->velocity);
	VectorMA (grenade->velocity, crandom() * 10.0, right, grenade->velocity);
	VectorSet (grenade->avelocity, 300, 300, 300);  
	grenade->movetype = MOVETYPE_BOUNCE;
	grenade->clipmask = MASK_SHOT;
	grenade->solid = SOLID_BBOX;
	grenade->s.effects |= EF_GRENADE;
	grenade->playerclass = self->playerclass;
	VectorClear (grenade->mins);
	VectorClear (grenade->maxs);

	grenade->owner = self;
	grenade->nextthink = level.time + timer;
	grenade->touch = Pipebomb_Touch;

	if (!self->client->gr_type)
	{
		if (self->playerclass == PC_SCOUT)
		{
			grenade->think = Flash_Explode;
			grenade->s.modelindex = gi.modelindex ("models/objects/flashgr/tris.md2");
		}
		else
		{
 			grenade->think = Grenade_Explode;
     		grenade->touch = Grenade_Touch;
			grenade->s.modelindex = gi.modelindex ("models/objects/grenade1/tris.md2");
		}
	}
	else
	{
		switch (self->playerclass)
		{
			case PC_SCOUT:
			case PC_MEDIC:
		        grenade->think = Concussion_Explode;
			break;
			case PC_SNIPER:
				grenade->think = FlareGrenadeExplode;
	   			grenade->touch = f_g_touch;
			break;
			case PC_SOLDIER:
				grenade->think = NailGrenadeExplode;
			break;
			case PC_HWGUY:
			case PC_DEMOMAN:
				grenade->think = Cluster_Explode;
			break;
			case PC_ENGINEER:
				grenade->think = EMPGrenadeExplode;
			break;
			case PC_SPY:
				grenade->think = Gas_Explode;
			break;
			default:
		        grenade->think = Grenade_Explode;
			break;
		}

		grenade->s.modelindex = gi.modelindex (models[self->playerclass]);
	}

	grenade->dmg = damage;
	grenade->dmg_radius = damage_radius;
    grenade->classname = "hgrenade";

	held ? (grenade->spawnflags = 3) : (grenade->spawnflags = 1); 

	grenade->s.sound = gi.soundindex("weapons/hgrenc1b.wav");
	grenade->ripstate = self->client->resp.s_team;

	if (timer <= 0.0)
		grenade->think (grenade);
	else
	{
		gi.sound (self, CHAN_WEAPON, gi.soundindex ("weapons/hgrent1a.wav"), 1, ATTN_NORM, 0);
		gi.linkentity (grenade);
	}
}

/*
=================
fire_rocket
=================
*/
void rocket_touch (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	vec3_t		origin;

	if (other == ent->owner)
		return;

	if (surf && (surf->flags & SURF_SKY))
	{
		G_FreeEdict (ent);
		return;
	}

	// calculate position for the explosion entity
	VectorMA (ent->s.origin, -0.02, ent->velocity, origin);

	if (other->takedamage)
		T_Damage (other, ent, ent->owner, ent->velocity, ent->s.origin, plane->normal, ent->dmg, 0, 0, MOD_ROCKET);

	T_RadiusDamage(ent, ent->owner, ent->radius_dmg, other, ent->dmg_radius, MOD_R_SPLASH);

	gi.WriteByte (svc_temp_entity);
	if (ent->waterlevel)
		gi.WriteByte (TE_ROCKET_EXPLOSION_WATER);
	else
		gi.WriteByte (TE_ROCKET_EXPLOSION);
	gi.WritePosition (origin);
	gi.multicast (ent->s.origin, MULTICAST_PHS);

	G_FreeEdict (ent);
}

void fire_rocket (edict_t *self, vec3_t start, vec3_t dir, int damage, int speed, float damage_radius, int radius_damage)
{
	edict_t	*rocket;

	rocket = G_Spawn();
	VectorCopy (start, rocket->s.origin);
	VectorCopy (dir, rocket->movedir);
	vectoangles (dir, rocket->s.angles);
	VectorScale (dir, speed, rocket->velocity);
	rocket->movetype = MOVETYPE_FLYMISSILE;
	rocket->clipmask = MASK_SHOT;
	rocket->solid = SOLID_BBOX;
	rocket->s.effects |= EF_ROCKET;
	VectorClear (rocket->mins);
	VectorClear (rocket->maxs);
	rocket->s.modelindex = gi.modelindex ("models/objects/rocket/tris.md2");
    rocket->s.modelindex3 = 0;
	rocket->owner = self;
	rocket->touch = rocket_touch;
	rocket->nextthink = level.time + 8000/speed;
	rocket->think = G_FreeEdict;
	rocket->dmg = damage;
	rocket->radius_dmg = radius_damage;
	rocket->dmg_radius = damage_radius;
	rocket->s.sound = gi.soundindex ("weapons/rockfly.wav");
	rocket->classname = "rocket";

	if (self->client)
		check_dodge (self, rocket->s.origin, dir, speed);

	gi.linkentity (rocket);
}

/*
=================
fire_rail
=================
*/
void fire_rail (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int kick)
{
	vec3_t		from;
	vec3_t		end;
	trace_t		tr;
	edict_t		*ignore;
	int			mask;
	qboolean	water;

	VectorMA (start, 8192, aimdir, end);
	VectorCopy (start, from);
	ignore = self;
	water = false;
	mask = MASK_SHOT|CONTENTS_SLIME|CONTENTS_LAVA;
	while (ignore)
	{
		tr = gi.trace (from, NULL, NULL, end, ignore, mask);

		if (tr.contents & (CONTENTS_SLIME|CONTENTS_LAVA))
		{
			mask &= ~(CONTENTS_SLIME|CONTENTS_LAVA);
			water = true;
		}
		else
		{
			//ZOID--added so rail goes through SOLID_BBOX entities (gibs, etc)
			if ((tr.ent->svflags & SVF_MONSTER) || (tr.ent->client) ||
				(tr.ent->solid == SOLID_BBOX))
				ignore = tr.ent;
			else
				ignore = NULL;

			if ((tr.ent != self) && (tr.ent->takedamage))
				T_Damage (tr.ent, self, self, aimdir, tr.endpos, tr.plane.normal, damage, kick, 0, MOD_RAILGUN);
		}

		VectorCopy (tr.endpos, from);
	}

	// send gun puff / flash
	gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_RAILTRAIL);
	gi.WritePosition (start);
	gi.WritePosition (tr.endpos);
	gi.multicast (self->s.origin, MULTICAST_PHS);

	if (water)
	{
		gi.WriteByte (svc_temp_entity);
		gi.WriteByte (TE_RAILTRAIL);
		gi.WritePosition (start);
		gi.WritePosition (tr.endpos);
		gi.multicast (tr.endpos, MULTICAST_PHS);
	}
}

void fire_grenade3 (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius)
{
	edict_t	*grenade;
	vec3_t	dir;
	vec3_t	forward, right, up;

	vectoangles (aimdir, dir);
	AngleVectors (dir, forward, right, up);

	grenade = G_Spawn();
	VectorCopy (start, grenade->s.origin);
	VectorScale (aimdir, speed, grenade->velocity);
	VectorMA (grenade->velocity, 200 + crandom() * 10.0, up, grenade->velocity);
	VectorMA (grenade->velocity, crandom() * 10.0, right, grenade->velocity);
	VectorSet (grenade->avelocity, 300, 300, 300);
	grenade->movetype = MOVETYPE_BOUNCE;
	grenade->clipmask = MASK_SHOT;
	grenade->solid = SOLID_BBOX;
	grenade->s.effects |= EF_GRENADE;
	VectorClear (grenade->mins);
	VectorClear (grenade->maxs);
	grenade->owner = self->owner;
	grenade->ripstate = self->owner->client->resp.s_team;
	grenade->s.modelindex = gi.modelindex ("models/objects/grenade2/tris.md2");
	grenade->owner = self->owner; //do not damage player
	grenade->touch = Pipebomb_Touch;
	grenade->nextthink = level.time + timer;
	grenade->think = Mirv_Explode;
	grenade->dmg = damage;
	grenade->dmg_radius = damage_radius;
   	grenade->classname = "grenade";

	gi.linkentity (grenade);
}

void Cluster_Explode (edict_t *ent)
{
	vec3_t		origin;

	VectorMA (ent->s.origin, -0.02, ent->velocity, origin);

	fire_grenade3(ent, origin, tv(20,10,40), 120, 10, 2.0, 120);
	fire_grenade3(ent, origin, tv(20,-10,40), 120, 10, 2.0, 120);
	fire_grenade3(ent, origin, tv(-20,10,40), 120, 10, 2.0, 120);
	fire_grenade3(ent, origin, tv(-20,-10,40), 120, 10, 2.0, 120);

    Grenade_Explode (ent);
}

void FlareGrenadeThink (edict_t *self)
{
	float time_left;

	time_left = self->health - level.time;

	if (time_left > 33)
	{
		if (random() < 0.5)
			self->s.effects = EF_BLASTER;
		else
      		self->s.effects = 0;
 
		self->nextthink = level.time + 0.05 + (random() * 0.1);
	}
	else if (time_left > 31)
	{
		if (random() < 0.5)
			self->s.effects = EF_BLASTER;
		else
      		self->s.effects = 0;

		self->nextthink = level.time + .05 + (random() * .1);

	}
	else if (time_left > 15)
	{
		self->s.effects = EF_BLASTER;
		self->nextthink = level.time + 10;
	}
	else if (time_left < 1)
		G_FreeEdict(self);
	else
	{
    	self->s.effects = EF_BLASTER;
		self->nextthink = level.time + time_left;
	}

	gi.linkentity (self);
}

void FlareGrenadeExplode (edict_t *self)
{
	self->health = level.time + 40;
	self->nextthink = level.time + .05 + (random() * .1);
	self->think = FlareGrenadeThink;
}

//=========================================================================
// Nail function for Nail Grenade
void NailGrenadeLaunchNail (edict_t *self)
{
	int i;
	int current_yaw;
	vec3_t forward, start, right;

#ifdef INTERNET
	for (i = 0; i < 2; i++)
#endif

#ifdef LAN
	for (i = 0; i < 4; i++)
#endif
	{ 
		current_yaw = anglemod(self->s.angles[YAW] + 35);
		VectorSet (self->s.angles, 0, current_yaw, 0); 
      	AngleVectors (self->s.angles, forward, right, NULL);
		G_ProjectSource(self->s.origin, tv(8, 8, 0), forward, right, start);
		VectorNormalize (forward);

#ifdef INTERNET
		fire_bullet (self, start, forward, 30, 1, DEFAULT_BULLET_HSPREAD/4, DEFAULT_BULLET_VSPREAD/4, MOD_NAILBOMB);
#endif

#ifdef LAN
		fire_bullet (self, start, forward, 30, 1, DEFAULT_BULLET_HSPREAD, DEFAULT_BULLET_VSPREAD, MOD_NAILBOMB);
#endif
	}

	self->playerclass++;
	self->nextthink = level.time + .1;

	// Explode
	if (self->playerclass > 50)
		self->think = Grenade_Explode;
}

//=========================================================================
// Nail function for Nail Grenade
void NailGrenadeNailEm (edict_t *self)
{
	VectorClear (self->velocity);
	// Rotate and spew Nails

	self->nextthink = level.time + .1;
	self->think = NailGrenadeLaunchNail;
	self->playerclass = 0;
}

//=========================================================================
// Explode Function for Nail Grenade
void NailGrenadeExplode (edict_t *self)
{
	// Raise into the air
	self->movetype = MOVETYPE_FLY;
	VectorClear(self->s.angles);

	self->s.origin[2] += 22;
	// Rotate and spew Nails
    VectorSet (self->avelocity, 0, 500, 0);

	self->nextthink = level.time + .7;
	self->think = NailGrenadeNailEm;
}

/*
===========================
Concussion Grenades
===========================
*/
void Concussion_Explode (edict_t *ent)
{
    edict_t *target;
	float Distance, DrunkTimeAdd;	

    // Move it off the ground so people are sure to see it
    ent->s.origin[2] += 10;

    target = &g_edicts[0];

    while ((target = findradius(target, ent->s.origin, 520)) != NULL)
    {
		if (target == ent)
			continue;
        if (!target->client)
			continue;       // It's not a player
        if (!visible (ent, target))
            continue;       // The player can't see it
	    if (teamplay->value && target->client->resp.s_team == ent->ripstate)
			continue;

		// Find distance
		Distance = entdist(ent, target);
		// Calculate drunk factor

		if (Distance < 260)
			DrunkTimeAdd = 20; // completely drunk
        else
            DrunkTimeAdd = 5200 / Distance; // partially drunk

		if (target->playerclass == PC_MEDIC)
			DrunkTimeAdd -= 5;

        // Increment the drunk time
        if (target->client->DrunkTime < level.time)
			target->client->DrunkTime = DrunkTimeAdd + level.time;
		else
			target->client->DrunkTime += DrunkTimeAdd;    

        T_RadiusBounce (ent, ent->owner, 240, ent);
	}

	// Blow up the grenade
	gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_BOSSTPORT);
	gi.WritePosition (ent->s.origin);
	gi.multicast (ent->s.origin, MULTICAST_PHS);
   
	G_FreeEdict (ent);
}

void tranq_think (edict_t *ent)
{
	ent->owner->client->tranq_time = 0;

	Rip_SetSpeed (ent->owner);

	gi.cprintf (ent->owner, PRINT_HIGH, "You feel more alert now.\n");
	G_FreeEdict (ent);
}

void tranq_touch (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	vec3_t	origin;

	// can't be hit by own rocket
	if (other == ent->owner)
		return;

	// can't hit sky
	if (surf && (surf->flags & SURF_SKY))
	{
		G_FreeEdict (ent);
		return;
	}

	// calculate position for the explosion entity
	VectorMA (ent->s.origin, -0.02, ent->velocity, origin);

	// impact damage
	if (other->takedamage && other->client)
	{
		if (teamplay->value && other->client->resp.s_team != ent->owner->client->resp.s_team)
		{
			G_FreeEdict(ent);
			return;
		}

		T_Damage (other, ent, ent->owner, vec3_origin, ent->s.origin, (plane->normal) ? plane->normal : vec3_origin, 20, 10, DAMAGE_BULLET, MOD_TRANQ);

		if (other->client->tranq_time > level.time)
			other->client->tranq_time += 15;
		else
		{ 
			other->client->tranq_time = level.time + 15;

			gi.cprintf (other, PRINT_HIGH, "You feel tired...\n");
			Rip_SetSpeed (other);
		}
    }
	else
	{ 
  		gi.WriteByte (svc_temp_entity);
		gi.WriteByte (TE_SPLASH);
		gi.WriteByte (8);
		gi.WritePosition (ent->s.origin);
		gi.WriteDir (plane->normal);
		gi.WriteByte (SPLASH_UNKNOWN);
		gi.multicast (ent->s.origin, MULTICAST_PVS);
	}

	G_FreeEdict (ent);
}

void fire_tranq (edict_t *self, vec3_t start, vec3_t dir, int damage, int speed)
{
	edict_t	*bolt;

	bolt = G_Spawn();
	VectorCopy (start, bolt->s.origin);
	VectorCopy (dir, bolt->movedir);
	vectoangles (dir, bolt->s.angles);
	VectorScale (dir, speed, bolt->velocity);
	bolt->movetype = MOVETYPE_FLYMISSILE;
	bolt->clipmask = MASK_SHOT;
	bolt->solid = SOLID_BBOX;
	VectorClear (bolt->mins);
	VectorClear (bolt->maxs);
	bolt->s.modelindex = gi.modelindex ("models/objects/water/tris.md2");
    bolt->s.modelindex3 = 0;
	bolt->owner = self;
	bolt->touch = tranq_touch;
	bolt->dmg = damage;
	bolt->classname = "tranq_bolt";

	gi.linkentity (bolt);
}