#include "g_local.h"
#include "m_player.h"
#include "p_hook.h"

void PrintOtherClass            (edict_t *ent);
void PrintClass_ToOther         (edict_t *ent);
void Print_ClassProperties      (edict_t *ent);
void SelectRandom               (edict_t *ent);
void CTFSay_Team                (edict_t *who, char *msg);
void ClassFunction				(edict_t *ent, int i);
void Flag_StatusReport			(edict_t *self);
void ClientUserinfoChanged		(edict_t *ent, char *userinfo);
void Self_Origin                (edict_t *ent);
void CTFDeadDropFlag            (edict_t *self);
void Cmd_Chasecam_Toggle		(edict_t *ent);
void Cmd_Class_f                (edict_t *ent);
void Cmd_Build_f                (edict_t *ent);
void Cmd_Reload_f               (edict_t *ent);
void Cmd_Class_f                (edict_t *ent);
void Cmd_id_f                   (edict_t *ent);
void Cmd_Discard_f              (edict_t *ent);
void Cmd_warp_f					(edict_t *ent);
void Cmd_vote_f					(edict_t *ent);

void Weapon_Grenade1            (edict_t *ent);
void Weapon_Grenade2            (edict_t *ent);

void TeamFortress_SetDetpack	(edict_t *self, int timer);
void TeamFortress_DetpackStop	(edict_t *self);
void TeamFortress_Scan			(edict_t *self, int scanrange);
void Print_Msg					(edict_t *who, char *msg1, ...);

qboolean loc_CanSee (edict_t *targ, edict_t *inflictor);

int TeamFortress_GetPlayersByNum (int i)
{
	edict_t *other;
	int num = 0;

	for (i = 0; i <= maxclients->value; i++)
	{
		other = &g_edicts[i];

		if (!other->client || !other->inuse)
			continue;

		if (other->client->resp.s_team == i)
			num++;
	}

	return num;
}

//=========================================================================
// StatusQuery
void TeamFortress2_StatusQuery (edict_t *self)
{
	gi.cprintf (self, PRINT_HIGH, "players per team: %i %i\n    Equalisation: %i %i\n", TeamFortress_GetPlayersByNum(1), TeamFortress_GetPlayersByNum(2), team1advantage, team2advantage);
}

char *gr_type (edict_t *ent, int i);

char *ClientTeam (edict_t *ent)
{
	char	*p;
	static char	value[512];

	value[0] = 0;

	if (!ent->client)
		return value;

	strcpy(value, Info_ValueForKey (ent->client->pers.userinfo, "skin"));
	p = strchr(value, '/');
	if (!p)
		return value;

	if ((int)(dmflags->value) & DF_MODELTEAMS)
	{
		*p = 0;
		return value;
	}

	// if ((int)(dmflags->value) & DF_SKINTEAMS)
	return ++p;
}

qboolean OnSameTeam (edict_t *ent1, edict_t *ent2)
{
	char	ent1Team [512];
	char	ent2Team [512];

	if (!((int)(dmflags->value) & (DF_MODELTEAMS | DF_SKINTEAMS)))
		return false;

	strcpy (ent1Team, ClientTeam (ent1));
	strcpy (ent2Team, ClientTeam (ent2));

	if (strcmp(ent1Team, ent2Team) == 0)
		return true;
	return false;
}


void SelectNextItem (edict_t *ent, int itflags)
{
	gclient_t	*cl;
	int			i, index;
	gitem_t		*it;

	cl = ent->client;
  
	if (cl->menu)
	{
		PMenu_Next(ent);
		return;
	}

	if (cl->chase_target) {
		ChaseNext(ent);
		return;
	}

	// scan  for the next valid one
	for (i=1 ; i<=MAX_ITEMS ; i++)
	{
		index = (cl->pers.selected_item + i)%MAX_ITEMS;
		if (!cl->pers.inventory[index])
			continue;
		it = &itemlist[index];
		if (!it->use)
			continue;
		if (!(it->flags & itflags))
			continue;

		cl->pers.selected_item = index;
		return;
	}

	cl->pers.selected_item = -1;
}

void SelectPrevItem (edict_t *ent, int itflags)
{
	gclient_t	*cl;
	int			i, index;
	gitem_t		*it;

	cl = ent->client;

	if (cl->menu) {
		PMenu_Prev(ent);
		return;
	}

	if (cl->chase_target) {
		ChasePrev(ent);
		return;
	}

	// scan  for the next valid one
	for (i=1 ; i<=MAX_ITEMS ; i++)
	{
		index = (cl->pers.selected_item + MAX_ITEMS - i)%MAX_ITEMS;
		if (!cl->pers.inventory[index])
			continue;
		it = &itemlist[index];
		if (!it->use)
			continue;
		if (!(it->flags & itflags))
			continue;

		cl->pers.selected_item = index;
		return;
	}

	cl->pers.selected_item = -1;
}

void ValidateSelectedItem (edict_t *ent)
{
	gclient_t	*cl;

	cl = ent->client;

	if (cl->pers.inventory[cl->pers.selected_item])
		return;		// valid

	SelectNextItem (ent, -1);
}


/*
==================
Cmd_Give_f

Give items to a client
==================
*/
void Cmd_Give_f (edict_t *ent)
{
	char		*name;
	gitem_t		*it;
	int			index;
	int			i;
	qboolean	give_all;
	edict_t		*it_ent;

	if (!sv_cheats->value)
	{
		gi.cprintf (ent, PRINT_HIGH, "You must run the server with '+set cheats 1' to enable this command.\n");
		return;
	}

	name = gi.args();

	if (Q_stricmp(name, "all") == 0)
		give_all = true;
	else
		give_all = false;

	if (give_all || Q_stricmp(gi.argv(1), "health") == 0)
	{
		if (gi.argc() == 3)
			ent->health = atoi(gi.argv(2));
		else
			ent->health = ent->max_health;
		if (!give_all)
			return;
	}

	if (give_all || Q_stricmp(name, "weapons") == 0)
	{
		for (i=0 ; i<game.num_items ; i++)
		{
			it = itemlist + i;
			if (!it->pickup)
				continue;
			if (!(it->flags & IT_WEAPON))
				continue;
			ent->client->pers.inventory[i] += 1;
		}
		if (!give_all)
			return;
	}

	if (give_all || Q_stricmp(name, "ammo") == 0)
	{
		for (i=0 ; i<game.num_items ; i++)
		{
			it = itemlist + i;
			if (!it->pickup)
				continue;
			if (!(it->flags & IT_AMMO))
				continue;
			Add_Ammo (ent, it, 1000);
		}
		if (!give_all)
			return;
	}

	if (give_all || Q_stricmp(name, "armor") == 0)
	{
		gitem_armor_t	*info;

		it = FindItem("Jacket Armor");
		ent->client->pers.inventory[ITEM_INDEX(it)] = 0;

		it = FindItem("Combat Armor");
		ent->client->pers.inventory[ITEM_INDEX(it)] = 0;

		it = FindItem("Body Armor");
		info = (gitem_armor_t *)it->info;
		ent->client->pers.inventory[ITEM_INDEX(it)] = info->max_count;

		if (!give_all)
			return;
	}

	if (give_all || Q_stricmp(name, "Power Shield") == 0)
	{
		it = FindItem("Power Shield");
		it_ent = G_Spawn();
		it_ent->classname = it->classname;
		SpawnItem (it_ent, it);
		Touch_Item (it_ent, ent, NULL, NULL);
		if (it_ent->inuse)
			G_FreeEdict(it_ent);

		if (!give_all)
			return;
	}

	if (give_all)
	{
		for (i=0 ; i<game.num_items ; i++)
		{
			it = itemlist + i;
			if (!it->pickup)
				continue;
			if (it->flags & (IT_ARMOR|IT_WEAPON|IT_AMMO))
				continue;
			ent->client->pers.inventory[i] = 1;
		}
		return;
	}

	it = FindItem (name);
	if (!it)
	{
		name = gi.argv(1);
		it = FindItem (name);
		if (!it)
		{
			gi.dprintf ("unknown item\n");
			return;
		}
	}

	if (!it->pickup)
	{
		gi.dprintf ("non-pickup item\n");
		return;
	}

	index = ITEM_INDEX(it);

	if (it->flags & IT_AMMO)
	{
		if (gi.argc() == 3)
			ent->client->pers.inventory[index] = atoi(gi.argv(2));
		else
			ent->client->pers.inventory[index] += it->quantity;
	}
	else
	{
		it_ent = G_Spawn();
		it_ent->classname = it->classname;
		SpawnItem (it_ent, it);
		Touch_Item (it_ent, ent, NULL, NULL);
		if (it_ent->inuse)
			G_FreeEdict(it_ent);
	}
}


/*
==================
Cmd_God_f

Sets client to godmode

argv(0) god
==================
*/
void Cmd_God_f (edict_t *ent)
{
	char	*msg;

	if (!sv_cheats->value)
	{
		gi.cprintf (ent, PRINT_HIGH, "You must run the server with '+set cheats 1' to enable this command.\n");
		return;
	}

	ent->flags ^= FL_GODMODE;
	if (!(ent->flags & FL_GODMODE) )
		msg = "godmode OFF\n";
	else
		msg = "godmode ON\n";

	gi.cprintf (ent, PRINT_HIGH, msg);
}


/*
==================
Cmd_Notarget_f

Sets client to notarget

argv(0) notarget
==================
*/
void Cmd_Notarget_f (edict_t *ent)
{
	char	*msg;

	if (!sv_cheats->value)
	{
		gi.cprintf (ent, PRINT_HIGH, "You must run the server with '+set cheats 1' to enable this command.\n");
		return;
	}

	ent->flags ^= FL_NOTARGET;
	if (!(ent->flags & FL_NOTARGET) )
		msg = "notarget OFF\n";
	else
		msg = "notarget ON\n";

	gi.cprintf (ent, PRINT_HIGH, msg);
}

/*
==================
Cmd_Noclip_f

argv(0) noclip
==================
*/
void Cmd_Noclip_f (edict_t *ent)
{
	char	*msg;

	if (!sv_cheats->value)
	{
		gi.cprintf (ent, PRINT_HIGH, "You must run the server with '+set cheats 1' to enable this command.\n");
		return;
	}

	if (ent->movetype == MOVETYPE_NOCLIP)
	{
		ent->movetype = MOVETYPE_WALK;
		msg = "noclip OFF\n";
	}
	else
	{
		ent->movetype = MOVETYPE_NOCLIP;
		msg = "noclip ON\n";
	}

	gi.cprintf (ent, PRINT_HIGH, msg);
}


/*
==================
Cmd_Use_f

Use an inventory item
==================
*/
void Cmd_Use_f (edict_t *ent)
{
	int			index;
	gitem_t		*it;
	char		*s;

	s = gi.args();

	if (ent->client->menu)
	{
		PMenu_MenuUse (ent, s);
		return;
	}

	it = FindItem (s);

	if (!it)
	{
		gi.cprintf (ent, PRINT_HIGH, "unknown item: %s\n", s);
		return;
	}

	if (!it->use || stricmp(it->pickup_name, "Grenades") == 0)
	{
		gi.cprintf (ent, PRINT_HIGH, "Item is not usable.\n");
		return;
	}

	index = ITEM_INDEX(it);
	if (!ent->client->pers.inventory[index])
	{
		gi.cprintf (ent, PRINT_HIGH, "Out of item: %s\n", s);
		return;
	}

	it->use (ent, it);
}


/*
==================
Cmd_Drop_f

Drop an inventory item
==================
*/
void Cmd_Drop_f (edict_t *ent)
{
	int			index;
	gitem_t		*it;
	char		*s;

	s = gi.args();
	it = FindItem (s);
	if (!it)
	{
		gi.cprintf (ent, PRINT_HIGH, "unknown item: %s\n", s);
		return;
	}
	if (!it->drop)
	{
		gi.cprintf (ent, PRINT_HIGH, "Item is not dropable.\n");
		return;
	}
	index = ITEM_INDEX(it);
	if (!ent->client->pers.inventory[index])
	{
		gi.cprintf (ent, PRINT_HIGH, "Out of item: %s\n", s);
		return;
	}

	it->drop (ent, it);
}


/*
=================
Cmd_Inven_f
=================
*/
void Cmd_Inven_f (edict_t *ent)
{
	int			i;
	gclient_t	*cl;

	cl = ent->client;

	if (cl->resp.s_team == 0)
	{
		Cmd_Team_f (ent);
		return;
	}
	else if (!ent->playerclass && cl->resp.s_team)
	{
		Cmd_Class_f (ent);
	    return;
	}

	cl->showscores = false;
	cl->showhelp = false;

//ZOID
	if (ent->client->menu)
	{
		PMenu_Close(ent);
		return;
	}
//ZOID

	if (cl->showinventory)
	{
		cl->showinventory = false;
		return;
	}

	cl->showinventory = true;

	gi.WriteByte (svc_inventory);
	for (i=0 ; i<MAX_ITEMS ; i++)
	{
		gi.WriteShort (cl->pers.inventory[i]);
	}
	gi.unicast (ent, true);
}

/*
=================
Cmd_InvUse_f
=================
*/
void Cmd_InvUse_f (edict_t *ent)
{
	gitem_t		*it;

//ZOID
	if (ent->client->menu) {
		PMenu_Select(ent);
		return;
	}
//ZOID

	ValidateSelectedItem (ent);

	if (ent->client->pers.selected_item == -1)
	{
		gi.cprintf (ent, PRINT_HIGH, "No item to use.\n");
        ent->client->pers.selected_item = 0; // Vic
		return;
	}

	it = &itemlist[ent->client->pers.selected_item];
	if (!it->use || stricmp(it->pickup_name, "Grenades") == 0)
	{
		gi.cprintf (ent, PRINT_HIGH, "Item is not usable.\n");
		return;
	}
	it->use (ent, it);
}

/*
=================
Cmd_WeapPrev_f
=================
*/
void Cmd_WeapPrev_f (edict_t *ent)
{
	gclient_t	*cl;
	int			i, index;
	gitem_t		*it;
	int			selected_weapon;

	cl = ent->client;

	if (!cl->pers.weapon)
		return;

	selected_weapon = ITEM_INDEX(cl->pers.weapon);

	// scan  for the next valid one
	for (i=1 ; i<=MAX_ITEMS ; i++)
	{
		index = (selected_weapon + i)%MAX_ITEMS;
		if (!cl->pers.inventory[index])
			continue;
		it = &itemlist[index];
		if (!it->use)
			continue;
		if (! (it->flags & IT_WEAPON) )
			continue;
		it->use (ent, it);
		if (cl->pers.weapon == it)
			return;	// successful
	}
}

/*
=================
Cmd_WeapNext_f
=================
*/
void Cmd_WeapNext_f (edict_t *ent)
{
	gclient_t	*cl;
	int			i, index;
	gitem_t		*it;
	int			selected_weapon;

	cl = ent->client;

	if (!cl->pers.weapon)
		return;

	selected_weapon = ITEM_INDEX(cl->pers.weapon);

	// scan  for the next valid one
	for (i=1 ; i<=MAX_ITEMS ; i++)
	{
		index = (selected_weapon + MAX_ITEMS - i)%MAX_ITEMS;
		if (!cl->pers.inventory[index])
			continue;
		it = &itemlist[index];
		if (!it->use)
			continue;
		if (! (it->flags & IT_WEAPON) )
			continue;
		it->use (ent, it);
		if (cl->pers.weapon == it)
			return;	// successful
	}
}

/*
=================
Cmd_WeapLast_f
=================
*/
void Cmd_WeapLast_f (edict_t *ent)
{
	gclient_t	*cl;
	int			index;
	gitem_t		*it;

	cl = ent->client;

	if (!cl->pers.weapon || !cl->pers.lastweapon)
		return;

	index = ITEM_INDEX(cl->pers.lastweapon);
	if (!cl->pers.inventory[index])
		return;
	it = &itemlist[index];
	if (!it->use)
		return;
	if (! (it->flags & IT_WEAPON) )
		return;
	it->use (ent, it);
}

/*
=================
Cmd_InvDrop_f
=================
*/
void Cmd_InvDrop_f (edict_t *ent)
{
	gitem_t		*it;

	ValidateSelectedItem (ent);

	if (ent->client->pers.selected_item == -1)
	{
		gi.cprintf (ent, PRINT_HIGH, "No item to drop.\n");
		return;
	}

	it = &itemlist[ent->client->pers.selected_item];
	if (!it->drop)
	{
		gi.cprintf (ent, PRINT_HIGH, "Item is not dropable.\n");
		return;
	}
	it->drop (ent, it);
}

/*
=================
Cmd_Kill_f
=================
*/
void Cmd_Kill_f (edict_t *ent)
{
	if((level.time - ent->client->respawn_time) < 5)
		return;

    if (!ent->playerclass)
        return;

	if ((int)(tflags->value) & RF_SUICIDE_KICK)
	{
		gi.bprintf (PRINT_MEDIUM, "%s kicked for suiciding\n", ent->client->pers.netname);
 		stuffcmd (ent, "disconnect\n");
		return;
    }

	ent->flags &= ~FL_GODMODE;
	ent->health = 0;
	meansOfDeath = MOD_SUICIDE;

	player_die (ent, ent, ent, 1000, vec3_origin);

    ent->deadflag = DEAD_DEAD;
}

/*
=================
Cmd_PutAway_f
=================
*/
void Cmd_PutAway_f (edict_t *ent)
{
	ent->client->showscores = false;
	ent->client->showhelp = false;
	ent->client->showinventory = false;
//ZOID
	if (ent->client->menu)
		PMenu_Close(ent);
//ZOID
}

int PlayerSort (void const *a, void const *b)
{
	int		anum, bnum;

	anum = *(int *)a;
	bnum = *(int *)b;

	anum = game.clients[anum].ps.stats[STAT_FRAGS];
	bnum = game.clients[bnum].ps.stats[STAT_FRAGS];

	if (anum < bnum)
		return -1;
	if (anum > bnum)
		return 1;
	return 0;
}

/*
=================
Cmd_Players_f
=================
*/
void Cmd_Players_f (edict_t *ent)
{
	int		i, count;
	char	small[64],	large[1280];
	int		index[256];

	count = 0;
	for (i = 0 ; i < maxclients->value ; i++)
		if (game.clients[i].pers.connected)
		{
			index[count] = i;
			count++;
		}

	// sort by frags
	qsort (index, count, sizeof(index[0]), PlayerSort);

	// print information
	large[0] = 0;

	for (i = 0 ; i < count ; i++)
	{
		Com_sprintf (small, sizeof(small), "%3i %s\n",
			game.clients[index[i]].ps.stats[STAT_FRAGS],
			game.clients[index[i]].pers.netname);
		if (strlen (small) + strlen(large) > sizeof(large) - 100 )
		{	// can't print all of them in one packet
			strcat (large, "...\n");
			break;
		}
		strcat (large, small);
	}

	gi.cprintf (ent, PRINT_HIGH, "%s\n%i players\n", large, count);
}

void TeamFotress_SaveMe (edict_t *self)
{
	int i;
	edict_t *player;

	if (!self->playerclass || self->deadflag)
		return;

	if (self->client->last_saveme_sound < level.time)
	{
		if (rand()&1)
			gi.sound(self, CHAN_AUTO, gi.soundindex("speech/saveme1.wav"), 1, ATTN_NORM, 0);	// MEDIC!
		else
			gi.sound(self, CHAN_AUTO, gi.soundindex("speech/saveme2.wav"), 1, ATTN_NORM, 0);	// Excuse me...
		self->client->last_saveme_sound = level.time + 4;
	}

	for_each_player (player, i)
	{
		if (player == self || player->playerclass == PC_MEDIC || player->playerclass == PC_ENGINEER || player->playerclass == PC_SPY)
		{
			if (player->client->resp.s_team == self->client->resp.s_team || player->playerclass == 9)
			{
				if (loc_CanSee (self, player))
				{
					vec3_t v;

					VectorCopy (self->s.origin, v);
					v[2] += 32;

					gi.WriteByte (svc_temp_entity);
					gi.WriteByte (TE_TELEPORT_EFFECT);
					gi.WritePosition (v);
					gi.multicast (v, MULTICAST_PHS);
				}
			}
		}
	}
}

/*
=================
Cmd_Wave_f
=================
*/
void Cmd_Wave_f (edict_t *ent)
{
	int		i;

	i = atoi (gi.argv(1));

	// can't wave when ducked
	if (ent->client->ps.pmove.pm_flags & PMF_DUCKED)
		return;

	if (ent->client->anim_priority > ANIM_WAVE)
		return;

	ent->client->anim_priority = ANIM_WAVE;

	switch (i)
	{
	case 0:
		gi.cprintf (ent, PRINT_HIGH, "flipoff\n");
		ent->s.frame = FRAME_flip01-1;
		ent->client->anim_end = FRAME_flip12;
		break;
	case 1:
		gi.cprintf (ent, PRINT_HIGH, "salute\n");
		ent->s.frame = FRAME_salute01-1;
		ent->client->anim_end = FRAME_salute11;
		break;
	case 2:
		gi.cprintf (ent, PRINT_HIGH, "taunt\n");
		ent->s.frame = FRAME_taunt01-1;
		ent->client->anim_end = FRAME_taunt17;
		break;
	case 3:
		gi.cprintf (ent, PRINT_HIGH, "wave\n");
		ent->s.frame = FRAME_wave01-1;
		ent->client->anim_end = FRAME_wave11;
		break;
	case 4:
	default:
		gi.cprintf (ent, PRINT_HIGH, "point\n");
		ent->s.frame = FRAME_point01-1;
		ent->client->anim_end = FRAME_point12;
		break;
	}
}

/*
==================
Cmd_Say_f
==================
*/
void Cmd_Say_f (edict_t *ent, qboolean team, qboolean arg0)
{
	int		j;
	edict_t	*other;
	char	*p;
	char	text[2048];
	//flood protection code
    int time_left=0; 

	//end flood protection code
	if (gi.argc () < 2 && !arg0)
		return;

// Begin - Message Flooding Protection Code. 

// if not already in a timer situation then.. 
	if (!(ent->client->flood_timer > PRESENT_TIME)) 
// if attempt to post more than 3 msgs in 1 unit of time. 
    if ((ent->client->flood_num_msgs >= 3) && (ent->client->flood_post_time+1 > PRESENT_TIME))
	{
		ent->client->flood_timer = PRESENT_TIME + 30; // Start 30 sec Timer. 
		ent->client->flood_post_time = PRESENT_TIME; // Reset First Post Time. 
		ent->client->flood_num_msgs = 0;
	} // Reset Num Messages posted 


	// Timer is running so NO POSTS ALLOWED. Just printf and exit.. 
	if (ent->client->flood_timer > PRESENT_TIME)
	{
		time_left = (int)(ent->client->flood_timer - PRESENT_TIME); 
		gi.cprintf(ent, PRINT_HIGH, "You can't talk for %i more seconds..\n",time_left); 
		return;
	} 

// End - Message Flood Protection 

	if (!((int)(dmflags->value) & (DF_MODELTEAMS | DF_SKINTEAMS)))
		team = false;

	if (team)
		Com_sprintf (text, sizeof(text), "(%s): ", ent->client->pers.netname);
	else
		Com_sprintf (text, sizeof(text), "%s: ", ent->client->pers.netname);

	if (arg0)
	{
		strcat (text, gi.argv(0));
		strcat (text, " ");
		strcat (text, gi.args());
	}
	else
	{
		p = gi.args();

		if (*p == '"')
		{
			p++;
			p[strlen(p)-1] = 0;
		}
		strcat(text, p);
	}

	// don't let text be too long for malicious reasons
	if (strlen(text) > 150)
		text[150] = 0;

	strcat(text, "\n");

	if (dedicated->value)
		gi.cprintf(NULL, PRINT_CHAT, "%s", text);

	for (j = 1; j <= game.maxclients; j++)
	{
		other = &g_edicts[j];
		if (!other->inuse)
			continue;
		if (!other->client)
			continue;
		if (team)
		{
			if (!OnSameTeam(ent, other))
				continue;
		}
		gi.cprintf(other, PRINT_CHAT, "%s", text);
	}
    // Increment Flood Msg Count 
    ent->client->flood_num_msgs += 1; 

    // Capture first post time 
     if (ent->client->flood_post_time + 1 < PRESENT_TIME) 
      ent->client->flood_post_time = PRESENT_TIME; 
}

void Join1 (edict_t *ent, pmenu_t *menu) 
{
    JoinTeam (ent, 1);
	PMenu_Close(ent);
    Cmd_Class_f (ent);
}

void Join2 (edict_t *ent, pmenu_t *menu) 
{
    JoinTeam (ent, 2);
	PMenu_Close(ent);
    Cmd_Class_f (ent);
}

void Camera (edict_t *ent, pmenu_t *menu) 
{
	stuffcmd (ent, "spectator 1\n");
}

pmenu_t team[] = 
{
	{	"*TFII X-Project", PMENU_ALIGN_CENTER, -1, NULL, NULL },
	{	"*Select Your Team", PMENU_ALIGN_CENTER, -1, NULL, NULL },
	{	NULL, PMENU_ALIGN_CENTER, -1, NULL, NULL },
	{	"1. Join Red Team", PMENU_ALIGN_LEFT, 1, NULL, Join1 },
	{	"2. Join Blue Team", PMENU_ALIGN_LEFT, 2, NULL, Join2 },
	{	"3. Observer", PMENU_ALIGN_LEFT, 3, NULL, Camera },
	{	NULL, PMENU_ALIGN_CENTER, -1, NULL, NULL },
	{	NULL, PMENU_ALIGN_CENTER, -2, NULL, NULL },
	{	NULL, PMENU_ALIGN_CENTER, -3, NULL, NULL },
	{	NULL, PMENU_ALIGN_CENTER, -4, NULL, NULL },
	{   "Use [ and ] to move cursor",	PMENU_ALIGN_LEFT, -1, NULL, NULL },
	{   "ENTER to select",	PMENU_ALIGN_LEFT, -1, NULL, NULL },
	{   "ESC to Exit Menu",	PMENU_ALIGN_LEFT, -1, NULL, NULL },
	{   "(TAB to Return)",	PMENU_ALIGN_LEFT, -1, NULL, NULL },
	{   NULL,				PMENU_ALIGN_LEFT, -1, NULL, NULL },
	{   "v " TF_VER,      	PMENU_ALIGN_RIGHT, -1, NULL, NULL }
};

//========================================
// Prints fmt to self's team
void strcpy_ (char *s, char *fmt, ...)
{
    va_list ap;
    static char st[100];

    va_start (ap, fmt);
    vsprintf (st, fmt, ap);
    va_end (ap);

    strcpy (s, st);
}

void Cmd_Team_f (edict_t *ent)
{
	int team11;
	static char team1[22], team2[22];
	static int num1, num2;

	if (ent->client->resp.s_team > 0)
		return;

	// Check to see if the menu is already open
	if (ent->client->showscores || ent->client->showinventory || ent->client->menu)
        return;
		
	num1 = TeamFortress_GetPlayersByNum (1);
	num2 = TeamFortress_GetPlayersByNum (2);

	if ((int)tflags->value & RF_FORCE_JOIN && num1 != num2)
	{
		if (num1 > num2)
			JoinTeam (ent, 2);
		else if (num2 > num1)
        	JoinTeam (ent, 1);
				
		Cmd_Class_f (ent);
		return;
	}

   // send the layout
   sprintf (team1, "1. Red Team  (%i players)", num1);
   sprintf (team2, "2. Blue Team (%i players)", num2);

   team[3].text = team1;
   team[4].text = team2;
   team[5].text = "3. Observer";

   if (num1 > num2)
	   team11 = 2;
   else if (num2 > num1)
	   team11 = 1;
   else
	   team11 = (rand()&1) + 1;

	if (team11 == 1)
		team11 = 3;
	else
		team11 = 5;

   PMenu_Open(ent, team, -1, sizeof(team)/sizeof(pmenu_t));

} // Cmd_MyWave_f

pmenu_t menu[];

void Class_Scout (edict_t *ent, pmenu_t *menu)
{
	ClassFunction (ent, PC_SCOUT);
	PMenu_Close(ent);
}

void Class_Sniper (edict_t *ent, pmenu_t *menu)
{
	ClassFunction (ent, PC_SNIPER);
	PMenu_Close(ent);
}

void Class_Soldier (edict_t *ent, pmenu_t *menu)
{
	ClassFunction (ent, PC_SOLDIER);
	PMenu_Close(ent);
}

void Class_Hwguy (edict_t *ent, pmenu_t *menu)
{
	ClassFunction (ent, PC_HWGUY);
	PMenu_Close(ent);
}

void Class_Demoman (edict_t *ent, pmenu_t *menu)
{
	ClassFunction (ent, PC_DEMOMAN);
	PMenu_Close(ent);
}

void Class_Medic (edict_t *ent, pmenu_t *menu)
{
	ClassFunction (ent, PC_MEDIC);
	PMenu_Close(ent);
}

void Class_Pyro (edict_t *ent, pmenu_t *menu)
{
	ClassFunction (ent, PC_PYRO);
	PMenu_Close(ent);
}

void Class_Engineer (edict_t *ent, pmenu_t *menu)
{
	ClassFunction (ent, PC_ENGINEER);
	PMenu_Close(ent);
}

void Class_Spy (edict_t *ent, pmenu_t *menu)
{
	ClassFunction (ent, PC_SPY);
	PMenu_Close(ent);
}

pmenu_t class_st[];

void Random_Class (edict_t *ent, pmenu_t *menu1)
{
	int i;
	int n;
	pmenu_t *menu = (ent->deadflag) ? menu1 : ent->client->menu->entries;

	if (!menu1)
	{
		ClassFunction (ent, 1);
		gi.cprintf (ent, PRINT_HIGH, "Invalid menu\n");
		return;
	}

	do
	{
		i = rand() % 9;
		n = i + 1;

		if (menu[n].button != -1)
			break;
	}
	while (1);

	gi.dprintf ("%i\n", menu[n].button);

	ClassFunction (ent, i);
	ent->ripstate |= STATE_RANDOM;
	gi.cprintf (ent, PRINT_HIGH, "Random class\n");

	if (ent->client->menu)
		PMenu_Close(ent);
}

pmenu_t class_st[] = 
{
	{	"*Select Your Class", PMENU_ALIGN_CENTER, -1, NULL, NULL },
	{	NULL, PMENU_ALIGN_CENTER, -1, NULL, NULL },
	{	"1. Scout", PMENU_ALIGN_LEFT, 1, NULL, Class_Scout },
	{	"2. Sniper", PMENU_ALIGN_LEFT, 2, NULL, Class_Sniper },
	{	"3. Soldier", PMENU_ALIGN_LEFT, 3, NULL, Class_Soldier },
	{	"4. Heavy Weapons Guy", PMENU_ALIGN_LEFT, 4, NULL, Class_Hwguy },
	{	"5. Demoman", PMENU_ALIGN_LEFT, 5, NULL, Class_Demoman },
	{	"6. Medic", PMENU_ALIGN_LEFT, 6, NULL, Class_Medic },
	{	"7. Pyro", PMENU_ALIGN_LEFT, 7, NULL, Class_Pyro },
	{	"8. Engineer", PMENU_ALIGN_LEFT, 8, NULL, Class_Engineer },
	{	"9. Spy", PMENU_ALIGN_LEFT, 9, NULL, Class_Spy },
	{   NULL, PMENU_ALIGN_CENTER, -1, NULL, NULL },
	{	"0. Random Class",  PMENU_ALIGN_LEFT, 0, NULL, Random_Class }
};

void dmi (pmenu_t *menu, int i)
{
	menu[i].text = NULL;
	menu[i].SelectFunc = NULL;
	menu[i].button = -1;
	menu[i].align = PMENU_ALIGN_CENTER;
}

int parse_classes (int team, pmenu_t *menu)
{
	pmenu_t temp[] = 
	{
		{	"*Select Your Class", PMENU_ALIGN_CENTER, -1, NULL, NULL },
		{	NULL, PMENU_ALIGN_CENTER, -1, NULL, NULL },
		{	"1. Scout", PMENU_ALIGN_LEFT, 1, NULL, Class_Scout },
		{	"2. Sniper", PMENU_ALIGN_LEFT, 2, NULL, Class_Sniper },
		{	"3. Soldier", PMENU_ALIGN_LEFT, 3, NULL, Class_Soldier },
		{	"4. Heavy Weapons Guy", PMENU_ALIGN_LEFT, 4, NULL, Class_Hwguy },
		{	"5. Demoman", PMENU_ALIGN_LEFT, 5, NULL, Class_Demoman },
		{	"6. Medic", PMENU_ALIGN_LEFT, 6, NULL, Class_Medic },
		{	"7. Pyro", PMENU_ALIGN_LEFT, 7, NULL, Class_Pyro },
		{	"8. Engineer", PMENU_ALIGN_LEFT, 8, NULL, Class_Engineer },
		{	"9. Spy", PMENU_ALIGN_LEFT, 9, NULL, Class_Spy },
		{   NULL, PMENU_ALIGN_CENTER, -1, NULL, NULL },
		{	"0. Random Class",  PMENU_ALIGN_LEFT, 0, NULL, Random_Class }
	};

	if ((max_scouts->value >= 0) && max_scouts->value <= num_classes[team][1])
		dmi (menu, 2);
	else
		menu[2] = temp[2];

	if ((max_snipers->value >= 0) && max_snipers->value <= num_classes[team][2])
		dmi (menu, 3);
	else
		menu[3] = temp[3];

	if ((max_soldiers->value >= 0) && max_soldiers->value <= num_classes[team][3])
		dmi (menu, 4);
	else
		menu[4] = temp[4];

	if ((max_hwguys->value >= 0) && max_hwguys->value <= num_classes[team][4])
		dmi (menu, 5);
	else
		menu[5] = temp[5];

	if ((max_demomen->value >= 0) && max_demomen->value <= num_classes[team][5])
		dmi (menu, 6);
	else
		menu[6] = temp[6];

	if ((max_medics->value >= 0) && max_medics->value <= num_classes[team][6])
		dmi (menu, 7);
	else
		menu[7] = temp[7];

	if ((max_pyro->value >= 0) && max_pyro->value <= num_classes[team][7])
		dmi (menu, 8);
	else
		menu[8] = temp[8];

	if ((max_engin->value >= 0) && max_engin->value <= num_classes[team][8])
		dmi (menu, 9);
	else
		menu[9] = temp[9];

	if ((max_spies->value >= 0) && max_spies->value <= num_classes[team][9])
		dmi (menu, 10);
	else
		menu[10] = temp[10];

	return -1;
}

void Cmd_Class_f (edict_t *ent)
{
   if (ent->client->showscores || ent->client->showinventory || 
        ent->client->menu)
        return;

   PMenu_Open(ent, class_st, parse_classes(ent->client->resp.s_team, class_st), sizeof(class_st)/sizeof(pmenu_t));
}

void Cmd_DetPipes_f (edict_t *ent);

qboolean check_stand (edict_t *ent)
{
	vec3_t v1, v2;
	trace_t tr;

	if (!ent->client->feining)
	{
		edict_t *ent1;

		ent1 = NULL;

		if ((ent1 = findradius (ent1, ent->s.origin, 64)) != NULL && ent1 != ent)
		{
			gi.cprintf (ent, PRINT_HIGH, "You can feign on the top of another spy\n");
			return false;
		}
		else
			return true;
	}

	VectorSet (v1, ent->s.origin[0] + 16, ent->s.origin[1], ent->s.origin[2] + 20);
	VectorSet (v2, ent->s.origin[0] - 16, ent->s.origin[1], ent->s.origin[2] + 20);

    tr = gi.trace (ent->s.origin, NULL, NULL, v1, ent, MASK_SHOT);

	if (tr.fraction < 0)
	{
		 if (tr.ent && onground (tr.ent))
		 {
			 if (tr.ent->mass && tr.ent->deadflag != DEAD_DEAD)
			 {
				  gi.cprintf (ent, PRINT_HIGH, "You can't get up while someone\nis standing on you.\n\n");
			 }

			return false;
		 }
	}

    tr = gi.trace (ent->s.origin, NULL, NULL, v2, ent, MASK_SHOT);

	if (tr.fraction < 0)
	{
		 if (tr.ent && onground (tr.ent))
		 {
			 if (tr.ent->mass)
			 {
				 if (!tr.ent->client)
					  gi.cprintf (ent, PRINT_HIGH, "Something stands on you.\n");
				 else
					  gi.cprintf (ent, PRINT_HIGH, "Somebody stands on you.\n");
			 }

			return false;
		 }
	}

	return true;
}

void Feign (edict_t *self, qboolean sfeign)
{
	static int i;

	if (self->playerclass != PC_SPY || self->client->chasetoggle)
		return;

	if (!check_stand(self))
		return;

	i = (i+1)%3;
 
	if (!self->client->feining)
	{
		self->client->anim_priority = ANIM_DEATH;

        switch (i)
		{
		case 0:
			self->s.frame = FRAME_death101-1;
			self->client->anim_end = FRAME_death106;
			break;
		case 1:
			self->s.frame = FRAME_death201-1;
			self->client->anim_end = FRAME_death206;
			break;
		case 2:
			self->s.frame = FRAME_death301-1;
			self->client->anim_end = FRAME_death308;
			break;
		}

		if (!sfeign)
			gi.sound (self, CHAN_VOICE, gi.soundindex(va("*death%i.wav", (rand()%4)+1)), 1, ATTN_NORM, 0);

        CTFDeadDropFlag(self);
		self->s.modelindex2 = 0;
		self->movetype = MOVETYPE_TOSS;
		self->client->ps.pmove.pm_type = PM_DEAD;
		self->client->feining = true;
		gi.linkentity (self);
	}
	else
	{
		self->client->anim_priority = ANIM_BASIC;
		self->client->ps.pmove.pm_type = PM_NORMAL;
		if (!self->client->chasetoggle)
    		self->client->ps.gunindex = gi.modelindex(self->client->pers.weapon->view_model);
		self->client->feining = false;
	}
}

void Undercover_Skin (edict_t *ent)
{
    if ((int)tflags->value & RF_SPYINVIS)
	{
	  	ent->svflags |= SVF_NOCLIENT;
		ent->ripstate |= STATE_SKIN;	
		return;
	}

	Rip_SetSkin (ent);

	if (ent->bullets != PC_SPY)
		gi.cprintf (ent, PRINT_HIGH, "You are undercover now.\n");
	else
	{
		gi.cprintf (ent, PRINT_HIGH, "Skin reset.\n");
		ent->ripstate &= ~STATE_UNDERCOVER;
	}
	
	ent->ripstate |= STATE_SKIN;
}

void Spy_RemoveDisguise (edict_t *self)
{
	self->rockets = self->client->resp.s_team;
	Rip_SetSkin(self);
	self->ripstate &= ~STATE_UNDERCOVER;
	self->svflags &= ~SVF_NOCLIENT;
}

void GoUndercover (edict_t *self, int i)
{
   	self->client->DisguiseTime = level.time + 4;
    self->ripstate &= ~STATE_SKIN;

	self->bullets = i;

    if ((int)tflags->value & RF_SPYINVIS)
	  	self->svflags |= SVF_NOCLIENT; 

	self->ripstate |= STATE_UNDERCOVER;
}

void Undercover_Color (edict_t *ent)
{
    if ((int)tflags->value & RF_SPYINVIS)
	{
	  	ent->svflags |= SVF_NOCLIENT;
		ent->ripstate |= STATE_SKIN;	
      	return;
	}

    Rip_SetSkin (ent);

	if (ent->rockets == 1)
		gi.cprintf (ent, PRINT_HIGH, "Changed color to red.\n");
	else
		gi.cprintf (ent, PRINT_HIGH, "Changed color to blue.\n");

	if (ent->rockets == ent->client->resp.s_team)
		ent->ripstate &= ~STATE_UNDERCOVER;
	
	ent->ripstate |= STATE_SKIN;
}

void C_C (edict_t *self)
{
   	self->client->ColorTime = level.time + 4;
    self->ripstate &= ~STATE_SKIN;

	self->ripstate |= STATE_UNDERCOVER;
}

void go_u (edict_t *ent, pmenu_t *menu)
{
	GoUndercover (ent, ent->client->menu->cur - 1);
	PMenu_Close(ent);
}

pmenu_t undercover[] =
{
	{	"*Select Your Skin", PMENU_ALIGN_CENTER, -1, NULL, NULL },
	{	NULL, PMENU_ALIGN_CENTER, -1, NULL, NULL },
	{	"1. Scout", PMENU_ALIGN_LEFT, 1, NULL, go_u },
	{	"2. Sniper", PMENU_ALIGN_LEFT, 2, NULL, go_u },
	{	"3. Soldier", PMENU_ALIGN_LEFT, 3, NULL, go_u },
	{	"4. Heavy Weapons Guy", PMENU_ALIGN_LEFT, 4, NULL, go_u },
	{	"5. Demoman", PMENU_ALIGN_LEFT, 5, NULL, go_u },
	{	"6. Medic", PMENU_ALIGN_LEFT, 6, NULL, go_u },
	{	"7. Pyro", PMENU_ALIGN_LEFT, 7, NULL, go_u },
	{	"8. Engineer", PMENU_ALIGN_LEFT, 8, NULL, go_u },
	{	"9. Spy", PMENU_ALIGN_LEFT, 9, NULL, go_u }
};

void Cmd_Skin_f (edict_t *ent)
{
	// Check to see if the menu is already open

   if (ent->client->showscores || ent->client->showinventory || 
        ent->client->menu)
        return;
  
   PMenu_Open(ent, undercover, parse_classes(ent->client->resp.s_team, undercover), sizeof(undercover)/sizeof(pmenu_t));
}

void c_s (edict_t *ent, pmenu_t *menu)
{
	PMenu_Close(ent);
	Cmd_Skin_f (ent);
}

void c_c1 (edict_t *ent, pmenu_t *menu)
{
    ent->rockets = 1;
	C_C (ent);
	PMenu_Close(ent);
}

void c_c2 (edict_t *ent, pmenu_t *menu)
{
    ent->rockets = 2;
	C_C (ent);
	PMenu_Close(ent);
}

void feign_ (edict_t *ent, pmenu_t *menu)
{
	Feign(ent, false);
	PMenu_Close(ent);
}

void SFeign (edict_t *ent)
{
	edict_t *player;
	int i;
	qboolean is_visible = false;

	for (i = 0; i < maxclients->value; i++)
	{
		player = &g_edicts[i];

		if (!player->inuse || player == ent)
			continue;
		if (visible (ent, player))
		{
			is_visible = true;
			break;
		}
	}

	Feign (ent, !is_visible);
}

void SFeign_ (edict_t *ent, pmenu_t *menu)
{
	SFeign (ent);
	PMenu_Close (ent);
}

pmenu_t dis[] =
{
	{	"*Disguise", PMENU_ALIGN_LEFT, -1, NULL, NULL },
	{	NULL, PMENU_ALIGN_CENTER, -1, NULL, NULL },
	{	"1. Change Skin", PMENU_ALIGN_LEFT, 1, NULL, c_s },
	{	"2. Change Color to Red", PMENU_ALIGN_LEFT, 2, NULL, c_c1 },
	{	"3. Change Color to Blue", PMENU_ALIGN_LEFT, 3, NULL, c_c2 },
	{	"4. Feign", PMENU_ALIGN_LEFT, 4, NULL, feign_ },
	{	"5. Silent Feign", PMENU_ALIGN_LEFT, 5, NULL, SFeign_ }
};

void Cmd_Disguise_f (edict_t *ent)
{
	// Check to see if the menu is already open
    if (ent->client->showscores || ent->client->showinventory || 
        ent->client->menu)
        return;

	if (ent->playerclass != PC_SPY)
		return;

	(ent->client->feining) ? (dis[5].text = "Stop Feigning") : (dis[5].text = "Start Feigning");

	PMenu_Open(ent, dis, -1, sizeof(dis)/sizeof(pmenu_t));
} 

void Cmd_PlayerList_f(edict_t *ent)
{
	int i;
	char st[80];
	char text[1400];
	edict_t *e2;

	// connect time, ping, score, name
	*text = 0;
	for (i = 0, e2 = g_edicts + 1; i < maxclients->value; i++, e2++) {
		if (!e2->inuse)
			continue;

		Com_sprintf(st, sizeof(st), "%02d:%02d %4d %3d %s%s\n",
			(level.framenum - e2->client->resp.enterframe) / 600,
			((level.framenum - e2->client->resp.enterframe) % 600)/10,
			e2->client->ping,
			e2->client->resp.score,
			e2->client->pers.netname,
			e2->client->resp.spectator ? " (spectator)" : "");
		if (strlen(text) + strlen(st) > sizeof(text) - 50) {
			sprintf(text+strlen(text), "And more...\n");
			gi.cprintf(ent, PRINT_HIGH, "%s", text);
			return;
		}
		strcat(text, st);
	}
	gi.cprintf(ent, PRINT_HIGH, "%s", text);
}

void Cmd_Autozoom_f (edict_t *ent)
{
	if (ent->client->SonicDamage)
	{
		gi.cprintf (ent, PRINT_HIGH, "You can't change autozoom while snipering.\n");
		return;
	}

	if (ITEM_INDEX(ent->client->pers.weapon) == ITEMLIST_SNIPERRIFLE)
	{
		if (ent->ripstate & STATE_AUTO)
		{
			ent->ripstate &= ~STATE_AUTO;
			gi.cprintf (ent, PRINT_HIGH, "Sniper rifle ready\n");
		}
		else
		{
			ent->ripstate |= STATE_AUTO;
			gi.cprintf (ent, PRINT_HIGH, "Rifle on fully auto\n");
		}
	}
}

void Cmd_Main_f (edict_t *ent)
{
	if (!ent->playerclass)
		return;

	if (ent->playerclass == PC_DEMOMAN)
		Cmd_DetPipes_f (ent);
	else if (ent->playerclass == PC_ENGINEER)
		Cmd_Build_f (ent);
	else if (ent->playerclass == PC_SPY)
		Cmd_Disguise_f (ent);
	else if (ent->playerclass == PC_SNIPER)
		Cmd_Autozoom_f (ent);
	else if (ent->playerclass == PC_PYRO)
	{
		if (ent->client->pers.weapon == FindItem("Flamethrower"))
		{
			if (ent->client->pers.inventory[ITEMLIST_ROCKETS])
			{
				ent->client->newweapon = FindItem("Incendiary Cannon");
				ChangeWeapon(ent);
			}
			else
				gi.cprintf (ent, PRINT_HIGH, "No rockets for Incendiary Cannon\n");
		}
		else if (ent->client->pers.weapon == FindItem("Incendiary Cannon"))
		{
			if (ent->client->pers.inventory[ITEMLIST_CELLS])
			{
				ent->client->newweapon = FindItem("Flamethrower");
				ChangeWeapon(ent);
			}
			else
				gi.cprintf (ent, PRINT_HIGH, "No cells for Flamethrower\n");
		}
	}
	else if (ent->playerclass == PC_HWGUY)
	{
		if (ent->client->pers.weapon == FindItem("Super Shotgun"))
		{
			if (ent->client->pers.inventory[ITEMLIST_SHELLS] && 
				ent->client->pers.inventory[ITEMLIST_CELLS] >= 4)
			{
				ent->client->newweapon = FindItem("Assault Cannon");
				ent->client->pers.inventory[ITEMLIST_CELLS] -= 4;
				ChangeWeapon(ent);
			}
			else
				gi.cprintf (ent, PRINT_HIGH, "Not ehough ammo for Assault Cannon\n");
		}
		else if (ent->client->pers.weapon == FindItem("Assault Cannon"))
		{
			if (ent->client->pers.inventory[ITEMLIST_SHELLS] >= 2)
			{
				ent->client->newweapon = FindItem("Super Shotgun");
				ChangeWeapon(ent);
			}
			else
				gi.cprintf (ent, PRINT_HIGH, "Not enough shells for Super Shotgun\n");
		}
	}
	else if (ent->playerclass == PC_MEDIC)
	{
		if (ent->client->pers.weapon == FindItem("Machinegun"))
		{
			if (ent->client->pers.inventory[ITEMLIST_MEDIKIT])
			{
				ent->client->newweapon = FindItem("Bioweapon");
				ChangeWeapon(ent);
			}
			else
				gi.cprintf (ent, PRINT_HIGH, "No medikits for BioWeapon\n");
		}
		else if (ent->client->pers.weapon == FindItem("Bioweapon"))
		{
			if (ent->client->pers.inventory[ITEMLIST_BULLETS])
			{
				ent->client->newweapon = FindItem("Machinegun");
				ChangeWeapon(ent);
			}
			else
				gi.cprintf (ent, PRINT_HIGH, "No bullets for Machinegun\n");
		}
	}
}

/*
=================
ClientCommand
=================
*/
void ClientCommand (edict_t *ent)
{
	char	*cmd;

	if (!ent->client)
		return;		// not fully in game yet

	if (level.intermissiontime)
		return;

	cmd = gi.argv(0);

	if (Q_stricmp (cmd, "players") == 0)
	{
		Cmd_Players_f (ent);
		return;
	}
	if (Q_stricmp (cmd, "say") == 0)
	{
		Cmd_Say_f (ent, false, false);
		return;
	}
	if (Q_stricmp (cmd, "say_team") == 0)
	{
		CTFSay_Team(ent, gi.args());
		return;
	}
	if (Q_stricmp (cmd, "score") == 0)
	{
		Cmd_Score_f (ent);
		return;
	}
	if (Q_stricmp (cmd, "help") == 0)
	{
		Cmd_Help_f (ent);
		return;
	}
    else if (Q_stricmp (cmd, "use") == 0)
		Cmd_Use_f (ent);
	else if (Q_stricmp (cmd, "drop") == 0)
		Cmd_Drop_f (ent);
	else if (Q_stricmp (cmd, "give") == 0)
		Cmd_Give_f (ent);
	else if (Q_stricmp (cmd, "god") == 0)
		Cmd_God_f (ent);
	else if (Q_stricmp (cmd, "notarget") == 0)
		Cmd_Notarget_f (ent);
	else if (Q_stricmp (cmd, "noclip") == 0)
		Cmd_Noclip_f (ent);
	else if (Q_stricmp (cmd, "inven") == 0)
		Cmd_Inven_f (ent);
	else if (Q_stricmp (cmd, "invnext") == 0)
		SelectNextItem (ent, -1);
	else if (Q_stricmp (cmd, "invprev") == 0)
		SelectPrevItem (ent, -1);
	else if (Q_stricmp (cmd, "invnextw") == 0)
		SelectNextItem (ent, IT_WEAPON);
	else if (Q_stricmp (cmd, "invprevw") == 0)
		SelectPrevItem (ent, IT_WEAPON);
	else if (Q_stricmp (cmd, "invnextp") == 0)
		SelectNextItem (ent, IT_POWERUP);
	else if (Q_stricmp (cmd, "invprevp") == 0)
		SelectPrevItem (ent, IT_POWERUP);
	else if (Q_stricmp (cmd, "invuse") == 0)
		Cmd_InvUse_f (ent);
	else if (Q_stricmp (cmd, "invdrop") == 0)
		Cmd_InvDrop_f (ent);
	else if (Q_stricmp (cmd, "disguise") == 0)
		Cmd_Disguise_f (ent);
	else if (Q_stricmp (cmd, "weapprev") == 0)
		Cmd_WeapPrev_f (ent);
	else if (Q_stricmp (cmd, "weapnext") == 0)
		Cmd_WeapNext_f (ent);
	else if (Q_stricmp (cmd, "weaplast") == 0)
		Cmd_WeapLast_f (ent);
	else if (Q_stricmp (cmd, "kill") == 0)
		Cmd_Kill_f (ent);
	else if (Q_stricmp (cmd, "putaway") == 0)
		Cmd_PutAway_f (ent);
    else if (Q_stricmp (cmd, "wave") == 0)
		Cmd_Wave_f (ent);
	else if (Q_stricmp (cmd, "showinfo") == 0)
		Print_ClassProperties (ent);
	else if (Q_stricmp (cmd, "maphelp") == 0)
	{
		if (*level.goal)
            Print_Msg (ent, level.goal);

	}  
	else if (Q_stricmp (cmd, "autozoom") == 0)
	{
		gi.cprintf (ent, PRINT_HIGH, "Autozoom ");

		if (ent->client->pers.autozoom)
		{
			ent->client->pers.autozoom = false;
			gi.cprintf (ent, PRINT_HIGH, "OFF\n");
		}
		else
		{
			ent->client->pers.autozoom = true;
			gi.cprintf (ent, PRINT_HIGH, "ON\n");
		}
	}
	else if (Q_stricmp (cmd, "flaginfo") == 0)
        Flag_StatusReport (ent);
    else if (Q_stricmp (cmd, "special") == 0)
       	Cmd_Main_f (ent);
	else if (Q_stricmp (cmd, "id") == 0)
		Cmd_id_f (ent);
	else if (Q_stricmp (cmd, "build") == 0)
		Cmd_Build_f (ent);
	else if (Q_stricmp (cmd, "changeclass") == 0)
		Cmd_Class_f (ent);
	else if (Q_stricmp (cmd, "showclasses") == 0)
		PrintOtherClass (ent);
	else if (Q_stricmp (cmd, "showloc") == 0)
		Self_Origin (ent);
	else if (Q_stricmp (cmd, "auto") == 0)
		Cmd_Autozoom_f (ent);
	else if (Q_stricmp (cmd, "reset") == 0)
		stuffcmd (ent, "\n");
	else if (Q_stricmp (cmd, "reload") == 0)
		Cmd_Reload_f (ent);
	else if (Q_stricmp (cmd, "playerlist") == 0)
		Cmd_PlayerList_f (ent);
	else if (Q_stricmp (cmd, "det5") == 0)
		TeamFortress_SetDetpack (ent, 5);
	else if (Q_stricmp (cmd, "det20") == 0)
		TeamFortress_SetDetpack (ent, 20);
	else if (Q_stricmp (cmd, "det50") == 0)
		TeamFortress_SetDetpack (ent, 50);
	else if (Q_stricmp (cmd, "detstop") == 0)
		TeamFortress_DetpackStop (ent);
	else if (Q_stricmp (cmd, "saveme") == 0)
 	    TeamFotress_SaveMe (ent);
	else if (Q_stricmp (cmd, "scan") == 0)
		TeamFortress_Scan (ent, atoi(gi.argv(1)));
    else if (Q_stricmp (cmd, "primeone") == 0)
	{
		if (ent->client->last_grenade < level.time)
		{
			ent->client->gr_type = 0;
			Weapon_Grenade1 (ent);
		}
	}
	else if (Q_stricmp (cmd, "primetwo") == 0)
	{
		if (ent->client->last_grenade < level.time)
		{
			ent->client->gr_type = 1;
			Weapon_Grenade1 (ent);
		}
	}
	else if (Q_stricmp (cmd, "query") == 0)
        TeamFortress2_StatusQuery (ent);
	else if (Q_stricmp (cmd, "throwgren") == 0)
		Weapon_Grenade2 (ent);
	else if (Q_stricmp (cmd, "randompc") == 0)
	{
		gi.cprintf (ent, PRINT_HIGH, "After dying you will return as a random class.\n");
		ent->ripstate |= STATE_RANDOM;
	}
	else if (Q_stricmp (cmd, "discard") == 0)
		Cmd_Discard_f (ent);
	else if (Q_stricmp (cmd, "inv") == 0)
	{
		if (!ent->deadflag)
			gi.cprintf (ent, PRINT_HIGH, "You are in team %i\nGr.Type 1(%s) : %i\nGr.Type 2(%s) : %i\n", ent->client->resp.s_team, gr_type(ent, 0), ent->client->pers.grenades_left[0], gr_type(ent, 1), ent->client->pers.grenades_left[1]);
	}
    else if (Q_stricmp (cmd, "warp") == 0)
		Cmd_warp_f(ent);
	else if (Q_stricmp (cmd, "vote") == 0)
		Cmd_vote_f(ent);
    else if (Q_stricmp (cmd, "hook") == 0)
	{
		if (grapple->value)
			hook_fire (ent);
	}
	else if (Q_stricmp (cmd, "unhook") == 0)
	{
        if (ent->client->hook)
			if (grapple->value)
				hook_reset(ent->client->hook);
	}
	else if (Q_stricmp (cmd, "detpipe") == 0)
	{
		if (ent->playerclass == PC_DEMOMAN)
			Cmd_DetPipes_f (ent);
	}
    else if (Q_stricmp (cmd, "chasecam") == 0)
        Cmd_Chasecam_Toggle (ent);
	else if (Q_stricmp (cmd, "feign") == 0)
		Feign (ent, false);
	else if (Q_stricmp (cmd, "sfeign") == 0)
		SFeign (ent);
	else if (Q_stricmp (cmd, "scout") == 0)
	{
		if (!ent->client->resp.spectator && ent->lastclass != PC_SCOUT)
		{
			if ((max_scouts->value < 0) || max_scouts->value > num_classes[ent->client->resp.s_team][1])
			{
				ent->lastclass = 1;
				ent->ripstate &= ~STATE_RANDOM;
				gi.cprintf (ent, PRINT_HIGH, "After dying you will return as a scout\n");
			}
		}
	}
	else if (Q_stricmp (cmd, "sniper") == 0)
	{
		if (!ent->client->resp.spectator && ent->lastclass != PC_SNIPER)
		{
			if ((max_snipers->value < 0) || max_snipers->value > num_classes[ent->client->resp.s_team][2])
			{
				ent->lastclass = 2;
				ent->ripstate &= ~STATE_RANDOM;
				gi.cprintf (ent, PRINT_HIGH, "After dying you will return as a sniper\n");
			}
		}
	}
	else if (Q_stricmp (cmd, "soldier") == 0)
	{
		if (!ent->client->resp.spectator && ent->lastclass != PC_SOLDIER)
		{
			if ((max_soldiers->value < 0) || max_soldiers->value > num_classes[ent->client->resp.s_team][3])
			{
				ent->lastclass = 3;
				ent->ripstate &= ~STATE_RANDOM;
				gi.cprintf (ent, PRINT_HIGH, "After dying you will return as a soldier\n");
			}
		}
	}
	else if (Q_stricmp (cmd, "hwguy") == 0)
	{
		if (!ent->client->resp.spectator && ent->lastclass != PC_HWGUY)
		{
			if ((max_hwguys->value < 0) || max_hwguys->value > num_classes[ent->client->resp.s_team][4])
			{
				ent->lastclass = 4;
				ent->ripstate &= ~STATE_RANDOM;
				gi.cprintf (ent, PRINT_HIGH, "After dying you will return as a Heavy Weapons Guy\n");
			}
		}
	}
	else if (Q_stricmp (cmd, "demoman") == 0)
	{
		if (!ent->client->resp.spectator && ent->lastclass != PC_DEMOMAN)
		{
			if ((max_demomen->value < 0) || max_demomen->value > num_classes[ent->client->resp.s_team][5])
			{
				ent->lastclass = 5;
				ent->ripstate &= ~STATE_RANDOM;
				gi.cprintf (ent, PRINT_HIGH, "After dying you will return as a demoman\n");
			}
		}
	}
	else if (Q_stricmp (cmd, "medic") == 0)
	{
		if (!ent->client->resp.spectator && ent->lastclass != PC_MEDIC)
		{
			if ((max_medics->value < 0) || max_medics->value > num_classes[ent->client->resp.s_team][6])
			{
				ent->lastclass = 6;
				ent->ripstate &= ~STATE_RANDOM;
				gi.cprintf (ent, PRINT_HIGH, "After dying you will return as a medic\n");
			}
		}
	}
	else if (Q_stricmp (cmd, "pyro") == 0)
	{
		if (!ent->client->resp.spectator && ent->lastclass != PC_PYRO)
		{
			if ((max_pyro->value < 0) || max_pyro->value > num_classes[ent->client->resp.s_team][7])
			{
				ent->lastclass = 7;
				ent->ripstate &= ~STATE_RANDOM;
				gi.cprintf (ent, PRINT_HIGH, "After dying you will return as a pyro\n");
			}
		}
	}
	else if (Q_stricmp (cmd, "engineer") == 0)
	{
		if (!ent->client->resp.spectator && ent->lastclass != PC_ENGINEER)
		{
			if ((max_engin->value < 0) || max_engin->value > num_classes[ent->client->resp.s_team][8])
			{
				ent->lastclass = 8;
				ent->ripstate &= ~STATE_RANDOM;
				gi.cprintf (ent, PRINT_HIGH, "After dying you will return as an engineer\n");
			}
		}
	}
	else if (Q_stricmp (cmd, "spy") == 0)
	{
		if (!ent->client->resp.spectator && ent->lastclass != PC_SPY)
		{
			if ((max_spies->value < 0) || max_spies->value > num_classes[ent->client->resp.s_team][9])
			{
				ent->lastclass = 9;
				ent->ripstate &= ~STATE_RANDOM;
				gi.cprintf (ent, PRINT_HIGH, "After dying you will return as a spy\n");
			}
		}
	}
	else
		Cmd_Say_f (ent, false, true);
}