#include "g_local.h"

void TeamFortress_DetpackCountDown (edict_t *self);
void TFII_DetpackSet (edict_t *self);
void TeamFortress_SetDetpack (edict_t *self, int timer);
void TeamFortress_DetpackStop (edict_t *self);
void TeamFortress_DetpackExplode (edict_t *self);
void TeamFortress_DetpackTouch (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf);
void TeamFortress_DetpackDisarm (edict_t *self);
void TeamFortress_DetpackCountDown (edict_t *self);

//=========================================================================
// The detpack is set, let the player go and start timer
void TFII_DetpackSet (edict_t *self)
{
	edict_t *countd, *newmis;
	float	*v;

	self->owner->ripstate &= ~STATE_DETPACK;
	if (!self->owner->client->chasetoggle)
	   	self->owner->client->ps.gunindex = gi.modelindex(self->owner->client->pers.weapon->view_model);

	Rip_SetSpeed(self->owner);

#ifdef SPEECH
	stuffcmd(self->owner, "play speech/demo_dp.wav\n");
#endif

	newmis = G_Spawn ();
	newmis->owner = self->owner;
	newmis->movetype = MOVETYPE_TOSS;
	newmis->solid = SOLID_BBOX;
	newmis->classname = "detpack";
	newmis->ripstate = self->owner->client->resp.s_team;
   	newmis->touch = TeamFortress_DetpackTouch;
	newmis->mode = 0;  // Detpack mode = 1 when disarming
	newmis->s.modelindex = gi.modelindex("models/objects/detpack/tris.md2");
	newmis->clipmask = MASK_SHOT;

	VectorSet(newmis->s.angles, 0, 0, 0);
	v = tv(-16, -16, -15);
	VectorCopy (v, newmis->mins);
	v = tv(16, 16, 8);
	VectorCopy (v, newmis->maxs);
	gi.linkentity (newmis);
	VectorCopy(self->owner->s.origin, newmis->s.origin);
	VectorClear(newmis->velocity);
	VectorClear(newmis->avelocity);

	// Create the CountDown entity
    countd = G_Spawn();
	countd->think = TeamFortress_DetpackCountDown;
	countd->health = self->health - 1;
	countd->owner = self->owner;
	countd->classname = "countdown_timer"; // Don't call it timer, because we
	countd->enemy = newmis;

	if (self->health <= 10)
		countd->nextthink = level.time + 1;
	else
	{
		countd->nextthink = level.time + self->health - 10;
		countd->health = 9;
	}

	newmis->activator = countd;
	newmis->nextthink = level.time + self->health;
	newmis->think = TeamFortress_DetpackExplode;

	gi.cprintf(self->owner, PRINT_HIGH, "Detpack set!\n");

	gi.linkentity (countd);

	G_FreeEdict(self);
}

//=========================================================================
// Handles the Setting of Detpacks
void TeamFortress_SetDetpack (edict_t *self, int timer)
{
	edict_t *newmis;

	if (!self->client->pers.inventory[ITEMLIST_DETPACK])
		return;

	// Cant set detpack if you're in the air
	if (!self->groundentity)
	{
		gi.cprintf (self, PRINT_HIGH, "You can't set detpacks in the air.\n");
		return;
	}

	if (!stricmp (self->groundentity->classname, "b_d") ||
		!stricmp (self->groundentity->classname, "d_s") ||
		!stricmp (self->groundentity->classname, "sentry") || 
		!stricmp (self->groundentity->classname, "dispencer"))
	{
		gi.cprintf (self, PRINT_HIGH, "You can't set detpack on the top of the building.\n");
		return;
	}
	else if (!stricmp(self->groundentity->classname, "detpack"))
	{
		gi.cprintf (self, PRINT_HIGH, "Detpacks can't be stacked.\n");
		return;
	}
	else if (self->groundentity->client)
	{
		gi.cprintf (self, PRINT_HIGH, "You can't set detpack on %s.\n", self->groundentity->client->pers.netname);
		return;
	}

	if (timer < 5)
	{
		gi.cprintf (self, PRINT_HIGH, "You can't set detpacks for less that 5 seconds.\n");
		return;
	}

	if (timer > 255)
		timer = 255;

	self->client->pers.inventory[ITEMLIST_DETPACK] = 0;

	self->ripstate |= STATE_DETPACK;

	Rip_SetSpeed(self);

	gi.cprintf(self, PRINT_HIGH, "Setting detpack for %i seconds...\n", timer);

	newmis = G_Spawn();
	newmis->owner = self;
	newmis->classname = "timer_d";
	newmis->nextthink = level.time + 3;
	newmis->think = TFII_DetpackSet;
	newmis->health = timer;

	gi.linkentity (newmis);
}

//=========================================================================
// Stops the setting of the detpack
void TeamFortress_DetpackStop (edict_t *self)
{
	edict_t *detpack_timer = NULL;
	qboolean found = false;

	while ((detpack_timer = G_Find(detpack_timer, FOFS(classname), "timer_d")) != NULL)
	{
		if (detpack_timer->owner != self)
			continue;
		
		G_FreeEdict(detpack_timer);
		found = true;
		break;
	}

	if (!found)
		return;

	gi.cprintf(self, PRINT_HIGH, "Detpack retrieved.\n");
		
	self->client->pers.inventory[ITEMLIST_DETPACK]++;

	if (!self->client->chasetoggle)
	   	self->client->ps.gunindex = gi.modelindex(self->client->pers.weapon->view_model);

	self->ripstate &= ~STATE_DETPACK;

	Rip_SetSpeed(self);
}

//=========================================================================
// The detpack goes BOOM!
void TeamFortress_DetpackExplode (edict_t *self)
{
	int pos;

	gi.bprintf(PRINT_MEDIUM, "FIRE IN THE HOLE!\n");

	// Check the pointcontents to prevent detpack outside the world
	pos = gi.pointcontents(self->s.origin); 

	if (pos != CONTENTS_SOLID && pos != CONTENTS_WINDOW) 
	{
		T_RadiusDamage (self, self->owner, 700, world, 700, MOD_DETPACK);
        G_Explosion (self);
	}
	else
		gi.dprintf("Detpack fizzled out.\n");

	// This code handles a disarming scout with protection
	if (self->mode == 1)     	  // Detpack was being disarmed
	{   
		Rip_SetSpeed(self->enemy);
		G_FreeEdict(self->activator);  	 // CountDown
		G_FreeEdict(self->creator); //	Disarm timer
	}

	G_Explosion (self);
	G_FreeEdict (self);
}

//=========================================================================
// The detpack touch function. Scouts can disarm it.
void TeamFortress_DetpackTouch (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	edict_t *disarm;

	if (!other->client)
		return;
	if (other->playerclass != PC_SCOUT)
		return;
	if (self->mode == 1)
	    return;
	if ((other->client->resp.s_team == self->owner->client->resp.s_team) && (self->owner->client->resp.s_team))
	    return;
	if (!infront (self, other))
		return;

	other->ripstate |= STATE_DISARMING;

	gi.cprintf(other, PRINT_HIGH, "Disarming detpack...\n");

	Rip_SetSpeed(other);

	// Spawn disarming entity
	disarm = G_Spawn();
	disarm->owner = other;		// the scout
	disarm->enemy = self;		// the detpack
	disarm->classname = "timer";
	disarm->nextthink = level.time + 3;
	disarm->think = TeamFortress_DetpackDisarm;
	gi.linkentity (disarm);
	
	self->mode = 1;  // indicates disarming
	self->enemy = other;   // points to scout
	self->creator = disarm;
}

//=========================================================================
// The detpack disarm function. Scout has finished disarming it
// .enemy is the detpack
// .owner is the scout
void TeamFortress_DetpackDisarm (edict_t *self)
{
	gi.bprintf (PRINT_MEDIUM, "%s's detpack was defused by %s\n", self->enemy->owner->client->pers.netname, self->owner->client->pers.netname);
	
	self->owner->ripstate &= ~STATE_DISARMING;

	if (!(int) tflags->value & RF_NO_FRAG)
		self->owner->client->resp.score++;

	if (!self->owner->deadflag && !self->owner->client->chasetoggle)
		self->owner->client->ps.gunindex = gi.modelindex(self->owner->client->pers.weapon->view_model);

	// Reset speeds of scout
	Rip_SetSpeed(self->owner);
	
	G_FreeEdict(self->enemy->activator);	// remove count down
	G_FreeEdict(self->enemy);        	// remove detpack
	G_FreeEdict(self);					// remove this timer
}

//=========================================================================
// The Detpack CountDown function. Displays the seconds left before the
// detpack detonates to the owner of the detpack, if < 5
void TeamFortress_DetpackCountDown (edict_t *self)
{
	gi.cprintf(self->owner, PRINT_HIGH, "%i...\n", self->health);

	self->nextthink = level.time + 1;
	self->health--;

	if (self->health < 5)
	{
		if (self->enemy->s.effects != EF_FLAG1)
			self->enemy->s.effects = EF_FLAG1;
		else
			self->enemy->s.effects = 0;
	}

	if (!self->health)
		G_FreeEdict(self);
}

void Pipebomb_Explode (edict_t *ent)
{
	vec3_t		origin;

	ent->s.origin[2] += 10;

	//FIXME: if we are onground then raise our Z just a bit since we are a point?
	if (ent->enemy)
	{
		float	points;
		vec3_t	v;
		vec3_t	dir;

		VectorAdd (ent->enemy->mins, ent->enemy->maxs, v);
		VectorMA (ent->enemy->s.origin, 0.5, v, v);
		VectorSubtract (ent->s.origin, v, v);
		points = ent->dmg - 0.5 * VectorLength (v);
		VectorSubtract (ent->enemy->s.origin, ent->s.origin, dir);
		T_Damage (ent->enemy, ent, ent->owner, dir, ent->s.origin, vec3_origin, (int)points, (int)points, DAMAGE_RADIUS, MOD_PIPEBOMB);
	}

	T_RadiusDamage(ent, ent->owner, ent->dmg, ent->enemy, ent->dmg_radius, MOD_PIPEBOMB);

	VectorMA (ent->s.origin, -0.02, ent->velocity, origin);

	pipes_team[ent->ripstate-1]--;

	gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_EXPLOSION1);
	gi.WritePosition (ent->s.origin);
	gi.multicast (ent->s.origin, MULTICAST_PVS);

	G_FreeEdict (ent);
}

void Pipebomb_Touch (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	if (other == ent->owner)
		return;

	if (surf && (surf->flags & SURF_SKY))
	{
		G_FreeEdict (ent);
		return;
	}

	if (ent->velocity == vec3_origin)
		VectorClear (ent->avelocity);

	if (ent->spawnflags & 1)
	{
		if (random() > 0.5)
			gi.sound (ent, CHAN_VOICE, gi.soundindex ("weapons/hgrenb1a.wav"), 1, ATTN_NORM, 0);
		else
			gi.sound (ent, CHAN_VOICE, gi.soundindex ("weapons/hgrenb2a.wav"), 1, ATTN_NORM, 0);
	}
	else
 		gi.sound (ent, CHAN_VOICE, gi.soundindex ("weapons/grenlb1b.wav"), 1, ATTN_NORM, 0);

	if (!other->takedamage)
	{
		if (ent->spawnflags & 1)
		{
			if (random() > 0.5)
				gi.sound (ent, CHAN_VOICE, gi.soundindex ("weapons/hgrenb1a.wav"), 1, ATTN_NORM, 0);
			else
				gi.sound (ent, CHAN_VOICE, gi.soundindex ("weapons/hgrenb2a.wav"), 1, ATTN_NORM, 0);
		}
		else
			gi.sound (ent, CHAN_VOICE, gi.soundindex ("weapons/grenlb1b.wav"), 1, ATTN_NORM, 0);
	}
}

void Cmd_DetPipes_f (edict_t *ent)
{
	edict_t	*blip = NULL;

	if (ent->playerclass != PC_DEMOMAN)
		return;

	while ((blip = G_Find (blip, FOFS(classname), "pipebomb")) != NULL)
	{
		if (blip->inuse && blip->owner == ent)
			Pipebomb_Explode(blip);
	}
}

void Detonate_old (int team)
{
	edict_t	*blip = NULL;

	while ((blip = G_Find(blip, FOFS(classname), "pipebomb")) != NULL)
	{
		if (blip->owner->client->resp.s_team == team)
		{
			blip->think = Pipebomb_Explode;
			blip->nextthink = level.time + .5;
			return;
		}
	}
}

void pipebomb_throw (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius)
{
	edict_t	*grenade;
	vec3_t	dir;
	vec3_t	forward, right, up;
	vec3_t  mins = {-6, -6, -6};
	vec3_t  maxs = {6, 6, 6};

    if (self->playerclass != PC_DEMOMAN)
		return;

	damage_radius = damage+40;
	
	vectoangles (aimdir, dir);
	AngleVectors (dir, forward, right, up);
	grenade = G_Spawn();
	VectorCopy (start, grenade->s.origin);
	VectorScale (aimdir, speed, grenade->velocity);
	VectorMA (grenade->velocity, 200 + crandom() * 10.0, up, grenade->velocity);
	VectorMA (grenade->velocity, crandom() * 10.0, right, grenade->velocity);
	VectorSet (grenade->avelocity, 300, 300, 300);
	grenade->movetype = MOVETYPE_BOUNCE;
	grenade->clipmask = MASK_SHOT;
	grenade->solid = SOLID_BBOX;
	grenade->s.effects |= EF_GRENADE;
	VectorCopy (mins, grenade->mins);
	VectorCopy (maxs, grenade->maxs);
	grenade->s.modelindex = gi.modelindex ("models/objects/detpipe/tris.md2");
	grenade->owner = self;
	grenade->touch = Pipebomb_Touch;
	grenade->nextthink = level.time + timer;
	grenade->think = Pipebomb_Explode;
	grenade->dmg = damage;
	grenade->dmg_radius = damage_radius;
	grenade->classname = "pipebomb";
	grenade->ripstate = self->client->resp.s_team;
	gi.linkentity (grenade);

	pipes_team[grenade->ripstate-1]++;
}
