//
// this file by brian martin 1996
// brian@phyast.pitt.edu
//
// this is part of the source for the MedDLe quake model viewer/editor
//
//
#include "stdafx.h"
#include "MedDLe.h"
#include "MedDLeIO.h"
#include "MedDLeGif.h"
#include "MedDLeGFX\MedDLeGFX.h"

void BG_WriteBMP(FILE *out, unsigned char *pal, unsigned char *pic, unsigned w, unsigned h);
void write_gif(char *name, unsigned char *pic, unsigned w, unsigned h);
void BG_ReadBMP(FILE *in, unsigned char *pal, unsigned char *pic, unsigned *w, unsigned *h);


//  export mdl frame to :  asc,pov,wrl,raw,dfx,map,(3ds  almost)
void export_mdl_frame(char *filename, CMedDLeFrame *frame, CMedDLeDoc *pDoc)
{
	#include "normals.h"
/*
	// frame is really frame-1 since indices start at 0

	strlwr(filename);
	char  *ptr;


	///////////////////////////////// asc (3ds) out
	if(strstr(filename,".asc"))
	{
		FILE *out;

		out=fopen(filename,"wt");
		//if(out==NULL) { printf("can't create file\n"); getch(); return; }


		fprintf(out,"Ambient light color: Red=0.039216 Green=0.039216 Blue=0.039216\n\n");
		fprintf(out,"Named object: \"%s\"\n",frame->name);
		fprintf(out,"Tri-mesh, Vertices: %d    Faces: %d\n",(int)pDoc->num.vertices,(int)pDoc->num.triangles);
		fprintf(out,"Vertex list:\n");
		for(int i=0; i<pDoc->num.vertices; i++)
		{
			fprintf(out,"Vertex %d:  X: %lf  Y: %lf  Z: %lf\n",i,
				frame->fv[i].v[1],
				-frame->fv[i].v[0],
				frame->fv[i].v[2]);
		}
		fprintf(out,"Face list:\n");
		for(i=0; i<pDoc->num.triangles; i++)
		{
			// reverse order and say that no sides lie in a plane
			fprintf(out,"Face %d:  A:%u B:%u C:%u AB:1 BC:1 CA:1\n",i,
			pDoc->Tris[i].vindex[0],
			pDoc->Tris[i].vindex[2],
			pDoc->Tris[i].vindex[1]);
//			fprintf(out,"Smoothing:  %d\n",1);
		}

		fclose(out);
	}
	///////////////////////////////// wrl out
	else if(strstr(filename,".wrl") || strstr(filename,".vrml"))
	{

		FILE *out;
		out=fopen(filename,"wt");
		if(out==NULL) { return;}
		fprintf(out,"#VRML V1.0 ascii\n\n# Created by MedDLe\n# by Brian Martin\n# brian@phyast.pitt.edu\n\n");
		fprintf(out,"Separator {\n");
		fprintf(out,"\tPerspectiveCamera {\n");
		fprintf(out,"\t\tposition    0. 0. 100.\n");
		fprintf(out,"\t}\n");
		fprintf(out,"\tDEF %s Separator {\n",frame->name );


		fprintf(out,"\t\tMaterial { diffuseColor [ 0.5 0.5 0.5 ] }\n");
		fprintf(out,"\t\tTexture2 {\n");
		fprintf(out,"\t\t\tfilename \"skin.gif\"\n");
		fprintf(out,"\t\t}\n");

		// these are all the 2d points including the seemed ones
		fprintf(out,"\t\tTextureCoordinate2 {\n");
		fprintf(out,"\t\t\tpoint [\n");
		for(int i=0; i<pDoc->num.vertices; i++)
		{
			float s,t;
			s=pDoc->Verts[i].x;
			t=pDoc->SkinH-pDoc->Verts[i].y;
			s/=(float)pDoc->SkinW;
			t/=(float)pDoc->SkinH;
			fprintf(out,"\t\t\t%f %f,\n",s,t);
		}
		// add ones on seem plus extras
		for(i=0; i<pDoc->num.vertices; i++)
		{
			float s,t;
			s=pDoc->SkinW/2+pDoc->Verts[i].x;
			t=pDoc->SkinH-pDoc->Verts[i].y;
			s/=(float)pDoc->SkinW;
			t/=(float)pDoc->SkinH;
			fprintf(out,"\t\t\t%f %f,\n",s,t);
		}
		fprintf(out,"\t\t\t]\n\t\t}\n");

		fprintf(out,"\t\tCoordinate3 {\n\t\tpoint [\n");
		for( i=0; i<pDoc->num.vertices ;i++)
		{
			// vrml wacky coordinate system...
			fprintf(out,"\t\t\t%lf %lf %lf,\n",
			-frame->fv[i].v[1],
			frame->fv[i].v[2],
			frame->fv[i].v[0]);
		}

		fprintf(out,"\t\t\t]\n\t\t}\n");
		fprintf(out,"\t\tIndexedFaceSet {\n");
		fprintf(out,"\t\tcoordIndex [\n");
		for( i=0; i<pDoc->num.triangles ;i++)
		{
			fprintf(out,"\t\t\t%d, %d, %d, -1,\n",
			pDoc->Tris[i].vindex[0],
			pDoc->Tris[i].vindex[1],
			pDoc->Tris[i].vindex[2] );
		}
		fprintf(out,"\t\t\t]\n");
		fprintf(out,"\t\ttextureCoordIndex [\n");
		int x1,x2,x3;
		unsigned p1,p2,p3,p4;
		unsigned offset=pDoc->num.vertices;
		for( i=0;i<pDoc->num.triangles;i++)
		{
			p1=pDoc->Tris[i].vindex[0];
			p2=pDoc->Tris[i].vindex[1];
			p3=pDoc->Tris[i].vindex[2];
			p4=pDoc->Tris[i].flags;
			x1=x2=x3=0;
			if((pDoc->Verts[p1].Mflags&S_ONSEEM)&&!(p4&S_FRONT)) x1=1;
			if((pDoc->Verts[p2].Mflags&S_ONSEEM)&&!(p4&S_FRONT)) x2=1;
			if((pDoc->Verts[p3].Mflags&S_ONSEEM)&&!(p4&S_FRONT)) x3=1;

			//BG_Line(vertex[p1*3+1]+x1,vertex[p1*3+2],vertex[p2*3+1]+x2,vertex[p2*3+2],8);
		//	BG_Line(vertex[p2*3+1]+x2,vertex[p2*3+2],vertex[p3*3+1]+x3,vertex[p3*3+2],8);
		//	BG_Line(vertex[p3*3+1]+x3,vertex[p3*3+2],vertex[p1*3+1]+x1,vertex[p1*3+2],8);
			fprintf(out,"\t\t\t%d, %d, %d, -1,\n",
			p1+x1*offset,
			p2+x2*offset,
			p3+x3*offset);
		}
		fprintf(out,"\t\t\t]\n");
		fprintf(out,"\t\t}\n");

		fprintf(out,"\t}\n");
		fprintf(out,"}"); //end

		fclose(out);
	}

	return;
*/

}

void export_mdl_skin(char *filename, int skin, CMedDLeDoc *pDoc )
{
/*	strlwr(filename);
	char  *ptr;

	if(strstr(filename,".gif"))
	{
		int	i,j, Error, NumFiles, ExtCode;
		GifRecordType RecordType;
		GifByteType *Extension;
		GifRowType *ImageBuffer;
		GifFileType *GifFileOut = NULL;
		ColorMapObject CM;
		CM.Colors=new GifColorType[256];

		if((skin<pDoc->Skins.GetSize())&&(skin>=0))
		{
			write_gif(filename, pDoc->Skins[skin]->bitmap, pDoc->SkinW, pDoc->SkinH);
		}
		// new skin (polygon pic)
		if(skin<0)
		{
			int x1,x2,x3;
			unsigned p1,p2,p3,p4;
			unsigned char *pic;
			pic= new unsigned char [pDoc->SkinW*pDoc->SkinH];

			for(j=0; j<pDoc->SkinH; j++)
			{
				for(i=0; i<pDoc->SkinW; i++)
				{
					pic[i+pDoc->SkinW*j]=0;
				}
			}

			int v1[2], v2[2];
			for(i=0;i<pDoc->num.triangles;i++)
			{
				p1=pDoc->Tris[i].vindex[0];
				p2=pDoc->Tris[i].vindex[1];
				p3=pDoc->Tris[i].vindex[2];
				p4=pDoc->Tris[i].flags;
				x1=x2=x3=0;
				if((pDoc->Verts[p1].Mflags&S_ONSEEM)&&(p4==0)) x1=pDoc->SkinW/2;
				if((pDoc->Verts[p2].Mflags&S_ONSEEM)&&(p4==0)) x2=pDoc->SkinW/2;
				if((pDoc->Verts[p3].Mflags&S_ONSEEM)&&(p4==0)) x3=pDoc->SkinW/2;
				v1[0]=pDoc->Verts[p2].x+x2;
				v1[1]=pDoc->Verts[p2].y;
				v2[0]=pDoc->Verts[p3].x+x3;
				v2[1]=pDoc->Verts[p3].y;
				vline(pic,v1,v2,pDoc);
				v1[0]=pDoc->Verts[p3].x+x3;
				v1[1]=pDoc->Verts[p3].y;
				v2[0]=pDoc->Verts[p1].x+x1;
				v2[1]=pDoc->Verts[p1].y;
				vline(pic,v1,v2,pDoc);
				v1[0]=pDoc->Verts[p1].x+x1;
				v1[1]=pDoc->Verts[p1].y;
				v2[0]=pDoc->Verts[p2].x+x2;
				v2[1]=pDoc->Verts[p2].y;
				vline(pic,v1,v2,pDoc);

			}

			write_gif(filename, pic, pDoc->SkinW, pDoc->SkinH);
			delete [] pic;
		}

		delete [] CM.Colors;

	}
	else if(strstr(filename,".bmp"))
	{
		FILE *out;
		int i,j;
		if((skin<pDoc->Skins.GetSize())&&(skin>=0))
		{
			out=fopen(filename,"wb");
			BG_WriteBMP(out, MedDLePalette, pDoc->Skins[skin]->bitmap, pDoc->SkinW, pDoc->SkinH);
			fclose(out);
		}
		// new skin (polygon pic)
		if(skin<0)
		{
			int x1,x2,x3;
			unsigned p1,p2,p3,p4;
			unsigned char *pic;
			pic= new unsigned char [pDoc->SkinW*pDoc->SkinH];

			for(j=0; j<pDoc->SkinH; j++)
			{
				for(i=0; i<pDoc->SkinW; i++)
				{
					pic[i+pDoc->SkinW*j]=0;
				}
			}

			int v1[2], v2[2];
			for(i=0;i<pDoc->num.triangles;i++)
			{
				p1=pDoc->Tris[i].vindex[0];
				p2=pDoc->Tris[i].vindex[1];
				p3=pDoc->Tris[i].vindex[2];
				p4=pDoc->Tris[i].flags;
				x1=x2=x3=0;
				if((pDoc->Verts[p1].Mflags&S_ONSEEM)&&(p4==0)) x1=pDoc->SkinW/2;
				if((pDoc->Verts[p2].Mflags&S_ONSEEM)&&(p4==0)) x2=pDoc->SkinW/2;
				if((pDoc->Verts[p3].Mflags&S_ONSEEM)&&(p4==0)) x3=pDoc->SkinW/2;
				v1[0]=pDoc->Verts[p2].x+x2;
				v1[1]=pDoc->Verts[p2].y;
				v2[0]=pDoc->Verts[p3].x+x3;
				v2[1]=pDoc->Verts[p3].y;
				vline(pic,v1,v2,pDoc);
				v1[0]=pDoc->Verts[p3].x+x3;
				v1[1]=pDoc->Verts[p3].y;
				v2[0]=pDoc->Verts[p1].x+x1;
				v2[1]=pDoc->Verts[p1].y;
				vline(pic,v1,v2,pDoc);
				v1[0]=pDoc->Verts[p1].x+x1;
				v1[1]=pDoc->Verts[p1].y;
				v2[0]=pDoc->Verts[p2].x+x2;
				v2[1]=pDoc->Verts[p2].y;
				vline(pic,v1,v2,pDoc);
				
			}
			out=fopen(filename,"wb");
			BG_WriteBMP(out, MedDLePalette, pic, pDoc->SkinW, pDoc->SkinH);
			fclose(out);
			delete [] pic;
		}
	}
*/
}

void vline(unsigned char *pic, int *v1, int *v2, CMedDLeDoc *pDoc)
{

/*			int i;
			register int inc_ah,inc_al;
			int dx,dy,long_d,short_d;
			int d,add_dh,add_dl;
			int inc_xh,inc_yh,inc_xl,inc_yl;

			dx=v2[0]-v1[0]; dy=v2[1]-v1[1];

			if(dx<0){dx=-dx; inc_xh=-1; inc_xl=-1;}
			else    {        inc_xh=1;  inc_xl=1; }

			if(dy<0){dy=-dy;inc_yh=-pDoc->SkinW;
					 inc_yl=-pDoc->SkinW;
					 }
			else    {       inc_yh= pDoc->SkinW;
					 inc_yl= pDoc->SkinW;
			}
			 if(dx>dy){long_d=dx;short_d=dy;inc_yl=0;}
			else     {long_d=dy;short_d=dx;inc_xl=0;}

			inc_ah=inc_xh+inc_yh;
			inc_al=inc_xl+inc_yl;
			pic+=v1[1]*pDoc->SkinW+v1[0];

			d=2*short_d-long_d;
			add_dl=2*short_d;
			add_dh=2*short_d-2*long_d;

			for(i=0;i<=long_d;i++)
			{
				*pic=11;
				if(d>=0){pic+=inc_ah; d+=add_dh;}
				else    {pic+=inc_al; d+=add_dl;}
			}
*/
}

void write_gif(char *fname, unsigned char *pic, unsigned w, unsigned h)
{
	int	i,j, Error, NumFiles, ExtCode;
	GifRecordType RecordType;
	GifByteType *Extension;
	GifRowType *ImageBuffer;
	GifFileType *GifFileOut = NULL;
	ColorMapObject CM;
	CM.Colors=new GifColorType [256];

	GifFileOut = EGifOpenFileName(fname,0);
	EGifSetGifVersion("87a");
	int expc=8;
	// set palette
	CM.ColorCount=256;
	CM.BitsPerPixel=8;
	for(i=0; i<256; i++)
	{
//		CM.Colors[i].Red=MedDLePalette[i*3];
//		CM.Colors[i].Green=MedDLePalette[i*3+1];
//		CM.Colors[i].Blue=MedDLePalette[i*3+2];
	}
	EGifPutScreenDesc(GifFileOut,w,h,8,0,&CM);
	EGifPutImageDesc(GifFileOut,0, 0, w, h, 0, NULL);
	for (i = 0; i < h; i++)
	{
		EGifPutLine(GifFileOut, pic+i*w, w);
	}
	EGifCloseFile(GifFileOut);
}

struct BMP_HEADER{

	unsigned filesize;
	short int reserved1;
	short int reserved2;
	int headersize;
	int infosize;
	int width;
	int height;
	short int planes;
	short int bits;
	int compression;
	int sizeimage;
	int xpelspermeter;
	int ypelspermeter;
	int colorsused;
	int colorsimportant;

};


void BG_WriteBMP(FILE *out, unsigned char *pal, unsigned char *pic, unsigned w, unsigned h)
{
	unsigned i, j, k;
	unsigned size;

	unsigned char *temp;
	int readsize;

	BMP_HEADER bmpfile;

	bmpfile.filesize = w*h + sizeof(bmpfile) + 1024L+2L;
	bmpfile.reserved1 = 0;
	bmpfile.reserved2 = 0;
	bmpfile.headersize =  sizeof(bmpfile) + 1024L + 2L;
	bmpfile.infosize = 40;

	bmpfile.width = w;
	bmpfile.height = h;

	bmpfile.planes = 1;
	bmpfile.compression = 0;
	bmpfile.bits = 8;
	bmpfile.xpelspermeter = 1181L;
	bmpfile.ypelspermeter = 1181L;
	bmpfile.colorsused = 256;
	bmpfile.colorsimportant = 256;

	bmpfile.sizeimage = w*h;

	fwrite("BM",2,1, out);
	fwrite(((char *)(&bmpfile)), sizeof(bmpfile), 1L, out);

	for (i = 0; i < 256; i++)
	{
		fputc(pal[i*3 + 2], out);
		fputc(pal[i*3 + 1], out);
		fputc(pal[i*3 + 0], out);
		fputc(0, out);
	}

	int ali;
	if(w<4)  ali=4-w;
	else ali=w%4;

		for(j=h;j>0;j--)
		{
			for(i=0;i<w;i++)
			{
				fwrite(pic+i+w*(j-1),1,1,out);

			}
			for(i=0;i<ali;i++)
			{
				fputc(0,out);
			}
		}


}

void BG_ReadBMP(FILE *in, unsigned char *pal, unsigned char *pic, unsigned *w, unsigned *h)
{
    unsigned i, j;
    unsigned size;
    unsigned x,y;

    char t[2];
    int readsize;
    unsigned char ch;

    rewind(in);
	fseek(in,18,SEEK_SET);
    fread(&x,4,1,in);
    fread(&y,4,1,in);
    fseek(in,28,SEEK_CUR);

    w[0]=x;
    h[0]=y;

    for (i = 0; i < 256; i++)
    {
		fread(pal+i*3 + 2,1,1,in);
		fread(pal+i*3 + 1,1,1,in);
		fread(pal+i*3 + 0,1,1,in);
		fseek(in,1,SEEK_CUR);
	}
	unsigned char junk[4];
	int ali;
	if(x<4) ali=4-x;
	else ali=x%4;


	for(j=y;j>0;j--)
	{
		for(i=0;i<x;i++)
		{
			fread(pic+i+x*(j-1),1,1,in);
		}
		if(ali!=0) fread(&junk[0],ali,1,in);
	}

}
/////////////////////////////////////////////////////
///////////////////////////////////////////////////////
//////////// IMPORT
/*
typedef unsigned char byte;

void add_frame_raw(MDL_model *model, char *fname, double *);
void insert_frame_raw(int frame, MDL_model *, double *);
void add_frame_ptlist(MDL_model *model, char *fname, BG_3pt *);
void insert_frame_ptlist(int frame, MDL_model *, BG_3pt *);
void new_frame_raw(MDL_model *model, char *fname, double *, int);
// import frames: raw
int import_mdl_frame(char *filename, int frame, MDL_model *model)
{

//	if(frame<=0)
//	{
//		printf("Error: Too small of a frame number\n");
//		getch();
//		return 1;
//	}

	strlwr(filename);
	// jethro tull rules... I hate this windows key on my new keyboard...
	// queensyche rules too... now I'm getting used to that key...
	if(strstr(filename,".raw"))
	{
		FILE *in;
		char str[256];

		double *rv;

		in=fopen(filename,"rt");
		if(in==NULL) { printf("Error: can't open file\n"); getch(); return 1; }
		if(!quiet) printf("reading raw file...\n");

		unsigned num_read_v=0;
		unsigned length;
		while(1)
		{
			length=fscanf(in,"%s",str);
			if((length==EOF)||(length<=0)) break;
			// if a number add vertex
			if(((str[0]>=48)&&(str[0]<=57))||(str[0]==43)||(str[0]==45)||(str[0]==46))
			{
				num_read_v++;
			}
		}

		rv=new (double)[num_read_v];
		if(rv==NULL) exit(1);
		num_read_v=0;
		rewind(in);
		while(1)
		{
			length=fscanf(in,"%s",str);
			if((length==EOF)||(length<=0)) break;
			// if a number add vertex
			if(((str[0]>=48)&&(str[0]<=57))||(str[0]==43)||(str[0]==45)||(str[0]==46))
			{
				num_read_v++;
				if(model->num_frames!=0)
				{
					if(num_read_v>(model->num_triangles*9))
					{
						printf("\nError: Number of points read is greater than those used in the model!\n");
						printf("Hit any key...\n");
						getch();
						fclose(in);
						return 1;
					}
				}
				*(rv+num_read_v-1)=(double)atof(str);
			}
		}
		//switch order (rotate about z axis 90 degrees)
		for(int i=0; i<num_read_v; i+=3)
		{
			float temp;
			temp=rv[i]; rv[i]=rv[i+1]; rv[i+1]=-temp;
		}

		if(model->num_frames!=0)
		{
			if(num_read_v<(model->num_triangles*9))
			{
				printf("\nError: Number of points read is less than those used in the model!\n");
				printf("Hit any key...\n");
				getch();
				fclose(in);
				return 1;
			}
			if(frame>model->blocks)
			{
				char name[32];
				char *ptr,*p,*q;
				while((p=strpbrk(filename,"\\"))||(q=strpbrk(filename,"/")))
				{
					if(p>q) strcpy(filename,++p);
					else strcpy(filename,++q);
				}
				strncpy(name,filename,16);
				ptr=strpbrk(name,".");
				ptr[0]=0;
				ptr++;
				strcpy(ptr,"MedDLe");

				add_frame_raw(model,name,rv);
			}
			else
			 insert_frame_raw(frame-1, model, rv);
		}
		else
		{
				char name[32];
				char *ptr,*p,*q;
				while((p=strpbrk(filename,"\\"))||(q=strpbrk(filename,"/")))
				{
					if(p>q) strcpy(filename,++p);
					else strcpy(filename,++q);
				}
			strncpy(name,filename,16);
			ptr=strpbrk(name,".");
			ptr[0]=0;
			ptr++;
			strcpy(ptr,"MedDLe");

			new_frame_raw(model,name,rv,num_read_v);
		}
		delete [] rv;

		fclose(in);

	}
	else if(strstr(filename,".asc"))
	{
		FILE *in;
		char str[256];

		in=fopen(filename,"rt");
		if(in==NULL) { printf("Error: can't open file\n"); getch(); return 1; }
		if(!quiet) printf("reading asc file...\n");


		char *keyword[]={"vertices","vertex","faces","face",NULL};

		unsigned num_verts=0;
		unsigned num_tris=0;
		float *base_pts;
		int *tri;
		unsigned tri_cnt=0;
		unsigned base_cnt=0;

		unsigned length;
		unsigned prev_size=0;
		while(1)
		{
			length=fscanf(in,"%s",str);
			if((length==EOF)||(length<=0)) break;
			for(int i=0; keyword[i]!=NULL; i++)
			{
				strlwr(str);
				if(strstr(str,keyword[i]))
				{
					char junk[16];
					switch (i)
					{
						case 0:
						int verts;
						fscanf(in,"%s",str);
						verts=atoi(str);
						if(num_verts>0)
							base_pts=(float*)realloc(base_pts,(verts+num_verts)*4*3);
						else
							base_pts=(float*)calloc((verts+num_verts)*3,4);
						prev_size=num_verts;
						num_verts+=verts;
						break;

						case 1: //get vertex
						int vertnum;
						fscanf(in,"%s",str);
						strlwr(str);
						if(!strstr(str,"list"))
						{
							vertnum=atoi(str);
							for(int j=0; j<3; j++)
							{

								fscanf(in,"%s",str);
								char *p;
								if(!(p=strstr(str,":"))) p=&str[0];
								else
								{
									int l;

									l=strlen(p);
									if(l<=1) {fscanf(in,"%s",str);p=&str[0];}
									else p++;
								}
								base_pts[base_cnt++]=atoi(p);
							}
						 //	for(int j=0; j<3; j++)
							//{
							//	fscanf(in,"%s%s",junk,str);
							//	base_pts[base_cnt++] =atof(str);
						 //	}
						}
						break;

						case 2:
						int faces;
						fscanf(in,"%s",str);
						faces=atoi(str);
						if(num_tris>0)
							tri=(int*)realloc(tri,(faces+num_tris)*4*3);
						else
							tri=(int*)calloc((faces+num_tris)*3,4);
						num_tris+=faces;
						break;

						case 3:
						int facenum;
						fscanf(in,"%s",str);
						strlwr(str);
						if(!strstr(str,"list"))
						{
							facenum=atoi(str);
							for(int j=0; j<3; j++)
							{
								fscanf(in,"%s",str);
								char *p;
								if(!(p=strstr(str,":"))) p=&str[0];
								else p++;

								tri[tri_cnt++]=atoi(p)+prev_size;
							}

						}
						break;

					}
					break;
				}

			}

		}
		fclose(in);

//		if(!quiet) printf("verts:%u tris:%u\n",num_verts,num_tris);
//		if(!quiet) printf("read v:%u read t:%u\n",base_cnt,tri_cnt);
//		getch();
		unsigned v1,v2,v3;
		double *rv;
		rv=new(double)[num_tris*9];
		// now stic in raw form!
		unsigned cnt=0;
		for(int i=0; i<num_tris; i++)
		{
//			for(int j=0; j<3; j++)
			{
				// reverse order
				int j=0;
				rv[cnt++]=-(double)base_pts[3*tri[i*3+j]];
				rv[cnt++]=-(double)base_pts[3*tri[i*3+j]+1];
				rv[cnt++]=(double)base_pts[3*tri[i*3+j]+2];
				j=2;
				rv[cnt++]=-(double)base_pts[3*tri[i*3+j]];
				rv[cnt++]=-(double)base_pts[3*tri[i*3+j]+1];
				rv[cnt++]=(double)base_pts[3*tri[i*3+j]+2];
				j=1;
				rv[cnt++]=-(double)base_pts[3*tri[i*3+j]];
				rv[cnt++]=-(double)base_pts[3*tri[i*3+j]+1];
				rv[cnt++]=(double)base_pts[3*tri[i*3+j]+2];
			}
		}
//		if(!quiet) printf("cnt:%u to %u\n",cnt,model->num_triangles*9);

		free(base_pts);
		free(tri);


		//switch order (rotate about z axis 90 degrees)
		for(int i=0; i<cnt; i+=3)
		{
			float temp;
			temp=rv[i]; rv[i]=rv[i+1]; rv[i+1]=-temp;
		}

		if(model->num_frames!=0)
		{
			if(cnt!=(model->num_triangles*9))
			{
				printf("\nError: Number of points read different from that in model!\n");
				printf("Hit any key...\n");
				getch();
				fclose(in);
				return 1;
			}
			if(frame>model->blocks)
			{
				char name[32];
				char *ptr,*p,*q;
				while((p=strpbrk(filename,"\\"))||(q=strpbrk(filename,"/")))
				{
					if(p>q) strcpy(filename,++p);
					else strcpy(filename,++q);
				}
				strncpy(name,filename,16);
				ptr=strpbrk(name,".");
				ptr[0]=0;
				ptr++;
				strcpy(ptr,"MedDLe");

				add_frame_raw(model,name,rv);
			}
			else
			 insert_frame_raw(frame-1, model, rv);
		}
		else
		{
				char name[32];
				char *ptr,*p,*q;
				while((p=strpbrk(filename,"\\"))||(q=strpbrk(filename,"/")))
				{
					if(p>q) strcpy(filename,++p);
					else strcpy(filename,++q);
				}
			strncpy(name,filename,16);
			ptr=strpbrk(name,".");
			ptr[0]=0;
			ptr++;
			strcpy(ptr,"MedDLe");
			new_frame_raw(model,name,rv,cnt);
		}
		delete [] rv;

	}
	else
	{
		printf("Don't know that file extension for a frame.\n");
//		getch();
		return 1;
	}


	return 0;
}
void new_frame_raw(MDL_model *model, char *fname, double *raw_pts, int n)
{
	model->num_frames=1;
	model->frame = new (struct MDL_frame);
	model->frame[0].type=0;
  for (int i=0; i<16; i++)
	{
		model->frame[0].sframe.name[i]=fname[i];
  }

	// construct pt list
	float x,y,z;
	double *pt_list;
	double minx,miny,minz,maxx,maxy,maxz;
	pt_list=new(double)[n];
	pt_list[0]=raw_pts[0];pt_list[1]=raw_pts[1];pt_list[2]=raw_pts[2];
	minx=raw_pts[0];miny=raw_pts[1];minz=raw_pts[2];
	maxx=raw_pts[0];maxy=raw_pts[1];maxz=raw_pts[2];
	model->num_vertices=1;
	model->num_triangles=n/9;
	model->triangle = new (unsigned)[model->num_triangles*4];


	// construct the triangles
	int vc=0;
//	printf("making 3d faces\n");
	model->num_vertices=0;

	for(int i=0; i<model->num_triangles; i++)
	{
		model->triangle[i*4]=0; // on back
		for(int k=0; k<3; k++)
		{
			int vertnum=-1;

			x=raw_pts[vc++]; y=raw_pts[vc++]; z=raw_pts[vc++];

			for(int j=0; j<model->num_vertices;j++)
			{
				if((x==pt_list[j*3])&&(y==pt_list[j*3+1])&&(z==pt_list[j*3+2]))
				{
					vertnum=j;
			//		model->triangle[i*4+1+k]=j;
					break;
				}
			}
			if (vertnum == -1)
			{
				int N=model->num_vertices;
				pt_list[N*3]=x;pt_list[N*3+1]=y;pt_list[N*3+2]=z;
				vertnum = model->num_vertices;
				model->num_vertices++;
				if(x<minx) minx=x;
				if(y<miny) miny=y;
				if(z<minz) minz=z;
				if(x>maxx) maxx=x;
				if(y>maxy) maxy=y;
				if(z>maxz) maxz=z;

			}

		model->triangle[i*4+1+k]= vertnum;

		}
	}
	model->frame[0].sframe.tv = new (trivertex)[model->num_vertices];

	model->xoffset=minx;
	model->yoffset=miny;
	model->zoffset=minz;
	model->xscale=(maxx-minx)/255.7;
	model->yscale=(maxy-miny)/255.7;
	model->zscale=(maxz-minz)/255.7;
	model->radius= sqrt((maxx-minx) * (maxx-minx) +
								 (maxy-miny)* (maxy-miny) +
								(maxz-minz) * (maxz-minz));

//	setup_3d_data(model);
	delete [] pt_list;
	printf("triangles: %d\n",model->num_triangles);
	printf("vertices: %d\n",model->num_vertices);

	printf("adding data to model\n");
	insert_frame_raw(-1, model, raw_pts);


}

void insert_frame_raw(int frame, MDL_model *model, double *raw_pts)
{

	if(frame!=-1)
	{

		// get bounds of raw points
		unsigned k=0;
		double rx,ry,rz;
		double rxmin,rxmax,rymin,rymax,rzmin,rzmax;
		rxmin= raw_pts[0];
		rymin= raw_pts[1];
		rzmin= raw_pts[2];
		rxmax= raw_pts[0];
		rymax= raw_pts[1];
		rzmax= raw_pts[2];
		for(int j=0; j< model->num_triangles*3; j++)
		{

				rx=raw_pts[k++];
				ry=raw_pts[k++];
				rz=raw_pts[k++];

				if(rx>rxmax) rxmax=rx;
				if(ry>rymax) rymax=ry;
				if(rz>rzmax) rzmax=rz;
				if(rx<rxmin) rxmin=rx;
				if(ry<rymin) rymin=ry;
				if(rz<rzmin) rzmin=rz;
		}
		// get the max and min of all
		unsigned num_pts=model->num_vertices;
		for (int i=0; i<model->blocks; i++)
		{
			//min
			if(model->block[i].ptlist[num_pts].x<rxmin) rxmin=model->block[i].ptlist[num_pts].x;
			if(model->block[i].ptlist[num_pts].y<rymin) rymin=model->block[i].ptlist[num_pts].y;
			if(model->block[i].ptlist[num_pts].z<rzmin) rzmin=model->block[i].ptlist[num_pts].z;
			//max
			if(model->block[i].ptlist[num_pts+1].x>rxmax) rxmax=model->block[i].ptlist[num_pts+1].x;
			if(model->block[i].ptlist[num_pts+1].y>rymax) rymax=model->block[i].ptlist[num_pts+1].y;
			if(model->block[i].ptlist[num_pts+1].z>rzmax) rzmax=model->block[i].ptlist[num_pts+1].z;

		}

		double rxs;
		rxs=(rxmax-rxmin)/255.7;
		double rys;
		rys=(rymax-rymin)/255.7;
		double rzs;
		rzs=(rzmax-rzmin)/255.7;
		int rescale=0;

		if(rxs>model->xscale) {rescale=1; model->xscale=rxs;}
		if(rys>model->yscale) {rescale=1; model->yscale=rys;}
		if(rzs>model->zscale) {rescale=1; model->zscale=rzs;}
		if(rxmin<model->xoffset) {rescale=1; model->xoffset=rxmin;}
		if(rymin<model->yoffset) {rescale=1; model->yoffset=rymin;}
		if(rzmin<model->zoffset) {rescale=1; model->zoffset=rzmin;}

		// must recalculate all with new bounds!
		if( rescale==1 )
		{
			printf("resizing frames..\n");
			double xo=model->xoffset;
			double yo=model->yoffset;
			double zo=model->zoffset;

			for(int f=0; f<model->blocks; f++)
			{
				byte xmin=255,xmax=0;
				byte ymin=255,ymax=0;
				byte zmin=255,zmax=0;

				k=0;

				unsigned p;
				for(int j=0; j< model->num_triangles; j++)
				{
					byte x,y,z;

					//each vertex of triangle
					for(int i=0; i<3; i++)
					{
						p=model->triangle[j*4L+1L+i];
						x=(byte)((model->block[f].ptlist[p].x-xo)/model->xscale);
						y=(byte)((model->block[f].ptlist[p].y-yo)/model->yscale);
						z=(byte)((model->block[f].ptlist[p].z-zo)/model->zscale);
						model->frame[f].sframe.tv[p].v[0]=x;
						model->frame[f].sframe.tv[p].v[1]=y;
						model->frame[f].sframe.tv[p].v[2]=z;

						if(x>xmax) xmax=x;
						if(y>ymax) ymax=y;
						if(z>zmax) zmax=z;
						if(x<xmin) xmin=x;
						if(y<ymin) ymin=y;
						if(z<zmin) zmin=z;
					}

				}
				model->frame[f].sframe.bboxmin.v[0]=xmin;
				model->frame[f].sframe.bboxmin.v[1]=ymin;
				model->frame[f].sframe.bboxmin.v[2]=zmin;
				model->frame[f].sframe.bboxmax.v[0]=xmax;
				model->frame[f].sframe.bboxmax.v[1]=ymax;
				model->frame[f].sframe.bboxmax.v[2]=zmax;
			}
		}

		delete_3d_data(model);
	}

	// else new frame
	else frame=0;

	// every
	double xo=model->xoffset;
	double yo=model->yoffset;
	double zo=model->zoffset;
	byte xmin=255,xmax=0;
	byte ymin=255,ymax=0;
	byte zmin=255,zmax=0;
	unsigned p;

	unsigned k=0;

	for(int j=0; j< model->num_triangles; j++)
	{
		unsigned p;
		int x,y,z;
		for(int i=0; i<3; i++)
		{
			p=model->triangle[j*4L+1L+i];
			x=((raw_pts[k++]-xo)/model->xscale);
			y=((raw_pts[k++]-yo)/model->yscale);
			z=((raw_pts[k++]-zo)/model->zscale);
      if(x>255) x=255;
			if(y>255) y=255;
			if(z>255) z=255;
      if(x<0) x=0;
      if(y<0) y=0;
      if(z<0) z=0;
 			model->frame[frame].sframe.tv[p].v[0]=x;
			model->frame[frame].sframe.tv[p].v[1]=y;
			model->frame[frame].sframe.tv[p].v[2]=z;

			if(x>xmax) xmax=x;
			if(y>ymax) ymax=y;
			if(z>zmax) zmax=z;
			if(x<xmin) xmin=x;
			if(y<ymin) ymin=y;
			if(z<zmin) zmin=z;
		}
	}
//	printf("bounding boxs\n");
	model->frame[frame].sframe.bboxmin.v[0]=xmin;
	model->frame[frame].sframe.bboxmin.v[1]=ymin;
	model->frame[frame].sframe.bboxmin.v[2]=zmin;
	model->frame[frame].sframe.bboxmax.v[0]=xmax;
	model->frame[frame].sframe.bboxmax.v[1]=ymax;
	model->frame[frame].sframe.bboxmax.v[2]=zmax;

	// set up 3d data
//	printf("set up normals\n");
	setup_3d_data(model);

	// now find vertex normals!
	//#include"mdl_norm.h"


	double avex,avey,avez;
	int norm_count;
	BG_3pt vnormal;
	for(int j=0;j<model->num_vertices; j++)
	{
		avex=avey=avez=0.0;
		norm_count=0;

		for(int i=0; i<model->num_triangles; i++)
		{

			if((j==model->triangle[i*4L+1L])||(j==model->triangle[i*4L+2L])||(j==model->triangle[i*4L+3L]) )
			{
				avex+=model->block[frame].side_normal[i].x;
				avey+=model->block[frame].side_normal[i].y;
				avez+=model->block[frame].side_normal[i].z;
				norm_count++;
			}

		}
		vnormal.x=avex/(double)norm_count;
		vnormal.y=avey/(double)norm_count;
		vnormal.z=avez/(double)norm_count;
		int k=0; /// this is the index!
		double dotted_val, hi_dot;
		hi_dot=BG_DotProduct(&vertex_normal[0],&vnormal);

		for(int i=1; i<162; i++)
		{
			dotted_val=BG_DotProduct(&vertex_normal[i],&vnormal);
			if(dotted_val>hi_dot)
			{
				hi_dot=dotted_val;
				k=i;
			}
		}

		model->frame[frame].sframe.tv[j].vnormal=(unsigned char)k;
	}

}


// only works for non-group type only
// ie you can't add to groups of frames (like flame)

void add_frame_raw(MDL_model *model, char *fname, double *raw_pts)
{
	struct MDL_frame *frame;
	frame = new (struct MDL_frame)[model->num_frames];

	delete_3d_data(model);

	// copy all frame data
	for(int k=0; k<model->num_frames;  k++)
	{
		frame[k].type=model->frame[k].type;
		if(frame[k].type==0)
		{
			memcpy(frame[k].sframe.bboxmin.v,model->frame[k].sframe.bboxmin.v,3);
			memcpy(frame[k].sframe.bboxmax.v,model->frame[k].sframe.bboxmax.v,3);
			for(int ii=0; ii<16; ii++) frame[k].sframe.name[ii]=model->frame[k].sframe.name[ii];
			frame[k].sframe.tv = new (trivertex)[model->num_vertices];
			memcpy(frame[k].sframe.tv,model->frame[k].sframe.tv,sizeof(trivertex)*model->num_vertices);
		}

		else
		{
			frame[k].gframe.num_gsframes=model->frame[k].gframe.num_gsframes;
			memcpy(frame[k].gframe.bboxmin.v,model->frame[k].gframe.bboxmin.v,3);
			memcpy(frame[k].gframe.bboxmax.v,model->frame[k].gframe.bboxmax.v,3);
			frame[k].gframe.gsframe_interval = new (float)[model->frame[k].gframe.num_gsframes];
			frame[k].gframe.gsframe = new (MDL_model_frame)[model->frame[k].gframe.num_gsframes];

			memcpy(frame[k].gframe.gsframe_interval,model->frame[k].gframe.gsframe_interval,sizeof(float)*model->frame[k].gframe.num_gsframes);

			for(int j=0; j<model->frame[k].gframe.num_gsframes; j++)
			{
				memcpy(frame[k].gframe.gsframe[j].bboxmin.v,model->frame[k].gframe.gsframe[j].bboxmin.v,3);
				memcpy(frame[k].gframe.gsframe[j].bboxmax.v,model->frame[k].gframe.gsframe[j].bboxmax.v,3);
				strncpy(frame[k].gframe.gsframe[j].name,model->frame[k].gframe.gsframe[j].name,16);
				frame[k].gframe.gsframe[j].tv = new (trivertex)[model->num_vertices];
				memcpy(frame[k].gframe.gsframe[j].tv,model->frame[k].gframe.gsframe[j].tv,sizeof(trivertex)*model->num_vertices);

			}
		}
	}

	// delete original data
	for(int k=0; k<model->num_frames;  k++)
	{
		if(model->frame[k].type==0)
			delete [] model->frame[k].sframe.tv;

		else
		{

			for(int j=0; j<model->frame[k].gframe.num_gsframes; j++)
			delete [] model->frame[k].gframe.gsframe[j].tv;
			delete [] model->frame[k].gframe.gsframe_interval;
			delete [] model->frame[k].gframe.gsframe;
		}
	}
	delete [] model->frame;


	model->num_frames++;
	model->frame = new (struct MDL_frame)[model->num_frames];

	//model->frame = (MDL_frame *)realloc(model->frame,sizeof(MDL_frame)*model->num_frames);
	//reload everything now
	for(int k=0; k<(model->num_frames-1);  k++)
	{
		model->frame[k].type=frame[k].type;
		if(model->frame[k].type==0)
		{
			memcpy(model->frame[k].sframe.bboxmin.v,frame[k].sframe.bboxmin.v,3);
			memcpy(model->frame[k].sframe.bboxmax.v,frame[k].sframe.bboxmax.v,3);
			for(int ii=0; ii<16; ii++) model->frame[k].sframe.name[ii]=frame[k].sframe.name[ii];
			model->frame[k].sframe.tv = new (trivertex)[model->num_vertices];
			memcpy(model->frame[k].sframe.tv,frame[k].sframe.tv,sizeof(trivertex)*model->num_vertices);
		}

		else
		{
			model->frame[k].gframe.num_gsframes=frame[k].gframe.num_gsframes;
			memcpy(model->frame[k].gframe.bboxmin.v,frame[k].gframe.bboxmin.v,3);
			memcpy(model->frame[k].gframe.bboxmax.v,frame[k].gframe.bboxmax.v,3);
			model->frame[k].gframe.gsframe_interval = new (float)[model->frame[k].gframe.num_gsframes];
			model->frame[k].gframe.gsframe = new (MDL_model_frame)[model->frame[k].gframe.num_gsframes];

			memcpy(model->frame[k].gframe.gsframe_interval,frame[k].gframe.gsframe_interval,sizeof(float)*model->frame[k].gframe.num_gsframes);

			for(int j=0; j<model->frame[k].gframe.num_gsframes; j++)
			{
				memcpy(model->frame[k].gframe.gsframe[j].bboxmin.v,frame[k].gframe.gsframe[j].bboxmin.v,3);
				memcpy(model->frame[k].gframe.gsframe[j].bboxmax.v,frame[k].gframe.gsframe[j].bboxmax.v,3);
				strncpy(model->frame[k].gframe.gsframe[j].name,frame[k].gframe.gsframe[j].name,16);
				model->frame[k].gframe.gsframe[j].tv = new (trivertex)[model->num_vertices];
				memcpy(model->frame[k].gframe.gsframe[j].tv,frame[k].gframe.gsframe[j].tv,sizeof(trivertex)*model->num_vertices);
			}
		}
	}

	// add the new frame (use other vertices)
	model->frame[model->num_frames-1].type=0;
//	for(ii=0; ii<16; ii) model->frame[k].sframe.name[ii]=frame[k].sframe.name[ii];

	for(int ii=0; ii<16; ii++) model->frame[model->num_frames-1].sframe.name[ii]=fname[ii];
	memcpy(model->frame[model->num_frames-1].sframe.bboxmin.v,model->frame[model->num_frames-2].sframe.bboxmin.v,3);
	memcpy(model->frame[model->num_frames-1].sframe.bboxmax.v,model->frame[model->num_frames-2].sframe.bboxmax.v,3);
	model->frame[model->num_frames-1].sframe.tv = new (trivertex)[model->num_vertices];
	memcpy(model->frame[model->num_frames-1].sframe.tv,model->frame[model->num_frames-2].sframe.tv,sizeof(trivertex)*model->num_vertices);

	//set the 3d data
	setup_3d_data(model);

	// delete temp stuff
	for(int k=0; k<(model->num_frames-1);  k++)
	{
		if(frame[k].type==0)
			delete [] frame[k].sframe.tv;

		else
		{

			for(int j=0; j<frame[k].gframe.num_gsframes; j++)
				delete [] frame[k].gframe.gsframe[j].tv;
			delete [] frame[k].gframe.gsframe_interval;
			delete [] frame[k].gframe.gsframe;
		}
	}
	delete [] frame;

	insert_frame_raw(model->num_frames-1, model, raw_pts);

}

*/

void import_mdl_skin(char *filename, int skin, CMedDLeDoc *pDoc)
{
/*
	strlwr(filename);
	if(strstr(filename,".gif"))
	{
		int	Error, NumFiles, ExtCode;
		GifRecordType RecordType;
		GifByteType *Extension;
		GifRowType *ImageBuffer;
		GifFileType *GifFileIn = NULL;

		unsigned char bmppal[256*3];
		unsigned bmpw, bmph;
		unsigned char *pic;
		int i,j;

		GifFileIn = DGifOpenFileName(filename);
		if(GifFileIn == NULL) { AfxMessageBox("Gif Error"); return;}
		do
		{
			if (DGifGetRecordType(GifFileIn, &RecordType) == 0) exit(1);

			switch (RecordType)
			{
				case IMAGE_DESC_RECORD_TYPE:
					if (DGifGetImageDesc(GifFileIn) == 0) exit(1);
					pic = new BYTE [GifFileIn->Image.Height*GifFileIn->Image.Width];
					for (i = 0; i < GifFileIn->Image.Height; i++)
						DGifGetLine(GifFileIn, &pic[i*GifFileIn->Image.Width], GifFileIn->Image.Width);
					break;
				case EXTENSION_RECORD_TYPE:
					// Skip any extension blocks in file: 
					DGifGetExtension(GifFileIn, &ExtCode, &Extension);
					// No support to more than one extension blocks, so discard: 
					while (Extension != NULL) DGifGetExtensionNext(GifFileIn, &Extension);
					break;
				case TERMINATE_RECORD_TYPE:
					break;
			}
		}while (RecordType != TERMINATE_RECORD_TYPE);

		bmpw=GifFileIn->Image.Width;
		bmph=GifFileIn->Image.Height;

		for (i = 0; i < 256; i++)
		{
			bmppal[i*3]=GifFileIn->SColorMap->Colors[i].Red;
			bmppal[i*3+1]=GifFileIn->SColorMap->Colors[i].Green;
			bmppal[i*3+2]=GifFileIn->SColorMap->Colors[i].Blue;
		}

		DGifCloseFile(GifFileIn);

		// now stick the info in the model...
		// match colors up
		char close_color[256];
		for(i=0; i<256; i++)
		{
			close_color[i]=i;
			float error, error0=1.566e5;
			float e1,e2,e3;
			for(j=0; j<256; j++)
			{
				e1= (float)(MedDLePalette[j*3]-bmppal[i*3]);
				e2= (float)(MedDLePalette[j*3+1]-bmppal[i*3+1]);
				e3= (float)(MedDLePalette[j*3+2]-bmppal[i*3+2]);
				error=e1*e1+e2*e2+e3*e3;
				if(error<=error0)
				{
					error0=error;
					close_color[i]=j;
				}
			}
		}

		Skin *s=new Skin;
		pDoc->Skins.Add(s);
		pDoc->num.skins++;
		pDoc->cur.skin=pDoc->Skins.GetSize()-1;
		s->type=0;
		s->bitmap=new BYTE [pDoc->SkinW*pDoc->SkinH];
		s->tcode=0;			// Time Code
		s->tduration=0;		// Time Duration
		strcpy(s->name,"un-named");			// Skin's Name

		// resize pic if needed and add to model
		double scalew, scaleh;
		scalew=(double)(bmpw)/(double)(pDoc->SkinW);
		scaleh=(double)(bmph)/(double)(pDoc->SkinH);

		for(j=0; j<pDoc->SkinH;j++)
		{
			for(i=0;i<pDoc->SkinW;i++)
			{
				unsigned pic_index;
				double di, dj;
				di=(double)i;
				dj=(double)j;
				pic_index=(unsigned)(scalew*di)+(unsigned)(scaleh*dj)*(bmpw);
				pDoc->Skins[pDoc->cur.skin]->bitmap[i+j*pDoc->SkinW]=close_color[pic[pic_index]];
			}
		}

		delete [] pic;

	}

	else if(strstr(filename,".bmp"))
	{
		FILE *in;
		unsigned char bmppal[256*3];
		unsigned bmpw, bmph;
		unsigned char *pic;
		int i,j;

		in=fopen(filename,"rb");
		if(in==NULL) {AfxMessageBox("Couldn't open file"); return;}
		rewind(in);
		fseek(in,18,SEEK_SET);
		fread(&bmpw,4,1,in);
		fread(&bmph,4,1,in);
		fseek(in,28,SEEK_CUR);

		for (i = 0; i < 256; i++)
		{
			fread(bmppal+i*3 + 2,1,1,in);
			fread(bmppal+i*3 + 1,1,1,in);
			fread(bmppal+i*3 + 0,1,1,in);
			fseek(in,1,SEEK_CUR);
		}

		//read new pic
		pic=new BYTE [(bmpw*bmph)];
		int ali;
		unsigned char junk[4];
		//  this is to make length end on a long
		if(bmpw<4) ali=4-bmpw;
		else ali=bmpw%4;

		for(j=bmph;j>0;j--)
		{
			for(i=0;i<bmpw;i++)
			{
				fread(&pic[i+bmpw*(j-1)],1,1,in);
			}
			if(ali!=0) fread(&junk[0],ali,1,in);
		}
		fclose(in);

		// now stick the info in the model...
		// match colors up
		char close_color[256];
		for(i=0; i<256; i++)
		{
			close_color[i]=i;
			float error, error0=1.566e5;
			float e1,e2,e3;
			for(j=0; j<256; j++)
			{
				e1= (float)(MedDLePalette[j*3]-bmppal[i*3]);
				e2= (float)(MedDLePalette[j*3+1]-bmppal[i*3+1]);
				e3= (float)(MedDLePalette[j*3+2]-bmppal[i*3+2]);
				error=e1*e1+e2*e2+e3*e3;
				if(error<=error0)
				{
					error0=error;
					close_color[i]=j;
				}
			}

		}

		Skin *s=new Skin;
		pDoc->Skins.Add(s);
		pDoc->num.skins++;
		pDoc->cur.skin=pDoc->Skins.GetSize()-1;
		s->type=0;
		s->bitmap=new BYTE [pDoc->SkinW*pDoc->SkinH];
		s->tcode=0;			// Time Code
		s->tduration=0;		// Time Duration
		strcpy(s->name,"un-named");			// Skin's Name

		// resize pic if needed and add to model
		double scalew, scaleh;
		scalew=(double)(bmpw)/(double)(pDoc->SkinW);
		scaleh=(double)(bmph)/(double)(pDoc->SkinH);

		for(j=0; j<pDoc->SkinH;j++)
		{
			for(i=0;i<pDoc->SkinW;i++)
			{
				unsigned pic_index;
				double di, dj;
				di=(double)i;
				dj=(double)j;
				pic_index=(unsigned)(scalew*di)+(unsigned)(scaleh*dj)*(bmpw);
				pDoc->Skins[pDoc->cur.skin]->bitmap[i+j*pDoc->SkinW]=close_color[pic[pic_index]];
			}
		}

		delete [] pic;
	}
	else
	{
		AfxMessageBox("Don't know file type");
	}
*/
}
