// Copyright (C) 1999-2000 Team Assault.
//
//
// ui_class.c
//

#include "ui_local.h"


#define CLASSMAIN_FRAME	"menu/art/cut_frame"
#define INGAME_MENU_VERTICAL_SPACING	24

#define ID_SCOUT		100
#define ID_SNIPER		101
#define ID_SOLDIER		102
#define ID_HWGUY		103
#define ID_DEMOMAN		104
#define ID_MEDIC		105
#define ID_PYRO			106
#define ID_SPY			107
#define ID_ENGINEER		108

typedef struct
{
	menuframework_s	menu;
	menubitmap_s	frame;
	menutext_s		scout;
	menutext_s		sniper;
	menutext_s		soldier;
	menutext_s		hwguy;
	menutext_s		demoman;
	menutext_s		medic;
	menutext_s		pyro;
	menutext_s		spy;
	menutext_s		engineer;
} classmain_t;

static classmain_t		s_classmain;
static menuframework_s	s_classmain_menu;
static menuaction_s		s_classmain_scout;
static menuaction_s		s_classmain_sniper;
static menuaction_s		s_classmain_soldier;
static menuaction_s		s_classmain_hwguy;
static menuaction_s		s_classmain_demoman;
static menuaction_s		s_classmain_medic;
static menuaction_s		s_classmain_pyro;
static menuaction_s		s_classmain_spy;
static menuaction_s		s_classmain_engineer;

/*
===============
ClassMain_MenuEvent
===============
*/
static void ClassMain_MenuEvent ( void* ptr, int event ) {
	if( event != QM_ACTIVATED ) {
		return;
	}

	switch( ((menucommon_s*)ptr)->id ) {
	case ID_SCOUT:
		trap_Cmd_ExecuteText( EXEC_APPEND, "cmd scout\n" );
		UI_ForceMenuOff();
		break;

	case ID_SNIPER:
		trap_Cmd_ExecuteText( EXEC_APPEND, "cmd sniper\n" );
		UI_ForceMenuOff();
		break;

	case ID_SOLDIER:
		trap_Cmd_ExecuteText( EXEC_APPEND, "cmd soldier\n" );
		UI_ForceMenuOff();
		break;

	case ID_HWGUY:
		trap_Cmd_ExecuteText( EXEC_APPEND, "cmd hwguy\n" );
		UI_ForceMenuOff();
		break;

	case ID_DEMOMAN:
		trap_Cmd_ExecuteText( EXEC_APPEND, "cmd demoman\n" );
		UI_ForceMenuOff();
		break;

	case ID_MEDIC:
		trap_Cmd_ExecuteText( EXEC_APPEND, "cmd medic\n" );
		UI_ForceMenuOff();
		break;

	case ID_PYRO:
		trap_Cmd_ExecuteText( EXEC_APPEND, "cmd pyro\n" );
		UI_ForceMenuOff();
		break;

	case ID_SPY:
		trap_Cmd_ExecuteText( EXEC_APPEND, "cmd spy\n" );
		UI_ForceMenuOff();
		break;

	case ID_ENGINEER:
		trap_Cmd_ExecuteText( EXEC_APPEND, "cmd engineer\n" );
		UI_ForceMenuOff();
		break;
	}
}


/*
===============
ClassMain_MenuInit
===============
*/
void ClassMain_MenuInit( void ) {
	int		y;
//	int		gametype;
//	char	info[MAX_INFO_STRING];

	memset( &s_classmain, 0, sizeof(s_classmain) );

	ClassMain_Cache();

	s_classmain.menu.wrapAround = qtrue;
	s_classmain.menu.fullscreen = qfalse;

	s_classmain.frame.generic.type   = MTYPE_BITMAP;
	s_classmain.frame.generic.flags	= QMF_INACTIVE;
	s_classmain.frame.generic.name   = CLASSMAIN_FRAME;
/*
	s_classmain.frame.generic.x		= 142;
	s_classmain.frame.generic.y		= 118;
	s_classmain.frame.width			= 359;
	s_classmain.frame.height			= 256;
*/
	s_classmain.frame.generic.x			= 320-233;//142;
	s_classmain.frame.generic.y			= 240-166;//118;
	s_classmain.frame.width				= 466;//359;
	s_classmain.frame.height				= 332;//256;

	y = 128;

	s_classmain.scout.generic.type     = MTYPE_PTEXT;
	s_classmain.scout.generic.flags    = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
	s_classmain.scout.generic.id       = ID_SCOUT;
	s_classmain.scout.generic.callback = ClassMain_MenuEvent;
	s_classmain.scout.generic.x        = 320;
	s_classmain.scout.generic.y        = y;
	s_classmain.scout.string           = "SCOUT";
	s_classmain.scout.style            = UI_CENTER|UI_SMALLFONT;
	s_classmain.scout.color            = colorRed;
	y += INGAME_MENU_VERTICAL_SPACING;

	s_classmain.sniper.generic.type     = MTYPE_PTEXT;
	s_classmain.sniper.generic.flags    = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
	s_classmain.sniper.generic.id       = ID_SNIPER;
	s_classmain.sniper.generic.callback = ClassMain_MenuEvent;
	s_classmain.sniper.generic.x        = 320;
	s_classmain.sniper.generic.y        = y;
	s_classmain.sniper.string           = "SNIPER";
	s_classmain.sniper.style            = UI_CENTER|UI_SMALLFONT;
	s_classmain.sniper.color            = colorRed;
	y += INGAME_MENU_VERTICAL_SPACING;

	s_classmain.soldier.generic.type     = MTYPE_PTEXT;
	s_classmain.soldier.generic.flags    = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
	s_classmain.soldier.generic.id       = ID_SOLDIER;
	s_classmain.soldier.generic.callback = ClassMain_MenuEvent;
	s_classmain.soldier.generic.x        = 320;
	s_classmain.soldier.generic.y        = y;
	s_classmain.soldier.string           = "SOLDIER";
	s_classmain.soldier.style            = UI_CENTER|UI_SMALLFONT;
	s_classmain.soldier.color            = colorRed;
	y += INGAME_MENU_VERTICAL_SPACING;

	s_classmain.hwguy.generic.type     = MTYPE_PTEXT;
	s_classmain.hwguy.generic.flags    = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
	s_classmain.hwguy.generic.id       = ID_HWGUY;
	s_classmain.hwguy.generic.callback = ClassMain_MenuEvent;
	s_classmain.hwguy.generic.x        = 320;
	s_classmain.hwguy.generic.y        = y;
	s_classmain.hwguy.string           = "HEAVY WEAPONS GUY";
	s_classmain.hwguy.style            = UI_CENTER|UI_SMALLFONT;
	s_classmain.hwguy.color            = colorRed;
	y += INGAME_MENU_VERTICAL_SPACING;

	s_classmain.demoman.generic.type     = MTYPE_PTEXT;
	s_classmain.demoman.generic.flags    = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
	s_classmain.demoman.generic.id       = ID_DEMOMAN;
	s_classmain.demoman.generic.callback = ClassMain_MenuEvent;
	s_classmain.demoman.generic.x        = 320;
	s_classmain.demoman.generic.y        = y;
	s_classmain.demoman.string           = "DEMOMAN";
	s_classmain.demoman.style            = UI_CENTER|UI_SMALLFONT;
	s_classmain.demoman.color            = colorRed;
	y += INGAME_MENU_VERTICAL_SPACING;

	s_classmain.medic.generic.type     = MTYPE_PTEXT;
	s_classmain.medic.generic.flags    = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
	s_classmain.medic.generic.id       = ID_MEDIC;
	s_classmain.medic.generic.callback = ClassMain_MenuEvent;
	s_classmain.medic.generic.x        = 320;
	s_classmain.medic.generic.y        = y;
	s_classmain.medic.string           = "MEDIC";
	s_classmain.medic.style            = UI_CENTER|UI_SMALLFONT;
	s_classmain.medic.color            = colorRed;
	y += INGAME_MENU_VERTICAL_SPACING;

	s_classmain.pyro.generic.type     = MTYPE_PTEXT;
	s_classmain.pyro.generic.flags    = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
	s_classmain.pyro.generic.id       = ID_PYRO;
	s_classmain.pyro.generic.callback = ClassMain_MenuEvent;
	s_classmain.pyro.generic.x        = 320;
	s_classmain.pyro.generic.y        = y;
	s_classmain.pyro.string           = "PYRO";
	s_classmain.pyro.style            = UI_CENTER|UI_SMALLFONT;
	s_classmain.pyro.color            = colorRed;
	y += INGAME_MENU_VERTICAL_SPACING;

	s_classmain.spy.generic.type     = MTYPE_PTEXT;
	s_classmain.spy.generic.flags    = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
	s_classmain.spy.generic.id       = ID_SPY;
	s_classmain.spy.generic.callback = ClassMain_MenuEvent;
	s_classmain.spy.generic.x        = 320;
	s_classmain.spy.generic.y        = y;
	s_classmain.spy.string           = "SPY";
	s_classmain.spy.style            = UI_CENTER|UI_SMALLFONT;
	s_classmain.spy.color			 = colorRed;
	y += INGAME_MENU_VERTICAL_SPACING;

	s_classmain.engineer.generic.type     = MTYPE_PTEXT;
	s_classmain.engineer.generic.flags    = QMF_CENTER_JUSTIFY|QMF_PULSEIFFOCUS;
	s_classmain.engineer.generic.id       = ID_HWGUY;
	s_classmain.engineer.generic.callback = ClassMain_MenuEvent;
	s_classmain.engineer.generic.x        = 320;
	s_classmain.engineer.generic.y        = y;
	s_classmain.engineer.string           = "ENGINEER";
	s_classmain.engineer.style            = UI_CENTER|UI_SMALLFONT;
	s_classmain.engineer.color            = colorRed;
	y += INGAME_MENU_VERTICAL_SPACING;

//	trap_GetConfigString(CS_SERVERINFO, info, MAX_INFO_STRING);   
//	gametype = atoi( Info_ValueForKey( info,"g_gametype" ) );

//	taTODO: Add cvars here to grey items such as max_scouts, etc.

/*
	// set initial states
	switch( gametype ) {
	case GT_SINGLE_PLAYER:
	case GT_FFA:
	case GT_TOURNAMENT:
		s_classmain.scout.generic.flags  |= QMF_GRAYED;
		s_classmain.sniper.generic.flags |= QMF_GRAYED;
		break;

	default:
	case GT_TEAM:
	case GT_CTF:
		s_classmain.soldier.generic.flags |= QMF_GRAYED;
		break;
	}
*/
	Menu_AddItem( &s_classmain.menu, (void*) &s_classmain.frame );
	Menu_AddItem( &s_classmain.menu, (void*) &s_classmain.scout );
	Menu_AddItem( &s_classmain.menu, (void*) &s_classmain.sniper );
	Menu_AddItem( &s_classmain.menu, (void*) &s_classmain.soldier );
	Menu_AddItem( &s_classmain.menu, (void*) &s_classmain.hwguy );
	Menu_AddItem( &s_classmain.menu, (void*) &s_classmain.demoman );
	Menu_AddItem( &s_classmain.menu, (void*) &s_classmain.medic );
	Menu_AddItem( &s_classmain.menu, (void*) &s_classmain.pyro );
	Menu_AddItem( &s_classmain.menu, (void*) &s_classmain.spy );
	Menu_AddItem( &s_classmain.menu, (void*) &s_classmain.engineer );
}


/*
===============
ClassMain_Cache
===============
*/
void ClassMain_Cache( void ) {
	trap_R_RegisterShaderNoMip( CLASSMAIN_FRAME );
}


/*
===============
UI_ClassMainMenu
===============
*/
void UI_ClassMainMenu( void ) {
	ClassMain_MenuInit();
	UI_PushMenu ( &s_classmain.menu );
}
