/*
	This is the header file for the FXT patch program.  It contains defintions
   for all of the structures used as well as function prototypes.

   Date		By	Description
   -----------	---	-----------------------------------------------------------
   25-Jan-1998	DML	Created as keeping everything in one place was getting to
				untidy.
*/

#ifndef FXTPATCH_INCLUDE
#define FXTPATCH_INCLUDE

//	This is where all of the structures are defined
typedef struct
{
	char far *szID;			//	Id of the message
	char far *szMessage;	//	Message itself, or 0 if the string is to be removed
} ST_MESSAGE;

typedef struct tag_ListItem
{
	struct tag_ListItem	far *pstNext;		//	Next item in list
	struct tag_ListItem far *pstPrevious;	//	Previous item in list
	ST_MESSAGE          far *pstMessage;	//
} ST_LIST_ITEM;

typedef struct
{
	ST_LIST_ITEM far	*pstFirst;
	ST_LIST_ITEM far   	*pstLast;
	ST_LIST_ITEM far   	*pstCurrent;
	int					iItems;
} ST_LIST_HEADER;

typedef struct
{
	int	iOutputFile;
	int	iPatchFile;
	int	iUndoFile;
	int iVerboseMode;
	int	iEncrypt;
	int	iDecrypt;
	int	iGenerate;
} ST_PROGRAM_ARGS;

//	Function Prototypes
void ParseCommandLine( int iNumberOfArgs, char **pszProgramArgs, ST_PROGRAM_ARGS *pstProgramArgs );
void WalkList( ST_LIST_HEADER *pstHeader );
void LoadFile( char *szFilename, ST_LIST_HEADER *pstHeader );
void WriteFile( char *szFilename, ST_LIST_HEADER *pstHeader, int	iFXTFile );
void AppendMessageToList( ST_LIST_HEADER *pstHeader, ST_MESSAGE far *pstMessage );
void AddMessageInOrderToList( ST_LIST_HEADER *pstHeader, ST_MESSAGE far *pstMessage );
void InitListHeader( ST_LIST_HEADER *pstHeader );
void ApplyPatch( ST_LIST_HEADER *pstMainList, ST_LIST_HEADER *pstPatchList, ST_LIST_HEADER *pstUndoMessages, int iVerbose );
void GeneratePatch( ST_LIST_HEADER *pstOriginal, ST_LIST_HEADER *pstNew, ST_LIST_HEADER *pstPatch, int iVerbose );
ST_MESSAGE * ReadMessage( char *acFile );
void FreeMessage( ST_MESSAGE far *pstMessage );
void ExtractMessageIntoList( ST_LIST_HEADER *pstHeader, char far *szMessage );
ST_MESSAGE far * CreateMessage( void );
ST_LIST_ITEM far * CreateListItem( void );
char far * CreateEmptyString( void );
void DestroyList( ST_LIST_HEADER *pstHeader );
ST_MESSAGE far * CreateDeleteMessage( ST_MESSAGE far *pstMessage );
ST_MESSAGE far * CreateDuplicateMessage( ST_MESSAGE far *pstMessage );
void RemoveCurrentItemFromList( ST_LIST_HEADER *pstHeader );
void FindMatchingMessage( ST_LIST_HEADER *pstMainList, ST_MESSAGE *pstMessageToFind );
int CompareMessageIDs( ST_MESSAGE *pstMessage1, ST_MESSAGE *pstMessage2 );
void WriteMessageToBuffer( char *acBuffer, char far *szID, char far *szMessage );

#endif
