// Copyright 1998 Olivier Mengu
// Distributed under the GPL (GNU Public Licence)

#define STRICT

// Pour acclrer le traitement de Windows.h, et utiliser moins de mmoire pour la compilation
#define NOMINMAX
//#define NOGDI
#define NOGDICAPMASKS
#define NOMENUS
#define NOATOMS
//#define NOCTLMGR
#define NOMEMMGR
#define NODRAWTEXT
#define NOTEXTMETRIC
//#define NOWINOFFSETS
#define NOHELP
#define NOPROFILER
#define NONLS
#define NOSCROLL
#define NOICONS
#define NORASTEROPS
//#define NOSHOWWINDOW
#define NOCOLOR
#define NOCLIPBOARD
//#define NOWINMESSAGES
#define NOSYSMETRICS
#define NOWINSTYLES
#define NOVIRTUALKEYS
#define NOKEYSTATES
#define NOSOUND
#define NOOPENFILE
#define NOMETAFILE
#define NOSERVICE
#define NOWH
#define NOKANJI
#define NOCOMM
#define NODEFERWINDOWPOS
#define NOMCX
#define _IMM_	// vite l'inclusion de imm.h qui pose problme, mais ne sert  rien


#ifdef UNICODE
#undef UNICODE
#endif

#include <windows.h>
#include <windowsx.h>

#include <shlobj.h>

#include <assert.h>

#include "resource.h"



#define szAppName TEXT("FXTEdit")






static void SystemErrorMessage()
{
	LPTSTR lpMsgBuf;
	DWORD dwError;

	if (((dwError=GetLastError()) != 0)
		&& (FormatMessage(
				FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_IGNORE_INSERTS  | FORMAT_MESSAGE_FROM_SYSTEM,
				NULL,
				dwError,
				MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
				(LPTSTR)&lpMsgBuf,
				0,
				NULL
				) != 0)
			) {
		MessageBox(NULL, lpMsgBuf, szAppName, MB_OK|MB_ICONERROR|MB_APPLMODAL);
		LocalFree(lpMsgBuf);
	}
}







static TCHAR szGTAPath[MAX_PATH];

#define FXT_LANGUAGES	4
#define FXT_ENGLISH		0
#define FXT_FRENCH		1
#define FXT_GERMAN		2
#define FXT_ITALIAN		3
//#define FXT_SPECIAL		4

static const TCHAR *szFxtFile[FXT_LANGUAGES] = {
	TEXT("GTADATA\\ENGLISH.FXT"),
	TEXT("GTADATA\\FRENCH.FXT"),
	TEXT("GTADATA\\GERMAN.FXT"),
	TEXT("GTADATA\\ITALIAN.FXT")
	//TEXT("GTADATA\\SPECIAL.FXT"),
};

typedef struct _FXTSTRING {
	LPTSTR pszID;
	LPTSTR apszString[FXT_LANGUAGES];
	INT anOrder[FXT_LANGUAGES];
	// BOOL bOriginal;
	BOOL bModified;
	struct _FXTSTRING *pfxtstrNext;
} FXTSTRING, *LPFXTSTRING;



static LPFXTSTRING pFxtStringsList = NULL;
static LPFXTSTRING pLastFxtString = NULL;
static int nFxtStrings = 0;



static BOOL PromptForGTAPath()
{
	BROWSEINFO bi;
	LPITEMIDLIST pidl;
	BOOL bOk;

	bi.hwndOwner = NULL;
	bi.pidlRoot = NULL;
	bi.pszDisplayName = NULL;	// We don't need the 'Display Name'
	bi.lpszTitle = TEXT("Select the folder where you installed Grand Theft Auto.\n"
						"\n"
						"Note: you can store the GTA path forever in the ")
					TEXT(szAppName) TEXT(".ini.");
	bi.ulFlags = BIF_RETURNONLYFSDIRS;
	bi.lpfn = NULL;
	bi.lParam = NULL;
	bi.iImage = NULL;
	if (pidl = SHBrowseForFolder(&bi)) {
		bOk = SHGetPathFromIDList(pidl, szGTAPath);
		CoTaskMemFree(pidl);
		return bOk;
	}
	return FALSE;
}



static BOOL CheckGTAPath()
{
	WIN32_FIND_DATA ffd;
	HANDLE hFindFile;
	int l;

	l = lstrlen(szGTAPath);
	if (l == 0)
		return FALSE;
	if (szGTAPath[l-1] != '\\') {
		szGTAPath[l] = '\\';
		szGTAPath[++l] = '\0';
	}
	if (l > MAX_PATH-7/*GTADATA*/-1-5/*AUDIO*/-12/*VOCALCOM.RAW*/-1)
		return FALSE;
	// We check there is a GTADATA folder in the GTA path given
	lstrcpy(szGTAPath+l, "GTADATA");
	hFindFile = FindFirstFile(szGTAPath, &ffd);
	if (hFindFile != INVALID_HANDLE_VALUE) {
		FindClose(hFindFile);
	}
	szGTAPath[l] = '\0';
	return (hFindFile != INVALID_HANDLE_VALUE && (ffd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) != 0);
}


static BOOL GetGTAPath()
{
	BOOL bError;
	TCHAR szPath[MAX_PATH+20];

	if (GetPrivateProfileString(TEXT("GTA"), TEXT("GTAPath"), NULL, szGTAPath, sizeof(szGTAPath)/sizeof(szGTAPath[0]), ".\\FXTEdit.ini") != NULL) {
		if (CheckGTAPath())
			return TRUE;
		else
			MessageBox(NULL, TEXT("Wrong directory in ") szAppName TEXT(".ini!"), szAppName, MB_OK|MB_ICONERROR);
	}
	do {
		if (!PromptForGTAPath())
			return FALSE;
		bError = !CheckGTAPath();
		if (bError) {
			wsprintf(szPath, TEXT("%s: wrong directory!"), szGTAPath);
			MessageBox(NULL, szPath, szAppName, MB_OK|MB_ICONWARNING);
		}
	} while (bError);

	// This way, the .ini file can be created on the hard disk if launched from a CD-ROM
	// It may be better to create it only in the FXTEdit folder (using GetModuleFileName)
	WritePrivateProfileString(TEXT("GTA"), TEXT("GTAPath"), szGTAPath, TEXT(".\\") szAppName TEXT(".ini"));

	return TRUE;
}


#define BUFFER_SIZE 32768
static HANDLE hFile;
static UCHAR acReadBuffer[BUFFER_SIZE];
static DWORD dwBytesRead;
static DWORD dwBufferPos;
static DWORD dwCharPos;


static int LoadChar()
{
	if (dwBytesRead == 0 || dwBufferPos == dwBytesRead) {
		ReadFile(hFile, acReadBuffer, BUFFER_SIZE, &dwBytesRead, NULL);
		dwBufferPos = 0;
		if (dwBytesRead == 0)
			return -1;
	}
	return acReadBuffer[dwBufferPos++];
}


// Decoding the byte
static int GetFXTChar()
{
	int c;

	c = LoadChar();
	if (c == -1)
		return -1;
	else if (dwCharPos < 8) {
		static const acKey[] = { 0x64,0xC7,0x8D,0x19,0x31,0x61,0xC1,0x81 };
		c = (c-acKey[dwCharPos]);
		if (c < 0)
			c += 256;
		dwCharPos++;
		return c;
	} else {
		//dwCharPos++;
		switch(c) {
		case 255:
			OutputDebugString("@");
			//return GetFXTChar(); // On ignore
			return 255;
		case 196:
			c = LoadChar();
			if (c == -1)
				return -1;
			return c+63;
		case 1:
			return '\n';
		default:
			return c-1;
		}
	}
}



static LPFXTSTRING GetFXTString(IN LPCTSTR pszID)
{
	LPFXTSTRING pFxtStr;
	for(pFxtStr=pFxtStringsList; pFxtStr; pFxtStr=pFxtStr->pfxtstrNext) {
		if (lstrcmp(pFxtStr->pszID, pszID) == 0)
			return pFxtStr;
	}
	return NULL;
}


LPVOID MyMemAlloc(DWORD dwBytes)
{
	//return GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT, dwBytes);
	return LocalAlloc(LMEM_FIXED|LMEM_ZEROINIT, dwBytes);
	//return HeapAlloc(hHeap, 0, dwBytes);
	//return calloc(1, dwBytes);
}



// equivalent  strdup (_strdup avec VC++)
static LPTSTR NewStr(IN LPCTSTR pszSrc, IN INT nLength)
{
	LPTSTR pszDest, pszReturn;
	if (nLength == -1)
		nLength = lstrlen(pszSrc);
	//pszDest = GlobalAlloc(GMEM_FIXED, (nLength+1)*sizeof(TCHAR));
	//pszDest = LocalAlloc(LMEM_FIXED, (nLength+1)*sizeof(TCHAR));
	//pszDest = HeapAlloc(hHeap, 0, (nLength+1)*sizeof(TCHAR));
	pszDest = (LPTSTR)MyMemAlloc((nLength+1)*sizeof(TCHAR));
	if (pszDest == NULL)
		return NULL;
	pszReturn = lstrcpy(pszDest, pszSrc);
	if (pszReturn == NULL)
		LocalFree(pszDest);
	return pszReturn;
}


static BOOL LoadLanguageFile(IN int nLanguage)
{
	TCHAR szID[64], szMsg[256];
	int i;
	char c;
#ifdef _DEBUG
	//TCHAR szTmp[10];
#endif
	LPFXTSTRING pFxtStr;
	TCHAR szFileName[MAX_PATH];

	lstrcpy(szFileName, szGTAPath);
	lstrcat(szFileName, szFxtFile[nLanguage]);
#ifdef _DEBUG
	OutputDebugString("FXT File to load: ");
	OutputDebugString(szFileName);
	OutputDebugString("\r\n");
#endif

	dwBufferPos = dwBytesRead = dwCharPos = 0;
	hFile = CreateFile(szFileName,
						GENERIC_READ,
						FILE_SHARE_READ,
						NULL,
						OPEN_EXISTING,
						FILE_ATTRIBUTE_NORMAL|FILE_FLAG_SEQUENTIAL_SCAN,
						NULL);
	if (hFile == INVALID_HANDLE_VALUE) {
		//ShowMessage(hwndMain, MB_OK|MB_ICONERROR, IDS_CANTOPENFILE, lpstrFileName);
		SystemErrorMessage();
		return FALSE;
	}

	c = GetFXTChar();
	while (c != -1) {
		if (c != '[')
			break;
		i = 0;
		while ((c = GetFXTChar()) != -1 && c != ']') {
			szID[i++] = c;
		}
		if (c != ']' || i == 0)
			break;
		szID[i] = '\0';
		i = 0;
		while ((c = GetFXTChar()) != -1 && c != '[') {
			szMsg[i++] = c;
		}
		if (c == -1)
			break;
		if (i && szMsg[i-1] == '\n')
			i--;
		szMsg[i] = '\0';

		pFxtStr = GetFXTString(szID);
		if (pFxtStr == NULL) {
			//pFxtStr = LocalAlloc(LMEM_FIXED|LMEM_ZEROINIT, sizeof(FXTSTRING));
			//pFxtStr = HeapAlloc(hHeap, HEAP_ZERO_MEMORY, sizeof(FXTSTRING));
			pFxtStr = (LPFXTSTRING)MyMemAlloc(sizeof(FXTSTRING));
			if (pFxtStr == NULL)
				// Traiter une ventuelle erreur
				OutputDebugString("Erreur d'allocation !\r\n");
			// Copie de l'ID
			pFxtStr->pszID = NewStr(szID, -1);

			if (pFxtStringsList == NULL) {
				pFxtStringsList = pFxtStr;
			} else {
				pLastFxtString->pfxtstrNext = pFxtStr;
			}
			pLastFxtString = pFxtStr;

			//pFxtStr->pfxtstrNext = NULL;
			//pFxtStr->pszString[nLanguage] = NULL;
		}
		if (pFxtStr->apszString[nLanguage] == NULL) {
			pFxtStr->apszString[nLanguage] = NewStr(szMsg, i);
			//pFxtStr->anOrder[nLanguage] = ;
			//assert(pFxtStr->pszString[nLanguage] != NULL);
		}
		// else MsgBox...

	}
	CloseHandle(hFile);
	return TRUE;
}



// Penser  convertir la chane en UNICODE si UNICODE est dfini
static BOOL LoadFXTStrings()
{
	nFxtStrings = 0;
	pFxtStringsList = pLastFxtString = NULL;
	return LoadLanguageFile(FXT_ENGLISH)
		&& LoadLanguageFile(FXT_FRENCH)
		&& LoadLanguageFile(FXT_GERMAN)
		&& LoadLanguageFile(FXT_ITALIAN)		;
}



void UpdateDialog(HWND hwndDlg)
{
	int iSelectedID;
	LPTSTR pszSelectedID;
	int nLength;
	LPFXTSTRING pFxtStr;
	int i;
	HWND hwndFXTEntryID = GetDlgItem(hwndDlg, IDC_FXT_ENTRY_ID);
	iSelectedID = ComboBox_GetCurSel(hwndFXTEntryID);
	if (iSelectedID != CB_ERR) {
		if ((nLength = ComboBox_GetLBTextLen(hwndFXTEntryID, iSelectedID)) != CB_ERR
			&& (pszSelectedID = (LPTSTR)LocalAlloc(LMEM_FIXED, (nLength+1)*sizeof(TCHAR))) != NULL) {
			ComboBox_GetLBText(hwndFXTEntryID, iSelectedID, pszSelectedID);
			if ((pFxtStr = GetFXTString(pszSelectedID)) != NULL) {
				for(i=0; i<FXT_LANGUAGES; i++)
					Edit_SetText(GetDlgItem(hwndDlg, IDC_FXT_ENGLISH+i), (pFxtStr->apszString[i]) ? (pFxtStr->apszString[i]) : TEXT("N/A"));
			}
			LocalFree(pszSelectedID);
		} else iSelectedID = CB_ERR;
	}
	if (iSelectedID == CB_ERR) {
		for(i=0; i<FXT_LANGUAGES; i++)
			Edit_SetText(GetDlgItem(hwndDlg, IDC_FXT_ENGLISH+i), TEXT("N/A"));
	}
}





BOOL CALLBACK FXTEditDlgProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	static HWND hwndFXTEntryID;
	LPFXTSTRING pFxtStr;
	LPTSTR pszWantedID;
	INT nLength;
	INT iSelectedID;

	switch (uMsg) {
	case WM_INITDIALOG:
		hwndFXTEntryID = GetDlgItem(hwndDlg, IDC_FXT_ENTRY_ID);
		for(pFxtStr = pFxtStringsList; pFxtStr; pFxtStr=pFxtStr->pfxtstrNext) {
			ComboBox_AddString(hwndFXTEntryID, pFxtStr->pszID);
		}
		if ((HWND)wParam != hwndFXTEntryID) {
			SetFocus(hwndFXTEntryID);
			return FALSE;
		}
		return TRUE;
	case WM_COMMAND:
		switch (GET_WM_COMMAND_CMD(wParam, lParam)) {
		case BN_CLICKED:
			if (wParam == MAKEWPARAM(IDCANCEL, BN_CLICKED)) {
				DestroyWindow(hwndDlg);
				return TRUE;
			} else if (wParam == MAKEWPARAM(IDC_ABOUT, BN_CLICKED)) {
				MessageBox(hwndDlg, TEXT("FXTEdit version 0.1\n\nCopyright 1998 Olivier Mengu"), TEXT("About ") szAppName, MB_OK|MB_ICONINFORMATION);
			}
			break;
		case CBN_EDITCHANGE:
			nLength = ComboBox_GetTextLength(hwndFXTEntryID);
			pszWantedID = (LPTSTR)LocalAlloc(LMEM_FIXED, nLength);
			if (pszWantedID != NULL) {
				ComboBox_GetText(hwndFXTEntryID, pszWantedID, nLength);
				iSelectedID = ComboBox_FindString(hwndFXTEntryID, -1, pszWantedID);
				if (iSelectedID != CB_ERR)
					ComboBox_SetCurSel(hwndFXTEntryID, iSelectedID);
				//ComboBox_SelectString(hwndFXTEntryID, iSelectedID, pszWantedID);
				LocalFree(pszWantedID);
			}
			// Continue with UpdateDialog, below
		case CBN_SELCHANGE:
			UpdateDialog(hwndDlg);
			break;
		}
		break;
	case WM_CLOSE:
		DestroyWindow(hwndDlg);
		return TRUE;
	case WM_DESTROY:
		PostQuitMessage(0);
		break;
	}
	return FALSE;
}





// On jecte la librairie standard
#define NOCRT

#if defined(_MSC_VER) && defined(NOCRT)
//#pragma comment(linker, "/MERGE:.idata=.data")
//#pragma comment(linker, "/MERGE:.data=.code")
#pragma comment(linker, "/ENTRY:FXTEditMain")
#pragma comment(linker, "/SUBSYSTEM:Windows")
#endif



#if defined(_MSC_VER) && defined(NOCRT)
void FXTEditMain()
#define hInstance GetModuleHandle(NULL)
#define nCmdShow SW_SHOWDEFAULT
#else
int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
#endif
{
	static HWND hwndFXTEditDlg;
	static MSG msg;
	static LPFXTSTRING pFxtStr;

	if (!GetGTAPath())
		ExitProcess(-1);
#ifdef _DEBUG
	OutputDebugString("GTA path: ");
	OutputDebugString(szGTAPath);
	OutputDebugString("\r\n");
#endif
	if (!LoadFXTStrings())
		ExitProcess(-1);
#ifdef _DEBUG
/*
	for(pFxtStr=pFxtStringsList; pFxtStr; pFxtStr=pFxtStr->pfxtstrNext) {
		if (pFxtStr->pszID == NULL)
			OutputDebugString("NULL");
		else
			OutputDebugString(pFxtStr->pszID);
		OutputDebugString(": ");
		if (pFxtStr->pszString[FXT_FRENCH] == NULL)
			OutputDebugString("N/A");
		else
			OutputDebugString(pFxtStr->pszString[FXT_FRENCH]);
		OutputDebugString("\r\n");
	}
*/
#endif

	hwndFXTEditDlg = CreateDialog(hInstance, MAKEINTRESOURCE(IDD_FXTEDIT), NULL, FXTEditDlgProc);

	SendMessage(hwndFXTEditDlg, WM_SETICON, (WPARAM)ICON_BIG, (LPARAM)LoadIcon(hInstance, MAKEINTRESOURCE(IDI_APP)));

	ShowWindow(hwndFXTEditDlg, nCmdShow);
	UpdateWindow(hwndFXTEditDlg);

	// Main message loop:
	while (GetMessage(&msg, NULL, 0, 0)) {
		// La fonction IsDialogMessage intercepte les touches Tabulation, Entre,
		// Alt+Lettre (o Lettre correspond  un raccourci d'accs  un contrle).
		if (!IsDialogMessage(hwndFXTEditDlg, &msg)) {
			// Si on fait la traduction des messages avec TranslateMessage, les
			// leds NumLock, CapsLock seront mises  jour.
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

#ifdef NOCRT
	ExitProcess(0);
#else
	return 0;
#endif
}
