#include <stdio.h>
#include <fstream.h>
#include <conio.h>
#include <stdlib.h>
#include <go32.h>
#include <dpmi.h>
#include <keys.h>
#include <pc.h>
#include <libc/farptrgs.h>
#include <string.h>
#include <dir.h>

fstream CityFile; // global file-identifier
fstream CityBack; // backup file
char BackupFile[256]; // just reserve enough
unsigned vectors[7]; // place to store the city-vectors
unsigned char * bl,* gr,* col,* ro,* po, *lo, *na;  // block,grid,column,route and positions
long NRoutes[3];
char Rmode=0;
char Umode=0;
char Bmode=0;
char Tmode=0;
char Imode=0;
char Gmode=0;
char Mode=0;
char Follow=0;
char AFmode=0;
char *Line_Contents;
int Old_Col;

typedef unsigned char uc;
typedef unsigned long ul;
typedef unsigned int ui;

uc TLights;

#define Route 0;
#define Position 1;
#define Column 2;
#define Block 3;


struct Route_Coord
{
  Route_Coord * Prev;
  Route_Coord * Next;
  uc X;
  uc Y;
  uc Z;
};

struct Route_Line
{
  Route_Line * Prev;
  Route_Line * Next;
  uc Type;
  uc Num; // count the number of REAL coordinates in a route
  Route_Coord * Start;
  Route_Coord * End;
};

struct Route_Total
{
  Route_Line * Start;
  Route_Line * End;
}Routes[3];

struct TLight_Info
{
  uc Link;
  ul Address;
}TLight[254];


void clprintf (char * String)
{
  char * ptr2;
  char String2[80];
  char String3[80];
  char * ptr;
  char Ready=0;
  strcpy (String2,String);
  while (!Ready)
   {
     ptr=strchr(String2,'#');
     if (ptr)
       {
         if (ptr!=String2) // not the first character
           {
             strcpy (String3,String2); // backup
             ptr[0]=0; // force end
             cprintf ("%s",String2);
             strcpy (String2,String3); //recover
           }
         textcolor ((*(ptr+1))-65);
         ptr2=strchr (ptr+2,'#');
         if (!ptr2)
            {
              Ready=1;
              cprintf ("%s",ptr+2);
            }
          else
            {
              strcpy (String3,ptr2);
              ptr2 [0]=0; // force end of string
              strcpy (String2,ptr+2);
              cprintf ("%s",String2);
              strcpy (String2,String3);
            }
       }
     else
       {
         Ready=1;
         cprintf ("%s",String2);
       }
   }
}

void Do_Error (char * Text1,char * Text2="",char * Text3="",char * Text4="")
{
  gettext (20,20,60,30,Line_Contents+200);textcolor(15);
  gotoxy(20,20);cprintf ("ͻ");
  for (uc Count=21;Count<=29;Count++)
    {gotoxy (20,Count);cprintf ("                                      ");}
  gotoxy(20,30);cprintf ("ͼ");
  if (strcmp(Text1,"")) {gotoxy(((38-strlen(Text1))/2)+21,23);clprintf (Text1);}
  if (strcmp(Text2,"")) {gotoxy(((38-strlen(Text1))/2)+21,24);clprintf (Text2);}
  if (strcmp(Text3,"")) {gotoxy(((38-strlen(Text1))/2)+21,25);clprintf (Text3);}
  if (strcmp(Text4,"")) {gotoxy(((38-strlen(Text1))/2)+21,26);clprintf (Text4);}
  gotoxy(29,29);clprintf ("#LPress any key to continue#P");
  getkey();
  puttext (20,20,60,30,Line_Contents+200);
}

void GetVectors (void)
{
  unsigned dummy;
  CityFile.seekg (0,ios::beg); // start at the beginning
  CityFile.read ((char *)(&vectors[0]),sizeof (vectors[0])); // header
  CityFile.read ((char *)(&vectors[1]),sizeof (vectors[1])); // map/sample nr.
  CityFile.read ((char *)(&vectors[2]),sizeof (vectors[2])); // Route size
  CityFile.read ((char *)(&vectors[3]),sizeof (vectors[3])); // Position size
  CityFile.read ((char *)(&vectors[4]),sizeof (vectors[4])); // Column size
  CityFile.read ((char *)(&vectors[5]),sizeof (vectors[5])); // Block size
  CityFile.read ((char *)(&vectors[6]),sizeof (vectors[6])); // Navigation size
}

long Read_Array (char N,long address,uc * Array)  // read a number of bytes from an array
{
   long fact;
   ul result;
   result=0;
   uc read;
   fact=1;
   for (char t=1;t<=N;t++)
     {
       read=Array[address];
       result+=(read*fact);
       fact *=256; // next byte
       address++;
     }
   return result;
}

uc * Read_Grid (void)
{
  long n=0;
  char ch;
  uc *g=(uc *) malloc (0x40000); // reserve city grid data
  if (g==0) {printf ("no memory");exit (1);}
  for (long Count=1;Count <=0x40000;Count ++)  // 256*256*4 bytes
     {
       CityFile.read ((char *)(&ch),sizeof (ch)); // read them
       g[n]=ch;                                   // put in array
       n++;
     }
  return g; // use pointer for reference
}

uc * Read_Column (void)
{
  long n=0;
  char ch;
  uc *c=(uc *) malloc (vectors[4]); // reserve column data
  if (c==0) {printf ("no memory");exit (1);}
  for (long Count=1;Count <=vectors[4];Count ++)
     {
       CityFile.read ((char *)(&ch),sizeof (ch)); // read them
       c[n]=ch;                                   // put in array
       n++;
     }
  return c;
}

uc * Read_Block (void)
{
  long n=0;
  char ch;
  uc *b=(uc *) malloc (vectors[5]); // reserve block data
  if (b==0) {printf ("no memory");exit (1);}
  for (long Count=1;Count <=vectors[5];Count++)
    {
      CityFile.read ((char *)(&ch),sizeof (ch));
      b[n]=ch;
      n++;
    }
  return b;
}

uc * Read_Position (void)
{

  TLights=0;
  long n=0;
  char Found=0; // found a traffic light ??
  char NulRoute=0; // still no 0-route
  char ch;
  uc *p=(uc *) malloc (vectors[3]+(253*14)); // reserve block data + max 253 new lights
  if (p==0) {printf ("no memory");exit (1);}
  for (uc Count3=0;Count3<=253;Count3++)
    {
      TLight[Count3].Link=255;   // empty records
      TLight[Count3].Address=0;
    }
  if (!vectors[3]) return p;
  for (long Count=1;Count <=(vectors[3]/14);Count++) // 14 bytes / struct
    {
      for (char Count2=1;Count2<=7;Count2++) // read coordinates and type
        {
          CityFile.read ((char *)(&ch),sizeof (ch));
          p[n]=ch;
          n++;
        } // ch contains the type
      if (ch==16) Found=1; // trafficlight !!!
            else  Found=0;
      CityFile.read ((char *)(&ch),sizeof (ch));
      p[n]=ch;
      n++;   // read remap-info
      CityFile.read ((char *)(&ch),sizeof (ch));
      p[n]=ch;
      n++;
      if (Found) // note rotation info on traffic light
        {
          if (ch==0)
            if (NulRoute) ch=254; // not the first 0-route (ignore)
                     else NulRoute=1;
          TLight[TLights].Link=ch;
          TLight[TLights].Address=n-1; // counter is allready moved
          TLights++;
        }
      for (char Count2=1;Count2<=5;Count2++) // read the rest
        {
          CityFile.read ((char *)(&ch),sizeof (ch));
          p[n]=ch;
          n++;
        }
    }
  return p;
}

uc * Read_Routes (void)
{
  long BR=0;      // bytes read
  uc Num;
  uc Select; //select type array
  uc Type;
  uc X;
  uc Y;
  uc Z;
  uc NulRoute=0; // no 0-route found
  for (char Count=0;Count<=2;Count++)
  {
    Routes[Count].Start=0L;
    Routes[Count].End=0L;
  }
  while (BR<vectors[2])
   {
     Route_Line *R=(Route_Line*) malloc (sizeof (Route_Line)); // reserve space for one
     if (R==0) {printf ("no memory");exit (1);}
     R->Start=0L;
     R->End=0L;
     CityFile.read ((char *)(&Num),sizeof (Num));
     CityFile.read ((char *)(&Type),sizeof (Type));
     if (Type<254) Select=2;else Select=Type-254;
     if (Type==0) NulRoute=1; // found a 0-route
     BR+=2;
     R->Type=Type;
     R->Num=Num-1;
     for (char Count=1;Count<=Num;Count++)
       {
         CityFile.read ((char *)(&X),sizeof (X));
         CityFile.read ((char *)(&Y),sizeof (Y));
         CityFile.read ((char *)(&Z),sizeof (Z));
         BR+=3;
         if (X|Y|Z)
           {
             Route_Coord *C=(Route_Coord*) malloc (sizeof (Route_Coord));
             if (C==0) {printf ("no memory");exit (1);}

             if (R->Start==0L) // first record coordinates
                 {
                   R->Start=C;
                   R->End=C;
                   C->Prev=0L;
                   C->Next=0L;
                 }
              else
                 {
                   R->End->Next=C;
                   C->Prev=R->End;
                   C->Next=0L;
                   R->End=C;
                 }
             C->X=X;C->Y=Y;C->Z=Z;
           }
       }
    NRoutes[Select]++; // keep number of routes
    if (Routes[Select].Start==0L) // first record routes
         {
           Routes[Select].Start=R;
           Routes[Select].End=R;
           R->Prev=0L;
           R->Next=0L;
         }
      else
         {
           Routes[Select].End->Next=R;
           R->Prev=Routes[Select].End;
           R->Next=0L;
           Routes[Select].End=R;
         }
   }
  if (!NulRoute)
    for (uc Count=0;Count<=253;Count++)
      if (TLight[Count].Link==0) TLight[Count].Link=254;
}

uc * Read_Locations (void)
{
  long n=0;
  char ch;
  uc *l=(uc *) malloc (108); // reserve location data (3*6*6)
  if (l==0) {printf ("no memory");exit (1);}
  for (long Count=1;Count <=108;Count++)
    {
      CityFile.read ((char *)(&ch),sizeof (ch));
      l[n]=ch;
      n++;
    }
  return l;
}

uc * Read_Navigation (void)
{
  long n=0;
  char ch;
  uc *nav=(uc *) malloc (vectors[6]); // reserve block data
  if (nav==0) {printf ("no memory");exit (1);}
  for (long Count=1;Count <=vectors[6];Count++)
    {
      CityFile.read ((char *)(&ch),sizeof (ch));
      nav[n]=ch;
      n++;
    }
  return nav;
}


ul Check_Column (int X,int Y)
{
  uc light=0;
  ul result;
  ul offset;
  ui N;
  ui Blocks[6]; // put the blocks here
  ui Attr;
  uc Att2;
  offset=Read_Array(4,((Y*256)+X)*4,gr);
  N=Read_Array(2,offset,col);
  char bit=1; // 6 bits per byte
  uc bit2=8; // position 1 for road direction
  for (char Count=1;Count<=6-N;Count++) // read column from file
    {
      Blocks[Count-1]=Read_Array(2,offset+(Count*2),col);
      bit*=2;bit2+=4;
    }
  ul BitBackup=bit2;
  result=0; // reset road info
  for (char Count=1;Count<=6-N;Count++) // process levels
    {
      Attr=Read_Array(2,Blocks[Count-1]*8,bl);
      Att2=Read_Array(1,(Blocks[Count-1]*8)+2,bl);
      if ((Att2 & 7)==1) light=1;
      bit/=2;bit2-=4; // correct bit count
      if ((result & 0xC0) ==0) // upper bits not used yet
        {
          if ((Attr & 0x70)==16) result|=64;   // water found
          if ((Attr & 0x70)==48) result|=128;  // pavement found
          if ((Attr & 0x70)==64) result|=128;  // field found
          if ((Attr & 0x70)==80) result|=192;  // building found
        }

      if ((((Attr & 0x70)==32) && Tmode==0) ||
         ((Att2 & 0x80) && Tmode==1) ||
         (((Attr & 0x70)==32) && !(Att2 & 0x80) && Tmode==2))

        {
          result|=bit; // found some road
          result|=((Attr & 0x0F) << bit2); // copy direction info
        }
       else
         if (((Attr & 0x0F)==1) || ((Attr & 0x0F)==2) ||
             ((Attr & 0x0F)==4) || ((Attr & 0x0F)==8))
                result|=(13 << bit2); // one direction but no road (goverment)
          else  result|=(15 << bit2); // all directions=> NO ROAD

    }
  bit2=BitBackup;
  if (N>0)
    for (char Count=1;Count<=N;Count++)
     {
      result|=(15 << bit2);
      bit2+=4;
     }

  bit=8;
  if (light)
    for (char Count=1;Count<=6;Count++)
      {
       if (((result >>bit) & 15)==15) result-= (1 <<bit);
       bit+=4;
      }
  return result;
}

void On_Screen (uc SX,uc SY,int Char,int Attr,uc X,uc Y)
{
  if ((X>=SX) && (X<=SX+79) &&
      (Y>=SY) && (Y<=SY+47))
     {
       ScreenPutChar (Char,Attr,X-SX,Y-SY);
     }
}

void Get_Route (uc X,uc Y,Route_Line * Address,uc mode)
{
  if (!NRoutes[mode]) return;
  uc Point=0;
  Route_Coord * Ptr=Address->Start;
  while (Ptr!=0L)
    {
      if ((Ptr->X|Ptr->Y)!=0)
          On_Screen (X,Y,'',Ptr->Z+10,Ptr->X,Ptr->Y);
      Point++;
      Ptr=Ptr->Next;
    }
}

Route_Line * Get_Block (uc X,uc Y,uc Nr)
{
  if (!TLights) return 0L;
  ul RX=Read_Array(2,TLight[Nr].Address-8,po)/64;//get 14bits coords
  ul RY=Read_Array(2,TLight[Nr].Address-6,po)/64;
  On_Screen (X,Y,'',7,RX,RY);
  if (!NRoutes[2]) return 0L;
  Route_Line * Back=0L;
  Route_Line * Ptr=Routes[2].Start; // start with the first
  while (Ptr)
     {
       if (Ptr->Type==TLight[Nr].Link) // route found
         {
           Back=Ptr;
           Get_Route (X,Y,Ptr,2);
         }
       Ptr=Ptr->Next;
     }
  return Back;
}

void Get_All_Blocks (uc X,uc Y)
{
 uc Block_Count=0;
 while (TLight[Block_Count].Link<255)
   {
    Get_Block(X,Y,Block_Count);
    Block_Count++;
   }
}

void Get_All_Routes (uc X,uc Y,uc mode)
{
  if (!NRoutes[mode]) return;
  Route_Line * Ptr=Routes[mode].Start; // start with the first
  while (Ptr)
     {
       Get_Route (X,Y,Ptr,mode);
       Ptr=Ptr->Next;
     }
}


ul Calc_Route_Len (void)
{
  Route_Line * Ptr;
  ul total=0;
  for (char Count=0;Count<=2;Count++)
    if (NRoutes[Count])
      {
        Ptr=Routes[Count].Start;
        while (Ptr)
          {
            total+=(((Ptr->Num+1)*3)+2);
            Ptr=Ptr->Next;
          }
      }
  return total;
}


void DrawScreen (uc X,uc Y)
{
  char line[80];
  ul result;
  for (char Count1=0;Count1<=47;Count1++)
    for (char Count2=0;Count2<=79;Count2++)
       {
         result=Check_Column (Count2+X,Count1+Y);
         if ((result & 0x3F)==0)
           if ((result & 0xC0)==64) ScreenPutChar('',3,Count2,Count1);
             else if ((result & 0xC0)==128) ScreenPutChar('',10,Count2,Count1);
             else if ((result & 0xC0)==192) ScreenPutChar('',1,Count2,Count1);
             else ScreenPutChar('',4,Count2,Count1);
           else
            if ((result & 0xC0)!=0)
               if (Tmode==1) ScreenPutChar('',0,Count2,Count1);
                       else  ScreenPutChar('',120,Count2,Count1);
              else if ((result & 0x3F)==1) ScreenPutChar('',0,Count2,Count1);
              else if ((result & 0x3F)==2) ScreenPutChar('',0,Count2,Count1);
              else if ((result & 0x3F)==4) ScreenPutChar('',0,Count2,Count1);
              else if ((result & 0x3F)==8) ScreenPutChar('',0,Count2,Count1);
              else if ((result & 0x3F)==16) ScreenPutChar('',0,Count2,Count1);
              else if ((result & 0x3F)==32) ScreenPutChar('',0,Count2,Count1);
                else ScreenPutChar ('.',15,Count2,Count1);
         uc bit=8;
         uc light=0;
         uc gov=0;
         uc Count3;
         for (Count3=1;Count3<=6;Count3++)
           {
             if (((result >>bit) & 15)==14) light=1;
             if ((((result >>bit) & 15)==13) &&
                 (((result >>(bit-4)) &15)<13)) gov++;
             bit+=4;
           }
         if (Gmode)
           {
             if (gov==1) ScreenPutChar ('*',11,Count2,Count1);
             if (gov>1) ScreenPutChar ('*',12,Count2,Count1);

             if (((Count1+X) || (Count2+Y))!=0)
               {
                 for (Count3=0;Count3<=15;Count3+=3)
                   if ((lo[Count3]==Count2+X) && (lo[Count3+1]==Count1+Y)) ScreenPutChar('P',15,Count2,Count1);
                 for (Count3=18;Count3<=33;Count3+=3)
                   if ((lo[Count3]==Count2+X) && (lo[Count3+1]==Count1+Y)) ScreenPutChar('H',15,Count2,Count1);
                 for (Count3=72;Count3<=87;Count3+=3)
                   if ((lo[Count3]==Count2+X) && (lo[Count3+1]==Count1+Y)) ScreenPutChar('F',15,Count2,Count1);
               }
           }
         if ((Bmode==2) && (light==1)) ScreenPutChar ('T',11,Count2,Count1);
       }
}


void Cur_Status (uc X,uc Y,uc SX,uc SY,ul RouteNr,Route_Line * CurRoute)
{
  ul result;
  int GetChar;
  gotoxy(1,49);
  textcolor (11);
  if (AFmode) { textcolor (15);cprintf ("AF ");textcolor(11);}
         else cprintf ("");
  if (Gmode)  { textcolor (15);cprintf ("GOV ");textcolor(11);}
         else cprintf ("");
  if (Imode)  { textcolor (15);cprintf ("I");textcolor(11);}
         else cprintf ("");
  cprintf ("");
  textcolor (14);
  gotoxy (1,50);cprintf ("(%03d,%03d)",X,Y);
  textcolor (15);
  gotoxy (11,50);
  result=Check_Column (X,Y);
  if ((result & 0x3F)==0)
         if ((result & 0xC0)== 64) cprintf ("Water           ");
    else if ((result & 0xC0)==128) cprintf ("Field/Pavement  ");
    else if ((result & 0xC0)==192) cprintf ("Building        ");
                 else              cprintf ("Air !!!         ");
   else
     {
      if ((result & 0xC0)!=0)     cprintf ("Tunn:");
         else                     cprintf ("Road:");
      long bit=256;
      char pr2=0;
      for (char count=1;count<=6;count++)
        {
          char pr=0;
            if (((result/bit) & 0x0F)<13)
              {
                textcolor(16-count);
                if ((result/bit) & 0x01) {cprintf("%c",24);pr++;}
                if ((result/bit) & 0x02) {cprintf("%c",25);pr++;}
                if ((result/bit) & 0x04) {cprintf("%c",27);pr++;}
                if ((result/bit) & 0x08) {cprintf("%c",26);pr++;}
                if (pr<2)
                  for (char Count2=1;Count2<=(2-pr);Count2++) cprintf(" ");
                pr2+=2;
              }
            bit*=16;
        }
      for (char Count2=1;Count2<=(11-pr2);Count2++) cprintf(" ");
     }
  textcolor(15);
  if ((Rmode==1) || (Umode==1) || (Bmode==1)) // route info mode
    {
      ScreenGetChar (&GetChar,0L,X-SX,Y-SY);
      if ((GetChar==254) && (CurRoute)) // I,m on the route
       {
        uc Oldx=0,Oldy=0;
        uc Point=0;
        uc Found=255;
        uc Wait=1;
        Route_Coord * Ptr=CurRoute->Start;
        while ((Ptr!=0L) && ((Found==255) || ((Oldx==Ptr->X) && (Oldy==Ptr->Y))))
          {
            if ((X==Ptr->X) && (Y==Ptr->Y) && (Found==255)) Found=Point;
            if (((Oldx|Oldy)==0) || (Oldx!=Ptr->X) || (Oldy!=Ptr->Y)) Point++;
            if ((Found!=255) && (Oldx==Ptr->X) && (Oldy==Ptr->Y)) Wait++;
            Oldx=Ptr->X;
            Oldy=Ptr->Y;
            Ptr=Ptr->Next;
          }
        gotoxy(39,50);
        textcolor (7);
        cprintf ("Point:%03d ",Found+1);
        textcolor (10);
        if (!Bmode)
          if (Wait<10)
                cprintf ("Time:%1d",Wait);
           else cprintf ("Time:!");
       }
        else
          {
            gotoxy(39,50);
            cprintf ("                ");
          }
      if (CurRoute) // are there some routes
        {
          textcolor(12);
          gotoxy(27,50);
          cprintf ("RouteNr:%03d",RouteNr);
          gotoxy(39,50);
          textcolor(7);
          if (!CurRoute->Start) cprintf ("No Points   ");
          gotoxy (70,50);
          textcolor(15);
          if (CurRoute->Start && !Bmode &&
             (CurRoute->Start->X==CurRoute->End->X) &&
             (CurRoute->Start->Y==CurRoute->End->Y))
                  cprintf ("L");
            else  cprintf (" ");
        }
       else
        {
          if ((Bmode==1) && (TLight[0].Link!=255)) // realy no routes ??
              {
                gotoxy (27,50);
                textcolor (12);
                cprintf ("RouteNr:%03d",RouteNr);
                gotoxy (39,50);
                textcolor (7);
                cprintf ("No Points   ");
              }
           else
              {
                gotoxy(27,50);
                textcolor (12);
                cprintf ("No Routes !!");
              }
        }

    }
  for (uc Count=10;Count<=15;Count++)
    ScreenPutChar ('',25-Count,Count+52,49);
  char Gov[7];
  uc Count3;
  strcpy (Gov,"      ");
  for (Count3=0;Count3<=15;Count3+=3)
    if ((lo[Count3]==X) && (lo[Count3+1]==Y))
      {
       Gov[0]='P';
       if (Gov[1]==' ') Gov[1]=(Count3/3)+'1';
                   else Gov[1]='M';
      }
  for (Count3=0;Count3<=15;Count3+=3)
    if ((lo[Count3+18]==X) && (lo[Count3+19]==Y))
      {
       Gov[2]='H';
       if (Gov[3]==' ') Gov[3]=(Count3/3)+'1';
                   else Gov[3]='M';
      }
  for (Count3=0;Count3<=15;Count3+=3)
    if ((lo[Count3+72]==X) && (lo[Count3+73]==Y))
      {
       Gov[4]='F';
       if (Gov[5]==' ') Gov[5]=(Count3/3)+'1';
                   else Gov[5]='M';
      }
  gotoxy (56,50);
  textcolor (11);
  cprintf ("%s",Gov);
  textcolor (15);
}


ul InputValue (uc MaxChars)
{
  uc CursorX=wherex();
  uc CursorY=wherey();
  uc NumChars=0;
  int ch;
  long total=0;
  int Key=getkey();
  while (Key!=K_Return)
     {
       if ((Key >='0') && (Key <='9') && (NumChars<MaxChars))
         {
          cprintf ("%1c",Key); // print the number
          NumChars++;
          total=(total * 10) + (Key-48);
         }
       if ((Key==K_BackSpace) && (NumChars>0))
         {
          NumChars--;
          ScreenGetChar (&ch,0L,wherex()-2,wherey()-1);
          ScreenPutChar (' ',15,wherex()-2,wherey()-1);
          gotoxy (wherex()-1,wherey());
          total= (total- (ch-48))/10;
         }
       if (Key==K_Escape)
         {
           total=255;
           Key=K_Return;
           break;
         }
       Key=getkey();
     }
  return total;
}


int Cursor (char NX,char NY,char OX,char OY,int OA)
{
   int ch,attr;
   ScreenGetChar (&ch,0L,OX,OY); // get char on old position
   ScreenPutChar (ch,OA,OX,OY);  // clear cursor
   ScreenGetChar (&ch,&attr,NX,NY); // get char on new position
   ScreenPutChar (ch,31,NX,NY); // set new cursor
   return attr;
}

Route_Coord * Get_Next (uc SX,uc SY,uc DX,uc DY,Route_Line * Cur_Route,uc NoRepeat=0)
{
  uc X=SX+DX;
  uc Y=SY+DY;
  uc Oldx=0,Oldy=0;
  uc Found=0;
  Route_Coord * Ptr=Cur_Route->Start;
  while ((Ptr!=0L) && (!Found || ((Oldx==Ptr->X) && (Oldy==Ptr->Y))))
     {
       if ((X==Ptr->X) && (Y==Ptr->Y) && !Found) Found=1;
       if (Found && NoRepeat) break;
       Oldx=Ptr->X;
       Oldy=Ptr->Y;
       Ptr=Ptr->Next;
     }
  if (!Found) // can only be a roadblock sequence
     if (NoRepeat) return 0L;
              else return Cur_Route->Start;
  return Ptr;
}

void Delete_Coord (Route_Coord * Ptr,Route_Line * CurRoute) // delete all occurences of a specific point
{
  Route_Coord * NextPtr;
  if (!Ptr) return;
  uc Del_x=Ptr->X;
  uc Del_y=Ptr->Y;
  while ((Ptr) && ((Ptr->X == Del_x) && (Ptr->Y == Del_y)))
    {
      NextPtr=Ptr->Next; // keep next record (or end) at all times
      if (!Ptr->Prev)
            CurRoute->Start=Ptr->Next;
       else Ptr->Prev->Next=Ptr->Next;
      if (!Ptr->Next)
            CurRoute->End=Ptr->Prev;
       else Ptr->Next->Prev=Ptr->Prev;
      free (Ptr); // free some memory
      Ptr=NextPtr; // next record (or end)
      CurRoute->Num--; // one coordinate less
    }
}

Route_Line * New_Route (long * NewNr,uc mode)
{
  NRoutes[mode]++;  // one more route
  Route_Line *R=(Route_Line*) malloc (sizeof (Route_Line)); // reserve space for one
  if (R==0) {printf ("no memory");exit (1);}
  R->Start=0L;
  R->End=0L;
  R->Num=0;
  R->Type=254+mode; // police route
  if (Routes[mode].Start==0L) // first record routes
    {
      Routes[mode].Start=R;
      Routes[mode].End=R;
      R->Prev=0L;
      R->Next=0L;
    }
   else
    {
      Routes[mode].End->Next=R;
      R->Prev=Routes[mode].End;
      R->Next=0L;
      Routes[mode].End=R;
    }
  *NewNr=NRoutes[mode];
  return Routes[mode].End;
}

Route_Line * Delete_Route (Route_Line * Ptr,uc mode)
{
  if (!Ptr) {Do_Error("No route to delete");return 0L;}
  Route_Line * NextPtr;
  while (Ptr->Start!=0L) // continue until ALL coordinates are deleted
     Delete_Coord (Ptr->Start,Ptr); // delete first coordinate
  if (Bmode!=1); // for roadblocks,skip messing with pointers
    {
      NextPtr=Ptr->Next;
      if (!Ptr->Prev)
            Routes[mode].Start=Ptr->Next;
       else Ptr->Prev->Next=Ptr->Next;
      if (!Ptr->Next)
            Routes[mode].End=Ptr->Prev;
       else Ptr->Next->Prev=Ptr->Prev;
    }
  free (Ptr); // free up route
  if (Bmode==1) return 0L;
  Ptr=NextPtr;
  if (!Ptr)  // was it the last route
    Ptr=Routes[mode].Start; // start with the first (or maybe no routes at all)
  NRoutes[mode]--;
  return Ptr;
}

void Unlink_Route (Route_Line * CurRoute)
{
  if ((!Rmode) && (!Umode)) return;
  if (!CurRoute->Start) return;
  if (CurRoute->Start==CurRoute->End) return ; // only one point , don't unlink !!
  while ((CurRoute->Start->X==CurRoute->End->X) &&
        (CurRoute->Start->Y==CurRoute->End->Y)) // is route linked
          Delete_Coord (CurRoute->End,CurRoute); // delete endpoint
}


void Add_Coord (uc X,uc Y,uc Z,Route_Coord * Ptr,int Duration,Route_Line * CurRoute)
{ // this routine puts a coord AFTER the coord pointed to by Ptr
   Route_Coord * Backup=Ptr;
   for (uc Count=1;Count<=Duration;Count++)
     {
       Route_Coord *C=(Route_Coord*) malloc (sizeof (Route_Coord));
       if (C==0) {printf ("no memory");exit (1);}

       if (!Backup) // start of line ?
             {
               if (!CurRoute->Start)  // start AND end of line ?
                     {
                       CurRoute->End=C;
                       C->Next=0L;
                     }
                else
                     {
                       CurRoute->Start->Prev=C;
                       C->Next=CurRoute->Start;
                     }
               CurRoute->Start=C;
               C->Prev=0L;
             }
        else
             {
               if (!Backup->Next) // end of line ?
                     {
                       CurRoute->End=C;
                       C->Next=0L;
                     }
                else
                     {
                       Backup->Next->Prev=C;
                       C->Next=Backup->Next;
                     }
               Backup->Next=C;
               C->Prev=Backup;
             }
       C->X=X;C->Y=Y;C->Z=Z;
     }
   CurRoute->Num+=Duration; // add a number of coordinates
}

void Add_Point (uc X,uc Y,uc SX,uc SY,Route_Coord * Address,Route_Line * CurRoute)

{
           gettext (1,50,80,50,Line_Contents); // retrieve last line
           _setcursortype(_NORMALCURSOR);
           char String[16];
           char Str2[3];
           ui Duration=0;
           if (Bmode==1) Duration=1;
           while ((Duration<1 || Duration >9) && (Duration!=255))
             {
               gotoxy (1,50);cprintf("Please input duration (1-9) :                                                ");
               gotoxy (30,50);
               Duration=InputValue (3);
             }
           uc Level=0;
           if (Duration!=255)
             {
               ul bit=256;
               ul result=Check_Column (X,Y);
               strcpy (Str2,"1 ");
               strcpy (String," ");
               uc Count2=0;
               for (char Count=1;Count<=6;Count++)
                 {
                  if (((result/bit) & 0x0F)<13)
                    {
                      Str2[0]=Count+48;
                      Count2++;
                      strcat (String,Str2);
                      if (!Level) Level=Count;
                    }
                  bit*=16;
                 }
               char Chosen=0;
               if (Count2>1)
                  {
                   while (!Chosen)
                     {
                       gotoxy (1,50);cprintf("Please Select roadlevel (%s):",String);
                       Level=InputValue(1);
                       if (Level==255) break;
                       if ((Level>=1) && (Level<=6) &&
                         (((result >> ((Level+1)*4)) &0x0F) !=15)) Chosen=1;
                     }
                  }
               if (Level!=255) Level=6-Level;
             }
           puttext (1,50,80,50,Line_Contents);
           _setcursortype(_NOCURSOR);
           if ((Level!=255) && (Duration!=255))
             {
               Add_Coord (X,Y,Level,Address,Duration,CurRoute);
               ScreenPutChar ('',31,SX,SY);
               Old_Col=10+Level;
             }
         }

void Goto_Cursor (uc * DX,uc * DY,uc X,uc Y,uc OX,uc OY,int * OC,
                  Route_Line * CR,uc NR=0)
{
  uc Scr_x,Scr_y;
  if ((X<*DX) || (X>*DX+79) ||  // coordinate is on not screen
      (Y<*DY) || (Y>*DY+47))
        {
          if (X>(255-40)) *DX=255-79; // extreme right
           else if (X<40) *DX=0;   // extreme left
                  else *DX=X-40;   // center point
          if (Y>(255-23)) *DY=255-47; // extreme bottom
           else if (Y<23) *DY=0;   // extreme top
                  else *DY=Y-23;
          DrawScreen (*DX,*DY);
          if (Rmode==1) Get_Route(*DX,*DY,CR,1);
          if (Umode==1) Get_Route(*DX,*DY,CR,0);
          if (Bmode==1) Get_Block(*DX,*DY,NR);
          Scr_x=X-*DX;
          Scr_y=Y-*DY;
          int col;
          ScreenGetChar (0L,&col,Scr_x,Scr_y);
          *OC=col;
          ScreenPutChar ('',31,Scr_x,Scr_y); // activate cursor
        }
      else
          {
            Scr_x=X-*DX;
            Scr_y=Y-*DY;
            *OC=Cursor (Scr_x,Scr_y,OX,OY,*OC);
          }
}

void Save_Routes (void)
{
  Route_Line * Ptr;
  Route_Coord * Ptr2;
  char ch;
  for (char Count=0;Count<=2;Count++)
    {
      {
        Ptr=Routes[Count].Start;
        while (Ptr) // There is a route
          {
            ch=Ptr->Num+1;
            CityFile.write ((char *)(&ch),sizeof (ch));
            CityFile.write ((char *)(&Ptr->Type),sizeof (Ptr->Type));
            CityBack.write ((char *)(&ch),sizeof (ch));
            CityBack.write ((char *)(&Ptr->Type),sizeof (Ptr->Type));
            Ptr2=Ptr->Start;
            while (Ptr2) // There is a coordinate
              {
                CityFile.write ((char *)(&Ptr2->X),sizeof (Ptr2->X));
                CityFile.write ((char *)(&Ptr2->Y),sizeof (Ptr2->Y));
                CityFile.write ((char *)(&Ptr2->Z),sizeof (Ptr2->Z));
                CityBack.write ((char *)(&Ptr2->X),sizeof (Ptr2->X));
                CityBack.write ((char *)(&Ptr2->Y),sizeof (Ptr2->Y));
                CityBack.write ((char *)(&Ptr2->Z),sizeof (Ptr2->Z));
                Ptr2=Ptr2->Next;
              }
            ch=0;
            if (Ptr->Type>253)
              {
                CityFile.write ((char *)(&ch),sizeof (ch)); // write zero end
                CityFile.write ((char *)(&ch),sizeof (ch));
                CityFile.write ((char *)(&ch),sizeof (ch));
                CityBack.write ((char *)(&ch),sizeof (ch)); // write zero end
                CityBack.write ((char *)(&ch),sizeof (ch));
                CityBack.write ((char *)(&ch),sizeof (ch));
              }
            Ptr=Ptr->Next;
          }
      }
    }
}

void Save_Field (void)
{
  char ch;
  ul n;
  vectors[2]=Calc_Route_Len(); // calculate length of COMPLETE route-plan
  for (char Count=0;Count<=6;Count++) // write 7 'vectors'
    CityFile.write ((char *)(&vectors[Count]),sizeof (vectors[Count]));

  CityBack.write ((char *)(&vectors[2]),sizeof (vectors[2]));
  CityBack.write ((char *)(&vectors[3]),sizeof (vectors[3]));

  n=0;
  for (long Count=1;Count <=0x40000;Count ++) // write citygrid
     {
       ch=gr[n];
       CityFile.write ((char *)(&ch),sizeof (ch)); // write it to file
       n++;
     }
  if (vectors[4])
    {
      n=0;
      for (long Count=1;Count <=vectors[4];Count++) // column data
        {
          ch=col[n];
          CityFile.write ((char *)(&ch),sizeof (ch));
          n++;
        }
    }
  if (vectors[5])
    {
      n=0;
      for (long Count=1;Count <=vectors[5];Count++) // block data
        {
          ch=bl[n];
          CityFile.write ((char *)(&ch),sizeof (ch));
          n++;
        }
    }
  if (vectors[3])
    {
      n=0;
      for (long Count=1;Count <=vectors[3];Count++)
        {
          ch=po[n];
          CityFile.write ((char *)(&ch),sizeof (ch));
          CityBack.write ((char *)(&ch),sizeof (ch)); // hold backup
          n++;
        }
    }
  Save_Routes(); // fairly complicated
  n=0;
  for (long Count=1;Count <=108;Count++) // save goverment locations
     {
       ch=lo[n];
       CityFile.write ((char *)(&ch),sizeof (ch));
       n++;
     }
  if (vectors[6])
    {
      n=0;
      for (long Count=1;Count <=vectors[6];Count++) // save navigational data
        {
          ch=na[n];
          CityFile.write ((char *)(&ch),sizeof (ch));
          n++;
        }
    }
  CityFile.close();
}


uc Get_Road_Level (uc X,uc Y)
{
  ul bit=256;
  uc TL=0;
  ul result=Check_Column (X,Y);
  uc Level=254;
  uc Count2=0;
  for (char Count=1;Count<=6;Count++)
    {
      if (((result/bit) & 0x0F)<13)
         {
           Count2++;
           if (Level==254) Level=Count;
         }
      if (((result/bit) & 0x0F)==14) TL=1;
      bit*=16;
    }
  char Chosen=0;
  if (Count2>1) {Do_Error ("No traffic-lights around viaduct");return 255;}   // error multiroad
  if (!Count2) return 252;
  if (!TL) return 251;
  return 6-Level;
}


uc Delete_Light (uc X,uc Y)
{
  uc Found=0;
  uc Cur_Light=0;
  ul X1,Y1;
  while (TLight[Cur_Light].Link!=255) // repeat until last light
    {
      X1=Read_Array (2,TLight[Cur_Light].Address-8,po);
      Y1=Read_Array (2,TLight[Cur_Light].Address-6,po);
      if (X1>=(X*64) && X1<=((X*64)+63) &&
          Y1>=(Y*64) && Y1<=((Y*64)+63)) {Found=1;break;}
      Cur_Light++;
    }
  if (!Found) return 0; // nothing deleted, just add a light
  if (TLight[Cur_Light].Link!=254) {Do_Error("Unable to delete used light");return 2;} // don't add a light
  long Source=TLight[Cur_Light].Address+6; // source of copy
  long Num=vectors[3]-Source;
  if (!Num)
    {
      TLight[Cur_Light].Link=255;
      TLight[Cur_Light].Address=0;
    }
   else
    {
      long Dest=TLight[Cur_Light].Address-8; // destination of copy
      memcpy (po+Dest,po+Source,Num);
      for (uc Count=0;Count <=253;Count++)
        if (TLight[Count].Address >Dest) TLight[Count].Address-=14;
      for (uc Count=Cur_Light;Count<TLights;Count++)
        {
          TLight[Count].Address=TLight[Count+1].Address;
          TLight[Count].Link=TLight[Count+1].Link;
        }
    }
  TLights--;
  vectors[3]-=14; // one object less
  return 1;
}

void main (int argc, char * argv[])
{
   argc--;
   argv++;
   if (!argv[0]) {
                   cprintf("Please enter a map-file as parameter !!!\n\r");
                   exit (1);
                 }
   int ch,attr;
   ul n;
   _set_screen_lines(50);
   strcpy (BackupFile,argv[0]); // copy filename
   char * index=strchr (BackupFile,'\\');
   char * index2=0L;
     while (index) // as long as I keep finding these things
       {
         index2=index; // don't forget
         index=strchr(index+1,'\\'); // search again
       }
   if (index2) index=strchr (index2+1,'.'); // find a point from the last backslash
         else index=strchr (BackupFile,'.'); // find it from the start
   if (!index) strcat (BackupFile,".cmb"); // add extension
         else strcpy (index,".cmb"); // replace extension
   _setcursortype(_NOCURSOR);
   intensevideo();
   Line_Contents=(char*) malloc (50*160); // reserve memory for keeping bottomline
   n=1;
   Route_Coord * Ipoint;
   CityFile.open (argv[0],ios::in|ios::nocreate|ios::binary);
   if (!CityFile) {printf ("unable to open");exit(1);}
   clrscr();
   GetVectors ();   // get the length of the various blocks a the start
   gr=Read_Grid();
   col=Read_Column();
   bl=Read_Block();
   po=Read_Position();
   ro=Read_Routes();
   lo=Read_Locations();
   na=Read_Navigation();
   Route_Line * Cur_R_Back=0L;
   Route_Line * Cur_U_Back=0L;
   Route_Line * Cur_B_Back=0L;
   Route_Line * Cur_Route;
   CityFile.close ();
   if ((vectors[2] | vectors[3])==0) // both routes and objects are empty
     {
       CityFile.open (BackupFile,ios::in|ios::nocreate|ios::binary);
       if (CityFile)
         {
           cprintf ("The route and roadblock information of this file is clean\n\r");
           cprintf ("Would you like to load this from the backup-file (Y/N)");
           char answer=' ';
           while (!strchr ("YyNn",answer))
             answer=getkey();
           if (strchr ("Yy",answer))
             {
               CityFile.read ((char *)(&vectors[2]),sizeof (vectors[2])); // Route size
               CityFile.read ((char *)(&vectors[3]),sizeof (vectors[3])); // Position size
               po=Read_Position();
               ro=Read_Routes();
             }
         CityFile.close();
         }
     }
   signed long Cur_Nr=1;
   ul Cur_RNr=0; // prepared for the worse
   ul Cur_BNr=0;
   ul Cur_UNr=0;
   uc Draw_x=0;
   uc Draw_y=0;
   uc Scr_x=0;
   uc Scr_y=0;
   uc Old_x;
   uc Old_y;
   textcolor(15);
   gotoxy(70,50);cprintf(" Normal ");
   textcolor(3);
   cprintf ("T0");
   DrawScreen (Draw_x,Draw_y);
   ScreenGetChar (&ch,&attr,0,0); // get left upper corner character
   Old_Col=attr;
   ScreenPutChar (ch,31,0,0); // activate cursor
   char end=0;
   int input;
   while (end==0)
     {
       Cur_Status(Draw_x+Scr_x,Draw_y+Scr_y,Draw_x,Draw_y,Cur_Nr,Cur_Route);
       if (!Follow) input=getxkey();
              else input=0;

       Old_x=Scr_x;
       Old_y=Scr_y;
       if ((input==K_ERight) && (Scr_x<79))
         {
           Scr_x++;
           Old_Col=Cursor (Scr_x,Scr_y,Old_x,Old_y,Old_Col);
         }
       if ((input==K_ELeft) && (Scr_x>0))
         {
           Scr_x--;
           Old_Col=Cursor (Scr_x,Scr_y,Old_x,Old_y,Old_Col);
         }
       if ((input==K_EUp) && (Scr_y>0))
         {
           Scr_y--;
           Old_Col=Cursor (Scr_x,Scr_y,Old_x,Old_y,Old_Col);
         }
       if ((input==K_EDown) && (Scr_y<47))
         {
           Scr_y++;
           Old_Col=Cursor (Scr_x,Scr_y,Old_x,Old_y,Old_Col);
         }
       if (input==K_Control_ERight)
         {
           if (Draw_x<(255-158)) Draw_x+=80; else Draw_x=255-79;
           DrawScreen (Draw_x,Draw_y);
           if (Rmode==1) Get_Route(Draw_x,Draw_y,Cur_Route,1);
           if (Rmode==2) Get_All_Routes (Draw_x,Draw_y,1);
           if (Umode==1) Get_Route(Draw_x,Draw_y,Cur_Route,0);
           if (Umode==2) Get_All_Routes (Draw_x,Draw_y,0);
           if (Bmode==1) Cur_Route=Get_Block (Draw_x,Draw_y,Cur_Nr);
           if (Bmode==2) Get_All_Blocks (Draw_x,Draw_y);
           ScreenGetChar (&ch,&attr,Scr_x,Scr_y); // get left upper corner character
           Old_Col=attr;
           ScreenPutChar (ch,31,Scr_x,Scr_y); // activate cursor
         }
       if (input==K_Control_ELeft)
         {
           if (Draw_x>79) Draw_x-=80; else Draw_x=0;
           DrawScreen (Draw_x,Draw_y);
           if (Rmode==1) Get_Route(Draw_x,Draw_y,Cur_Route,1);
           if (Rmode==2) Get_All_Routes (Draw_x,Draw_y,1);
           if (Umode==1) Get_Route(Draw_x,Draw_y,Cur_Route,0);
           if (Umode==2) Get_All_Routes (Draw_x,Draw_y,0);
           if (Bmode==1) Cur_Route=Get_Block (Draw_x,Draw_y,Cur_Nr);
           if (Bmode==2) Get_All_Blocks (Draw_x,Draw_y);
           ScreenGetChar (&ch,&attr,Scr_x,Scr_y); // get left upper corner character
           Old_Col=attr;
           ScreenPutChar (ch,31,Scr_x,Scr_y); // activate cursor
         }
       if (input==K_Control_EUp)
         {
           if (Draw_y>46) Draw_y-=47; else Draw_y=0;
           DrawScreen (Draw_x,Draw_y);
           if (Rmode==1) Get_Route(Draw_x,Draw_y,Cur_Route,1);
           if (Rmode==2) Get_All_Routes (Draw_x,Draw_y,1);
           if (Umode==1) Get_Route(Draw_x,Draw_y,Cur_Route,0);
           if (Umode==2) Get_All_Routes (Draw_x,Draw_y,0);
           if (Bmode==1) Cur_Route=Get_Block (Draw_x,Draw_y,Cur_Nr);
           if (Bmode==2) Get_All_Blocks (Draw_x,Draw_y);
           ScreenGetChar (&ch,&attr,Scr_x,Scr_y); // get left upper corner character
           Old_Col=attr;
           ScreenPutChar (ch,31,Scr_x,Scr_y); // activate cursor
         }
       if (input==K_Control_EDown)
         {
           if (Draw_y<(255-92)) Draw_y+=47; else Draw_y=255-47;
           DrawScreen (Draw_x,Draw_y);
           if (Rmode==1) Get_Route(Draw_x,Draw_y,Cur_Route,1);
           if (Rmode==2) Get_All_Routes (Draw_x,Draw_y,1);
           if (Umode==1) Get_Route(Draw_x,Draw_y,Cur_Route,0);
           if (Umode==2) Get_All_Routes (Draw_x,Draw_y,0);
           if (Bmode==1) Cur_Route=Get_Block (Draw_x,Draw_y,Cur_Nr);
           if (Bmode==2) Get_All_Blocks (Draw_x,Draw_y);
           ScreenGetChar (&ch,&attr,Scr_x,Scr_y); // get left upper corner character
           Old_Col=attr;
           ScreenPutChar (ch,31,Scr_x,Scr_y); // activate cursor
         }
       if (input==K_Alt_ERight)
         {
           if (Draw_x<(255-118)) Draw_x+=40; else Draw_x=255-79;
           DrawScreen (Draw_x,Draw_y);
           if (Rmode==1) Get_Route(Draw_x,Draw_y,Cur_Route,1);
           if (Rmode==2) Get_All_Routes (Draw_x,Draw_y,1);
           if (Umode==1) Get_Route(Draw_x,Draw_y,Cur_Route,0);
           if (Umode==2) Get_All_Routes (Draw_x,Draw_y,0);
           if (Bmode==1) Cur_Route=Get_Block (Draw_x,Draw_y,Cur_Nr);
           if (Bmode==2) Get_All_Blocks (Draw_x,Draw_y);
           ScreenGetChar (&ch,&attr,Scr_x,Scr_y); // get left upper corner character
           Old_Col=attr;
           ScreenPutChar (ch,31,Scr_x,Scr_y); // activate cursor
         }
       if (input==K_Alt_ELeft)
         {
           if (Draw_x>39) Draw_x-=40; else Draw_x=0;
           DrawScreen (Draw_x,Draw_y);
           if (Rmode==1) Get_Route(Draw_x,Draw_y,Cur_Route,1);
           if (Rmode==2) Get_All_Routes (Draw_x,Draw_y,1);
           if (Umode==1) Get_Route(Draw_x,Draw_y,Cur_Route,0);
           if (Umode==2) Get_All_Routes (Draw_x,Draw_y,0);
           if (Bmode==1) Cur_Route=Get_Block (Draw_x,Draw_y,Cur_Nr);
           if (Bmode==2) Get_All_Blocks (Draw_x,Draw_y);
           ScreenGetChar (&ch,&attr,Scr_x,Scr_y); // get left upper corner character
           Old_Col=attr;
           ScreenPutChar (ch,31,Scr_x,Scr_y); // activate cursor
         }
       if (input==K_Alt_EUp)
         {
           if (Draw_y>23) Draw_y-=24; else Draw_y=0;
           DrawScreen (Draw_x,Draw_y);
           if (Rmode==1) Get_Route(Draw_x,Draw_y,Cur_Route,1);
           if (Rmode==2) Get_All_Routes (Draw_x,Draw_y,1);
           if (Umode==1) Get_Route(Draw_x,Draw_y,Cur_Route,0);
           if (Umode==2) Get_All_Routes (Draw_x,Draw_y,0);
           if (Bmode==1) Cur_Route=Get_Block (Draw_x,Draw_y,Cur_Nr);
           if (Bmode==2) Get_All_Blocks (Draw_x,Draw_y);
           ScreenGetChar (&ch,&attr,Scr_x,Scr_y); // get left upper corner character
           Old_Col=attr;
           ScreenPutChar (ch,31,Scr_x,Scr_y); // activate cursor
         }
       if (input==K_Alt_EDown)
         {
           if (Draw_y<(255-69)) Draw_y+=24; else Draw_y=255-47;
           DrawScreen (Draw_x,Draw_y);
           if (Rmode==1) Get_Route(Draw_x,Draw_y,Cur_Route,1);
           if (Rmode==2) Get_All_Routes (Draw_x,Draw_y,1);
           if (Umode==1) Get_Route(Draw_x,Draw_y,Cur_Route,0);
           if (Umode==2) Get_All_Routes (Draw_x,Draw_y,0);
           if (Bmode==1) Cur_Route=Get_Block (Draw_x,Draw_y,Cur_Nr);
           if (Bmode==2) Get_All_Blocks (Draw_x,Draw_y);
           ScreenGetChar (&ch,&attr,Scr_x,Scr_y); // get left upper corner character
           Old_Col=attr;
           ScreenPutChar (ch,31,Scr_x,Scr_y); // activate cursor
         }
       if ((input=='r') || (input=='R'))  // enter route info
         {
           if (Rmode==2)
               {
                 gotoxy(70,50);cprintf(" Normal");
                 gotoxy(27,50);cprintf("                             ");
                 Cur_R_Back=Cur_Route;
                 Cur_Nr=Cur_RNr;
                 DrawScreen (Draw_x,Draw_y);
                 ScreenGetChar (&ch,&attr,Scr_x,Scr_y);
                 Old_Col=attr;
                 Mode=0;
                 Rmode=0;
               }
            else if (Rmode==0)
               {
                 gotoxy(70,50);cprintf(" Route ");
                 if (Cur_R_Back) Cur_Route=Cur_R_Back;
                            else Cur_Route=Routes[1].Start;
                 if (Cur_RNr)    Cur_Nr=Cur_RNr;
                            else Cur_Nr=1;
                 DrawScreen (Draw_x,Draw_y);
                 Get_Route(Draw_x,Draw_y,Cur_Route,1);
                 ScreenGetChar (&ch,&attr,Scr_x,Scr_y); // get char under cursor
                 Old_Col=attr;
                 Umode=0;
                 Mode=2;
                 Rmode=1;
                 Bmode=0;
                 if (AFmode) Follow=1;
               }
           else
               {
                 gotoxy(70,50);cprintf(" R All ");
                 gotoxy(27,50);cprintf("                             ");
                 Get_All_Routes (Draw_x,Draw_y,0);
                 ScreenGetChar (&ch,&attr,Scr_x,Scr_y);
                 if (ch==254) Old_Col=attr;
                 Mode=2;
                 Rmode=2;
               }
           Cursor(Scr_x,Scr_y,Scr_x,Scr_y,Old_Col);
         }
       if ((input=='u') || (input=='U'))  // enter route info
         {
           if (Umode==2)
               {
                 gotoxy(70,50);cprintf(" Normal");
                 gotoxy(27,50);cprintf("                             ");
                 Cur_U_Back=Cur_Route;
                 Cur_UNr=Cur_Nr;
                 DrawScreen (Draw_x,Draw_y);
                 ScreenGetChar (&ch,&attr,Scr_x,Scr_y);
                 Old_Col=attr;
                 Mode=0;
                 Rmode=0;
                 Umode=0;
               }
            else if (Umode==0)
               {
                 gotoxy(70,50);cprintf(" URoute");
                 if (Cur_U_Back) Cur_Route=Cur_U_Back;
                            else Cur_Route=Routes[0].Start;
                 if (Cur_UNr)    Cur_Nr=Cur_UNr;
                            else Cur_Nr=1;
                 DrawScreen(Draw_x,Draw_y);
                 Get_Route(Draw_x,Draw_y,Cur_Route,0);
                 ScreenGetChar (&ch,&attr,Scr_x,Scr_y); // get char under cursor
                 Old_Col=attr;
                 Mode=1;
                 Rmode=0;
                 Umode=1;
                 Bmode=0;
                 if (AFmode) Follow=1;
               }
           else
               {
                 gotoxy(70,50);cprintf(" U All ");
                 gotoxy(27,50);cprintf("                             ");
                 Get_All_Routes (Draw_x,Draw_y,0);
                 ScreenGetChar (&ch,&attr,Scr_x,Scr_y);
                 if (ch==254) Old_Col=attr;
                 Mode=1;
                 Umode=2;
               }
           Cursor(Scr_x,Scr_y,Scr_x,Scr_y,Old_Col);
         }



       if ((input=='b') || (input=='B'))  // enter route info
         {
           if (Bmode==2)
               {
                 gotoxy(70,50);cprintf("Normal");
                 gotoxy(27,50);cprintf("                             ");
                 Cur_UNr=Cur_Nr;
                 Bmode=0;
                 DrawScreen (Draw_x,Draw_y);
                 ScreenGetChar (&ch,&attr,Scr_x,Scr_y);
                 Old_Col=attr;
                 Mode=0;
                 Rmode=0;
                 Umode=0;
               }
            else if (Bmode==0)
               {
                 gotoxy(70,50);cprintf(" Block ");
                 Bmode=1;
                 if (Cur_BNr)    Cur_Nr=Cur_BNr;
                            else Cur_Nr=0;
                 DrawScreen(Draw_x,Draw_y);
                 Cur_Route=Get_Block(Draw_x,Draw_y,Cur_Nr);
                 ScreenGetChar (&ch,&attr,Scr_x,Scr_y); // get char under cursor
                 Old_Col=attr;
                 Mode=3;
                 Rmode=0;
                 Umode=0;
                 Bmode=1;
                 if (AFmode) Follow=1;
               }
            else
               {
                 gotoxy(70,50);cprintf(" B All ");
                 gotoxy(27,50);cprintf("                             ");
                 Bmode=2;
                 DrawScreen (Draw_x,Draw_y);
                 Get_All_Blocks (Draw_x,Draw_y);
                 ScreenGetChar (&ch,&attr,Scr_x,Scr_y);
                 Old_Col=attr;
                 Mode=3;
               }
           Cursor(Scr_x,Scr_y,Scr_x,Scr_y,Old_Col);
         }
       if ((input=='t') || (input=='T')) // train mode
         {
           Tmode= (Tmode+1) % 3;
           DrawScreen (Draw_x,Draw_y);
           if (Rmode==1) Get_Route(Draw_x,Draw_y,Cur_Route,1);
           ScreenGetChar (&ch,&attr,Scr_x,Scr_y); // get left upper corner character
           Old_Col=attr;
           ScreenPutChar (ch,31,Scr_x,Scr_y); // activate cursor
           gotoxy(78,50);
           textcolor (3);
           cprintf ("T%1d",Tmode);
           textcolor(15);
         }
       if (((input=='d') || (input=='D')) && ((Bmode|Rmode|Umode)==1))
         {
           ScreenGetChar (&ch,&attr,Scr_x,Scr_y);
           if (ch==254)
             {
               Route_Coord * Ptr=Get_Next(Scr_x,Scr_y,Draw_x,Draw_y,Cur_Route,1); 
               Delete_Coord (Ptr,Cur_Route);
               DrawScreen (Draw_x,Draw_y);
               if (Bmode) Get_Block (Draw_x,Draw_y,Cur_Nr);
                     else Get_Route(Draw_x,Draw_y,Cur_Route,Mode-1);
               ScreenGetChar (&ch,&attr,Scr_x,Scr_y); // get left upper corner character
               Old_Col=attr;
               ScreenPutChar (ch,31,Scr_x,Scr_y); // activate cursor
             }

         }
       if ((input=='a') || (input=='A'))
        {
         if (((Rmode==1) || (Umode==1)) && Cur_Route)
            {
             if (!Imode)
                  {
                   Unlink_Route (Cur_Route); // make shure it's not a circle
                   Add_Point (Draw_x+Scr_x,Draw_y+Scr_y,Scr_x,Scr_y,Cur_Route->End,Cur_Route);
                  }
              else Add_Point (Draw_x+Scr_x,Draw_y+Scr_y,Scr_x,Scr_y,Ipoint,Cur_Route);
             Imode=0;
            }
          if (Bmode==1)
            {
              uc Check=255;
              if (TLight[Cur_Nr].Link==254) // unused traffic-light
                {
                  for (uc Count=0;Count<=253;Count++)
                    {
                      for (uc Count1=0;Count1<=253;Count1++)
                        {
                          if (TLight[Count1].Link==Count) break;
                          if (TLight[Count1].Link==255)
                             {
                               Check=Count; // found a spot
                               break;
                             }
                        }
                      if (Check!=255) break; // found a value
                    }
                  if (Check!=255) // time to create a new route
                     {
                       Route_Line *R=(Route_Line*) malloc (sizeof (Route_Line)); // reserve space for one
                       if (R==0) {printf ("no memory");exit (1);}
                       R->Start=0L;
                       R->End=0L;
                       R->Type=Check;
                       NRoutes[2]++; // keep number of routes
                       if (Routes[2].Start==0L) // first record routes
                          {
                            Routes[2].Start=R;
                            Routes[2].End=R;
                            R->Prev=0L;
                            R->Next=0L;
                          }
                         else
                          {
                            Routes[2].End->Next=R;
                            R->Prev=Routes[2].End;
                            R->Next=0L;
                            Routes[2].End=R;
                          }
                       TLight[Cur_Nr].Link=Check;
                       po[TLight[Cur_Nr].Address]=Check;
                       Cur_Route=R;
                       Add_Point (Draw_x+Scr_x,Draw_y+Scr_y,Scr_x,Scr_y,Cur_Route->End,Cur_Route);
                       R->Num=0; // Make sure Num = Number of points-1
                     }
                   else ; // trouble
                }
               else // used traffic light
                  Add_Point (Draw_x+Scr_x,Draw_y+Scr_y,Scr_x,Scr_y,Cur_Route->End,Cur_Route);
            }
        }
       if ((input=='i') || (input=='I'))
         {
           if (Bmode==0)
             {
               ScreenGetChar (&ch,&attr,Scr_x,Scr_y);
               if (ch==254)
                 {
                   Ipoint=Get_Next(Scr_x,Scr_y,Draw_x,Draw_y,Cur_Route);
                   if (Ipoint!=0L)
                     {
                       Ipoint=Ipoint->Prev;
                       Imode=1;
                     }
                 }
               else Do_Error ("Please place the cursor on route-point","before activating insert mode !!");
             }
         }
       if (((input=='e') || (input=='E')) && ((Umode|Rmode)==1) && (Bmode==0))
         {
           ScreenGetChar (&ch,&attr,Scr_x,Scr_y);
           if (ch==254) // route point
             {
               gettext (1,50,80,50,Line_Contents); // retrieve last line
               _setcursortype(_NORMALCURSOR);
               ui Duration=0;
               while (((Duration<1) || (Duration >9)) && (Duration!=255))
                 {
                   gotoxy (1,50);cprintf("Please input duration (1-255) :                                                ");
                   gotoxy (32,50);
                   Duration=InputValue(1);
                 }
               puttext (1,50,80,50,Line_Contents);
               _setcursortype(_NOCURSOR);
               if (Duration!=255)
                 {
                   Route_Coord * Ptr=Get_Next(Scr_x,Scr_y,Draw_x,Draw_y,Cur_Route,1); // get FIRST matching coordinate
                   uc CoordZ=Ptr->Z;
                   Route_Coord * Ptr2=Ptr->Prev;
                   Delete_Coord (Ptr,Cur_Route); // Delete the coordinate
                   Add_Coord (Draw_x+Scr_x,Draw_y+Scr_y,CoordZ,Ptr2,Duration,Cur_Route); // add coordinate after Prev.
                 }
             }
         }

       if ((input=='f') || (input=='F') || (Follow))
         {
           if ((Rmode==1) || (Umode))
              {
               if ((Cur_Route) && (Cur_Route->Start))
                 {
                   ScreenGetChar (&ch,&attr,Scr_x,Scr_y);
                   if ((ch==254) && (!Follow))
                     {
                       Route_Coord * Ptr=Get_Next(Scr_x,Scr_y,Draw_x,Draw_y,Cur_Route);
                       if (Ptr!=0) // new coordinate found
                         {
                           Goto_Cursor (&Draw_x,&Draw_y,Ptr->X,Ptr->Y,Old_x,Old_y,&Old_Col,Cur_Route,Cur_Nr);
                           Scr_x=Ptr->X-Draw_x;
                           Scr_y=Ptr->Y-Draw_y;
                         }
                        else
                         {
                           Goto_Cursor (&Draw_x,&Draw_y,Cur_Route->Start->X,Cur_Route->Start->Y,Old_x,Old_y,&Old_Col,Cur_Route,Cur_Nr);
                           Scr_x=Cur_Route->Start->X-Draw_x;
                           Scr_y=Cur_Route->Start->Y-Draw_y;
                         }
                     }
                    else
                       if (Cur_Route->Start)
                         {
                           Goto_Cursor (&Draw_x,&Draw_y,Cur_Route->Start->X,Cur_Route->Start->Y,Old_x,Old_y,&Old_Col,Cur_Route,Cur_Nr);
                           Scr_x=Cur_Route->Start->X-Draw_x;
                           Scr_y=Cur_Route->Start->Y-Draw_y;
                         }
                 }
              }
           if ((Bmode==1) && TLights)
             {
               ul RX=Read_Array(2,TLight[(uc)Cur_Nr].Address-8,po)/64;
               ul RY=Read_Array(2,TLight[(uc)Cur_Nr].Address-6,po)/64;
               ScreenGetChar (&ch,&attr,Scr_x,Scr_y);
               if ((ch==254) && (!Follow))
                 {
                   if (Cur_Route)
                     {
                       Route_Coord * Ptr=Get_Next (Scr_x,Scr_y,Draw_x,Draw_y,Cur_Route);
                       if (Ptr!=0)
                         {
                           Goto_Cursor (&Draw_x,&Draw_y,Ptr->X,Ptr->Y,Old_x,Old_y,&Old_Col,Cur_Route,Cur_Nr);
                           Scr_x=Ptr->X-Draw_x;
                           Scr_y=Ptr->Y-Draw_y;
                         }
                        else
                         {
                           Goto_Cursor (&Draw_x,&Draw_y,RX,RY,Old_x,Old_y,&Old_Col,Cur_Route,Cur_Nr);
                           Scr_x=RX-Draw_x;
                           Scr_y=RY-Draw_y;
                         }
                     }
                 }
                else
                  {
                    Goto_Cursor (&Draw_x,&Draw_y,RX,RY,Old_x,Old_y,&Old_Col,Cur_Route,Cur_Nr);
                    Scr_x=RX-Draw_x;
                    Scr_y=RY-Draw_y;
                  }
             }
           Follow=0;
         }
       if ((input=='g') || (input=='G'))
        if (Gmode)
         {
           gettext (1,50,80,50,Line_Contents); // retrieve last line
           _setcursortype(_NORMALCURSOR);
           uc Type=0;
           while ((Type<1 || Type>3) && (Type!=255))
             {
              gotoxy(1,50);
              cprintf ("Please Select Facility (1=Police-Station 2=Fire-Station 3=Hospital):           ");
              gotoxy(69,50);
              Type=InputValue (1);
             }
           if (Type!=255)
             {
               uc bit=12;
               uc gov=0;
               uc Level=0;
               uc Count3;
               ul result=Check_Column(Scr_x+Draw_x,Scr_y+Draw_y);
               for (Count3=2;Count3<=6;Count3++)
                  {
                    if ((((result >>bit) & 15)==13) &&
                        (((result >>(bit-4)) &15)<13)) {gov++;Level=Count3-1;}

                    bit+=4;
                  }
               if ((gov>=1) || (Type==2))
                  {
                    uc Num=0;
                    while ((Num<1 || Num>6) && (Num!=255))
                      {
                        gotoxy(1,50);
                        cprintf ("Please Select Number (1-6):                                                    ");
                        gotoxy(28,50);
                        Num=InputValue(1);
                      }
                    if (Num!=255)
                      {
                        bit=8;
                        uc Roads=0;
                        if (Type==2) // check roadlevels
                         {
                          Level=0;
                          for (Count3=1;Count3<=6;Count3++)
                            {
                              if (((result >>bit) & 15)<13) {Roads++;Level=Count3;}
                              bit+=4;
                            }
                          if (Roads>1) Level=0;
                          if (Roads==0) {Level=255;Do_Error ("No Road defined for Fire-station !");}
                         }
                        if (gov>1) Level=0; // reset level (multiple changes)
                        while ((Level<1 || Level>6) && (Level!=255))
                          {
                            gotoxy(1,50);
                            cprintf ("Please Select Level (1-6):                                                     ");
                            gotoxy(27,50);
                            Level=InputValue(1);
                            if (Level!=255)
                              if ((Type!=2) && (Level==6)) {Level=0;Do_Error ("Hospital or Police-station can't be","placed at top level !           ");}
                                else if ((Type!=2) && (((result >> ((Level*4)+8)) & 15)!=13)) {Level=0;Do_Error ("Invalid level for hospital or","Police-station.","No direction above building !");}
                                  else if ((Type!=2) && (((result >> ((Level*4)+4)) & 15)>12)) {Level=0;Do_Error ("Invalid level for hospital or","Police-station.","No read defined for vehicle !");}
                          }
                        if (Level!=255)
                          {
                            uc Pos;
                            if (Type==1) Pos=0;
                            if (Type==2) Pos=72;
                            if (Type==3) Pos=18;
                            Pos+=(Num-1)*3;
                            lo[Pos++]=Scr_x+Draw_x;
                            lo[Pos++]=Scr_y+Draw_y;
                            lo[Pos]=6-Level;
                          }
                      }
                  }
             }
           puttext (1,50,80,50,Line_Contents);
           _setcursortype(_NOCURSOR);
           DrawScreen (Draw_x,Draw_y);
           if (Rmode==1) Get_Route(Draw_x,Draw_y,Cur_Route,1);
           if (Rmode==2) Get_All_Routes (Draw_x,Draw_y,1);
           if (Umode==1) Get_Route(Draw_x,Draw_y,Cur_Route,0);
           if (Umode==2) Get_All_Routes (Draw_x,Draw_y,0);
           if (Bmode==1) Cur_Route=Get_Block (Draw_x,Draw_y,Cur_Nr);
           if (Bmode==2) Get_All_Blocks (Draw_x,Draw_y);
           ScreenGetChar (&ch,&attr,Scr_x,Scr_y); // get left upper corner character
           Old_Col=attr;
           ScreenPutChar (ch,31,Scr_x,Scr_y); // activate cursor
         }
       if (((input=='L') || (input=='l')) && (Bmode==2))
        {
         uc Roads=0; // no road found yet
         uc TRoads=0;
         uc Result=0;
         uc Add=0;
         uc Del=Delete_Light(Scr_x+Draw_x,Scr_y+Draw_y);
         if (!Del)
          {
           if (TLights>=254) {Result=254;Do_Error ("To many trafficlights in map !");}
           uc Level=255; // no level found yet
           if (((Scr_x+Draw_x)>0) && (Result!=254)) Result=Get_Road_Level(Scr_x+Draw_x-1,Scr_y+Draw_y);
           if (Result<6) {TRoads++;Level=Result;}
           if (Result==251) Roads++;
           if (Result<253)
            {
             if ((Scr_x+Draw_x)<255) Result=Get_Road_Level(Scr_x+Draw_x+1,Scr_y+Draw_y);
             if (Result<6)
               if ((Level==255) || (Level==Result)) {TRoads++;Level=Result;}
                      else {Result=253;Do_Error("Multiple levels around traffic-light !");} // force error
             if (Result==251) Roads++;
             if (Result<253)
              {
               if ((Scr_y+Draw_y)>0) Result=Get_Road_Level(Scr_x+Draw_x,Scr_y+Draw_y-1);
               if (Result<6)
                 if ((Level==255) || (Level==Result)) {TRoads++;Level=Result;}
                        else {Result=253;Do_Error("Multiple levels around traffic-light !");}
               if (Result==251) Roads++;
               if (Result<253)
                {
                 if ((Scr_y+Draw_y)<255) Result=Get_Road_Level(Scr_x+Draw_x,Scr_y+Draw_y+1);
                 if (Result<6)
                   if ((Level==255) || (Level==Result)) {TRoads++;Level=Result;}
                        else {Result=253;Do_Error("Multiple levels around traffic-light !");}
                 if (Result==251) Roads++;
                }
              }
            }
           if ((Result<253) && (TRoads>0) && ((TRoads+Roads)<3))
             {
               TLight[TLights].Link=254;
               TLight[TLights].Address=vectors[3]+8;
               po[vectors[3]++]=(((Scr_x+Draw_x)*64)+32) % 256; // low byte X
               po[vectors[3]++]=(((Scr_x+Draw_x)*64)+32) / 256; // high byte X
               po[vectors[3]++]=(((Scr_y+Draw_y)*64)+32) % 256; // low byte Y
               po[vectors[3]++]=(((Scr_y+Draw_y)*64)+32) / 256; // high byte Y
               po[vectors[3]++]=(0x3F+(Level*64)) % 256; // low byte Z
               po[vectors[3]++]=(0x3F+(Level*64)) / 256; // high byte Z
               po[vectors[3]++]=16; // traffic light
               for (uc Count=1;Count<=7;Count++) po[vectors[3]++]=0;
               TLights++;
               Add++;
             }
          }
         DrawScreen (Draw_x,Draw_y);
         Get_All_Blocks (Draw_x,Draw_y);
         ScreenGetChar (&ch,&attr,Scr_x,Scr_y); // get left upper corner character
         Old_Col=attr;
         ScreenPutChar (ch,31,Scr_x,Scr_y); // activate cursor
         if ((TRoads==0) && (!Del) && (Result<253)) Do_Error ("No traffic-lights attached to Object !");
           else if (((Roads+TRoads)>2) && (!Del) && (Result<253)) Do_Error ("To many roads around traffic-light !");
        }
       if (input==K_EInsert)
         {
           if ((Rmode==1) || (Umode==1))
             {
              Cur_Route=New_Route (&Cur_Nr,Mode-1); // create new and make default
              DrawScreen (Draw_x,Draw_y);
              Get_Route (Draw_x,Draw_y,Cur_Route,Mode-1);
              ScreenGetChar (&ch,&attr,Scr_x,Scr_y); // get left upper corner character
              Old_Col=attr;
              ScreenPutChar (ch,31,Scr_x,Scr_y);
             }
         }
       if (input==K_EDelete)
         {
           if ((Rmode==1) || (Umode==1) || (Bmode==1))
             {
               Cur_Route=Delete_Route (Cur_Route,Mode-1);
               DrawScreen (Draw_x,Draw_y);
               if (Bmode==1)
                        {
                          TLight[Cur_Nr].Link=254;
                          Get_Block(Draw_x,Draw_y,Cur_Nr);
                        }
                        else Get_Route(Draw_x,Draw_y,Cur_Route,Mode-1);
               ScreenGetChar (&ch,&attr,Scr_x,Scr_y); // get left upper corner character
               Old_Col=attr;
               ScreenPutChar (ch,31,Scr_x,Scr_y);
               if (AFmode) Follow=1;
             }

         }
       if (input==K_EPageDown)
         {
           if ((Rmode==1) || (Umode==1))
             {
               Cur_Route=Cur_Route->Next;
               Cur_Nr++;
               if (Cur_Route==0L) {Cur_Route=Routes[Mode-1].Start;Cur_Nr=1;}
               DrawScreen (Draw_x,Draw_y);
               Get_Route (Draw_x,Draw_y,Cur_Route,Mode-1);
               ScreenGetChar (&ch,&attr,Scr_x,Scr_y); // get left upper corner character
               Old_Col=attr;
               ScreenPutChar (ch,31,Scr_x,Scr_y);
               if (AFmode) Follow=1;
             }
           if (Bmode==1)
             {
               Cur_Nr++;
               if (Cur_Nr>(TLights-1)) Cur_Nr=0;
               DrawScreen (Draw_x,Draw_y);
               Cur_Route=Get_Block (Draw_x,Draw_y,Cur_Nr);
               ScreenGetChar (&ch,&attr,Scr_x,Scr_y); // get left upper corner character
               Old_Col=attr;
               ScreenPutChar (ch,31,Scr_x,Scr_y);
               if (AFmode) Follow=1;
             }
         }
       if (input==K_Tab)
           if (AFmode==0) AFmode=1;
                   else   AFmode=0;
       if (input==K_EPageUp)
         {
           if ((Rmode==1) || (Umode==1))
             {
               Cur_Route=Cur_Route->Prev;
               Cur_Nr--;
               if (Cur_Route==0L) {Cur_Route=Routes[Mode-1].End;Cur_Nr=NRoutes[Mode-1];}
               DrawScreen (Draw_x,Draw_y);
               Get_Route (Draw_x,Draw_y,Cur_Route,Mode-1);
               ScreenGetChar (&ch,&attr,Scr_x,Scr_y); // get left upper corner character
               Old_Col=attr;
               ScreenPutChar (ch,31,Scr_x,Scr_y);
               if (AFmode) Follow=1;
             }
           if (Bmode==1)
             {
               Cur_Nr--;
               if (Cur_Nr==-1) Cur_Nr=(TLights-1);
               DrawScreen (Draw_x,Draw_y);
               Cur_Route=Get_Block (Draw_x,Draw_y,Cur_Nr);
               ScreenGetChar (&ch,&attr,Scr_x,Scr_y); // get left upper corner character
               Old_Col=attr;
               ScreenPutChar (ch,31,Scr_x,Scr_y);
               if (AFmode) Follow=1;
             }

         }
       if ((input=='v') || (input=='V'))
         {
           if (Gmode)
             {
               Gmode=0;
               DrawScreen (Draw_x,Draw_y);
               if (Rmode==1) Get_Route(Draw_x,Draw_y,Cur_Route,1);
               if (Rmode==2) Get_All_Routes (Draw_x,Draw_y,1);
               if (Umode==1) Get_Route(Draw_x,Draw_y,Cur_Route,0);
               if (Umode==2) Get_All_Routes (Draw_x,Draw_y,0);
               if (Bmode==1) Cur_Route=Get_Block (Draw_x,Draw_y,Cur_Nr);
               if (Bmode==2) Get_All_Blocks (Draw_x,Draw_y);
               ScreenGetChar (&ch,&attr,Scr_x,Scr_y); // get left upper corner character
               Old_Col=attr;
               ScreenPutChar (ch,31,Scr_x,Scr_y); // activate cursor
             }
            else
             {
               Gmode=1;
               DrawScreen (Draw_x,Draw_y);
               if (Rmode==1) Get_Route(Draw_x,Draw_y,Cur_Route,1);
               if (Rmode==2) Get_All_Routes (Draw_x,Draw_y,1);
               if (Umode==1) Get_Route(Draw_x,Draw_y,Cur_Route,0);
               if (Umode==2) Get_All_Routes (Draw_x,Draw_y,0);
               if (Bmode==1) Cur_Route=Get_Block (Draw_x,Draw_y,Cur_Nr);
               if (Bmode==2) Get_All_Blocks (Draw_x,Draw_y);
               ScreenGetChar (&ch,&attr,Scr_x,Scr_y); // get left upper corner character
               Old_Col=attr;
               ScreenPutChar (ch,31,Scr_x,Scr_y); // activate cursor
             }
         }
       if (input==K_F10)
         {
          gettext (1,50,80,50,Line_Contents); // retrieve last line
          gotoxy (1,50);
          cprintf ("Saving .....                                                                   ");
          CityFile.open (argv[0],ios::out|ios::binary|ios::trunc); // open for output
          CityBack.open (BackupFile,ios::out|ios::binary|ios::trunc);
          Save_Field (); // should speak for itself
          CityFile.close();
          CityBack.close();
          puttext (1,50,80,50,Line_Contents); // retrieve last line
         }
       if (input==K_Escape)
         {
          gettext (1,50,80,50,Line_Contents);
          gotoxy (1,50);
          cprintf ("Are you sure (Y/N)                                                             ");
          char confirm='R';
          while (!strchr("YyNn",confirm))
            confirm=getkey();
          if ((confirm=='Y') || (confirm=='y')) end=1;
          puttext (1,50,80,50,Line_Contents);
         }
       if (input==K_F1)
         {
           gettext (1,1,80,50,Line_Contents);
           clrscr();
           clprintf ("#MCops (and Goverment) #PQuick Reference\n\n\r");
           clprintf ("#PMode keys\n\n\r#H");
           clprintf ("B       = Road#OB#Hlock mode\n\r");
           clprintf ("R       = Police#OR#Houte mode\n\r");
           clprintf ("U       = #OU#Hnknown mode #G(See doc)#H\n\r");
           clprintf ("T       = #OT#Hrain mode\n\r");
           clprintf ("V       = #OV#Hiew goverment mode\n\n\r");
           clprintf ("#PIn mode keys\n\n\r#H");
           clprintf ("I       = Activate #OI#Hnsert mode\n\r");
           clprintf ("A       = #OA#Hdd a point\n\r");
           clprintf ("D       = #OD#Helete a point\n\r");
           clprintf ("E       = #OE#Hdit the time of a point #G(not in Roadblock mode)#H\n\r");
           clprintf ("F       = #OF#Hollow route to next point\n\r");
           clprintf ("L       = Place/Remove Traffic #OL#Hight #G(only in 'B All' mode)#H\n\r");
           clprintf ("G       = Place #OG#Hoverment facility (#G(only in Goverment view mode)#H\n\r");
           clprintf ("Page Dwn= Select next route\n\r");
           clprintf ("Page Up = Select previous route \n\r");
           clprintf ("Delete  = Delete a complete route\n\r");
           clprintf ("Insert  = Creates a complete new route #G(not in Roadblock mode)#H\n\n\r");
           clprintf ("#PMiscellanous keys#H\n\n\r");
           clprintf ("F1      = This help screen\n\r");
           clprintf ("F10     = Saves the field\n\r");
           clprintf ("Escape  = Exits the program\n\r");
           clprintf ("Tab     = Auto Follow mode");
           gotoxy (15,50);
           clprintf ("#L Press Any key to Return");
           getxkey();
           puttext (1,1,80,50,Line_Contents);
         }
     }
   clrscr();
   _set_screen_lines(25);
   _setcursortype(_NORMALCURSOR);

}
