/* $Id: wicomp.cpp,v 1.9 2000/11/23 18:42:38 umoeller Exp $ */

/***************************************************************************
 *                                                                         *
 *  Compression routines for the class WIArchive                           *
 *                                                                         *
 *  This file Copyright (C) 1998-2000 Jens Bckman, Ulrich Mller.         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation, in version 2 as it comes in the COPYING  *
 *  file of this distribution.                                             *
 *  This program is distributed in the hope that it will be useful,        *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *  GNU General Public License for more details.                           *
 *                                                                         *
 ***************************************************************************/

#include "setup.h"              // added V0.9.2 (2000-03-15) [umoeller]

#define WIARCHIVE_INTERNAL
#include "wiarchive.h"

#ifdef WIN32
#include <limits.h>
#endif

char *text;

/****************************************************************************
 * Use the Lempel-Ziv and Huffman compression methods to reduce the size of
 * this file.
 *
 * Arguments - head: Reference to file header
 */
void WIArchive::Compress(WIFileHeader *head)
{
    bz_stream z;
    char *outbuf;
    int status, count;
    unsigned int i;

    // First of all, do some initialization
    head->method = 1;
    head->crc = INIT_CRC;
    char *text = new char[BUFFERSIZE];
    outbuf = new char[BUFFERSIZE];
    z.bzalloc = 0;
    z.bzfree  = 0;
    z.opaque = NULL;
    z.bzalloc = NULL;
    z.bzfree = NULL;
    BZ2_bzCompressInit (&z, 9, 0, 30);
    // Now, begin the compression!
    z.avail_in = 0;
    z.next_out = outbuf;
    z.avail_out = BUFFERSIZE;
    head->compsize = 0;
    for (;;)
    {
        if (_pfnCallback != NULL)
            (*_pfnCallback)(CBM_PERCENTAGE,
                            CalcPercentage(ftell(_File), head->origsize),
                            head);
        if (z.avail_in == 0)
        {
            z.next_in = text;
            z.avail_in = fread (text, 1, BUFFERSIZE, _File);
        }
        if (z.avail_in == 0)
             break;
        for (i = 0; i < z.avail_in; i++)
            UPDATE_CRC (text[i]);
        status = BZ2_bzCompress (&z, BZ_RUN);
        count = BUFFERSIZE - z.avail_out;
        head->compsize += count;
        if (count)
            fwrite (outbuf, 1, count, _Archive);
        z.next_out = outbuf;
        z.avail_out = BUFFERSIZE;
    }

    // Flush pending data and wrap things up
    if (head->origsize != 0)
    {
        do
        {
            status = BZ2_bzCompress (&z, BZ_FINISH);
            count = BUFFERSIZE - z.avail_out;
            head->compsize += count;
            if (count)
                fwrite (outbuf, 1, count, _Archive);
            z.next_out = outbuf;
            z.avail_out = BUFFERSIZE;
        } while (status != BZ_STREAM_END);
    }
    BZ2_bzCompressEnd (&z);
    delete [] outbuf;
    delete [] text;
}

/****************************************************************************
 * Do not apply any compression at all on this file, just calculate the CRC
 * value and store it.
 *
 * Arguments - head: Reference to file header
 */
void WIArchive::Store(WIFileHeader *head)
{
    unsigned short bytes, i;
    unsigned long crc;

    head->compsize = head->origsize;
    head->method = 0;
    crc = INIT_CRC;

    // ----- Store the file without compression
    text = new char[BUFFERSIZE];
    bytes = fread (text, 1, BUFFERSIZE, _File);
    while (bytes)
    {
        if (_pfnCallback != NULL)
            (*_pfnCallback)(CBM_PERCENTAGE,
                            CalcPercentage (ftell(_File), head->origsize),
                            head);
        for (i = 0; i < bytes; i++)
            UPDATE_CRC (text[i]);
        fwrite(text, 1, bytes, _Archive);
        bytes = fread (text, 1, BUFFERSIZE, _File);
    }
    delete [] text;

    crc ^= INIT_CRC;
    head->crc = crc;
}










