/*------------------------------------------------------------------------*\
|                                                                          |
|           MKWINBAK.CMD - Version 1.0 - Version Date 1995-09-29           |
|                 Copyright (c) 1995 by C F S Nevada, Inc.                 |
|                                                                          |
|                 Dick Goran      - Voice      702-732-9616                |
|                                 - FAX        702-732-3847                |
|                                 - CompuServe 71154,2002                  |
|                                 - Internet   dgoran@cfsrexx.com          |
|                                                                          |
|          Produced and distributed by Productivity Solutions, Inc.        |
|                 David Moskowitz - Voice      610-631-5685                |
|                                 - FAX        610-631-0414                |
|                                 - CompuServe 76701,100                   |
|                                 - Internet   davidm@cfsrexx.com          |
|                                                                          |
| ------------------------------------------------------------------------ |
|  Requires: REXXLIB.DLL  - OS/2 REXX external function library            |
|                           (c) Copyright 1992-95 Quercus Systems          |
\*------------------------------------------------------------------------*/
/*

   This program can be used to backup \WINOS2 and subordinate directories.
   At the same time, it creates R-WINOS2.CMD which will restore the WINOS2
   to its original contents (including subdirectories).

   It calculates the required space and allows the user to select the
   drive and path where the backup repository will be created.

   The backup repository will be created only if it does not exist.
   This will generally be a on-time task.

   The restore procedure, R-WINOS2.CMD, may be run as desired.

*/

   SIGNAL ON ERROR                  /* trap object time errors     */
   SIGNAL ON FAILURE                /* trap object time errors     */
   SIGNAL ON HALT                   /* trap object time errors     */
   SIGNAL ON NOVALUE                /* trap object time errors     */
   SIGNAL ON SYNTAX                 /* trap object time errors     */

GBL. = ''             /* initialize stem */
parse Arg             GBL.command_line
parse Version         GBL.REXX_version .
parse Source          GBL.operating_system,
                      GBL.calling_environment,
                      GBL.program_path_and_name
GBL.package_name    = 'MKWINOS2'
GBL.environment     = 'OS2ENVIRONMENT'
GBL.boot_drive      = LEFT( VALUE( 'RUNWORKPLACE',, GBL.environment ), 2 )
GBL.program_version = 1.0           /* version / mod of this program */
GBL.program_name    = FILESPEC( 'N', GBL.program_path_and_name )
GBL.program_path    = FILESPEC( 'D', GBL.program_path_and_name ) ||,
                      FILESPEC( 'P', GBL.program_path_and_name )

parse var GBL.program_name,
   GBL.program_fn '.',
   GBL.program_fe

GBL.bksp               = '08'x
GBL.progress_list      = "\|/"
GBL.progress_subscript = 1
GBL.list =,
   'crlf',
   ''

crlf = '0D0A'x

call TIME 'E'                       /* set elapsed timer - sssss.uuuuu */
say 'Begin' TRANSLATE( GBL.program_name ) 'at' TIME('N')
call REGISTER_REQUIRED_FUNCTIONS

/*------------------------------------*\
|  Get WINOS2 path & file system type  |
\*------------------------------------*/
GBL.WINOS2_path =,
   STRIP( SysIni( 'USER', 'PM_INSTALL', 'WINOS2_LOCATION' ), 'T', '00'x ) || '\'
GBL.WINOS2_file_system =,
   DOSFILESYS( FILESPEC( 'D', GBL.WINOS2_path ) )

/*-------------------*\
|  Define file names  |
\*-------------------*/
GBL.R_WINOS2_yes =,
   GBL.program_path ||,
   'R-WINOS2.YES'                   /* YES reply file */
GBL.R_WINOS2_file =,
   GBL.program_path ||,
   'R-WINOS2.CMD'                   /* restore procedural CMD file */

/*-------------------------------------------*\
|  Check for prior execution of this program  |
\*-------------------------------------------*/
if STREAM( GBL.R_WINOS2_yes, 'C', 'QUERY EXISTS' ) = '' then
   do
      say ''
      say '   This program has previously been run. Running it again can result'
      say '   in an ambiguous tree structure subordinate to' GBL.WINOS2_path
      say ''
      say '   To override this check and allow this program to run, you must first'
      say '   manually delete' GBL.R_WINOS2_yes 'then rerun this program.'
      say ''
      call EOJ
   end

/*------------------------------------*\
|  Calculate required repository size  |
\*------------------------------------*/
GBL.repository_size = 0

call SysFileTree GBL.WINOS2_path || '*.*', 'WINOS2_stem', 'S'
if WINOS2_stem.0 = 0 then
   do
      say '   Unable to locate any files in ' || GBL.WINOS2_path
      call EOJ                      /* should not occur */
   end

/* Put directory entries first */
directory_indicator_pos = WORDINDEX( WINOS2_stem.1, 4 ) + 1
path_and_name_pos       = WORDINDEX( WINOS2_stem.1, 5 )
call ARRAYSORT 'WINOS2_stem', 1, WINOS2_stem.0,,
               directory_indicator_pos,   1, 'D', 'C',,
               path_and_name_pos,       100, 'A', 'C'

/* Tally rounded up size */
do s = 1 to WINOS2_stem.0
   parse value WINOS2_stem.s with,
      stem_date,
      stem_time,
      stem_size,
      stem_attr,
      stem_path_and_file_name
   stem_path_and_file_name = STRIP( stem_path_and_file_name )

   if SUBSTR( stem_attr, 2, 1 ) = 'D' then
      do
         /* use an excessive amount for safety */
         rounded_size =,
            ( ( stem_size + 4095 ) % 4096 ) * 4096
         GBL.repository_size = GBL.repository_size + rounded_size
      end
end

/*--------------------------------------------*\
|  Build list of drives that have enough room  |
|     HPFS or FAT if WINOS2 on FAT             |
|     HPFS only   if WINOS2 on HPFS            |
\*--------------------------------------------*/
potential_drive_list = SysDriveMap()
useable_drive_list   = ''

do w = 1 to WORDS( potential_drive_list )
   drive_letter_colon = WORD( potential_drive_list, w )
   if WORD( SysDriveInfo( drive_letter_colon ), 2 ) < GBL.repository_size then
      do
         iterate w
      end
   if GBL.WINOS2_file_system = 'HPFS',
            &,
      DOSFILESYS( drive_letter_colon ) = 'HPFS' then
      do
         iterate w
      end
   useable_drive_list =,
      useable_drive_list ||,
      drive_letter_colon || ' '
end

if useable_drive_list = '' then
   do
      say '   Unable to find any drives with adequate space to create WINOS2 backup'
      say '   ' || EDIT( GBL.repository_size ) || ' bytes required'
      call EOJ
   end

/*-------------------------------------------------*\
|  Query user for drive & path to store repository  |
\*-------------------------------------------------*/
call CHAROUT 'CON:',,
             COPIES( ' ', 3 ) ||,
             'The following drives have adequate room to contain your WINOS2 backup.' || crlf ||,
             COPIES( ' ', 3 ) || 'Enter a drive letter and path for the WINOS2 repository from one of ' || crlf ||,
             COPIES( ' ', 3 ) || 'the following drives. The directory will be created for you.' || crlf ||,
             COPIES( ' ', 6 ) || useable_drive_list || '  '

do forever
   pull reply
   if LENGTH( reply ) = 1 then
      do
         reply = reply || ':'
      end
   drive_ptr = WORDPOS( FILESPEC( 'D', reply ), useable_drive_list )
   if drive_ptr > 0,
         &,
      LENGTH( reply ) > 2 then
      do
         call CHAROUT 'CON:', crlf
         leave
      end
   call CHAROUT 'CON:',,
                COPIES( ' ', 9 ) || 'invalid entry, retry   '
end

/*-----------------------------*\
|  Confirm building repository  |
\*-----------------------------*/
if RIGHT( reply, 1 ) = '\' then
   do
      reply = reply || '\'
   end
GBL.repository_path =,
   FILESPEC( 'D', reply ) ||,
   FILESPEC( 'P', reply )

if DOSISDIR( STRIP( GBL.repository_path, 'T', '\' ) ) then
   do
      call CHAROUT 'CON:',,
                   COPIES( ' ', 3 ) ||,
                   GBL.repository_path ||,
                   ' already exists, should it be overwritten? '
      pull reply
      if LEFT( reply, 1 ) = 'Y' then
         do
            call DELETE_TREE
         end
      else
         do
            reply = 'BYPASS'
         end
   end

if reply = 'BYPASS' then
   do
      call COPY_TREE
   end

/*------------------------------------------------------------------------*\
|                                                                          |
|         Build procedural R-WINOS2.CMD file - not a REXX program          |
|                                                                          |
\*------------------------------------------------------------------------*/
/*------------------------------------------*\
|  Build YES data file for DEL *.* response  |
\*------------------------------------------*/
call SysFileDelete GBL.R_WINOS2_yes
call LINEOUT GBL.R_WINOS2_yes, 'Y'
call STREAM GBL.R_WINOS2_yes, 'C', 'CLOSE'

/*-------------------------*\
|  Check for skeleton data  |
|    created by MKWINOS2    |
\*-------------------------*/
begin_marker = 'REM  BEG:'
end_marker   = 'REM  END:'

GBL.R_WINOS2_size = STREAM( GBL.R_WINOS2_file, 'C', 'QUERY SIZE' )

if GBL.R_WINOS2_size > 0 then
   do
      GBL.R_WINOS2_area = CHARIN( GBL.R_WINOS2_file, 1, GBL.R_WINOS2_size )
      call STREAM GBL.R_WINOS2_file, 'C', 'CLOSE'

      /*--------------------------------*\
      |  Get paths inserted by MKWINOS2  |
      \*--------------------------------*/
      begin_marker_pos = POS( begin_marker, GBL.R_WINOS2_area )
      if begin_marker = 0 then
         do
            say '   ' || GBL.R_WINOS2_file || ' has been unrecognizeably altered'
            say '   Please read the MKWINOS2 documentation!'
            call EOJ
         end
      next_line_pos = POS( crlf, GBL.R_WINOS2_area, begin_marker_pos ) + 2

      end_marker_pos = POS( end_marker, GBL.R_WINOS2_area )
      if end_marker = 0 then
         do
            say '   ' || GBL.R_WINOS2_file || ' has been unrecognizeably altered'
            say '   Please read the MKWINOS2 documentation!'
            call EOJ
         end
      end_line_begin_pos = LASTPOS( crlf, GBL.R_WINOS2_area, end_marker_pos ) + 2

      if end_line_begin_pos = next_line_pos then
         do
            GBL.R_WINOS2_area =,
               SUBSTR( GBL.R_WINOS2_area,,
                       next_line_pos,,
                       end_line_begin_pos - next_line_pos )
         end
      else
         do
            GBL.R_WINOS2_area = ''
         end
   end

l=0
l=l+1; line.l = '@ECHO off'
l=l+1; line.l = 'ECHO ͻ'
l=l+1; line.l = 'ECHO  Restore WINOS2 directories '
l=l+1; line.l = 'ECHO ͼ'
l=l+1; line.l = 'SET  WINOS2_path=' || GBL.WINOS2_path
l=l+1; line.l = 'SET  WINOS2_backup_path=' || GBL.repository_path
l=l+1; line.l = 'IF EXIST %WINOS2_backup_path%WIN.INI GOTO STEP01'
l=l+1; line.l = 'ECHO Unable to locate %WINOS2_backup_path%WIN.INI, restore cancelled'
l=l+1; line.l = 'GOTO EOJ'
l=l+1; line.l = ''
l=l+1; line.l = ':STEP01'
l=l+1; line.l = 'ECHO Recreate '                   ||,
                      GBL.WINOS2_path     || '*.*' ||,
                      ' from '                     ||,
                      GBL.repository_path || '*.*'
l=l+1; line.l = 'ECHO (OK to rerun as desired - altered dynamically by MKWINOS2)'

l=l+1; line.l = ' '
l=l+1; line.l = 'ECHO.'
l=l+1; line.l = 'ECHO Restoring %WINOS2_path%'
l=l+1; line.l = 'DEL  %WINOS2_path%*.* <' || GBL.R_WINOS2_yes || ' 2>nul'
l=l+1; line.l = 'COPY %WINOS2_backup_path%*.* %WINOS2_path%*.* 1>nul'

l=l+1; line.l = ' '
l=l+1; line.l = 'ECHO.'
l=l+1; line.l = 'ECHO Restoring %WINOS2_path%SYSTEM\'
l=l+1; line.l = 'DEL  %WINOS2_path%SYSTEM\*.* <' || GBL.R_WINOS2_yes || ' 2>nul'
l=l+1; line.l = 'COPY %WINOS2_backup_path%SYSTEM\*.* %WINOS2_path%SYSTEM\*.* 1>nul'

l=l+1; line.l = ' '
l=l+1; line.l = 'REM' COPIES( '*', 76 )
l=l+1; line.l = 'REM  Do NOT alter any data between the BEG: & END: lines'
l=l+1; line.l = 'REM  BEG: additional directories - set dynamically by MKWINOS2'

if GBL.R_WINOS2_area = '' then
   do
      /* strip trailing crlf to prevent double occurrence */
      l=l+1; line.l = LEFT( GBL.R_WINOS2_area, LENGTH( GBL.R_WINOS2_area ) - 2 )
   end

l=l+1; line.l = 'REM  END: additional directories - set dynamically by MKWINOS2'
l=l+1; line.l = 'REM' COPIES( '*', 76 )

l=l+1; line.l = ' '
l=l+1; line.l = ':EOJ'
l=l+1; line.l = 'SET  WINOS2_path='
l=l+1; line.l = 'SET  WINOS2_backup_path='
       line.0 = l

call SysFileDelete GBL.R_WINOS2_file
do l = 1 to line.0
   call LINEOUT GBL.R_WINOS2_file, line.l
end
call STREAM GBL.R_WINOS2_file, 'C', 'CLOSE'

call STREAM 'CON:', 'C', 'CLOSE'

call EOJ 0


/*------------------------------------------------------------------------*\
|                                                                          |
|     Copy all \WINOS2 files and subordinate directories to repository     |
|                                                                          |
\*------------------------------------------------------------------------*/
COPY_TREE:
   Procedure expose,
      GBL. (GBL.list),
      WINOS2_stem.


call CHAROUT 'CON:', '   Copying '       ||,
                     GBL.WINOS2_path     ||,
                     ' to '              ||,
                     GBL.repository_path ||,
                     '  '
call SysCurState 'OFF'

/* make top level directory */
call SysMkDir STRIP( GBL.repository_path, 'T', '\' )

do s = 1 to WINOS2_stem.0
   call WRITE_PROGRESS_INDICATOR
   parse value WINOS2_stem.s with,
      stem_date,
      stem_time,
      stem_size,
      stem_attr,
      stem_path_and_file_name
   stem_path_and_file_name = STRIP( stem_path_and_file_name )

   parse value stem_path_and_file_name with,
      (GBL.WINOS2_path),
      tail_path_and_name

   if SUBSTR( stem_attr, 2, 1 ) = 'D' then
      do
         call SysMkDir GBL.repository_path || tail_path_and_name
      end
   else
      do
         call DOSCOPY stem_path_and_file_name,,
                      GBL.repository_path || tail_path_and_name,,
                      'R'
      end
end
call CHAROUT 'CON:', ' ' || crlf
call SysCurState 'ON'

return

/*------------------------------------------------------------------------*\
|                                                                          |
|  Delete all files and directories in and subordinate to specified path   |
|                                                                          |
\*------------------------------------------------------------------------*/
DELETE_TREE:
   Procedure expose,
      GBL. (GBL.list)

call SysFileTree GBL.repository_path || '*.*', 'd_stem', 'S'
if d_stem.0 = 0 then
   do
      call SysRmDir GBL.repository_path
      return
   end

/* Put directory entries last */
directory_indicator_pos = WORDINDEX( d_stem.1, 4 ) + 1
call ARRAYSORT 'd_stem', 1, d_stem.0,,
               directory_indicator_pos,   1, 'A', 'C'

call CHAROUT 'CON:', '   Deleting contents of ' ||,
                     GBL.repository_path        ||,
                     '  '
call SysCurState 'OFF'

do s = 1 to d_stem.0
   call WRITE_PROGRESS_INDICATOR
   parse value d_stem.s with,
      stem_date,
      stem_time,
      stem_size,
      stem_attr,
      stem_path_and_file_name
   stem_path_and_file_name = STRIP( stem_path_and_file_name )

   if SUBSTR( stem_attr, 2, 1 ) = 'D' then
      do
         call SysFileDelete stem_path_and_file_name
      end
   else
      do
         call SysRmDir stem_path_and_file_name
      end
end

call CHAROUT 'CON:', ' ' || crlf
call SysCurState 'ON'

return

/*------------------------------------------------------------------------*\
|                                                                          |
|                            EDIT REXX function                            |
|                                                                          |
\*------------------------------------------------------------------------*/
EDIT:
   Procedure

/* first time here, build translate tables */
SIGNAL OFF NOVALUE
if LEFT(e1, 1) <> '01'x then
   do
      e1 = XRANGE('01'x, '19'x)
      e2 = XRANGE('01'x, '03'x) || '19'x ||,
           XRANGE('04'x, '06'x) || '19'x ||,
           XRANGE('07'x, '09'x) || '19'x ||,
           XRANGE('0A'x, '0C'x) || '19'x ||,
           XRANGE('0D'x, '0F'x) || '19'x ||,
           XRANGE('10'x, '12'x) || '19'x ||,
           XRANGE('13'x, '15'x) || '19'x ||,
           XRANGE('16'x, '18'x)
      /* get punctuation characters from INI file  */
      decimal  = STRIP( SysIni( 'USER',,
                                'PM_National',,
                                'sDecimal' ), 'T', '00'x )
      thousand = STRIP( SysIni( 'USER',,
                                'PM_National',,
                                'sThousand' ), 'T', '00'x )
   end
SIGNAL ON NOVALUE

/* return BAD if non-numeric data */
if DATATYPE( ARG(1) ) <> 'NUM' then
   return 'BAD'

/* test and save sign value along with absolute numeric value */
if SIGN( ARG(1) ) <> '-1' then
   sign_character = ''
else
   sign_character = '-'
absolute_value = ABS( ARG(1) )

/* test for and save decimal value indicator */
decimal_position = POS( decimal, absolute_value )

if decimal_position = 0 then
   source = RIGHT( absolute_value, LENGTH(e1) - 1 ) || ' '
else
   source = RIGHT( LEFT( absolute_value, decimal_position - 1 ), LENGTH(e1) - 1 ) || ' '

if decimal_position = 0 then
   edited_number =,
      STRIP( TRANSLATE( TRANSLATE( e2, source, e1), ',', ' '), 'B', ',')
else
   edited_number =,
      STRIP( TRANSLATE( TRANSLATE( e2, source, e1), ',', ' '), 'B', ','),
                      || RIGHT( absolute_value,,
                                LENGTH(absolute_value) - decimal_position + 1)
return sign_character || edited_number

!tr!=VALUE('TRACE',,'OS2Environment'); if !tr!<>'' then do;TRACE(!tr!);nop;end
/*------------------------------------------------------------------------*\
|                                                                          |
|                                End of Job                                |
|                                                                          |
\*------------------------------------------------------------------------*/
EOJ:
   Procedure expose,
      GBL.

if ARG() = 0 then
   eoj_rc = 0
else
   eoj_rc = ARG(1)

elapsed_time = TIME('E')            /* get elapsed time - sssss.uuuuu */
parse value elapsed_time with seconds '.' micro_seconds
if LEFT( micro_seconds, 1, 1 ) >= 5 then
   seconds = seconds + 1
ss = FORMAT( seconds // 60, 2 )
minutes = ( seconds - ss ) / 60
mm = FORMAT( minutes // 60, 2 )
hh = FORMAT( ( minutes - mm ) / 60, 2 )
duration = hh':'mm':'ss

program_name = TRANSLATE( FILESPEC( 'N', GBL.program_path_and_name ) )
say 'End  ' program_name 'at' TIME('N') ||,
    ', duration' TRANSLATE( duration, '0', ' ' )
exit eoj_rc

/*------------------------------------------------------------------------*\
|                                                                          |
|                   Register external function routines                    |
|                                                                          |
\*------------------------------------------------------------------------*/
REGISTER_REQUIRED_FUNCTIONS:
   Procedure expose,
      GBL.

/*----------------------------------------*\
|  Load REXXUtil External Function Module  |
\*----------------------------------------*/
module             = 'REXXUTIL'
entry_name         = 'SysLoadFuncs'
function_name      = 'SysLoadFuncs'
anticipated_return = ''
call REGISTER_ROUTINE function_name, module, entry_name, anticipated_return

/*-----------------------------------*\
|  Load the REXXLIB Function Package  |
\*-----------------------------------*/
if GBL.REXX_version = 'REXX/Personal' then
   do
      module = 'qrexxlib'
   end
else
   do
      module = 'rexxlib'
   end
entry_name         = 'rexxlibregister'
function_name      = 'RexxLibRegister'
anticipated_return = '1'
call REGISTER_ROUTINE function_name, module, entry_name, anticipated_return

/*-----------------------------*\
|  Determine Warp vs. non-Warp  |
\*-----------------------------*/
GBL.warp = 0
if SYSINI( 'USER', 'PM_Workplace:Location', '<WP_LAUNCHPAD>' ) = '' then
   do
      GBL.warp = 1
   end

return


/*---------------------*\
|  Register Subroutine  |
\*---------------------*/
REGISTER_ROUTINE:
   Procedure

parse ARG  function_name,,
           module,,
           entry_name,,
           anticipated_return

if RxFuncQuery(function_name) = 0 then return      /* function registered */

if LENGTH(module) > 8 then
   do
      dll_drive = FILESPEC( 'D', module )
      dll_path  = STRIP( FILESPEC( 'P', module ), 'T', '\' )
      module    = FILESPEC( 'N', module )
      '@' || dll_drive
      '@cd' dll_drive || dll_path
   end
else
   do
      dll_drive = ''
   end

parse var module module_fname '.' module_fext
if RxFuncAdd( function_name, module_fname, entry_name ) = 0 then
   do
      register_call = 'call' function_name
      interpret register_call
      if WORD( RESULT, 1 ) <> WORD( anticipated_return, 1 ) then
         do
            Say function_name 'returned' RESULT '-',
                                         anticipated_return 'was expected'
            exit 255
         end
   end
else
   do
      Say 'RxFuncAdd returned' RESULT 'registering' module
      exit 254
   end
if dll_drive <> '' then
   do
      Parse Source . . GBL.program_path_and_name
      '@' || LEFT( GBL.program_path_and_name, 2 )
   end
return


/*------------------------------------------------------------------------*\
|                                                                          |
|                    Write twirling progress indicator                     |
|                                                                          |
\*------------------------------------------------------------------------*/
WRITE_PROGRESS_INDICATOR:
   Procedure expose,
      GBL.

call CHAROUT "CON:", SUBSTR( GBL.progress_list,,
                             GBL.progress_subscript,,
                             1 ) || GBL.bksp
GBL.progress_subscript = GBL.progress_subscript + 1
if GBL.progress_subscript > LENGTH( GBL.progress_list ) then
   do
      GBL.progress_subscript = 1
   end

return

/*------------------------------------------------------------------------*\
|                                                                          |
|                              Trap Routines                               |
|                                                                          |
\*------------------------------------------------------------------------*/
ERROR:   call TRAP_PROCESSING SIGL, 'ERROR',   RC
FAILURE: call TRAP_PROCESSING SIGL, 'FAILURE', RC
HALT:    call TRAP_PROCESSING SIGL, 'HALT',    ''
NOVALUE: call TRAP_PROCESSING SIGL, 'NOVALUE', ''
SYNTAX:  call TRAP_PROCESSING SIGL, 'SYNTAX',  RC

/* Rev. 95/07/29 */
TRAP_PROCESSING:
   parse Source . . TRAP.path_and_program
   trap.line_nbr = ARG(1)
   if POS( ':', TRAP.path_and_program ) > 0 then
      /* get source line if it is available */
      do t = 1
         trap_source_line.t =  SOURCELINE( trap.line_nbr )
         trap_source_line.0 = t
         trap.line_nbr      = trap.line_nbr + 1
         if RIGHT( trap_source_line.t, 1 ) = ',' then
            do
               leave
            end
      end
   else
      /* program is running in macrospace */
      do
         TRAP.path_and_program = VALUE( 'TEMP',, 'OS2ENVIRONMENT' ) ||,
                                 '\' || TRAP.path_and_program
         trap_source_line.1 = 'Source line is not available.'
         trap_source_line.0 = 1
      end

   parse value FILESPEC( 'N', TRAP.path_and_program ) with,
      TRAP.fn '.' TRAP.fe
   trap_file_name = FILESPEC( 'D', TRAP.path_and_program ) ||,
                    FILESPEC( 'P', TRAP.path_and_program ) ||,
                    TRAP.fn || '.' || 'DMP'

   /*------------------------------------------*\
   |  check for reason not to create .DMP file  |
   \*------------------------------------------*/
   if ARG(2) = '----' then
      do
         trap_file_name = ''
      end
   if RxFuncQuery( 'VARDUMP' ) <> 0 then
      do
         trap_file_name = ''
      end
   if POS( ':', trap_file_name ) = 0 then
      do
         trap_file_name = ''
      end

   /*------------------------*\
   |  Build trap message box  |
   \*------------------------*/
   dbl.h    = 'CD'x                 /*  double line - horizontal   */
   dbl.v    = 'BA'x                 /*  double line - vertical     */
   dbl.bl   = 'C8'x                 /*  double line - bottom left  */
   dbl.br   = 'BC'x                 /*  double line - bottom right */
   dbl.tl   = 'C9'x                 /*  double line - top left     */
   dbl.tr   = 'BB'x                 /*  double line - top right    */
   trap.red = '1B'x || '[1;37;41m'  /* bright white on red          */
   trap.dul = '1B'x || '[0m'        /* reset to normal              */

   say ' '
   trap_error_description =,
      'Error line = ' || ARG(1) ||,
      '; ' ||,
      ARG(2) ||,
      ' error.'
   if ARG(3) <> '' then
      trap_error_description = trap_error_description ||,
                               '  Return code = ' || ARG(3)
   trap.width = MAX( 74, LENGTH( trap_error_description ) )
   say trap.red || dbl.tl || COPIES( dbl.h,trap.width + 2 ) || dbl.tr || trap.dul
   say trap.red || dbl.v  || COPIES( ' ',  trap.width + 2 ) || dbl.v  || trap.dul
   say trap.red || dbl.v CENTER( TRAP.fn'.CMD',trap.width )    dbl.v  || trap.dul
   say trap.red || dbl.v CENTER( trap_error_description, trap.width ) dbl.v || trap.dul
   if trap_file_name <> '' then
      do
   say trap.red || dbl.v  || COPIES( ' ',  trap.width + 2 ) || dbl.v  || trap.dul
   say trap.red || dbl.v     CENTER( 'See: ' || trap_file_name,,
                                     trap.width )  dbl.v  || trap.dul
      end
   say trap.red || dbl.v  || COPIES( ' ',  trap.width + 2 ) || dbl.v  || trap.dul
   say trap.red || dbl.bl || COPIES( dbl.h,trap.width + 2 ) || dbl.br || trap.dul
   say trap.red || COPIES( ' ', trap.width + 4 ) || trap.dul
   say trap.red || LEFT( 'Source line(s) at time of trap:', trap.width + 4 ) || trap.dul
   do t = 1 to trap_source_line.0
      say trap.red || LEFT( '   ' || trap_source_line.t, trap.width + 4 ) || trap.dul
   end
   say trap.red || COPIES( ' ', trap.width + 4 ) || trap.dul

   /*---------------------------------*\
   |  Create .DMP file if appropriate  |
   \*---------------------------------*/
   if trap_file_name <> '' then
      do
         call SysFileDelete trap_file_name
         /* remove meaningless labels from dump for clarity */
         drop dbl. TRAP. RC RESULT SIGL !tr!
         call VARDUMP trap_file_name  /* write variables to program.DMP file */
      end
   exit 253
