// ToBoSoft-Version 3.5T
// for Watcom or Borland C++
// #define WATCOM_COMPILER

// 祭 *.h.
#include <Windows.h>
#include <String.h>
#include <Mem.h>
#include <IO.h>
#include <FCntl.h>
#include <Sys\Stat.h>
#ifdef WATCOM_COMPILER
 #include <Direct.h>
#else
 #include <Dir.h>
#endif

//  .
#define INT     int
#define CHAR    char
#define VOID    void
#ifndef WATCOM_COMPILER
 #define FAR     _far
#endif

//  ।  Win.ini.
#define VK_MACRO        0xE2
#define VK_RIGHT_ALT    0xC1380001

#define VK_UP_1         0x1480001
#define VK_UP_2         0xC1480001
#define VK_DOWN_1       0x1500001
#define VK_DOWN_2       0xC1500001
#define VK_LEFT_1       0x14B0001
#define VK_LEFT_2       0xC14B0001
#define VK_RIGHT_1      0x14D0001
#define VK_RIGHT_2      0xC14D0001

#define HTCLOSEBUTTON   20

#define SM_MOVE         0xF010
#define SM_CLOSE        0xF060

#ifndef WATCOM_COMPILER
 #define min( a, b ) ( ( ( a ) < ( b ) ) ? ( a ) : ( b ) )
#endif

//  ப   . ᮪ ᪫祭 ஥  祭 10.
#define SIZE_OF_NAME    10
//  ᯨ᪮    墠 ࠦ  .
#define SIZE_OF_LIST    100
#define SIZE_OF_LINE    150

//    ஥:
// ਫ - WinMain() 뢠  ᠬ 砫.
INT PASCAL _export WinMain( HANDLE Instance, HANDLE PrevInstance, LPSTR CmdParam, INT CmdShow );
// ⠥ ன.
VOID ReadSettings( VOID );
// 뢠 ன.
VOID WriteSettings( VOID );
//    .
VOID CreateMenus( VOID );
// 뢠 .
VOID DestroyMenus( VOID );
//   .
VOID UpdateAllWindows( HWND Window );

// ࠡ稪 ᮮ饭, 室  ਫ - 뢠 ⮣,     ᮮ饭.
LRESULT CALLBACK _export WinProc( HWND Window, UINT Message, WPARAM wParam, LPARAM lParam );
//    .
VOID PaintWindow( HWND Window );
// ஢,   窠  .
BYTE IsPointVisible( INT X, INT Y, INT H );
//  梥  ⥬.
COLORREF MakeDarkColor( COLORREF Color );
//  ⨭.
VOID DrawBitmap( HDC Hdc, INT x, INT y, HBITMAP hBitmap );

// ࠡ稪 ᮡ⨩, 뢠  ।  ᮮ饭  譨 ன.
LRESULT CALLBACK _export KbdMouseHookProc( INT Code, WPARAM wParam, LPARAM lParam );
// ࠡ稪 ᮡ⨩, 뢠  ।  ᮮ饭  㣨 .
LRESULT CALLBACK _export CallWndHookProc( INT Code, WPARAM wParam, LPARAM lParam );
// ஢,   ᮢ ࠬ  .
BYTE PermissionForDrawing( HWND Window );
// ஢,    㪠⥫   .
BYTE PermissionForChanging( HWND Window );
// ஢,    । ࠦ  .
BYTE PermissionForScrolling( HWND Window );
// ஢,   । ࠦ   ५.
BYTE PermissionForKeyScrolling( HWND Window );
// ஢, ࠭ ,  .
BYTE IsActive( HWND Window );
// ஢,   㪠  ᪮ ᬮ.
BYTE IsScrollBar( HWND Window, BYTE Scroll_bars_only );
// 室     ᬮ  頥 㪠⥫  .
HWND FindScrollBar( HWND Window, INT Type );
// 뢠  ॡ   ᪥.
INT CALLBACK _export SBFindProc( HWND Current_window, LPARAM lParam );

//   ᯨ᮪ ,   । .
VOID AddWindowToList( HWND Window, UINT Message, LPARAM lParam );
// 室   ᯨ᪥  頥 1  0.
BYTE FindWindowInList( HWND Window );
//  窨  㪠 .
VOID GetPointsFromWindow( HWND Window );
//  窨  㪠   頥 ﭨ,  ஥  뫨 ᤢ.
INT FindPoints( HWND Window, WPARAM Direction, INT Supposition );
// ॢ 祭 梥  ⪮ ᫮.
BYTE ByteFromRGB( COLORREF Color ) { return ( GetRValue( Color ) / 3 + GetGValue( Color ) / 3 + GetBValue( Color ) / 3 ); }
//  ࠦ  ⮬ Scroll Lock.
VOID ScrollImage( WPARAM Key );
// 稭 । ࠦ   .
VOID BeginDragging( HWND Window, INT X, INT Y );
// । ࠦ  ࠭ .
VOID DragImage( INT X, INT Y );
// 蠥 । ࠦ   .
VOID EndDragging( VOID );

//  ࠬ  .
VOID DrawWindowFrame( HWND Window );
//  ࠬ  筮 .
VOID DrawNormalFrame( HWND Window );
//   ࠬ  筮 .
VOID DrawLines( HWND Window, DWORD Window_style );
//  ࠬ  1 .
VOID DrawPointFrame( HWND Window );
//  ࠬ   ﭭ ࠧ.
VOID DrawConstFrame( HWND Window );
//  ࠬ  ᪮ .
VOID DrawFlatFrame( HWND Window );
//  ࠬ  , 㬥襭  箪.
VOID DrawIconFrame( HWND Window );
//  ࠬ  .
VOID DrawMenuFrame( HWND Window );
//    ࠢ 孥 㣫 .
INT DrawButtons( HWND Window, BYTE Frame, DWORD Window_style, DWORD Window_xstyle, BYTE Pressed_button, BYTE Calc_rectangles_only );
//   .
VOID DrawCaption( HWND Window, BYTE Frame, BYTE Menu, BYTE Sysmenu_width, INT Button_width, BYTE SMPressed, BYTE Draw_sysmenu_only );
//  , ࠧ   ࠡ  .
VOID DrawDivisionLine( HWND Window, BYTE Frame );
// ࠡ뢠      .
BYTE AnimateButtons( HWND Window, UINT Message );
// 믮 ⢨  ⨨     .
VOID Action( HWND Window, BYTE Buton );
// 頥  筮 ﭨ , ஥ ࠭ .
VOID UnrollWindow( VOID );
// 뢠  .
VOID MoveWindowAbove( HWND Window );
//    ਫ.
HWND GetMainWindow( HWND Window );

//  㪠⥫ .
VOID ChangeMousePointer( VOID );
//   ⨨  .
VOID KeyClick( WPARAM Key, LPARAM Info );
// 砥/몫砥 Num Lock.
VOID SetNumLock( VOID );

// 饭, ஥ ࠡ뢠  CallWndHookProc().
struct CWMSG { LPARAM lParam; WPARAM wParam; UINT message; HWND hwnd; }; typedef CWMSG FAR* LPCWMSG;

// 騥 ६.
// ࠭,  ன ࠡ⠥ ਫ.
INT Code_page = GetKBCodePage();
//  ࠭.
INT FAR xScreen = GetSystemMetrics( SM_CXSCREEN ); INT FAR yScreen = GetSystemMetrics( SM_CYSCREEN );
//  ࠬ 筮 .
INT FAR xNormalFrame = GetSystemMetrics( SM_CXFRAME ); INT FAR yNormalFrame = GetSystemMetrics( SM_CYFRAME );
//  ࠬ  ﭭ ࠧ.
INT FAR xConstFrame = GetSystemMetrics( SM_CXDLGFRAME ); INT FAR yConstFrame = GetSystemMetrics( SM_CYDLGFRAME );
//   .
INT FAR yCaption = GetSystemMetrics( SM_CYCAPTION );
//  窠.
INT FAR xIcon = GetSystemMetrics( SM_CXICON ); INT FAR yIcon = GetSystemMetrics( SM_CYICON );
//  .
INT FAR yMenu = GetSystemMetrics( SM_CYMENU );
//  , ᫨  ࠭.
COLORREF FAR Color_of_caption = GetSysColor( COLOR_ACTIVECAPTION );
COLORREF FAR Color_of_caption_text = GetSysColor( COLOR_CAPTIONTEXT );
//  , ᫨   ࠭.
COLORREF FAR Color_of_inactive_caption = GetSysColor( COLOR_INACTIVECAPTION );
COLORREF FAR Color_of_inactive_text = GetSysColor( COLOR_INACTIVECAPTIONTEXT );

// ६  ࠡ ਫ.
// 뢠  Nice_win.dll.
HANDLE Res_Instance = NULL;
// , ᯮ  .
HWND FAR WinButton[ 6 ] = { NULL, NULL, NULL, NULL, NULL, NULL }; RECT FAR WinButton_Rect[ 6 ];
// ,  뢠  ⨨  .
HWND FAR WinMenu[ 17 ] = { NULL, NULL, NULL, NULL, NULL, NULL }; HBITMAP FAR WinMenu_bitmap[ 14 ];
// ⥫  KbdMouseHookProc()  ।騩 ࠡ稪.
HHOOK KbdMouseHook = NULL; HHOOK Defined_KbdMouseHook = NULL;
// ⥫  CallWndHookProc()  ।騩 ࠡ稪.
HHOOK CallWndHook = NULL; HHOOK Defined_CallWndHook = NULL;
// ⥫  SBFindProc().
WNDENUMPROC FAR SBFProc = NULL;

// ன.
//  । ࠦ  ᬮ ? 0 - , 1 - .
BYTE FAR Smooth_scrolling = 1;
//  ࠦ     ? 0 - , 1 - ᫨  ࠢ , 2 - , 3 - ।.
BYTE FAR Drag_image = 1;
// 㦭  ᤢ ࠦ    ⮬ Scroll Lock? 0 - , 1 - .
// 㦭  뫠 ᮮ饭   Alt, ⮡ ⪫ ? 0 - , 1 - .
BYTE FAR Key_scrolling = 1; BYTE FAR Disable_menu = 1;

//  ࠬ ?
BYTE FAR Paint_frames = 1;
//  ࠬ   ? 0 - , 1 - .
BYTE FAR Paint_normal_frames = 1;
//  ࠬ   ? 0 - , 1 - .
BYTE FAR Paint_point_frames = 1;
//  ࠬ   ﭭ ࠧ? 0 - , 1 - .
BYTE FAR Paint_const_frames = 1;
//  ࠬ  ᪨ ? 0 - , 1 - .
BYTE FAR Paint_flat_frames = 1;
//  窨 ਫ? 0 - , 1 - .
BYTE FAR Paint_icons = 1;
//  ? 0 - , 1 - .
BYTE FAR Paint_menus = 1;
// ᮢ    ࠢ 孥 㣫 ? 0 - , 1 - , 2 - ,   ࠢ.
BYTE FAR Draw_buttons = 1;
// ન ꥬ ? 0 - , 1 - , 2 - 㣫㡨 .
BYTE FAR Draw_captions = 1;
// ᮢ ⨭   孥 㣫 ? 0 - , 1 - .
BYTE FAR Draw_system_menu = 1;
// ᮢ  ? 0 - , 1 - .
BYTE FAR Draw_window_title = 1;
// ᮢ ꥬ   ? 0 - , 1 - .
BYTE FAR Draw_menus = 1;
// ᮢ , ࠧ   ࠡ  筮 ? 0 - , 1 - .
BYTE FAR Draw_normal_division_lines = 1;
// ᮢ , ࠧ   ࠡ  , 饣 ࠬ  1 ? 0 - , 1 - .
BYTE FAR Draw_point_division_lines = 0;

//   ᯮ짮 ࠢ    ࠡ  ᪠  ? 0 - , 1 - .
BYTE FAR Use_right_mouse_button = 1;
//  㪠⥫ ? 0 - , 1 - .
BYTE FAR Change_mouse_pointers = 0;
// 㦭  ८।  ? 0 - , 1 - .
BYTE FAR Define_right_Alt = 0; BYTE FAR Define_Mac_key = 1;
// 㦭   Num Lock   ⨨? 0 - 祬? 1 - , 2 - 몫.
BYTE FAR Num_Lock = 1;
// 㦥    ⨨  ? 0 -  㦥, 1 - 㦥.
BYTE FAR Key_click = 0;

//  㤥 룫拉 ? 0 -  ⨭, 1 - ஧筮, 2 - ஧筮.
BYTE FAR Background = 1; HBITMAP FAR Bitmap_for_background = NULL;
//  뢠 ?
CHAR FAR AppWindow_name[] = "Nice-Win :-)"; CHAR FAR AppWindow_title[] = ">>>";

// ᮪ ᪫祭.
//    । ? ६ - ப  SIZE_OF_NAME 㪢.
CHAR FAR Window_name[ SIZE_OF_NAME ]    = "";
// ६  ⥭ ᯨ᪠ ᪫祭.
CHAR FAR Exception[ SIZE_OF_NAME ]      = "";

// ᪨ ᬮ  ,    ᯮ짮 ࠢ   뢠 ⠪:
CHAR FAR ScrollBar_name[ SIZE_OF_NAME ] = "ScrollBar";
CHAR FAR FontLabSB_name[ SIZE_OF_NAME ] = "YBAR";
CHAR FAR Split123_name[ SIZE_OF_NAME ]  = "123WSplit";
CHAR FAR SplitWord_name[ SIZE_OF_NAME ] = "OpusRSB";

//  ,     ᮢ ࠬ. ਬ, 窨.
CHAR FAR Icon_name[ SIZE_OF_NAME ]      = "#32772";
CHAR FAR WPShell_name[ SIZE_OF_NAME ]   = "WhiteWind";
CHAR FAR Ecl_name[ SIZE_OF_NAME ]       = "OEcl";
CHAR FAR PdxDlg_name[ SIZE_OF_NAME ]    = "bordlgPdx";
CHAR FAR AppStudio1_name[ SIZE_OF_NAME ]= "Afx:8:40e";
CHAR FAR AppStudio2_name[ SIZE_OF_NAME ]= "Afx:0:40e";
CHAR FAR Marines_name[ SIZE_OF_NAME ]   = "Metal Mar";
CHAR FAR Clock_name[ SIZE_OF_NAME ]     = "Clock";
CHAR FAR FontMonger_name[ SIZE_OF_NAME ]= "kbFontMon";
//  - ᮢ뢠   짮⥫.
CHAR FAR Menu_name[ SIZE_OF_NAME ]      = "#32768";
// ᮪ ᪫祭,  짮⥫.
CHAR FAR RessSize[2] = "";
CHAR FAR RessName[16] = "";

CHAR FAR Exception_1[ SIZE_OF_NAME ]    = "";
CHAR FAR Exception_2[ SIZE_OF_NAME ]    = "";
CHAR FAR Exception_3[ SIZE_OF_NAME ]    = "";
CHAR FAR Exception_4[ SIZE_OF_NAME ]    = "";

//       㪠⥫  -   ࠢ ⠭  :
CHAR FAR Excel_name[ SIZE_OF_NAME ]     = "XLMAIN";
CHAR FAR Access_name[ SIZE_OF_NAME ]    = "OMain";
// ᮪ ᪫祭,  짮⥫.
CHAR FAR Exception_5[ SIZE_OF_NAME ]    = "";
CHAR FAR Exception_6[ SIZE_OF_NAME ]    = "";
CHAR FAR Exception_7[ SIZE_OF_NAME ]    = "";
CHAR FAR Exception_8[ SIZE_OF_NAME ]    = "";

//      । ࠦ     :
CHAR FAR MDIClient_name[ SIZE_OF_NAME ] = "MDIClient";
CHAR FAR ListView_name[ SIZE_OF_NAME ]  = "SysListVi";
CHAR FAR WinHelp_name[ SIZE_OF_NAME ]   = "MS_WINTOP";
CHAR FAR SdmDlg1_name[ SIZE_OF_NAME ]   = "bosa_sdm_";
CHAR FAR SdmDlg2_name[ SIZE_OF_NAME ]   = "_sdm_Micr";
CHAR FAR SdmDlg3_name[ SIZE_OF_NAME ]   = "_sdm_XL";
// ᮪ ᪫祭,  짮⥫.
CHAR FAR Exception_9[ SIZE_OF_NAME ]    = "";
CHAR FAR Exception_A[ SIZE_OF_NAME ]    = "";
CHAR FAR Exception_B[ SIZE_OF_NAME ]    = "";
CHAR FAR Exception_C[ SIZE_OF_NAME ]    = "";

//      । ࠦ   ५:
CHAR FAR Word_name[ SIZE_OF_NAME ]      = "OpusMwd";
CHAR FAR CModule_name[ SIZE_OF_NAME ]   = "C1Module";
CHAR FAR OModule_name[ SIZE_OF_NAME ]   = "OModule";
// ᮪ ᪫祭,  짮⥫.
CHAR FAR Exception_D[ SIZE_OF_NAME ]    = "";
CHAR FAR Exception_E[ SIZE_OF_NAME ]    = "";
CHAR FAR Exception_F[ SIZE_OF_NAME ]    = "";
CHAR FAR Exception_G[ SIZE_OF_NAME ]    = "";

// 窠 Windows 뢠 ⠪:
CHAR FAR Progman_name[ SIZE_OF_NAME ]   = "Progman";
// ᫨ ਫ 맢  Windows,  1,  0.
BYTE FAR Shell_is_Windows = 0;

// ६  ᪠ ᪨ ᬮ.
HWND FAR Found_window = NULL;
HWND FAR Scroll_bar = NULL; INT FAR Type_of_scroll_bar = NULL;

// ந室 ᮢ  ਫ.
BYTE FAR Painting = 0;

// । ࠦ  .
// ,  ஬ ந室 । ࠦ.
HWND FAR Scrolling_window = NULL;
//  ।   ࠦ .
BYTE FAR Disable_smooth_scrolling = 0;
// ᫨ 1  2,  । ⮫쪮 稭, ᫨ 0 -  த.
BYTE FAR Step_of_scrolling = 1;

// ६, ⮡  窨    '>',  ⥬ ᪠   । ᪮.
BYTE FAR Line_1[ SIZE_OF_LINE ]; BYTE FAR Line_2[ SIZE_OF_LINE ];
INT FAR Position_of_lines = 0;

// ᮪  ,     ࠦ. Name । , xV  yV - ᪮
// । ࠦ,    ᪮쪮 祪  ।, ᫨   ᪥
// ᬮ ன  . VBar  HBar 뢠,  ᢮  ⤥ ᮪  砥 ᮮ饭.
struct LIST { CHAR Name[ SIZE_OF_NAME ]; INT xV; INT yV; BYTE VBar; BYTE HBar; };
LIST FAR List[ SIZE_OF_LIST ];
//   ᯨ᪠. ᥣ   ᪥  ᥭ    .
LIST FAR Record_from_list;

// ,  ஬ । ࠦ.
HWND FAR Dragging_window = NULL; BYTE FAR InTravel = 0;
// ᪠ ᬮ  .
HWND FAR VSB_Control = NULL; HWND FAR HSB_Control = NULL;
//  ।.
INT FAR Dragging_window_xV = 0; INT FAR Dragging_window_yV = 0;
// 窠,  ன 稭 ।.
POINT FAR Begin_point = { 0, 0 };
// । 窠 - ⠭  ࠧ  ।.
POINT FAR Old_point = { 0, 0 };

// ⥫ , ᯮ㥬  । ࠦ.
BYTE FAR Name_of_cursor[ 16 ] = "DRAG_HAND_BLACK"; INT FAR Number_of_cursor = 1;
HCURSOR FAR Cursor_for_dragging = NULL;

//  譥  .
// ,   뫠 ᮢ ࠬ   㪠⥫.
HWND FAR Window_with_new_frame = NULL;
HWND FAR Window_with_new_pointer = NULL;

//   ᮢ ࠬ  , ஥ 뢠  ⨨ ࠢ  .
BYTE FAR Repaint_menu = 0;

// ᯮ    .
RECT FAR Max_button_Rect = { 0, 0, 0, 0 };
RECT FAR Min_button_Rect = { 0, 0, 0, 0 };
RECT FAR Rollup_button_Rect = { 0, 0, 0, 0 };
RECT FAR Close_button_Rect = { 0, 0, 0, 0 };

// 뢠,      :
// 0 -   , 1 - ⨭   孥 㣫 ,
// 2 - 㢥祭 ,    3 - 㬥襭  ᮪⨥ ,
// 4 - " ",    5 - ⨥ .
BYTE FAR Selected_button = 0;
//     ?
HWND FAR Selected_window = NULL; HWND FAR Prev_selected_window = NULL;

// ⨭   孥 㣫  - 箪  ࠦ  .
HICON FAR Sysmenu_icon = NULL;
HBITMAP FAR Sysmenu_bitmap = NULL;
HBITMAP FAR Max_Np_bitmap = NULL;
HBITMAP FAR Max_Pl_bitmap = NULL;
HBITMAP FAR Min_Np_bitmap = NULL;
HBITMAP FAR Min_Pl_bitmap = NULL;
HBITMAP FAR Maxed_Np_bitmap = NULL;
HBITMAP FAR Maxed_Pl_bitmap = NULL;
HBITMAP FAR Close_Np_bitmap = NULL;
HBITMAP FAR Close_Pl_bitmap = NULL;
HBITMAP FAR Rollup_Np_bitmap = NULL;
HBITMAP FAR Rollup_Pl_bitmap = NULL;
HBITMAP FAR Rolldown_Np_bitmap = NULL;
HBITMAP FAR Rolldown_Pl_bitmap = NULL;

//  룫廊  ?
CHAR FAR Window_caption[ 255 ];
CHAR FAR Wise_word[ 4 ] = ">>>";

// । , ஥ ࠭ .
HWND FAR Rolled_window = NULL;
// ᯮ  ࠭ , ஥ ࠭ .
RECT FAR Rolled_window_Rect = { 0, 0, 0, 0 };

// ᯮ ࠢ  ।  .
BYTE FAR Right_button_is_used = 0;

// ⥫ , ᯮ㥬     㪠⥫.
HCURSOR FAR Old_cursor_0 = NULL; HCURSOR FAR New_cursor_0 = NULL; HCURSOR FAR Old_cursor_1 = NULL; HCURSOR FAR New_cursor_1 = NULL;
HCURSOR FAR Old_cursor_2 = NULL; HCURSOR FAR New_cursor_2 = NULL; HCURSOR FAR Old_cursor_3 = NULL; HCURSOR FAR New_cursor_3 = NULL;
HCURSOR FAR Old_cursor_4 = NULL; HCURSOR FAR New_cursor_4 = NULL; HCURSOR FAR Old_cursor_5 = NULL; HCURSOR FAR New_cursor_5 = NULL;
HCURSOR FAR Old_cursor_6 = NULL; HCURSOR FAR New_cursor_6 = NULL; HCURSOR FAR Old_cursor_7 = NULL; HCURSOR FAR New_cursor_7 = NULL;
HCURSOR FAR Old_cursor_8 = NULL; HCURSOR FAR New_cursor_8 = NULL; HCURSOR FAR Old_cursor_9 = NULL; HCURSOR FAR New_cursor_9 = NULL;
HCURSOR FAR Old_cursor_A = NULL; HCURSOR FAR New_cursor_A = NULL;

//   ᯮ짮.
INT FAR Destroy_S6_smopuIM = GetVersion();

// .
#include "Plug-ins.h"

// --- ਫ. ---

#ifndef WINMAIN_IS_REPLACED
//  ⮣  稭 ࠡ ਫ.
// Instance  PrevInstance । ਫ, CmdParam -  祬 맢, CmdShow -   룫拉.
INT PASCAL _export WinMain( HANDLE Instance, HANDLE PrevInstance, LPSTR CmdParam, INT CmdShow )
{
 // ६, ।騥  ਫ.
 WNDCLASS Window_class; HWND Window = NULL;
 // 饭, ஥ । .
 MSG Message = { NULL, 0, 0, 0, 0, 0 };
 // 稪.
 INT Count = 0;

 // ᫨ ⨫ ன ࠧ - 室.
 if( PrevInstance != NULL ) { MessageBeep( MB_ICONEXCLAMATION ); return 0; }

 // 砥 Nice_win.dll.
 Res_Instance = LoadLibrary( (LPSTR) "Nice_win.dll" ); if( Res_Instance == NULL ) { MessageBeep( MB_ICONEXCLAMATION ); return 0; }

 // ।塞  ਫ.
 Window_class.hInstance = Instance; Window_class.lpszClassName = (LPSTR) AppWindow_name;
 //   ࠡ 㤥 ⢥ WinProc().
 Window_class.lpfnWndProc = (WNDPROC) WinProc;
 //  㤥 ஧.
 Window_class.hbrBackground = GetStockObject( NULL_BRUSH );
 // ।塞 㪠⥫  箪.
 Window_class.hCursor = LoadCursor( 0, IDC_ARROW ); Window_class.hIcon = LoadIcon( Res_Instance, "HAWK" );
 //    祣  ⭮.
 Window_class.style = NULL; Window_class.lpszMenuName = NULL; Window_class.cbClsExtra = NULL; Window_class.cbWndExtra = NULL;
 // ᫨  ।  㤠 - 室.
 if( RegisterClass( &Window_class ) == NULL )
  {
	//  - 訡.
   MessageBeep( MB_ICONEXCLAMATION );
	// ᢮ Nice_win.dll.
   if( Res_Instance != NULL ) FreeLibrary( Res_Instance );
   // 室.
   return 0;
  }

 // ⠭ ࠧ .
 // Window_Rect.right - ਭ . Window_Rect.bottom -  .
 RECT Window_Rect = { 0, 0, 0, 0 };
 Window_Rect.left = xScreen / 6; Window_Rect.top = yScreen / 3.5;
 Window_Rect.right = xScreen / 2.5; Window_Rect.bottom = yScreen / 2.2;

 // ᫨ ᯮ ࠭ VGA:
 if( xScreen == 640 ) { Window_Rect.right += 60; Window_Rect.bottom += 60; }

 //  .
 // ᫨ 㪠 WS_POPUP, =>  ⠫쭮   .
 //   ࠬ.
 //  Window = CreateWindow( AppWindow_name, AppWindow_title, WS_POPUP, Window_Rect.left, Window_Rect.top, Window_Rect.right, Window_Rect.bottom, HWND_DESKTOP, NULL, Instance, NULL );
 //  ࠬ  1 .
 //  Window = CreateWindow( AppWindow_name, AppWindow_title, WS_POPUP | WS_BORDER, Window_Rect.left, Window_Rect.top, Window_Rect.right, Window_Rect.bottom, HWND_DESKTOP, NULL, Instance, NULL );
 //   ﭭ ࠧ,   - ᪮ .
 //  Window = CreateWindow( AppWindow_name, AppWindow_title, WS_POPUP | WS_DLGFRAME, Window_Rect.left, Window_Rect.top, Window_Rect.right, Window_Rect.bottom, HWND_DESKTOP, NULL, Instance, NULL );
 //    ࠧ.
 //  Window = CreateWindow( AppWindow_name, AppWindow_title, WS_POPUP | WS_THICKFRAME, Window_Rect.left, Window_Rect.top, Window_Rect.right, Window_Rect.bottom, HWND_DESKTOP, NULL, Instance, NULL );
 //    ⮭ ࠬ.  , ᫨ 㪠 WS_BORDER  WS_DLGFRAME ६.
 //  Window = CreateWindow( AppWindow_name, AppWindow_title, WS_POPUP | WS_BORDER | WS_DLGFRAME, Window_Rect.left, Window_Rect.top, Window_Rect.right, Window_Rect.bottom, HWND_DESKTOP, NULL, Instance, NULL );
 //    ࠬ   ࠧ.
 //  Window = CreateWindow( AppWindow_name, AppWindow_title, WS_POPUP | WS_BORDER | WS_DLGFRAME | WS_THICKFRAME, Window_Rect.left, Window_Rect.top, Window_Rect.right, Window_Rect.bottom, HWND_DESKTOP, NULL, Instance, NULL );
 //  稨    .    ⢮.
 //  Window = CreateWindow( AppWindow_name, AppWindow_title, WS_POPUP | WS_BORDER | WS_DLGFRAME | WS_SYSMENU | WS_MAXIMIZEBOX, Window_Rect.left, Window_Rect.top, Window_Rect.right, Window_Rect.bottom, HWND_DESKTOP, NULL, Instance, NULL );

 //   ⠪  ᮧ  ﭭ ࠧ, 饥 :
 //  Window = CreateWindowEx( WS_EX_DLGMODALFRAME, AppWindow_name, AppWindow_title, WS_POPUP | WS_BORDER | WS_DLGFRAME, Window_Rect.left, Window_Rect.top, Window_Rect.right, Window_Rect.bottom, HWND_DESKTOP, NULL, Instance, NULL );
 //  ᪮  - ᫨ 㪠 WS_POPUP  WS_CHILD   WS_BORDER | WS_DLGFRAME:
 //  Window = CreateWindowEx( WS_EX_DLGMODALFRAME, AppWindow_name, AppWindow_title, WS_POPUP, Window_Rect.left, Window_Rect.top, Window_Rect.right, Window_Rect.bottom, HWND_DESKTOP, NULL, Instance, NULL );

 // ᫨ WS_POPUP  㪠,    㪠 WS_CHILD.  砥,   ᥣ
 // ᯮ  㣮 .  WS_CHILD   ᫥ ࠢ.
 // ᫨ 㪠 WS_POPUP,  WS_CHILD  .

 //   㪠뢠  WS_POPUP,  WS_CHILD.   㤥 ᮢ ⠪,  
 // WS_POPUP | WS_BORDER | WS_DLGFRAME 㦥 㪠.
 //    ⮭ ࠬ.
 //  Window = CreateWindow( AppWindow_name, AppWindow_title, 0, Window_Rect.left, Window_Rect.top, Window_Rect.right, Window_Rect.bottom, HWND_DESKTOP, NULL, Instance, NULL );
 //    ࠬ   ࠧ.
 //  Window = CreateWindow( AppWindow_name, AppWindow_title, WS_THICKFRAME, Window_Rect.left, Window_Rect.top, Window_Rect.right, Window_Rect.bottom, HWND_DESKTOP, NULL, Instance, NULL );
 //  稨    .    ⢮.
 //  Window = CreateWindow( AppWindow_name, AppWindow_title, WS_SYSMENU | WS_MAXIMIZEBOX, Window_Rect.left, Window_Rect.top, Window_Rect.right, Window_Rect.bottom, HWND_DESKTOP, NULL, Instance, NULL );

 //   ਫ.
 Window = CreateWindow( AppWindow_name, AppWindow_title, WS_POPUP | WS_BORDER | WS_DLGFRAME | WS_THICKFRAME | WS_SYSMENU | WS_MINIMIZEBOX, Window_Rect.left, Window_Rect.top, Window_Rect.right, Window_Rect.bottom, HWND_DESKTOP, NULL, Instance, NULL );

 // ᫨  ᮧ  㤠 - 室.
 if( Window == NULL )
  {
   //  - 訡.
	MessageBeep( MB_ICONEXCLAMATION );
	// ᢮ Nice_win.dll.
   if( Res_Instance != NULL ) FreeLibrary( Res_Instance );
	// 室.
   return 0;
  }

 //  ࠧ  ᮢ.
 RECT Rect = { 0, 0, 0, 0 }; GetClientRect( Window, &Rect );
 // Rect.top -   ᮢ.
 Rect.top = Rect.bottom;

 //  ࠧ .
 // WinButton_Rect[].right - ਭ . WinButton_Rect[].bottom -  .
 WinButton_Rect[ 0 ].left = 10;
 WinButton_Rect[ 0 ].top = 12;
 WinButton_Rect[ 0 ].right = Rect.right - 20;
 WinButton_Rect[ 0 ].bottom = ( Rect.top - 70 ) / 6;
 for( Count = 1; Count < 6; Count ++ )
  {
	WinButton_Rect[ Count ].left = 10;
	WinButton_Rect[ Count ].top = WinButton_Rect[ Count - 1 ].top + WinButton_Rect[ Count - 1 ].bottom + 10;
   WinButton_Rect[ Count ].right = Rect.right - 20;
	WinButton_Rect[ Count ].bottom = ( Rect.top - 70 ) / 6;
  }

 //    .  ᮤঠ  Nice_win.dll  롨  ᨬ  ࠭.
 if( Code_page == 866 ) Count = 0; else Count = 100;
 while( Count < 6 )
  {
   // 㦠 ப.
   LoadString( Res_Instance, Count, Window_caption, 255 );
   //  .
	WinButton[ Count ] = CreateWindow( "Button", Window_caption, WS_CHILD, WinButton_Rect[ Count ].left, WinButton_Rect[ Count ].top, WinButton_Rect[ Count ].right, WinButton_Rect[ Count ].bottom, Window, Count + 1, Instance, NULL );
   // 稢 稪.
   Count ++;
  }

 // ⠥ ன  Nice_win.ini
 ReadSettings();

 // ⠭ ४⥫  .
 SetNumLock();

 //  ,  뢠  ⨨  .
 CreateMenus();

 // 㦠 ⨭  ᮢ ⠢  .
 Bitmap_for_background = LoadBitmap( Res_Instance, "PAPER" );

 // 㦠 ⨭  ᮢ 窠   孥 㣫  .
 Sysmenu_bitmap = LoadBitmap( Res_Instance, "MENU" );
 Sysmenu_icon = LoadIcon( Res_Instance, "MENU" );
 strcpy(RessName,"MAXNP_");
 strcat(RessName,RessSize);
 Max_Np_bitmap = LoadBitmap( Res_Instance, RessName );
 strcpy(RessName,"MAXPL_");
 strcat(RessName,RessSize);
 Max_Pl_bitmap = LoadBitmap( Res_Instance, RessName );
 strcpy(RessName,"MINNP_");
 strcat(RessName,RessSize);
 Min_Np_bitmap = LoadBitmap( Res_Instance, RessName );
 strcpy(RessName,"MINPL_");
 strcat(RessName,RessSize);
 Min_Pl_bitmap = LoadBitmap( Res_Instance, RessName );
 strcpy(RessName,"MAXEDNP_");
 strcat(RessName,RessSize);
 Maxed_Np_bitmap = LoadBitmap( Res_Instance, RessName );
 strcpy(RessName,"MAXEDPL_");
 strcat(RessName,RessSize);
 Maxed_Pl_bitmap = LoadBitmap( Res_Instance, RessName );
 strcpy(RessName,"CLOSENP_");
 strcat(RessName,RessSize);
 Close_Np_bitmap = LoadBitmap( Res_Instance, RessName );
 strcpy(RessName,"CLOSEPL_");
 strcat(RessName,RessSize);
 Close_Pl_bitmap = LoadBitmap( Res_Instance, RessName );
 strcpy(RessName,"ROLLUPNP_");
 strcat(RessName,RessSize);
 Rollup_Np_bitmap = LoadBitmap( Res_Instance, RessName );
 strcpy(RessName,"ROLLUPPL_");
 strcat(RessName,RessSize);
 Rollup_Pl_bitmap = LoadBitmap( Res_Instance, RessName );
 strcpy(RessName,"ROLLDOWNNP_");
 strcat(RessName,RessSize);
 Rolldown_Np_bitmap = LoadBitmap( Res_Instance, RessName );
 strcpy(RessName,"ROLLDOWNPL_");
 strcat(RessName,RessSize);
 Rolldown_Pl_bitmap = LoadBitmap( Res_Instance, RessName );

 // 㦠 㪠⥫  । ࠦ     .
 Cursor_for_dragging = LoadCursor( Res_Instance, (LPSTR) Name_of_cursor );

 // 㦠 㪠⥫,   ᯮ짮  .
 New_cursor_0 = LoadCursor( Res_Instance, "ARROW" ); New_cursor_1 = LoadCursor( Res_Instance, "CROSS" );
 New_cursor_2 = LoadCursor( Res_Instance, "MOVE"  ); New_cursor_3 = LoadCursor( Res_Instance, "POINT" );
 New_cursor_4 = LoadCursor( Res_Instance, "SIZENESW" ); New_cursor_5 = LoadCursor( Res_Instance, "SIZENS" );
 New_cursor_6 = LoadCursor( Res_Instance, "SIZENWSE" ); New_cursor_7 = LoadCursor( Res_Instance, "SIZEWE" );
 New_cursor_8 = LoadCursor( Res_Instance, "TEXT" );  New_cursor_9 = LoadCursor( Res_Instance, "UPARROW" );
 New_cursor_A = LoadCursor( Res_Instance, "WAIT" );

 //  㪠⥫,  ᯮ   ᥩ.
 Old_cursor_0 = LoadCursor( NULL, IDC_ARROW );    Old_cursor_1 = LoadCursor( NULL, IDC_CROSS );
 Old_cursor_2 = LoadCursor( NULL, IDC_SIZE );     Old_cursor_3 = LoadCursor( NULL, IDC_ICON );
 Old_cursor_4 = LoadCursor( NULL, IDC_SIZENESW ); Old_cursor_5 = LoadCursor( NULL, IDC_SIZENS );
 Old_cursor_6 = LoadCursor( NULL, IDC_SIZENWSE ); Old_cursor_7 = LoadCursor( NULL, IDC_SIZEWE );
 Old_cursor_8 = LoadCursor( NULL, IDC_IBEAM );    Old_cursor_9 = LoadCursor( NULL, IDC_UPARROW );
 Old_cursor_A = LoadCursor( NULL, IDC_WAIT );

 // ᫨  ࠬ "/Hide" -  㤥 .
 if( lstrcmpi( CmdParam, "/Hide" ) == 0 ) CmdShow = SW_HIDE;
 else if( lstrcmpi( CmdParam, "-Hide" ) == 0 ) CmdShow = SW_HIDE;
 else if( lstrcmpi( CmdParam, "Hide" ) == 0 ) CmdShow = SW_HIDE;

 // ᫨   룫拉   窠 -  㤥 .
 if( CmdShow == SW_SHOWMINIMIZED || CmdShow == SW_SHOWMINNOACTIVE ) CmdShow = SW_HIDE;
 // 뢠  ਫ.
 ShowWindow( Window, CmdShow ); for( Count = 0; Count < 6; Count ++ ) ShowWindow( WinButton[ Count ], SW_SHOW );

 // ࠡ뢠 ᮮ饭, 室騥    . KbdMouseHookProc()  뢠
 // 直 ࠧ  ।   ᮮ饭  譨 ன.
 KbdMouseHook = (HHOOK) MakeProcInstance( (FARPROC) KbdMouseHookProc, Instance );
 Defined_KbdMouseHook = SetWindowsHookEx( WH_GETMESSAGE, (HOOKPROC) KbdMouseHookProc, Instance, NULL );

 // ࠡ뢠 ᮮ饭, 室騥  . CallWndHookProc()  뢠
 // 直 ࠧ  ।   ᮮ饭  㣮 .
 CallWndHook = (HHOOK) MakeProcInstance( (FARPROC) CallWndHookProc, Instance );
 Defined_CallWndHook = SetWindowsHookEx( WH_CALLWNDPROC, (HOOKPROC) CallWndHookProc, Instance, NULL );

 //  㪠⥫  SBFindProc(),   뢠  ᪥ ᮪.
 SBFProc = (WNDENUMPROC) MakeProcInstance( (FARPROC) SBFindProc, Instance );

 // , 맢  ਫ  Windows.
 if( FindWindow( Progman_name, NULL ) != NULL ) Shell_is_Windows = 1;

 // 塞  ਫ.
 if( CmdShow != SW_HIDE ) UpdateWindow( Window );
 // ᫨   ᯮ ⨭ - ᮢ뢠 ࠬ.
 if( Background == 0 )
  {
	// 뫠 ᮮ饭.
	PostMessage( Window, WM_NULL, 0, 0xABCDEF0 );
	//  .
	Window_with_new_frame = Message.hwnd;
  }

 // 塞  , 稭  ᠬ 孥.
 UpdateAllWindows( GetTopWindow( NULL ) );

 // 뢠 .
 Auxiliary_ApplicationStarted( Instance, CmdParam, CmdShow );

 // 祭  । ᮮ饭  ਫ -    㤥 .
 while( GetMessage( &Message, 0, 0, 0 ) ) DispatchMessage( &Message );

 // 뢠 .
 Auxiliary_ApplicationTerminated();

 // 뢠 㪠⥫  SBFindProc().
 FreeProcInstance( (FARPROC) SBFProc );

 //  ࠡ뢠  ᮮ饭  .
 UnhookWindowsHookEx( Defined_CallWndHook );
 FreeProcInstance( (FARPROC) CallWndHook );

 //  ࠡ뢠  ᮮ饭  譨 ன.
 UnhookWindowsHookEx( Defined_KbdMouseHook );
 FreeProcInstance( (FARPROC) KbdMouseHook );

 // 塞  , 稭  ᠬ 孥.
 UpdateAllWindows( GetTopWindow( NULL ) );

 // 뢠 ன  Nice_win.ini
 WriteSettings();

 // 뢠 .
 DestroyMenus();

 // 뢠 㪠⥫, 窨, ப  ⨭.
 DeleteObject( Sysmenu_bitmap );
 DeleteObject( Sysmenu_icon );
 DeleteObject( Bitmap_for_background );
 DeleteObject( Max_Np_bitmap );
 DeleteObject( Max_Pl_bitmap );
 DeleteObject( Min_Np_bitmap );
 DeleteObject( Min_Pl_bitmap );
 DeleteObject( Maxed_Np_bitmap );
 DeleteObject( Maxed_Pl_bitmap );
 DeleteObject( Close_Np_bitmap );
 DeleteObject( Close_Pl_bitmap );
 DeleteObject( Rollup_Np_bitmap );
 DeleteObject( Rollup_Pl_bitmap );
 DeleteObject( Rolldown_Np_bitmap );
 DeleteObject( Rolldown_Pl_bitmap );

 DeleteObject( Cursor_for_dragging );
 DeleteObject( New_cursor_0 ); DeleteObject( New_cursor_1 ); DeleteObject( New_cursor_2 );
 DeleteObject( New_cursor_3 ); DeleteObject( New_cursor_4 ); DeleteObject( New_cursor_5 );
 DeleteObject( New_cursor_6 ); DeleteObject( New_cursor_7 ); DeleteObject( New_cursor_8 );
 DeleteObject( New_cursor_9 ); DeleteObject( New_cursor_A );
 DeleteObject( Window_class.hIcon );

 // 뢠  ਫ.
 for( Count = 0; Count < 6; Count ++ ) DestroyWindow( WinButton[ Count ] );
 DestroyWindow( Window ); UnregisterClass( AppWindow_name, Instance );

 // ᢮ Nice_win.dll.
 if( Res_Instance != NULL ) FreeLibrary( Res_Instance );

 // 室.
 return 0;
}
#endif

// --- ⠥ ன. ---

#ifndef READ_SETTINGS_IS_REPLACED
// ⠥ ன.
VOID ReadSettings( VOID )
{
 //   ᯨ᪠ .
 INT Count = 0; CHAR StrCount[ 5 ] = "";

 // ன ਫ ᯮ  Nice_win.ini.
 CHAR Filename[ 50 ] = ""; GetWindowsDirectory( Filename, 50 ); lstrcat( Filename, "\\Nice_win.ini" );

 // ஢塞,   . ᫨ ,  ᮧ Nice_win.ini .
 #ifdef WATCOM_COMPILER
  INT File_of_settings = open( Filename, O_CREAT | O_BINARY | O_RDWR, S_IWRITE );
 #else
  INT File_of_settings = open( Filename, O_CREAT | O_BINARY, S_IWRITE );
 #endif

 // ᫨ Nice_win.ini  ᮧ :
 if( filelength( File_of_settings ) == 0 )
  {
	//   ᯮ  Nice_win.in-  ⠫ ਫ.
	#ifdef WATCOM_COMPILER
	 INT Source_file = open( "Nice_win.in-", O_BINARY | O_RDONLY );
	#else
	 INT Source_file = open( "Nice_win.in-", O_BINARY );
	#endif

	// ᫨ Nice_win.in- :
	if( Source_file != -1 )
	 {
	  // ७ᨬ ன  Nice_win.ini.
	  for( INT Position = 0; Position < filelength( Source_file ); Position ++ )
		{
		 BYTE Byte;
		 read( Source_file, &Byte, 1 );
		 write( File_of_settings, &Byte, 1 );
		}
	  // 뢠 Nice_win.in-.
	  close( Source_file );
	 }
  }

 // 뢠 Nice_win.ini.
 close( File_of_settings );

 // ⠥ ᯨ᮪ ᪫祭  Nice_win.ini.   ,     ᮢ
 // ࠬ,  㪠⥫    । ࠦ. ᮪   .
 GetPrivateProfileString( "Settings", "Ressource Size", "S", RessSize, 2, "Nice_win.ini" );

 GetPrivateProfileString( "Exceptions", "1. This window has one's own frame", "", Exception_1, SIZE_OF_NAME, "Nice_win.ini" );
 GetPrivateProfileString( "Exceptions", "2. This window has one's own frame", "", Exception_2, SIZE_OF_NAME, "Nice_win.ini" );
 GetPrivateProfileString( "Exceptions", "3. This window has one's own frame", "", Exception_3, SIZE_OF_NAME, "Nice_win.ini" );
 GetPrivateProfileString( "Exceptions", "4. This window has one's own frame", "", Exception_4, SIZE_OF_NAME, "Nice_win.ini" );

 GetPrivateProfileString( "Exceptions", "5. Do not change pointer in window", "", Exception_5, SIZE_OF_NAME, "Nice_win.ini" );
 GetPrivateProfileString( "Exceptions", "6. Do not change pointer in window", "", Exception_6, SIZE_OF_NAME, "Nice_win.ini" );
 GetPrivateProfileString( "Exceptions", "7. Do not change pointer in window", "", Exception_7, SIZE_OF_NAME, "Nice_win.ini" );
 GetPrivateProfileString( "Exceptions", "8. Do not change pointer in window", "", Exception_8, SIZE_OF_NAME, "Nice_win.ini" );

 GetPrivateProfileString( "Exceptions", "9. Ordinary scrolling is in window", "", Exception_9, SIZE_OF_NAME, "Nice_win.ini" );
 GetPrivateProfileString( "Exceptions", "A. Ordinary scrolling is in window", "", Exception_A, SIZE_OF_NAME, "Nice_win.ini" );
 GetPrivateProfileString( "Exceptions", "B. Ordinary scrolling is in window", "", Exception_B, SIZE_OF_NAME, "Nice_win.ini" );
 GetPrivateProfileString( "Exceptions", "C. Ordinary scrolling is in window", "", Exception_C, SIZE_OF_NAME, "Nice_win.ini" );

 GetPrivateProfileString( "Exceptions", "D. Do not use arrow keys in window", "", Exception_D, SIZE_OF_NAME, "Nice_win.ini" );
 GetPrivateProfileString( "Exceptions", "E. Do not use arrow keys in window", "", Exception_E, SIZE_OF_NAME, "Nice_win.ini" );
 GetPrivateProfileString( "Exceptions", "F. Do not use arrow keys in window", "", Exception_F, SIZE_OF_NAME, "Nice_win.ini" );
 GetPrivateProfileString( "Exceptions", "G. Do not use arrow keys in window", "", Exception_G, SIZE_OF_NAME, "Nice_win.ini" );

 // ⠥ ன.
 Smooth_scrolling = GetPrivateProfileInt( "Settings", "Smooth scrolling", Smooth_scrolling, "Nice_win.ini" );
 Key_scrolling = GetPrivateProfileInt( "Settings", "Key scrolling", Key_scrolling, "Nice_win.ini" );
 Disable_menu = GetPrivateProfileInt( "Settings", "Disable menu", Disable_menu, "Nice_win.ini" );
 Drag_image = GetPrivateProfileInt( "Settings", "Drag image", Drag_image, "Nice_win.ini" );
 Number_of_cursor = GetPrivateProfileInt( "Settings", "Number of cursor", Number_of_cursor, "Nice_win.ini" );

 Paint_frames = GetPrivateProfileInt( "Settings", "Paint frames", Paint_frames, "Nice_win.ini" );
 Paint_normal_frames = GetPrivateProfileInt( "Settings", "Paint normal frames", Paint_normal_frames, "Nice_win.ini" );
 Paint_point_frames = GetPrivateProfileInt( "Settings", "Paint point frames", Paint_point_frames, "Nice_win.ini" );
 Paint_const_frames = GetPrivateProfileInt( "Settings", "Paint const frames", Paint_const_frames, "Nice_win.ini" );
 Paint_flat_frames = GetPrivateProfileInt( "Settings", "Paint flat frames", Paint_flat_frames, "Nice_win.ini" );
 Paint_icons = GetPrivateProfileInt( "Settings", "Paint icons", Paint_icons, "Nice_win.ini" );
 Paint_menus = GetPrivateProfileInt( "Settings", "Paint menus", Paint_menus, "Nice_win.ini" );

 Draw_captions = GetPrivateProfileInt( "Settings", "Draw captions", Draw_captions, "Nice_win.ini" );
 Draw_system_menu = GetPrivateProfileInt( "Settings", "Draw system menu", Draw_system_menu, "Nice_win.ini" );
 Draw_window_title = GetPrivateProfileInt( "Settings", "Draw window title", Draw_window_title, "Nice_win.ini" );
 Draw_buttons = GetPrivateProfileInt( "Settings", "Draw buttons", Draw_buttons, "Nice_win.ini" );
 Draw_menus = GetPrivateProfileInt( "Settings", "Draw menus", Draw_menus, "Nice_win.ini" );
 Draw_normal_division_lines = GetPrivateProfileInt( "Settings", "Draw normal division lines", Draw_normal_division_lines, "Nice_win.ini" );
 Draw_point_division_lines = GetPrivateProfileInt( "Settings", "Draw point division lines", Draw_point_division_lines, "Nice_win.ini" );

 Use_right_mouse_button = GetPrivateProfileInt( "Settings", "Use right mouse button", Use_right_mouse_button, "Nice_win.ini" );
 Change_mouse_pointers = GetPrivateProfileInt( "Settings", "Change mouse pointers", Change_mouse_pointers, "Nice_win.ini" );
 Num_Lock = GetPrivateProfileInt( "Settings", "Num Lock", Num_Lock, "Nice_win.ini" );
 Define_right_Alt = GetPrivateProfileInt( "Settings", "Define right Alt", Define_right_Alt, "Nice_win.ini" );
 Define_Mac_key = GetPrivateProfileInt( "Settings", "Define Mac key", Define_Mac_key, "Nice_win.ini" );
 Key_click = GetPrivateProfileInt( "Settings", "Key click", Key_click, "Nice_win.ini" );

 Background = GetPrivateProfileInt( "Settings", "Background", Background, "Nice_win.ini" );

 // ⠥ ᯨ᮪   Nice_win.ini
 for( Count = 0; Count < SIZE_OF_LIST; Count ++ )
  {
	wsprintf( StrCount, "%d", Count );
	GetPrivateProfileString( "WinList", StrCount, "", List[  Count  ].Name, SIZE_OF_NAME, "Nice_win.ini" );
	List[  Count  ].yV = GetPrivateProfileInt( "WinYV", StrCount, 0, "Nice_win.ini" );
	List[  Count  ].xV = GetPrivateProfileInt( "WinXV", StrCount, 0, "Nice_win.ini" );
	List[  Count  ].VBar = GetPrivateProfileInt( "WinVBar", StrCount, 0, "Nice_win.ini" );
	List[  Count  ].HBar = GetPrivateProfileInt( "WinHBar", StrCount, 0, "Nice_win.ini" );
  }

 // 뢠 .
 Auxiliary_ReadSettings();

 // .
 return;
}
#endif

// --- 뢠 ன. ---

#ifndef WRITE_SETTINGS_IS_REPLACED
// 뢠 ன.
VOID WriteSettings( VOID )
{
 // ன  ᯨ᮪ .
 INT Count = 0; CHAR StrCount[ 5 ] = ""; CHAR String[ 5 ] = "";
 CHAR StrxV[ 5 ] = ""; CHAR StryV[ 5 ] = ""; CHAR StrVBar[ 5 ] = ""; CHAR StrHBar[ 5 ] = "";

 // 뢠  Nice_win.ini ᯨ᮪ ᪫祭, ᫨  ⮩ - , Nice_win.ini  .
 // ஢塞 ᯨ᮪ ᪫祭.
 GetPrivateProfileString( "Exceptions", "1. This window has one's own frame", "", Exception, SIZE_OF_NAME, "Nice_win.ini" );
 if( Exception[ 0 ] == NULL ) if( Exception[ 1 ] == NULL ) GetPrivateProfileString( "Exceptions", "2. This window has one's own frame", "", Exception, SIZE_OF_NAME, "Nice_win.ini" );
 if( Exception[ 0 ] == NULL ) if( Exception[ 1 ] == NULL ) GetPrivateProfileString( "Exceptions", "3. This window has one's own frame", "", Exception, SIZE_OF_NAME, "Nice_win.ini" );
 if( Exception[ 0 ] == NULL ) if( Exception[ 1 ] == NULL ) GetPrivateProfileString( "Exceptions", "4. This window has one's own frame", "", Exception, SIZE_OF_NAME, "Nice_win.ini" );

 if( Exception[ 0 ] == NULL ) if( Exception[ 1 ] == NULL ) GetPrivateProfileString( "Exceptions", "5. Do not change pointer in window", "", Exception, SIZE_OF_NAME, "Nice_win.ini" );
 if( Exception[ 0 ] == NULL ) if( Exception[ 1 ] == NULL ) GetPrivateProfileString( "Exceptions", "6. Do not change pointer in window", "", Exception, SIZE_OF_NAME, "Nice_win.ini" );
 if( Exception[ 0 ] == NULL ) if( Exception[ 1 ] == NULL ) GetPrivateProfileString( "Exceptions", "7. Do not change pointer in window", "", Exception, SIZE_OF_NAME, "Nice_win.ini" );
 if( Exception[ 0 ] == NULL ) if( Exception[ 1 ] == NULL ) GetPrivateProfileString( "Exceptions", "8. Do not change pointer in window", "", Exception, SIZE_OF_NAME, "Nice_win.ini" );

 if( Exception[ 0 ] == NULL ) if( Exception[ 1 ] == NULL ) GetPrivateProfileString( "Exceptions", "9. Ordinary scrolling is in window", "", Exception, SIZE_OF_NAME, "Nice_win.ini" );
 if( Exception[ 0 ] == NULL ) if( Exception[ 1 ] == NULL ) GetPrivateProfileString( "Exceptions", "A. Ordinary scrolling is in window", "", Exception, SIZE_OF_NAME, "Nice_win.ini" );
 if( Exception[ 0 ] == NULL ) if( Exception[ 1 ] == NULL ) GetPrivateProfileString( "Exceptions", "B. Ordinary scrolling is in window", "", Exception, SIZE_OF_NAME, "Nice_win.ini" );
 if( Exception[ 0 ] == NULL ) if( Exception[ 1 ] == NULL ) GetPrivateProfileString( "Exceptions", "C. Ordinary scrolling is in window", "", Exception, SIZE_OF_NAME, "Nice_win.ini" );

 if( Exception[ 0 ] == NULL ) if( Exception[ 1 ] == NULL ) GetPrivateProfileString( "Exceptions", "D. Do not use arrow keys in window", "", Exception, SIZE_OF_NAME, "Nice_win.ini" );
 if( Exception[ 0 ] == NULL ) if( Exception[ 1 ] == NULL ) GetPrivateProfileString( "Exceptions", "E. Do not use arrow keys in window", "", Exception, SIZE_OF_NAME, "Nice_win.ini" );
 if( Exception[ 0 ] == NULL ) if( Exception[ 1 ] == NULL ) GetPrivateProfileString( "Exceptions", "F. Do not use arrow keys in window", "", Exception, SIZE_OF_NAME, "Nice_win.ini" );
 if( Exception[ 0 ] == NULL ) if( Exception[ 1 ] == NULL ) GetPrivateProfileString( "Exceptions", "G. Do not use arrow keys in window", "", Exception, SIZE_OF_NAME, "Nice_win.ini" );

 // 뢠  Nice_win.ini ᯨ᮪ ᪫祭, ᫨  ⮩.
 if( Exception[ 0 ] == NULL ) if( Exception[ 1 ] == NULL )
  {
   WritePrivateProfileString( "Exceptions", "-----", "-----", "Nice_win.ini" );

   WritePrivateProfileString( "Exceptions", "1. This window has one's own frame", Exception_1, "Nice_win.ini" );
   WritePrivateProfileString( "Exceptions", "2. This window has one's own frame", Exception_2, "Nice_win.ini" );
   WritePrivateProfileString( "Exceptions", "3. This window has one's own frame", Exception_3, "Nice_win.ini" );
	WritePrivateProfileString( "Exceptions", "4. This window has one's own frame", Exception_4, "Nice_win.ini" );

	WritePrivateProfileString( "Exceptions", "---", "---", "Nice_win.ini" );

   WritePrivateProfileString( "Exceptions", "5. Do not change pointer in window", Exception_5, "Nice_win.ini" );
	WritePrivateProfileString( "Exceptions", "6. Do not change pointer in window", Exception_6, "Nice_win.ini" );
   WritePrivateProfileString( "Exceptions", "7. Do not change pointer in window", Exception_7, "Nice_win.ini" );
   WritePrivateProfileString( "Exceptions", "8. Do not change pointer in window", Exception_8, "Nice_win.ini" );

   WritePrivateProfileString( "Exceptions", "--", "--", "Nice_win.ini" );

	WritePrivateProfileString( "Exceptions", "9. Ordinary scrolling is in window", Exception_9, "Nice_win.ini" );
	WritePrivateProfileString( "Exceptions", "A. Ordinary scrolling is in window", Exception_A, "Nice_win.ini" );
   WritePrivateProfileString( "Exceptions", "B. Ordinary scrolling is in window", Exception_B, "Nice_win.ini" );
	WritePrivateProfileString( "Exceptions", "C. Ordinary scrolling is in window", Exception_C, "Nice_win.ini" );

   WritePrivateProfileString( "Exceptions", "----", "----", "Nice_win.ini" );

   WritePrivateProfileString( "Exceptions", "D. Do not use arrow keys in window", Exception_D, "Nice_win.ini" );
   WritePrivateProfileString( "Exceptions", "E. Do not use arrow keys in window", Exception_E, "Nice_win.ini" );
	WritePrivateProfileString( "Exceptions", "F. Do not use arrow keys in window", Exception_F, "Nice_win.ini" );
   WritePrivateProfileString( "Exceptions", "G. Do not use arrow keys in window", Exception_G, "Nice_win.ini" );

   WritePrivateProfileString( "Exceptions", "------", "------", "Nice_win.ini" );

	WritePrivateProfileString( "-------", "----", "----", "Nice_win.ini" );
  }

 // 뢠 ᫮  Nice_win.ini.
 WritePrivateProfileString( "Description", "Nice_Win", "A Win-OS/2 shell complements from Russia.", "Nice_win.ini" );
 WritePrivateProfileString( "Description", "Version", "2.1, march 1997 - september 1998.", "Nice_win.ini" );
 WritePrivateProfileString( "Description", "Status", "Free for all.", "Nice_win.ini" );
 WritePrivateProfileString( "Description", "Developer", "Sergey Posokhov.", "Nice_win.ini" );
 WritePrivateProfileString( "Description", "E-Mail", "<abc@posokhov.msk.ru>", "Nice_win.ini" );
 WritePrivateProfileString( "Description", "Smile", " :-)", "Nice_win.ini" );

 WritePrivateProfileString( "Russian description", "Nice_Win", "  窥 Win-OS/2.", "Nice_win.ini" );
 WritePrivateProfileString( "Russian description", "", "2.1,  1997 - ᥭ 1998.", "Nice_win.ini" );
 WritePrivateProfileString( "Russian description", "ﭨ", "  .", "Nice_win.ini" );
 WritePrivateProfileString( "Russian description", "ࠡ稪", "ࣥ 客.", "Nice_win.ini" );
 WritePrivateProfileString( "Russian description", "", "<abc@posokhov.msk.ru>", "Nice_win.ini" );
 WritePrivateProfileString( "Russian description", "롪", " :-)", "Nice_win.ini" );

 WritePrivateProfileString( "--------", "----", "-----", "Nice_win.ini" );

 // 뢠 ன.
 wsprintf( String, "%d", Smooth_scrolling );
 WritePrivateProfileString( "Settings", "Smooth scrolling", String, "Nice_win.ini" );
 wsprintf( String, "%d", Key_scrolling );
 WritePrivateProfileString( "Settings", "Key scrolling", String, "Nice_win.ini" );
 wsprintf( String, "%d", Disable_menu );
 WritePrivateProfileString( "Settings", "Disable menu", String, "Nice_win.ini" );
 wsprintf( String, "%d", Drag_image );
 WritePrivateProfileString( "Settings", "Drag image", String, "Nice_win.ini" );
 wsprintf( String, "%d", Number_of_cursor );
 WritePrivateProfileString( "Settings", "Number of cursor", String, "Nice_win.ini" );

 wsprintf( String, "%d", Paint_frames );
 WritePrivateProfileString( "Settings", "Paint frames", String, "Nice_win.ini" );
 wsprintf( String, "%d", Paint_normal_frames );
 WritePrivateProfileString( "Settings", "Paint normal frames", String, "Nice_win.ini" );
 wsprintf( String, "%d", Paint_point_frames );
 WritePrivateProfileString( "Settings", "Paint point frames", String, "Nice_win.ini" );
 wsprintf( String, "%d", Paint_const_frames );
 WritePrivateProfileString( "Settings", "Paint const frames", String, "Nice_win.ini" );
 wsprintf( String, "%d", Paint_flat_frames );
 WritePrivateProfileString( "Settings", "Paint flat frames", String, "Nice_win.ini" );
 wsprintf( String, "%d", Paint_icons );
 WritePrivateProfileString( "Settings", "Paint icons", String, "Nice_win.ini" );
 wsprintf( String, "%d", Paint_menus );
 WritePrivateProfileString( "Settings", "Paint menus", String, "Nice_win.ini" );

 wsprintf( String, "%d", Draw_captions );
 WritePrivateProfileString( "Settings", "Draw captions", String, "Nice_win.ini" );
 wsprintf( String, "%d", Draw_system_menu );
 WritePrivateProfileString( "Settings", "Draw system menu", String, "Nice_win.ini" );
 wsprintf( String, "%d", Draw_window_title );
 WritePrivateProfileString( "Settings", "Draw window title", String, "Nice_win.ini" );
 wsprintf( String, "%d", Draw_buttons );
 WritePrivateProfileString( "Settings", "Draw buttons", String, "Nice_win.ini" );
 wsprintf( String, "%d", Draw_menus );
 WritePrivateProfileString( "Settings", "Draw menus", String, "Nice_win.ini" );
 wsprintf( String, "%d", Draw_normal_division_lines );
 WritePrivateProfileString( "Settings", "Draw normal division lines", String, "Nice_win.ini" );
 wsprintf( String, "%d", Draw_point_division_lines );
 WritePrivateProfileString( "Settings", "Draw point division lines", String, "Nice_win.ini" );

 wsprintf( String, "%d", Use_right_mouse_button );
 WritePrivateProfileString( "Settings", "Use right mouse button", String, "Nice_win.ini" );
 wsprintf( String, "%d", Change_mouse_pointers );
 WritePrivateProfileString( "Settings", "Change mouse pointers", String, "Nice_win.ini" );
 wsprintf( String, "%d", Num_Lock );
 WritePrivateProfileString( "Settings", "Num Lock", String, "Nice_win.ini" );
 wsprintf( String, "%d", Define_right_Alt );
 WritePrivateProfileString( "Settings", "Define right Alt", String, "Nice_win.ini" );
 wsprintf( String, "%d", Define_Mac_key );
 WritePrivateProfileString( "Settings", "Define Mac key", String, "Nice_win.ini" );
 wsprintf( String, "%d", Key_click );
 WritePrivateProfileString( "Settings", "Key click", String, "Nice_win.ini" );

 wsprintf( String, "%d", Background );
 WritePrivateProfileString( "Settings", "Background", String, "Nice_win.ini" );

 // 뢠  Nice_win.ini  .
 for( Count = 0; Count < SIZE_OF_LIST; Count ++ )
  {
   wsprintf( StrCount, "%d", Count );
   wsprintf( StryV, "%d", List[  Count  ].yV );
   wsprintf( StrxV, "%d", List[  Count  ].xV );
   wsprintf( StrVBar, "%d", List[  Count  ].VBar );
   wsprintf( StrHBar, "%d", List[  Count  ].HBar );
	WritePrivateProfileString( "WinList", StrCount, List[  Count  ].Name, "Nice_win.ini" );
	WritePrivateProfileString( "WinYV", StrCount, StryV, "Nice_win.ini" );
   WritePrivateProfileString( "WinXV", StrCount, StrxV, "Nice_win.ini" );
	WritePrivateProfileString( "WinVBar", StrCount, StrVBar, "Nice_win.ini" );
   WritePrivateProfileString( "WinHBar", StrCount, StrHBar, "Nice_win.ini" );
  }

 // 뢠 .
 Auxiliary_WriteSettings();

 // .
 return;
}
#endif

// ---    . ---

#ifndef CREATE_MENUS_IS_REPLACED
// Res_Instance ।, 㤠 㦠 ப  .
VOID CreateMenus( VOID )
{
 // ।,   ࠦ ப .
 INT Flag = 0;

 // ப ᮤঠ  Nice_win.dll  롨  ᨬ  ࠭.
 INT Offset = 0; if( Code_page == 866 ) Offset = 0; else Offset = 100;

 //    .
 for( INT Count = 0; Count < 17; Count ++ ) WinMenu[ Count ] = CreatePopupMenu();

 // 0.  । ࠦ  .
 LoadString( Res_Instance, Offset + 10, Window_caption, 255 );
 if( Smooth_scrolling == 1 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 0 ], MF_STRING | Flag, 0, Window_caption );

 // 1. ᯮ짮 ५.
 LoadString( Res_Instance, Offset + 13, Window_caption, 255 );
 Flag = 0; if( Key_scrolling == 1 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 1 ], MF_STRING | Flag, 1, Window_caption );

 // 2.  ।  ⪫   .
 LoadString( Res_Instance, Offset + 14, Window_caption, 255 );
 Flag = 0; if( Disable_menu == 1 ) Flag = MF_CHECKED; if( Key_scrolling == 0 ) Flag |= MF_GRAYED;
 AppendMenu( WinMenu[ 1 ], MF_STRING | Flag, 2, Window_caption );

 //  ࠧ.
 AppendMenu( WinMenu[ 1 ], 0, 0, 0 );

 // 뢠 , ஥ ᮤন ப 1  2.
 LoadString( Res_Instance, Offset + 12, Window_caption, 255 );
 AppendMenu( WinMenu[ 0 ], MF_STRING | MF_POPUP, WinMenu[ 1 ], Window_caption );

 // 3. ᯮ짮 ࠢ    ।.
 LoadString( Res_Instance, Offset + 17, Window_caption, 255 );
 Flag = 0; if( Drag_image == 1 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 2 ], MF_STRING | Flag, 3, Window_caption );

 // 4. ᯮ짮     ।.
 LoadString( Res_Instance, Offset + 18, Window_caption, 255 );
 Flag = 0; if( Drag_image == 2 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 2 ], MF_STRING | Flag, 4, Window_caption );

 // 5. ᯮ짮 ।    ।.
 LoadString( Res_Instance, Offset + 19, Window_caption, 255 );
 Flag = 0; if( Drag_image == 3 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 2 ], MF_STRING | Flag, 5, Window_caption );

 // 뢠 , ஥ ᮤন ப 4  5.
 LoadString( Res_Instance, Offset + 16, Window_caption, 255 );
 Flag = 0; if( Smooth_scrolling == 0 ) Flag = MF_GRAYED;
 AppendMenu( WinMenu[ 0 ], MF_STRING | MF_POPUP | Flag, WinMenu[ 2 ], Window_caption );

 // 6 - 17.   㪠⥫   ।.
 WinMenu_bitmap[ 0 ] = LoadBitmap( Res_Instance, "DRAG_HAND_BLACK" );
 Flag = 0; if( Number_of_cursor == 1 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 3 ], MF_BITMAP | Flag, 6, (LPCSTR) WinMenu_bitmap[ 0 ] );

 WinMenu_bitmap[ 1 ] = LoadBitmap( Res_Instance, "DRAG_HAND_WHITE" );
 Flag = 0; if( Number_of_cursor == 2 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 3 ], MF_BITMAP | Flag, 7, (LPCSTR) WinMenu_bitmap[ 1 ] );

 WinMenu_bitmap[ 2 ] = LoadBitmap( Res_Instance, "DRAG_HAND_COLOR" );
 Flag = 0; if( Number_of_cursor == 3 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 3 ], MF_BITMAP | Flag, 8, (LPCSTR) WinMenu_bitmap[ 2 ] );

 WinMenu_bitmap[ 3 ] = LoadBitmap( Res_Instance, "DRAG_CAT_BLACK" );
 Flag = 0; if( Number_of_cursor == 4 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 3 ], MF_BITMAP | Flag, 9, (LPCSTR) WinMenu_bitmap[ 3 ] );

 WinMenu_bitmap[ 4 ] = LoadBitmap( Res_Instance, "DRAG_CAT_WHITE" );
 Flag = 0; if( Number_of_cursor == 5 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 3 ], MF_BITMAP | Flag, 10, (LPCSTR) WinMenu_bitmap[ 4 ] );

 WinMenu_bitmap[ 5 ] = LoadBitmap( Res_Instance, "DRAG_CAT_COLOR" );
 Flag = 0; if( Number_of_cursor == 6 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 3 ], MF_BITMAP | Flag, 11, (LPCSTR) WinMenu_bitmap[ 5 ] );

 WinMenu_bitmap[ 6 ] = LoadBitmap( Res_Instance, "DRAG_RAKE_BLACK" );
 Flag = 0; if( Number_of_cursor == 7 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 3 ], MF_BITMAP | Flag, 12, (LPCSTR) WinMenu_bitmap[ 6 ] );

 WinMenu_bitmap[ 7 ] = LoadBitmap( Res_Instance, "DRAG_RAKE_WHITE" );
 Flag = 0; if( Number_of_cursor == 8 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 3 ], MF_BITMAP | Flag, 13, (LPCSTR) WinMenu_bitmap[ 7 ] );

 WinMenu_bitmap[ 8 ] = LoadBitmap( Res_Instance, "DRAG_RAKE_COLOR" );
 Flag = 0; if( Number_of_cursor == 9 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 3 ], MF_BITMAP | Flag, 14, (LPCSTR) WinMenu_bitmap[ 8 ] );

 WinMenu_bitmap[ 9 ] = LoadBitmap( Res_Instance, "DRAG_LEAF" );
 Flag = 0; if( Number_of_cursor == 10 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 3 ], MF_BITMAP | Flag, 15, (LPCSTR) WinMenu_bitmap[ 9 ] );

 WinMenu_bitmap[ 10 ] = LoadBitmap( Res_Instance, "DRAG_MOVE" );
 Flag = 0; if( Number_of_cursor == 11 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 3 ], MF_BITMAP | Flag, 16, (LPCSTR) WinMenu_bitmap[ 10 ] );

 WinMenu_bitmap[ 11 ] = LoadBitmap( Res_Instance, "DRAG_ARROW" );
 Flag = 0; if( Number_of_cursor == 12 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 3 ], MF_BITMAP | Flag, 17, (LPCSTR) WinMenu_bitmap[ 11 ] );

 //  ࠧ.
 AppendMenu( WinMenu[ 3 ], 0, 0, 0 );

 // 뢠 , ஥ ᮤন ப 6 - 17.
 LoadString( Res_Instance, Offset + 20, Window_caption, 255 );
 Flag = 0; if( Drag_image == 0 ) Flag = MF_GRAYED;
 AppendMenu( WinMenu[ 2 ], MF_STRING | MF_POPUP | Flag, WinMenu[ 3 ], Window_caption );

 //  ࠧ.
 AppendMenu( WinMenu[ 2 ], 0, 0, 0 );

 //  ࠧ.
 AppendMenu( WinMenu[ 0 ], 0, 0, 0 );

 // 18. 맮 㪮⢠.
 LoadString( Res_Instance, Offset + 7, Window_caption, 255 );
 AppendMenu( WinMenu[ 0 ], MF_STRING, 18, Window_caption );

 // 19. .
 LoadString( Res_Instance, Offset + 8, Window_caption, 255 );
 AppendMenu( WinMenu[ 0 ], MF_STRING, 19, Window_caption );

 //  ࠧ.
 AppendMenu( WinMenu[ 0 ], 0, 0, 0 );

 // 20.  譥  .
 LoadString( Res_Instance, Offset + 22, Window_caption, 255 );
 Flag = 0; if( Paint_frames == 1 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 4 ], MF_STRING | Flag, 20, Window_caption );

 // 21.    .
 LoadString( Res_Instance, Offset + 25, Window_caption, 255 );
 Flag = 0; if( Paint_normal_frames == 1 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 5 ], MF_STRING | Flag, 21, Window_caption );

 // 22.   1 .
 LoadString( Res_Instance, Offset + 26, Window_caption, 255 );
 Flag = 0; if( Paint_point_frames == 1 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 5 ], MF_STRING | Flag, 22, Window_caption );

 // 23.    ﭭ ࠧ.
 LoadString( Res_Instance, Offset + 27, Window_caption, 255 );
 Flag = 0; if( Paint_const_frames == 1 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 5 ], MF_STRING | Flag, 23, Window_caption );

 // 24.   ᪨ .
 LoadString( Res_Instance, Offset + 28, Window_caption, 255 );
 Flag = 0; if( Paint_flat_frames == 1 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 5 ], MF_STRING | Flag, 24, Window_caption );

 // 25.   ,  㬥襭  窨.
 LoadString( Res_Instance, Offset + 29, Window_caption, 255 );
 Flag = 0; if( Paint_icons == 1 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 5 ], MF_STRING | Flag, 25, Window_caption );

 // 26.   .
 LoadString( Res_Instance, Offset + 30, Window_caption, 255 );
 Flag = 0; if( Paint_menus == 1 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 5 ], MF_STRING | Flag, 26, Window_caption );

 //  ࠧ.
 AppendMenu( WinMenu[ 5 ], 0, 0, 0 );

 // 뢠 , ஥ ᮤন ப 20 - 26.
 LoadString( Res_Instance, Offset + 24, Window_caption, 255 );
 Flag = 0; if( Paint_frames == 0 ) Flag = MF_GRAYED;
 AppendMenu( WinMenu[ 4 ], MF_STRING | MF_POPUP | Flag, WinMenu[ 5 ], Window_caption );

 // 27. 㡨   - ⪫祭.
 LoadString( Res_Instance, Offset + 33, Window_caption, 255 );
 Flag = MF_GRAYED; if( Draw_captions == 2 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 6 ], MF_STRING | Flag, 27, Window_caption );

 // 28. ન ꥬ .
 LoadString( Res_Instance, Offset + 34, Window_caption, 255 );
 Flag = 0; if( Draw_captions == 1 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 6 ], MF_STRING | Flag, 28, Window_caption );

 // 뢠 , ஥ ᮤন ப 27  28.
 LoadString( Res_Instance, Offset + 32, Window_caption, 255 );
 AppendMenu( WinMenu[ 4 ], MF_STRING | MF_POPUP, WinMenu[ 6 ], Window_caption );

 //  ࠧ.
 AppendMenu( WinMenu[ 4 ], 0, 0, 0 );

 // 18. 맮 㪮⢠.
 LoadString( Res_Instance, Offset + 7, Window_caption, 255 );
 AppendMenu( WinMenu[ 4 ], MF_STRING, 18, Window_caption );

 // 19. .
 LoadString( Res_Instance, Offset + 8, Window_caption, 255 );
 AppendMenu( WinMenu[ 4 ], MF_STRING, 19, Window_caption );

 //  ࠧ.
 AppendMenu( WinMenu[ 4 ], 0, 0, 0 );

 // 29. ⨭   孥 㣫 .
 LoadString( Res_Instance, Offset + 37, Window_caption, 255 );
 Flag = 0; if( Draw_system_menu == 1 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 7 ], MF_STRING | Flag, 29, Window_caption );

 // 30.  .
 LoadString( Res_Instance, Offset + 38, Window_caption, 255 );
 Flag = 0; if( Draw_window_title == 1 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 7 ], MF_STRING | Flag, 30, Window_caption );

 // 31 - 33.  룫    .
 LoadString( Res_Instance, Offset + 42, Window_caption, 255 );
 Flag = 0; if( Draw_buttons == 0 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 8 ], MF_STRING | Flag, 31, Window_caption );

 // 32.   ᫥.
 WinMenu_bitmap[ 12 ] = LoadBitmap( Res_Instance, "BUTTONS-1" );
 Flag = 0; if( Draw_buttons == 1 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 8 ], MF_BITMAP | Flag, 32, (LPCSTR) WinMenu_bitmap[ 12 ] );

 // 32.   ࠢ.
 WinMenu_bitmap[ 13 ] = LoadBitmap( Res_Instance, "BUTTONS-2" );
 Flag = 0; if( Draw_buttons == 2 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 8 ], MF_BITMAP | Flag, 33, (LPCSTR) WinMenu_bitmap[ 13 ] );

 //  ࠧ.
 AppendMenu( WinMenu[ 8 ], 0, 0, 0 );

 // 뢠 , ஥ ᮤন ப 31  32.
 LoadString( Res_Instance, Offset + 41, Window_caption, 255 );
 AppendMenu( WinMenu[ 7 ], MF_STRING | MF_POPUP, WinMenu[ 8 ], Window_caption );

 // 34. ᮢ  .
 LoadString( Res_Instance, Offset + 39, Window_caption, 255 );
 Flag = 0; if( Draw_menus == 1 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 7 ], MF_STRING | Flag, 34, Window_caption );

 // 35.  ࠧ   .
 LoadString( Res_Instance, Offset + 45, Window_caption, 255 );
 Flag = 0; if( Draw_normal_division_lines == 1 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 9 ], MF_STRING | Flag, 35, Window_caption );

 // 36.  ࠧ  ,   ࠬ  1 .
 LoadString( Res_Instance, Offset + 46, Window_caption, 255 );
 Flag = 0; if( Draw_point_division_lines == 1 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 9 ], MF_STRING | Flag, 36, Window_caption );

 //  ࠧ.
 AppendMenu( WinMenu[ 9 ], 0, 0, 0 );

 // 뢠 , ஥ ᮤন ப 35  36.
 LoadString( Res_Instance, Offset + 44, Window_caption, 255 );
 AppendMenu( WinMenu[ 7 ], MF_STRING | MF_POPUP, WinMenu[ 9 ], Window_caption );

 //  ࠧ.
 AppendMenu( WinMenu[ 7 ], 0, 0, 0 );

 // 뢠 , ஥ ᮤন ப 29 - 34.
 LoadString( Res_Instance, Offset + 36, Window_caption, 255 );
 Flag = 0; if( Draw_captions != 1 ) Flag = MF_GRAYED;
 AppendMenu( WinMenu[ 6 ], MF_STRING | MF_POPUP | Flag, WinMenu[ 7 ], Window_caption );

 //  ࠧ.
 AppendMenu( WinMenu[ 6 ], 0, 0, 0 );

 // 37. ⢨ ࠢ  .
 LoadString( Res_Instance, Offset + 48, Window_caption, 255 );
 Flag = 0; if( Use_right_mouse_button == 1 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 10 ], MF_STRING | Flag, 37, Window_caption );

 // 38.  㪠⥫  - ⪫祭.
 LoadString( Res_Instance, Offset + 49, Window_caption, 255 );
 Flag = MF_GRAYED; if( Change_mouse_pointers == 1 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 10 ], MF_STRING | Flag, 38, Window_caption );

 // 39.  Num Lock.
 LoadString( Res_Instance, Offset + 52, Window_caption, 255 );
 Flag = 0; if( Num_Lock == 1 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 11 ], MF_STRING | Flag, 39, Window_caption );

 // 40. 몫 Num Lock.
 LoadString( Res_Instance, Offset + 53, Window_caption, 255 );
 Flag = 0; if( Num_Lock == 2 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 11 ], MF_STRING | Flag, 40, Window_caption );

 //  ࠧ.
 AppendMenu( WinMenu[ 11 ], 0, 0, 0 );

 // 뢠 , ஥ ᮤন ப 39  40.
 LoadString( Res_Instance, Offset + 51, Window_caption, 255 );
 AppendMenu( WinMenu[ 10 ], MF_STRING | MF_POPUP, WinMenu[ 11 ], Window_caption );

 // 41. ᮪   ࠢ 'Alt'.
 LoadString( Res_Instance, Offset + 56, Window_caption, 255 );
 Flag = 0; if( Define_right_Alt == 1 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 12 ], MF_STRING | Flag, 41, Window_caption );

 // 42. ८। '|\'.
 LoadString( Res_Instance, Offset + 57, Window_caption, 255 );
 Flag = 0; if( Define_Mac_key == 1 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 12 ], MF_STRING | Flag, 42, Window_caption );

 //  ࠧ.
 AppendMenu( WinMenu[ 12 ], 0, 0, 0 );

 // 뢠 , ஥ ᮤন ப 41  42.
 LoadString( Res_Instance, Offset + 55, Window_caption, 255 );
 AppendMenu( WinMenu[ 10 ], MF_STRING | MF_POPUP, WinMenu[ 12 ], Window_caption );

 // 43.   ⨨ .
 LoadString( Res_Instance, Offset + 59, Window_caption, 255 );
 Flag = 0; if( Key_click == 1 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 10 ], MF_STRING | Flag, 43, Window_caption );

 //  ࠧ.
 AppendMenu( WinMenu[ 10 ], 0, 0, 0 );

 // 18. 맮 㪮⢠.
 LoadString( Res_Instance, Offset + 7, Window_caption, 255 );
 AppendMenu( WinMenu[ 10 ], MF_STRING, 18, Window_caption );

 // 19. .
 LoadString( Res_Instance, Offset + 8, Window_caption, 255 );
 AppendMenu( WinMenu[ 10 ], MF_STRING, 19, Window_caption );

 //  ࠧ.
 AppendMenu( WinMenu[ 10 ], 0, 0, 0 );

 // 44. ஧筮  ਫ.
 LoadString( Res_Instance, Offset + 62, Window_caption, 255 );
 Flag = 0; if( Background == 1 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 14 ], MF_STRING | Flag, 44, Window_caption );

 // 45. ஧筮 .
 LoadString( Res_Instance, Offset + 63, Window_caption, 255 );
 Flag = 0; if( Background == 2 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 14 ], MF_STRING | Flag, 45, Window_caption );

 // 46. ⨭  .
 LoadString( Res_Instance, Offset + 64, Window_caption, 255 );
 Flag = 0; if( Background == 0 ) Flag = MF_CHECKED;
 AppendMenu( WinMenu[ 14 ], MF_STRING | Flag, 46, Window_caption );

 //  ࠧ.
 AppendMenu( WinMenu[ 14 ], 0, 0, 0 );

 // 뢠 , ஥ ᮤন ப 45  46.
 LoadString( Res_Instance, Offset + 61, Window_caption, 255 );
 AppendMenu( WinMenu[ 13 ], MF_STRING | MF_POPUP, WinMenu[ 14 ], Window_caption );

 // 47. ⠭ ன  OS/2.
 LoadString( Res_Instance, Offset + 67, Window_caption, 255 );
 AppendMenu( WinMenu[ 15 ], MF_STRING, 47, Window_caption );

 // 48. ⠭ ன.
 LoadString( Res_Instance, Offset + 68, Window_caption, 255 );
 AppendMenu( WinMenu[ 15 ], MF_STRING, 48, Window_caption );

 //  ࠧ.
 AppendMenu( WinMenu[ 15 ], 0, 0, 0 );

 // 뢠 , ஥ ᮤন ப 47  48.
 LoadString( Res_Instance, Offset + 66, Window_caption, 255 );
 AppendMenu( WinMenu[ 13 ], MF_STRING | MF_POPUP, WinMenu[ 15 ], Window_caption );

 // 49 - 60. ᮪ ,  뫨 ᥭ 짮⥫ﬨ.
 LoadString( Res_Instance, Offset + 71, Window_caption, 255 );
 AppendMenu( WinMenu[ 16 ], MF_STRING | MF_GRAYED, 49, Window_caption );

 // .
 Auxiliary_AppendMenus( Offset );

 //  ࠧ.
 AppendMenu( WinMenu[ 16 ], 0, 0, 0 );

 // 뢠 , ஥ ᮤন ப 49 - 60.
 LoadString( Res_Instance, Offset + 70, Window_caption, 255 );
 AppendMenu( WinMenu[ 13 ], MF_STRING | MF_POPUP, WinMenu[ 16 ], Window_caption );

 //  ࠧ.
 AppendMenu( WinMenu[ 13 ], 0, 0, 0 );

 // 18. 맮 㪮⢠.
 LoadString( Res_Instance, Offset + 7, Window_caption, 255 );
 AppendMenu( WinMenu[ 13 ], MF_STRING, 18, Window_caption );

 // 19. .
 LoadString( Res_Instance, Offset + 8, Window_caption, 255 );
 AppendMenu( WinMenu[ 13 ], MF_STRING, 19, Window_caption );

 //  ࠧ.
 AppendMenu( WinMenu[ 13 ], 0, 0, 0 );

 // .
 return;
}
#endif

// --- 뢠 . ---

#ifndef DESTROY_MENUS_IS_REPLACED
// 뢠 .
VOID DestroyMenus( VOID )
{
 // 稪.
 INT Count = 0;

 // 뢠 .
 for( Count = 0; Count < 17; Count ++ ) DestroyMenu( WinMenu[ Count ] );
 for( Count = 0; Count < 14; Count ++ ) DeleteObject( WinMenu_bitmap[ Count ] );

 // .
 return;
}
#endif

// ---   . ---

#ifndef UPDATE_ALL_WINDOWS_IS_REPLACED
//   . Window ।  ਫ  ᠬ 孥 .
VOID UpdateAllWindows( HWND Window )
{
 // ᫨    - .
 if( Window == NULL ) return;

 //  .
 RECT Rect = { 0, 0, 0, 0 };

 // ᫨   :
 if( PermissionForDrawing( Window ) != 0 ) if( IsWindowVisible( Window ) ) if( !IsIconic( Window ) )
  {
   //  ࠧ .
	// Rect.top  Rect.left -  孨 㣮. Rect.right  Rect.bottom - ࠢ .
   GetWindowRect( Window, &Rect );
	//    ।  .
   MoveWindow( Window, xScreen * 2, yScreen * 2, ( Rect.right - Rect.left ) / 2, ( Rect.bottom - Rect.top ) / 2, 1 );
   //  ⥯ ୥  .
	MoveWindow( Window, Rect.left, Rect.top, Rect.right - Rect.left, Rect.bottom - Rect.top, 1 );
  }

 //  ࢮ   ᯨ᪥ .
 HWND First_window = GetWindow( Window, GW_HWNDFIRST );
 //  ᫥   ᯨ᪥ .
 HWND Last_window = GetWindow( Window, GW_HWNDLAST );
 // ᫨   - .
 if( First_window == NULL || Last_window == NULL ) return;

 // 塞  .
 HWND Next_window = First_window;
 while( 1 )
  {
   // 뢠 ᮤন .
	if( PermissionForDrawing( Next_window ) != 0 ) if( IsWindowVisible( Next_window ) ) if( !IsIconic( Next_window ) )
    {
	  //  ࠧ .
     // Rect.top  Rect.left -  孨 㣮. Rect.right  Rect.bottom - ࠢ .
     GetWindowRect( Next_window, &Rect );
	  //    ।  .
     MoveWindow( Next_window, xScreen * 2, yScreen * 2, ( Rect.right - Rect.left ) / 2, ( Rect.bottom - Rect.top ) / 2, 1 );
     //  ⥯ ୥  .
     MoveWindow( Next_window, Rect.left, Rect.top, Rect.right - Rect.left, Rect.bottom - Rect.top, 1 );
    }

	// ᫨ ᬮ७  :
	if( Next_window == Last_window ) break;

	//  ᫥饥 .
   Next_window = GetNextWindow( Next_window, GW_HWNDNEXT );
  }

 // .
 return;
}
#endif

// --- ࠡ稪 ᮮ饭, 室  ਫ. ---

#ifndef WINPROC_IS_REPLACED
// Win-OS/2 뢠 WinProc() 直 ࠧ,     ᮮ饭.
// Window ।  , Message - ᮮ饭  , wParam  lParam - . ᢥ.
LRESULT CALLBACK _export WinProc( HWND Window, UINT Message, WPARAM wParam, LPARAM lParam )
{
 // ६  । ࠧ .
 RECT Rect = { 0, 0, 0, 0 };

 // 饭:
 INT Count = 0;
 switch( Message )
  {
   // ᫨  ᮢ :
   case WM_PAINT:
    // ᫨  㦥 ,    .
	 if( !Painting )
     {
		Painting = 1;
      PaintWindow( Window );
      Painting = 0;
	  }
   break;

   // ᫨  ࠭  ।:
   case WM_SETFOCUS:
   case WM_MOVE:
	 //  ᮢ .
	 InvalidateRect( Window, NULL, 1 );
   break;

   // ᫨ ࠧ  :
   case WM_SIZE:
    //  ࠧ  ᮢ.
    GetClientRect( Window, &Rect );
    // Rect.top -   ᮢ.
	 Rect.top = Rect.bottom;

	 //  ࠧ .
    // WinButton_Rect[].right - ਭ . WinButton_Rect[].bottom -  .
    WinButton_Rect[ 0 ].left = 10;
	 WinButton_Rect[ 0 ].top = 12;
    WinButton_Rect[ 0 ].right = Rect.right - 20;
    WinButton_Rect[ 0 ].bottom = ( Rect.top - 70 ) / 6;
    for( Count = 1; Count < 6; Count ++ )
     {
      WinButton_Rect[ Count ].left = 10;
		WinButton_Rect[ Count ].top = WinButton_Rect[ Count - 1 ].top + WinButton_Rect[ Count - 1 ].bottom + 10;
		WinButton_Rect[ Count ].right = Rect.right - 20;
      WinButton_Rect[ Count ].bottom = ( Rect.top - 70 ) / 6;
	  }

    // । .
    for( Count = 0; Count < 6; Count ++ )
     MoveWindow( WinButton[ Count ], WinButton_Rect[ Count ].left, WinButton_Rect[ Count ].top, WinButton_Rect[ Count ].right, WinButton_Rect[ Count ].bottom, 1 );

	 //  ᮢ .
    InvalidateRect( Window, NULL, 1 );
	break;

   // ᫨  :
	case WM_KEYDOWN:
    // ᫨ F1 - 뢠 㪮⢮.
    if( wParam == VK_F1 ) PostMessage( Window, WM_COMMAND, 18, 0 );
    // ᫨ ESC -  .
    if( wParam == VK_ESCAPE ) DestroyWindow( Window );
   break;

	// ᫨      ࠭ ப :
   case WM_COMMAND:
	 // ᫨    :
    if( lParam != 0 )
     {
      //  ࠧ .
      GetWindowRect( Window, &Rect );

		//  ⨨   믮 । ⢨.
      if( LOWORD( lParam ) == WinButton[ 0 ] ) TrackPopupMenu( WinMenu[ 0 ], 0, Rect.left + xNormalFrame + WinButton_Rect[ 0 ].left + WinButton_Rect[ 0 ].right + 5, Rect.top + yNormalFrame + yCaption + WinButton_Rect[ 0 ].top + WinButton_Rect[ 0 ].bottom / 2, 0, Window, 0 );
		else if( LOWORD( lParam ) == WinButton[ 1 ] ) TrackPopupMenu( WinMenu[ 4 ], 0, Rect.left + xNormalFrame + WinButton_Rect[ 1 ].left + WinButton_Rect[ 1 ].right + 5, Rect.top + yNormalFrame + yCaption + WinButton_Rect[ 1 ].top + WinButton_Rect[ 1 ].bottom / 2, 0, Window, 0 );
      else if( LOWORD( lParam ) == WinButton[ 2 ] ) TrackPopupMenu( WinMenu[ 10 ], 0, Rect.left + xNormalFrame + WinButton_Rect[ 2 ].left + WinButton_Rect[ 2 ].right + 5, Rect.top + yNormalFrame + yCaption + WinButton_Rect[ 2 ].top + WinButton_Rect[ 2 ].bottom / 2, 0, Window, 0 );
      else if( LOWORD( lParam ) == WinButton[ 3 ] ) TrackPopupMenu( WinMenu[ 13 ], 0, Rect.left + xNormalFrame + WinButton_Rect[ 3 ].left + WinButton_Rect[ 3 ].right + 5, Rect.top + yNormalFrame + yCaption + WinButton_Rect[ 3 ].top + WinButton_Rect[ 3 ].bottom / 2, 0, Window, 0 );
		else if( LOWORD( lParam ) == WinButton[ 4 ] ) ShowWindow( Window, SW_MINIMIZE );
      else if( LOWORD( lParam ) == WinButton[ 5 ] ) DestroyWindow( Window );
     }
    // ᫨ ࠭ ப :
    else
     {
		// ਬ,  ப ࠭,  ⠭ ᮮ⢥騥 ६.
		switch( wParam )
       {
		  // ⠭ ६.
        case 0: if( Smooth_scrolling != 1 ) Smooth_scrolling = 1; else Smooth_scrolling = 0; break;
        case 1: if( Key_scrolling != 1 ) Key_scrolling = 1; else Key_scrolling = 0; break;
        case 2: if( Disable_menu != 1 ) Disable_menu = 1; else Disable_menu = 0; break;
        case 3: if( Drag_image != 1 ) Drag_image = 1; else Drag_image = 0; break;
        case 4: if( Drag_image != 2 ) Drag_image = 2; else Drag_image = 0; break;
		  case 5: if( Drag_image != 3 ) Drag_image = 3; else Drag_image = 0; break;
        case 6: Number_of_cursor = 1; lstrcpy( (LPSTR) Name_of_cursor, "DRAG_HAND_BLACK" ); break;
		  case 7: Number_of_cursor = 2; lstrcpy( (LPSTR) Name_of_cursor, "DRAG_HAND_WHITE" ); break;
        case 8: Number_of_cursor = 3; lstrcpy( (LPSTR) Name_of_cursor, "DRAG_HAND_COLOR" ); break;
        case 9: Number_of_cursor = 4; lstrcpy( (LPSTR) Name_of_cursor, "DRAG_CAT_BLACK" ); break;
		  case 10: Number_of_cursor = 5; lstrcpy( (LPSTR) Name_of_cursor, "DRAG_CAT_WHITE" ); break;
        case 11: Number_of_cursor = 6; lstrcpy( (LPSTR) Name_of_cursor, "DRAG_CAT_COLOR" ); break;
        case 12: Number_of_cursor = 7; lstrcpy( (LPSTR) Name_of_cursor, "DRAG_RAKE_BLACK" ); break;
        case 13: Number_of_cursor = 8; lstrcpy( (LPSTR) Name_of_cursor, "DRAG_RAKE_WHITE" ); break;
        case 14: Number_of_cursor = 9; lstrcpy( (LPSTR) Name_of_cursor, "DRAG_RAKE_COLOR" ); break;
        case 15: Number_of_cursor = 10; lstrcpy( (LPSTR) Name_of_cursor, "DRAG_LEAF" ); break;
		  case 16: Number_of_cursor = 11; lstrcpy( (LPSTR) Name_of_cursor, "DRAG_MOVE" ); break;
		  case 17: Number_of_cursor = 12; lstrcpy( (LPSTR) Name_of_cursor, "DRAG_ARROW" ); break;
        case 20: if( Paint_frames != 1 ) Paint_frames = 1; else { Paint_frames = 0; UnrollWindow(); } break;
		  case 21: if( Paint_normal_frames != 1 ) Paint_normal_frames = 1; else Paint_normal_frames = 0; break;
        case 22: if( Paint_point_frames != 1 ) Paint_point_frames = 1; else Paint_point_frames = 0; break;
        case 23: if( Paint_const_frames != 1 ) Paint_const_frames = 1; else Paint_const_frames = 0; break;
        case 24: if( Paint_flat_frames != 1 ) Paint_flat_frames = 1; else Paint_flat_frames = 0; break;
        case 25: if( Paint_icons != 1 ) Paint_icons = 1; else Paint_icons = 0; break;
        case 26: if( Paint_menus != 1 ) Paint_menus = 1; else Paint_menus = 0; break;
		  case 27: if( Draw_captions != 2 ) Draw_captions = 2; else Draw_captions = 0; break;
        case 28: if( Draw_captions != 1 ) Draw_captions = 1; else Draw_captions = 0; break;
		  case 29: if( Draw_system_menu != 1 ) Draw_system_menu = 1; else Draw_system_menu = 0; break;
        case 30: if( Draw_window_title != 1 ) Draw_window_title = 1; else Draw_window_title = 0; break;
        case 31: Draw_buttons = 0; break; case 32: Draw_buttons = 1; break; case 33: Draw_buttons = 2; break;
		  case 34: if( Draw_menus != 1 ) Draw_menus = 1; else Draw_menus = 0; break;
        case 35: if( Draw_normal_division_lines != 1 ) Draw_normal_division_lines = 1; else Draw_normal_division_lines = 0; break;
        case 36: if( Draw_point_division_lines != 1 ) Draw_point_division_lines = 1; else Draw_point_division_lines = 0; break;
        case 37: if( Use_right_mouse_button != 1 ) Use_right_mouse_button = 1; else Use_right_mouse_button = 0; break;
        case 38: if( Change_mouse_pointers != 1 ) Change_mouse_pointers = 1; else Change_mouse_pointers = 0; break;
        case 39: if( Num_Lock != 1 ) Num_Lock = 1; else Num_Lock = 0; break;
		  case 40: if( Num_Lock != 2 ) Num_Lock = 2; else Num_Lock = 0; break;
		  case 41: if( Define_right_Alt != 1 ) Define_right_Alt = 1; else Define_right_Alt = 0; break;
        case 42: if( Define_Mac_key != 1 ) Define_Mac_key = 1; else Define_Mac_key = 0; break;
		  case 43: if( Key_click != 1 ) { Key_click = 1; MessageBeep( 0 ); } else Key_click = 0; break;
        case 44: Background = 1; break; case 45: Background = 2; break; case 46: Background = 0; break;

        // ⠭ ன:
        case 47:
         Smooth_scrolling = 1; Key_scrolling = 1; Disable_menu = 1; Drag_image = 1; Number_of_cursor = 1;
			Paint_frames = 1; Paint_normal_frames = 1; Paint_point_frames = 1; Paint_const_frames = 1; Paint_flat_frames = 1; Paint_icons = 1; Paint_menus = 1;
         Draw_captions = 1; Draw_system_menu = 1; Draw_window_title = 1; Draw_buttons = 1;
			Draw_menus = 1; Draw_normal_division_lines = 1; Draw_point_division_lines = 0;
         Use_right_mouse_button = 1; Change_mouse_pointers = 0;
         Num_Lock = 1; Define_right_Alt = 1; Define_Mac_key = 1; Key_click = 0;
			Background = 1; lstrcpy( (LPSTR) Name_of_cursor, "DRAG_HAND_BLACK" );
        break;

        case 48:
         Smooth_scrolling = 0; Key_scrolling = 0; Disable_menu = 0; Drag_image = 0; Number_of_cursor = 1;
         Paint_frames = 0; Paint_normal_frames = 0; Paint_point_frames = 0; Paint_const_frames = 0; Paint_flat_frames = 0; Paint_icons = 0; Paint_menus = 0;
			Draw_captions = 0; Draw_system_menu = 0; Draw_window_title = 0; Draw_buttons = 0;
			Draw_menus = 0; Draw_normal_division_lines = 0; Draw_point_division_lines = 0;
         Use_right_mouse_button = 0; Change_mouse_pointers = 0;
			Num_Lock = 0; Define_right_Alt = 0; Define_Mac_key = 0; Key_click = 0;
         Background = 0; lstrcpy( (LPSTR) Name_of_cursor, "DRAG_HAND_BLACK" );
        break;

        // 뢠 㪮⢮.
        case 18:
			//  .
         CHAR Command[ 75 ] = "Cmd /C Start View "; CHAR Path[ 50 ] = "";
			#ifdef WATCOM_COMPILER
          getcwd( Path, 50 );
         #else
			 getcurdir( 0, Path );
         #endif
         lstrcat( Command, Path ); lstrcat( Command, "\\Nice-OS2.inf" );

         //  .  롨ࠥ  ᨬ  ࠭.
         if( Code_page == 866 )
			 {
			  CHAR Topic[] = " ";
           AnsiToOem( Topic, Topic );
			  lstrcat( Command, Topic );
          }
         else lstrcat( Command, " Using" );

         // 뢠 㪮⢮.
         WinExec( Command, SW_HIDE );
		  break;
       }

      // 塞 㪠⥫,  ᯮ  । ࠦ.
      if( ( wParam >= 6 && wParam <= 17 ) || wParam == 47 || wParam == 48 )
		 {
        // 뢠 㪠⥫.
        DeleteObject( Cursor_for_dragging );
        // 㦠  㪠⥫.
        if( Number_of_cursor != 3 && Number_of_cursor != 6 && Number_of_cursor != 9 )
         Cursor_for_dragging = LoadCursor( Res_Instance, (LPSTR) Name_of_cursor );
		  else Cursor_for_dragging = LoadIcon( Res_Instance, (LPSTR) Name_of_cursor );
		 }

		// 塞  , ᫨  ॡ.
      if( ( wParam >= 20 && wParam <= 36 ) || wParam == 47 || wParam == 48 ) UpdateAllWindows( Window );
      // 塞  ਫ, ᫨  ॡ.
      if( wParam >= 44 && wParam <= 46 ) InvalidateRect( Window, NULL, 1 );

      // ⠭ ४⥫  .
		if( wParam == 39 || wParam == 40 || wParam == 47 || wParam == 48 ) SetNumLock();

		// 뢠 .
      Auxiliary_ItemIsClicked( Window, wParam );

		// 뢠 ,  ⥬ ᭮  ᮧ.
      DestroyMenus(); CreateMenus();
     }
   break;

   // ᫨  梥 :
	case WM_SYSCOLORCHANGE:
	 // ⠭ 梥 .
    Color_of_caption = GetSysColor( COLOR_ACTIVECAPTION );
	 Color_of_caption_text = GetSysColor( COLOR_CAPTIONTEXT );
    Color_of_inactive_caption = GetSysColor( COLOR_INACTIVECAPTION );
    Color_of_inactive_text = GetSysColor( COLOR_INACTIVECAPTIONTEXT );
   break;

   // ᫨  뢠:
	case WM_DESTROY:
    // 頥  筮 ﭨ , ஥ 뫮 ࠭ .
	 if( Rolled_window != NULL ) UnrollWindow();
    // 蠥 ࠡ ᮮ饭.
    PostQuitMessage(0);
	break;

   // 襭 ࠡ Windows:
   case WM_QUERYENDSESSION:
    // 뢠 ன  Nice_win.ini
    WriteSettings();
	 // .
	return 1;

	// 㣮 ᮮ饭 -  ࠡ뢠.
   default: return DefWindowProc( Window, Message, wParam, lParam );
  }

 // .
 return 0;
}
#endif

// ---    . ---

#ifndef PAINT_WINDOW_IS_REPLACED
// 㥬    ਫ,  । ६ Window.
VOID PaintWindow( HWND Window )
{
 // ६  ᮢ.
 HDC Hdc = NULL;
 PAINTSTRUCT Paint_struct = { NULL, NULL, NULL, NULL, NULL, NULL };
 RECT Rect = { 0, 0, 0, 0 };

 // 稪.
 INT xCount = 0; INT yCount = 0; INT Count = 0; INT Step = 0;

 // ஧筮 㤥.
 if( Background == 1 || Background == 2 )
  {
	//  ࠧ .
   // Rect.top  Rect.left -  孨 㣮. Rect.right  Rect.bottom - ࠢ .
	GetWindowRect( Window, &Rect );
   //    ।  .
   MoveWindow( Window, xScreen * 2, yScreen * 2, ( Rect.right - Rect.left ) / 2, ( Rect.bottom - Rect.top ) / 2, 1 );
	// 뢠 ᮤন  ਫ.
   InvalidateRect( Window, NULL, 1 );
   // ,   ᯮ   ਫ.
   HWND Prev_window = GetNextWindow( Window, GW_HWNDPREV );
   // 뢠 ᮤন , ஥ ᯮ   ਫ.
   InvalidateRect( Prev_window, NULL, 1 );
	// 뢠 ᮤন , ஥ ᯮ  .
	InvalidateRect( GetNextWindow( Prev_window, GW_HWNDPREV ), NULL, 1 );
   //   ᮢ ᥬ .
	Yield();
   //  ⥯ ୥  .
   MoveWindow( Window, Rect.left, Rect.top, Rect.right - Rect.left, Rect.bottom - Rect.top, 1 );
  }

 // 稭 ᮢ.
 Hdc = BeginPaint( Window, &Paint_struct );

 //  ࠧ  ᮢ.
 GetClientRect( Window, &Rect );
 // Rect.top -   ᮢ.
 Rect.top = Rect.bottom;

 // 塞 .
 switch ( Background )
  {
   case 0:
	 //  ⠪ - ⨭.
	 for( yCount = 0; yCount <= Rect.top + 80; yCount += 80 )
     for( xCount = 0; xCount <= Rect.right;  xCount += 80 )
		DrawBitmap( Hdc, xCount, yCount, Bitmap_for_background );
   break;

   case 1:
    //  ⠪ - ஢  .
    SelectObject( Hdc, GetStockObject( BLACK_PEN ) );
	 for( xCount = 0; xCount <= Rect.top + Rect.right; xCount += 2 )
     {
		// ஢ .
      MoveTo( Hdc, 0, Rect.top - xCount );
      LineTo( Hdc, xCount, Rect.top );
	  }
    // ᮢ뢠 .
    for( Count = 0; Count < 6; Count ++ ) UpdateWindow( WinButton[ Count ] );
   break;

   case 2:
	 //  ⠪ - ᭠砫 ⠭ 㪠⥫  - "",
	 HCURSOR Prev_cursor;
    SetCapture( Window );
	 if( Change_mouse_pointers != 0 ) Prev_cursor = SetCursor( New_cursor_A );
    else Prev_cursor = SetCursor( Old_cursor_A );

    // ᮢ뢠 .
    for( Count = 0; Count < 6; Count ++ ) UpdateWindow( WinButton[ Count ] );

	 // ਬ,  窨   ⠢ ⥬.
    for( Step = 0; Step < 10; Step ++ )
	  for( yCount = 0; yCount <= Rect.top / 10 + 1; yCount ++ )
      for( xCount = 0; xCount <= Rect.right;  xCount ++ )
       if( IsPointVisible( xCount, yCount * 10 + Step, Rect.top ) )
		  SetPixel( Hdc, xCount, yCount * 10 + Step, MakeDarkColor( GetPixel( Hdc, xCount, yCount * 10 + Step ) ) );

    // ⠭ 㪠⥫  ⭮.
    SetCursor( Prev_cursor ); ReleaseCapture();
   break;
  }

 // 蠥 ᮢ.
 EndPaint( Window, &Paint_struct );
 // .
 return;
}
#endif

// --- ஢,   窠  . ---

#ifndef IS_POINT_VISIBLE_IS_REPLACED
// X  Y ।   . ᫨ 窠 , 頥 1,  0.
BYTE IsPointVisible( INT X, INT Y, INT H )
{
 // ᫨ 窠 室  ।  ᮢ - .
 if( Y > H ) return 0;

 // ᫨  ⮩ 窥 ᯮ  - 窠  .
 for( INT Count = 0; Count < 6; Count ++ )
  if( X > WinButton_Rect[ Count ].left ) if( X < WinButton_Rect[ Count ].left + WinButton_Rect[ Count ].right )
  if( Y > WinButton_Rect[ Count ].top ) if( Y < WinButton_Rect[ Count ].top + WinButton_Rect[ Count ].bottom )
	return 0;

 // .
 return 1;
}
#endif

// ---  梥  ⥬. ---

#ifndef MAKE_DARK_COLOR_IS_REPLACED
//  梥  ⥬. Color । 梥.
COLORREF MakeDarkColor( COLORREF Color )
{
 // 塞 梥.
 BYTE Red = ( GetRValue( Color ) / 3 ) * 2;
 BYTE Green = ( GetGValue( Color ) / 3 ) * 2;
 BYTE Blue = ( GetBValue( Color ) / 3 ) * 2;
 // 頥 祭 祭.
 return RGB( Red, Green, Blue );
}
#endif

// ---  ⨭. ---

#ifndef DRAW_BITMAP_IS_REPLACED
// Hdc । ன⢮, x  y - , Source_bitmap - ⨭  ᮢ.
VOID DrawBitmap( HDC Hdc, INT x, INT y, HBITMAP Source_bitmap )
{
 // ६  ᮢ.
 HDC Hdc_in_memory = NULL; BITMAP Bitmap; HBITMAP Old_bitmap = NULL;

 // 뢠 .
 Hdc_in_memory = CreateCompatibleDC( Hdc );

 // ᫨   뤥 - .
 if( Hdc_in_memory == NULL ) return;

 //    ⨭.
 Old_bitmap = SelectObject( Hdc_in_memory, Source_bitmap );

 //  ࠧ ⨭.
 GetObject( Source_bitmap, sizeof(BITMAP), (LPSTR) &Bitmap );

 // ७ᨬ   ன⢮.
 BitBlt( Hdc, x, y, Bitmap.bmWidth, Bitmap.bmHeight, Hdc_in_memory, 0,  0, SRCCOPY );

 // 뢠 ⨭  .
 SelectObject( Hdc_in_memory, Old_bitmap ); DeleteDC( Hdc_in_memory );

 // .
 return;
}
#endif

// --- ࠡ⪠ ᮮ饭  譨 ன. ---

#ifndef KBD_MOUSE_HOOK_PROC_IS_REPLACED
// Win-OS/2 뢠 KbdMouseHookProc() 直 ࠧ  ।  ᮮ饭  ன.
// Code ।,   । ࠢ 㣨 ࠡ稪.
// wParam  ᯮ, lParam 㪠뢠  ᮮ饭.
LRESULT CALLBACK _export KbdMouseHookProc( INT Code, WPARAM wParam, LPARAM lParam )
{
 // ,  ᮮ饭 । .
 MSG Message; memcpy( &Message, (VOID*) lParam, sizeof(MSG) );

 // ᫨   㪠 - ᮮ饭 । ਫ, .
 if( Message.hwnd == NULL ) return 0;

 //  ࠦ   ப, ᫨  ५  祭 Scroll Lock.
 if( Key_scrolling != 0 )
  if( Message.message == WM_KEYDOWN )
   if( Message.wParam == VK_DOWN  || Message.wParam == VK_UP  ||
       Message.wParam == VK_RIGHT || Message.wParam == VK_LEFT )
	 if( GetKeyState( VK_SCROLL ) != 0  )
     ScrollImage( Message.wParam );

 // । ࠦ   .
 // ᫨  ࠢ   祭 Scroll Lock - 稭 ।.
 if( Drag_image == 1 ) if( Smooth_scrolling != 0 ) if( Message.message == WM_RBUTTONDOWN ) if( GetKeyState( VK_SCROLL ) != 0 )
  {
	// 稭 ।.
   BeginDragging( Message.hwnd, LOWORD( Message.lParam ), HIWORD( Message.lParam ) );
	// ᫨  砫:
   if( InTravel == 1 )
    {
     //  ᮮ饭.
     Message.message = WM_NULL; Message.wParam = 0; Message.lParam = 0;
     // 塞 ᮮ饭, । .
	  memcpy( (VOID*) lParam, &Message, sizeof(MSG) );
    }
  }
 // ᫨     祭 Scroll Lock - 稭 ।.
 if( Drag_image == 2 ) if( Smooth_scrolling != 0 ) if( Message.message == WM_LBUTTONDOWN ) if( GetKeyState( VK_SCROLL ) != 0  )
  {
   // 稭 ।.
   BeginDragging( Message.hwnd, LOWORD( Message.lParam ), HIWORD( Message.lParam ) );
   // ᫨  砫:
   if( InTravel == 1 )
    {
	  //  ᮮ饭.
	  Message.message = WM_NULL; Message.wParam = 0; Message.lParam = 0;
     // 塞 ᮮ饭, । .
	  memcpy( (VOID*) lParam, &Message, sizeof(MSG) );
    }
  }
 // ᫨  ।   - 稭 ।.
 if( Drag_image == 3 ) if( Smooth_scrolling != 0 ) if( Message.message == WM_MBUTTONDOWN )
  {
	// 稭 ।.
   BeginDragging( Message.hwnd, LOWORD( Message.lParam ), HIWORD( Message.lParam ) );
	// ᫨  砫:
   if( InTravel == 1 )
    {
	  //  ᮮ饭.
     Message.message = WM_NULL; Message.wParam = 0; Message.lParam = 0;
     // 塞 ᮮ饭, । .
     memcpy( (VOID*) lParam, &Message, sizeof(MSG) );
    }
  }
 // । ࠦ  ࠭ .
 if( InTravel == 1 ) if( Message.message == WM_MOUSEMOVE )
  {
	// । ࠦ  ࠭ .
   DragImage( LOWORD( Message.lParam ), HIWORD( Message.lParam ) );
   //  ᮮ饭.
   Message.message = WM_NULL; Message.wParam = 0; Message.lParam = 0;
   // 塞 ᮮ饭, । .
   memcpy( (VOID*) lParam, &Message, sizeof(MSG) );
  }
 // ᫨ ⦠      ன ࠧ - 蠥 ।.
 if( InTravel == 1 )
  if( Message.message == WM_MBUTTONUP || Message.message == WM_RBUTTONUP || Message.message == WM_LBUTTONUP ||
      Message.message == WM_MBUTTONDOWN || Message.message == WM_RBUTTONDOWN || Message.message == WM_LBUTTONDOWN )
	{
    // 蠥 ।.
    EndDragging();
    //  ᮮ饭.
    Message.message = WM_NULL; Message.wParam = 0; Message.lParam = 0;
    // 塞 ᮮ饭, । .
	 memcpy( (VOID*) lParam, &Message, sizeof(MSG) );
	}
 // ᫨   "ESC" - 蠥 ।.
 if( InTravel == 1 ) if( Message.message == WM_KEYDOWN ) if( Message.wParam == VK_ESCAPE )
  {
   // । ࠦ  砫 .
   DragImage( Begin_point.x, Begin_point.y );
   // 蠥 ।.
   EndDragging();
	//  ᮮ饭.
   Message.message = WM_NULL; Message.wParam = 0; Message.lParam = 0;
	// 塞 ᮮ饭, । .
   memcpy( (VOID*) lParam, &Message, sizeof(MSG) );
  }

 // 㥬 ࠬ  . 饭 ।   CallWndHookProc()  祭
 // ᮮ饭  ᮢ.     㦥 ᮢ,    ᨬ.
 if( Paint_frames != 0 )
  if( Message.message == WM_NULL )
   if( Message.lParam == 0xABCDEF0 )
	 {
	  // 㥬 ࠬ.
     DrawWindowFrame( Message.hwnd );
	  //  - ⭮.
     Window_with_new_frame = NULL;
    }

 // 㥬 ࠬ  .  砥  ᮮ饭 WM_PAINT   譥 ன⢠.
 // ᫥ ண WM_PAINT 뫠 ᮮ饭 WM_NULL.
 if( Paint_frames != 0 ) if( Paint_menus != 0 )
  if( Message.message == WM_PAINT ) if( Window_with_new_frame != Message.hwnd )
	{
    // ,    । .
    BYTE Window_is_exist = GetClassName( Message.hwnd, Window_name, SIZE_OF_NAME );
	 // ᫨  :
    if( Window_is_exist )
     {
      // ᫨  :
      if( lstrcmp( Window_name, Menu_name ) == 0 )
       // ஢塞,  ᮮ饭 WM_PAINT  .
		 if( Repaint_menu == 0 ) Repaint_menu = 1;
		 else
        {
			//  稭 .
         Repaint_menu = 0;
         // 뫠 ᮮ饭.
         PostMessage( Message.hwnd, WM_NULL, 0, 0xABCDEF0 );
         //  .
         Window_with_new_frame = Message.hwnd;
		  }
     }
	}

 // ࠡ뢠      .
 if( Paint_frames != 0 ) if( Draw_captions == 1 ) if( Draw_buttons != 0 )
  {
   //  ⨨     ,  ஬  ந諮.  ।
   // , ᫨  ,  ᮢ ࠬ.  ⦠⨨  - ⮦ ᮢ.
   // ᫨     뫨  ⦠⮬ ﭨ:
   if( Selected_window == NULL )
	 {
	  // ᫨    -    㥬    ⮩.
     if( Message.message == WM_NCLBUTTONDOWN || Message.message == WM_NCRBUTTONDOWN || Message.message == WM_NCMBUTTONDOWN ||
			Message.message == WM_NCLBUTTONDBLCLK || Message.message == WM_NCRBUTTONDBLCLK || Message.message == WM_NCMBUTTONDBLCLK )
      if( !IsIconic( Message.hwnd ) ) if( PermissionForDrawing( Message.hwnd ) != 0 )
       {
        //  ࠭ .
        Selected_window = Message.hwnd;

		  // 㥬      ⮩.
        BYTE Button_is_pressed = AnimateButtons( Selected_window, Message.message );
		  // ᫨      -  ᮮ饭.
        if( Button_is_pressed )
         {
			 //  ᮮ饭.
          Message.message = WM_NULL; Message.wParam = 0; Message.lParam = 0;
          // 塞 ᮮ饭, । .
          memcpy( (VOID*) lParam, &Message, sizeof(MSG) );
         }
        //  ᫨   :
		  else
			{
          // ᫨    -  ᮮ饭.
			 if( Message.wParam == HTMAXBUTTON || Message.wParam == HTMINBUTTON || Message.wParam == HTCLOSEBUTTON )
           {
            //  ᮮ饭.
            Message.message = WM_NULL; Message.wParam = 0; Message.lParam = 0;
            // 塞 ᮮ饭, । .
            memcpy( (VOID*) lParam, &Message, sizeof(MSG) );
			  }

			 //   ⨨ ࠢ      ࠭ .
          if( Message.message == WM_NCRBUTTONDBLCLK ) if( Message.wParam == HTCAPTION ) if( IsZoomed( Message.hwnd ) )
           {
				//    ࠭ .
            Action( Message.hwnd, 4 );

            //  ᮮ饭.
            Message.message = WM_NULL; Message.wParam = 0; Message.lParam = 0;
            // 塞 ᮮ饭, । .
				memcpy( (VOID*) lParam, &Message, sizeof(MSG) );
			  }
         }
		 }
    }
   // ᫨      뫠  ⮬ ﭨ:
   else
    {
     // ᫨   - 㥬    .    ⠭ ⮩.
	  if( Message.message == WM_NCMOUSEMOVE || Message.message == WM_MOUSEMOVE )
      AnimateButtons( Selected_window, Message.message );

     // ᫨      -  ᮮ饭.
     if( Message.message == WM_NCLBUTTONDOWN || Message.message == WM_NCRBUTTONDOWN || Message.message == WM_NCMBUTTONDOWN )
		{
       // 㥬      ⮩.       㣮 .
       BYTE Button_is_pressed = AnimateButtons( Message.hwnd, Message.message );
       // ᫨   -  ᮮ饭.
       if( Button_is_pressed )
        {
			// ᫨     㣮  - ᮢ뢠  ࠬ.
			if( Message.hwnd != Selected_window ) DrawWindowFrame( Message.hwnd );

			//  ᮮ饭.
         Message.message = WM_NULL; Message.wParam = 0; Message.lParam = 0;
         // 塞 ᮮ饭, । .
         memcpy( (VOID*) lParam, &Message, sizeof(MSG) );
        }
      }

     // ᫨ ⦠   - 믮塞 ⢨  㥬      筮 .
	  if( Message.message == WM_NCLBUTTONUP || Message.message == WM_NCRBUTTONUP || Message.message == WM_NCMBUTTONUP ||
         Message.message == WM_LBUTTONUP   || Message.message == WM_RBUTTONUP   || Message.message == WM_MBUTTONUP )
          {
			  //   , ࠭  - ⭮.
           // ६ 뢠 ࠭ -    ᮮ饭 WM_NCLBUTTONUP.
           BYTE Button = Selected_button; Selected_button = 0;
           HWND Window = Selected_window; Selected_window = NULL;

           // ᫨  뫠     ⨭:
			  if( Button >= 2 )
				{
             // ᮢ뢠 ࠬ .
				 DrawWindowFrame( Window );
             // 믮塞 । ⢨.
             Action( Window, Button );
            }
          }
    }
  }

 // ᫨ , ஥ 뫮 ࠭ ,  ࠧ  뢠,  ⠪ ᫨     :
 if( Rolled_window == Message.hwnd )
  {
	// ᫨   ࠧ  뢠 - 頥   筮 ﭨ.
   if( ( Message.message == WM_SYSCOMMAND && Message.wParam == SC_MAXIMIZE ) ||
       ( Message.message == WM_SYSCOMMAND && Message.wParam == SC_MINIMIZE ) ||
       ( Message.message == WM_SYSCOMMAND && Message.wParam == SC_RESTORE  ) ||
       ( Message.message == WM_SYSCOMMAND && Message.wParam == SC_CLOSE    ) ||
         Message.message == WM_CLOSE ) UnrollWindow();
	// ᫨     ࠧ   :
	if( Message.message == WM_NCLBUTTONDBLCLK || Message.message == WM_NCRBUTTONDBLCLK ||
       Message.message == WM_NCMBUTTONDBLCLK ) if( Message.wParam == HTCAPTION )
		  {
         // 頥   筮 ﭨ.
         UnrollWindow();

         //  ᮮ饭.
         Message.message = WM_NULL; Message.wParam = 0; Message.lParam = 0;
			// 塞 ᮮ饭, । .
         memcpy( (VOID*) lParam, &Message, sizeof(MSG) );
		  }
  }

 // ᯮ㥬 ࠢ  ।    ࠡ  .
 // 塞 襤襥 ᮮ饭 ⠪,   ࠡ ந室  .
 if( Use_right_mouse_button != 0 )
  {
   // ᫨  ࠡ祩   ࠢ  । :
   if( Message.message == WM_NCRBUTTONDOWN || Message.message == WM_NCMBUTTONDOWN )
	 {
	  // 塞 ᮮ饭, । .
     Message.message = WM_NCLBUTTONDOWN; memcpy( (VOID*) lParam, &Message, sizeof(MSG) );
	  //  ᯮ.
     Right_button_is_used = 1;
    }
   // ᫨  ᪮ ᬮ  ࠢ  । :
   if( Message.message == WM_RBUTTONDOWN || Message.message == WM_MBUTTONDOWN ) if( IsScrollBar( Message.hwnd, 0 ) )
    {
	  // 塞 ᮮ饭, । .
     Message.message = WM_LBUTTONDOWN; memcpy( (VOID*) lParam, &Message, sizeof(MSG) );
	  //  ᯮ.
     Right_button_is_used = 1;
    }
	// ᫨ ࠢ  ।   ᯮ:
   if( Right_button_is_used )
    {
     // ᫨  ࠡ祩  ⦠ ࠢ  । :
     if( Message.message == WM_NCRBUTTONUP || Message.message == WM_NCMBUTTONUP )
      {
		 // 塞 ᮮ饭, । .
		 Message.message = WM_NCLBUTTONUP; memcpy( (VOID*) lParam, &Message, sizeof(MSG) );
       //    ᯮ.
		 Right_button_is_used = 0;
      }
     // ᫨   ⦠ ࠢ  । :
     if( Message.message == WM_RBUTTONUP || Message.message == WM_MBUTTONUP )
      {
       // 塞 ᮮ饭, । .
		 Message.message = WM_LBUTTONUP; memcpy( (VOID*) lParam, &Message, sizeof(MSG) );
       //    ᯮ.
		 Right_button_is_used = 0;
      }
    }
  }

 // 塞 㪠⥫ .
 if( Change_mouse_pointers != 0 )
  {
   // 饭 WM_NULL ।   CallWndHookProc()   㪠⥫:
	if( Message.message == WM_NULL ) if( Message.lParam == 0x12345678 )
	 {
     // 塞 㪠⥫.
	  ChangeMousePointer();
     //  - ⭮.
     Window_with_new_pointer = NULL;
    }
   // ᫨      :
   if( Message.message >= WM_NCLBUTTONDOWN && Message.message <= WM_NCMBUTTONUP )
	 if( PermissionForChanging( Message.hwnd ) != 0 )
     ChangeMousePointer();
	// ᫨     :
   if( Message.message >= WM_LBUTTONDOWN && Message.message <= WM_MBUTTONUP )
    if( PermissionForChanging( Message.hwnd ) != 0 )
	  ChangeMousePointer();
  }

 // ⠭ ४⥫  ⨨ Num Lock.
 if( Num_Lock != 0 ) if( Message.message == WM_KEYDOWN ) if( Message.wParam == VK_NUMLOCK ) SetNumLock();

 // ८।塞 ࠢ  'Alt'. 뢠 襤襥 ᮮ饭,  뫠 㣮.
 if( Define_right_Alt != 0 )
  {
	// ᫨ 室 ᮮ饭  ⦠⨨ ࠢ  'Alt'   :
   if( Message.message == WM_SYSKEYUP ) if( Message.wParam == VK_MENU ) if( Message.lParam == VK_RIGHT_ALT )
    if( IsWindow( Message.hwnd ) )
     {
      // 맮 ᯨ᪠ .
      SendMessage( Message.hwnd, WM_SYSCOMMAND, SC_TASKLIST, 0 );
		//  ᮮ饭.
      Message.message = WM_NULL; Message.wParam = 0; Message.lParam = 0;
		// 塞 ᮮ饭, । .
      memcpy( (VOID*) lParam, &Message, sizeof(MSG) );
     }
  }

 // ८।塞  '|\'  ''. 塞 襤襥 ᮮ饭.
 if( Define_Mac_key != 0 )
  if( Message.message == WM_KEYDOWN )
   if( Message.wParam == VK_MACRO )
	 {
	  // 饭 ਤ   ⨨,  ࠧ   㪢.
     Message.message = WM_CHAR;
	  if( GetKeyState( VK_CAPITAL ) != 0  )
      if( GetKeyState( VK_SHIFT ) < 0 ) Message.wParam = 171; else Message.wParam = 187;
     else
      if( GetKeyState( VK_SHIFT ) < 0 ) Message.wParam = 149; else Message.wParam = 151;
     // 塞 ᮮ饭, । .
     memcpy( (VOID*) lParam, &Message, sizeof(MSG) );
	 }

 //   ⨨  .
 if( Key_click != 0 ) if( Message.message == WM_KEYDOWN || Message.message == WM_SYSKEYDOWN )
  KeyClick( Message.wParam, Message.lParam );

 // 뢠 .
 Auxiliary_KbdMouseHookProc( &Message );

 // .
 return 0;
}
#endif

// --- ࠡ⪠ ᮮ饭  . ---

#ifndef CALL_WND_HOOK_PROC_IS_REPLACED
// Win-OS/2 뢠 CallWndHookProc()  ।  ᮮ饭  㣨 .
// Code ।,   । ࠢ 㣨 ࠡ稪.
// wParam  ᯮ, lParam 㪠뢠  ᮮ饭.
LRESULT CALLBACK _export CallWndHookProc( INT Code, WPARAM wParam, LPARAM lParam )
{
 // ,  ᮮ饭 । .
 CWMSG Message; memcpy( &Message, (VOID*) lParam, sizeof(CWMSG) );

 // ᫨   㪠 - ᮮ饭 । ਫ, .
 if( Message.hwnd == NULL ) return 0;

 // । ࠦ 㤥 . ᫨  ᪥ ᬮ ६頥 ,
 //    ࠧ । ࠦ  ⮣  ( । lParam).
 if( Smooth_scrolling != 0 )
  if( Message.message == WM_VSCROLL || Message.message == WM_HSCROLL )
	if( Message.wParam == SB_THUMBTRACK )
    {
	  //  ,  ஬ ந室 । ࠦ, ⮡   ࠧ襭  ࠧ.
     if( Message.hwnd != Scrolling_window )
      {
       //  .
       Scrolling_window = Message.hwnd;
       // ,    । ࠦ  ⮬ .
		 if( PermissionForScrolling( Message.hwnd ) != 0 ) Disable_smooth_scrolling = 0;
       else Disable_smooth_scrolling = 1;
		}
     // ᫨   :
     else
		{
       // ᫨ । ࠦ :
       if( Disable_smooth_scrolling == 0 )
        {
         // 뫠 ᮮ饭.
         Smooth_scrolling = 0;
			SendMessage( Message.hwnd, Message.message, SB_THUMBPOSITION, Message.lParam );
			SendMessage( Message.hwnd, Message.message, SB_ENDSCROLL,     Message.lParam );
         Smooth_scrolling = 1;
		  }
      }
    }

 //  ,   ந室 । ࠦ.
 if( Key_scrolling != 0 )
  if( Message.message == WM_VSCROLL  || Message.message == WM_HSCROLL )
   if( Message.wParam == SB_LINEDOWN || Message.wParam == SB_PAGEDOWN ||
		 Message.wParam == SB_LINEUP  || Message.wParam == SB_PAGEUP    )
    if( PermissionForScrolling( Message.hwnd ) != 0 )
     AddWindowToList( Message.hwnd, Message.message, Message.lParam );

 //    ᪮   ।.
 if( Smooth_scrolling != 0 )
  if( Message.message == WM_VSCROLL || Message.message == WM_HSCROLL )
   {
    //  । 稢, ⠭ ६  1.
	 if( Message.wParam == SB_ENDSCROLL ) if( Step_of_scrolling == 0 )
	  {
      // 騩 蠣 - .
		Step_of_scrolling = 1;
     }
    //   ⮫쪮  筥,  窨,  ⠭ ६  2,
    // ⮡  ஬ 蠣 ஢,  窨 .
    if( Message.wParam == SB_THUMBTRACK ) if( Step_of_scrolling == 1 )
     {
		// ᫨ । ࠦ , :
      if( PermissionForScrolling( Message.hwnd ) != 0 )
		 {
        // ᨬ   ᯨ᮪,  㤥 .
        AddWindowToList( Message.hwnd, Message.message, Message.lParam );
		  //    ᪨.
        Position_of_lines = LOWORD( Message.lParam );
        //  窨  .
        GetPointsFromWindow( Message.hwnd );
        // 騩 蠣 - ன.
        Step_of_scrolling = 2;
		 }
		//  ᫨ ࠦ ।   -   ᪮.
      else Step_of_scrolling = 0;
	  }
    //  ஬ 蠣 ᨬ   ᯨ᮪, 㧭 ᪮  뢠 ६ ᭮  0.
    // ᫨    -  ।㫨   1 :
    else if( Step_of_scrolling == 2 ) if( LOWORD( Message.lParam ) > Position_of_lines )
     {
      // ⠭ ᪮ ᢥ .
		if( Message.message == WM_VSCROLL )
       {
		  // ⠭    ᯨ᪥.
        FindWindowInList( Message.hwnd );
        // । ﭨ:
		  INT Supposition = List[ 0 ].yV * ( LOWORD( Message.lParam ) - Position_of_lines );
        //  ᠬ  ன:
        INT Distance = FindPoints( Message.hwnd, WM_VSCROLL, Supposition );
        // ᫨  0,  ﭨ, 室  1 蠣. ᫨ 0 < yV < 1,  yV = 1;
        if( Distance > 0 ) { List[ 0 ].yV = Distance / ( LOWORD( Message.lParam ) - Position_of_lines ); if( List[ 0 ].yV == 0 ) List[ 0 ].yV = 1; }
       }
		// ⠭ ᪮ ᫥ ࠢ.
		if( Message.message == WM_HSCROLL )
       {
		  // ⠭    ᯨ᪥.
        FindWindowInList( Message.hwnd );
        // । ﭨ:
        INT Supposition = List[ 0 ].xV * ( LOWORD( Message.lParam ) - Position_of_lines );
        //  ᠬ  ன:
        INT Distance = FindPoints( Message.hwnd, WM_HSCROLL, Supposition );
		  // ᫨  0,  ﭨ, 室  1 蠣. ᫨ 0 < xV < 1,  xV = 1;
        if( Distance > 0 ) { List[ 0 ].xV = Distance / ( LOWORD( Message.lParam ) - Position_of_lines ); if( List[ 0 ].xV == 0 ) List[ 0 ].xV = 1; }
		 }
      // ⮣ 筮.
      Step_of_scrolling = 0;
	  }
   }

 // 㥬 ࠬ  . ᫨  砥 ᮮ饭  ⮬,     ᮢ,
 // 뫠  ᮮ饭 WM_NULL.   ࠡ뢠  ᮮ饭.  㤥 ᮢ.
 //  ᮮ饭 뫠 ⮫쪮 ⮣,  ࠡ⠭ ।饥.
 if( Paint_frames != 0 )
  {
   // ᫨  砥 ᮮ饭  ᮢ:
	if( Message.message == WM_NCPAINT ) if( Window_with_new_frame != Message.hwnd )
    if( PermissionForDrawing( Message.hwnd ) != 0 )
     {
      // 뫠 ᮮ饭.  ⮬ ६,   ਤ,   ࠬ.
      PostMessage( Message.hwnd, WM_NULL, 0, 0xABCDEF0 );
      //  .
		Window_with_new_frame = Message.hwnd;
     }
	// ᫨  ࠭  ࠭ 㣮 :
   if( Message.message == WM_NCACTIVATE || Message.message == WM_ACTIVATE || Message.message == WM_SETFOCUS || Message.message == WM_KILLFOCUS || Message.message == WM_ENABLE )
    if( PermissionForDrawing( Message.hwnd ) != 0 )
	  {
      // ᫨  ࠭    - ᮢ뢠 ࠬ.
      if( Message.message == WM_ACTIVATE || Message.message == WM_SETFOCUS ) DrawWindowFrame( Message.hwnd );
      // ⥬ 뫠 ᮮ饭.
      if( Window_with_new_frame != Message.hwnd )
       {
		  // 뫠 ᮮ饭.
		  PostMessage( Message.hwnd, WM_NULL, 0, 0xABCDEF0 );
        //  .
		  Window_with_new_frame = Message.hwnd;
       }
     }
   //     - ᮢ뢠 ࠬ  뫠 ᮮ饭.
   if( Message.message == WM_SETTEXT || Message.message == WM_GETTEXT || Message.message == WM_GETTEXTLENGTH )
    if( PermissionForDrawing( Message.hwnd ) != 0 )
	  {
      // ᮢ뢠 ࠬ.
		DrawWindowFrame( Message.hwnd );
      // ᫨   - 뫠 ᮮ饭.
      if( Window_with_new_frame != Message.hwnd )
		 {
        // 뫠 ᮮ饭.
        PostMessage( Message.hwnd, WM_NULL, 0, 0xABCDEF0 );
        //  .
        Window_with_new_frame = Message.hwnd;
       }
	  }
	// ᫨ ᮤন  襭 - ᮢ뢠 ࠬ.
   if( Message.message == WM_ERASEBKGND ) if( PermissionForDrawing( Message.hwnd ) != 0 )
	 DrawWindowFrame( Message.hwnd );
   // ᫨   । ࠦ - ᮢ뢠 ࠬ.
   if( Message.message == WM_VSCROLL || Message.message == WM_HSCROLL ) if( Paint_normal_frames != 0 )
    {
     //  ࠬ  ?   ⮭, 筠, ᪠,   ﭭ ࠧ.
     LONG Window_style = GetWindowLong( Message.hwnd, GWL_STYLE );
	  // ᫨  筮      :
     if( Window_style & WS_THICKFRAME ) if( Window_style & WS_BORDER ) if( Window_style & WS_DLGFRAME )
		{
       //  ᫨    ﭭ ࠧ:
       LONG Window_xstyle = GetWindowLong( Message.hwnd, GWL_EXSTYLE );
		 if( !( Window_xstyle & WS_EX_DLGMODALFRAME ) )
        {
         // 㥬  ࠬ   .
         if( PermissionForDrawing( Message.hwnd ) != 0 )
          DrawLines( Message.hwnd, Window_style );
        }
		}
	 }
  }

// 졠  ஬  . ᫨ 뫠  ⨭   孥 㣫 ,  ⥬
//   Esc   , ⮡   - 㥬 ࠬ  .
if( Paint_frames != 0 ) if( Draw_captions == 1 ) if( Draw_system_menu != 0 ) if( Message.message == WM_MENUSELECT )
 {
  // ᫨ ࠭ ⨭   孥 㣫  - ᮢ뢠 ࠬ.
  if( (INT)LOWORD( Message.lParam ) == -1 || LOWORD( Message.lParam ) & MF_SYSMENU )
   {
	 // ᫨ ࠬ ᮢ :
    if( PermissionForDrawing( Message.hwnd ) != 0 )
     {
		// ᮢ뢠 ࠬ .
      DrawWindowFrame( Message.hwnd );

      // ᮢ뢠 ࠬ ।饣 .
      if( Prev_selected_window != Message.hwnd ) if( Prev_selected_window != NULL )
       DrawWindowFrame( Prev_selected_window );

		//    ।饥.
      Prev_selected_window = Message.hwnd;
	  }
   }
  // ᫨  ࠭  - ᮢ뢠 ࠬ ।饣 .
  else
   {
    // ᮢ뢠 ࠬ ।饣 .
	 if( Prev_selected_window != NULL )
     DrawWindowFrame( Prev_selected_window );

    // ।饥  - ⭮.
    Prev_selected_window = NULL;
	}
 }

 // 졠      . ᫨ 뫮 맢  ,  ᮮ饭
 //   室 ⮫쪮  . ⥫᪮  砥 㣨 ᮮ饭.
 // ᫨      뫠  ⮬ ﭨ:
 if( Selected_button != 0 ) if( Selected_window != NULL ) if( Message.hwnd != Selected_window )
  if( Message.message == WM_ENTERIDLE || Message.message == WM_SETCURSOR )
   {
	 //  ,  ஬ ᯮ 㪠⥫ .
    POINT Mouse_point = { 0, 0 }; GetCursorPos( &Mouse_point );

    // ᫨ 㪠⥫ ᯮ  㣮 :
    if( WindowFromPoint( Mouse_point ) != Selected_window )
     {
		//   .
      Selected_button = 0;
		// ᮢ뢠 ࠬ ,  ஬ 뫠  .
      DrawWindowFrame( Selected_window );
      // ࠭  - ⭮.
		Selected_window = NULL;
     }
   }

 // ᫨ ந室 襭 ࠡ ⥬,   ࠭  - 頥   筮 ﭨ.
 if( Rolled_window == Message.hwnd ) if( Message.message == WM_QUERYENDSESSION ) UnrollWindow();

 // 塞 㪠⥫ .
 if( Change_mouse_pointers != 0 )
  {
   // ᫨ ਫ  ᪥  襭 뢠  -  ᮧ   ᬥ 㪠⥫.
   if( Message.message == WM_CREATE || Message.message == WM_DESTROY )
    if( PermissionForChanging( Message.hwnd ) != 0 ) ChangeMousePointer();
   // ᫨  砥 ᮮ饭  ⮬,   ⠭ 㪠⥫, 뫠  ᮮ饭
   // WM_NULL.   ࠡ뢠  ᮮ饭. ⥫ 㤥   㣮.
	//  ᮮ饭 뫠 ⮫쪮 ⮣,  ࠡ⠭ ।饥.
   if( Message.message == WM_SETCURSOR ) if( Window_with_new_pointer != Message.hwnd )
	 if( PermissionForChanging( Message.hwnd ) != 0 )
     {
      // 뫠 ᮮ饭.
		PostMessage( Message.hwnd, WM_NULL, 0, 0x12345678 );
      //  .
      Window_with_new_pointer = Message.hwnd;
     }
  }

 // ⠭ ४⥫  .
 if( Num_Lock != 0 ) if( Message.message == WM_ACTIVATE ) if( Message.wParam == WA_INACTIVE )
  SetNumLock();

 // 뢠 .
 Auxiliary_CallWndHookProc( &Message );

 // .
 return 0;
}
#endif

// --- ஢,   ᮢ ࠬ  . ---

#ifndef PERMISSION_FOR_DRAWING_IS_REPLACED
// Window । . 頥 祭: 1, ᫨ , 0, ᫨ .
BYTE PermissionForDrawing( HWND Window )
{
 //   .
 LONG Window_style = GetWindowLong( Window, GWL_STYLE );
 LONG Window_xstyle = GetWindowLong( Window, GWL_EXSTYLE );

 // ᫨  ᯮ  㣮     ,  祣 ᮢ  .
 if( Window_style & WS_CHILD ) if( !( Window_style & WS_DLGFRAME ) ) if( !( Window_style & WS_THICKFRAME ) ) if( !( Window_xstyle & WS_EX_DLGMODALFRAME ) ) return 0;
 if( Window_style & WS_CHILD ) if( Window_style & WS_DLGFRAME ) if( !( Window_style & WS_BORDER ) ) if( !( Window_xstyle & WS_EX_DLGMODALFRAME ) ) return 0;

 // ,    । .
 BYTE Window_is_exist = GetClassName( Window, Window_name, SIZE_OF_NAME );

 // ᫨   - .
 if( !Window_is_exist ) return 0;

 // ᫨   ࠡ祣 ⮫,  ᮢ ࠬ  .
 if( lstrcmp( Window_name, WPShell_name ) == 0 ) return 0;
 // ᫨    窠,  ᮢ ࠬ  .
 if( lstrcmp( Window_name, Icon_name ) == 0 ) return 0;
 //  ᮢ뢠   짮⥫ - 頥 1  0.
 if( lstrcmp( Window_name, Menu_name ) == 0 ) if( Paint_menus == 0 ) return 0; else return 1;

 // ᫨    ࠬ - 祣 ᮢ  .
 if( Window_style & WS_POPUP ) if( !( Window_style & WS_BORDER ) )
  if( !( Window_style & WS_DLGFRAME ) ) if( !( Window_style & WS_THICKFRAME ) )
   if( !( Window_xstyle & WS_EX_DLGMODALFRAME ) ) return 0;

 // ᫨   ECL, AppStudio,  ன Paradox,  ᮢ ࠬ  .
 if( Window_style & WS_CHILD ) if( lstrcmp( Window_name, Ecl_name ) == 0 ) return 0;
 if( Window_style & WS_BORDER ) if( !( Window_style & WS_THICKFRAME ) ) if( !( Window_xstyle & WS_EX_DLGMODALFRAME ) )
  if( lstrcmp( Window_name, AppStudio1_name ) == 0 || lstrcmp( Window_name, AppStudio2_name ) == 0 ) return 0;
 if( lstrcmp( Window_name, PdxDlg_name ) == 0 ) return 0;

 // ᫨   Metal Marines,  ᮢ ࠬ  .
 if( Window_name[ 0 ] == 'A' && Window_name[ 1 ] == 'f' && Window_name[ 2 ] == 'x' && Window_name[ 3 ] == ':' )
  {
   //   .
	Paint_frames = 0; GetWindowText( Window, Window_caption, SIZE_OF_NAME ); Paint_frames = 1;
   if( lstrcmp( Window_caption, Marines_name ) == 0 ) return 0;
  }

 // ᫨ ᯨ᮪ ᪫祭  -    ஢.
 if( Exception_1[ 0 ] == NULL ) if( Exception_1[ 1 ] == NULL )
 if( Exception_2[ 0 ] == NULL ) if( Exception_2[ 1 ] == NULL )
 if( Exception_3[ 0 ] == NULL ) if( Exception_3[ 1 ] == NULL )
 if( Exception_4[ 0 ] == NULL ) if( Exception_4[ 1 ] == NULL ) return 1;

 // ஢塞,     ᯨ᪥ ᪫祭.
 if( lstrcmp( Window_name, Exception_1 ) == 0 ) return 0;
 if( lstrcmp( Window_name, Exception_2 ) == 0 ) return 0;
 if( lstrcmp( Window_name, Exception_3 ) == 0 ) return 0;
 if( lstrcmp( Window_name, Exception_4 ) == 0 ) return 0;

 // ᫨   -   ਫ,  ஢  㦭, .
 HWND Main_window = GetMainWindow( Window ); if( Main_window == Window ) return 1;

 // ,    ।   ਫ.
 if( Main_window != NULL ) GetClassName( Main_window, Window_name, SIZE_OF_NAME );
 else { Window_name[ 0 ] = NULL; Window_name[ 1 ] = NULL; }

 // ஢塞,     ਫ  ᯨ᪥ ᪫祭.
 if( lstrcmp( Window_name, Exception_1 ) == 0 ) return 0;
 if( lstrcmp( Window_name, Exception_2 ) == 0 ) return 0;
 if( lstrcmp( Window_name, Exception_3 ) == 0 ) return 0;
 if( lstrcmp( Window_name, Exception_4 ) == 0 ) return 0;

 // 뢠 .
 if( !Auxiliary_PermissionForDrawing( Window ) ) return 0;

 // .
 return 1;
}
#endif

// ---  ஢,    㪠⥫   . ---

#ifndef PERMISSION_FOR_CHANGING_IS_REPLACED
// Window । . 頥 祭: 1, ᫨ , 0, ᫨ .
BYTE PermissionForChanging( HWND Window )
{
 //    ਫ.
 HWND Main_window = GetMainWindow( Window );

 // ,    ।   ਫ.
 if( Main_window != NULL ) GetClassName( Main_window, Window_name, SIZE_OF_NAME );
 else { Window_name[ 0 ] = NULL; Window_name[ 1 ] = NULL; }

 //    㪠⥫   .
 if( lstrcmp( Window_name, Excel_name ) == 0 ) return 0;
 if( lstrcmp( Window_name, Access_name ) == 0 ) return 0;

 // ᫨ ᯨ᮪ ᪫祭  -    ஢.
 if( Exception_5[ 0 ] == NULL ) if( Exception_5[ 1 ] == NULL )
 if( Exception_6[ 0 ] == NULL ) if( Exception_6[ 1 ] == NULL )
 if( Exception_7[ 0 ] == NULL ) if( Exception_7[ 1 ] == NULL )
 if( Exception_8[ 0 ] == NULL ) if( Exception_8[ 1 ] == NULL ) return 1;

 // ஢塞,     ਫ  ᯨ᪥ ᪫祭.
 if( lstrcmp( Window_name, Exception_5 ) == 0 ) return 0;
 if( lstrcmp( Window_name, Exception_6 ) == 0 ) return 0;
 if( lstrcmp( Window_name, Exception_7 ) == 0 ) return 0;
 if( lstrcmp( Window_name, Exception_8 ) == 0 ) return 0;

 // ᫨   -   ਫ,  ஢  㦭, .
 if( Window == Main_window ) if( Main_window != NULL ) return 1;

 // ,    । ,  ஬ ᯮ 㪠⥫.
 BYTE Window_is_exist = GetClassName( Window, Window_name, SIZE_OF_NAME );

 // ᫨   - .
 if( !Window_is_exist ) return 0;

 // ஢塞,     ᯨ᪥ ᪫祭.
 if( lstrcmp( Window_name, Exception_5 ) == 0 ) return 0;
 if( lstrcmp( Window_name, Exception_6 ) == 0 ) return 0;
 if( lstrcmp( Window_name, Exception_7 ) == 0 ) return 0;
 if( lstrcmp( Window_name, Exception_8 ) == 0 ) return 0;

 // 뢠 .
 if( !Auxiliary_PermissionForChanging( Window ) ) return 0;

 // .
 return 1;
}
#endif

// --- ஢,    । ࠦ  . ---

#ifndef PERMISSION_FOR_SCROLLING_IS_REPLACED
// Window । . 頥 祭: 1, ᫨ , 0, ᫨ .
BYTE PermissionForScrolling( HWND Window )
{
 // ,    । .
 BYTE Window_is_exist = GetClassName( Window, Window_name, SIZE_OF_NAME );

 // ᫨   - .
 if( !Window_is_exist ) return 0;

 //     । ࠦ  .
 if( lstrcmp( Window_name, MDIClient_name ) == 0 ) return 0;
 if( lstrcmp( Window_name, ListView_name ) == 0 ) return 0;
 if( lstrcmp( Window_name, WinHelp_name ) == 0 ) return 0;
 if( lstrcmp( Window_name, SdmDlg1_name ) == 0 ) return 0;
 if( lstrcmp( Window_name, SdmDlg2_name ) == 0 ) return 0;
 if( lstrcmp( Window_name, SdmDlg3_name ) == 0 ) return 0;

 // ᫨ ᯨ᮪ ᪫祭  -    ஢.
 if( Exception_9[ 0 ] == NULL ) if( Exception_9[ 1 ] == NULL )
 if( Exception_A[ 0 ] == NULL ) if( Exception_A[ 1 ] == NULL )
 if( Exception_B[ 0 ] == NULL ) if( Exception_B[ 1 ] == NULL )
 if( Exception_C[ 0 ] == NULL ) if( Exception_C[ 1 ] == NULL ) return 1;

 // ஢塞,     ᯨ᪥ ᪫祭.
 if( lstrcmp( Window_name, Exception_9 ) == 0 ) return 0;
 if( lstrcmp( Window_name, Exception_A ) == 0 ) return 0;
 if( lstrcmp( Window_name, Exception_B ) == 0 ) return 0;
 if( lstrcmp( Window_name, Exception_C ) == 0 ) return 0;

 // ᫨   -   ਫ,  ஢  㦭, .
 HWND Main_window = GetMainWindow( Window ); if( Main_window == Window ) return 1;

 // ,    ।   ਫ.
 if( Main_window != NULL ) GetClassName( Main_window, Window_name, SIZE_OF_NAME );
 else { Window_name[ 0 ] = NULL; Window_name[ 1 ] = NULL; }

 // ஢塞,     ਫ  ᯨ᪥ ᪫祭.
 if( lstrcmp( Window_name, Exception_9 ) == 0 ) return 0;
 if( lstrcmp( Window_name, Exception_A ) == 0 ) return 0;
 if( lstrcmp( Window_name, Exception_B ) == 0 ) return 0;
 if( lstrcmp( Window_name, Exception_C ) == 0 ) return 0;

 // 뢠 .
 if( !Auxiliary_PermissionForScrolling( Window ) ) return 0;

 // .
 return 1;
}
#endif

// --- ஢,   । ࠦ   ५. ---

#ifndef PERMISSION_FOR_KEY_SCROLLING_IS_REPLACED
// Window । . 頥 祭: 1, ᫨ , 0, ᫨ .
// ᫨  뫠 ⥫ ᮮ饭  ⨨ , 頥 2.
BYTE PermissionForKeyScrolling( HWND Window )
{
 // ,    । .
 BYTE Window_is_exist = GetClassName( Window, Window_name, SIZE_OF_NAME );

 // ᫨   - .
 if( !Window_is_exist ) return 0;

 //    । ࠦ  .
 if( lstrcmp( Window_name, Word_name ) == 0 ) return 0;

 // ᫨   Access -  뫠 ⥫ ᮮ饭.
 if( lstrcmp( Window_name, CModule_name ) == 0 ) return 2;
 if( lstrcmp( Window_name, OModule_name ) == 0 ) return 2;

 // ᫨ ᯨ᮪ ᪫祭  -    ஢.
 if( Exception_D[ 0 ] == NULL ) if( Exception_D[ 1 ] == NULL )
 if( Exception_E[ 0 ] == NULL ) if( Exception_E[ 1 ] == NULL )
 if( Exception_F[ 0 ] == NULL ) if( Exception_F[ 1 ] == NULL )
 if( Exception_G[ 0 ] == NULL ) if( Exception_G[ 1 ] == NULL ) return 1;

 // ஢塞,     ᯨ᪥ ᪫祭.
 if( lstrcmp( Window_name, Exception_D ) == 0 ) return 0;
 if( lstrcmp( Window_name, Exception_E ) == 0 ) return 0;
 if( lstrcmp( Window_name, Exception_F ) == 0 ) return 0;
 if( lstrcmp( Window_name, Exception_G ) == 0 ) return 0;

 // ᫨   -   ਫ,  ஢  㦭, .
 HWND Main_window = GetMainWindow( Window ); if( Main_window == Window ) return 1;

 // ,    ।   ਫ.
 if( Main_window != NULL ) GetClassName( Main_window, Window_name, SIZE_OF_NAME );
 else { Window_name[ 0 ] = NULL; Window_name[ 1 ] = NULL; }

 // ஢塞,     ਫ  ᯨ᪥ ᪫祭.
 if( lstrcmp( Window_name, Exception_D ) == 0 ) return 0;
 if( lstrcmp( Window_name, Exception_E ) == 0 ) return 0;
 if( lstrcmp( Window_name, Exception_F ) == 0 ) return 0;
 if( lstrcmp( Window_name, Exception_G ) == 0 ) return 0;

 // 뢠 .
 if( !Auxiliary_PermissionForKeyScrolling( Window ) ) return 0;

 // .
 return 1;
}
#endif

// ---  ஢, ࠭ ,  . ---

#ifndef IS_ACTIVE_IS_REPLACED
// Window । , ஥  ஢. ᫨  ࠭, 頥 1,  - 0.
BYTE IsActive( HWND Window )
{
 //  ,  ஥ ந室   .
 HWND Active_window = GetFocus();

 // ᫨  ஢塞 , 頥 1.
 if( Active_window == Window ) return 1;

 // ᫨   ਭ ஢塞, 頥 1.
 if( IsChild( Window, Active_window ) ) return 1;

 // ,    ࠭.
 Active_window = GetActiveWindow();

 // ᫨  ஢塞 , 頥 1.
 if( Active_window == Window ) return 1;

 // .
 return 0;
}
#endif

// --- ஢,    ᪮ ᬮ. ---

#ifndef IS_SCROLLBAR_IS_REPLACED
// Window । . ᫨  ᪠ ᬮ, 頥 1,  0.
// ᫨ Scroll_bars_only = 1,     饩 ᪮ ᬮ.
BYTE IsScrollBar( HWND Window, BYTE Scroll_bars_only )
{
 // ,    । .
 INT Length_of_name = GetClassName( Window, Window_caption, 255 );

 // ᫨  ᮤন ᫮ "ScrollBar"  "Scrollbar" -  ᪠ ᬮ:
 for( INT Count = 0; Count <= Length_of_name - 9; Count ++ )
  if( lstrcmpi( Window_caption + Count, ScrollBar_name ) == 0 ) return 1;

 // ᫨ ॡ ஢ ⮫쪮 騥 ᪨ ᬮ - .
 if( Scroll_bars_only ) return 0;

 // ᫨    ᯮ짮 ࠢ  :
 if( lstrcmp( Window_caption, FontLabSB_name ) == 0 ) return 1;
 if( lstrcmp( Window_caption, Split123_name ) == 0 ) return 1;
 if( lstrcmp( Window_caption, SplitWord_name ) == 0 ) return 1;

 // .
 return 0;
}
#endif

// --- 室     ᬮ  頥 㪠⥫    NULL. ---

#ifndef FIND_SCROLLBAR_IS_REPLACED
// Window । , Type ।,     - SB_VERT,  SB_HORZ.
//  祭 㤥 । SBFindProc(), 뢠  ॡ .
HWND FindScrollBar( HWND Window, INT Type )
{
 // 塞 ६, ।      .
 //  㤥 ᯮ짮  SBFindProc()  ॡ .
 Found_window = Window;
 Type_of_scroll_bar = Type;
 //  ६ । ᠬ , ᫨  㤥 .
 Scroll_bar = NULL;

 // ॡࠥ ୨ ,    .
 EnumChildWindows( Window, (WNDENUMPROC) SBFProc, NULL );

 // 頥 㪠⥫  , ᫨  뫠 ,  NULL.
 return Scroll_bar;
}
#endif

// --- 뢠  ॡ   ᪥. ---

#ifndef SB_FIND_PROC_IS_REPLACED
// Current_window ।   , lParam  ᯮ.
//        , । ࠭.
INT CALLBACK _export SBFindProc( HWND Current_window, LPARAM lParam )
{
 // ᯮ ᪨.
 RECT Rect = { 0, 0, 0, 0 };

 // ᫨  - ᪠ ᬮ   :
 if( IsScrollBar( Current_window, 1 ) ) if( IsWindowVisible( Current_window ) )
  {
   //  ﭨ ᪨.
   INT Scroll_begin = 0; INT Scroll_end = 0;
   GetScrollRange( Current_window, SB_CTL, &Scroll_begin, &Scroll_end );
	// ᫨ । ࠦ :
	if( !( Scroll_begin == 0 && Scroll_end == 0 ) )
    {
	  // ,   ᯮ.
     GetWindowRect( Current_window, &Rect );
     // ᫨   ࠧ ⠪ 饬:
     if( Type_of_scroll_bar == SB_VERT ) if( ( Rect.bottom - Rect.top ) > ( Rect.right - Rect.left ) )
      {
       // ⠭ ६,  । .
		 Scroll_bar = Current_window;
       // 頥 0  ४饭 ॡ .
		 return 0;
      }
     if( Type_of_scroll_bar == SB_HORZ ) if( ( Rect.right - Rect.left ) > ( Rect.bottom - Rect.top ) )
		{
       // ⠭ ६,  । .
       Scroll_bar = Current_window;
       // 頥 0  ४饭 ॡ .
       return 0;
      }
	 }
  }

 // 頥 1  த ॡ .
 return 1;
}
#endif

// ---   ᯨ᮪ ,   । . ---

#ifndef ADD_WINDOW_TO_LIST_IS_REPLACED
VOID AddWindowToList( HWND Window, UINT Message, LPARAM lParam )
{
 // ६  ᪠  祭 ᯨ᪠.
 INT Count = 0; INT Position = 0;
 INT xV = 0; INT yV = 0; BYTE VBar = 0; BYTE HBar = 0;

 // ,    । .
 GetClassName( Window, Window_name, SIZE_OF_NAME );
 // ࠭塞 ஡   ᫮.
 if( Window_name[ SIZE_OF_NAME - 2 ] == ' ' ) Window_name[ SIZE_OF_NAME - 2 ] = '_';

 // ᫨  ,   ࢮ  ᯨ᪥ - 頥 ࠧ .
 if( lstrcmp( Window_name, List[ 0 ].Name ) == 0 )
  {
   // ⠭, 㤠 諮 ᮮ饭.
   if( Message == WM_VSCROLL ) if( HIWORD( lParam ) == 0 ) List[ 0 ].VBar = 0; else if( IsWindow( HIWORD( lParam ) ) ) List[ 0 ].VBar = 1;
   if( Message == WM_HSCROLL ) if( HIWORD( lParam ) == 0 ) List[ 0 ].HBar = 0; else if( IsWindow( HIWORD( lParam ) ) ) List[ 0 ].HBar = 1;
   // .
	return;
  }

 // 饬   ᯨ᪥. ᫨  ,    ⠢ , ⮡ ᫥ ࠧ .
 for( Count = 1; Count < SIZE_OF_LIST; Count ++ )
  if( lstrcmp( Window_name, List[  Count  ].Name ) == 0 )
   {
    Position = Count;
    xV = List[  Count  ].xV;     yV = List[  Count  ].yV;
    VBar = List[  Count  ].VBar; HBar = List[  Count  ].HBar;

	 //  ᯨ᮪  ⮣   1 .    - SIZE_OF_NAME 㪢.
	 for( Count = Position; Count >= 1; Count -- )
     {
		lstrcpyn( List[  Count  ].Name, List[  Count - 1  ].Name, SIZE_OF_NAME );
      List[  Count  ].xV = List[  Count - 1  ].xV;     List[  Count  ].yV = List[  Count - 1  ].yV;
      List[  Count  ].VBar = List[  Count - 1  ].VBar; List[  Count  ].HBar = List[  Count - 1  ].HBar;
     }

    // ⠢  .
	 lstrcpyn( List[ 0 ].Name, Window_name, SIZE_OF_NAME );
    List[ 0 ].xV = xV; List[ 0 ].yV = yV; List[ 0 ].VBar = VBar; List[ 0 ].HBar = HBar;
	 // VBar  HBar 㪠뢠  , 㤠 뫮 祭 ᮮ饭. ᫨ HIWORD( lParam ) 
    // ࠢ ,   諮  ᮪, ਭ .  -  ᮪, ᯮ
    // ⤥쭮.  祭  ᥣ,    뫪 ᮮ饭.
	 if( Message == WM_VSCROLL ) if( HIWORD( lParam ) == 0 ) List[ 0 ].VBar = 0; else if( IsWindow( HIWORD( lParam ) ) ) List[ 0 ].VBar = 1;
    if( Message == WM_HSCROLL ) if( HIWORD( lParam ) == 0 ) List[ 0 ].HBar = 0; else if( IsWindow( HIWORD( lParam ) ) ) List[ 0 ].HBar = 1;

    //  , ⮬ 頥.
    return;
   }

 //  ᫨   뫮 ,    .
 //   ᯨ᮪    1 .    - SIZE_OF_NAME 㪢.
 for( Count = SIZE_OF_LIST - 1; Count >= 1; Count -- )
  {
   lstrcpyn( List[  Count  ].Name, List[  Count - 1  ].Name, SIZE_OF_NAME );
   List[  Count  ].xV = List[  Count - 1  ].xV;     List[  Count  ].yV = List[  Count - 1  ].yV;
   List[  Count  ].VBar = List[  Count - 1  ].VBar; List[  Count  ].HBar = List[  Count - 1  ].HBar;
  }

 // ᨬ   ᯨ᮪ -  㤥 . xV, yV, VBar  HBar ᭠砫  ।.
 lstrcpyn( List[ 0 ].Name, Window_name, SIZE_OF_NAME );
 List[ 0 ].xV = 0; List[ 0 ].yV = 0; List[ 0 ].VBar = -1; List[ 0 ].HBar = -1;
 if( Message == WM_VSCROLL ) if( HIWORD( lParam ) == 0 ) List[ 0 ].VBar = 0; else if( IsWindow( HIWORD( lParam ) ) ) List[ 0 ].VBar = 1;
 if( Message == WM_HSCROLL ) if( HIWORD( lParam ) == 0 ) List[ 0 ].HBar = 0; else if( IsWindow( HIWORD( lParam ) ) ) List[ 0 ].HBar = 1;

 // .
 return;
}
#endif

// --- 室   ᯨ᪥  頥 1  0. ---

#ifndef FIND_WINDOW_IN_LIST_IS_REPLACED
// ᫨   ᯥ,  ६ Record_from_list, । .
BYTE FindWindowInList( HWND Window )
{
 // ६  ᪠  祭 ᯨ᪠.
 INT Count = 0; INT Position = 0;
 INT xV = 0; INT yV = 0; BYTE VBar = 0; BYTE HBar = 0;

 // ,    । .
 GetClassName( Window, Window_name, SIZE_OF_NAME );
 // ࠭塞 ஡   ᫮.
 if( Window_name[ SIZE_OF_NAME - 2 ] == ' ' ) Window_name[ SIZE_OF_NAME - 2 ] = '_';

 // ᫨  ,   ࢮ  ᯨ᪥ - 頥 ࠧ .
 if( lstrcmp( Window_name, List[ 0 ].Name ) == 0 )
  {
   // 塞 ६, ।   ᯨ᪠. ᫥   㤥 ᯮ짮.
	Record_from_list.xV   = List[ 0 ].xV;   Record_from_list.yV = List[ 0 ].yV;
	Record_from_list.VBar = List[ 0 ].VBar; Record_from_list.HBar = List[ 0 ].HBar;
   // .
	return 1;
  }

 // ᫨  ,   ஥  ᯨ᪥ - 頥 ࠧ .
 if( lstrcmp( Window_name, List[ 1 ].Name ) == 0 )
  {
	// 塞 ६, ।   ᯨ᪠. ᫥   㤥 ᯮ짮.
   Record_from_list.xV   = List[ 1 ].xV;   Record_from_list.yV = List[ 1 ].yV;
	Record_from_list.VBar = List[ 1 ].VBar; Record_from_list.HBar = List[ 1 ].HBar;
   // .
   return 1;
  }

 // 饬   ᯨ᪥. ᫨  ,    ⠢ , ⮡ ᫥ ࠧ .
 for( Count = 2; Count < SIZE_OF_LIST; Count ++ )
  if( lstrcmp( Window_name, List[  Count  ].Name ) == 0 )
   {
	 Position = Count;
	 xV = List[  Count  ].xV;     yV = List[  Count  ].yV;
    VBar = List[  Count  ].VBar; HBar = List[  Count  ].HBar;

    //  ᯨ᮪  ⮣   1 .    - SIZE_OF_NAME 㪢.
    for( Count = Position; Count >= 1; Count -- )
     {
      lstrcpyn( List[  Count  ].Name, List[  Count - 1  ].Name, SIZE_OF_NAME );
      List[  Count  ].xV = List[  Count - 1  ].xV;     List[  Count  ].yV = List[  Count - 1  ].yV;
		List[  Count  ].VBar = List[  Count - 1  ].VBar; List[  Count  ].HBar = List[  Count - 1  ].HBar;
     }

    // ⠢  .
    lstrcpyn( List[ 0 ].Name, Window_name, SIZE_OF_NAME );
	 List[ 0 ].xV = xV; List[ 0 ].yV = yV; List[ 0 ].VBar = VBar; List[ 0 ].HBar = HBar;

    // 塞 ६, ।   ᯨ᪠. ᫥   㤥 ᯮ짮.
    Record_from_list.xV = xV; Record_from_list.yV = yV;
    Record_from_list.VBar = VBar; Record_from_list.HBar = HBar;

	 // 頥 1 -   ᯥ.
	 return 1;
   }

 // ᫨    - 頥 0. Record_from_list  .
 return 0;
}
#endif

// ---  窨  㪠 . ---

#ifndef GET_POINTS_FROM_WINDOW_IS_REPLACED
// Window । .
VOID GetPointsFromWindow( HWND Window )
{
 // ६  ࠡ  .
 RECT Rect = { 0, 0, 0, 0 };
 HDC Hdc = NULL;
 // 稪.
 INT Count = 0;
 INT Max_count = 0;

 // ⪠ X->  Y| ⠭   孨 㣮 . ७ -  窠.
 //  ࠧ .
 GetWindowRect( Window, &Rect );
 // Rect.top -   ᮢ. Rect.right - ਭ  ᮢ.
 Rect.top = Rect.bottom - Rect.top; Rect.right = Rect.right - Rect.left;

 // 窨 㤥    ࠧ஬ SIZE_OF_LINE * SIZE_OF_LINE * 2  .
 if( min( Rect.right, Rect.top ) / 4 > SIZE_OF_LINE ) Max_count = SIZE_OF_LINE;
 else Max_count = min( Rect.right, Rect.top ) / 4;

 // 稭 ࠡ  .
 Hdc = GetWindowDC( Window );

 //  窨 -  '>', ᯮ  ⮬ . ᫨ 窠 㯭, 
 // GetPixel() 頥 (-1), ᫨ 㯭 - 梥 窨,  ॢ  ⪮ ᫮.
 for( Count = Max_count - 1; Count >= 0; Count -= 1 )
  {
   Line_1[ Count ] = ByteFromRGB( GetPixel( Hdc, Rect.right/2 - Count, Rect.top/2 + Count ) );
	Line_2[ Count ] = ByteFromRGB( GetPixel( Hdc, Rect.right/2 - Count, Rect.top/2 - Count ) );
  }

 // 襭 ࠡ  .
 ReleaseDC( Window, Hdc );

 // .
 return;
}
#endif

// ---  窨  㪠 . ---

#ifndef FIND_POINTS_IS_REPLACED
//  窨  㪠   頥 ﭨ,  ஥  뫨 ᤢ.
// ᫨ ﭨ = 0,   । , 頥 0.
// Window । , Direction - ࠢ,  ஬ 뫮 ᤢ ࠦ,
// Supposition - ﭨ, ஥   ன.
INT FindPoints( HWND Window, WPARAM Direction, INT Supposition )
{
 // ६  ࠡ  .
 RECT Rect = { 0, 0, 0, 0 };
 HDC Hdc = NULL;
 // 稪.
 INT Count = 0;
 INT Max_count = 0;
 INT Count_for_lines = 0;
 // 쪮  ᮢ.
 INT Coincidences = 0;
 // 窠,  ன  ᮢ.
 INT Position = 0;
 //   蠣 - .
 INT Success = 0;

 // ⪠ X->  Y| ⠭   孨 㣮 . ७ -  窠.
 //  ࠧ .
 GetWindowRect( Window, &Rect );
 // Rect.top -  . Rect.right - ਭ .
 Rect.top = Rect.bottom - Rect.top; Rect.right = Rect.right - Rect.left;

 // 窨    ࠧ஬ SIZE_OF_LINE * SIZE_OF_LINE * 2  .
 if( min( Rect.right, Rect.top ) / 4 > SIZE_OF_LINE ) Max_count = SIZE_OF_LINE;
 else Max_count = min( Rect.right, Rect.top ) / 4;

 // 稭 ࠡ  .
 Hdc = GetWindowDC( Window );

 // ᫨ ࠦ 뫮 ᤢ :
 if( Direction == WM_VSCROLL )
  {
   //  ᪮, 饬 窨   ࠧ   ।  -  ᫨  ⠬, 頥 ﭨ.
	// ,  ⮬ 蠣 - 㤥 .
   Success = 1;
   // ਬ,  窨 ⠬ ᥩ. ᫨ 窠 㯭,  GetPixel() 頥 (-1).
	//  ॢ  ⪮ ᫮. ᫨  ᮢ - 뢠 .
   for( Count = Max_count - 1; Count >= 0; Count -= 1 )
    {
     // ᫨ ᮢ ,    ४頥 .
     if( Line_1[ Count ] != ByteFromRGB( GetPixel( Hdc, Rect.right/2 - Count, Rect.top/2 + Count - Supposition ) ) ) { Success = 0; break; }
     if( Line_2[ Count ] != ByteFromRGB( GetPixel( Hdc, Rect.right/2 - Count, Rect.top/2 - Count - Supposition ) ) ) { Success = 0; break; }
	 }
	// ᫨ 뫮 ᮢ - 窨   ⮬   - ୥  ﭨ.
   if( Success == 1 ) Position = Supposition;
	//  - ஢   ᥩ .  ᪠ - Max_count.
   else
    {
     // 饬 窨      稭  ⮣,   뫨 -  ᫨ ,
     // 頥 ﭨ. ᫨  ᪮쪮 ᮢ, 頥 0.
     for( Count_for_lines = 0; Count_for_lines < Max_count; Count_for_lines += 1 )
		{
       // ,  ⮬ 蠣 - 㤥 .
		 Success = 1;
       // ਬ,  窨 ⠬ ᥩ. ᫨ 窠 㯭,  GetPixel() 頥 (-1).
       //  ॢ  ⪮ ᫮. ᫨  ᮢ - 뢠 .
		 for( Count = Max_count - 1; Count >= 0; Count -= 1 )
        {
         // ᫨ ᮢ ,    ४頥 .
         if( Line_1[ Count ] != ByteFromRGB( GetPixel( Hdc, Rect.right/2 - Count, Rect.top/2 + Count - Count_for_lines ) ) ) { Success = 0; break; }
         if( Line_2[ Count ] != ByteFromRGB( GetPixel( Hdc, Rect.right/2 - Count, Rect.top/2 - Count - Count_for_lines ) ) ) { Success = 0; break; }
        }
		  // ᫨ 뫮 ᮢ  ⮬ 蠣.
		  if( Success == 1 )
         {
			 // 稢 稪 ᮢ   ﭨ.
          Coincidences += 1; Position = Count_for_lines;
          // ᫨ ᮢ  1, ४頥   ᥩ .
          if( Coincidences > 1 ) Position = 0;
          // ᫨ ᮢ 뫮 ࠧ    뫮  1, 頥 0.
          if( Position == 0 ) break;
			}
      }
	 }
  }

 // ᫨ ࠦ 뫮 ᤢ ࠢ:
 if( Direction == WM_HSCROLL )
  {
   //  ᪮, 饬 窨   ࠧ   ।  -  ᫨  ⠬, 頥 ﭨ.
   // ,  ⮬ 蠣 - 㤥 .
   Success = 1;
	// ਬ,  窨 ⠬ ᥩ. ᫨ 窠 㯭,  GetPixel() 頥 (-1).
	//  ॢ  ⪮ ᫮. ᫨  ᮢ - 뢠 .
   for( Count = Max_count - 1; Count >= 0; Count -= 1 )
	 {
     // ᫨ ᮢ ,    ४頥 .
     if( Line_1[ Count ] != ByteFromRGB( GetPixel( Hdc, Rect.right/2 - Count - Supposition, Rect.top/2 + Count ) ) ) { Success = 0; break; }
     if( Line_2[ Count ] != ByteFromRGB( GetPixel( Hdc, Rect.right/2 - Count - Supposition, Rect.top/2 - Count ) ) ) { Success = 0; break; }
    }
   // ᫨ 뫮 ᮢ - 窨   ⮬   - ୥  ﭨ.
	if( Success == 1 ) Position = Supposition;
   //  - p   ᥩ .  ᪠ - Max_count.
	else
    {
     // 饬 窨      稭  ⮣,   뫨 -  ᫨ ,
	  // 頥 ﭨ. ᫨  ᪮쪮 ᮢ, 頥 0.
     for( Count_for_lines = 0; Count_for_lines < Max_count; Count_for_lines += 1 )
      {
       // ,  ⮬ 蠣 - 㤥 .
       Success = 1;
       // ਬ,  窨 ⠬ ᥩ. ᫨ 窠 㯭,  GetPixel() 頥 (-1).
		 //  ॢ  ⪮ ᫮. ᫨  ᮢ - 뢠 .
		 for( Count = Max_count - 1; Count >= 0; Count -= 1 )
        {
			// ᫨ ᮢ ,    ४頥 .
         if( Line_1[ Count ] != ByteFromRGB( GetPixel( Hdc, Rect.right/2 - Count - Count_for_lines, Rect.top/2 + Count ) ) ) { Success = 0; break; }
         if( Line_2[ Count ] != ByteFromRGB( GetPixel( Hdc, Rect.right/2 - Count - Count_for_lines, Rect.top/2 - Count ) ) ) { Success = 0; break; }
        }
        // ᫨ 뫮 ᮢ  ⮬ 蠣.
        if( Success == 1 )
			{
          // 稢 稪 ᮢ   ﭨ.
			 Coincidences += 1; Position = Count_for_lines;
          // ᫨ ᮢ  1, ४頥   ᥩ .
          if( Coincidences > 1 ) Position = 0;
			 // ᫨ ᮢ 뫮 ࠧ    뫮  1, 頥 0.
          if( Position == 0 ) break;
         }
      }
    }
  }

 // 蠥 ࠡ  .
 ReleaseDC( Window, Hdc );

 // 頥 । 祭 - ﭨ  0.
 return Position;
}
#endif

// ---  ࠦ  ⮬ Scroll Lock. ---

#ifndef SCROLL_IMAGE_IS_REPLACED
// Key । .
VOID ScrollImage( WPARAM Key )
{
 // ६    । ﭨ ᮪.
 HWND Window = NULL; HWND Parent_window = NULL; HWND Target_window = NULL;
 HWND SB_Control = NULL; INT Scroll_position = 0; INT Scroll_begin = 0; INT Scroll_end = 0;
 // ।,     ⥫ ᮮ饭  ⨨ ५.
 BYTE Supplementary_messages = 0;

 //  ,  ஥ ந室   .
 Window = GetFocus();

 // ᫨ ⠪   - .
 if( Window == NULL ) return;

 // ࠭ ⠭ ६, ।   ᯨ᪠ . 祭 -   ।.
 Record_from_list.xV = 0; Record_from_list.yV = 0; Record_from_list.VBar = -1; Record_from_list.HBar = -1;

 // 饬   ᯨ᪥. ᫨  ,  ᮮ饭 㤥 뫠 .
 if( FindWindowInList( Window ) == 1 )
  {
   // 㤥 뫠 ᮮ饭 .
	Target_window = Window;
   //  த⥫᪮ .
   if( GetWindowLong( Window, GWL_STYLE ) & WS_CHILD ) Parent_window = GetParent( Window );
  }
 //  ᫨  ,  த⥫᪮ .
 else
  {
	//  த⥫᪮ .
   if( GetWindowLong( Window, GWL_STYLE ) & WS_CHILD ) Parent_window = GetParent( Window );
	// ᫨      ᯨ᪥:
   if( Parent_window != NULL ) if( FindWindowInList( Parent_window ) == 1 )
    {
     // 㤥 뫠 ᮮ饭 த⥫᪮ .
     Target_window = Parent_window;
     //  ᫥饥 த⥫᪮ .
	  if( GetWindowLong( Parent_window, GWL_STYLE ) & WS_CHILD ) Parent_window = GetParent( Parent_window );
    }
  }

 // ᫨    - .
 if( Target_window == NULL ) return;

 //    । ࠦ  .
 BYTE Reply = PermissionForKeyScrolling( Target_window ); if( Reply == 0 ) return;
 //      뫠 ⥫ ᮮ饭.
 if( Reply == 2 ) Supplementary_messages = 1;

 //  , 祭 ᫥ ᪠.
 BYTE Window_VBar = Record_from_list.VBar; BYTE Window_HBar = Record_from_list.HBar;

 //   ?
 switch( Key )
  {
   // ᫨  ५ , :
   case VK_UP:
	 // ᫨  砥 ᮮ饭  ᢮ ᪨:
    if( Window_VBar == 0 )
	  {
      // ,   ﭨ ᪠:
      if( GetWindowLong( Target_window, GWL_STYLE ) & WS_VSCROLL )
		 {
        // ,    ﭨ:
        Scroll_position = GetScrollPos( Target_window, SB_VERT );
        GetScrollRange( Target_window, SB_VERT, &Scroll_begin, &Scroll_end );
       }
      // ᫨    - 㧭,   ﭨ ᪠ த⥫᪮ :
		if( Scroll_begin == 0 && Scroll_end == 0 ) if( Parent_window != NULL )
		 {
        // ⠭ ६, ।   ᯨ᪠ . 祭 -   ।.
		  Record_from_list.xV = 0; Record_from_list.yV = 0; Record_from_list.VBar = -1; Record_from_list.HBar = -1;
        // 室  ᯨ᪥ த⥫᪮ .
        FindWindowInList( Parent_window );
        // ᫨ த⥫᪮    । ࠦ :
        if( !( Record_from_list.xV == 0 && Record_from_list.yV == 0 ) )
         if( PermissionForKeyScrolling( Parent_window ) != 0 )
			 // ᫨  । ᢥ  த⥫᪮  砥 ᮮ饭  ᢮ ᪨:
          if( Record_from_list.VBar == 0 )
			  {
            // ,   ﭨ ᪠:
            if( GetWindowLong( Parent_window, GWL_STYLE ) & WS_VSCROLL )
				 {
              // ,   ﭨ ᪠:
              Scroll_position = GetScrollPos( Parent_window, SB_VERT );
              GetScrollRange( Parent_window, SB_VERT, &Scroll_begin, &Scroll_end );
             }
            // ᫨   - 㤥 । ࠦ  த⥫᪮ .
				if( !( Scroll_begin == 0 && Scroll_end == 0 ) ) Target_window = Parent_window;
			  }
          //  ᫨  த⥫᪮  뫠 ᮧ ⤥쭠 ᪠,    .
			 else if( Record_from_list.VBar == 1 )
           {
            // 饬   .
            SB_Control = FindScrollBar( Parent_window, SB_VERT );
            // ,    ﭨ.
            if( SB_Control != NULL )
				 {
              // ,   ﭨ ᪠.
				  Scroll_position = GetScrollPos( SB_Control, SB_CTL );
              GetScrollRange( SB_Control, SB_CTL, &Scroll_begin, &Scroll_end );
             }
				// ᫨   - 㤥 । ࠦ  த⥫᪮ .
            if( !( Scroll_begin == 0 && Scroll_end == 0 ) ) Target_window = Parent_window;
           }
        }
     }
    //  ᫨   뫠 ᮧ ⤥쭠 ᪠,    ,  lParam ᮮ饭 㤥 㪠뢠  .
	 else if( Window_VBar == 1 )
	  {
      // ᪠   ᯮ  ᠬ .
		SB_Control = FindScrollBar( Target_window, SB_VERT );
      // ᫨ ᪠  - 㧭,    ﭨ.
      if( SB_Control != NULL )
       {
        // ,   ﭨ ᪠.
        Scroll_position = GetScrollPos( SB_Control, SB_CTL );
		  GetScrollRange( SB_Control, SB_CTL, &Scroll_begin, &Scroll_end );
       }
		// ᫨ ᪨  -    ᯮ 冷  .
      else if( Parent_window != NULL )
       {
		  // ⠭ ६, ।   ᯨ᪠ . 祭 -   ।.
        Record_from_list.xV = 0; Record_from_list.yV = 0; Record_from_list.VBar = -1; Record_from_list.HBar = -1;
        // 室  ᯨ᪥ த⥫᪮ .
        FindWindowInList( Parent_window );
        // ᫨ த⥫᪮    । ࠦ :
        if( !( Record_from_list.xV == 0 && Record_from_list.yV == 0 ) )
			if( PermissionForKeyScrolling( Parent_window ) != 0 )
			 // ᫨  । ᢥ  த⥫᪮  砥 ᮮ饭  ᢮ ᪨:
          if( Record_from_list.VBar == 0 )
			  {
            // ,   ﭨ ᪠:
            if( GetWindowLong( Parent_window, GWL_STYLE ) & WS_VSCROLL )
             {
              // ,   ﭨ ᪠:
              Scroll_position = GetScrollPos( Parent_window, SB_VERT );
				  GetScrollRange( Parent_window, SB_VERT, &Scroll_begin, &Scroll_end );
             }
				// ᫨   - 㤥 । ࠦ  த⥫᪮ .
            if( !( Scroll_begin == 0 && Scroll_end == 0 ) ) Target_window = Parent_window;
           }
			 //  ᫨  த⥫᪮  뫠 ᮧ ⤥쭠 ᪠,    .
          else if( Record_from_list.VBar == 1 )
           {
            // 饬   .
            SB_Control = FindScrollBar( Parent_window, SB_VERT );
            // ,   ﭨ ᪠.
				if( SB_Control != NULL )
				 {
              // ,    ﭨ.
				  Scroll_position = GetScrollPos( SB_Control, SB_CTL );
              GetScrollRange( SB_Control, SB_CTL, &Scroll_begin, &Scroll_end );
             }
            // ᫨   - 㤥 । ࠦ  த⥫᪮ .
            if( !( Scroll_begin == 0 && Scroll_end == 0 ) ) Target_window = Parent_window;
           }
		  }
     }

    // ᫨ ᪠ ,  । ࠦ , :
    if( !( Scroll_begin == 0 && Scroll_end == 0 ) ) if( Scroll_position > Scroll_begin )
	  {
      // 稭 ।.
      Key_scrolling = 0;
      // 뫠 ᮮ饭  ⨨  ⦠⨨ Alt - ⮡  , ᫨  ࠭.
      if( Disable_menu > 0 ) { PostMessage( Window, WM_KEYDOWN, VK_MENU, 0 ); PostMessage( Window, WM_KEYUP, VK_MENU, 0 ); }
      //  ࠦ   ⮪.
		SendMessage( Target_window, WM_VSCROLL, SB_LINEUP, MAKELONG( 0, SB_Control ) );
		// 뫠 ᮮ饭  ⨨  ⦠⨨ ५ , ᫨  ॡ.
      if( Supplementary_messages == 1 ) { SendMessage( Window, WM_KEYDOWN, VK_UP, VK_UP_1 ); SendMessage( Window, WM_KEYUP, VK_UP, VK_UP_2 ); }
		// 蠥 ।.
      Key_scrolling = 1;
     }
   break;

   // ᫨  ५ , :
	case VK_DOWN:
    // ᫨  砥 ᮮ饭  ᢮ ᪨:
	 if( Window_VBar == 0 )
     {
      // ,   ﭨ ᪠:
		if( GetWindowLong( Target_window, GWL_STYLE ) & WS_VSCROLL )
       {
        // ,    ﭨ:
        Scroll_position = GetScrollPos( Target_window, SB_VERT );
        GetScrollRange( Target_window, SB_VERT, &Scroll_begin, &Scroll_end );
       }
		// ᫨    - 㧭,   ﭨ ᪠ த⥫᪮ :
		if( Scroll_begin == 0 && Scroll_end == 0 ) if( Parent_window != NULL )
       {
		  // ⠭ ६, ।   ᯨ᪠ . 祭 -   ।.
        Record_from_list.xV = 0; Record_from_list.yV = 0; Record_from_list.VBar = -1; Record_from_list.HBar = -1;
        // 室  ᯨ᪥ த⥫᪮ .
        FindWindowInList( Parent_window );
        // ᫨ த⥫᪮    । ࠦ :
        if( !( Record_from_list.xV == 0 && Record_from_list.yV == 0 ) )
			if( PermissionForKeyScrolling( Parent_window ) != 0 )
          // ᫨  । ᢥ  த⥫᪮  砥 ᮮ饭  ᢮ ᪨:
			 if( Record_from_list.VBar == 0 )
           {
            // ,   ﭨ ᪠:
				if( GetWindowLong( Parent_window, GWL_STYLE ) & WS_VSCROLL )
             {
              // ,   ﭨ ᪠:
              Scroll_position = GetScrollPos( Parent_window, SB_VERT );
              GetScrollRange( Parent_window, SB_VERT, &Scroll_begin, &Scroll_end );
             }
				// ᫨   - 㤥 । ࠦ  த⥫᪮ .
				if( !( Scroll_begin == 0 && Scroll_end == 0 ) ) Target_window = Parent_window;
           }
			 //  ᫨  த⥫᪮  뫠 ᮧ ⤥쭠 ᪠,    .
          else if( Record_from_list.VBar == 1 )
           {
            // 饬   .
            SB_Control = FindScrollBar( Parent_window, SB_VERT );
            // ,    ﭨ.
				if( SB_Control != NULL )
             {
				  // ,   ﭨ ᪠.
              Scroll_position = GetScrollPos( SB_Control, SB_CTL );
              GetScrollRange( SB_Control, SB_CTL, &Scroll_begin, &Scroll_end );
				 }
            // ᫨   - 㤥 । ࠦ  த⥫᪮ .
            if( !( Scroll_begin == 0 && Scroll_end == 0 ) ) Target_window = Parent_window;
           }
        }
     }
	 //  ᫨   뫠 ᮧ ⤥쭠 ᪠,    ,  lParam ᮮ饭 㤥 㪠뢠  .
	 else if( Window_VBar == 1 )
     {
		// ᪠   ᯮ  ᠬ .
      SB_Control = FindScrollBar( Target_window, SB_VERT );
      // ᫨ ᪠  - 㧭,    ﭨ.
      if( SB_Control != NULL )
       {
        // ,   ﭨ ᪠.
		  Scroll_position = GetScrollPos( SB_Control, SB_CTL );
        GetScrollRange( SB_Control, SB_CTL, &Scroll_begin, &Scroll_end );
		 }
      // ᫨ ᪨  -    ᯮ 冷  .
      else if( Parent_window != NULL )
		 {
        // ⠭ ६, ।   ᯨ᪠ . 祭 -   ।.
        Record_from_list.xV = 0; Record_from_list.yV = 0; Record_from_list.VBar = -1; Record_from_list.HBar = -1;
        // 室  ᯨ᪥ த⥫᪮ .
        FindWindowInList( Parent_window );
        // ᫨ த⥫᪮    । ࠦ :
		  if( !( Record_from_list.xV == 0 && Record_from_list.yV == 0 ) )
			if( PermissionForKeyScrolling( Parent_window ) != 0 )
          // ᫨  । ᢥ  த⥫᪮  砥 ᮮ饭  ᢮ ᪨:
			 if( Record_from_list.VBar == 0 )
           {
            // ,   ﭨ ᪠:
            if( GetWindowLong( Parent_window, GWL_STYLE ) & WS_VSCROLL )
             {
              // ,   ﭨ ᪠:
				  Scroll_position = GetScrollPos( Parent_window, SB_VERT );
              GetScrollRange( Parent_window, SB_VERT, &Scroll_begin, &Scroll_end );
				 }
            // ᫨   - 㤥 । ࠦ  த⥫᪮ .
            if( !( Scroll_begin == 0 && Scroll_end == 0 ) ) Target_window = Parent_window;
			  }
          //  ᫨  த⥫᪮  뫠 ᮧ ⤥쭠 ᪠,    .
          else if( Record_from_list.VBar == 1 )
           {
            // 饬   .
            SB_Control = FindScrollBar( Parent_window, SB_VERT );
				// ,   ﭨ ᪠.
				if( SB_Control != NULL )
             {
				  // ,    ﭨ.
              Scroll_position = GetScrollPos( SB_Control, SB_CTL );
              GetScrollRange( SB_Control, SB_CTL, &Scroll_begin, &Scroll_end );
             }
            // ᫨   - 㤥 । ࠦ  த⥫᪮ .
            if( !( Scroll_begin == 0 && Scroll_end == 0 ) ) Target_window = Parent_window;
			  }
        }
	  }

    // ᫨ ᪠ ,  । ࠦ , :
	 if( !( Scroll_begin == 0 && Scroll_end == 0 ) ) if( Scroll_position < Scroll_end )
     {
      // 稭 ।.
      Key_scrolling = 0;
      // 뫠 ᮮ饭  ⨨  ⦠⨨ Alt - ⮡  , ᫨  ࠭.
      if( Disable_menu > 0 ) { PostMessage( Window, WM_KEYDOWN, VK_MENU, 0 ); PostMessage( Window, WM_KEYUP, VK_MENU, 0 ); }
		//  ࠦ   ⮪.
		SendMessage( Target_window, WM_VSCROLL, SB_LINEDOWN, MAKELONG( 0, SB_Control ) );
      // 뫠 ᮮ饭  ⨨  ⦠⨨ ५ , ᫨  ॡ.
		if( Supplementary_messages == 1 ) { SendMessage( Window, WM_KEYDOWN, VK_DOWN, VK_DOWN_1 ); SendMessage( Window, WM_KEYUP, VK_DOWN, VK_DOWN_2 ); }
      // 蠥 ।.
      Key_scrolling = 1;
     }
   break;

	// ᫨  ५ , :
   case VK_LEFT:
	 // ᫨  砥 ᮮ饭  ᢮ ᪨:
    if( Window_HBar == 0 )
     {
		// ,   ﭨ ᪠:
      if( GetWindowLong( Target_window, GWL_STYLE ) & WS_HSCROLL )
       {
        // ,    ﭨ:
        Scroll_position = GetScrollPos( Target_window, SB_HORZ );
        GetScrollRange( Target_window, SB_HORZ, &Scroll_begin, &Scroll_end );
		 }
		// ᫨    - 㧭,   ﭨ ᪠ த⥫᪮ :
      if( Scroll_begin == 0 && Scroll_end == 0 ) if( Parent_window != NULL )
		 {
        // ⠭ ६, ।   ᯨ᪠ . 祭 -   ।.
        Record_from_list.xV = 0; Record_from_list.yV = 0; Record_from_list.HBar = -1; Record_from_list.HBar = -1;
        // 室  ᯨ᪥ த⥫᪮ .
        FindWindowInList( Parent_window );
        // ᫨ த⥫᪮    । ࠦ :
		  if( !( Record_from_list.xV == 0 && Record_from_list.yV == 0 ) )
         if( PermissionForKeyScrolling( Parent_window ) != 0 )
			 // ᫨  । ᢥ  த⥫᪮  砥 ᮮ饭  ᢮ ᪨:
          if( Record_from_list.HBar == 0 )
           {
				// ,   ﭨ ᪠:
            if( GetWindowLong( Parent_window, GWL_STYLE ) & WS_HSCROLL )
             {
              // ,   ﭨ ᪠:
              Scroll_position = GetScrollPos( Parent_window, SB_HORZ );
              GetScrollRange( Parent_window, SB_HORZ, &Scroll_begin, &Scroll_end );
				 }
				// ᫨   - 㤥 । ࠦ  த⥫᪮ .
            if( !( Scroll_begin == 0 && Scroll_end == 0 ) ) Target_window = Parent_window;
			  }
          //  ᫨  த⥫᪮  뫠 ᮧ ⤥쭠 ᪠,    .
          else if( Record_from_list.HBar == 1 )
           {
            // 饬   .
            SB_Control = FindScrollBar( Parent_window, SB_HORZ );
				// ,    ﭨ.
            if( SB_Control != NULL )
				 {
              // ,   ﭨ ᪠.
              Scroll_position = GetScrollPos( SB_Control, SB_CTL );
				  GetScrollRange( SB_Control, SB_CTL, &Scroll_begin, &Scroll_end );
             }
            // ᫨   - 㤥 । ࠦ  த⥫᪮ .
            if( !( Scroll_begin == 0 && Scroll_end == 0 ) ) Target_window = Parent_window;
           }
        }
	  }
	 //  ᫨   뫠 ᮧ ⤥쭠 ᪠,    ,  lParam ᮮ饭 㤥 㪠뢠  .
    else if( Window_HBar == 1 )
	  {
      // ᪠   ᯮ  ᠬ .
      SB_Control = FindScrollBar( Target_window, SB_HORZ );
      // ᫨ ᪠  - 㧭,    ﭨ.
      if( SB_Control != NULL )
       {
		  // ,   ﭨ ᪠.
        Scroll_position = GetScrollPos( SB_Control, SB_CTL );
		  GetScrollRange( SB_Control, SB_CTL, &Scroll_begin, &Scroll_end );
       }
      // ᫨ ᪨  -    ᯮ 冷  .
		else if( Parent_window != NULL )
       {
        // ⠭ ६, ।   ᯨ᪠ . 祭 -   ।.
        Record_from_list.xV = 0; Record_from_list.yV = 0; Record_from_list.HBar = -1; Record_from_list.HBar = -1;
        // 室  ᯨ᪥ த⥫᪮ .
        FindWindowInList( Parent_window );
		  // ᫨ த⥫᪮    । ࠦ :
		  if( !( Record_from_list.xV == 0 && Record_from_list.yV == 0 ) )
         if( PermissionForKeyScrolling( Parent_window ) != 0 )
			 // ᫨  । ᢥ  த⥫᪮  砥 ᮮ饭  ᢮ ᪨:
          if( Record_from_list.HBar == 0 )
           {
            // ,   ﭨ ᪠:
            if( GetWindowLong( Parent_window, GWL_STYLE ) & WS_HSCROLL )
             {
				  // ,   ﭨ ᪠:
              Scroll_position = GetScrollPos( Parent_window, SB_HORZ );
				  GetScrollRange( Parent_window, SB_HORZ, &Scroll_begin, &Scroll_end );
             }
            // ᫨   - 㤥 । ࠦ  த⥫᪮ .
				if( !( Scroll_begin == 0 && Scroll_end == 0 ) ) Target_window = Parent_window;
           }
          //  ᫨  த⥫᪮  뫠 ᮧ ⤥쭠 ᪠,    .
          else if( Record_from_list.HBar == 1 )
           {
            // 饬   .
				SB_Control = FindScrollBar( Parent_window, SB_HORZ );
				// ,   ﭨ ᪠.
            if( SB_Control != NULL )
				 {
              // ,    ﭨ.
              Scroll_position = GetScrollPos( SB_Control, SB_CTL );
              GetScrollRange( SB_Control, SB_CTL, &Scroll_begin, &Scroll_end );
             }
            // ᫨   - 㤥 । ࠦ  த⥫᪮ .
				if( !( Scroll_begin == 0 && Scroll_end == 0 ) ) Target_window = Parent_window;
           }
		  }
     }

	 // ᫨ ᪠ ,  । ࠦ , :
    if( !( Scroll_begin == 0 && Scroll_end == 0 ) ) if( Scroll_position > Scroll_begin )
     {
      // 稭 ।.
      Key_scrolling = 0;
      // 뫠 ᮮ饭  ⨨  ⦠⨨ Alt - ⮡  , ᫨  ࠭.
		if( Disable_menu > 0 ) { PostMessage( Window, WM_KEYDOWN, VK_MENU, 0 ); PostMessage( Window, WM_KEYUP, VK_MENU, 0 ); }
		//  ࠦ   ⮪.
      SendMessage( Target_window, WM_HSCROLL, SB_LINEUP, MAKELONG( 0, SB_Control ) );
		// 뫠 ᮮ饭  ⨨  ⦠⨨ ५ , ᫨  ॡ.
      if( Supplementary_messages == 1 ) { SendMessage( Window, WM_KEYDOWN, VK_LEFT, VK_LEFT_1 ); SendMessage( Window, WM_KEYUP, VK_LEFT, VK_LEFT_2 ); }
      // 蠥 ।.
      Key_scrolling = 1;
     }
   break;

   // ᫨  ५ ࠢ, :
	case VK_RIGHT:
    // ᫨  砥 ᮮ饭  ᢮ ᪨:
    if( Window_HBar == 0 )
	  {
      // ,   ﭨ ᪠:
      if( GetWindowLong( Target_window, GWL_STYLE ) & WS_HSCROLL )
       {
        // ,    ﭨ:
        Scroll_position = GetScrollPos( Target_window, SB_HORZ );
		  GetScrollRange( Target_window, SB_HORZ, &Scroll_begin, &Scroll_end );
		 }
      // ᫨    - 㧭,   ﭨ ᪠ த⥫᪮ :
		if( Scroll_begin == 0 && Scroll_end == 0 ) if( Parent_window != NULL )
       {
        // ⠭ ६, ।   ᯨ᪠ . 祭 -   ।.
        Record_from_list.xV = 0; Record_from_list.yV = 0; Record_from_list.HBar = -1; Record_from_list.HBar = -1;
        // 室  ᯨ᪥ த⥫᪮ .
        FindWindowInList( Parent_window );
		  // ᫨ த⥫᪮    । ࠦ :
        if( !( Record_from_list.xV == 0 && Record_from_list.yV == 0 ) )
			if( PermissionForKeyScrolling( Parent_window ) != 0 )
          // ᫨  । ᢥ  த⥫᪮  砥 ᮮ饭  ᢮ ᪨:
          if( Record_from_list.HBar == 0 )
			  {
            // ,   ﭨ ᪠:
            if( GetWindowLong( Parent_window, GWL_STYLE ) & WS_HSCROLL )
             {
              // ,   ﭨ ᪠:
              Scroll_position = GetScrollPos( Parent_window, SB_HORZ );
				  GetScrollRange( Parent_window, SB_HORZ, &Scroll_begin, &Scroll_end );
				 }
            // ᫨   - 㤥 । ࠦ  த⥫᪮ .
				if( !( Scroll_begin == 0 && Scroll_end == 0 ) ) Target_window = Parent_window;
           }
          //  ᫨  த⥫᪮  뫠 ᮧ ⤥쭠 ᪠,    .
          else if( Record_from_list.HBar == 1 )
           {
            // 饬   .
				SB_Control = FindScrollBar( Parent_window, SB_HORZ );
            // ,    ﭨ.
				if( SB_Control != NULL )
             {
              // ,   ﭨ ᪠.
				  Scroll_position = GetScrollPos( SB_Control, SB_CTL );
              GetScrollRange( SB_Control, SB_CTL, &Scroll_begin, &Scroll_end );
             }
            // ᫨   - 㤥 । ࠦ  த⥫᪮ .
            if( !( Scroll_begin == 0 && Scroll_end == 0 ) ) Target_window = Parent_window;
           }
		  }
	  }
    //  ᫨   뫠 ᮧ ⤥쭠 ᪠,    ,  lParam ᮮ饭 㤥 㪠뢠  .
	 else if( Window_HBar == 1 )
     {
      // ᪠   ᯮ  ᠬ .
      SB_Control = FindScrollBar( Target_window, SB_HORZ );
      // ᫨ ᪠  - 㧭,    ﭨ.
      if( SB_Control != NULL )
		 {
        // ,   ﭨ ᪠.
		  Scroll_position = GetScrollPos( SB_Control, SB_CTL );
        GetScrollRange( SB_Control, SB_CTL, &Scroll_begin, &Scroll_end );
       }
		// ᫨ ᪨  -    ᯮ 冷  .
      else if( Parent_window != NULL )
       {
        // ⠭ ६, ।   ᯨ᪠ . 祭 -   ।.
        Record_from_list.xV = 0; Record_from_list.yV = 0; Record_from_list.HBar = -1; Record_from_list.HBar = -1;
        // 室  ᯨ᪥ த⥫᪮ .
		  FindWindowInList( Parent_window );
		  // ᫨ த⥫᪮    । ࠦ :
        if( !( Record_from_list.xV == 0 && Record_from_list.yV == 0 ) )
			if( PermissionForKeyScrolling( Parent_window ) != 0 )
          // ᫨  । ᢥ  த⥫᪮  砥 ᮮ饭  ᢮ ᪨:
          if( Record_from_list.HBar == 0 )
           {
            // ,   ﭨ ᪠:
            if( GetWindowLong( Parent_window, GWL_STYLE ) & WS_HSCROLL )
				 {
              // ,   ﭨ ᪠:
				  Scroll_position = GetScrollPos( Parent_window, SB_HORZ );
              GetScrollRange( Parent_window, SB_HORZ, &Scroll_begin, &Scroll_end );
             }
				// ᫨   - 㤥 । ࠦ  த⥫᪮ .
            if( !( Scroll_begin == 0 && Scroll_end == 0 ) ) Target_window = Parent_window;
           }
          //  ᫨  த⥫᪮  뫠 ᮧ ⤥쭠 ᪠,    .
          else if( Record_from_list.HBar == 1 )
           {
				// 饬   .
				SB_Control = FindScrollBar( Parent_window, SB_HORZ );
            // ,   ﭨ ᪠.
				if( SB_Control != NULL )
             {
              // ,    ﭨ.
              Scroll_position = GetScrollPos( SB_Control, SB_CTL );
              GetScrollRange( SB_Control, SB_CTL, &Scroll_begin, &Scroll_end );
             }
				// ᫨   - 㤥 । ࠦ  த⥫᪮ .
            if( !( Scroll_begin == 0 && Scroll_end == 0 ) ) Target_window = Parent_window;
			  }
        }
     }

    // ᫨ ᪠ ,  । ࠦ , :
    if( !( Scroll_begin == 0 && Scroll_end == 0 ) ) if( Scroll_position < Scroll_end )
     {
      // 稭 ।.
      Key_scrolling = 0;
		// 뫠 ᮮ饭  ⨨  ⦠⨨ Alt - ⮡  , ᫨  ࠭.
		if( Disable_menu > 0 ) { PostMessage( Window, WM_KEYDOWN, VK_MENU, 0 ); PostMessage( Window, WM_KEYUP, VK_MENU, 0 ); }
      //  ࠦ   ⮪.
		SendMessage( Target_window, WM_HSCROLL, SB_LINEDOWN, MAKELONG( 0, SB_Control ) );
      // 뫠 ᮮ饭  ⨨  ⦠⨨ ५ ࠢ, ᫨  ॡ.
      if( Supplementary_messages == 1 ) { SendMessage( Window, WM_KEYDOWN, VK_RIGHT, VK_RIGHT_1 ); SendMessage( Window, WM_KEYUP, VK_RIGHT, VK_RIGHT_2 ); }
      // 蠥 ।.
      Key_scrolling = 1;
     }
	break;
  }

 // .
 return;
}
#endif

// --- 稭 । ࠦ   . ---

#ifndef BEGIN_DRAGGING_IS_REPLACED
// Window । ,   ᯮ 㪠⥫ .
VOID BeginDragging( HWND Window, INT X, INT Y )
{
 // ᫨   - .
 if( !IsWindow( Window ) ) return;

 // ६  । ﭨ ᮪.
 INT VScroll_begin = 0; INT VScroll_end = 0; INT HScroll_begin = 0; INT HScroll_end = 0;
 // । த⥫᪮ .
 HWND Parent_window = NULL;

 // ࠭ ⠭ ६, ।   ᯨ᪠ . 祭 -   ।.
 Record_from_list.xV = 0; Record_from_list.yV = 0; Record_from_list.VBar = -1; Record_from_list.HBar = -1;

 // 饬   ᯨ᪥. ᫨  ,  ᮮ饭 㤥 뫠 .
 if( FindWindowInList( Window ) == 1 )
  {
   // 㤥 뫠 ᮮ饭 .
   Dragging_window = Window;
   //  த⥫᪮ .
	if( GetWindowLong( Window, GWL_STYLE ) & WS_CHILD ) Parent_window = GetParent( Window );
  }
 //  ᫨  ,  த⥫᪮ .
 else
  {
   //  த⥫᪮ .
   if( GetWindowLong( Window, GWL_STYLE ) & WS_CHILD ) Parent_window = GetParent( Window );
   // ᫨      ᯨ᪥:
   if( Parent_window != NULL ) if( FindWindowInList( Parent_window ) == 1 )
	 {
     // 㤥 뫠 ᮮ饭 த⥫᪮ .
	  Dragging_window = Parent_window;
     //  ᫥饥 த⥫᪮ .
     if( GetWindowLong( Parent_window, GWL_STYLE ) & WS_CHILD ) Parent_window = GetParent( Parent_window );
	 }
  }

 // ᫨    - .
 if( Dragging_window == NULL ) return;

 // ᫨ 㪠⥫ ᯮ  ᪮ ᬮ - .
 if( IsScrollBar( Window, 0 ) ) return;

 //    । ࠦ  .
 if( PermissionForScrolling( Dragging_window ) == 0 ) return;

 //  , 祭 ᫥ ᪠.
 BYTE Window_VBar = Record_from_list.VBar; BYTE Window_HBar = Record_from_list.HBar;

 // ᫨  । ᢥ   砥 ᮮ饭  ᢮ ᪨:
 if( Window_VBar == 0 )
  {
   // ⠭ ६,  । . 祭 -  砥 ᮮ饭  ᢮ ᪨.
   VSB_Control = NULL;
	// ,   ﭨ ᪠:
   if( GetWindowLong( Dragging_window, GWL_STYLE ) & WS_VSCROLL )
    GetScrollRange( Dragging_window, SB_VERT, &VScroll_begin, &VScroll_end );
   // ᫨    - 㧭,   ﭨ ᪠ த⥫᪮ :
   if( VScroll_begin == 0 && VScroll_end == 0 ) if( Parent_window != NULL )
    {
	  // ⠭ ६, ।   ᯨ᪠ . 祭 -   ।.
	  Record_from_list.xV = 0; Record_from_list.yV = 0; Record_from_list.VBar = -1; Record_from_list.HBar = -1;
     // 室  ᯨ᪥ த⥫᪮ .
	  FindWindowInList( Parent_window );
     // ᫨ த⥫᪮    । ࠦ :
     if( !( Record_from_list.xV == 0 && Record_from_list.yV == 0 ) )
      if( PermissionForScrolling( Parent_window ) != 0 )
       // ᫨  । ᢥ  த⥫᪮  砥 ᮮ饭  ᢮ ᪨:
       if( Record_from_list.VBar == 0 )
		  {
         // ,   ﭨ ᪠:
			if( GetWindowLong( Parent_window, GWL_STYLE ) & WS_VSCROLL )
          GetScrollRange( Parent_window, SB_VERT, &VScroll_begin, &VScroll_end );
         // ᫨  :
			if( !( VScroll_begin == 0 && VScroll_end == 0 ) )
          {
           // 㤥 । ࠦ  த⥫᪮ .
           Dragging_window = Parent_window; Parent_window = NULL; Window_HBar = Record_from_list.HBar;
          }
        }
		 //  ᫨  த⥫᪮  뫠 ᮧ ⤥쭠 ᪠,    .
		 else if( Record_from_list.VBar == 1 )
        {
			// 饬   .
         VSB_Control = FindScrollBar( Parent_window, SB_VERT );
         // ,   ﭨ ᪠.
         if( VSB_Control != NULL ) GetScrollRange( VSB_Control, SB_CTL, &VScroll_begin, &VScroll_end );
         // ᫨  :
         if( !( VScroll_begin == 0 && VScroll_end == 0 ) )
			 {
           // 㤥 । ࠦ  த⥫᪮ .
			  Dragging_window = Parent_window; Parent_window = NULL; Window_HBar = Record_from_list.HBar;
          }
         // ᫨ ᪨  - ⠭ ६,  । . 祭 - ᪠  .
			else VSB_Control = -1;
        }
    }
  }
 //  ᫨   뫠 ᮧ ⤥쭠 ᪠,    .
 else if( Window_VBar == 1 )
  {
	// ᪠   ᯮ  .  ,  ⠭ ६,  । .
   VSB_Control = FindScrollBar( Dragging_window, SB_VERT );
	// ,   ﭨ ᪠:
   if( VSB_Control != NULL ) GetScrollRange( VSB_Control, SB_CTL, &VScroll_begin, &VScroll_end );
   // ᫨ ᪠   -     த⥫᪮ .
   else if( Parent_window != NULL )
    {
     // ⠭ ६,  । . 祭 - ᪠  .
	  VSB_Control = -1;
     // ⠭ ६, ।   ᯨ᪠ . 祭 -   ।.
	  Record_from_list.xV = 0; Record_from_list.yV = 0; Record_from_list.VBar = -1; Record_from_list.HBar = -1;
     // 室  ᯨ᪥ த⥫᪮ .
     FindWindowInList( Parent_window );
	  // ᫨ த⥫᪮    । ࠦ :
     if( !( Record_from_list.xV == 0 && Record_from_list.yV == 0 ) )
      if( PermissionForScrolling( Parent_window ) != 0 )
       // ᫨  । ᢥ  த⥫᪮  砥 ᮮ饭  ᢮ ᪨:
       if( Record_from_list.VBar == 0 )
        {
			// ⠭ ६,  । . 祭 -  砥 ᮮ饭  ᢮ ᪨.
			VSB_Control = NULL;
         // ,   ﭨ ᪠:
			if( GetWindowLong( Parent_window, GWL_STYLE ) & WS_VSCROLL )
          GetScrollRange( Parent_window, SB_VERT, &VScroll_begin, &VScroll_end );
         // ᫨  :
         if( !( VScroll_begin == 0 && VScroll_end == 0 ) )
          {
           // 㤥 । ࠦ  த⥫᪮ .
			  Dragging_window = Parent_window; Parent_window = NULL; Window_HBar = Record_from_list.HBar;
          }
		  }
       //  ᫨  த⥫᪮  뫠 ᮧ ⤥쭠 ᪠,    .
       else if( Record_from_list.VBar == 1 )
		  {
         // 饬   .
         VSB_Control = FindScrollBar( Parent_window, SB_VERT );
         // ,   ﭨ ᪠.
         if( VSB_Control != NULL ) GetScrollRange( VSB_Control, SB_CTL, &VScroll_begin, &VScroll_end );
         // ᫨  :
			if( !( VScroll_begin == 0 && VScroll_end == 0 ) )
			 {
           // 㤥 । ࠦ  த⥫᪮ .
			  Dragging_window = Parent_window; Parent_window = NULL; Window_HBar = Record_from_list.HBar;
          }
         // ᫨ ᪨  - ⠭ ६,  । . 祭 - ᪠  .
         else VSB_Control = -1;
        }
    }
  }

 // ᫨  । ᫥ ࠢ  砥 ᮮ饭  ᢮ ᪨:
 if( Window_HBar == 0 )
  {
	// ⠭ ६,  । . 祭 -  砥 ᮮ饭  ᢮ ᪨.
   HSB_Control = NULL;
   // ,   ﭨ ᪠:
   if( GetWindowLong( Dragging_window, GWL_STYLE ) & WS_HSCROLL )
    GetScrollRange( Dragging_window, SB_HORZ, &HScroll_begin, &HScroll_end );
   // ᫨   ,  ᪨ ᬮ ᢥ  ⮦  - 㧭,   ﭨ ᪠ த⥫᪮ :
	if( HScroll_begin == 0 && HScroll_end == 0 && VScroll_begin == 0 && VScroll_end == 0 )
	 if( Parent_window != NULL )
     {
		// ⠭ ६, ।   ᯨ᪠ . 祭 -   ।.
      Record_from_list.xV = 0; Record_from_list.yV = 0; Record_from_list.HBar = -1; Record_from_list.HBar = -1;
      // 室  ᯨ᪥ த⥫᪮ .
      FindWindowInList( Parent_window );
      // ᫨ த⥫᪮    । ࠦ :
      if( !( Record_from_list.xV == 0 && Record_from_list.yV == 0 ) )
		 if( PermissionForScrolling( Parent_window ) != 0 )
        // ᫨  । ᫥ ࠢ த⥫᪮  砥 ᮮ饭  ᢮ ᪨:
		  if( Record_from_list.HBar == 0 )
         {
          // ,   ﭨ ᪠:
			 if( GetWindowLong( Parent_window, GWL_STYLE ) & WS_HSCROLL )
           GetScrollRange( Parent_window, SB_HORZ, &HScroll_begin, &HScroll_end );
          // ᫨   - ࠦ 㤥 ।  த⥫᪮ .
          if( !( HScroll_begin == 0 && HScroll_end == 0 ) ) Dragging_window = Parent_window;
         }
        //  ᫨  த⥫᪮  뫠 ᮧ ⤥쭠 ᪠,    .
		  else if( Record_from_list.HBar == 1 )
			{
          // 饬   .
			 HSB_Control = FindScrollBar( Parent_window, SB_HORZ );
          // ,   ﭨ ᪠.
          if( HSB_Control != NULL ) GetScrollRange( HSB_Control, SB_CTL, &HScroll_begin, &HScroll_end );
          // ᫨   - ࠦ 㤥 ।  த⥫᪮ .
          if( !( HScroll_begin == 0 && HScroll_end == 0 ) ) Dragging_window = Parent_window;
         }
	  }
  }
 //  ᫨   뫠 ᮧ ⤥쭠 ᪠,    .
 else if( Window_HBar == 1 )
  {
	// ᪠   ᯮ  .  ,  ⠭ ६,  । .
   HSB_Control = FindScrollBar( Dragging_window, SB_HORZ );
   // ,   ﭨ ᪠:
   if( HSB_Control != NULL ) GetScrollRange( HSB_Control, SB_CTL, &HScroll_begin, &HScroll_end );
   // ᫨   ,  ᪨ ᬮ ᢥ  ⮦  - 㧭,   ﭨ ᪠ த⥫᪮ :
   else if( VScroll_begin == 0 && VScroll_end == 0 ) if( Parent_window != NULL )
	 {
	  // ⠭ ६,  । . 祭 - ᪠  .
     HSB_Control = -1;
	  // ⠭ ६, ।   ᯨ᪠ . 祭 -   ।.
     Record_from_list.xV = 0; Record_from_list.yV = 0; Record_from_list.HBar = -1; Record_from_list.HBar = -1;
     // 室  ᯨ᪥ த⥫᪮ .
     FindWindowInList( Parent_window );
     // ᫨ த⥫᪮    । ࠦ :
     if( !( Record_from_list.xV == 0 && Record_from_list.yV == 0 ) )
		if( PermissionForScrolling( Parent_window ) != 0 )
       // ᫨  । ᫥ ࠢ த⥫᪮  砥 ᮮ饭  ᢮ ᪨:
		 if( Record_from_list.HBar == 0 )
        {
         // ,   ﭨ ᪠:
			if( GetWindowLong( Parent_window, GWL_STYLE ) & WS_HSCROLL )
          GetScrollRange( Parent_window, SB_HORZ, &HScroll_begin, &HScroll_end );
         // ᫨   - ࠦ 㤥 ।  த⥫᪮ .
         if( !( HScroll_begin == 0 && HScroll_end == 0 ) )
          {
           // 㤥 । ࠦ  த⥫᪮ .
			  Dragging_window = Parent_window; HSB_Control = NULL;
			 }
        }
		 //  ᫨  த⥫᪮  뫠 ᮧ ⤥쭠 ᪠,    .
       else if( Record_from_list.HBar == 1 )
        {
         // 饬   .
         HSB_Control = FindScrollBar( Parent_window, SB_HORZ );
         // ,   ﭨ ᪠.
			if( HSB_Control != NULL ) GetScrollRange( HSB_Control, SB_CTL, &HScroll_begin, &HScroll_end );
         // ᫨   - ࠦ 㤥 ।  த⥫᪮ .
			if( !( HScroll_begin == 0 && HScroll_end == 0 ) ) Dragging_window = Parent_window;
         // ᫨ ᪨  - ⠭ ६,  । . 祭 - ᪠  .
         else HSB_Control = -1;
		  }
    }
  }

 // ᫨ ᮪    - .
 if( VScroll_begin == 0 && VScroll_end == 0 && HScroll_begin == 0 && HScroll_end == 0 ) return;

 //  室   ᯨ᪥ - ६ Record_from_list     ᪥ த⥫᪨ .
 FindWindowInList( Dragging_window );

 //   㪠⥫ .
 Begin_point.x = X; Begin_point.y = Y;
 Old_point.x = X;   Old_point.y = Y;
 //  ᪮ । ࠦ  .
 Dragging_window_xV = Record_from_list.xV; Dragging_window_yV = Record_from_list.yV;
 // ⠭  㪠⥫ .
 SetCapture( Dragging_window ); SetCursor( Cursor_for_dragging );
 //  - ।!
 InTravel = 1;

 // .
 return;
}
#endif

// --- । ࠦ  ࠭ . ---

#ifndef DRAG_IMAGE_IS_REPLACED
// X  Y ।  .
VOID DragImage( INT X, INT Y )
{
 // ᫨   - .
 if( !IsWindow( Dragging_window ) ) { InTravel = 0; return; }

 // ६  । ﭨ ᮪.
 INT VScroll_position = 0; INT VScroll_begin = 0; INT VScroll_end = 0;
 INT HScroll_position = 0; INT HScroll_begin = 0; INT HScroll_end = 0;
 // ६  ⠢ ᮮ饭.
 INT Distance = 0; INT New_position = 0; LPARAM lParam = 0;
 // ।, 뫮  ᫠ ᮮ饭.
 BYTE Serg_ = 0;

 // ᫨ 㪠⥫  ⮬   - .
 if( X == Old_point.x ) if( Y == Old_point.y ) return;

 // ᫨ । ந室 ᢥ :
 if( Y != Old_point.y )
  // ᫨  砥 ᮮ饭  ᢮ ᪨:
  if( VSB_Control == NULL )
	{
    // ,   ﭨ ᪠:
    if( GetWindowLong( Dragging_window, GWL_STYLE ) & WS_VSCROLL )
     {
      // ,    ﭨ:
      VScroll_position = GetScrollPos( Dragging_window, SB_VERT );
		GetScrollRange( Dragging_window, SB_VERT, &VScroll_begin, &VScroll_end );
     }
	}
  //  ᫨   뫠 ᮧ ⤥쭠 ᪠   뫠 :
  else if( (INT) VSB_Control != -1 )
	{
    // ,    ﭨ:
    GetScrollRange( VSB_Control, SB_CTL, &VScroll_begin, &VScroll_end );
    VScroll_position = GetScrollPos( VSB_Control, SB_CTL );
   }

 // ᫨ । ந室 ᫥ ࠢ:
 if( X != Old_point.x )
  // ᫨  砥 ᮮ饭  ᢮ ᪨:
  if( HSB_Control == NULL )
   {
    // ,   ﭨ ᪠:
    if( GetWindowLong( Dragging_window, GWL_STYLE ) & WS_HSCROLL )
     {
      // ,    ﭨ:
		GetScrollRange( Dragging_window, SB_HORZ, &HScroll_begin, &HScroll_end );
      HScroll_position = GetScrollPos( Dragging_window, SB_HORZ );
	  }
   }
  //  ᫨   뫠 ᮧ ⤥쭠 ᪠   뫠 :
  else if( (INT) HSB_Control != -1 )
   {
    // ,    ﭨ:
    GetScrollRange( HSB_Control, SB_CTL, &HScroll_begin, &HScroll_end );
    HScroll_position = GetScrollPos( HSB_Control, SB_CTL );
   }

 // । ࠦ.
 // ᫨ 㪠⥫ ।㫨 , ⭠ ᪮  । ࠦ , :
 if( Y > Old_point.y ) if( Dragging_window_yV != 0 ) if( VScroll_position > VScroll_begin )
  if( !( VScroll_begin == 0 && VScroll_end == 0 ) )
   {
    // ,  ﭨ 襫 㪠⥫.
    Distance = ( Y - Old_point.y );
    // ᫨  >= ﭨ, । ᪮, । ࠦ.
	 if( Distance >= Dragging_window_yV )
     {
		// ⠢塞 ᮮ饭.
      New_position = VScroll_position - Distance / Dragging_window_yV;
      if( New_position < VScroll_begin ) New_position = VScroll_begin;
		lParam = MAKELONG( New_position, VSB_Control );
      // 뫠 ᮮ饭.
      Smooth_scrolling = 0;
      SendMessage( Dragging_window, WM_VSCROLL, SB_THUMBTRACK, lParam );
      SendMessage( Dragging_window, WM_VSCROLL, SB_THUMBPOSITION, lParam );
      SendMessage( Dragging_window, WM_VSCROLL, SB_ENDSCROLL, lParam );
		Smooth_scrolling = 1;
		// 塞 ﭨ ᪨ ᬮ.
      // ᫨  砥 ᮮ饭  ᢮ ᪨:
		if( VSB_Control == NULL ) SetScrollPos( Dragging_window, SB_VERT, New_position, 1 );
      //  ᫨   뫠 ᮧ ⤥쭠 ᪠:
      else SetScrollPos( VSB_Control, SB_CTL, New_position, 1 );
      // ,  ᮮ饭 뫮 ᫠.
      Serg_ = 1;
     }
	}

 // ᫨ 㪠⥫ ।㫨 , ⭠ ᪮  । ࠦ , :
 if( Y < Old_point.y ) if( Dragging_window_yV != 0 ) if( VScroll_position < VScroll_end )
  if( !( VScroll_begin == 0 && VScroll_end == 0 ) )
	{
    // ,  ﭨ 襫 㪠⥫.
    Distance = ( Old_point.y - Y );
    // ᫨  >= ﭨ, । ᪮, । ࠦ.
    if( Distance >= Dragging_window_yV )
     {
		// ⠢塞 ᮮ饭.
		New_position = VScroll_position + Distance / Dragging_window_yV;
      if( New_position > VScroll_end ) New_position = VScroll_end;
		lParam = MAKELONG( New_position, VSB_Control );
      // 뫠 ᮮ饭.
      Smooth_scrolling = 0;
      SendMessage( Dragging_window, WM_VSCROLL, SB_THUMBTRACK, lParam );
      SendMessage( Dragging_window, WM_VSCROLL, SB_THUMBPOSITION, lParam );
      SendMessage( Dragging_window, WM_VSCROLL, SB_ENDSCROLL, lParam );
		Smooth_scrolling = 1;
      // 塞 ﭨ ᪨ ᬮ.
		// ᫨  砥 ᮮ饭  ᢮ ᪨:
      if( VSB_Control == NULL ) SetScrollPos( Dragging_window, SB_VERT, New_position, 1 );
      //  ᫨   뫠 ᮧ ⤥쭠 ᪠:
		else SetScrollPos( VSB_Control, SB_CTL, New_position, 1 );
      // ,  ᮮ饭 뫮 ᫠.
      Serg_ = 1;
     }
   }

 // ᫨ 㪠⥫ ।㫨 ࠢ, ⭠ ᪮  । ࠦ , :
 if( X > Old_point.x ) if( Dragging_window_xV != 0 ) if( HScroll_position > HScroll_begin )
  if( !( HScroll_begin == 0 && HScroll_end == 0 ) )
	{
    // ,  ﭨ 襫 㪠⥫.
    Distance = ( X - Old_point.x );
    // ᫨  >= ﭨ, । ᪮, । ࠦ.
    if( Distance >= Dragging_window_xV )
     {
		// ⠢塞 ᮮ饭.
      New_position = HScroll_position - Distance / Dragging_window_xV;
		if( New_position < HScroll_begin ) New_position = HScroll_begin;
      lParam = MAKELONG( New_position, HSB_Control );
      // 뫠 ᮮ饭.
		Smooth_scrolling = 0;
      SendMessage( Dragging_window, WM_HSCROLL, SB_THUMBTRACK, lParam );
      SendMessage( Dragging_window, WM_HSCROLL, SB_THUMBPOSITION, lParam );
      SendMessage( Dragging_window, WM_HSCROLL, SB_ENDSCROLL, lParam );
      Smooth_scrolling = 1;
      // 塞 ﭨ ᪨ ᬮ.
		// ᫨  砥 ᮮ饭  ᢮ ᪨:
		if( HSB_Control == NULL ) SetScrollPos( Dragging_window, SB_HORZ, New_position, 1 );
      //  ᫨   뫠 ᮧ ⤥쭠 ᪠:
		else SetScrollPos( HSB_Control, SB_CTL, New_position, 1 );
      // ,  ᮮ饭 뫮 ᫠.
      Serg_ = 1;
     }
   }

 // ᫨ 㪠⥫ ।㫨 , ⭠ ᪮  । ࠦ , :
 if( X < Old_point.x ) if( Dragging_window_xV != 0 ) if( HScroll_position < HScroll_end )
  if( !( HScroll_begin == 0 && HScroll_end == 0 ) )
   {
    // ,  ﭨ 襫 㪠⥫.
	 Distance = ( Old_point.x - X );
    // ᫨  >= ﭨ, । ᪮, । ࠦ.
    if( Distance >= Dragging_window_xV )
     {
      // ⠢塞 ᮮ饭.
      New_position = HScroll_position + Distance / Dragging_window_xV;
		if( New_position > HScroll_end ) New_position = HScroll_end;
		lParam = MAKELONG( New_position, HSB_Control );
      // 뫠 ᮮ饭.
		Smooth_scrolling = 0;
      SendMessage( Dragging_window, WM_HSCROLL, SB_THUMBTRACK, lParam );
      SendMessage( Dragging_window, WM_HSCROLL, SB_THUMBPOSITION, lParam );
      SendMessage( Dragging_window, WM_HSCROLL, SB_ENDSCROLL, lParam );
      Smooth_scrolling = 1;
      // 塞 ﭨ ᪨ ᬮ.
		// ᫨  砥 ᮮ饭  ᢮ ᪨:
      if( HSB_Control == NULL ) SetScrollPos( Dragging_window, SB_HORZ, New_position, 1 );
		//  ᫨   뫠 ᮧ ⤥쭠 ᪠:
      else SetScrollPos( HSB_Control, SB_CTL, New_position, 1 );
      // ,  ᮮ饭 뫮 ᫠.
		Serg_ = 1;
     }
   }

 // ᫨ ᮮ饭 뫮 ᫠, :
 if( Serg_ == 1 )
  {
	//    㪠⥫ .
   Old_point.x = X; Old_point.y = Y;
	// ⠭ 㪠⥫ .
   SetCapture( Dragging_window ); SetCursor( Cursor_for_dragging );
  }

 // .
 return;
}
#endif

// --- 蠥 । ࠦ   . ---

#ifndef END_DRAGGING_IS_REPLACED
VOID EndDragging( VOID )
{
 // 蠥 ।.
 InTravel = 0;
 // ᢮ . ⥫ 㤥 ⠭.
 ReleaseCapture();

 // .
 return;
}
#endif

// ---  ࠬ  . ---

#ifndef DRAW_WINDOW_FRAME_IS_REPLACED
// Window । ,  ஬ 㤥 ᮢ.
VOID DrawWindowFrame( HWND Window )
{
 // ᫨   - .
 if( !IsWindow( Window ) ) return;

 // ᫨  室  㬥襭 ﭨ:
 if( IsIconic( Window ) )
  {
   // ᫨  ਮ ࠬ  , 㬥襭  窨 - ᮢ ࠬ  .
	if( Paint_icons != 0 ) DrawIconFrame( Window );
	// .
   return;
  }

 //  ६  ᯮ짮  ᮢ .
 // Frame -  ࠬ  . Menu -     ⮬ .
 // Sysmenu_width - ਭ ⨭   孥 㣫 .
 BYTE Frame = 0; BYTE Menu = 0; BYTE Sysmenu_width = 0;

 //  ࠬ  ?   ⮭, 筠, ᪠,   ﭭ ࠧ.
 //   .
 LONG Window_style = GetWindowLong( Window, GWL_STYLE );
 LONG Window_xstyle = GetWindowLong( Window, GWL_EXSTYLE );

 //   㥬 ࠬ.
 if( Window_style & WS_POPUP ) if( !( Window_style & WS_BORDER ) )
 if( !( Window_style & WS_DLGFRAME ) ) if( !( Window_style & WS_THICKFRAME ) )
  {
   // ,    । .
	GetClassName( Window, Window_name, SIZE_OF_NAME );
	// ᫨  :
   if( lstrcmp( Window_name, Menu_name ) == 0 )
	 {
     // 㥬 ࠬ.
     if( Paint_menus != 0 ) DrawMenuFrame( Window );
     //  祣   㦭 - .
     return;
    }
  }

 // 㥬 ࠬ  ᪨ .
 if( Window_style & WS_DLGFRAME ) if( !( Window_style & WS_BORDER ) )
  if( !( Window_style & WS_THICKFRAME ) ) if( !( Window_xstyle & WS_EX_DLGMODALFRAME ) )
	{
    // 㥬 ࠬ.
    if( Paint_flat_frames != 0 ) DrawFlatFrame( Window );
    //  祣   㦭 - .
    return;
   }

 // 㥬 ࠬ  ᪨ ,  ᮧ  ᭮  ﭭ ࠧ.
 if( Window_xstyle & WS_EX_DLGMODALFRAME ) if( Window_style & WS_POPUP || Window_style & WS_CHILD )
  if( !( ( Window_style & WS_BORDER ) && ( Window_style & WS_DLGFRAME ) ) )
   {
    // 㥬 ࠬ.
    if( Paint_flat_frames != 0 ) DrawFlatFrame( Window );
    //  祣   㦭 - .
    return;
	}

 // 㥬 ࠬ   .
 if( Window_style & WS_THICKFRAME ) if( !( Window_xstyle & WS_EX_DLGMODALFRAME ) )
  {
	// 㥬 ࠬ.
   if( Paint_normal_frames != 0 ) DrawNormalFrame( Window );
   // ᫨ ਫ 맢  Windows:
   if( Shell_is_Windows )
    {
     // ,    । .
	  GetClassName( Window, Window_name, SIZE_OF_NAME );
	  // ᫨   -  ᮢ ⮫쪮 ࠬ, .
     if( lstrcmp( Window_name, Clock_name ) == 0 ) return;
	 }
   // ,  ࠬ  .
   Frame = 1;
  }

 // 㥬 ࠬ  1 .
 if( Window_style & WS_BORDER ) if( !( Window_style & WS_THICKFRAME ) ) if( !( Window_xstyle & WS_EX_DLGMODALFRAME ) )
  {
	// 㥬 ࠬ.
   if( Paint_point_frames != 0 ) DrawPointFrame( Window );
   // ,  ࠬ  .
	Frame = 2;
  }

 // 㥬 ࠬ   ﭭ ࠧ.
 if( Window_xstyle & WS_EX_DLGMODALFRAME )
  {
	// 㥬 ࠬ.
	if( Paint_const_frames != 0 ) DrawConstFrame( Window );
   // ,  ࠬ  .
	Frame = 3;
  }

 // ᫨   - .
 if( Window_style & WS_CHILD ) if( !( Window_style & WS_DLGFRAME ) ) if( !( Window_xstyle & WS_EX_DLGMODALFRAME ) ) return;
 if( Window_style & WS_CHILD ) if( Window_style & WS_DLGFRAME ) if( !( Window_style & WS_BORDER ) ) if( !( Window_xstyle & WS_EX_DLGMODALFRAME ) ) return;
 if( Window_style & WS_POPUP ) if( !( Window_style & WS_DLGFRAME ) ) if( !( Window_xstyle & WS_EX_DLGMODALFRAME ) ) return;
 if( Window_style & WS_POPUP ) if( Window_style & WS_DLGFRAME ) if( !( Window_style & WS_BORDER ) ) if( !( Window_xstyle & WS_EX_DLGMODALFRAME ) ) return;

 // 㥬 , ࠧ   ࠡ  .
 if( Draw_captions == 1 ) if( Draw_normal_division_lines != 0 ) if( Frame == 1 ) DrawDivisionLine( Window, Frame );
 if( Draw_captions == 1 ) if( Draw_point_division_lines  != 0 ) if( Frame == 2 ) DrawDivisionLine( Window, Frame );

 // ᫨  ᮢ  㦭 - .
 if( Draw_captions == 0 ) return;

 // 㥬   ࠢ 孥 㣫 ,  㧭, ᪮쪮 祪  﫨.
 INT Button_width = 0;

 // ᫨  ન ꥬ :
 if( Draw_captions == 1 )
  {
   // ᫨        ⨭:
   if( Window == Selected_window && Selected_button >= 2 )
    Button_width = DrawButtons( Window, Frame, Window_style, Window_xstyle, Selected_button, 0 );
   //  ᫨     :
	else Button_width = DrawButtons( Window, Frame, Window_style, Window_xstyle, 0, 0 );
  }

 // ,   ᮢ ⨭  ࠢ 孥 㣫 .
 if( Window_style & WS_SYSMENU ) Sysmenu_width = yCaption - 2;

 // ,     ⮬ .
 if( !( Window_style & WS_CHILD ) ) if( GetMenu( Window ) != 0 ) Menu = 1;

 // 㥬  .
 DrawCaption( Window, Frame, Menu, Sysmenu_width, Button_width, 0, 0 );

 // .
 return;
}
#endif

// ---  ࠬ  筮 . ---

#ifndef DRAW_NORMAL_FRAME_IS_REPLACED
// Window । ,  ஬ 㤥 ᮢ.
VOID DrawNormalFrame( HWND Window )
{
 // ६  ᮢ.
 RECT Rect = { 0, 0, 0, 0 };
 HDC Hdc = NULL;
 HPEN Pen = NULL;

 // ⪠ X->  Y| ⠭   孨 㣮 ࠡ祩 . ७ -  窠.
 //  ࠧ .
 GetWindowRect( Window, &Rect );

 // ᫨  㢥祭 - ᮢ ࠬ  .
 if( Rect.top < 0 ) if( Rect.left < 0 ) if( Rect.right > xScreen ) if( Rect.bottom > yScreen ) return;

 // Rect.top -   ᮢ. Rect.right - ਭ  ᮢ.
 Rect.top = Rect.bottom - Rect.top; Rect.right = Rect.right - Rect.left;

 // 稭 ᮢ.
 Hdc = GetWindowDC( Window );

 // 㥬 ࠬ  .
 Pen = CreatePen( PS_SOLID, 1, RGB( 192, 192, 192 ) ); SelectObject( Hdc, Pen );
 SelectObject( Hdc, GetStockObject( LTGRAY_BRUSH ) );
 Rectangle( Hdc, 0, 0, xNormalFrame - 1, Rect.top );
 Rectangle( Hdc, 0, 0, Rect.right, yNormalFrame - 1 );
 Rectangle( Hdc, Rect.right, Rect.top, Rect.right - xNormalFrame + 1, 0 );
 Rectangle( Hdc, Rect.right, Rect.top, 0, Rect.top - yNormalFrame + 1 );
 SelectObject( Hdc, GetStockObject( WHITE_PEN ) ); DeleteObject( Pen );

 // 㥬 ᢥ  ⥭.
 Pen = CreatePen( PS_SOLID, 1, RGB( 128, 128, 128 ) ); SelectObject( Hdc, Pen );
 MoveTo( Hdc, 0, Rect.top - 2 );
 LineTo( Hdc, 0, 0 );
 LineTo( Hdc, Rect.right - 1, 0 );
 SelectObject( Hdc, GetStockObject( BLACK_PEN ) ); DeleteObject( Pen );

 // 㥬 ⥬  ⥭.
 MoveTo( Hdc, Rect.right - 1, 1 );
 LineTo( Hdc, Rect.right - 1, Rect.top -1 );
 LineTo( Hdc, 0, Rect.top - 1 );

 // 㥬 ᢥ  譥 ࠬ.
 SelectObject( Hdc, GetStockObject( WHITE_PEN ) );
 MoveTo( Hdc, 1, Rect.top - 3 );
 LineTo( Hdc, 1, 1 );
 LineTo( Hdc, Rect.right - 2, 1 );

 // ᫨  㢥祭    ࠬ - 롨ࠥ ୮ .
 if( Rect.right == xScreen + xNormalFrame * 2 - 2 ) SelectObject( Hdc, GetStockObject( BLACK_PEN ) );

 // 㥬 ᢥ  ७ ࠬ.
 MoveTo( Hdc, Rect.right - xNormalFrame, yNormalFrame - 1 );
 LineTo( Hdc, Rect.right - xNormalFrame, Rect.top - yNormalFrame );
 LineTo( Hdc, xNormalFrame - 2, Rect.top - yNormalFrame );

 // 㥬 ⥬  譥 ࠬ.
 Pen = CreatePen( PS_SOLID, 1, RGB( 128, 128, 128 ) ); SelectObject( Hdc, Pen );
 MoveTo( Hdc, Rect.right - 2, 2 );
 LineTo( Hdc, Rect.right - 2, Rect.top - 2 );
 LineTo( Hdc, 1, Rect.top - 2 );

 // 㥬 ⥬  ७ ࠬ.
 MoveTo( Hdc, xNormalFrame - 1, Rect.top - yNormalFrame );
 LineTo( Hdc, xNormalFrame - 1, yNormalFrame - 1 );
 LineTo( Hdc, Rect.right - xNormalFrame + 1, yNormalFrame - 1 );
 SelectObject( Hdc, GetStockObject( WHITE_PEN ) ); DeleteObject( Pen );

 // 㥬 㣮 譥 ࠬ.
 SetPixel( Hdc, Rect.right - 1, 0, RGB( 64, 64, 64 ) );
 SetPixel( Hdc, 0, Rect.top - 1, RGB( 64, 64, 64 ) );

 // 㥬 㣮 ७ ࠬ.
 SetPixel( Hdc, Rect.right - xNormalFrame, yNormalFrame - 1, RGB( 192, 192, 192 ) );
 SetPixel( Hdc, xNormalFrame - 1, Rect.top - yNormalFrame, RGB( 192, 192, 192 ) );

 // 蠥 ᮢ.
 ReleaseDC( Window, Hdc );

 // .
 return;
}
#endif

// ---   ࠬ  筮 . ---

#ifndef DRAW_LINES_IS_REPLACED
// Window । ,  ஬ 㤥 ᮢ.
VOID DrawLines( HWND Window, DWORD Window_style )
{
 // ६  ᮢ.
 RECT Rect = { 0, 0, 0, 0 };
 HDC Hdc = NULL;
 HPEN Pen = NULL;

 // ⪠ X->  Y| ⠭   孨 㣮 ࠡ祩 . ७ -  窠.
 //  ࠧ .
 GetWindowRect( Window, &Rect );

 // ᫨  㢥祭 - ᮢ ࠬ  .
 if( Rect.top < 0 ) if( Rect.left < 0 ) if( Rect.right > xScreen ) if( Rect.bottom > yScreen ) return;

 // Rect.top -   ᮢ. Rect.right - ਭ  ᮢ.
 Rect.top = Rect.bottom - Rect.top; Rect.right = Rect.right - Rect.left;

 // 稭 ᮢ.
 Hdc = GetWindowDC( Window );

 // 㥬 ⥬  ७ ࠬ.
 Pen = CreatePen( PS_SOLID, 1, RGB( 128, 128, 128 ) ); SelectObject( Hdc, Pen );
 MoveTo( Hdc, xNormalFrame - 1, Rect.top - yNormalFrame );
 LineTo( Hdc, xNormalFrame - 1, yNormalFrame - 1 );
 LineTo( Hdc, Rect.right - xNormalFrame + 1, yNormalFrame - 1 );
 SelectObject( Hdc, GetStockObject( WHITE_PEN ) ); DeleteObject( Pen );

 // ᫨  㢥祭    ࠬ - 롨ࠥ ୮ .
 if( Rect.right == xScreen + xNormalFrame * 2 - 2 ) SelectObject( Hdc, GetStockObject( BLACK_PEN ) );

 // 㥬 ᢥ  ७ ࠬ.
 MoveTo( Hdc, Rect.right - xNormalFrame, yNormalFrame - 1 );
 LineTo( Hdc, Rect.right - xNormalFrame, Rect.top - yNormalFrame );
 LineTo( Hdc, xNormalFrame - 2, Rect.top - yNormalFrame );

 // 㥬 㣮 ७ ࠬ.
 SetPixel( Hdc, Rect.right - xNormalFrame, yNormalFrame - 1, RGB( 192, 192, 192 ) );
 SetPixel( Hdc, xNormalFrame - 1, Rect.top - yNormalFrame, RGB( 192, 192, 192 ) );

 // 㥬 , ࠧ   ࠡ  .
 if( Draw_captions == 1 ) if( Draw_normal_division_lines != 0 )
  {
   // 㥬  冷  .
	SelectObject( Hdc, GetStockObject( WHITE_PEN ) );
	MoveTo( Hdc, xNormalFrame, yNormalFrame + yCaption - 2 );
   LineTo( Hdc, Rect.right - xNormalFrame, yNormalFrame + yCaption - 2 );
  }

 // 㥬 , ᫨    .
 if( Draw_captions == 1 ) if( Draw_menus ) if( !( Window_style & WS_CHILD ) ) if( GetMenu( Window ) != 0 )
  {
   // 㥬 ⥬  .
	Pen = CreatePen( PS_SOLID, 1, RGB( 128, 128, 128 ) ); SelectObject( Hdc, Pen );
   MoveTo( Hdc, Rect.right - xNormalFrame - 1, yNormalFrame + yCaption + yMenu - 1 );
	LineTo( Hdc, xNormalFrame - 1, yNormalFrame + yCaption + yMenu - 1 );
   SelectObject( Hdc, GetStockObject( WHITE_PEN ) ); DeleteObject( Pen );
  }

 // 蠥 ᮢ.
 ReleaseDC( Window, Hdc );

 // .
 return;
}
#endif

// ---  ࠬ  1 . ---

#ifndef DRAW_POINT_FRAME_IS_REPLACED
// Window । ,  ஬ 㤥 ᮢ.
VOID DrawPointFrame( HWND Window )
{
 // ६  ᮢ.
 RECT Rect = { 0, 0, 0, 0 };
 HDC Hdc = NULL;
 HPEN Pen = NULL;

 // ⪠ X->  Y| ⠭   孨 㣮 ࠡ祩 . ७ -  窠.
 //  ࠧ .
 GetWindowRect( Window, &Rect );
 // Rect.top -   ᮢ. Rect.right - ਭ  ᮢ.
 Rect.top = Rect.bottom - Rect.top; Rect.right = Rect.right - Rect.left;

 // ᫨    ࠭,   ⠢ - .
 if( Rect.top >= yScreen ) return;

 // 稭 ᮢ.
 Hdc = GetWindowDC( Window );

 // 㥬 ᢥ  ࠬ.
 SelectObject( Hdc, GetStockObject( WHITE_PEN ) );
 MoveTo( Hdc, 0, Rect.top  - 1 );
 LineTo( Hdc, 0, 0 );
 LineTo( Hdc, Rect.right - 1, 0 );

 // 㥬 ⥬  ࠬ.
 Pen = CreatePen( PS_SOLID, 1, RGB( 128, 128, 128 ) ); SelectObject( Hdc, Pen );
 MoveTo( Hdc, Rect.right - 1, 0 );
 LineTo( Hdc, Rect.right - 1, Rect.top - 1 );
 LineTo( Hdc, 0, Rect.top - 1 );
 SelectObject( Hdc, GetStockObject( WHITE_PEN ) ); DeleteObject( Pen );

 // 㥬 㣮 ࠬ.
 SetPixel( Hdc, Rect.right - 1, 0, RGB( 192, 192, 192 ) );
 SetPixel( Hdc, 0, Rect.top - 1, RGB( 192, 192, 192 ) );

 // 蠥 ᮢ.
 ReleaseDC( Window, Hdc );

 // .
 return;
}
#endif

// ---  ࠬ   ﭭ ࠧ. ---

#ifndef DRAW_CONST_FRAME_IS_REPLACED
// Window । ,  ஬ 㤥 ᮢ.
VOID DrawConstFrame( HWND Window )
{
 // ६  ᮢ.
 RECT Rect = { 0, 0, 0, 0 };
 HDC Hdc = NULL;
 HPEN Pen = NULL;

 // ⪠ X->  Y| ⠭   孨 㣮 ࠡ祩 . ७ -  窠.
 //  ࠧ .
 GetWindowRect( Window, &Rect );
 // Rect.top -   ᮢ. Rect.right - ਭ  ᮢ.
 Rect.top = Rect.bottom - Rect.top; Rect.right = Rect.right - Rect.left;

 // 稭 ᮢ.
 Hdc = GetWindowDC( Window );

 // 㥬 ࠬ  .
 Pen = CreatePen( PS_SOLID, 1, RGB( 192, 192, 192 ) ); SelectObject( Hdc, Pen );
 SelectObject( Hdc, GetStockObject( LTGRAY_BRUSH ) );
 Rectangle( Hdc, 0, 0, xConstFrame + 1, Rect.top );
 Rectangle( Hdc, 0, 0, Rect.right, yConstFrame + 1 );
 Rectangle( Hdc, Rect.right, Rect.top, Rect.right - xConstFrame - 1, 0 );
 Rectangle( Hdc, Rect.right, Rect.top, 0, Rect.top - yConstFrame - 1 );
 SelectObject( Hdc, GetStockObject( WHITE_PEN ) ); DeleteObject( Pen );

 // 㥬 ᢥ  ⥭.
 Pen = CreatePen( PS_SOLID, 1, RGB( 128, 128, 128 ) ); SelectObject( Hdc, Pen );
 MoveTo( Hdc, 0, Rect.top - 2 );
 LineTo( Hdc, 0, 0 );
 LineTo( Hdc, Rect.right - 1, 0 );
 SelectObject( Hdc, GetStockObject( BLACK_PEN ) ); DeleteObject( Pen );

 // 㥬 ⥬  ⥭.
 MoveTo( Hdc, Rect.right - 1, 1 );
 LineTo( Hdc, Rect.right - 1, Rect.top -1 );
 LineTo( Hdc, 0, Rect.top - 1 );

 // 㥬 ᢥ  譥 ࠬ.
 SelectObject( Hdc, GetStockObject( WHITE_PEN ) );
 MoveTo( Hdc, 1, Rect.top - 3 );
 LineTo( Hdc, 1, 1 );
 LineTo( Hdc, Rect.right - 2, 1 );

 // 㥬 ᢥ  ७ ࠬ.
 MoveTo( Hdc, Rect.right - xConstFrame - 2, yConstFrame + 1 );
 LineTo( Hdc, Rect.right - xConstFrame - 2, yConstFrame + yCaption - 1 );
 LineTo( Hdc, xConstFrame + 1, yConstFrame + yCaption - 1 );

 // 㥬 ⥬  譥 ࠬ.
 Pen = CreatePen( PS_SOLID, 1, RGB( 128, 128, 128 ) ); SelectObject( Hdc, Pen );
 MoveTo( Hdc, Rect.right - 2, 2 );
 LineTo( Hdc, Rect.right - 2, Rect.top - 2 );
 LineTo( Hdc, 1, Rect.top - 2 );

 // 㥬 ⥬  ७ ࠬ.
 MoveTo( Hdc, xConstFrame + 1, yCaption + yConstFrame - 2 );
 LineTo( Hdc, xConstFrame + 1, yConstFrame );
 LineTo( Hdc, Rect.right - xConstFrame - 2, yConstFrame );
 SelectObject( Hdc, GetStockObject( WHITE_PEN ) ); DeleteObject( Pen );

 // 㥬 㣮 譥 ࠬ.
 SetPixel( Hdc, Rect.right - 1, 0, RGB( 64, 64, 64 ) );
 SetPixel( Hdc, 0, Rect.top - 1, RGB( 64, 64, 64 ) );

 // 㥬 㣮 ७ ࠬ.
 SetPixel( Hdc, Rect.right - xConstFrame - 2, yConstFrame, RGB( 192, 192, 192 ) );
 SetPixel( Hdc, xConstFrame + 1, yConstFrame + yCaption - 1, RGB( 192, 192, 192 ) );

 // 蠥 ᮢ.
 ReleaseDC( Window, Hdc );

 // .
 return;
}
#endif

// ---  ࠬ  ᪮ . ---

#ifndef DRAW_FLAT_FRAME_IS_REPLACED
// Window । ,  ஬ 㤥 ᮢ.
VOID DrawFlatFrame( HWND Window )
{
 // ६  ᮢ.
 RECT Rect = { 0, 0, 0, 0 };
 HDC Hdc = NULL;
 HPEN Pen = NULL;

 // ⪠ X->  Y| ⠭   孨 㣮 ࠡ祩 . ७ -  窠.
 //  ࠧ .
 GetWindowRect( Window, &Rect );
 // Rect.top -   ᮢ. Rect.right - ਭ  ᮢ.
 Rect.top = Rect.bottom - Rect.top; Rect.right = Rect.right - Rect.left;

 // 稭 ᮢ.
 Hdc = GetWindowDC( Window );

 // 㥬 ࠬ  .
 Pen = CreatePen( PS_SOLID, 1, RGB( 192, 192, 192 ) ); SelectObject( Hdc, Pen );
 SelectObject( Hdc, GetStockObject( LTGRAY_BRUSH ) );
 Rectangle( Hdc, 0, 0, xConstFrame, Rect.top );
 Rectangle( Hdc, 0, 0, Rect.right, yConstFrame );
 Rectangle( Hdc, Rect.right, Rect.top, Rect.right - xConstFrame, 0 );
 Rectangle( Hdc, Rect.right, Rect.top, 0, Rect.top - yConstFrame );
 SelectObject( Hdc, GetStockObject( WHITE_PEN ) ); DeleteObject( Pen );

 // 㥬 ᢥ  ⥭.
 Pen = CreatePen( PS_SOLID, 1, RGB( 128, 128, 128 ) ); SelectObject( Hdc, Pen );
 MoveTo( Hdc, 0, Rect.top - 2 );
 LineTo( Hdc, 0, 0 );
 LineTo( Hdc, Rect.right - 1, 0 );
 SelectObject( Hdc, GetStockObject( BLACK_PEN ) ); DeleteObject( Pen );

 // 㥬 ⥬  ⥭.
 MoveTo( Hdc, Rect.right - 1, 1 );
 LineTo( Hdc, Rect.right - 1, Rect.top -1 );
 LineTo( Hdc, 0, Rect.top - 1 );

 // 㥬 ᢥ  譥 ࠬ.
 SelectObject( Hdc, GetStockObject( WHITE_PEN ) );
 MoveTo( Hdc, 1, Rect.top - 3 );
 LineTo( Hdc, 1, 1 );
 LineTo( Hdc, Rect.right - 2, 1 );

 // 㥬 ᢥ  ७ ࠬ.
 MoveTo( Hdc, xConstFrame, Rect.top - yConstFrame - 2 );
 LineTo( Hdc, xConstFrame, yConstFrame );
 LineTo( Hdc, Rect.right - xConstFrame - 1, yConstFrame );

 MoveTo( Hdc, Rect.right - xConstFrame, yConstFrame );
 LineTo( Hdc, Rect.right - xConstFrame, Rect.top - yConstFrame );
 LineTo( Hdc, xConstFrame - 1, Rect.top - yConstFrame );

 // 㥬 ⥬  譥 ࠬ.
 Pen = CreatePen( PS_SOLID, 1, RGB( 128, 128, 128 ) ); SelectObject( Hdc, Pen );
 MoveTo( Hdc, Rect.right - 2, 2 );
 LineTo( Hdc, Rect.right - 2, Rect.top - 2 );
 LineTo( Hdc, 1, Rect.top - 2 );

 // 㥬 ⥬  ७ ࠬ.
 MoveTo( Hdc, xConstFrame - 1, Rect.top - yConstFrame - 2 );
 LineTo( Hdc, xConstFrame - 1, yConstFrame - 1 );
 LineTo( Hdc, Rect.right - xConstFrame - 1, yConstFrame - 1 );

 MoveTo( Hdc, Rect.right - xConstFrame - 1, yConstFrame - 1 );
 LineTo( Hdc, Rect.right - xConstFrame - 1, Rect.top - yConstFrame - 1 );
 LineTo( Hdc, xConstFrame - 2, Rect.top - yConstFrame - 1 );
 SelectObject( Hdc, GetStockObject( WHITE_PEN ) ); DeleteObject( Pen );

 // 㥬 㣮 譥 ࠬ.
 SetPixel( Hdc, Rect.right - 1, 0, RGB( 64, 64, 64 ) );
 SetPixel( Hdc, 0, Rect.top - 1, RGB( 64, 64, 64 ) );

 // 㥬 㣮 ७ ࠬ.
 SetPixel( Hdc, xConstFrame, Rect.top - yConstFrame - 1, RGB( 192, 192, 192 ) );
 SetPixel( Hdc, Rect.right - xConstFrame - 1, yConstFrame, RGB( 192, 192, 192 ) );

 // 蠥 ᮢ.
 ReleaseDC( Window, Hdc );

 // .
 return;
}
#endif

// ---  ࠬ  , 㬥襭  箪. ---

#ifndef DRAW_ICON_FRAME_IS_REPLACED
// Window । ,  ஬ 㤥 ᮢ.
VOID DrawIconFrame( HWND Window )
{
 // ६  ᮢ.
 RECT Rect = { 0, 0, 0, 0 };
 INT xFrame = 0; INT yFrame = 0;
 HDC Hdc = NULL;
 HPEN Pen = NULL;

 // ⪠ X->  Y| ⠭   孨 㣮 ࠡ祩 . ७ -  窠.
 //  ࠧ .
 GetWindowRect( Window, &Rect );
 // Rect.top -   ᮢ. Rect.right - ਭ  ᮢ.
 Rect.top = Rect.bottom - Rect.top; Rect.right = Rect.right - Rect.left;

 // 塞 ਭ ࠬ.
 xFrame = ( Rect.right - xIcon ) / 2;
 yFrame = ( Rect.top - yIcon ) / 2;

 // 稭 ᮢ.
 Hdc = GetWindowDC( Window );

 // 㥬 ࠬ  窠.
 Pen = CreatePen( PS_SOLID, 1, RGB( 192, 192, 192 ) ); SelectObject( Hdc, Pen );
 SelectObject( Hdc, GetStockObject( LTGRAY_BRUSH ) );
 Rectangle( Hdc, 0, 0, xFrame, Rect.top );
 Rectangle( Hdc, 0, 0, Rect.right, yFrame );
 Rectangle( Hdc, Rect.right, Rect.top, Rect.right - xFrame, 0 );
 Rectangle( Hdc, Rect.right, Rect.top, 0, Rect.top - yFrame );
 SelectObject( Hdc, GetStockObject( WHITE_PEN ) ); DeleteObject( Pen );

 // 㥬 ᢥ  ࠬ.
 MoveTo( Hdc, 0, Rect.top - 1 );
 LineTo( Hdc, 0, 0 );
 LineTo( Hdc, Rect.right - 1, 0 );

 // 㥬 ⥬  ࠬ.
 Pen = CreatePen( PS_SOLID, 1, RGB( 128, 128, 128 ) ); SelectObject( Hdc, Pen );
 MoveTo( Hdc, Rect.right - 1, 0 );
 LineTo( Hdc, Rect.right - 1, Rect.top - 1 );
 LineTo( Hdc, 0, Rect.top - 1 );
 SelectObject( Hdc, GetStockObject( WHITE_PEN ) ); DeleteObject( Pen );

 // 㥬 㣮 ࠬ.
 SetPixel( Hdc, Rect.right - 1, 0, RGB( 192, 192, 192 ) );
 SetPixel( Hdc, 0, Rect.top - 1, RGB( 192, 192, 192 ) );

 // 蠥 ᮢ.
 ReleaseDC( Window, Hdc );

 // .
 return;
}
#endif

// ---  ࠬ  . ---

#ifndef DRAW_MENU_FRAME_IS_REPLACED
// Window । ,  ஬ 㤥 ᮢ.
VOID DrawMenuFrame( HWND Window )
{
 // ६  ᮢ.
 RECT Rect = { 0, 0, 0, 0 };
 HDC Hdc = NULL;
 HPEN Pen = NULL;

 // ⪠ X->  Y| ⠭   孨 㣮 ࠡ祩 . ७ -  窠.
 //  ࠧ .
 GetWindowRect( Window, &Rect );
 // Rect.top -   ᮢ. Rect.right - ਭ  ᮢ.
 Rect.top = Rect.bottom - Rect.top; Rect.right = Rect.right - Rect.left;

 // 稭 ᮢ.
 Hdc = GetWindowDC( Window );

 // 㥬 ᢥ  ࠬ.
 SelectObject( Hdc, GetStockObject( WHITE_PEN ) );
 MoveTo( Hdc, 0, Rect.top - 2 );
 LineTo( Hdc, 0, 0 );
 LineTo( Hdc, Rect.right - 1, 0 );

 // 㥬 ⥬  ࠬ.
 Pen = CreatePen( PS_SOLID, 1, RGB( 128, 128, 128 ) ); SelectObject( Hdc, Pen );
 MoveTo( Hdc, Rect.right - 2, 1 );
 LineTo( Hdc, Rect.right - 2, Rect.top - 2 );
 LineTo( Hdc, 0, Rect.top - 2 );
 SelectObject( Hdc, GetStockObject( BLACK_PEN ) ); DeleteObject( Pen );

 // 㥬 ⥭  .
 MoveTo( Hdc, Rect.right - 1, 1 );
 LineTo( Hdc, Rect.right - 1, Rect.top - 1 );
 LineTo( Hdc, 0, Rect.top - 1 );

 // 㥬 㣮  ⥭.
 SetPixel( Hdc, Rect.right - 1, 0, RGB( 128, 128, 128 ) );
 SetPixel( Hdc, 0, Rect.top - 1, RGB( 128, 128, 128 ) );

 // 蠥 ᮢ.
 ReleaseDC( Window, Hdc );

 // .
 return;
}
#endif

// ---    ࠢ 孥 㣫 . ---

#ifndef DRAW_BUTTONS_IS_REPLACED
//    ࠢ 孥 㣫   頥 ᪮쪮 祪  .
// Window । ,  ஬ 㤥 ᮢ. Window_style -  룫廊 .
// BYTE Pressed_button -   ,  祭 ᮢ  祭 Selected_button.
// ᫨ Calc_rectangles_only == 1,  ᮢ 祣  ,  ⮫쪮 ஢ .
INT DrawButtons( HWND Window, BYTE Frame, DWORD Window_style, DWORD Window_xstyle, BYTE Pressed_button, BYTE Calc_rectangles_only )
{
 // 쪮 祪  .
 INT Button_width = 0;

 // ᫨   ࠢ 孥 㣫 ᮢ   - 頥 ࠧ  :
 if( Draw_buttons == 0 )
  {
   // ᫨   㢥祭:
	if( Window_style & WS_MAXIMIZEBOX )
    {
     //  = ਭ  .
     Button_width = yCaption - 1;
     // ᫨   㢥祭:
	  if( yCaption > 20 ) Button_width -= 2;
	 }

	// ᫨   㬥襭:
   if( Window_style & WS_MINIMIZEBOX )
    {
	  //  = ࠧ + ਭ  .
     Button_width += yCaption - 1;
     // ᫨   㢥祭:
	  if( yCaption > 20 ) Button_width -= 2;
    }

	// ᫨  筮 ,   ﭭ ࠧ,       :
	if( Window_xstyle & WS_EX_DLGMODALFRAME || Window_style & WS_THICKFRAME )
    if( Window_style & WS_MAXIMIZEBOX || Window_style & WS_MINIMIZEBOX )
	  Button_width --;

   // .
   return Button_width;
  }

 // ६  ᮢ.
 RECT Window_Rect = { 0, 0, 0, 0 };
 HDC Hdc = NULL;
 HPEN Pen = NULL;

 // ᨬ  ⮣,  룫廊 , ࠢ騥   ࠢ 孥 㣫 
 // ᥣ    .  ⮫쪮  אַ㣮쭨,     ᯮ.
 Max_button_Rect.top = -1;
 Min_button_Rect.top = -1;
 Rollup_button_Rect.top = -1;
 Close_button_Rect.top = -1;

 //  㢥祭.
 BYTE Window_is_zoomed = IsZoomed( Window );

 // ⪠ X->  Y| ⠭   孨 㣮 ࠡ祩 . ७ -  窠.
 //  ࠧ .
 GetWindowRect( Window, &Window_Rect );
 // Window_Rect.top -   ᮢ. Window_Rect.right - ਭ  ᮢ.
 Window_Rect.top = Window_Rect.bottom - Window_Rect.top; Window_Rect.right = Window_Rect.right - Window_Rect.left;

 // ᫨  ᯮ  㣮     ⨭   孥 㣫  ,
 //  ᫨   ࠬ  1   ஬  祣  - .
 if( !( Window_style & WS_SYSMENU ) )
  if( !( Window_style & WS_MAXIMIZEBOX ) ) if( !( Window_style & WS_MINIMIZEBOX ) )
	{
    if( Window_style & WS_CHILD ) return 0;
    if( Frame == 2 ) if( Window_Rect.top == yCaption ) return 0;
	}

 // ,   뢠 .
 BYTE Draw_close_button = 1;
 if( Window_style & WS_SYSMENU )
  {
	//  ﭨ ᯨ᪠ ⢨  .
   HMENU Menu = GetSystemMenu( Window, 0 );
   INT Close_item_state = GetMenuState( Menu, SM_CLOSE, MF_BYCOMMAND );
   // ᫨  ⢨ "",    :
   if( Close_item_state != -1 ) if( Close_item_state & MF_GRAYED || Close_item_state & MF_DISABLED )
	 Draw_close_button = 0;
	// ᫨ ⢨ "" ,   ""  "":
   if( Close_item_state == -1 ) if( Window_style & WS_MAXIMIZEBOX || Window_style & WS_MINIMIZEBOX )
	 Draw_close_button = 0;
   // ᫨ ⢨ "" ,   "६":
   if( Close_item_state == -1 )
	 {
     INT Move_item_state = GetMenuState( Menu, SM_MOVE, MF_BYCOMMAND );
     if( Move_item_state != -1 ) Draw_close_button = 0;
	 }
  }

 // ᫨ 祣  㤥 ᮢ - .
 if( !( Window_style & WS_MAXIMIZEBOX ) ) if( !( Window_style & WS_MINIMIZEBOX ) )
  if( Draw_close_button == 0 ) return 0;

 //  אַ㣮쭨  ᨬ  ⮣,  ࠬ  .
 switch( Frame )
  {
   //   :
   case 1:
	 // ᫨    ᮢ ᫥, :
    if( Draw_buttons == 1 )
	  {
      // ᫨   㢥祭:
      if( Window_style & WS_MAXIMIZEBOX )
		 {
        //  אַ㣮쭨   㢥祭.
        Max_button_Rect.top = yNormalFrame;
		  Max_button_Rect.bottom = yNormalFrame + yCaption - 3;
        Max_button_Rect.left = Window_Rect.right - xNormalFrame - yCaption + 2;
        Max_button_Rect.right = Window_Rect.right - xNormalFrame - 1;
		  //  = ਭ  .
		  Button_width = yCaption - 2;
       }

      // ᫨   㬥襭:
      if( Window_style & WS_MINIMIZEBOX )
       {
        //  אַ㣮쭨   㬥襭.
        Min_button_Rect.top = yNormalFrame;
		  Min_button_Rect.bottom = yNormalFrame + yCaption - 3;
        Min_button_Rect.left = Window_Rect.right - xNormalFrame - yCaption - Button_width + 2;
		  Min_button_Rect.right = Window_Rect.right - xNormalFrame - Button_width - 1;
        //  = ࠧ + ਭ  .
        Button_width += yCaption - 2;
		 }

      // ᫨  ᮢ  " ":
		if( Window_is_zoomed )
       {
        //  אַ㣮쭨   " ".
		  Rollup_button_Rect.top = yNormalFrame;
		  Rollup_button_Rect.bottom = yNormalFrame + yCaption - 3;
        Rollup_button_Rect.left = Window_Rect.right - xNormalFrame - yCaption - Button_width + 2;
		  Rollup_button_Rect.right = Window_Rect.right - xNormalFrame - Button_width - 1;
        //  = ࠧ + ਭ  .
        Button_width += yCaption - 2;
       }

      // ᫨    :
		if( Draw_close_button != 0 )
       {
		  //  אַ㣮쭨   .
        Close_button_Rect.top = yNormalFrame;
        Close_button_Rect.bottom = yNormalFrame + yCaption - 3;
		  Close_button_Rect.left = Window_Rect.right - xNormalFrame - yCaption - Button_width + 2;
        Close_button_Rect.right = Window_Rect.right - xNormalFrame - Button_width - 1;
        //  = ࠧ + ਭ  .
		  Button_width += yCaption - 2;
       }
     }
	 // ᫨    ᮢ ࠢ, :
	 else
     {
		// ᫨    :
      if( Draw_close_button != 0 )
       {
        //  אַ㣮쭨   .
        Close_button_Rect.top = yNormalFrame;
        Close_button_Rect.bottom = yNormalFrame + yCaption - 3;
		  Close_button_Rect.left = Window_Rect.right - xNormalFrame - yCaption + 2;
        Close_button_Rect.right = Window_Rect.right - xNormalFrame - 1;
		  //  = ਭ  .
        Button_width = yCaption - 2;
       }

      // ᫨   㢥祭:
      if( Window_style & WS_MAXIMIZEBOX )
		 {
        //  אַ㣮쭨   㢥祭.
        Max_button_Rect.top = yNormalFrame;
		  Max_button_Rect.bottom = yNormalFrame + yCaption - 3;
		  Max_button_Rect.left = Window_Rect.right - xNormalFrame - yCaption - Button_width + 2;
        Max_button_Rect.right = Window_Rect.right - xNormalFrame - Button_width - 1;
		  //  = ࠧ + ਭ  .
        Button_width += yCaption - 2;
       }

      // ᫨   㬥襭:
      if( Window_style & WS_MINIMIZEBOX )
		 {
        //  אַ㣮쭨   㬥襭.
		  Min_button_Rect.top = yNormalFrame;
        Min_button_Rect.bottom = yNormalFrame + yCaption - 3;
        Min_button_Rect.left = Window_Rect.right - xNormalFrame - yCaption - Button_width + 2;
		  Min_button_Rect.right = Window_Rect.right - xNormalFrame - Button_width - 1;
        //  = ࠧ + ਭ  .
        Button_width += yCaption - 2;
		 }

      // ᫨  ᮢ  " ":
		if( Window_is_zoomed )
		 {
        //  אַ㣮쭨   " ".
		  Rollup_button_Rect.top = yNormalFrame;
        Rollup_button_Rect.bottom = yNormalFrame + yCaption - 3;
        Rollup_button_Rect.left = Window_Rect.right - xNormalFrame - yCaption - Button_width + 2;
        Rollup_button_Rect.right = Window_Rect.right - xNormalFrame - Button_width - 1;
        //  = ࠧ + ਭ  .
        Button_width += yCaption - 2;
		 }
     }
	break;

   //  ,  ࠬ  1 :
	case 2:
    // ᫨    ᮢ ᫥, :
    if( Draw_buttons == 1 )
	  {
      // ᫨   㢥祭:
      if( Window_style & WS_MAXIMIZEBOX )
		 {
		  //  אַ㣮쭨   㢥祭.
        Max_button_Rect.top = 0;
		  Max_button_Rect.bottom = yCaption - 2;
        Max_button_Rect.left = Window_Rect.right - yCaption + 1;
        Max_button_Rect.right = Window_Rect.right - 1;
        //  = ਭ  .
        Button_width = yCaption - 1;
        // ᫨  㢥祭  ࠬ  :
		  if( Window_Rect.top > yScreen || Paint_point_frames == 0 || Window == Rolled_window )
         {
			 Max_button_Rect.top ++; Max_button_Rect.right --;
          Button_width --;
         }
		  // ᫨ ஬  祣 :
        else if( Window_Rect.top == yCaption ) if( Window != Rolled_window ) Max_button_Rect.bottom ++;
       }

      // ᫨   㬥襭:
      if( Window_style & WS_MINIMIZEBOX )
		 {
		  //  אַ㣮쭨   㬥襭.
        Min_button_Rect.top = 0;
		  Min_button_Rect.bottom = yCaption - 2;
        Min_button_Rect.left = Window_Rect.right - yCaption - Button_width + 1;
        Min_button_Rect.right = Window_Rect.right - Button_width - 1;
        //  = ࠧ + ਭ  .
        Button_width += yCaption - 1;
        // ᫨  㢥祭  ࠬ  :
		  if( Window_Rect.top > yScreen || Paint_point_frames == 0 || Window == Rolled_window )
         {
			 Min_button_Rect.top ++; Min_button_Rect.right --;
          Button_width --;
         }
		  // ᫨ ஬  祣 :
        else if( Window_Rect.top == yCaption ) if( Window != Rolled_window ) Min_button_Rect.bottom ++;
       }

      // ᫨  ᮢ  " ":
      if( Window_is_zoomed )
		 {
		  //  אַ㣮쭨   " ".
        Rollup_button_Rect.top = 0;
		  Rollup_button_Rect.bottom = yCaption - 2;
        Rollup_button_Rect.left = Window_Rect.right - yCaption - Button_width + 1;
        Rollup_button_Rect.right = Window_Rect.right - Button_width - 1;
        //  = ࠧ + ਭ  .
        Button_width += yCaption - 1;
        // ᫨  㢥祭  ࠬ  :
		  if( Window_Rect.top > yScreen || Paint_point_frames == 0 || Window == Rolled_window )
         {
			 Rollup_button_Rect.top ++; Rollup_button_Rect.right --;
          Button_width --;
         }
		  // ᫨ ஬  祣 :
        else if( Window_Rect.top == yCaption ) if( Window != Rolled_window ) Rollup_button_Rect.bottom ++;
       }

      // ᫨    :
      if( Draw_close_button != 0 )
		 {
		  //  אַ㣮쭨   .
        Close_button_Rect.top = 0;
		  Close_button_Rect.bottom = yCaption - 2;
        Close_button_Rect.left = Window_Rect.right - yCaption - Button_width + 1;
        Close_button_Rect.right = Window_Rect.right - Button_width - 1;
        //  = ࠧ + ਭ  .
        Button_width += yCaption - 1;
        // ᫨  㢥祭  ࠬ  :
		  if( Window_Rect.top > yScreen || Paint_point_frames == 0 || Window == Rolled_window )
         {
			 Close_button_Rect.top ++;
          Close_button_Rect.right --;
         }
		  // ᫨ ஬  祣 :
        else if( Window_Rect.top == yCaption ) if( Window != Rolled_window ) Close_button_Rect.bottom ++;
       }
		// ᫨        ⮬ 㢥祭  ࠬ  :
      else if( Window_Rect.top > yScreen || Paint_point_frames == 0 || Window == Rolled_window ) Button_width ++;
     }
	 // ᫨    ᮢ ࠢ, :
	 else
     {
		// ᫨    :
      if( Draw_close_button != 0 )
       {
        //  אַ㣮쭨   .
        Close_button_Rect.top = 0;
        Close_button_Rect.bottom = yCaption - 2;
		  Close_button_Rect.left = Window_Rect.right - yCaption + 1;
        Close_button_Rect.right = Window_Rect.right - 1;
		  //  = ਭ  .
        Button_width = yCaption - 1;
        // ᫨  㢥祭  ࠬ  :
		  if( Window_Rect.top > yScreen || Paint_point_frames == 0 || Window == Rolled_window )
         {
          Close_button_Rect.top ++; Close_button_Rect.right --;
			 Button_width --;
         }
        // ᫨ ஬  祣 :
		  else if( Window_Rect.top == yCaption ) if( Window != Rolled_window ) Close_button_Rect.bottom ++;
		 }

		// ᫨   㢥祭:
      if( Window_style & WS_MAXIMIZEBOX )
       {
        //  אַ㣮쭨   㢥祭.
        Max_button_Rect.top = 0;
        Max_button_Rect.bottom = yCaption - 2;
		  Max_button_Rect.left = Window_Rect.right - yCaption - Button_width + 1;
        Max_button_Rect.right = Window_Rect.right - Button_width - 1;
		  //  = ࠧ + ਭ  .
        Button_width += yCaption - 1;
        // ᫨  㢥祭  ࠬ  :
		  if( Window_Rect.top > yScreen || Paint_point_frames == 0 || Window == Rolled_window )
         {
          Max_button_Rect.top ++; Max_button_Rect.right --;
			 Button_width --;
         }
        // ᫨ ஬  祣 :
		  else if( Window_Rect.top == yCaption ) if( Window != Rolled_window ) Max_button_Rect.bottom ++;
		 }

		// ᫨   㬥襭:
      if( Window_style & WS_MINIMIZEBOX )
       {
        //  אַ㣮쭨   㬥襭.
        Min_button_Rect.top = 0;
        Min_button_Rect.bottom = yCaption - 2;
		  Min_button_Rect.left = Window_Rect.right - yCaption - Button_width + 1;
        Min_button_Rect.right = Window_Rect.right - Button_width - 1;
		  //  = ࠧ + ਭ  .
        Button_width += yCaption - 1;
        // ᫨  㢥祭  ࠬ  :
		  if( Window_Rect.top > yScreen || Paint_point_frames == 0 || Window == Rolled_window )
         {
          Min_button_Rect.top ++; Min_button_Rect.right --;
			 Button_width --;
         }
        // ᫨ ஬  祣 :
		  else if( Window_Rect.top == yCaption ) if( Window != Rolled_window ) Min_button_Rect.bottom ++;
		 }

		// ᫨  ᮢ  " ":
      if( Window_is_zoomed )
		 {
		  //  אַ㣮쭨   " ".
		  Rollup_button_Rect.top = 0;
		  Rollup_button_Rect.bottom = yCaption - 2;
		  Rollup_button_Rect.left = Window_Rect.right - yCaption - Button_width + 1;
		  Rollup_button_Rect.right = Window_Rect.right - Button_width - 1;
		  //  = ࠧ + ਭ  .
		  Button_width += yCaption - 1;
		  // ᫨  㢥祭  ࠬ  :
		  if( Window_Rect.top > yScreen || Paint_point_frames == 0 || Window == Rolled_window )
			{
			 Rollup_button_Rect.top ++;
			 Rollup_button_Rect.right --;
			}
		  // ᫨ ஬  祣 :
		  else if( Window_Rect.top == yCaption ) if( Window != Rolled_window ) Rollup_button_Rect.bottom ++;
		 }
		// ᫨ ᮢ  " "     ⮬ 㢥祭  ࠬ  :
		else if( Window_Rect.top > yScreen || Paint_point_frames == 0 || Window == Rolled_window ) Button_width ++;
	  }
	break;

	//   ﭭ ࠧ:
	case 3:
	 // ᫨    ᮢ ᫥, :
	 if( Draw_buttons == 1 )
	  {
      // ᫨   㢥祭:
      if( Window_style & WS_MAXIMIZEBOX )
		 {
        //  אַ㣮쭨   㢥祭.
        Max_button_Rect.top = yConstFrame + 1;
		  Max_button_Rect.bottom = yConstFrame + yCaption - 2;
        Max_button_Rect.left = Window_Rect.right - xConstFrame - yCaption;
        Max_button_Rect.right = Window_Rect.right - xConstFrame - 3;
		  //  = ਭ  .
		  Button_width = yCaption - 2;
       }

      // ᫨   㬥襭:
		if( Window_style & WS_MINIMIZEBOX )
       {
        //  אַ㣮쭨   㬥襭.
        Min_button_Rect.top = yConstFrame + 1;
		  Min_button_Rect.bottom = yConstFrame + yCaption - 2;
        Min_button_Rect.left = Window_Rect.right - xConstFrame - yCaption - Button_width;
		  Min_button_Rect.right = Window_Rect.right - xConstFrame - Button_width - 3;
        //  = ࠧ + ਭ  .
        Button_width += yCaption - 2;
		 }

      // ᫨  ᮢ  " ":
		if( Window_is_zoomed )
       {
        //  אַ㣮쭨   " ".
		  Rollup_button_Rect.top = yConstFrame + 1;
		  Rollup_button_Rect.bottom = yConstFrame + yCaption - 2;
        Rollup_button_Rect.left = Window_Rect.right - xConstFrame - yCaption - Button_width;
		  Rollup_button_Rect.right = Window_Rect.right - xConstFrame - Button_width - 3;
        //  = ࠧ + ਭ  .
		  Button_width += yCaption - 2;
       }

      // ᫨    :
		if( Draw_close_button != 0 )
       {
		  //  אַ㣮쭨   .
        Close_button_Rect.top = yConstFrame + 1;
        Close_button_Rect.bottom = yConstFrame + yCaption - 2;
		  Close_button_Rect.left = Window_Rect.right - xConstFrame - yCaption - Button_width;
        Close_button_Rect.right = Window_Rect.right - xConstFrame - Button_width - 3;
        //  = ࠧ + ਭ  .
		  Button_width += yCaption - 2;
       }
     }
	 // ᫨    ᮢ ࠢ, :
	 else
     {
		// ᫨    :
      if( Draw_close_button != 0 )
		 {
        //  אַ㣮쭨   .
        Close_button_Rect.top = yConstFrame + 1;
        Close_button_Rect.bottom = yConstFrame + yCaption - 2;
		  Close_button_Rect.left = Window_Rect.right - xConstFrame - yCaption;
        Close_button_Rect.right = Window_Rect.right - xConstFrame - 3;
		  //  = ਭ  .
        Button_width = yCaption - 2;
       }

      // ᫨   㢥祭:
      if( Window_style & WS_MAXIMIZEBOX )
		 {
        //  אַ㣮쭨   㢥祭.
        Max_button_Rect.top = yConstFrame + 1;
		  Max_button_Rect.bottom = yConstFrame + yCaption - 2;
		  Max_button_Rect.left = Window_Rect.right - xConstFrame - yCaption - Button_width;
        Max_button_Rect.right = Window_Rect.right - xConstFrame - Button_width - 3;
		  //  = ࠧ + ਭ  .
        Button_width += yCaption - 2;
		 }

      // ᫨   㬥襭:
      if( Window_style & WS_MINIMIZEBOX )
		 {
        //  אַ㣮쭨   㬥襭.
		  Min_button_Rect.top = yConstFrame + 1;
        Min_button_Rect.bottom = yConstFrame + yCaption - 2;
        Min_button_Rect.left = Window_Rect.right - xConstFrame - yCaption - Button_width;
		  Min_button_Rect.right = Window_Rect.right - xConstFrame - Button_width - 3;
        //  = ࠧ + ਭ  .
        Button_width += yCaption - 2;
		 }

      // ᫨  ᮢ  " ":
		if( Window_is_zoomed )
		 {
        //  אַ㣮쭨   " ".
		  Rollup_button_Rect.top = yConstFrame + 1;
        Rollup_button_Rect.bottom = yConstFrame + yCaption - 2;
		  Rollup_button_Rect.left = Window_Rect.right - xConstFrame - yCaption - Button_width;
        Rollup_button_Rect.right = Window_Rect.right - xConstFrame - Button_width - 3;
        //  = ࠧ + ਭ  .
        Button_width += yCaption - 2;
		 }
     }
	break;
  }

 // ᫨ Calc_rectangles_only == 1,  ᮢ 祣  ,  ⮫쪮 ஢ .
 if( Calc_rectangles_only == 1 ) return Button_width;

 //  ࠧ אַ㣮쭨.
 RECT Rect = { 0, 0, 0, 0 };

 // ᫨   :
 if( Close_button_Rect.top != -1 )
  {
	Rect.top = Close_button_Rect.top + 1;
   Rect.bottom = Close_button_Rect.bottom + 1;
  }
 // ᫨ ,    㢥祭:
 else if( Max_button_Rect.top != -1 )
  {
	Rect.top = Max_button_Rect.top + 1;
	Rect.bottom = Max_button_Rect.bottom + 1;
  }
 // ᫨ ,    㬥襭:
 else if( Min_button_Rect.top != -1 )
  {
	Rect.top = Min_button_Rect.top + 1;
	Rect.bottom = Min_button_Rect.bottom + 1;
  }

 // ᫨    ᮢ ᫥, :
 if( Draw_buttons == 1 )
  {
	// ᫨   :
	if( Close_button_Rect.top != -1 ) Rect.left = Close_button_Rect.left + 1;
	// ᫨ ,    " ":
	else if( Rollup_button_Rect.top != -1 ) Rect.left = Rollup_button_Rect.left + 1;
	// ᫨ ,    㬥襭:
	else if( Min_button_Rect.top != -1 ) Rect.left = Min_button_Rect.left + 1;
	// ᫨ ,    㢥祭:
	else if( Max_button_Rect.top != -1 ) Rect.left = Max_button_Rect.left + 1;

	// ᫨   㢥祭:
	if( Max_button_Rect.top != -1 ) Rect.right = Max_button_Rect.right + 1;
	// ᫨ ,    㬥襭:
	else if( Min_button_Rect.top != -1 ) Rect.right = Min_button_Rect.right + 1;
	// ᫨ ,    " ":
	else if( Rollup_button_Rect.top != -1 ) Rect.right = Rollup_button_Rect.right + 1;
	// ᫨ ,    :
	else if( Close_button_Rect.top != -1 ) Rect.right = Close_button_Rect.right + 1;
  }
 // ᫨    ᮢ ࠢ, :
 else
  {
	// ᫨   :
	if( Close_button_Rect.top != -1 ) Rect.right = Close_button_Rect.right + 1;
	// ᫨ ,    㢥祭:
	else if( Max_button_Rect.top != -1 ) Rect.right = Max_button_Rect.right + 1;
	// ᫨ ,    㬥襭:
	else if( Min_button_Rect.top != -1 ) Rect.right = Min_button_Rect.right + 1;
	// ᫨ ,    " ":
	else if( Rollup_button_Rect.top != -1 ) Rect.right = Rollup_button_Rect.right + 1;

	// ᫨   " ":
	if( Rollup_button_Rect.top != -1 ) Rect.left = Rollup_button_Rect.left + 1;
	// ᫨ ,    㬥襭:
	else if( Min_button_Rect.top != -1 ) Rect.left = Min_button_Rect.left + 1;
	// ᫨ ,    㢥祭:
	else if( Max_button_Rect.top != -1 ) Rect.left = Max_button_Rect.left + 1;
	// ᫨ ,    :
	else if( Close_button_Rect.top != -1 ) Rect.left = Close_button_Rect.left + 1;
  }

 // DrawButtons with DrawBitmap function
 Hdc = GetWindowDC( Window );

 // do something with the increase and the decrease button
 if( Max_button_Rect.top != -1 )
  {
	// window is zoomed
	if( Window_is_zoomed )
	 {
	  // decrease button pressed
	  if( Pressed_button == 2 )
		{
		DrawBitmap( Hdc, Max_button_Rect.left, Max_button_Rect.top, Maxed_Pl_bitmap );
		}
	  else
		{
		DrawBitmap( Hdc, Max_button_Rect.left, Max_button_Rect.top, Maxed_Np_bitmap );
		}
	 }
	// window is not zoomed
	else
	 {
	  // increase button pressed
	  if( Pressed_button == 2 )
		{
		 DrawBitmap( Hdc, Max_button_Rect.left, Max_button_Rect.top, Max_Pl_bitmap );
		}
	  // increase button released
	  else
		{
		 DrawBitmap( Hdc, Max_button_Rect.left, Max_button_Rect.top, Max_Np_bitmap );
		}
	 }
  }

 // do something with the minimize button
 if( Min_button_Rect.top != -1 )
  {
	// minimize button pressed
	if( Pressed_button == 3 )
	 {
	  DrawBitmap( Hdc, Min_button_Rect.left, Min_button_Rect.top, Min_Pl_bitmap );
	 }
	// minimize button released
	else
	 {
	  DrawBitmap( Hdc, Min_button_Rect.left, Min_button_Rect.top, Min_Np_bitmap );
	 }
  }

 // and now the rollup and the rolldown button
 if( Rollup_button_Rect.top != -1 )
  {
	if ( Window == Rolled_window)
	 {
	  // rolldown button pressed
	  if( Pressed_button == 4 )
		{
		DrawBitmap( Hdc, Rollup_button_Rect.left, Rollup_button_Rect.top, Rolldown_Pl_bitmap );
		}
	  // rolldown button released
	 else
	  {
		DrawBitmap( Hdc, Rollup_button_Rect.left, Rollup_button_Rect.top, Rolldown_Np_bitmap );
	  }
	 }
	else
	 {
	 // rollup button pressed
	 if( Pressed_button == 4 )
	  {
		DrawBitmap( Hdc, Rollup_button_Rect.left, Rollup_button_Rect.top, Rollup_Pl_bitmap );
	  }
	 // rollup button released
	 else
	  {
		DrawBitmap( Hdc, Rollup_button_Rect.left, Rollup_button_Rect.top, Rollup_Np_bitmap );
	  }
	 }
  }

 // the "one click" close button
 if( Close_button_Rect.top != -1 )
  {
	// close button pressed
	if( Pressed_button == 5 )
	 {
	  DrawBitmap( Hdc, Close_button_Rect.left, Close_button_Rect.top, Close_Pl_bitmap );
	 }

	// close button released
	else
	 {
	  DrawBitmap( Hdc, Close_button_Rect.left, Close_button_Rect.top, Close_Np_bitmap );
	}
  }

 // 蠥 ᮢ.
 ReleaseDC( Window, Hdc );

 // .
 return Button_width;
}
#endif

// ---   . ---

#ifndef DRAW_CAPTION_IS_REPLACED
//    ࠢ 孥 㣫   頥 ᪮쪮 祪  .
// Window । ,  ஬ 㤥 ᮢ, Frame । ࠬ ,
// Menu -     ⮬ , SMPressed -   ⨭   孥 㣫.
// Sysmenu_width - ਭ ⨭   孥 㣫, Frame - ਭ ࠬ .
// Button_width - ᪮쪮 祪 﫨 , ᯮ  ࠢ 孥 㣫 .
VOID DrawCaption( HWND Window, BYTE Frame, BYTE Menu, BYTE Sysmenu_width, INT Button_width, BYTE SMPressed, BYTE Draw_sysmenu_only )
{
 // ६  ᮢ.
 RECT Window_Rect = { 0, 0, 0, 0 };
 HDC Hdc = NULL;
 HPEN Pen = NULL;
 HBRUSH Brush = NULL;

 // , ࠭ ,  .
 BYTE Window_is_active = IsActive( Window );

 // ⪠ X->  Y| ⠭   孨 㣮 ࠡ祩 . ७ -  窠.
 //  ࠧ .
 GetWindowRect( Window, &Window_Rect );
 // Window_Rect.top -   ᮢ. Window_Rect.right - ਭ  ᮢ.
 Window_Rect.top = Window_Rect.bottom - Window_Rect.top; Window_Rect.right = Window_Rect.right - Window_Rect.left;

 // ᨬ  ⮣,  룫廊 ,   ⨭   孥 㣫 
 // ᥣ    .  ⮫쪮  אַ㣮쭨,     ᯮ.
 //  ⮣ ᯮ ६ Frame, Sysmenu_width  Button_width.
 RECT System_menu_Rect = { 0, 0, 0, 0 }; RECT Caption_Rect = { 0, 0, 0, 0 };

 //  אַ㣮쭨  ᨬ  ⮣,  ࠬ  .
 switch( Frame )
  {
   //   :
   case 1:
    // ᫨ ⨭   孥 㣫 ᮢ  , :
    if( Sysmenu_width == 0 )
     {
		Caption_Rect.top = yNormalFrame;
      Caption_Rect.bottom = yNormalFrame + yCaption - 3;
      Caption_Rect.left = xNormalFrame;
      Caption_Rect.right = Window_Rect.right - xNormalFrame - Button_width - 1;
	  }
    //  ᫨ , :
    else
     {
		System_menu_Rect.top = yNormalFrame;
      System_menu_Rect.bottom = yNormalFrame + yCaption - 3;
      System_menu_Rect.left = xNormalFrame;
      System_menu_Rect.right = xNormalFrame + Sysmenu_width - 1;
      Caption_Rect.top = yNormalFrame;
      Caption_Rect.bottom = yNormalFrame + yCaption - 3;
      Caption_Rect.left = System_menu_Rect.right + 1;
      Caption_Rect.right = Window_Rect.right - xNormalFrame - Button_width - 1;
     }
   break;

   //  ,  ࠬ  1 :
	case 2:
    // ᫨ ⨭   孥 㣫 ᮢ  , :
    if( Sysmenu_width == 0 )
     {
		Caption_Rect.top = 0;
      Caption_Rect.bottom = yCaption - 2;
      Caption_Rect.left = 0;
      Caption_Rect.right = Window_Rect.right - Button_width - 1;
		// ᫨ ࠬ     :
      if( Paint_point_frames == 0 ) if( Button_width == 0 ) Caption_Rect.right --;
      // ᫨  㢥祭  ࠬ  :
      if( Window_Rect.top > yScreen || Paint_point_frames == 0 || Window == Rolled_window )
       {
        Caption_Rect.top ++;
        Caption_Rect.left ++;
       }
      // ᫨ ஬  祣 :
      else if( Window_Rect.top == yCaption ) if( Window != Rolled_window ) Caption_Rect.bottom ++;
     }
    //  ᫨ , :
	 else
     {
      System_menu_Rect.top = 0;
      System_menu_Rect.bottom = yCaption - 2;
		System_menu_Rect.left = 0;
      System_menu_Rect.right = Sysmenu_width;
      Caption_Rect.top = 0;
      Caption_Rect.bottom = yCaption - 2;
		Caption_Rect.left = System_menu_Rect.right + 1;
      Caption_Rect.right = Window_Rect.right - Button_width - 1;
      // ᫨ ࠬ     :
      if( Paint_point_frames == 0 ) if( Button_width == 0 ) Caption_Rect.right --;
      // ᫨  㢥祭  ࠬ  :
      if( Window_Rect.top > yScreen || Paint_point_frames == 0 || Window == Rolled_window )
       {
        Caption_Rect.top ++; System_menu_Rect.top ++;
        System_menu_Rect.left ++;
       }
      // ᫨ ஬  祣 :
      else if( Window_Rect.top == yCaption ) if( Window != Rolled_window )
		 {
        Caption_Rect.bottom ++;
        System_menu_Rect.bottom ++;
       }
     }
   break;

   //   ﭭ ࠧ:
	case 3:
    // ᫨ ⨭   孥 㣫 ᮢ  , :
    if( Sysmenu_width == 0 )
     {
      Caption_Rect.top = yConstFrame + 1;
      Caption_Rect.bottom = yConstFrame + yCaption - 2;
      Caption_Rect.left = xConstFrame + 2;
      Caption_Rect.right = Window_Rect.right - xConstFrame - Button_width - 3;
     }
    //  ᫨ , :
    else
     {
		System_menu_Rect.top = yConstFrame + 1;
      System_menu_Rect.bottom = yConstFrame + yCaption - 2;
      System_menu_Rect.left = xConstFrame + 2;
      System_menu_Rect.right = xConstFrame + Sysmenu_width + 1;
      Caption_Rect.top = yConstFrame + 1;
      Caption_Rect.bottom = yConstFrame + yCaption - 2;
      Caption_Rect.left = System_menu_Rect.right + 1;
      Caption_Rect.right = Window_Rect.right - xConstFrame - Button_width - 3;
	  }
   break;
  }

 // 稭 ᮢ.
 Hdc = GetWindowDC( Window );

 // ન ꥬ .
 if( Draw_captions == 1 )
  {
   // 㥬 ࠬ ⨭.
   if( Sysmenu_width != 0 )
    {
     // 㥬 ⥬  ࠬ ⨭.
     Pen = CreatePen( PS_SOLID, 1, RGB( 128, 128, 128 ) ); SelectObject( Hdc, Pen );
     MoveTo( Hdc, System_menu_Rect.right, System_menu_Rect.top + 1 );
     LineTo( Hdc, System_menu_Rect.right, System_menu_Rect.bottom );
     LineTo( Hdc, System_menu_Rect.left, System_menu_Rect.bottom );
     SelectObject( Hdc, GetStockObject( WHITE_PEN ) ); DeleteObject( Pen );

	  // 㥬 ᢥ  ࠬ ⨭.
     MoveTo( Hdc, System_menu_Rect.left, System_menu_Rect.bottom - 1 );
     LineTo( Hdc, System_menu_Rect.left, System_menu_Rect.top );
     LineTo( Hdc, System_menu_Rect.right, System_menu_Rect.top );

     // 㥬 㣮.
     SetPixel( Hdc, System_menu_Rect.right, System_menu_Rect.top, RGB( 192, 192, 192 ) );
     SetPixel( Hdc, System_menu_Rect.left, System_menu_Rect.bottom, RGB( 192, 192, 192 ) );
    }

   // ᫨  ࠭ - 㥬   梥⮬.
   if( !Draw_sysmenu_only )
    if( Window_is_active )
     {
      // ᮢ뢠 ᢥ  .
      Pen = CreatePen( PS_SOLID, 1, Color_of_caption ); SelectObject( Hdc, Pen );
      MoveTo( Hdc, Caption_Rect.left, Caption_Rect.bottom );
      LineTo( Hdc, Caption_Rect.left, Caption_Rect.top );
      LineTo( Hdc, Caption_Rect.right + 1, Caption_Rect.top );

		// ᮢ뢠 ⥬  .
      MoveTo( Hdc, Caption_Rect.right, Caption_Rect.top + 1 );
      LineTo( Hdc, Caption_Rect.right, Caption_Rect.bottom );
      LineTo( Hdc, Caption_Rect.left, Caption_Rect.bottom );
      SelectObject( Hdc, GetStockObject( WHITE_PEN ) ); DeleteObject( Pen );
     }
    // ᫨   ࠭ - ન ꥬ :
    else
     {
      // 㥬 ⥬  .
      Pen = CreatePen( PS_SOLID, 1, RGB( 128, 128, 128 ) ); SelectObject( Hdc, Pen );
      MoveTo( Hdc, Caption_Rect.right, Caption_Rect.top + 1 );
      LineTo( Hdc, Caption_Rect.right, Caption_Rect.bottom );
      LineTo( Hdc, Caption_Rect.left, Caption_Rect.bottom );
      SelectObject( Hdc, GetStockObject( WHITE_PEN ) ); DeleteObject( Pen );

      // 㥬 ᢥ  .
      MoveTo( Hdc, Caption_Rect.left, Caption_Rect.bottom );
      LineTo( Hdc, Caption_Rect.left, Caption_Rect.top );
      LineTo( Hdc, Caption_Rect.right, Caption_Rect.top );

      // 㥬 㣮.
      SetPixel( Hdc, Caption_Rect.right, Caption_Rect.top, RGB( 192, 192, 192 ) );
      SetPixel( Hdc, Caption_Rect.left, Caption_Rect.bottom, RGB( 192, 192, 192 ) );
     }
  }
 //   㣫㡨  -    ⮫쪮   .
 else if( Draw_captions == 2 ) if( Frame == 1 )
  {
   // 㥬 ᢥ  .
   SelectObject( Hdc, GetStockObject( WHITE_PEN ) );
   MoveTo( Hdc, Window_Rect.right - xNormalFrame, yNormalFrame - 1 );
   LineTo( Hdc, Window_Rect.right - xNormalFrame, yNormalFrame + yCaption - 2 );
   LineTo( Hdc, xNormalFrame - 1, yNormalFrame + yCaption - 2 );

   // 㥬 ⥬  .
   Pen = CreatePen( PS_SOLID, 1, RGB( 128, 128, 128 ) ); SelectObject( Hdc, Pen );
   MoveTo( Hdc, xNormalFrame - 1, yNormalFrame + yCaption - 3 );
   LineTo( Hdc, xNormalFrame - 1, yNormalFrame - 1 );
   LineTo( Hdc, Window_Rect.right - xNormalFrame, yNormalFrame - 1 );
	SelectObject( Hdc, GetStockObject( WHITE_PEN ) ); DeleteObject( Pen );

   // 㥬 㣮 .
   SetPixel( Hdc, Window_Rect.right - xNormalFrame, yNormalFrame - 1, RGB( 192, 192, 192 ) );
   SetPixel( Hdc, xNormalFrame - 1, yNormalFrame + yCaption - 2, RGB( 192, 192, 192 ) );
  }

 // 㥬 ,    ꥬ - ᫨  .
 if( Menu == 1 ) if( Draw_captions == 1 ) if( Draw_menus == 1 ) if( !Draw_sysmenu_only )
  {
   //   :
   if( Frame == 1 )
    {
     // 㥬 ᢥ  .
     SelectObject( Hdc, GetStockObject( WHITE_PEN ) );
     MoveTo( Hdc, xNormalFrame, yNormalFrame + yCaption - 2 );
     LineTo( Hdc, Window_Rect.right - xNormalFrame, yNormalFrame + yCaption - 2 );

     // 㥬 ⥬  .
     Pen = CreatePen( PS_SOLID, 1, RGB( 128, 128, 128 ) ); SelectObject( Hdc, Pen );
	  MoveTo( Hdc, Window_Rect.right - xNormalFrame - 1, yNormalFrame + yCaption + yMenu - 1 );
     LineTo( Hdc, xNormalFrame - 1, yNormalFrame + yCaption + yMenu - 1 );
     SelectObject( Hdc, GetStockObject( WHITE_PEN ) ); DeleteObject( Pen );
    }
   // ᫨   ࠬ  1 :
   else if( Frame == 2 )
    {
     // 㥬 ᢥ  .
     SelectObject( Hdc, GetStockObject( WHITE_PEN ) );
     MoveTo( Hdc, 1, yCaption - 1 );
     LineTo( Hdc, Window_Rect.right - 1, yCaption - 1 );

     // 㥬 ⥬  .
     Pen = CreatePen( PS_SOLID, 1, RGB( 128, 128, 128 ) ); SelectObject( Hdc, Pen );
     MoveTo( Hdc, Window_Rect.right - 2, yCaption + yMenu );
     LineTo( Hdc, 0, yCaption + yMenu );
     SelectObject( Hdc, GetStockObject( WHITE_PEN ) ); DeleteObject( Pen );
    }
  }

 // 㥬 ⨭   孥 㣫.
 if( Draw_captions == 1 ) if( Draw_system_menu == 1 ) if( Sysmenu_width != 0 )
  {
   //  箪 .
   HICON Window_icon = GetClassWord( Window, GCW_HICON );

   // ,    । .
   if( Window_icon != NULL )
    {
     // ,    । .
     GetClassName( Window, Window_name, SIZE_OF_NAME );
     // ᫨   FontMonger:
     if( lstrcmp( Window_name, FontMonger_name ) == 0 )
      {
       //  箪 த⥫᪮ .
       Window_icon = GetClassWord( GetParent( GetParent( Window ) ), GCW_HICON );
       // ⠭  箪.
       SetClassWord( Window, GCW_HICON, Window_icon );
      }
    }

   // ᫨ 窠  - 㧭 箪 த⥫᪮     ਫ.
   if( Window_icon == NULL )
    {
     //  த⥫᪮ .
     HWND Parent_window = GetParent( Window );
     // ᬠਢ  த⥫᪨ .
     HWND Next_window = NULL;
     // ᬠਢ .
     if( Parent_window != NULL )
      while( 1 )
       {
        //  箪 .
        Window_icon = GetClassWord( Parent_window, GCW_HICON );
        // ᫨ 窠 :
        if( Window_icon == NULL )
         {
          //  ᫥饥 த⥫᪮ .
          Next_window = GetParent( Parent_window );
          // ᫨   - த ॡ .
			 if( Next_window != NULL ) Parent_window = Next_window;
          //  ᫨   - 蠥 .
          else break;
         }
        //  ᫨ 箪  - 蠥 .
        else break;
       }
    }

   // ᫨ 窠  - 㥬 ᢮.
   if( Window_icon == NULL ) Window_icon = Sysmenu_icon;

   // ᫨ ⨭ 뫠 ࠭   :
   if( SMPressed == 1 )
    {
     // 訢 ᢥ  ࠬ ⨭.
     Pen = CreatePen( PS_SOLID, 1, RGB( 128, 128, 128 ) ); SelectObject( Hdc, Pen );
     MoveTo( Hdc, System_menu_Rect.left, System_menu_Rect.bottom );
     LineTo( Hdc, System_menu_Rect.left, System_menu_Rect.top );
     LineTo( Hdc, System_menu_Rect.right + 1, System_menu_Rect.top );
	  SelectObject( Hdc, GetStockObject( WHITE_PEN ) ); DeleteObject( Pen );

     //  ⨭, ⮡ ,   .
     System_menu_Rect.left ++; System_menu_Rect.top ++;
     System_menu_Rect.right ++; System_menu_Rect.bottom ++;

     // 訢 ᢮ ࠭⢮ - 㥬 .
     Pen = CreatePen( PS_SOLID, 1, RGB( 192, 192, 192 ) ); SelectObject( Hdc, Pen );
     MoveTo( Hdc, System_menu_Rect.left, System_menu_Rect.bottom - 1 );
     LineTo( Hdc, System_menu_Rect.left, System_menu_Rect.top );
     LineTo( Hdc, System_menu_Rect.right, System_menu_Rect.top );
     SelectObject( Hdc, GetStockObject( WHITE_PEN ) ); DeleteObject( Pen );
    }

    // 訢 ࠭⢮  ⨭.
    SelectObject( Hdc, GetStockObject( NULL_PEN ) );
    SelectObject( Hdc, GetStockObject( LTGRAY_BRUSH ) );
    Rectangle( Hdc, System_menu_Rect.left + 1, System_menu_Rect.top + 1, System_menu_Rect.right + 1, System_menu_Rect.bottom + 1 );

    // ६  ᮢ ⨭.
	 HDC Hdc_in_memory = NULL; HBITMAP Old_bitmap = NULL;

    //  ⨭  .
    Hdc_in_memory = CreateCompatibleDC( Hdc ); Old_bitmap = SelectObject( Hdc_in_memory, Sysmenu_bitmap );

    // 㥬  ⨭ אַ㣮쭨.
    Pen = CreatePen( PS_SOLID, 1, RGB( 192, 192, 192 ) ); SelectObject( Hdc_in_memory, Pen );
    SelectObject( Hdc_in_memory, GetStockObject( LTGRAY_BRUSH ) );
    Rectangle( Hdc_in_memory, 0, 0, xIcon, yIcon );
    SelectObject( Hdc_in_memory, GetStockObject( WHITE_PEN ) ); DeleteObject( Pen );

    // 㥬  ⨭ 箪 .
    DrawIcon( Hdc_in_memory, 0, 0, Window_icon );

    // ᫨   ࠬ  1 , 窠 ,   㢥祭  ࠬ :
    if( Frame == 2 ) if( Window_icon == Sysmenu_icon ) if( Window_Rect.top <= yScreen ) if( Paint_point_frames != 0 ) if( Window != Rolled_window )
     {
      // 塞 ࠧ 窠, ⮡  룫拉 ⠪ ,    ⠫ .
      System_menu_Rect.bottom --;
      System_menu_Rect.right --;

      // 訢 ᢮ ࠭⢮ - 㥬 .
      Pen = CreatePen( PS_SOLID, 1, RGB( 192, 192, 192 ) ); SelectObject( Hdc, Pen );
      MoveTo( Hdc, System_menu_Rect.right, System_menu_Rect.top - 1 );
      LineTo( Hdc, System_menu_Rect.right, System_menu_Rect.bottom );
      LineTo( Hdc, System_menu_Rect.left, System_menu_Rect.bottom );
      SelectObject( Hdc, GetStockObject( WHITE_PEN ) ); DeleteObject( Pen );
     }

    // ७ᨬ ⨭  ன⢮.
    StretchBlt( Hdc, System_menu_Rect.left + 1, System_menu_Rect.top + 1, System_menu_Rect.right - System_menu_Rect.left - 1, System_menu_Rect.bottom - System_menu_Rect.top - 1, Hdc_in_memory, 0, 0, xIcon, yIcon, SRCCOPY );

    // 뢠 ⨭  .
    SelectObject( Hdc_in_memory, Old_bitmap ); DeleteDC( Hdc_in_memory );
  }

 // 㥬 .
 if( Draw_captions == 1 ) if( Draw_window_title == 1 ) if( !Draw_sysmenu_only )
  {
   // ,  룫廊  .
	Window_caption[ 0 ] = NULL; Window_caption[ 1 ] = NULL;
   Paint_frames = 0; GetWindowText( Window, Window_caption, 255 ); Paint_frames = 1;

   // ᫨   祣  - ᬮਬ   த⥫᪮ .
   if( Window_caption[ 0 ] == NULL ) if( Window_caption[ 1 ] == NULL )
    {
     //  த⥫᪮ .
     HWND Parent_window = GetParent( Window );
     // ᫨   - 㧭  .
     if( Parent_window != NULL ) { Paint_frames = 0; GetWindowText( Parent_window, Window_caption, 255 ); Paint_frames = 1; }

     // ᫨   ࠢ  - ᪠ 㬭 -.
     if( Window_caption[ 0 ] == NULL ) if( Window_caption[ 1 ] == NULL ) lstrcpyn( Window_caption, Wise_word, 4 );
    }

   // ᫨  ࠭:
   if( Window_is_active )
    {
     // 㥬 .
     SelectObject( Hdc, GetStockObject( NULL_PEN ) );
	  SelectObject( Hdc, GetStockObject( HOLLOW_BRUSH ) );
     Brush = CreateSolidBrush( Color_of_caption ); SelectObject( Hdc, Brush );
     Rectangle( Hdc, Caption_Rect.left, Caption_Rect.top, Caption_Rect.right + 2, Caption_Rect.bottom + 2 );
     SelectObject( Hdc, GetStockObject( LTGRAY_BRUSH ) ); DeleteObject( Brush );

     //    1  , ⮡ 頫  㪢.
     Caption_Rect.top ++;

     // 㪢   室  , ન騥 ꥬ .
     if( Draw_captions == 1 ) Caption_Rect.left += 2; else Caption_Rect.left += 1;
     Caption_Rect.right --;

     // 㥬  .
     SelectObject( Hdc, GetStockObject( SYSTEM_FONT ) );
     SetTextColor( Hdc, Color_of_caption_text );
     SetBkMode( Hdc, TRANSPARENT );
     DrawText( Hdc, Window_caption, -1, &Caption_Rect, DT_SINGLELINE | DT_CENTER | DT_VCENTER | DT_NOPREFIX );
    }
   // ᫨   ࠭:
   else
	 {
     // 蠥  ᮢ, ⮡  ண , ન騥 ꥬ .
     if( Draw_captions == 1 )
      {
       Caption_Rect.left ++; Caption_Rect.top ++;
       Caption_Rect.right --; Caption_Rect.bottom --;
      }

     // 㥬 .
     SelectObject( Hdc, GetStockObject( NULL_PEN ) );
     SelectObject( Hdc, GetStockObject( HOLLOW_BRUSH ) );
     Brush = CreateSolidBrush( Color_of_inactive_caption ); SelectObject( Hdc, Brush );
     Rectangle( Hdc, Caption_Rect.left, Caption_Rect.top, Caption_Rect.right + 2, Caption_Rect.bottom + 2 );
     SelectObject( Hdc, GetStockObject( LTGRAY_BRUSH ) ); DeleteObject( Brush );

     // 頥  ᮢ  室 ﭨ.
     if( Draw_captions == 1 )
      {
       Caption_Rect.left --; Caption_Rect.top --;
       Caption_Rect.right ++; Caption_Rect.bottom ++;
		}

     //    1  , ⮡ 頫  㪢.
     //  ᤢ    , ⮡ ભ,    ࠭.
     Caption_Rect.left --; Caption_Rect.right --; Caption_Rect.bottom --;

     // 㪢   室  , ન騥 ꥬ .
     if( Draw_captions == 1 ) Caption_Rect.left += 3; else Caption_Rect.left += 2;

     // 㥬  .
     SelectObject( Hdc, GetStockObject( SYSTEM_FONT ) );
     SetTextColor( Hdc, Color_of_inactive_text );
     SetBkMode( Hdc, TRANSPARENT );
     DrawText( Hdc, Window_caption, -1, &Caption_Rect, DT_SINGLELINE | DT_CENTER | DT_VCENTER | DT_NOPREFIX );
    }
  }

 // 蠥 ᮢ.
 ReleaseDC( Window, Hdc );

 //   1  뫠 .  ᭮ ᮢ .
 if( Frame == 2 ) if( Window_Rect.top <= yScreen ) if( Paint_point_frames != 0 ) if( Window != Rolled_window ) DrawPointFrame( Window );

 // .
 return;
}
#endif

// ---  , ࠧ   ࠡ  . ---

#ifndef DRAW_DIVISION_LINE_IS_REPLACED
//  , ࠧ   ࠡ  .
// Window । ,  ஬ 㤥 ᮢ. Frame -  ࠬ  .
VOID DrawDivisionLine( HWND Window, BYTE Frame )
{
 // ६  ᮢ.
 RECT Rect = { 0, 0, 0, 0 };
 HDC Hdc = NULL;

 // ⪠ X->  Y| ⠭   孨 㣮 ࠡ祩 . ७ -  窠.
 //  ࠧ .
 GetWindowRect( Window, &Rect );
 // Rect.top -   ᮢ. Rect.right - ਭ  ᮢ.
 Rect.top = Rect.bottom - Rect.top; Rect.right = Rect.right - Rect.left;

 //   :
 if( Frame == 1 )
  {
   // 稭 ᮢ.
   Hdc = GetWindowDC( Window );

   // 㥬  冷  .
   SelectObject( Hdc, GetStockObject( WHITE_PEN ) );
   MoveTo( Hdc, xNormalFrame, yNormalFrame + yCaption - 2 );
   LineTo( Hdc, Rect.right - xNormalFrame, yNormalFrame + yCaption - 2 );

   // 蠥 ᮢ.
   ReleaseDC( Window, Hdc );
  }
 //  ,  ࠬ  1 :
 else
  {
   // ᫨ ஬  祣  - .
   if( Rect.top == yCaption ) return;

   // ᫨    ࠭,   ⠢ - .
   if( Rect.top >= yScreen ) return;

   // 稭 ᮢ.
   Hdc = GetWindowDC( Window );

   // 㥬  冷  .
   SelectObject( Hdc, GetStockObject( WHITE_PEN ) );
   MoveTo( Hdc, 1, yCaption - 1 );
   LineTo( Hdc, Rect.right - 1, yCaption - 1 );

   // 蠥 ᮢ.
   ReleaseDC( Window, Hdc );
  }

 // .
 return;
}
#endif

// --- ࠡ뢠      . ---

#ifndef ANIMATE_BUTTONS_IS_REPLACED
// Window । ,  ஬  ᮢ .
// 頥 祭: ᫨ ᮮ饭 ࠡ⠭      ।,  1,  0.
BYTE AnimateButtons( HWND Window, UINT Message )
{
 // ,  ࠬ  .
 LONG Window_style = GetWindowLong( Window, GWL_STYLE );
 LONG Window_xstyle = GetWindowLong( Window, GWL_EXSTYLE );

 // ᫨  ᪮ -  ᮢ  㦭, .
 if( Window_style & WS_DLGFRAME ) if( !( Window_style & WS_BORDER ) )
  if( !( Window_style & WS_THICKFRAME ) ) if( !( Window_xstyle & WS_EX_DLGMODALFRAME ) ) return 0;

 // ᫨  ᪮  ᮧ  ᭮  ﭭ ࠧ - .
 if( Window_xstyle & WS_EX_DLGMODALFRAME ) if( Window_style & WS_POPUP || Window_style & WS_CHILD )
  if( !( ( Window_style & WS_BORDER ) && ( Window_style & WS_DLGFRAME ) ) ) return 0;

 // ᫨    -  ᮢ  㦭, .
 if( Window_style & WS_POPUP ) if( !( Window_style & WS_BORDER ) )
 if( !( Window_style & WS_DLGFRAME ) ) if( !( Window_style & WS_THICKFRAME ) ) return 0;

 // ᫨   - .
 if( Window_style & WS_CHILD ) if( !( Window_style & WS_DLGFRAME ) ) if( !( Window_xstyle & WS_EX_DLGMODALFRAME ) ) return 0;
 if( Window_style & WS_CHILD ) if( Window_style & WS_DLGFRAME ) if( !( Window_style & WS_BORDER ) ) if( !( Window_xstyle & WS_EX_DLGMODALFRAME ) ) return 0;
 if( Window_style & WS_POPUP ) if( !( Window_style & WS_DLGFRAME ) ) if( !( Window_xstyle & WS_EX_DLGMODALFRAME ) ) return 0;
 if( Window_style & WS_POPUP ) if( Window_style & WS_DLGFRAME ) if( !( Window_style & WS_BORDER ) ) if( !( Window_xstyle & WS_EX_DLGMODALFRAME ) ) return 0;

 // ᫨   - .
 if( !IsWindow( Window ) ) return 0;

 // ६  । ࠧ஢ .
 RECT Window_Rect = { 0, 0, 0, 0 };

 // ⪠ X->  Y| ⠭   孨 㣮 ࠡ祩 . ७ -  窠.
 //  ࠧ . Window_Rect.top  Window_Rect.left ।  孨 㣮 ,
 // Window_Rect.right  Window_Rect.bottom - ࠢ  㣮 .
 GetWindowRect( Window, &Window_Rect );

 // ।塞,  ᯮ 㪠⥫ .
 POINT Mouse_point = { 0, 0 }; GetCursorPos( &Mouse_point );

 //     .
 INT Button_width = 0;

 // ᫨  ᮢ   ࠢ 孥 㣫 :
 if( Draw_buttons != 0 )
  {
   // ,  ᯮ    .
   //  祭   ६ Max_button_Rect, Min_button_Rect,  㣨.
   Button_width = DrawButtons( Window, 1, Window_style, Window_xstyle, 0, 1 );

   // ਢ  Button_Rect  ᮮ⢥⢨  祭ﬨ Mouse_point.
   if( Max_button_Rect.top != -1 )
	 {
     Max_button_Rect.left += Window_Rect.left; Max_button_Rect.right  += Window_Rect.left;
     Max_button_Rect.top  += Window_Rect.top;  Max_button_Rect.bottom += Window_Rect.top;
    }
   if( Min_button_Rect.top != -1 )
    {
     Min_button_Rect.left += Window_Rect.left; Min_button_Rect.right  += Window_Rect.left;
     Min_button_Rect.top  += Window_Rect.top;  Min_button_Rect.bottom += Window_Rect.top;
    }
   if( Rollup_button_Rect.top != -1 )
    {
     Rollup_button_Rect.left += Window_Rect.left; Rollup_button_Rect.right  += Window_Rect.left;
     Rollup_button_Rect.top  += Window_Rect.top;  Rollup_button_Rect.bottom += Window_Rect.top;
    }
   if( Close_button_Rect.top != -1 )
    {
     Close_button_Rect.left += Window_Rect.left; Close_button_Rect.right  += Window_Rect.left;
     Close_button_Rect.top  += Window_Rect.top;  Close_button_Rect.bottom += Window_Rect.top;
    }
  }

 //   :
 if( !( Window_xstyle & WS_EX_DLGMODALFRAME ) ) if( Window_style & WS_THICKFRAME )
  {
   // ᫨  ᮢ ⨭   孥 㣫 :
   if( Window_style & WS_SYSMENU ) if( Draw_captions == 1 ) if( Draw_system_menu != 0 )
    {
     // ᫨ 㪠⥫  ᯮ  ⨭:
     if( Mouse_point.y >= Window_Rect.top + yNormalFrame  && Mouse_point.y <= Window_Rect.top + yNormalFrame + yCaption - 3 &&
         Mouse_point.x >= Window_Rect.left + xNormalFrame && Mouse_point.x <= Window_Rect.left + xNormalFrame + yCaption - 3 )
      {
       //  Win-OS/2  뢠 ⮫쪮     .
       if( Message == WM_NCRBUTTONDOWN || Message == WM_NCMBUTTONDOWN || Message == WM_NCMOUSEMOVE ||
           Message == WM_NCRBUTTONDBLCLK || Message == WM_NCMBUTTONDBLCLK ) return 0;

       //  ⨭   孥 㣫 ⮩  ᮢ뢠 ࠬ .
       Selected_button = 1;
       DrawCaption( Window, 1, 0, yCaption - 2, Button_width, 1, 1 );

       // .
		 return 0;
      }
     // ᫨ 㪠⥫ ᯮ   ⨭,  ࠭  뫠 :
     else if( Selected_button == 1 )
      {
       //   .
       Selected_button = 0;
       // 㥬  .
       DrawCaption( Window, 1, 0, yCaption - 2, Button_width, 0, 1 );
      }
    }

   // ᫨  ᮢ   ࠢ 孥 㣫 :
   if( Draw_buttons != 0 )
    {
     // ᫨     㢥祭 ࠧ:
     if( Max_button_Rect.top != -1 )
      // ᫨ 㪠⥫  ᯮ   㢥祭 ࠧ:
      if( Mouse_point.y >= Max_button_Rect.top  && Mouse_point.y <= Max_button_Rect.bottom + 2 &&
          Mouse_point.x >= Max_button_Rect.left && Mouse_point.x <= Max_button_Rect.right )
		 {
        // ᫨  뫠  - .
        if( Selected_button == 2 ) return 1;

        //     ⮩.
        Selected_button = 2;
        DrawButtons( Window, 1, Window_style, Window_xstyle, 2, 0 );

        // 뢠 , ᫨  ॡ.
        MoveWindowAbove( Window );

        // .
        return 1;
       }
      // ᫨ 㪠⥫ ᯮ    㢥祭 ࠧ,  ࠭  뫠 :
      else if( Selected_button == 2 )
       {
        //   .
        Selected_button = 0;
        // 㥬   ࠢ 孥 㣫 .
		  DrawButtons( Window, 1, Window_style, Window_xstyle, 0, 0 );
       }

     // ᫨     㬥襭:
     if( Min_button_Rect.top != -1 )
      // ᫨ 㪠⥫  ᯮ   㬥襭:
      if( Mouse_point.y >= Min_button_Rect.top  && Mouse_point.y <= Min_button_Rect.bottom + 2 &&
          Mouse_point.x >= Min_button_Rect.left && Mouse_point.x <= Min_button_Rect.right )
       {
        // ᫨  뫠  - .
        if( Selected_button == 3 ) return 1;

        //     ⮩.
        Selected_button = 3;
        DrawButtons( Window, 1, Window_style, Window_xstyle, 3, 0 );

        // 뢠 , ᫨  ॡ.
        MoveWindowAbove( Window );

        // .
		  return 1;
       }
      // ᫨ 㪠⥫ ᯮ    㬥襭,  ࠭  뫠 :
      else if( Selected_button == 3 )
       {
        //   .
        Selected_button = 0;
        // 㥬   ࠢ 孥 㣫 .
        DrawButtons( Window, 1, Window_style, Window_xstyle, 0, 0 );
       }

     // ᫨     " ":
     if( Rollup_button_Rect.top != -1 )
      // ᫨ 㪠⥫   ᯮ   " ":
      if( Mouse_point.y >= Rollup_button_Rect.top  && Mouse_point.y <= Rollup_button_Rect.bottom + 2 &&
          Mouse_point.x >= Rollup_button_Rect.left && Mouse_point.x <= Rollup_button_Rect.right )
       {
        // ᫨  뫠  - .
        if( Selected_button == 4 ) return 1;

		  //     ⮩.
        Selected_button = 4;
        DrawButtons( Window, 1, Window_style, Window_xstyle, 4, 0 );

        // 뢠 , ᫨  ॡ.
        MoveWindowAbove( Window );

        // .
        return 1;
       }
      // ᫨ 㪠⥫ ᯮ    " ",  ࠭  뫠 :
      else if( Selected_button == 4 )
       {
        //   .
        Selected_button = 0;
        // 㥬   ࠢ 孥 㣫 .
        DrawButtons( Window, 1, Window_style, Window_xstyle, 0, 0 );
       }

     // ᫨     :
	  if( Close_button_Rect.top != -1 )
      // ᫨ 㪠⥫  ᯮ   :
      if( Mouse_point.y >= Close_button_Rect.top  && Mouse_point.y <= Close_button_Rect.bottom + 2 &&
          Mouse_point.x >= Close_button_Rect.left && Mouse_point.x <= Close_button_Rect.right )
       {
        // ᫨  뫠  - .
        if( Selected_button == 5 ) return 1;

        //     ⮩.
        Selected_button = 5;
        DrawButtons( Window, 1, Window_style, Window_xstyle, 5, 0 );

        // 뢠 , ᫨  ॡ.
        MoveWindowAbove( Window );

        // .
        return 1;
       }
      // ᫨ 㪠⥫ ᯮ    ,  ࠭  뫠 :
      else if( Selected_button == 5 )
		 {
        //   .
        Selected_button = 0;
        // 㥬   ࠢ 孥 㣫 .
        DrawButtons( Window, 1, Window_style, Window_xstyle, 0, 0 );
       }
    }

   // .
   return 0;
  }

 //  ,  ࠬ  1 .
 if( Window_style & WS_BORDER ) if( !( Window_style & WS_THICKFRAME ) ) if( !( Window_xstyle & WS_EX_DLGMODALFRAME ) )
  {
   // ᫨  ᮢ ⨭   孥 㣫 :
   if( Window_style & WS_SYSMENU ) if( Draw_captions == 1 ) if( Draw_system_menu != 0 )
    {
     // ᫨ 㪠⥫  ᯮ  ⨭:
     if( Mouse_point.y >= Window_Rect.top + 1  && Mouse_point.y <= Window_Rect.top + yCaption - 2 &&
			Mouse_point.x >= Window_Rect.left + 1 && Mouse_point.x <= Window_Rect.left + yCaption - 2  )
      {
       //  Win-OS/2  뢠 ⮫쪮     .
       if( Message == WM_NCRBUTTONDOWN || Message == WM_NCMBUTTONDOWN || Message == WM_NCMOUSEMOVE ||
           Message == WM_NCRBUTTONDBLCLK || Message == WM_NCMBUTTONDBLCLK ) return 0;

       //  ⨭   孥 㣫 ⮩  ᮢ뢠 ࠬ .
       Selected_button = 1;
       DrawCaption( Window, 2, 0, yCaption - 2, Button_width, 1, 1 );

       // .
       return 0;
      }
     // ᫨ 㪠⥫ ᯮ   ⨭,  ࠭  뫠 :
     else if( Selected_button == 1 )
      {
       //   .
       Selected_button = 0;
       // 㥬  .
       DrawCaption( Window, 2, 0, yCaption - 2, Button_width, 0, 1 );
		}
    }

   // ᫨  ᮢ   ࠢ 孥 㣫 :
   if( Draw_buttons != 0 )
    {
     // ᫨     㢥祭 ࠧ:
     if( Max_button_Rect.top != -1 )
      // ᫨ 㪠⥫  ᯮ   㢥祭 ࠧ:
      if( Mouse_point.y >= Max_button_Rect.top - 5 && Mouse_point.y <= Max_button_Rect.bottom  - 3 &&
          Mouse_point.x >= Max_button_Rect.left + 4 && Mouse_point.x <= Max_button_Rect.right + 5 )
       {
        // ᫨  뫠  - .
        if( Selected_button == 2 ) return 1;

        //     ⮩.
        Selected_button = 2;
        DrawButtons( Window, 2, Window_style, Window_xstyle, 2, 0 );

        // 㥬 ࠬ , ᫨   㢥祭  ࠬ .
		  if( Window_Rect.top <= yScreen ) if( Paint_point_frames != 0 ) if( Window != Rolled_window ) DrawPointFrame( Window );

        // 뢠 , ᫨  ॡ.
        MoveWindowAbove( Window );

        // .
        return 1;
       }
      // ᫨ 㪠⥫ ᯮ    㢥祭 ࠧ,  ࠭  뫠 :
      else if( Selected_button == 2 )
       {
        //   .
        Selected_button = 0;
        // 㥬   ࠢ 孥 㣫 .
        DrawButtons( Window, 2, Window_style, Window_xstyle, 0, 0 );
       }

     // ᫨     㬥襭:
     if( Min_button_Rect.top != -1 )
      // ᫨ 㪠⥫  ᯮ   㬥襭:
		if( Mouse_point.y >= Min_button_Rect.top - 5  && Mouse_point.y <= Min_button_Rect.bottom - 3 &&
          Mouse_point.x >= Min_button_Rect.left + 4 && Mouse_point.x <= Min_button_Rect.right + 5 )
       {
        // ᫨  뫠  - .
        if( Selected_button == 3 ) return 1;

        //     ⮩.
        Selected_button = 3;
        DrawButtons( Window, 2, Window_style, Window_xstyle, 3, 0 );

        // 㥬 ࠬ , ᫨   㢥祭  ࠬ .
        if( Window_Rect.top <= yScreen ) if( Paint_point_frames != 0 ) if( Window != Rolled_window ) DrawPointFrame( Window );

        // 뢠 , ᫨  ॡ.
        MoveWindowAbove( Window );

        // .
        return 1;
       }
      // ᫨ 㪠⥫ ᯮ    㬥襭,  ࠭  뫠 :
		else if( Selected_button == 3 )
       {
        //   .
        Selected_button = 0;
        // 㥬   ࠢ 孥 㣫 .
        DrawButtons( Window, 2, Window_style, Window_xstyle, 0, 0 );
       }

     // ᫨     " ":
     if( Rollup_button_Rect.top != -1 )
      // ᫨ 㪠⥫   ᯮ   " ":
      if( Mouse_point.y >= Rollup_button_Rect.top - 5 && Mouse_point.y <= Rollup_button_Rect.bottom - 3 &&
          Mouse_point.x >= Rollup_button_Rect.left + 4 && Mouse_point.x <= Rollup_button_Rect.right + 5 )
       {
        // ᫨  뫠  - .
        if( Selected_button == 4 ) return 1;

        //     ⮩.
        Selected_button = 4;
        DrawButtons( Window, 2, Window_style, Window_xstyle, 4, 0 );

        // 㥬 ࠬ , ᫨   㢥祭  ࠬ .
        if( Window_Rect.top <= yScreen ) if( Paint_point_frames != 0 ) if( Window != Rolled_window ) DrawPointFrame( Window );

        // 뢠 , ᫨  ॡ.
        MoveWindowAbove( Window );

        // .
        return 1;
       }
      // ᫨ 㪠⥫ ᯮ    " ",  ࠭  뫠 :
      else if( Selected_button == 4 )
       {
        //   .
        Selected_button = 0;
        // 㥬   ࠢ 孥 㣫 .
        DrawButtons( Window, 2, Window_style, Window_xstyle, 0, 0 );
       }

     // ᫨     :
	  if( Close_button_Rect.top != -1 )
      // ᫨ 㪠⥫  ᯮ   :
      if( Mouse_point.y >= Close_button_Rect.top - 5 && Mouse_point.y <= Close_button_Rect.bottom - 3 &&
          Mouse_point.x >= Close_button_Rect.left + 4 && Mouse_point.x <= Close_button_Rect.right + 5 )
       {
        // ᫨  뫠  - .
        if( Selected_button == 5 ) return 1;

        //     ⮩.
        Selected_button = 5;
        DrawButtons( Window, 2, Window_style, Window_xstyle, 5, 0 );

        // 㥬 ࠬ , ᫨   㢥祭  ࠬ .
        if( Window_Rect.top <= yScreen ) if( Paint_point_frames != 0 ) if( Window != Rolled_window ) DrawPointFrame( Window );

        // 뢠 , ᫨  ॡ.
        MoveWindowAbove( Window );

        // .
        return 1;
		 }
      // ᫨ 㪠⥫ ᯮ    ,  ࠭  뫠 :
      else if( Selected_button == 5 )
       {
        //   .
        Selected_button = 0;
        // 㥬   ࠢ 孥 㣫 .
        DrawButtons( Window, 2, Window_style, Window_xstyle, 0, 0 );
       }
    }

   // .
   return 0;
  }

 //   ﭭ ࠧ:
 if( Window_xstyle & WS_EX_DLGMODALFRAME )
  {
   // ᫨  ᮢ ⨭   孥 㣫 :
   if( Window_style & WS_SYSMENU ) if( Draw_captions == 1 ) if( Draw_system_menu != 0 )
	 {
     // ᫨ 㪠⥫  ᯮ  ⨭:
     if( Mouse_point.y >= Window_Rect.top + yConstFrame  && Mouse_point.y <= Window_Rect.top + yConstFrame + yCaption - 3 &&
         Mouse_point.x >= Window_Rect.left + xConstFrame && Mouse_point.x <= Window_Rect.left + xConstFrame + yCaption - 3 )
      {
       //  Win-OS/2  뢠 ⮫쪮     .
       if( Message == WM_NCRBUTTONDOWN || Message == WM_NCMBUTTONDOWN || Message == WM_NCMOUSEMOVE ||
           Message == WM_NCRBUTTONDBLCLK || Message == WM_NCMBUTTONDBLCLK ) return 0;

       //  ⨭   孥 㣫 ⮩  ᮢ뢠 ࠬ .
       Selected_button = 1;
       DrawCaption( Window, 3, 0, yCaption - 2, Button_width, 1, 1 );

       // .
       return 0;
      }
     // ᫨ 㪠⥫ ᯮ   ⨭,  ࠭  뫠 :
     else if( Selected_button == 1 )
      {
       //   .
		 Selected_button = 0;
       // 㥬  .
       DrawCaption( Window, 3, 0, yCaption - 2, Button_width, 0, 1 );
      }
    }

   // ᫨  ᮢ   ࠢ 孥 㣫 :
   if( Draw_buttons != 0 )
    {
     // ᫨     㢥祭 ࠧ:
     if( Max_button_Rect.top != -1 )
      // ᫨ 㪠⥫  ᯮ   㢥祭 ࠧ:
      if( Mouse_point.y >= Max_button_Rect.top + 1  && Mouse_point.y <= Max_button_Rect.bottom + 1 &&
          Mouse_point.x >= Max_button_Rect.left - 1 && Mouse_point.x <= Max_button_Rect.right - 1 )
       {
        // ᫨  뫠  - .
        if( Selected_button == 2 ) return 1;

        //     ⮩.
        Selected_button = 2;
		  DrawButtons( Window, 3, Window_style, Window_xstyle, 2, 0 );

        // 뢠 , ᫨  ॡ.
        MoveWindowAbove( Window );

        // .
        return 1;
       }
      // ᫨ 㪠⥫ ᯮ    㢥祭 ࠧ,  ࠭  뫠 :
      else if( Selected_button == 2 )
       {
        //   .
        Selected_button = 0;
        // 㥬   ࠢ 孥 㣫 .
        DrawButtons( Window, 3, Window_style, Window_xstyle, 0, 0 );
       }

     // ᫨     㬥襭:
     if( Min_button_Rect.top != -1 )
      // ᫨ 㪠⥫  ᯮ   㬥襭:
		if( Mouse_point.y >= Min_button_Rect.top + 1  && Mouse_point.y <= Min_button_Rect.bottom + 1 &&
          Mouse_point.x >= Min_button_Rect.left - 1 && Mouse_point.x <= Min_button_Rect.right - 1 )
       {
        // ᫨  뫠  - .
        if( Selected_button == 3 ) return 1;

        //     ⮩.
        Selected_button = 3;
        DrawButtons( Window, 3, Window_style, Window_xstyle, 3, 0 );

        // 뢠 , ᫨  ॡ.
        MoveWindowAbove( Window );

        // .
        return 1;
       }
      // ᫨ 㪠⥫ ᯮ    㬥襭,  ࠭  뫠 :
      else if( Selected_button == 3 )
       {
        //   .
		  Selected_button = 0;
        // 㥬   ࠢ 孥 㣫 .
        DrawButtons( Window, 3, Window_style, Window_xstyle, 0, 0 );
       }

     // ᫨     " ":
     if( Rollup_button_Rect.top != -1 )
      // ᫨ 㪠⥫   ᯮ   " ":
      if( Mouse_point.y >= Rollup_button_Rect.top + 1  && Mouse_point.y <= Rollup_button_Rect.bottom + 1 &&
          Mouse_point.x >= Rollup_button_Rect.left - 1 && Mouse_point.x <= Rollup_button_Rect.right - 1 )
       {
        // ᫨  뫠  - .
        if( Selected_button == 4 ) return 1;

        //     ⮩.
        Selected_button = 4;
        DrawButtons( Window, 3, Window_style, Window_xstyle, 4, 0 );

        // 뢠 , ᫨  ॡ.
        MoveWindowAbove( Window );

        // .
        return 1;
       }
      // ᫨ 㪠⥫ ᯮ    " ",  ࠭  뫠 :
      else if( Selected_button == 4 )
       {
        //   .
        Selected_button = 0;
        // 㥬   ࠢ 孥 㣫 .
        DrawButtons( Window, 3, Window_style, Window_xstyle, 0, 0 );
       }

     // ᫨     :
     if( Close_button_Rect.top != -1 )
      // ᫨ 㪠⥫  ᯮ   :
      if( Mouse_point.y >= Close_button_Rect.top + 1  && Mouse_point.y <= Close_button_Rect.bottom + 1 &&
          Mouse_point.x >= Close_button_Rect.left - 1 && Mouse_point.x <= Close_button_Rect.right - 1 )
       {
        // ᫨  뫠  - .
		  if( Selected_button == 5 ) return 1;

        //     ⮩.
        Selected_button = 5;
        DrawButtons( Window, 3, Window_style, Window_xstyle, 5, 0 );

        // 뢠 , ᫨  ॡ.
        MoveWindowAbove( Window );

        // .
        return 1;
       }
      // ᫨ 㪠⥫ ᯮ    ,  ࠭  뫠 :
      else if( Selected_button == 5 )
       {
        //   .
        Selected_button = 0;
        // 㥬   ࠢ 孥 㣫 .
        DrawButtons( Window, 3, Window_style, Window_xstyle, 0, 0 );
       }
	 }

   // .
   return 0;
  }

 // .
 return 0;
}
#endif

// --- 믮 ⢨  ⨨     . ---

#ifndef ACTION_IS_REPLACED
// Window । ,  ஬  ᮢ .
VOID Action( HWND Window, BYTE Button )
{
 // ᫨   - .
 if( !IsWindow( Window ) ) return;

 // ਬ,   ,  믮塞 । ⢨.
 switch( Button )
  {
   // ᫨   㢥祭:
   case 2:
    // ᫨  㢥祭 - ⠭  ࠧ.
    if( IsZoomed( Window ) ) PostMessage( Window, WM_SYSCOMMAND, SC_RESTORE, 0 );
    //  - 㢥稢 .
    else PostMessage( Window, WM_SYSCOMMAND, SC_MAXIMIZE, 0 );
   break;

   // ᫨   㬥襭:
   case 3:
    // 蠥   箪.
    PostMessage( Window, WM_SYSCOMMAND, SC_MINIMIZE, 0 );
   break;

   // ᫨   " ":
   case 4:
    // ᫨   ࠭ :
	 if( Window != Rolled_window )
     {
      // ᫨  㣮 , ஥ ࠭ :
      if( Rolled_window != NULL ) if( IsWindow( Rolled_window ) ) if( IsZoomed( Rolled_window ) )
       {
        //  .
        HWND BigWhiteBear = Rolled_window;
        // 頥   筮 ﭨ.
        UnrollWindow();
        // 蠥   箪. 饭 ।  ,  १ ।.
        SendMessage( BigWhiteBear, WM_SYSCOMMAND, SC_MINIMIZE, 0 );
       }

      //  ࠧ .
      GetWindowRect( Window, &Rolled_window_Rect );
      // Rolled_window_Rect.right ᮤন ਭ , Rolled_window_Rect.bottom - .
      Rolled_window_Rect.right = Rolled_window_Rect.right - Rolled_window_Rect.left;
      Rolled_window_Rect.bottom = Rolled_window_Rect.bottom - Rolled_window_Rect.top;

      // ,  ࠬ  .
		LONG Window_style = GetWindowLong( Window, GWL_STYLE );
      LONG Window_xstyle = GetWindowLong( Window, GWL_EXSTYLE );

      // ᫨  筮 :
      if( !( Window_xstyle & WS_EX_DLGMODALFRAME ) ) if( Window_style & WS_THICKFRAME )
       // ᫨    ࠭:
       if( Rolled_window_Rect.top < 0 ) MoveWindow( Window, Rolled_window_Rect.left + xNormalFrame, Rolled_window_Rect.top + yNormalFrame, Rolled_window_Rect.right - xNormalFrame * 2, yCaption + yNormalFrame + 3, 1 );
       //  ᫨  ࠭    맮 ਫ:
       else MoveWindow( Window, Rolled_window_Rect.left + xNormalFrame - 1, Rolled_window_Rect.top, Rolled_window_Rect.right - xNormalFrame * 2 + 2, yCaption + yNormalFrame + 3, 1 );

      // ᫨   ࠬ  1 :
      if( Window_style & WS_BORDER ) if( !( Window_style & WS_THICKFRAME ) ) if( !( Window_xstyle & WS_EX_DLGMODALFRAME ) )
       // ᫨    ࠭:
       if( Rolled_window_Rect.top < 0 ) MoveWindow( Window, Rolled_window_Rect.left + 1, Rolled_window_Rect.top + 1, Rolled_window_Rect.right - 2, yCaption, 1 );
       //  ᫨  ࠭    맮 ਫ:
       else MoveWindow( Window, Rolled_window_Rect.left + 1, Rolled_window_Rect.top, Rolled_window_Rect.right - 2, yCaption, 1 );

      // ᫨   ﭭ ࠧ:
      if( Window_xstyle & WS_EX_DLGMODALFRAME )
       MoveWindow( Window, Rolled_window_Rect.left, Rolled_window_Rect.top, Rolled_window_Rect.right, yCaption + yConstFrame + 4, 1 );

      //  .
      Rolled_window = Window;

      //  ࠧ ࠭.
      xScreen = GetSystemMetrics( SM_CXSCREEN ); yScreen = GetSystemMetrics( SM_CYSCREEN );
      POINT Center_of_screen = { 0, 0 }; Center_of_screen.x = xScreen / 2; Center_of_screen.y = yScreen / 2;
      //  , ஥ ᯮ  । ࠭.
      HWND Next_window = WindowFromPoint( Center_of_screen );
      // ᫨    ,  ४  த⥫᪮ .
      BYTE Switching = 0;

      //   .
      Window_style = GetWindowLong( Next_window, GWL_STYLE );
      Window_xstyle = GetWindowLong( Next_window, GWL_EXSTYLE );
      // ᫨  ᯮ  㣮     :
      if( Window_style & WS_CHILD ) if( !( Window_xstyle & WS_EX_DLGMODALFRAME ) )
       {
        // ॡ ४祭  த⥫᪮ .
        if( !( Window_style & WS_DLGFRAME ) ) Switching = 1;
		  if( Window_style & WS_DLGFRAME ) if( !( Window_style & WS_BORDER ) ) Switching = 1;
       }

      // ᫨ ந室 ४祭  த⥫᪮ :
      if( Switching == 1 )
       {
        //  த⥫᪮ .
        Next_window = GetParent( Next_window );
        //  ࠧ 㧭  .
        Window_style = GetWindowLong( Next_window, GWL_STYLE );
        Window_xstyle = GetWindowLong( Next_window, GWL_EXSTYLE );
        // ᫨  ᯮ  㣮     :
        if( Window_style & WS_CHILD ) if( !( Window_xstyle & WS_EX_DLGMODALFRAME ) )
         {
          // ॡ ४祭  த⥫᪮ .
          if( !( Window_style & WS_DLGFRAME ) ) Switching = 2;
          if( Window_style & WS_DLGFRAME ) if( !( Window_style & WS_BORDER ) ) Switching = 2;
         }
       }

		// ᫨ ந室 ୮ ४祭  த⥫᪮ :
      if( Switching == 2 )
       {
        //  த⥫᪮ .
        Next_window = GetParent( Next_window );
        //  ࠧ 㧭  .
        Window_style = GetWindowLong( Next_window, GWL_STYLE );
        Window_xstyle = GetWindowLong( Next_window, GWL_EXSTYLE );
        // ᫨  ᯮ  㣮     :
        if( Window_style & WS_CHILD ) if( !( Window_xstyle & WS_EX_DLGMODALFRAME ) )
         {
          //   .
          if( !( Window_style & WS_DLGFRAME ) ) Next_window = NULL;
          if( Window_style & WS_DLGFRAME ) if( !( Window_style & WS_BORDER ) ) Next_window = NULL;
         }
       }

      //    ਫ.
      HWND Main_window = GetMainWindow( Next_window );
      //   ⠭ ࠭.
		if( Main_window != Next_window ) SetActiveWindow( Main_window );
      //  ⠭ ࠭.
      SetActiveWindow( Next_window );
     }
    // ᫨  ࠭  - 頥   筮 ﭨ.
    else UnrollWindow();
   break;

   // ᫨   :
   case 5:
    //   .
    LONG Window_style = GetWindowLong( Window, GWL_STYLE );

    // ᫨  ᯮ  㣮 :
    if( Window_style & WS_CHILD ) PostMessage( Window, WM_SYSCOMMAND, SC_CLOSE, 0 );
    //  ᫨    ࠭  ᯨ᪥ :
    else PostMessage( Window, WM_CLOSE, 0, 0 );
   break;
  }

 // .
 return;
}
#endif

// --- 頥  筮 ﭨ , ஥ ࠭ . ---

#ifndef UNROLL_WINDOW_IS_REPLACED
//  । ६ Rolled_window.
VOID UnrollWindow( VOID )
{
 // 頥   筮 ﭨ.
 MoveWindow( Rolled_window, Rolled_window_Rect.left, Rolled_window_Rect.top, Rolled_window_Rect.right, Rolled_window_Rect.bottom, 1 );

 // 뢠 ६,  । .
 Rolled_window = NULL;

 // .
 return;
}
#endif

// --- 뢠  . ---

#ifndef MOVE_WINDOW_ABOVE_IS_REPLACED
// Window । , ஥  맢.
VOID MoveWindowAbove( HWND Window )
{
 // ᫨   ࠭:
 if( !IsActive( Window ) )
  {
   //    ਫ.
   HWND Main_window = GetMainWindow( Window );
   //   ਫ ⠭ ࠭.
   if( Main_window != Window ) SetActiveWindow( Main_window );
   //  ⠭ ࠭.
   SetActiveWindow( Window );
  }

 // .
 return;
}
#endif

// ---    ਫ. ---

#ifndef GET_MAIN_WINDOW_IS_REPLACED
// Window ।    ਫ.
HWND GetMainWindow( HWND Window )
{
 // ᫨   㪠 - .
 if( Window == NULL ) return NULL;

 //  த⥫᪮ .
 HWND Parent_window = GetParent( Window );
 // ᫨ த⥫᪮   -   .
 if( Parent_window == NULL ) return Window;

 // ᬠਢ  த⥫᪨ .
 HWND Next_window = NULL;
 // ᬠਢ .
 while( 1 )
  {
   //  ᫥饥 த⥫᪮ .
   Next_window = GetParent( Parent_window );
   // ᫨   - த ॡ .
   if( Next_window != NULL ) Parent_window = Next_window;
   //  ᫨   -   .
   else break;
  }

 // .
 return Parent_window;
}
#endif

// ---  㪠⥫   . ---

#ifndef CHANGE_MOUSE_POINTER_IS_REPLACED
VOID ChangeMousePointer( VOID )
{
 // ਬ,  㪠⥫ ,  ⠢ .
 HCURSOR Current_cursor = GetCursor();
 if( Current_cursor == Old_cursor_0 ) SetCursor( New_cursor_0 );
 else if( Current_cursor == Old_cursor_1 ) SetCursor( New_cursor_1 );
 else if( Current_cursor == Old_cursor_2 ) SetCursor( New_cursor_2 );
 else if( Current_cursor == Old_cursor_3 ) SetCursor( New_cursor_3 );
 else if( Current_cursor == Old_cursor_4 ) SetCursor( New_cursor_4 );
 else if( Current_cursor == Old_cursor_5 ) SetCursor( New_cursor_5 );
 else if( Current_cursor == Old_cursor_6 ) SetCursor( New_cursor_6 );
 else if( Current_cursor == Old_cursor_7 ) SetCursor( New_cursor_7 );
 else if( Current_cursor == Old_cursor_8 ) SetCursor( New_cursor_8 );
 else if( Current_cursor == Old_cursor_9 ) SetCursor( New_cursor_9 );
 else if( Current_cursor == Old_cursor_A ) SetCursor( New_cursor_A );

 // .
 return;
}
#endif

// ---   ⨨  . ---

#ifndef KEY_CLICK_IS_REPLACED
VOID KeyClick( WPARAM Key, LPARAM Info )
{
 // Alt  뢠, ᫨ 祭 Scroll Lock.
 if( Key == VK_MENU ) if( GetKeyState( VK_SCROLL ) != 0 ) return;
 //    ⮫쪮  . ਬ,  ⠭   Info.
 if( HIWORD( Info ) < 0x4000 ) MessageBeep( 0 );
 // .
 return;
}
#endif

// --- 砥/몫砥 Num Lock. ---

#ifndef SET_NUM_LOCK_IS_REPLACED
VOID SetNumLock( VOID )
{
 //  ﭨ .
 BYTE Keyboard_state[ 256 ]; GetKeyboardState( (LPBYTE) Keyboard_state );

 switch( Num_Lock )
  {
   case 1:
    // 砥 Num Lock.
    Keyboard_state[ VK_NUMLOCK ] = 1;
   break;
   case 2:
    // 몫砥 Num Lock.
    Keyboard_state[ VK_NUMLOCK ] = 0;
   break;
  }

 // ⠭  ﭨ .
 SetKeyboardState( (LPBYTE) Keyboard_state );

 // .
 return;
}
#endif
