/*
 * LFNCall V 1.7
 *
 * This script copies the original file to the temp file or moves it to
 * the root of the drive, then it can be edited, when finished it copies
 * or moves it the original location
 * (c) 1997-2001 Thomas Bohn, Vogelwiese 65, D-18435 Stralsund, Germany
 *
 */

call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'

'@Echo off'
'cls'
say''
say'     Ŀ'
say'                                  LFNCall V 1.7                         '
say'                           (c) Thomas Bohn 1997-2001                    '
say'                        longname file copy/move program                 '
say'     '
say''

parse arg Command Par
if Par=="" then exit
nLPos=lastpos(' ',Par)
nTPos=lastpos('\',Par)
if substr(Par,1,1) <> '"' then OrgFile='"'left(Par,nLPos-1)'"'
else OrgFile=left(Par,nLPos-1)
nOPos1=pos('\',OrgFile)
RootFile=substr(Par,nLPos+3)
TmpPath=value('TMP',,'OS2ENVIRONMENT')
TmpFile=TmpPath||substr(Par,nTPos)
nEPos=lastpos('.',RootFile)-1
EAreadfile=substr(OrgFile,2,length(OrgFile)-2)
EAfile=substr(EAreadfile,1,2)||substr(Rootfile,1,nEPos)'.EAI'
AppBkFile=substr(EAreadfile,1,2)||substr(Rootfile,1,nEPos)'.BAK'
BackFile=substr(Par,nLPos+1)
OrgDirFile='"'substr(OrgFile,nOPos1)
EAputfile=substr(OrgFile,2,length(OrgFile)-2)
DumFile=OrgFile

SELECT
 WHEN Command=='/KC' then do
   say "Copying file with long name to temp. directory..." 
   rc = SysGetEA(EAreadfile, ".LONGNAME", "langname")
   if rc = 0 then do
     call SysIni EAfile, 'LFNCALL', '.LONGNAME', langname
   end
   Copy OrgFile TmpFile
 END
 WHEN Command=='/KM' then do
   say "Moving file with long name for editing to the root..." 
   rc = SysGetEA(EAreadfile, ".LONGNAME", "langname")
   if rc = 0 then do
     call SysIni EAfile, 'LFNCALL', '.LONGNAME', langname
   end
   Move OrgFile RootFile
   'copy D:\Windows\lfndum.txt' DumFile
 END
 WHEN Command=='/LC' then do
   Dir1='lfndir1.dat'
   Dir2='lfndir2.dat'
   'dir /N' OrgFile '>'Dir1
   'dir /N' TmpFile '>'Dir2
   Line1= LineIn(Dir1,1,1)
   Line1= LineIn(Dir1,,1)
   Line1= LineIn(Dir1,,1)
   Line1= LineIn(Dir1,,1)
   Line1= LineIn(Dir1,,1)
   if substr(Line1,1,1) == " " then Line1= LineIn(Dir1,,1)
   call stream Dir1, "C", "CLOSE"
   Line2= LineIn(Dir2,1,1)
   Line2= LineIn(Dir2,,1)
   Line2= LineIn(Dir2,,1)
   Line2= LineIn(Dir2,,1)
   Line2= LineIn(Dir2,,1)
   Line2= LineIn(Dir2,,1)
   call stream Dir2, "C", "CLOSE"
   if substr(Line1,1,26) <> substr(Line2,1,26) then do
      say "Copying changed to original position..."
      Copy TmpFile OrgFile
      call SysFileTree OrgFile 'Test', 'T'
      if (Test.0<>0) then do
	call SysFileDelete TmpFile
	call SysFileTree EAfile, 'ea', 'F'
	if ea.0 > 0 then do
     	  langname = SysIni(EAfile, 'LFNCALL', '.LONGNAME')
          call SysPutEA EAputfile, ".LONGNAME", langname
          call SysFileDelete EAfile
          call SysFileDelete AppBkFile
        end
      end	
   end
   else do
        say "file unchanged - no action."
	call SysFileDelete TmpFile
        call SysFileDelete EAfile
   end
   del Dir1
   del Dir2
 END
 WHEN Command=='/LM' then do
   say "Moving file to original position..."
   'del ' DumFile
   call SysFileTree EAfile, 'ea', 'F'
   Move BackFile OrgDirFile
   if ea.0 > 0 then do
     langname = SysIni(EAfile, 'LFNCALL', '.LONGNAME')
     call SysPutEA EAputfile, ".LONGNAME", langname
     call SysFileDelete EAfile
     call SysFileDelete AppBkFile
   end
 END
end
exit
