
/*
 *
 *
 */

/*
 *@@ UNICASEFOLD:
 *      one case folding entry.
 *
 *      Generated from
 *
 +      http://www.unicode.org/Public/3.2-Update/CaseFolding-3.2.0.txt
 *
 *@@added V0.9.20 (2002-07-03) [umoeller]
 */

typedef struct _UNICASEFOLD
{
    unsigned long   ulLow;

    unsigned long   fl;
        #define CASEFL_C        0x0100
            // C: common case folding, common mappings shared by both simple
            // and full mappings
        #define CASEFL_F        0x0200
            // F: full case folding, mappings that cause strings to grow in
            // length. Multiple characters are separated by spaces.
        #define CASEFL_S        0x0400
            // S: simple case folding, mappings to single characters where
            // different from F.
        #define CASEFL_T        0x0800
            // T: special case for uppercase I and dotted uppercase I:
            // - For non-Turkic languages, this mapping is normally not used.
            // - For Turkic languages (tr, az), this mapping can be used
            //   instead of the normal mapping for these characters.

        #define CASEFL_FLAGMASK 0xFF00
        #define CASEFL_BYTECNT  0x00FF

    unsigned long   c1,
                    c2,
                    c3;

} UNICASEFOLD, *PUNICASEFOLD;

UNICASEFOLD G_aCaseFolds[] =
{
{ 0x0041, CASEFL_C | 1, 0x0061, 0, 0 }, // LATIN CAPITAL LETTER A
{ 0x0042, CASEFL_C | 1, 0x0062, 0, 0 }, // LATIN CAPITAL LETTER B
{ 0x0043, CASEFL_C | 1, 0x0063, 0, 0 }, // LATIN CAPITAL LETTER C
{ 0x0044, CASEFL_C | 1, 0x0064, 0, 0 }, // LATIN CAPITAL LETTER D
{ 0x0045, CASEFL_C | 1, 0x0065, 0, 0 }, // LATIN CAPITAL LETTER E
{ 0x0046, CASEFL_C | 1, 0x0066, 0, 0 }, // LATIN CAPITAL LETTER F
{ 0x0047, CASEFL_C | 1, 0x0067, 0, 0 }, // LATIN CAPITAL LETTER G
{ 0x0048, CASEFL_C | 1, 0x0068, 0, 0 }, // LATIN CAPITAL LETTER H
{ 0x0049, CASEFL_C | 1, 0x0069, 0, 0 }, // LATIN CAPITAL LETTER I
{ 0x0049, CASEFL_T | 1, 0x0131, 0, 0 }, // LATIN CAPITAL LETTER I
{ 0x004A, CASEFL_C | 1, 0x006A, 0, 0 }, // LATIN CAPITAL LETTER J
{ 0x004B, CASEFL_C | 1, 0x006B, 0, 0 }, // LATIN CAPITAL LETTER K
{ 0x004C, CASEFL_C | 1, 0x006C, 0, 0 }, // LATIN CAPITAL LETTER L
{ 0x004D, CASEFL_C | 1, 0x006D, 0, 0 }, // LATIN CAPITAL LETTER M
{ 0x004E, CASEFL_C | 1, 0x006E, 0, 0 }, // LATIN CAPITAL LETTER N
{ 0x004F, CASEFL_C | 1, 0x006F, 0, 0 }, // LATIN CAPITAL LETTER O
{ 0x0050, CASEFL_C | 1, 0x0070, 0, 0 }, // LATIN CAPITAL LETTER P
{ 0x0051, CASEFL_C | 1, 0x0071, 0, 0 }, // LATIN CAPITAL LETTER Q
{ 0x0052, CASEFL_C | 1, 0x0072, 0, 0 }, // LATIN CAPITAL LETTER R
{ 0x0053, CASEFL_C | 1, 0x0073, 0, 0 }, // LATIN CAPITAL LETTER S
{ 0x0054, CASEFL_C | 1, 0x0074, 0, 0 }, // LATIN CAPITAL LETTER T
{ 0x0055, CASEFL_C | 1, 0x0075, 0, 0 }, // LATIN CAPITAL LETTER U
{ 0x0056, CASEFL_C | 1, 0x0076, 0, 0 }, // LATIN CAPITAL LETTER V
{ 0x0057, CASEFL_C | 1, 0x0077, 0, 0 }, // LATIN CAPITAL LETTER W
{ 0x0058, CASEFL_C | 1, 0x0078, 0, 0 }, // LATIN CAPITAL LETTER X
{ 0x0059, CASEFL_C | 1, 0x0079, 0, 0 }, // LATIN CAPITAL LETTER Y
{ 0x005A, CASEFL_C | 1, 0x007A, 0, 0 }, // LATIN CAPITAL LETTER Z
{ 0x00B5, CASEFL_C | 1, 0x03BC, 0, 0 }, // MICRO SIGN
{ 0x00C0, CASEFL_C | 1, 0x00E0, 0, 0 }, // LATIN CAPITAL LETTER A WITH GRAVE
{ 0x00C1, CASEFL_C | 1, 0x00E1, 0, 0 }, // LATIN CAPITAL LETTER A WITH ACUTE
{ 0x00C2, CASEFL_C | 1, 0x00E2, 0, 0 }, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX
{ 0x00C3, CASEFL_C | 1, 0x00E3, 0, 0 }, // LATIN CAPITAL LETTER A WITH TILDE
{ 0x00C4, CASEFL_C | 1, 0x00E4, 0, 0 }, // LATIN CAPITAL LETTER A WITH DIAERESIS
{ 0x00C5, CASEFL_C | 1, 0x00E5, 0, 0 }, // LATIN CAPITAL LETTER A WITH RING ABOVE
{ 0x00C6, CASEFL_C | 1, 0x00E6, 0, 0 }, // LATIN CAPITAL LETTER AE
{ 0x00C7, CASEFL_C | 1, 0x00E7, 0, 0 }, // LATIN CAPITAL LETTER C WITH CEDILLA
{ 0x00C8, CASEFL_C | 1, 0x00E8, 0, 0 }, // LATIN CAPITAL LETTER E WITH GRAVE
{ 0x00C9, CASEFL_C | 1, 0x00E9, 0, 0 }, // LATIN CAPITAL LETTER E WITH ACUTE
{ 0x00CA, CASEFL_C | 1, 0x00EA, 0, 0 }, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX
{ 0x00CB, CASEFL_C | 1, 0x00EB, 0, 0 }, // LATIN CAPITAL LETTER E WITH DIAERESIS
{ 0x00CC, CASEFL_C | 1, 0x00EC, 0, 0 }, // LATIN CAPITAL LETTER I WITH GRAVE
{ 0x00CD, CASEFL_C | 1, 0x00ED, 0, 0 }, // LATIN CAPITAL LETTER I WITH ACUTE
{ 0x00CE, CASEFL_C | 1, 0x00EE, 0, 0 }, // LATIN CAPITAL LETTER I WITH CIRCUMFLEX
{ 0x00CF, CASEFL_C | 1, 0x00EF, 0, 0 }, // LATIN CAPITAL LETTER I WITH DIAERESIS
{ 0x00D0, CASEFL_C | 1, 0x00F0, 0, 0 }, // LATIN CAPITAL LETTER ETH
{ 0x00D1, CASEFL_C | 1, 0x00F1, 0, 0 }, // LATIN CAPITAL LETTER N WITH TILDE
{ 0x00D2, CASEFL_C | 1, 0x00F2, 0, 0 }, // LATIN CAPITAL LETTER O WITH GRAVE
{ 0x00D3, CASEFL_C | 1, 0x00F3, 0, 0 }, // LATIN CAPITAL LETTER O WITH ACUTE
{ 0x00D4, CASEFL_C | 1, 0x00F4, 0, 0 }, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX
{ 0x00D5, CASEFL_C | 1, 0x00F5, 0, 0 }, // LATIN CAPITAL LETTER O WITH TILDE
{ 0x00D6, CASEFL_C | 1, 0x00F6, 0, 0 }, // LATIN CAPITAL LETTER O WITH DIAERESIS
{ 0x00D8, CASEFL_C | 1, 0x00F8, 0, 0 }, // LATIN CAPITAL LETTER O WITH STROKE
{ 0x00D9, CASEFL_C | 1, 0x00F9, 0, 0 }, // LATIN CAPITAL LETTER U WITH GRAVE
{ 0x00DA, CASEFL_C | 1, 0x00FA, 0, 0 }, // LATIN CAPITAL LETTER U WITH ACUTE
{ 0x00DB, CASEFL_C | 1, 0x00FB, 0, 0 }, // LATIN CAPITAL LETTER U WITH CIRCUMFLEX
{ 0x00DC, CASEFL_C | 1, 0x00FC, 0, 0 }, // LATIN CAPITAL LETTER U WITH DIAERESIS
{ 0x00DD, CASEFL_C | 1, 0x00FD, 0, 0 }, // LATIN CAPITAL LETTER Y WITH ACUTE
{ 0x00DE, CASEFL_C | 1, 0x00FE, 0, 0 }, // LATIN CAPITAL LETTER THORN
{ 0x00DF, CASEFL_F | 2, 0x0073, 0x0073, 0 }, // LATIN SMALL LETTER SHARP S
{ 0x0100, CASEFL_C | 1, 0x0101, 0, 0 }, // LATIN CAPITAL LETTER A WITH MACRON
{ 0x0102, CASEFL_C | 1, 0x0103, 0, 0 }, // LATIN CAPITAL LETTER A WITH BREVE
{ 0x0104, CASEFL_C | 1, 0x0105, 0, 0 }, // LATIN CAPITAL LETTER A WITH OGONEK
{ 0x0106, CASEFL_C | 1, 0x0107, 0, 0 }, // LATIN CAPITAL LETTER C WITH ACUTE
{ 0x0108, CASEFL_C | 1, 0x0109, 0, 0 }, // LATIN CAPITAL LETTER C WITH CIRCUMFLEX
{ 0x010A, CASEFL_C | 1, 0x010B, 0, 0 }, // LATIN CAPITAL LETTER C WITH DOT ABOVE
{ 0x010C, CASEFL_C | 1, 0x010D, 0, 0 }, // LATIN CAPITAL LETTER C WITH CARON
{ 0x010E, CASEFL_C | 1, 0x010F, 0, 0 }, // LATIN CAPITAL LETTER D WITH CARON
{ 0x0110, CASEFL_C | 1, 0x0111, 0, 0 }, // LATIN CAPITAL LETTER D WITH STROKE
{ 0x0112, CASEFL_C | 1, 0x0113, 0, 0 }, // LATIN CAPITAL LETTER E WITH MACRON
{ 0x0114, CASEFL_C | 1, 0x0115, 0, 0 }, // LATIN CAPITAL LETTER E WITH BREVE
{ 0x0116, CASEFL_C | 1, 0x0117, 0, 0 }, // LATIN CAPITAL LETTER E WITH DOT ABOVE
{ 0x0118, CASEFL_C | 1, 0x0119, 0, 0 }, // LATIN CAPITAL LETTER E WITH OGONEK
{ 0x011A, CASEFL_C | 1, 0x011B, 0, 0 }, // LATIN CAPITAL LETTER E WITH CARON
{ 0x011C, CASEFL_C | 1, 0x011D, 0, 0 }, // LATIN CAPITAL LETTER G WITH CIRCUMFLEX
{ 0x011E, CASEFL_C | 1, 0x011F, 0, 0 }, // LATIN CAPITAL LETTER G WITH BREVE
{ 0x0120, CASEFL_C | 1, 0x0121, 0, 0 }, // LATIN CAPITAL LETTER G WITH DOT ABOVE
{ 0x0122, CASEFL_C | 1, 0x0123, 0, 0 }, // LATIN CAPITAL LETTER G WITH CEDILLA
{ 0x0124, CASEFL_C | 1, 0x0125, 0, 0 }, // LATIN CAPITAL LETTER H WITH CIRCUMFLEX
{ 0x0126, CASEFL_C | 1, 0x0127, 0, 0 }, // LATIN CAPITAL LETTER H WITH STROKE
{ 0x0128, CASEFL_C | 1, 0x0129, 0, 0 }, // LATIN CAPITAL LETTER I WITH TILDE
{ 0x012A, CASEFL_C | 1, 0x012B, 0, 0 }, // LATIN CAPITAL LETTER I WITH MACRON
{ 0x012C, CASEFL_C | 1, 0x012D, 0, 0 }, // LATIN CAPITAL LETTER I WITH BREVE
{ 0x012E, CASEFL_C | 1, 0x012F, 0, 0 }, // LATIN CAPITAL LETTER I WITH OGONEK
{ 0x0130, CASEFL_F | 2, 0x0069, 0x0307, 0 }, // LATIN CAPITAL LETTER I WITH DOT ABOVE
{ 0x0130, CASEFL_T | 1, 0x0069, 0, 0 }, // LATIN CAPITAL LETTER I WITH DOT ABOVE
{ 0x0132, CASEFL_C | 1, 0x0133, 0, 0 }, // LATIN CAPITAL LIGATURE IJ
{ 0x0134, CASEFL_C | 1, 0x0135, 0, 0 }, // LATIN CAPITAL LETTER J WITH CIRCUMFLEX
{ 0x0136, CASEFL_C | 1, 0x0137, 0, 0 }, // LATIN CAPITAL LETTER K WITH CEDILLA
{ 0x0139, CASEFL_C | 1, 0x013A, 0, 0 }, // LATIN CAPITAL LETTER L WITH ACUTE
{ 0x013B, CASEFL_C | 1, 0x013C, 0, 0 }, // LATIN CAPITAL LETTER L WITH CEDILLA
{ 0x013D, CASEFL_C | 1, 0x013E, 0, 0 }, // LATIN CAPITAL LETTER L WITH CARON
{ 0x013F, CASEFL_C | 1, 0x0140, 0, 0 }, // LATIN CAPITAL LETTER L WITH MIDDLE DOT
{ 0x0141, CASEFL_C | 1, 0x0142, 0, 0 }, // LATIN CAPITAL LETTER L WITH STROKE
{ 0x0143, CASEFL_C | 1, 0x0144, 0, 0 }, // LATIN CAPITAL LETTER N WITH ACUTE
{ 0x0145, CASEFL_C | 1, 0x0146, 0, 0 }, // LATIN CAPITAL LETTER N WITH CEDILLA
{ 0x0147, CASEFL_C | 1, 0x0148, 0, 0 }, // LATIN CAPITAL LETTER N WITH CARON
{ 0x0149, CASEFL_F | 2, 0x02BC, 0x006E, 0 }, // LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
{ 0x014A, CASEFL_C | 1, 0x014B, 0, 0 }, // LATIN CAPITAL LETTER ENG
{ 0x014C, CASEFL_C | 1, 0x014D, 0, 0 }, // LATIN CAPITAL LETTER O WITH MACRON
{ 0x014E, CASEFL_C | 1, 0x014F, 0, 0 }, // LATIN CAPITAL LETTER O WITH BREVE
{ 0x0150, CASEFL_C | 1, 0x0151, 0, 0 }, // LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
{ 0x0152, CASEFL_C | 1, 0x0153, 0, 0 }, // LATIN CAPITAL LIGATURE OE
{ 0x0154, CASEFL_C | 1, 0x0155, 0, 0 }, // LATIN CAPITAL LETTER R WITH ACUTE
{ 0x0156, CASEFL_C | 1, 0x0157, 0, 0 }, // LATIN CAPITAL LETTER R WITH CEDILLA
{ 0x0158, CASEFL_C | 1, 0x0159, 0, 0 }, // LATIN CAPITAL LETTER R WITH CARON
{ 0x015A, CASEFL_C | 1, 0x015B, 0, 0 }, // LATIN CAPITAL LETTER S WITH ACUTE
{ 0x015C, CASEFL_C | 1, 0x015D, 0, 0 }, // LATIN CAPITAL LETTER S WITH CIRCUMFLEX
{ 0x015E, CASEFL_C | 1, 0x015F, 0, 0 }, // LATIN CAPITAL LETTER S WITH CEDILLA
{ 0x0160, CASEFL_C | 1, 0x0161, 0, 0 }, // LATIN CAPITAL LETTER S WITH CARON
{ 0x0162, CASEFL_C | 1, 0x0163, 0, 0 }, // LATIN CAPITAL LETTER T WITH CEDILLA
{ 0x0164, CASEFL_C | 1, 0x0165, 0, 0 }, // LATIN CAPITAL LETTER T WITH CARON
{ 0x0166, CASEFL_C | 1, 0x0167, 0, 0 }, // LATIN CAPITAL LETTER T WITH STROKE
{ 0x0168, CASEFL_C | 1, 0x0169, 0, 0 }, // LATIN CAPITAL LETTER U WITH TILDE
{ 0x016A, CASEFL_C | 1, 0x016B, 0, 0 }, // LATIN CAPITAL LETTER U WITH MACRON
{ 0x016C, CASEFL_C | 1, 0x016D, 0, 0 }, // LATIN CAPITAL LETTER U WITH BREVE
{ 0x016E, CASEFL_C | 1, 0x016F, 0, 0 }, // LATIN CAPITAL LETTER U WITH RING ABOVE
{ 0x0170, CASEFL_C | 1, 0x0171, 0, 0 }, // LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
{ 0x0172, CASEFL_C | 1, 0x0173, 0, 0 }, // LATIN CAPITAL LETTER U WITH OGONEK
{ 0x0174, CASEFL_C | 1, 0x0175, 0, 0 }, // LATIN CAPITAL LETTER W WITH CIRCUMFLEX
{ 0x0176, CASEFL_C | 1, 0x0177, 0, 0 }, // LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
{ 0x0178, CASEFL_C | 1, 0x00FF, 0, 0 }, // LATIN CAPITAL LETTER Y WITH DIAERESIS
{ 0x0179, CASEFL_C | 1, 0x017A, 0, 0 }, // LATIN CAPITAL LETTER Z WITH ACUTE
{ 0x017B, CASEFL_C | 1, 0x017C, 0, 0 }, // LATIN CAPITAL LETTER Z WITH DOT ABOVE
{ 0x017D, CASEFL_C | 1, 0x017E, 0, 0 }, // LATIN CAPITAL LETTER Z WITH CARON
{ 0x017F, CASEFL_C | 1, 0x0073, 0, 0 }, // LATIN SMALL LETTER LONG S
{ 0x0181, CASEFL_C | 1, 0x0253, 0, 0 }, // LATIN CAPITAL LETTER B WITH HOOK
{ 0x0182, CASEFL_C | 1, 0x0183, 0, 0 }, // LATIN CAPITAL LETTER B WITH TOPBAR
{ 0x0184, CASEFL_C | 1, 0x0185, 0, 0 }, // LATIN CAPITAL LETTER TONE SIX
{ 0x0186, CASEFL_C | 1, 0x0254, 0, 0 }, // LATIN CAPITAL LETTER OPEN O
{ 0x0187, CASEFL_C | 1, 0x0188, 0, 0 }, // LATIN CAPITAL LETTER C WITH HOOK
{ 0x0189, CASEFL_C | 1, 0x0256, 0, 0 }, // LATIN CAPITAL LETTER AFRICAN D
{ 0x018A, CASEFL_C | 1, 0x0257, 0, 0 }, // LATIN CAPITAL LETTER D WITH HOOK
{ 0x018B, CASEFL_C | 1, 0x018C, 0, 0 }, // LATIN CAPITAL LETTER D WITH TOPBAR
{ 0x018E, CASEFL_C | 1, 0x01DD, 0, 0 }, // LATIN CAPITAL LETTER REVERSED E
{ 0x018F, CASEFL_C | 1, 0x0259, 0, 0 }, // LATIN CAPITAL LETTER SCHWA
{ 0x0190, CASEFL_C | 1, 0x025B, 0, 0 }, // LATIN CAPITAL LETTER OPEN E
{ 0x0191, CASEFL_C | 1, 0x0192, 0, 0 }, // LATIN CAPITAL LETTER F WITH HOOK
{ 0x0193, CASEFL_C | 1, 0x0260, 0, 0 }, // LATIN CAPITAL LETTER G WITH HOOK
{ 0x0194, CASEFL_C | 1, 0x0263, 0, 0 }, // LATIN CAPITAL LETTER GAMMA
{ 0x0196, CASEFL_C | 1, 0x0269, 0, 0 }, // LATIN CAPITAL LETTER IOTA
{ 0x0197, CASEFL_C | 1, 0x0268, 0, 0 }, // LATIN CAPITAL LETTER I WITH STROKE
{ 0x0198, CASEFL_C | 1, 0x0199, 0, 0 }, // LATIN CAPITAL LETTER K WITH HOOK
{ 0x019C, CASEFL_C | 1, 0x026F, 0, 0 }, // LATIN CAPITAL LETTER TURNED M
{ 0x019D, CASEFL_C | 1, 0x0272, 0, 0 }, // LATIN CAPITAL LETTER N WITH LEFT HOOK
{ 0x019F, CASEFL_C | 1, 0x0275, 0, 0 }, // LATIN CAPITAL LETTER O WITH MIDDLE TILDE
{ 0x01A0, CASEFL_C | 1, 0x01A1, 0, 0 }, // LATIN CAPITAL LETTER O WITH HORN
{ 0x01A2, CASEFL_C | 1, 0x01A3, 0, 0 }, // LATIN CAPITAL LETTER OI
{ 0x01A4, CASEFL_C | 1, 0x01A5, 0, 0 }, // LATIN CAPITAL LETTER P WITH HOOK
{ 0x01A6, CASEFL_C | 1, 0x0280, 0, 0 }, // LATIN LETTER YR
{ 0x01A7, CASEFL_C | 1, 0x01A8, 0, 0 }, // LATIN CAPITAL LETTER TONE TWO
{ 0x01A9, CASEFL_C | 1, 0x0283, 0, 0 }, // LATIN CAPITAL LETTER ESH
{ 0x01AC, CASEFL_C | 1, 0x01AD, 0, 0 }, // LATIN CAPITAL LETTER T WITH HOOK
{ 0x01AE, CASEFL_C | 1, 0x0288, 0, 0 }, // LATIN CAPITAL LETTER T WITH RETROFLEX HOOK
{ 0x01AF, CASEFL_C | 1, 0x01B0, 0, 0 }, // LATIN CAPITAL LETTER U WITH HORN
{ 0x01B1, CASEFL_C | 1, 0x028A, 0, 0 }, // LATIN CAPITAL LETTER UPSILON
{ 0x01B2, CASEFL_C | 1, 0x028B, 0, 0 }, // LATIN CAPITAL LETTER V WITH HOOK
{ 0x01B3, CASEFL_C | 1, 0x01B4, 0, 0 }, // LATIN CAPITAL LETTER Y WITH HOOK
{ 0x01B5, CASEFL_C | 1, 0x01B6, 0, 0 }, // LATIN CAPITAL LETTER Z WITH STROKE
{ 0x01B7, CASEFL_C | 1, 0x0292, 0, 0 }, // LATIN CAPITAL LETTER EZH
{ 0x01B8, CASEFL_C | 1, 0x01B9, 0, 0 }, // LATIN CAPITAL LETTER EZH REVERSED
{ 0x01BC, CASEFL_C | 1, 0x01BD, 0, 0 }, // LATIN CAPITAL LETTER TONE FIVE
{ 0x01C4, CASEFL_C | 1, 0x01C6, 0, 0 }, // LATIN CAPITAL LETTER DZ WITH CARON
{ 0x01C5, CASEFL_C | 1, 0x01C6, 0, 0 }, // LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON
{ 0x01C7, CASEFL_C | 1, 0x01C9, 0, 0 }, // LATIN CAPITAL LETTER LJ
{ 0x01C8, CASEFL_C | 1, 0x01C9, 0, 0 }, // LATIN CAPITAL LETTER L WITH SMALL LETTER J
{ 0x01CA, CASEFL_C | 1, 0x01CC, 0, 0 }, // LATIN CAPITAL LETTER NJ
{ 0x01CB, CASEFL_C | 1, 0x01CC, 0, 0 }, // LATIN CAPITAL LETTER N WITH SMALL LETTER J
{ 0x01CD, CASEFL_C | 1, 0x01CE, 0, 0 }, // LATIN CAPITAL LETTER A WITH CARON
{ 0x01CF, CASEFL_C | 1, 0x01D0, 0, 0 }, // LATIN CAPITAL LETTER I WITH CARON
{ 0x01D1, CASEFL_C | 1, 0x01D2, 0, 0 }, // LATIN CAPITAL LETTER O WITH CARON
{ 0x01D3, CASEFL_C | 1, 0x01D4, 0, 0 }, // LATIN CAPITAL LETTER U WITH CARON
{ 0x01D5, CASEFL_C | 1, 0x01D6, 0, 0 }, // LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
{ 0x01D7, CASEFL_C | 1, 0x01D8, 0, 0 }, // LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
{ 0x01D9, CASEFL_C | 1, 0x01DA, 0, 0 }, // LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
{ 0x01DB, CASEFL_C | 1, 0x01DC, 0, 0 }, // LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
{ 0x01DE, CASEFL_C | 1, 0x01DF, 0, 0 }, // LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON
{ 0x01E0, CASEFL_C | 1, 0x01E1, 0, 0 }, // LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON
{ 0x01E2, CASEFL_C | 1, 0x01E3, 0, 0 }, // LATIN CAPITAL LETTER AE WITH MACRON
{ 0x01E4, CASEFL_C | 1, 0x01E5, 0, 0 }, // LATIN CAPITAL LETTER G WITH STROKE
{ 0x01E6, CASEFL_C | 1, 0x01E7, 0, 0 }, // LATIN CAPITAL LETTER G WITH CARON
{ 0x01E8, CASEFL_C | 1, 0x01E9, 0, 0 }, // LATIN CAPITAL LETTER K WITH CARON
{ 0x01EA, CASEFL_C | 1, 0x01EB, 0, 0 }, // LATIN CAPITAL LETTER O WITH OGONEK
{ 0x01EC, CASEFL_C | 1, 0x01ED, 0, 0 }, // LATIN CAPITAL LETTER O WITH OGONEK AND MACRON
{ 0x01EE, CASEFL_C | 1, 0x01EF, 0, 0 }, // LATIN CAPITAL LETTER EZH WITH CARON
{ 0x01F0, CASEFL_F | 2, 0x006A, 0x030C, 0 }, // LATIN SMALL LETTER J WITH CARON
{ 0x01F1, CASEFL_C | 1, 0x01F3, 0, 0 }, // LATIN CAPITAL LETTER DZ
{ 0x01F2, CASEFL_C | 1, 0x01F3, 0, 0 }, // LATIN CAPITAL LETTER D WITH SMALL LETTER Z
{ 0x01F4, CASEFL_C | 1, 0x01F5, 0, 0 }, // LATIN CAPITAL LETTER G WITH ACUTE
{ 0x01F6, CASEFL_C | 1, 0x0195, 0, 0 }, // LATIN CAPITAL LETTER HWAIR
{ 0x01F7, CASEFL_C | 1, 0x01BF, 0, 0 }, // LATIN CAPITAL LETTER WYNN
{ 0x01F8, CASEFL_C | 1, 0x01F9, 0, 0 }, // LATIN CAPITAL LETTER N WITH GRAVE
{ 0x01FA, CASEFL_C | 1, 0x01FB, 0, 0 }, // LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE
{ 0x01FC, CASEFL_C | 1, 0x01FD, 0, 0 }, // LATIN CAPITAL LETTER AE WITH ACUTE
{ 0x01FE, CASEFL_C | 1, 0x01FF, 0, 0 }, // LATIN CAPITAL LETTER O WITH STROKE AND ACUTE
{ 0x0200, CASEFL_C | 1, 0x0201, 0, 0 }, // LATIN CAPITAL LETTER A WITH DOUBLE GRAVE
{ 0x0202, CASEFL_C | 1, 0x0203, 0, 0 }, // LATIN CAPITAL LETTER A WITH INVERTED BREVE
{ 0x0204, CASEFL_C | 1, 0x0205, 0, 0 }, // LATIN CAPITAL LETTER E WITH DOUBLE GRAVE
{ 0x0206, CASEFL_C | 1, 0x0207, 0, 0 }, // LATIN CAPITAL LETTER E WITH INVERTED BREVE
{ 0x0208, CASEFL_C | 1, 0x0209, 0, 0 }, // LATIN CAPITAL LETTER I WITH DOUBLE GRAVE
{ 0x020A, CASEFL_C | 1, 0x020B, 0, 0 }, // LATIN CAPITAL LETTER I WITH INVERTED BREVE
{ 0x020C, CASEFL_C | 1, 0x020D, 0, 0 }, // LATIN CAPITAL LETTER O WITH DOUBLE GRAVE
{ 0x020E, CASEFL_C | 1, 0x020F, 0, 0 }, // LATIN CAPITAL LETTER O WITH INVERTED BREVE
{ 0x0210, CASEFL_C | 1, 0x0211, 0, 0 }, // LATIN CAPITAL LETTER R WITH DOUBLE GRAVE
{ 0x0212, CASEFL_C | 1, 0x0213, 0, 0 }, // LATIN CAPITAL LETTER R WITH INVERTED BREVE
{ 0x0214, CASEFL_C | 1, 0x0215, 0, 0 }, // LATIN CAPITAL LETTER U WITH DOUBLE GRAVE
{ 0x0216, CASEFL_C | 1, 0x0217, 0, 0 }, // LATIN CAPITAL LETTER U WITH INVERTED BREVE
{ 0x0218, CASEFL_C | 1, 0x0219, 0, 0 }, // LATIN CAPITAL LETTER S WITH COMMA BELOW
{ 0x021A, CASEFL_C | 1, 0x021B, 0, 0 }, // LATIN CAPITAL LETTER T WITH COMMA BELOW
{ 0x021C, CASEFL_C | 1, 0x021D, 0, 0 }, // LATIN CAPITAL LETTER YOGH
{ 0x021E, CASEFL_C | 1, 0x021F, 0, 0 }, // LATIN CAPITAL LETTER H WITH CARON
{ 0x0220, CASEFL_C | 1, 0x019E, 0, 0 }, // LATIN CAPITAL LETTER N WITH LONG RIGHT LEG
{ 0x0222, CASEFL_C | 1, 0x0223, 0, 0 }, // LATIN CAPITAL LETTER OU
{ 0x0224, CASEFL_C | 1, 0x0225, 0, 0 }, // LATIN CAPITAL LETTER Z WITH HOOK
{ 0x0226, CASEFL_C | 1, 0x0227, 0, 0 }, // LATIN CAPITAL LETTER A WITH DOT ABOVE
{ 0x0228, CASEFL_C | 1, 0x0229, 0, 0 }, // LATIN CAPITAL LETTER E WITH CEDILLA
{ 0x022A, CASEFL_C | 1, 0x022B, 0, 0 }, // LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON
{ 0x022C, CASEFL_C | 1, 0x022D, 0, 0 }, // LATIN CAPITAL LETTER O WITH TILDE AND MACRON
{ 0x022E, CASEFL_C | 1, 0x022F, 0, 0 }, // LATIN CAPITAL LETTER O WITH DOT ABOVE
{ 0x0230, CASEFL_C | 1, 0x0231, 0, 0 }, // LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON
{ 0x0232, CASEFL_C | 1, 0x0233, 0, 0 }, // LATIN CAPITAL LETTER Y WITH MACRON
{ 0x0345, CASEFL_C | 1, 0x03B9, 0, 0 }, // COMBINING GREEK YPOGEGRAMMENI
{ 0x0386, CASEFL_C | 1, 0x03AC, 0, 0 }, // GREEK CAPITAL LETTER ALPHA WITH TONOS
{ 0x0388, CASEFL_C | 1, 0x03AD, 0, 0 }, // GREEK CAPITAL LETTER EPSILON WITH TONOS
{ 0x0389, CASEFL_C | 1, 0x03AE, 0, 0 }, // GREEK CAPITAL LETTER ETA WITH TONOS
{ 0x038A, CASEFL_C | 1, 0x03AF, 0, 0 }, // GREEK CAPITAL LETTER IOTA WITH TONOS
{ 0x038C, CASEFL_C | 1, 0x03CC, 0, 0 }, // GREEK CAPITAL LETTER OMICRON WITH TONOS
{ 0x038E, CASEFL_C | 1, 0x03CD, 0, 0 }, // GREEK CAPITAL LETTER UPSILON WITH TONOS
{ 0x038F, CASEFL_C | 1, 0x03CE, 0, 0 }, // GREEK CAPITAL LETTER OMEGA WITH TONOS
{ 0x0390, CASEFL_F | 3, 0x03B9, 0x0308, 0x0301 }, // GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS
{ 0x0391, CASEFL_C | 1, 0x03B1, 0, 0 }, // GREEK CAPITAL LETTER ALPHA
{ 0x0392, CASEFL_C | 1, 0x03B2, 0, 0 }, // GREEK CAPITAL LETTER BETA
{ 0x0393, CASEFL_C | 1, 0x03B3, 0, 0 }, // GREEK CAPITAL LETTER GAMMA
{ 0x0394, CASEFL_C | 1, 0x03B4, 0, 0 }, // GREEK CAPITAL LETTER DELTA
{ 0x0395, CASEFL_C | 1, 0x03B5, 0, 0 }, // GREEK CAPITAL LETTER EPSILON
{ 0x0396, CASEFL_C | 1, 0x03B6, 0, 0 }, // GREEK CAPITAL LETTER ZETA
{ 0x0397, CASEFL_C | 1, 0x03B7, 0, 0 }, // GREEK CAPITAL LETTER ETA
{ 0x0398, CASEFL_C | 1, 0x03B8, 0, 0 }, // GREEK CAPITAL LETTER THETA
{ 0x0399, CASEFL_C | 1, 0x03B9, 0, 0 }, // GREEK CAPITAL LETTER IOTA
{ 0x039A, CASEFL_C | 1, 0x03BA, 0, 0 }, // GREEK CAPITAL LETTER KAPPA
{ 0x039B, CASEFL_C | 1, 0x03BB, 0, 0 }, // GREEK CAPITAL LETTER LAMDA
{ 0x039C, CASEFL_C | 1, 0x03BC, 0, 0 }, // GREEK CAPITAL LETTER MU
{ 0x039D, CASEFL_C | 1, 0x03BD, 0, 0 }, // GREEK CAPITAL LETTER NU
{ 0x039E, CASEFL_C | 1, 0x03BE, 0, 0 }, // GREEK CAPITAL LETTER XI
{ 0x039F, CASEFL_C | 1, 0x03BF, 0, 0 }, // GREEK CAPITAL LETTER OMICRON
{ 0x03A0, CASEFL_C | 1, 0x03C0, 0, 0 }, // GREEK CAPITAL LETTER PI
{ 0x03A1, CASEFL_C | 1, 0x03C1, 0, 0 }, // GREEK CAPITAL LETTER RHO
{ 0x03A3, CASEFL_C | 1, 0x03C3, 0, 0 }, // GREEK CAPITAL LETTER SIGMA
{ 0x03A4, CASEFL_C | 1, 0x03C4, 0, 0 }, // GREEK CAPITAL LETTER TAU
{ 0x03A5, CASEFL_C | 1, 0x03C5, 0, 0 }, // GREEK CAPITAL LETTER UPSILON
{ 0x03A6, CASEFL_C | 1, 0x03C6, 0, 0 }, // GREEK CAPITAL LETTER PHI
{ 0x03A7, CASEFL_C | 1, 0x03C7, 0, 0 }, // GREEK CAPITAL LETTER CHI
{ 0x03A8, CASEFL_C | 1, 0x03C8, 0, 0 }, // GREEK CAPITAL LETTER PSI
{ 0x03A9, CASEFL_C | 1, 0x03C9, 0, 0 }, // GREEK CAPITAL LETTER OMEGA
{ 0x03AA, CASEFL_C | 1, 0x03CA, 0, 0 }, // GREEK CAPITAL LETTER IOTA WITH DIALYTIKA
{ 0x03AB, CASEFL_C | 1, 0x03CB, 0, 0 }, // GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
{ 0x03B0, CASEFL_F | 3, 0x03C5, 0x0308, 0x0301 }, // GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS
{ 0x03C2, CASEFL_C | 1, 0x03C3, 0, 0 }, // GREEK SMALL LETTER FINAL SIGMA
{ 0x03D0, CASEFL_C | 1, 0x03B2, 0, 0 }, // GREEK BETA SYMBOL
{ 0x03D1, CASEFL_C | 1, 0x03B8, 0, 0 }, // GREEK THETA SYMBOL
{ 0x03D5, CASEFL_C | 1, 0x03C6, 0, 0 }, // GREEK PHI SYMBOL
{ 0x03D6, CASEFL_C | 1, 0x03C0, 0, 0 }, // GREEK PI SYMBOL
{ 0x03D8, CASEFL_C | 1, 0x03D9, 0, 0 }, // GREEK LETTER ARCHAIC KOPPA
{ 0x03DA, CASEFL_C | 1, 0x03DB, 0, 0 }, // GREEK LETTER STIGMA
{ 0x03DC, CASEFL_C | 1, 0x03DD, 0, 0 }, // GREEK LETTER DIGAMMA
{ 0x03DE, CASEFL_C | 1, 0x03DF, 0, 0 }, // GREEK LETTER KOPPA
{ 0x03E0, CASEFL_C | 1, 0x03E1, 0, 0 }, // GREEK LETTER SAMPI
{ 0x03E2, CASEFL_C | 1, 0x03E3, 0, 0 }, // COPTIC CAPITAL LETTER SHEI
{ 0x03E4, CASEFL_C | 1, 0x03E5, 0, 0 }, // COPTIC CAPITAL LETTER FEI
{ 0x03E6, CASEFL_C | 1, 0x03E7, 0, 0 }, // COPTIC CAPITAL LETTER KHEI
{ 0x03E8, CASEFL_C | 1, 0x03E9, 0, 0 }, // COPTIC CAPITAL LETTER HORI
{ 0x03EA, CASEFL_C | 1, 0x03EB, 0, 0 }, // COPTIC CAPITAL LETTER GANGIA
{ 0x03EC, CASEFL_C | 1, 0x03ED, 0, 0 }, // COPTIC CAPITAL LETTER SHIMA
{ 0x03EE, CASEFL_C | 1, 0x03EF, 0, 0 }, // COPTIC CAPITAL LETTER DEI
{ 0x03F0, CASEFL_C | 1, 0x03BA, 0, 0 }, // GREEK KAPPA SYMBOL
{ 0x03F1, CASEFL_C | 1, 0x03C1, 0, 0 }, // GREEK RHO SYMBOL
{ 0x03F2, CASEFL_C | 1, 0x03C3, 0, 0 }, // GREEK LUNATE SIGMA SYMBOL
{ 0x03F4, CASEFL_C | 1, 0x03B8, 0, 0 }, // GREEK CAPITAL THETA SYMBOL
{ 0x03F5, CASEFL_C | 1, 0x03B5, 0, 0 }, // GREEK LUNATE EPSILON SYMBOL
{ 0x0400, CASEFL_C | 1, 0x0450, 0, 0 }, // CYRILLIC CAPITAL LETTER IE WITH GRAVE
{ 0x0401, CASEFL_C | 1, 0x0451, 0, 0 }, // CYRILLIC CAPITAL LETTER IO
{ 0x0402, CASEFL_C | 1, 0x0452, 0, 0 }, // CYRILLIC CAPITAL LETTER DJE
{ 0x0403, CASEFL_C | 1, 0x0453, 0, 0 }, // CYRILLIC CAPITAL LETTER GJE
{ 0x0404, CASEFL_C | 1, 0x0454, 0, 0 }, // CYRILLIC CAPITAL LETTER UKRAINIAN IE
{ 0x0405, CASEFL_C | 1, 0x0455, 0, 0 }, // CYRILLIC CAPITAL LETTER DZE
{ 0x0406, CASEFL_C | 1, 0x0456, 0, 0 }, // CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I
{ 0x0407, CASEFL_C | 1, 0x0457, 0, 0 }, // CYRILLIC CAPITAL LETTER YI
{ 0x0408, CASEFL_C | 1, 0x0458, 0, 0 }, // CYRILLIC CAPITAL LETTER JE
{ 0x0409, CASEFL_C | 1, 0x0459, 0, 0 }, // CYRILLIC CAPITAL LETTER LJE
{ 0x040A, CASEFL_C | 1, 0x045A, 0, 0 }, // CYRILLIC CAPITAL LETTER NJE
{ 0x040B, CASEFL_C | 1, 0x045B, 0, 0 }, // CYRILLIC CAPITAL LETTER TSHE
{ 0x040C, CASEFL_C | 1, 0x045C, 0, 0 }, // CYRILLIC CAPITAL LETTER KJE
{ 0x040D, CASEFL_C | 1, 0x045D, 0, 0 }, // CYRILLIC CAPITAL LETTER I WITH GRAVE
{ 0x040E, CASEFL_C | 1, 0x045E, 0, 0 }, // CYRILLIC CAPITAL LETTER SHORT U
{ 0x040F, CASEFL_C | 1, 0x045F, 0, 0 }, // CYRILLIC CAPITAL LETTER DZHE
{ 0x0410, CASEFL_C | 1, 0x0430, 0, 0 }, // CYRILLIC CAPITAL LETTER A
{ 0x0411, CASEFL_C | 1, 0x0431, 0, 0 }, // CYRILLIC CAPITAL LETTER BE
{ 0x0412, CASEFL_C | 1, 0x0432, 0, 0 }, // CYRILLIC CAPITAL LETTER VE
{ 0x0413, CASEFL_C | 1, 0x0433, 0, 0 }, // CYRILLIC CAPITAL LETTER GHE
{ 0x0414, CASEFL_C | 1, 0x0434, 0, 0 }, // CYRILLIC CAPITAL LETTER DE
{ 0x0415, CASEFL_C | 1, 0x0435, 0, 0 }, // CYRILLIC CAPITAL LETTER IE
{ 0x0416, CASEFL_C | 1, 0x0436, 0, 0 }, // CYRILLIC CAPITAL LETTER ZHE
{ 0x0417, CASEFL_C | 1, 0x0437, 0, 0 }, // CYRILLIC CAPITAL LETTER ZE
{ 0x0418, CASEFL_C | 1, 0x0438, 0, 0 }, // CYRILLIC CAPITAL LETTER I
{ 0x0419, CASEFL_C | 1, 0x0439, 0, 0 }, // CYRILLIC CAPITAL LETTER SHORT I
{ 0x041A, CASEFL_C | 1, 0x043A, 0, 0 }, // CYRILLIC CAPITAL LETTER KA
{ 0x041B, CASEFL_C | 1, 0x043B, 0, 0 }, // CYRILLIC CAPITAL LETTER EL
{ 0x041C, CASEFL_C | 1, 0x043C, 0, 0 }, // CYRILLIC CAPITAL LETTER EM
{ 0x041D, CASEFL_C | 1, 0x043D, 0, 0 }, // CYRILLIC CAPITAL LETTER EN
{ 0x041E, CASEFL_C | 1, 0x043E, 0, 0 }, // CYRILLIC CAPITAL LETTER O
{ 0x041F, CASEFL_C | 1, 0x043F, 0, 0 }, // CYRILLIC CAPITAL LETTER PE
{ 0x0420, CASEFL_C | 1, 0x0440, 0, 0 }, // CYRILLIC CAPITAL LETTER ER
{ 0x0421, CASEFL_C | 1, 0x0441, 0, 0 }, // CYRILLIC CAPITAL LETTER ES
{ 0x0422, CASEFL_C | 1, 0x0442, 0, 0 }, // CYRILLIC CAPITAL LETTER TE
{ 0x0423, CASEFL_C | 1, 0x0443, 0, 0 }, // CYRILLIC CAPITAL LETTER U
{ 0x0424, CASEFL_C | 1, 0x0444, 0, 0 }, // CYRILLIC CAPITAL LETTER EF
{ 0x0425, CASEFL_C | 1, 0x0445, 0, 0 }, // CYRILLIC CAPITAL LETTER HA
{ 0x0426, CASEFL_C | 1, 0x0446, 0, 0 }, // CYRILLIC CAPITAL LETTER TSE
{ 0x0427, CASEFL_C | 1, 0x0447, 0, 0 }, // CYRILLIC CAPITAL LETTER CHE
{ 0x0428, CASEFL_C | 1, 0x0448, 0, 0 }, // CYRILLIC CAPITAL LETTER SHA
{ 0x0429, CASEFL_C | 1, 0x0449, 0, 0 }, // CYRILLIC CAPITAL LETTER SHCHA
{ 0x042A, CASEFL_C | 1, 0x044A, 0, 0 }, // CYRILLIC CAPITAL LETTER HARD SIGN
{ 0x042B, CASEFL_C | 1, 0x044B, 0, 0 }, // CYRILLIC CAPITAL LETTER YERU
{ 0x042C, CASEFL_C | 1, 0x044C, 0, 0 }, // CYRILLIC CAPITAL LETTER SOFT SIGN
{ 0x042D, CASEFL_C | 1, 0x044D, 0, 0 }, // CYRILLIC CAPITAL LETTER E
{ 0x042E, CASEFL_C | 1, 0x044E, 0, 0 }, // CYRILLIC CAPITAL LETTER YU
{ 0x042F, CASEFL_C | 1, 0x044F, 0, 0 }, // CYRILLIC CAPITAL LETTER YA
{ 0x0460, CASEFL_C | 1, 0x0461, 0, 0 }, // CYRILLIC CAPITAL LETTER OMEGA
{ 0x0462, CASEFL_C | 1, 0x0463, 0, 0 }, // CYRILLIC CAPITAL LETTER YAT
{ 0x0464, CASEFL_C | 1, 0x0465, 0, 0 }, // CYRILLIC CAPITAL LETTER IOTIFIED E
{ 0x0466, CASEFL_C | 1, 0x0467, 0, 0 }, // CYRILLIC CAPITAL LETTER LITTLE YUS
{ 0x0468, CASEFL_C | 1, 0x0469, 0, 0 }, // CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS
{ 0x046A, CASEFL_C | 1, 0x046B, 0, 0 }, // CYRILLIC CAPITAL LETTER BIG YUS
{ 0x046C, CASEFL_C | 1, 0x046D, 0, 0 }, // CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS
{ 0x046E, CASEFL_C | 1, 0x046F, 0, 0 }, // CYRILLIC CAPITAL LETTER KSI
{ 0x0470, CASEFL_C | 1, 0x0471, 0, 0 }, // CYRILLIC CAPITAL LETTER PSI
{ 0x0472, CASEFL_C | 1, 0x0473, 0, 0 }, // CYRILLIC CAPITAL LETTER FITA
{ 0x0474, CASEFL_C | 1, 0x0475, 0, 0 }, // CYRILLIC CAPITAL LETTER IZHITSA
{ 0x0476, CASEFL_C | 1, 0x0477, 0, 0 }, // CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
{ 0x0478, CASEFL_C | 1, 0x0479, 0, 0 }, // CYRILLIC CAPITAL LETTER UK
{ 0x047A, CASEFL_C | 1, 0x047B, 0, 0 }, // CYRILLIC CAPITAL LETTER ROUND OMEGA
{ 0x047C, CASEFL_C | 1, 0x047D, 0, 0 }, // CYRILLIC CAPITAL LETTER OMEGA WITH TITLO
{ 0x047E, CASEFL_C | 1, 0x047F, 0, 0 }, // CYRILLIC CAPITAL LETTER OT
{ 0x0480, CASEFL_C | 1, 0x0481, 0, 0 }, // CYRILLIC CAPITAL LETTER KOPPA
{ 0x048A, CASEFL_C | 1, 0x048B, 0, 0 }, // CYRILLIC CAPITAL LETTER SHORT I WITH TAIL
{ 0x048C, CASEFL_C | 1, 0x048D, 0, 0 }, // CYRILLIC CAPITAL LETTER SEMISOFT SIGN
{ 0x048E, CASEFL_C | 1, 0x048F, 0, 0 }, // CYRILLIC CAPITAL LETTER ER WITH TICK
{ 0x0490, CASEFL_C | 1, 0x0491, 0, 0 }, // CYRILLIC CAPITAL LETTER GHE WITH UPTURN
{ 0x0492, CASEFL_C | 1, 0x0493, 0, 0 }, // CYRILLIC CAPITAL LETTER GHE WITH STROKE
{ 0x0494, CASEFL_C | 1, 0x0495, 0, 0 }, // CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK
{ 0x0496, CASEFL_C | 1, 0x0497, 0, 0 }, // CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER
{ 0x0498, CASEFL_C | 1, 0x0499, 0, 0 }, // CYRILLIC CAPITAL LETTER ZE WITH DESCENDER
{ 0x049A, CASEFL_C | 1, 0x049B, 0, 0 }, // CYRILLIC CAPITAL LETTER KA WITH DESCENDER
{ 0x049C, CASEFL_C | 1, 0x049D, 0, 0 }, // CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE
{ 0x049E, CASEFL_C | 1, 0x049F, 0, 0 }, // CYRILLIC CAPITAL LETTER KA WITH STROKE
{ 0x04A0, CASEFL_C | 1, 0x04A1, 0, 0 }, // CYRILLIC CAPITAL LETTER BASHKIR KA
{ 0x04A2, CASEFL_C | 1, 0x04A3, 0, 0 }, // CYRILLIC CAPITAL LETTER EN WITH DESCENDER
{ 0x04A4, CASEFL_C | 1, 0x04A5, 0, 0 }, // CYRILLIC CAPITAL LIGATURE EN GHE
{ 0x04A6, CASEFL_C | 1, 0x04A7, 0, 0 }, // CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK
{ 0x04A8, CASEFL_C | 1, 0x04A9, 0, 0 }, // CYRILLIC CAPITAL LETTER ABKHASIAN HA
{ 0x04AA, CASEFL_C | 1, 0x04AB, 0, 0 }, // CYRILLIC CAPITAL LETTER ES WITH DESCENDER
{ 0x04AC, CASEFL_C | 1, 0x04AD, 0, 0 }, // CYRILLIC CAPITAL LETTER TE WITH DESCENDER
{ 0x04AE, CASEFL_C | 1, 0x04AF, 0, 0 }, // CYRILLIC CAPITAL LETTER STRAIGHT U
{ 0x04B0, CASEFL_C | 1, 0x04B1, 0, 0 }, // CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE
{ 0x04B2, CASEFL_C | 1, 0x04B3, 0, 0 }, // CYRILLIC CAPITAL LETTER HA WITH DESCENDER
{ 0x04B4, CASEFL_C | 1, 0x04B5, 0, 0 }, // CYRILLIC CAPITAL LIGATURE TE TSE
{ 0x04B6, CASEFL_C | 1, 0x04B7, 0, 0 }, // CYRILLIC CAPITAL LETTER CHE WITH DESCENDER
{ 0x04B8, CASEFL_C | 1, 0x04B9, 0, 0 }, // CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE
{ 0x04BA, CASEFL_C | 1, 0x04BB, 0, 0 }, // CYRILLIC CAPITAL LETTER SHHA
{ 0x04BC, CASEFL_C | 1, 0x04BD, 0, 0 }, // CYRILLIC CAPITAL LETTER ABKHASIAN CHE
{ 0x04BE, CASEFL_C | 1, 0x04BF, 0, 0 }, // CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER
{ 0x04C1, CASEFL_C | 1, 0x04C2, 0, 0 }, // CYRILLIC CAPITAL LETTER ZHE WITH BREVE
{ 0x04C3, CASEFL_C | 1, 0x04C4, 0, 0 }, // CYRILLIC CAPITAL LETTER KA WITH HOOK
{ 0x04C5, CASEFL_C | 1, 0x04C6, 0, 0 }, // CYRILLIC CAPITAL LETTER EL WITH TAIL
{ 0x04C7, CASEFL_C | 1, 0x04C8, 0, 0 }, // CYRILLIC CAPITAL LETTER EN WITH HOOK
{ 0x04C9, CASEFL_C | 1, 0x04CA, 0, 0 }, // CYRILLIC CAPITAL LETTER EN WITH TAIL
{ 0x04CB, CASEFL_C | 1, 0x04CC, 0, 0 }, // CYRILLIC CAPITAL LETTER KHAKASSIAN CHE
{ 0x04CD, CASEFL_C | 1, 0x04CE, 0, 0 }, // CYRILLIC CAPITAL LETTER EM WITH TAIL
{ 0x04D0, CASEFL_C | 1, 0x04D1, 0, 0 }, // CYRILLIC CAPITAL LETTER A WITH BREVE
{ 0x04D2, CASEFL_C | 1, 0x04D3, 0, 0 }, // CYRILLIC CAPITAL LETTER A WITH DIAERESIS
{ 0x04D4, CASEFL_C | 1, 0x04D5, 0, 0 }, // CYRILLIC CAPITAL LIGATURE A IE
{ 0x04D6, CASEFL_C | 1, 0x04D7, 0, 0 }, // CYRILLIC CAPITAL LETTER IE WITH BREVE
{ 0x04D8, CASEFL_C | 1, 0x04D9, 0, 0 }, // CYRILLIC CAPITAL LETTER SCHWA
{ 0x04DA, CASEFL_C | 1, 0x04DB, 0, 0 }, // CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS
{ 0x04DC, CASEFL_C | 1, 0x04DD, 0, 0 }, // CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS
{ 0x04DE, CASEFL_C | 1, 0x04DF, 0, 0 }, // CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS
{ 0x04E0, CASEFL_C | 1, 0x04E1, 0, 0 }, // CYRILLIC CAPITAL LETTER ABKHASIAN DZE
{ 0x04E2, CASEFL_C | 1, 0x04E3, 0, 0 }, // CYRILLIC CAPITAL LETTER I WITH MACRON
{ 0x04E4, CASEFL_C | 1, 0x04E5, 0, 0 }, // CYRILLIC CAPITAL LETTER I WITH DIAERESIS
{ 0x04E6, CASEFL_C | 1, 0x04E7, 0, 0 }, // CYRILLIC CAPITAL LETTER O WITH DIAERESIS
{ 0x04E8, CASEFL_C | 1, 0x04E9, 0, 0 }, // CYRILLIC CAPITAL LETTER BARRED O
{ 0x04EA, CASEFL_C | 1, 0x04EB, 0, 0 }, // CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS
{ 0x04EC, CASEFL_C | 1, 0x04ED, 0, 0 }, // CYRILLIC CAPITAL LETTER E WITH DIAERESIS
{ 0x04EE, CASEFL_C | 1, 0x04EF, 0, 0 }, // CYRILLIC CAPITAL LETTER U WITH MACRON
{ 0x04F0, CASEFL_C | 1, 0x04F1, 0, 0 }, // CYRILLIC CAPITAL LETTER U WITH DIAERESIS
{ 0x04F2, CASEFL_C | 1, 0x04F3, 0, 0 }, // CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE
{ 0x04F4, CASEFL_C | 1, 0x04F5, 0, 0 }, // CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS
{ 0x04F8, CASEFL_C | 1, 0x04F9, 0, 0 }, // CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS
{ 0x0500, CASEFL_C | 1, 0x0501, 0, 0 }, // CYRILLIC CAPITAL LETTER KOMI DE
{ 0x0502, CASEFL_C | 1, 0x0503, 0, 0 }, // CYRILLIC CAPITAL LETTER KOMI DJE
{ 0x0504, CASEFL_C | 1, 0x0505, 0, 0 }, // CYRILLIC CAPITAL LETTER KOMI ZJE
{ 0x0506, CASEFL_C | 1, 0x0507, 0, 0 }, // CYRILLIC CAPITAL LETTER KOMI DZJE
{ 0x0508, CASEFL_C | 1, 0x0509, 0, 0 }, // CYRILLIC CAPITAL LETTER KOMI LJE
{ 0x050A, CASEFL_C | 1, 0x050B, 0, 0 }, // CYRILLIC CAPITAL LETTER KOMI NJE
{ 0x050C, CASEFL_C | 1, 0x050D, 0, 0 }, // CYRILLIC CAPITAL LETTER KOMI SJE
{ 0x050E, CASEFL_C | 1, 0x050F, 0, 0 }, // CYRILLIC CAPITAL LETTER KOMI TJE
{ 0x0531, CASEFL_C | 1, 0x0561, 0, 0 }, // ARMENIAN CAPITAL LETTER AYB
{ 0x0532, CASEFL_C | 1, 0x0562, 0, 0 }, // ARMENIAN CAPITAL LETTER BEN
{ 0x0533, CASEFL_C | 1, 0x0563, 0, 0 }, // ARMENIAN CAPITAL LETTER GIM
{ 0x0534, CASEFL_C | 1, 0x0564, 0, 0 }, // ARMENIAN CAPITAL LETTER DA
{ 0x0535, CASEFL_C | 1, 0x0565, 0, 0 }, // ARMENIAN CAPITAL LETTER ECH
{ 0x0536, CASEFL_C | 1, 0x0566, 0, 0 }, // ARMENIAN CAPITAL LETTER ZA
{ 0x0537, CASEFL_C | 1, 0x0567, 0, 0 }, // ARMENIAN CAPITAL LETTER EH
{ 0x0538, CASEFL_C | 1, 0x0568, 0, 0 }, // ARMENIAN CAPITAL LETTER ET
{ 0x0539, CASEFL_C | 1, 0x0569, 0, 0 }, // ARMENIAN CAPITAL LETTER TO
{ 0x053A, CASEFL_C | 1, 0x056A, 0, 0 }, // ARMENIAN CAPITAL LETTER ZHE
{ 0x053B, CASEFL_C | 1, 0x056B, 0, 0 }, // ARMENIAN CAPITAL LETTER INI
{ 0x053C, CASEFL_C | 1, 0x056C, 0, 0 }, // ARMENIAN CAPITAL LETTER LIWN
{ 0x053D, CASEFL_C | 1, 0x056D, 0, 0 }, // ARMENIAN CAPITAL LETTER XEH
{ 0x053E, CASEFL_C | 1, 0x056E, 0, 0 }, // ARMENIAN CAPITAL LETTER CA
{ 0x053F, CASEFL_C | 1, 0x056F, 0, 0 }, // ARMENIAN CAPITAL LETTER KEN
{ 0x0540, CASEFL_C | 1, 0x0570, 0, 0 }, // ARMENIAN CAPITAL LETTER HO
{ 0x0541, CASEFL_C | 1, 0x0571, 0, 0 }, // ARMENIAN CAPITAL LETTER JA
{ 0x0542, CASEFL_C | 1, 0x0572, 0, 0 }, // ARMENIAN CAPITAL LETTER GHAD
{ 0x0543, CASEFL_C | 1, 0x0573, 0, 0 }, // ARMENIAN CAPITAL LETTER CHEH
{ 0x0544, CASEFL_C | 1, 0x0574, 0, 0 }, // ARMENIAN CAPITAL LETTER MEN
{ 0x0545, CASEFL_C | 1, 0x0575, 0, 0 }, // ARMENIAN CAPITAL LETTER YI
{ 0x0546, CASEFL_C | 1, 0x0576, 0, 0 }, // ARMENIAN CAPITAL LETTER NOW
{ 0x0547, CASEFL_C | 1, 0x0577, 0, 0 }, // ARMENIAN CAPITAL LETTER SHA
{ 0x0548, CASEFL_C | 1, 0x0578, 0, 0 }, // ARMENIAN CAPITAL LETTER VO
{ 0x0549, CASEFL_C | 1, 0x0579, 0, 0 }, // ARMENIAN CAPITAL LETTER CHA
{ 0x054A, CASEFL_C | 1, 0x057A, 0, 0 }, // ARMENIAN CAPITAL LETTER PEH
{ 0x054B, CASEFL_C | 1, 0x057B, 0, 0 }, // ARMENIAN CAPITAL LETTER JHEH
{ 0x054C, CASEFL_C | 1, 0x057C, 0, 0 }, // ARMENIAN CAPITAL LETTER RA
{ 0x054D, CASEFL_C | 1, 0x057D, 0, 0 }, // ARMENIAN CAPITAL LETTER SEH
{ 0x054E, CASEFL_C | 1, 0x057E, 0, 0 }, // ARMENIAN CAPITAL LETTER VEW
{ 0x054F, CASEFL_C | 1, 0x057F, 0, 0 }, // ARMENIAN CAPITAL LETTER TIWN
{ 0x0550, CASEFL_C | 1, 0x0580, 0, 0 }, // ARMENIAN CAPITAL LETTER REH
{ 0x0551, CASEFL_C | 1, 0x0581, 0, 0 }, // ARMENIAN CAPITAL LETTER CO
{ 0x0552, CASEFL_C | 1, 0x0582, 0, 0 }, // ARMENIAN CAPITAL LETTER YIWN
{ 0x0553, CASEFL_C | 1, 0x0583, 0, 0 }, // ARMENIAN CAPITAL LETTER PIWR
{ 0x0554, CASEFL_C | 1, 0x0584, 0, 0 }, // ARMENIAN CAPITAL LETTER KEH
{ 0x0555, CASEFL_C | 1, 0x0585, 0, 0 }, // ARMENIAN CAPITAL LETTER OH
{ 0x0556, CASEFL_C | 1, 0x0586, 0, 0 }, // ARMENIAN CAPITAL LETTER FEH
{ 0x0587, CASEFL_F | 2, 0x0565, 0x0582, 0 }, // ARMENIAN SMALL LIGATURE ECH YIWN
{ 0x1E00, CASEFL_C | 1, 0x1E01, 0, 0 }, // LATIN CAPITAL LETTER A WITH RING BELOW
{ 0x1E02, CASEFL_C | 1, 0x1E03, 0, 0 }, // LATIN CAPITAL LETTER B WITH DOT ABOVE
{ 0x1E04, CASEFL_C | 1, 0x1E05, 0, 0 }, // LATIN CAPITAL LETTER B WITH DOT BELOW
{ 0x1E06, CASEFL_C | 1, 0x1E07, 0, 0 }, // LATIN CAPITAL LETTER B WITH LINE BELOW
{ 0x1E08, CASEFL_C | 1, 0x1E09, 0, 0 }, // LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE
{ 0x1E0A, CASEFL_C | 1, 0x1E0B, 0, 0 }, // LATIN CAPITAL LETTER D WITH DOT ABOVE
{ 0x1E0C, CASEFL_C | 1, 0x1E0D, 0, 0 }, // LATIN CAPITAL LETTER D WITH DOT BELOW
{ 0x1E0E, CASEFL_C | 1, 0x1E0F, 0, 0 }, // LATIN CAPITAL LETTER D WITH LINE BELOW
{ 0x1E10, CASEFL_C | 1, 0x1E11, 0, 0 }, // LATIN CAPITAL LETTER D WITH CEDILLA
{ 0x1E12, CASEFL_C | 1, 0x1E13, 0, 0 }, // LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW
{ 0x1E14, CASEFL_C | 1, 0x1E15, 0, 0 }, // LATIN CAPITAL LETTER E WITH MACRON AND GRAVE
{ 0x1E16, CASEFL_C | 1, 0x1E17, 0, 0 }, // LATIN CAPITAL LETTER E WITH MACRON AND ACUTE
{ 0x1E18, CASEFL_C | 1, 0x1E19, 0, 0 }, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW
{ 0x1E1A, CASEFL_C | 1, 0x1E1B, 0, 0 }, // LATIN CAPITAL LETTER E WITH TILDE BELOW
{ 0x1E1C, CASEFL_C | 1, 0x1E1D, 0, 0 }, // LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE
{ 0x1E1E, CASEFL_C | 1, 0x1E1F, 0, 0 }, // LATIN CAPITAL LETTER F WITH DOT ABOVE
{ 0x1E20, CASEFL_C | 1, 0x1E21, 0, 0 }, // LATIN CAPITAL LETTER G WITH MACRON
{ 0x1E22, CASEFL_C | 1, 0x1E23, 0, 0 }, // LATIN CAPITAL LETTER H WITH DOT ABOVE
{ 0x1E24, CASEFL_C | 1, 0x1E25, 0, 0 }, // LATIN CAPITAL LETTER H WITH DOT BELOW
{ 0x1E26, CASEFL_C | 1, 0x1E27, 0, 0 }, // LATIN CAPITAL LETTER H WITH DIAERESIS
{ 0x1E28, CASEFL_C | 1, 0x1E29, 0, 0 }, // LATIN CAPITAL LETTER H WITH CEDILLA
{ 0x1E2A, CASEFL_C | 1, 0x1E2B, 0, 0 }, // LATIN CAPITAL LETTER H WITH BREVE BELOW
{ 0x1E2C, CASEFL_C | 1, 0x1E2D, 0, 0 }, // LATIN CAPITAL LETTER I WITH TILDE BELOW
{ 0x1E2E, CASEFL_C | 1, 0x1E2F, 0, 0 }, // LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE
{ 0x1E30, CASEFL_C | 1, 0x1E31, 0, 0 }, // LATIN CAPITAL LETTER K WITH ACUTE
{ 0x1E32, CASEFL_C | 1, 0x1E33, 0, 0 }, // LATIN CAPITAL LETTER K WITH DOT BELOW
{ 0x1E34, CASEFL_C | 1, 0x1E35, 0, 0 }, // LATIN CAPITAL LETTER K WITH LINE BELOW
{ 0x1E36, CASEFL_C | 1, 0x1E37, 0, 0 }, // LATIN CAPITAL LETTER L WITH DOT BELOW
{ 0x1E38, CASEFL_C | 1, 0x1E39, 0, 0 }, // LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON
{ 0x1E3A, CASEFL_C | 1, 0x1E3B, 0, 0 }, // LATIN CAPITAL LETTER L WITH LINE BELOW
{ 0x1E3C, CASEFL_C | 1, 0x1E3D, 0, 0 }, // LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW
{ 0x1E3E, CASEFL_C | 1, 0x1E3F, 0, 0 }, // LATIN CAPITAL LETTER M WITH ACUTE
{ 0x1E40, CASEFL_C | 1, 0x1E41, 0, 0 }, // LATIN CAPITAL LETTER M WITH DOT ABOVE
{ 0x1E42, CASEFL_C | 1, 0x1E43, 0, 0 }, // LATIN CAPITAL LETTER M WITH DOT BELOW
{ 0x1E44, CASEFL_C | 1, 0x1E45, 0, 0 }, // LATIN CAPITAL LETTER N WITH DOT ABOVE
{ 0x1E46, CASEFL_C | 1, 0x1E47, 0, 0 }, // LATIN CAPITAL LETTER N WITH DOT BELOW
{ 0x1E48, CASEFL_C | 1, 0x1E49, 0, 0 }, // LATIN CAPITAL LETTER N WITH LINE BELOW
{ 0x1E4A, CASEFL_C | 1, 0x1E4B, 0, 0 }, // LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW
{ 0x1E4C, CASEFL_C | 1, 0x1E4D, 0, 0 }, // LATIN CAPITAL LETTER O WITH TILDE AND ACUTE
{ 0x1E4E, CASEFL_C | 1, 0x1E4F, 0, 0 }, // LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS
{ 0x1E50, CASEFL_C | 1, 0x1E51, 0, 0 }, // LATIN CAPITAL LETTER O WITH MACRON AND GRAVE
{ 0x1E52, CASEFL_C | 1, 0x1E53, 0, 0 }, // LATIN CAPITAL LETTER O WITH MACRON AND ACUTE
{ 0x1E54, CASEFL_C | 1, 0x1E55, 0, 0 }, // LATIN CAPITAL LETTER P WITH ACUTE
{ 0x1E56, CASEFL_C | 1, 0x1E57, 0, 0 }, // LATIN CAPITAL LETTER P WITH DOT ABOVE
{ 0x1E58, CASEFL_C | 1, 0x1E59, 0, 0 }, // LATIN CAPITAL LETTER R WITH DOT ABOVE
{ 0x1E5A, CASEFL_C | 1, 0x1E5B, 0, 0 }, // LATIN CAPITAL LETTER R WITH DOT BELOW
{ 0x1E5C, CASEFL_C | 1, 0x1E5D, 0, 0 }, // LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON
{ 0x1E5E, CASEFL_C | 1, 0x1E5F, 0, 0 }, // LATIN CAPITAL LETTER R WITH LINE BELOW
{ 0x1E60, CASEFL_C | 1, 0x1E61, 0, 0 }, // LATIN CAPITAL LETTER S WITH DOT ABOVE
{ 0x1E62, CASEFL_C | 1, 0x1E63, 0, 0 }, // LATIN CAPITAL LETTER S WITH DOT BELOW
{ 0x1E64, CASEFL_C | 1, 0x1E65, 0, 0 }, // LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE
{ 0x1E66, CASEFL_C | 1, 0x1E67, 0, 0 }, // LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE
{ 0x1E68, CASEFL_C | 1, 0x1E69, 0, 0 }, // LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE
{ 0x1E6A, CASEFL_C | 1, 0x1E6B, 0, 0 }, // LATIN CAPITAL LETTER T WITH DOT ABOVE
{ 0x1E6C, CASEFL_C | 1, 0x1E6D, 0, 0 }, // LATIN CAPITAL LETTER T WITH DOT BELOW
{ 0x1E6E, CASEFL_C | 1, 0x1E6F, 0, 0 }, // LATIN CAPITAL LETTER T WITH LINE BELOW
{ 0x1E70, CASEFL_C | 1, 0x1E71, 0, 0 }, // LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW
{ 0x1E72, CASEFL_C | 1, 0x1E73, 0, 0 }, // LATIN CAPITAL LETTER U WITH DIAERESIS BELOW
{ 0x1E74, CASEFL_C | 1, 0x1E75, 0, 0 }, // LATIN CAPITAL LETTER U WITH TILDE BELOW
{ 0x1E76, CASEFL_C | 1, 0x1E77, 0, 0 }, // LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW
{ 0x1E78, CASEFL_C | 1, 0x1E79, 0, 0 }, // LATIN CAPITAL LETTER U WITH TILDE AND ACUTE
{ 0x1E7A, CASEFL_C | 1, 0x1E7B, 0, 0 }, // LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS
{ 0x1E7C, CASEFL_C | 1, 0x1E7D, 0, 0 }, // LATIN CAPITAL LETTER V WITH TILDE
{ 0x1E7E, CASEFL_C | 1, 0x1E7F, 0, 0 }, // LATIN CAPITAL LETTER V WITH DOT BELOW
{ 0x1E80, CASEFL_C | 1, 0x1E81, 0, 0 }, // LATIN CAPITAL LETTER W WITH GRAVE
{ 0x1E82, CASEFL_C | 1, 0x1E83, 0, 0 }, // LATIN CAPITAL LETTER W WITH ACUTE
{ 0x1E84, CASEFL_C | 1, 0x1E85, 0, 0 }, // LATIN CAPITAL LETTER W WITH DIAERESIS
{ 0x1E86, CASEFL_C | 1, 0x1E87, 0, 0 }, // LATIN CAPITAL LETTER W WITH DOT ABOVE
{ 0x1E88, CASEFL_C | 1, 0x1E89, 0, 0 }, // LATIN CAPITAL LETTER W WITH DOT BELOW
{ 0x1E8A, CASEFL_C | 1, 0x1E8B, 0, 0 }, // LATIN CAPITAL LETTER X WITH DOT ABOVE
{ 0x1E8C, CASEFL_C | 1, 0x1E8D, 0, 0 }, // LATIN CAPITAL LETTER X WITH DIAERESIS
{ 0x1E8E, CASEFL_C | 1, 0x1E8F, 0, 0 }, // LATIN CAPITAL LETTER Y WITH DOT ABOVE
{ 0x1E90, CASEFL_C | 1, 0x1E91, 0, 0 }, // LATIN CAPITAL LETTER Z WITH CIRCUMFLEX
{ 0x1E92, CASEFL_C | 1, 0x1E93, 0, 0 }, // LATIN CAPITAL LETTER Z WITH DOT BELOW
{ 0x1E94, CASEFL_C | 1, 0x1E95, 0, 0 }, // LATIN CAPITAL LETTER Z WITH LINE BELOW
{ 0x1E96, CASEFL_F | 2, 0x0068, 0x0331, 0 }, // LATIN SMALL LETTER H WITH LINE BELOW
{ 0x1E97, CASEFL_F | 2, 0x0074, 0x0308, 0 }, // LATIN SMALL LETTER T WITH DIAERESIS
{ 0x1E98, CASEFL_F | 2, 0x0077, 0x030A, 0 }, // LATIN SMALL LETTER W WITH RING ABOVE
{ 0x1E99, CASEFL_F | 2, 0x0079, 0x030A, 0 }, // LATIN SMALL LETTER Y WITH RING ABOVE
{ 0x1E9A, CASEFL_F | 2, 0x0061, 0x02BE, 0 }, // LATIN SMALL LETTER A WITH RIGHT HALF RING
{ 0x1E9B, CASEFL_C | 1, 0x1E61, 0, 0 }, // LATIN SMALL LETTER LONG S WITH DOT ABOVE
{ 0x1EA0, CASEFL_C | 1, 0x1EA1, 0, 0 }, // LATIN CAPITAL LETTER A WITH DOT BELOW
{ 0x1EA2, CASEFL_C | 1, 0x1EA3, 0, 0 }, // LATIN CAPITAL LETTER A WITH HOOK ABOVE
{ 0x1EA4, CASEFL_C | 1, 0x1EA5, 0, 0 }, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE
{ 0x1EA6, CASEFL_C | 1, 0x1EA7, 0, 0 }, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE
{ 0x1EA8, CASEFL_C | 1, 0x1EA9, 0, 0 }, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
{ 0x1EAA, CASEFL_C | 1, 0x1EAB, 0, 0 }, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE
{ 0x1EAC, CASEFL_C | 1, 0x1EAD, 0, 0 }, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW
{ 0x1EAE, CASEFL_C | 1, 0x1EAF, 0, 0 }, // LATIN CAPITAL LETTER A WITH BREVE AND ACUTE
{ 0x1EB0, CASEFL_C | 1, 0x1EB1, 0, 0 }, // LATIN CAPITAL LETTER A WITH BREVE AND GRAVE
{ 0x1EB2, CASEFL_C | 1, 0x1EB3, 0, 0 }, // LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE
{ 0x1EB4, CASEFL_C | 1, 0x1EB5, 0, 0 }, // LATIN CAPITAL LETTER A WITH BREVE AND TILDE
{ 0x1EB6, CASEFL_C | 1, 0x1EB7, 0, 0 }, // LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW
{ 0x1EB8, CASEFL_C | 1, 0x1EB9, 0, 0 }, // LATIN CAPITAL LETTER E WITH DOT BELOW
{ 0x1EBA, CASEFL_C | 1, 0x1EBB, 0, 0 }, // LATIN CAPITAL LETTER E WITH HOOK ABOVE
{ 0x1EBC, CASEFL_C | 1, 0x1EBD, 0, 0 }, // LATIN CAPITAL LETTER E WITH TILDE
{ 0x1EBE, CASEFL_C | 1, 0x1EBF, 0, 0 }, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
{ 0x1EC0, CASEFL_C | 1, 0x1EC1, 0, 0 }, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
{ 0x1EC2, CASEFL_C | 1, 0x1EC3, 0, 0 }, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
{ 0x1EC4, CASEFL_C | 1, 0x1EC5, 0, 0 }, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
{ 0x1EC6, CASEFL_C | 1, 0x1EC7, 0, 0 }, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
{ 0x1EC8, CASEFL_C | 1, 0x1EC9, 0, 0 }, // LATIN CAPITAL LETTER I WITH HOOK ABOVE
{ 0x1ECA, CASEFL_C | 1, 0x1ECB, 0, 0 }, // LATIN CAPITAL LETTER I WITH DOT BELOW
{ 0x1ECC, CASEFL_C | 1, 0x1ECD, 0, 0 }, // LATIN CAPITAL LETTER O WITH DOT BELOW
{ 0x1ECE, CASEFL_C | 1, 0x1ECF, 0, 0 }, // LATIN CAPITAL LETTER O WITH HOOK ABOVE
{ 0x1ED0, CASEFL_C | 1, 0x1ED1, 0, 0 }, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE
{ 0x1ED2, CASEFL_C | 1, 0x1ED3, 0, 0 }, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE
{ 0x1ED4, CASEFL_C | 1, 0x1ED5, 0, 0 }, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
{ 0x1ED6, CASEFL_C | 1, 0x1ED7, 0, 0 }, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE
{ 0x1ED8, CASEFL_C | 1, 0x1ED9, 0, 0 }, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW
{ 0x1EDA, CASEFL_C | 1, 0x1EDB, 0, 0 }, // LATIN CAPITAL LETTER O WITH HORN AND ACUTE
{ 0x1EDC, CASEFL_C | 1, 0x1EDD, 0, 0 }, // LATIN CAPITAL LETTER O WITH HORN AND GRAVE
{ 0x1EDE, CASEFL_C | 1, 0x1EDF, 0, 0 }, // LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE
{ 0x1EE0, CASEFL_C | 1, 0x1EE1, 0, 0 }, // LATIN CAPITAL LETTER O WITH HORN AND TILDE
{ 0x1EE2, CASEFL_C | 1, 0x1EE3, 0, 0 }, // LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW
{ 0x1EE4, CASEFL_C | 1, 0x1EE5, 0, 0 }, // LATIN CAPITAL LETTER U WITH DOT BELOW
{ 0x1EE6, CASEFL_C | 1, 0x1EE7, 0, 0 }, // LATIN CAPITAL LETTER U WITH HOOK ABOVE
{ 0x1EE8, CASEFL_C | 1, 0x1EE9, 0, 0 }, // LATIN CAPITAL LETTER U WITH HORN AND ACUTE
{ 0x1EEA, CASEFL_C | 1, 0x1EEB, 0, 0 }, // LATIN CAPITAL LETTER U WITH HORN AND GRAVE
{ 0x1EEC, CASEFL_C | 1, 0x1EED, 0, 0 }, // LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE
{ 0x1EEE, CASEFL_C | 1, 0x1EEF, 0, 0 }, // LATIN CAPITAL LETTER U WITH HORN AND TILDE
{ 0x1EF0, CASEFL_C | 1, 0x1EF1, 0, 0 }, // LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW
{ 0x1EF2, CASEFL_C | 1, 0x1EF3, 0, 0 }, // LATIN CAPITAL LETTER Y WITH GRAVE
{ 0x1EF4, CASEFL_C | 1, 0x1EF5, 0, 0 }, // LATIN CAPITAL LETTER Y WITH DOT BELOW
{ 0x1EF6, CASEFL_C | 1, 0x1EF7, 0, 0 }, // LATIN CAPITAL LETTER Y WITH HOOK ABOVE
{ 0x1EF8, CASEFL_C | 1, 0x1EF9, 0, 0 }, // LATIN CAPITAL LETTER Y WITH TILDE
{ 0x1F08, CASEFL_C | 1, 0x1F00, 0, 0 }, // GREEK CAPITAL LETTER ALPHA WITH PSILI
{ 0x1F09, CASEFL_C | 1, 0x1F01, 0, 0 }, // GREEK CAPITAL LETTER ALPHA WITH DASIA
{ 0x1F0A, CASEFL_C | 1, 0x1F02, 0, 0 }, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA
{ 0x1F0B, CASEFL_C | 1, 0x1F03, 0, 0 }, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA
{ 0x1F0C, CASEFL_C | 1, 0x1F04, 0, 0 }, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA
{ 0x1F0D, CASEFL_C | 1, 0x1F05, 0, 0 }, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA
{ 0x1F0E, CASEFL_C | 1, 0x1F06, 0, 0 }, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI
{ 0x1F0F, CASEFL_C | 1, 0x1F07, 0, 0 }, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI
{ 0x1F18, CASEFL_C | 1, 0x1F10, 0, 0 }, // GREEK CAPITAL LETTER EPSILON WITH PSILI
{ 0x1F19, CASEFL_C | 1, 0x1F11, 0, 0 }, // GREEK CAPITAL LETTER EPSILON WITH DASIA
{ 0x1F1A, CASEFL_C | 1, 0x1F12, 0, 0 }, // GREEK CAPITAL LETTER EPSILON WITH PSILI AND VARIA
{ 0x1F1B, CASEFL_C | 1, 0x1F13, 0, 0 }, // GREEK CAPITAL LETTER EPSILON WITH DASIA AND VARIA
{ 0x1F1C, CASEFL_C | 1, 0x1F14, 0, 0 }, // GREEK CAPITAL LETTER EPSILON WITH PSILI AND OXIA
{ 0x1F1D, CASEFL_C | 1, 0x1F15, 0, 0 }, // GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
{ 0x1F28, CASEFL_C | 1, 0x1F20, 0, 0 }, // GREEK CAPITAL LETTER ETA WITH PSILI
{ 0x1F29, CASEFL_C | 1, 0x1F21, 0, 0 }, // GREEK CAPITAL LETTER ETA WITH DASIA
{ 0x1F2A, CASEFL_C | 1, 0x1F22, 0, 0 }, // GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA
{ 0x1F2B, CASEFL_C | 1, 0x1F23, 0, 0 }, // GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA
{ 0x1F2C, CASEFL_C | 1, 0x1F24, 0, 0 }, // GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA
{ 0x1F2D, CASEFL_C | 1, 0x1F25, 0, 0 }, // GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA
{ 0x1F2E, CASEFL_C | 1, 0x1F26, 0, 0 }, // GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI
{ 0x1F2F, CASEFL_C | 1, 0x1F27, 0, 0 }, // GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI
{ 0x1F38, CASEFL_C | 1, 0x1F30, 0, 0 }, // GREEK CAPITAL LETTER IOTA WITH PSILI
{ 0x1F39, CASEFL_C | 1, 0x1F31, 0, 0 }, // GREEK CAPITAL LETTER IOTA WITH DASIA
{ 0x1F3A, CASEFL_C | 1, 0x1F32, 0, 0 }, // GREEK CAPITAL LETTER IOTA WITH PSILI AND VARIA
{ 0x1F3B, CASEFL_C | 1, 0x1F33, 0, 0 }, // GREEK CAPITAL LETTER IOTA WITH DASIA AND VARIA
{ 0x1F3C, CASEFL_C | 1, 0x1F34, 0, 0 }, // GREEK CAPITAL LETTER IOTA WITH PSILI AND OXIA
{ 0x1F3D, CASEFL_C | 1, 0x1F35, 0, 0 }, // GREEK CAPITAL LETTER IOTA WITH DASIA AND OXIA
{ 0x1F3E, CASEFL_C | 1, 0x1F36, 0, 0 }, // GREEK CAPITAL LETTER IOTA WITH PSILI AND PERISPOMENI
{ 0x1F3F, CASEFL_C | 1, 0x1F37, 0, 0 }, // GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI
{ 0x1F48, CASEFL_C | 1, 0x1F40, 0, 0 }, // GREEK CAPITAL LETTER OMICRON WITH PSILI
{ 0x1F49, CASEFL_C | 1, 0x1F41, 0, 0 }, // GREEK CAPITAL LETTER OMICRON WITH DASIA
{ 0x1F4A, CASEFL_C | 1, 0x1F42, 0, 0 }, // GREEK CAPITAL LETTER OMICRON WITH PSILI AND VARIA
{ 0x1F4B, CASEFL_C | 1, 0x1F43, 0, 0 }, // GREEK CAPITAL LETTER OMICRON WITH DASIA AND VARIA
{ 0x1F4C, CASEFL_C | 1, 0x1F44, 0, 0 }, // GREEK CAPITAL LETTER OMICRON WITH PSILI AND OXIA
{ 0x1F4D, CASEFL_C | 1, 0x1F45, 0, 0 }, // GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
{ 0x1F50, CASEFL_F | 2, 0x03C5, 0x0313, 0 }, // GREEK SMALL LETTER UPSILON WITH PSILI
{ 0x1F52, CASEFL_F | 3, 0x03C5, 0x0313, 0x0300 }, // GREEK SMALL LETTER UPSILON WITH PSILI AND VARIA
{ 0x1F54, CASEFL_F | 3, 0x03C5, 0x0313, 0x0301 }, // GREEK SMALL LETTER UPSILON WITH PSILI AND OXIA
{ 0x1F56, CASEFL_F | 3, 0x03C5, 0x0313, 0x0342 }, // GREEK SMALL LETTER UPSILON WITH PSILI AND PERISPOMENI
{ 0x1F59, CASEFL_C | 1, 0x1F51, 0, 0 }, // GREEK CAPITAL LETTER UPSILON WITH DASIA
{ 0x1F5B, CASEFL_C | 1, 0x1F53, 0, 0 }, // GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
{ 0x1F5D, CASEFL_C | 1, 0x1F55, 0, 0 }, // GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
{ 0x1F5F, CASEFL_C | 1, 0x1F57, 0, 0 }, // GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI
{ 0x1F68, CASEFL_C | 1, 0x1F60, 0, 0 }, // GREEK CAPITAL LETTER OMEGA WITH PSILI
{ 0x1F69, CASEFL_C | 1, 0x1F61, 0, 0 }, // GREEK CAPITAL LETTER OMEGA WITH DASIA
{ 0x1F6A, CASEFL_C | 1, 0x1F62, 0, 0 }, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA
{ 0x1F6B, CASEFL_C | 1, 0x1F63, 0, 0 }, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA
{ 0x1F6C, CASEFL_C | 1, 0x1F64, 0, 0 }, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA
{ 0x1F6D, CASEFL_C | 1, 0x1F65, 0, 0 }, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA
{ 0x1F6E, CASEFL_C | 1, 0x1F66, 0, 0 }, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI
{ 0x1F6F, CASEFL_C | 1, 0x1F67, 0, 0 }, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI
{ 0x1F80, CASEFL_F | 2, 0x1F00, 0x03B9, 0 }, // GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI
{ 0x1F81, CASEFL_F | 2, 0x1F01, 0x03B9, 0 }, // GREEK SMALL LETTER ALPHA WITH DASIA AND YPOGEGRAMMENI
{ 0x1F82, CASEFL_F | 2, 0x1F02, 0x03B9, 0 }, // GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA AND YPOGEGRAMMENI
{ 0x1F83, CASEFL_F | 2, 0x1F03, 0x03B9, 0 }, // GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA AND YPOGEGRAMMENI
{ 0x1F84, CASEFL_F | 2, 0x1F04, 0x03B9, 0 }, // GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA AND YPOGEGRAMMENI
{ 0x1F85, CASEFL_F | 2, 0x1F05, 0x03B9, 0 }, // GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA AND YPOGEGRAMMENI
{ 0x1F86, CASEFL_F | 2, 0x1F06, 0x03B9, 0 }, // GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
{ 0x1F87, CASEFL_F | 2, 0x1F07, 0x03B9, 0 }, // GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
{ 0x1F88, CASEFL_F | 2, 0x1F00, 0x03B9, 0 }, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI
{ 0x1F88, CASEFL_S | 1, 0x1F80, 0, 0 }, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI
{ 0x1F89, CASEFL_F | 2, 0x1F01, 0x03B9, 0 }, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENI
{ 0x1F89, CASEFL_S | 1, 0x1F81, 0, 0 }, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENI
{ 0x1F8A, CASEFL_F | 2, 0x1F02, 0x03B9, 0 }, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI
{ 0x1F8A, CASEFL_S | 1, 0x1F82, 0, 0 }, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI
{ 0x1F8B, CASEFL_F | 2, 0x1F03, 0x03B9, 0 }, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI
{ 0x1F8B, CASEFL_S | 1, 0x1F83, 0, 0 }, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI
{ 0x1F8C, CASEFL_F | 2, 0x1F04, 0x03B9, 0 }, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI
{ 0x1F8C, CASEFL_S | 1, 0x1F84, 0, 0 }, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI
{ 0x1F8D, CASEFL_F | 2, 0x1F05, 0x03B9, 0 }, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI
{ 0x1F8D, CASEFL_S | 1, 0x1F85, 0, 0 }, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI
{ 0x1F8E, CASEFL_F | 2, 0x1F06, 0x03B9, 0 }, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
{ 0x1F8E, CASEFL_S | 1, 0x1F86, 0, 0 }, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
{ 0x1F8F, CASEFL_F | 2, 0x1F07, 0x03B9, 0 }, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
{ 0x1F8F, CASEFL_S | 1, 0x1F87, 0, 0 }, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
{ 0x1F90, CASEFL_F | 2, 0x1F20, 0x03B9, 0 }, // GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI
{ 0x1F91, CASEFL_F | 2, 0x1F21, 0x03B9, 0 }, // GREEK SMALL LETTER ETA WITH DASIA AND YPOGEGRAMMENI
{ 0x1F92, CASEFL_F | 2, 0x1F22, 0x03B9, 0 }, // GREEK SMALL LETTER ETA WITH PSILI AND VARIA AND YPOGEGRAMMENI
{ 0x1F93, CASEFL_F | 2, 0x1F23, 0x03B9, 0 }, // GREEK SMALL LETTER ETA WITH DASIA AND VARIA AND YPOGEGRAMMENI
{ 0x1F94, CASEFL_F | 2, 0x1F24, 0x03B9, 0 }, // GREEK SMALL LETTER ETA WITH PSILI AND OXIA AND YPOGEGRAMMENI
{ 0x1F95, CASEFL_F | 2, 0x1F25, 0x03B9, 0 }, // GREEK SMALL LETTER ETA WITH DASIA AND OXIA AND YPOGEGRAMMENI
{ 0x1F96, CASEFL_F | 2, 0x1F26, 0x03B9, 0 }, // GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
{ 0x1F97, CASEFL_F | 2, 0x1F27, 0x03B9, 0 }, // GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
{ 0x1F98, CASEFL_F | 2, 0x1F20, 0x03B9, 0 }, // GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI
{ 0x1F98, CASEFL_S | 1, 0x1F90, 0, 0 }, // GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI
{ 0x1F99, CASEFL_F | 2, 0x1F21, 0x03B9, 0 }, // GREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENI
{ 0x1F99, CASEFL_S | 1, 0x1F91, 0, 0 }, // GREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENI
{ 0x1F9A, CASEFL_F | 2, 0x1F22, 0x03B9, 0 }, // GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI
{ 0x1F9A, CASEFL_S | 1, 0x1F92, 0, 0 }, // GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI
{ 0x1F9B, CASEFL_F | 2, 0x1F23, 0x03B9, 0 }, // GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI
{ 0x1F9B, CASEFL_S | 1, 0x1F93, 0, 0 }, // GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI
{ 0x1F9C, CASEFL_F | 2, 0x1F24, 0x03B9, 0 }, // GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI
{ 0x1F9C, CASEFL_S | 1, 0x1F94, 0, 0 }, // GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI
{ 0x1F9D, CASEFL_F | 2, 0x1F25, 0x03B9, 0 }, // GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI
{ 0x1F9D, CASEFL_S | 1, 0x1F95, 0, 0 }, // GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI
{ 0x1F9E, CASEFL_F | 2, 0x1F26, 0x03B9, 0 }, // GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
{ 0x1F9E, CASEFL_S | 1, 0x1F96, 0, 0 }, // GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
{ 0x1F9F, CASEFL_F | 2, 0x1F27, 0x03B9, 0 }, // GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
{ 0x1F9F, CASEFL_S | 1, 0x1F97, 0, 0 }, // GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
{ 0x1FA0, CASEFL_F | 2, 0x1F60, 0x03B9, 0 }, // GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI
{ 0x1FA1, CASEFL_F | 2, 0x1F61, 0x03B9, 0 }, // GREEK SMALL LETTER OMEGA WITH DASIA AND YPOGEGRAMMENI
{ 0x1FA2, CASEFL_F | 2, 0x1F62, 0x03B9, 0 }, // GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA AND YPOGEGRAMMENI
{ 0x1FA3, CASEFL_F | 2, 0x1F63, 0x03B9, 0 }, // GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA AND YPOGEGRAMMENI
{ 0x1FA4, CASEFL_F | 2, 0x1F64, 0x03B9, 0 }, // GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA AND YPOGEGRAMMENI
{ 0x1FA5, CASEFL_F | 2, 0x1F65, 0x03B9, 0 }, // GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA AND YPOGEGRAMMENI
{ 0x1FA6, CASEFL_F | 2, 0x1F66, 0x03B9, 0 }, // GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
{ 0x1FA7, CASEFL_F | 2, 0x1F67, 0x03B9, 0 }, // GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
{ 0x1FA8, CASEFL_F | 2, 0x1F60, 0x03B9, 0 }, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI
{ 0x1FA8, CASEFL_S | 1, 0x1FA0, 0, 0 }, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI
{ 0x1FA9, CASEFL_F | 2, 0x1F61, 0x03B9, 0 }, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI
{ 0x1FA9, CASEFL_S | 1, 0x1FA1, 0, 0 }, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI
{ 0x1FAA, CASEFL_F | 2, 0x1F62, 0x03B9, 0 }, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI
{ 0x1FAA, CASEFL_S | 1, 0x1FA2, 0, 0 }, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI
{ 0x1FAB, CASEFL_F | 2, 0x1F63, 0x03B9, 0 }, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI
{ 0x1FAB, CASEFL_S | 1, 0x1FA3, 0, 0 }, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI
{ 0x1FAC, CASEFL_F | 2, 0x1F64, 0x03B9, 0 }, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI
{ 0x1FAC, CASEFL_S | 1, 0x1FA4, 0, 0 }, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI
{ 0x1FAD, CASEFL_F | 2, 0x1F65, 0x03B9, 0 }, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI
{ 0x1FAD, CASEFL_S | 1, 0x1FA5, 0, 0 }, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI
{ 0x1FAE, CASEFL_F | 2, 0x1F66, 0x03B9, 0 }, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
{ 0x1FAE, CASEFL_S | 1, 0x1FA6, 0, 0 }, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
{ 0x1FAF, CASEFL_F | 2, 0x1F67, 0x03B9, 0 }, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
{ 0x1FAF, CASEFL_S | 1, 0x1FA7, 0, 0 }, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
{ 0x1FB2, CASEFL_F | 2, 0x1F70, 0x03B9, 0 }, // GREEK SMALL LETTER ALPHA WITH VARIA AND YPOGEGRAMMENI
{ 0x1FB3, CASEFL_F | 2, 0x03B1, 0x03B9, 0 }, // GREEK SMALL LETTER ALPHA WITH YPOGEGRAMMENI
{ 0x1FB4, CASEFL_F | 2, 0x03AC, 0x03B9, 0 }, // GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
{ 0x1FB6, CASEFL_F | 2, 0x03B1, 0x0342, 0 }, // GREEK SMALL LETTER ALPHA WITH PERISPOMENI
{ 0x1FB7, CASEFL_F | 3, 0x03B1, 0x0342, 0x03B9 }, // GREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENI
{ 0x1FB8, CASEFL_C | 1, 0x1FB0, 0, 0 }, // GREEK CAPITAL LETTER ALPHA WITH VRACHY
{ 0x1FB9, CASEFL_C | 1, 0x1FB1, 0, 0 }, // GREEK CAPITAL LETTER ALPHA WITH MACRON
{ 0x1FBA, CASEFL_C | 1, 0x1F70, 0, 0 }, // GREEK CAPITAL LETTER ALPHA WITH VARIA
{ 0x1FBB, CASEFL_C | 1, 0x1F71, 0, 0 }, // GREEK CAPITAL LETTER ALPHA WITH OXIA
{ 0x1FBC, CASEFL_F | 2, 0x03B1, 0x03B9, 0 }, // GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
{ 0x1FBC, CASEFL_S | 1, 0x1FB3, 0, 0 }, // GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
{ 0x1FBE, CASEFL_C | 1, 0x03B9, 0, 0 }, // GREEK PROSGEGRAMMENI
{ 0x1FC2, CASEFL_F | 2, 0x1F74, 0x03B9, 0 }, // GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI
{ 0x1FC3, CASEFL_F | 2, 0x03B7, 0x03B9, 0 }, // GREEK SMALL LETTER ETA WITH YPOGEGRAMMENI
{ 0x1FC4, CASEFL_F | 2, 0x03AE, 0x03B9, 0 }, // GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
{ 0x1FC6, CASEFL_F | 2, 0x03B7, 0x0342, 0 }, // GREEK SMALL LETTER ETA WITH PERISPOMENI
{ 0x1FC7, CASEFL_F | 3, 0x03B7, 0x0342, 0x03B9 }, // GREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENI
{ 0x1FC8, CASEFL_C | 1, 0x1F72, 0, 0 }, // GREEK CAPITAL LETTER EPSILON WITH VARIA
{ 0x1FC9, CASEFL_C | 1, 0x1F73, 0, 0 }, // GREEK CAPITAL LETTER EPSILON WITH OXIA
{ 0x1FCA, CASEFL_C | 1, 0x1F74, 0, 0 }, // GREEK CAPITAL LETTER ETA WITH VARIA
{ 0x1FCB, CASEFL_C | 1, 0x1F75, 0, 0 }, // GREEK CAPITAL LETTER ETA WITH OXIA
{ 0x1FCC, CASEFL_F | 2, 0x03B7, 0x03B9, 0 }, // GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
{ 0x1FCC, CASEFL_S | 1, 0x1FC3, 0, 0 }, // GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
{ 0x1FD2, CASEFL_F | 3, 0x03B9, 0x0308, 0x0300 }, // GREEK SMALL LETTER IOTA WITH DIALYTIKA AND VARIA
{ 0x1FD3, CASEFL_F | 3, 0x03B9, 0x0308, 0x0301 }, // GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
{ 0x1FD6, CASEFL_F | 2, 0x03B9, 0x0342, 0 }, // GREEK SMALL LETTER IOTA WITH PERISPOMENI
{ 0x1FD7, CASEFL_F | 3, 0x03B9, 0x0308, 0x0342 }, // GREEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENI
{ 0x1FD8, CASEFL_C | 1, 0x1FD0, 0, 0 }, // GREEK CAPITAL LETTER IOTA WITH VRACHY
{ 0x1FD9, CASEFL_C | 1, 0x1FD1, 0, 0 }, // GREEK CAPITAL LETTER IOTA WITH MACRON
{ 0x1FDA, CASEFL_C | 1, 0x1F76, 0, 0 }, // GREEK CAPITAL LETTER IOTA WITH VARIA
{ 0x1FDB, CASEFL_C | 1, 0x1F77, 0, 0 }, // GREEK CAPITAL LETTER IOTA WITH OXIA
{ 0x1FE2, CASEFL_F | 3, 0x03C5, 0x0308, 0x0300 }, // GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND VARIA
{ 0x1FE3, CASEFL_F | 3, 0x03C5, 0x0308, 0x0301 }, // GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND OXIA
{ 0x1FE4, CASEFL_F | 2, 0x03C1, 0x0313, 0 }, // GREEK SMALL LETTER RHO WITH PSILI
{ 0x1FE6, CASEFL_F | 2, 0x03C5, 0x0342, 0 }, // GREEK SMALL LETTER UPSILON WITH PERISPOMENI
{ 0x1FE7, CASEFL_F | 3, 0x03C5, 0x0308, 0x0342 }, // GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPOMENI
{ 0x1FE8, CASEFL_C | 1, 0x1FE0, 0, 0 }, // GREEK CAPITAL LETTER UPSILON WITH VRACHY
{ 0x1FE9, CASEFL_C | 1, 0x1FE1, 0, 0 }, // GREEK CAPITAL LETTER UPSILON WITH MACRON
{ 0x1FEA, CASEFL_C | 1, 0x1F7A, 0, 0 }, // GREEK CAPITAL LETTER UPSILON WITH VARIA
{ 0x1FEB, CASEFL_C | 1, 0x1F7B, 0, 0 }, // GREEK CAPITAL LETTER UPSILON WITH OXIA
{ 0x1FEC, CASEFL_C | 1, 0x1FE5, 0, 0 }, // GREEK CAPITAL LETTER RHO WITH DASIA
{ 0x1FF2, CASEFL_F | 2, 0x1F7C, 0x03B9, 0 }, // GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI
{ 0x1FF3, CASEFL_F | 2, 0x03C9, 0x03B9, 0 }, // GREEK SMALL LETTER OMEGA WITH YPOGEGRAMMENI
{ 0x1FF4, CASEFL_F | 2, 0x03CE, 0x03B9, 0 }, // GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
{ 0x1FF6, CASEFL_F | 2, 0x03C9, 0x0342, 0 }, // GREEK SMALL LETTER OMEGA WITH PERISPOMENI
{ 0x1FF7, CASEFL_F | 3, 0x03C9, 0x0342, 0x03B9 }, // GREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI
{ 0x1FF8, CASEFL_C | 1, 0x1F78, 0, 0 }, // GREEK CAPITAL LETTER OMICRON WITH VARIA
{ 0x1FF9, CASEFL_C | 1, 0x1F79, 0, 0 }, // GREEK CAPITAL LETTER OMICRON WITH OXIA
{ 0x1FFA, CASEFL_C | 1, 0x1F7C, 0, 0 }, // GREEK CAPITAL LETTER OMEGA WITH VARIA
{ 0x1FFB, CASEFL_C | 1, 0x1F7D, 0, 0 }, // GREEK CAPITAL LETTER OMEGA WITH OXIA
{ 0x1FFC, CASEFL_F | 2, 0x03C9, 0x03B9, 0 }, // GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
{ 0x1FFC, CASEFL_S | 1, 0x1FF3, 0, 0 }, // GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
{ 0x2126, CASEFL_C | 1, 0x03C9, 0, 0 }, // OHM SIGN
{ 0x212A, CASEFL_C | 1, 0x006B, 0, 0 }, // KELVIN SIGN
{ 0x212B, CASEFL_C | 1, 0x00E5, 0, 0 }, // ANGSTROM SIGN
{ 0x2160, CASEFL_C | 1, 0x2170, 0, 0 }, // ROMAN NUMERAL ONE
{ 0x2161, CASEFL_C | 1, 0x2171, 0, 0 }, // ROMAN NUMERAL TWO
{ 0x2162, CASEFL_C | 1, 0x2172, 0, 0 }, // ROMAN NUMERAL THREE
{ 0x2163, CASEFL_C | 1, 0x2173, 0, 0 }, // ROMAN NUMERAL FOUR
{ 0x2164, CASEFL_C | 1, 0x2174, 0, 0 }, // ROMAN NUMERAL FIVE
{ 0x2165, CASEFL_C | 1, 0x2175, 0, 0 }, // ROMAN NUMERAL SIX
{ 0x2166, CASEFL_C | 1, 0x2176, 0, 0 }, // ROMAN NUMERAL SEVEN
{ 0x2167, CASEFL_C | 1, 0x2177, 0, 0 }, // ROMAN NUMERAL EIGHT
{ 0x2168, CASEFL_C | 1, 0x2178, 0, 0 }, // ROMAN NUMERAL NINE
{ 0x2169, CASEFL_C | 1, 0x2179, 0, 0 }, // ROMAN NUMERAL TEN
{ 0x216A, CASEFL_C | 1, 0x217A, 0, 0 }, // ROMAN NUMERAL ELEVEN
{ 0x216B, CASEFL_C | 1, 0x217B, 0, 0 }, // ROMAN NUMERAL TWELVE
{ 0x216C, CASEFL_C | 1, 0x217C, 0, 0 }, // ROMAN NUMERAL FIFTY
{ 0x216D, CASEFL_C | 1, 0x217D, 0, 0 }, // ROMAN NUMERAL ONE HUNDRED
{ 0x216E, CASEFL_C | 1, 0x217E, 0, 0 }, // ROMAN NUMERAL FIVE HUNDRED
{ 0x216F, CASEFL_C | 1, 0x217F, 0, 0 }, // ROMAN NUMERAL ONE THOUSAND
{ 0x24B6, CASEFL_C | 1, 0x24D0, 0, 0 }, // CIRCLED LATIN CAPITAL LETTER A
{ 0x24B7, CASEFL_C | 1, 0x24D1, 0, 0 }, // CIRCLED LATIN CAPITAL LETTER B
{ 0x24B8, CASEFL_C | 1, 0x24D2, 0, 0 }, // CIRCLED LATIN CAPITAL LETTER C
{ 0x24B9, CASEFL_C | 1, 0x24D3, 0, 0 }, // CIRCLED LATIN CAPITAL LETTER D
{ 0x24BA, CASEFL_C | 1, 0x24D4, 0, 0 }, // CIRCLED LATIN CAPITAL LETTER E
{ 0x24BB, CASEFL_C | 1, 0x24D5, 0, 0 }, // CIRCLED LATIN CAPITAL LETTER F
{ 0x24BC, CASEFL_C | 1, 0x24D6, 0, 0 }, // CIRCLED LATIN CAPITAL LETTER G
{ 0x24BD, CASEFL_C | 1, 0x24D7, 0, 0 }, // CIRCLED LATIN CAPITAL LETTER H
{ 0x24BE, CASEFL_C | 1, 0x24D8, 0, 0 }, // CIRCLED LATIN CAPITAL LETTER I
{ 0x24BF, CASEFL_C | 1, 0x24D9, 0, 0 }, // CIRCLED LATIN CAPITAL LETTER J
{ 0x24C0, CASEFL_C | 1, 0x24DA, 0, 0 }, // CIRCLED LATIN CAPITAL LETTER K
{ 0x24C1, CASEFL_C | 1, 0x24DB, 0, 0 }, // CIRCLED LATIN CAPITAL LETTER L
{ 0x24C2, CASEFL_C | 1, 0x24DC, 0, 0 }, // CIRCLED LATIN CAPITAL LETTER M
{ 0x24C3, CASEFL_C | 1, 0x24DD, 0, 0 }, // CIRCLED LATIN CAPITAL LETTER N
{ 0x24C4, CASEFL_C | 1, 0x24DE, 0, 0 }, // CIRCLED LATIN CAPITAL LETTER O
{ 0x24C5, CASEFL_C | 1, 0x24DF, 0, 0 }, // CIRCLED LATIN CAPITAL LETTER P
{ 0x24C6, CASEFL_C | 1, 0x24E0, 0, 0 }, // CIRCLED LATIN CAPITAL LETTER Q
{ 0x24C7, CASEFL_C | 1, 0x24E1, 0, 0 }, // CIRCLED LATIN CAPITAL LETTER R
{ 0x24C8, CASEFL_C | 1, 0x24E2, 0, 0 }, // CIRCLED LATIN CAPITAL LETTER S
{ 0x24C9, CASEFL_C | 1, 0x24E3, 0, 0 }, // CIRCLED LATIN CAPITAL LETTER T
{ 0x24CA, CASEFL_C | 1, 0x24E4, 0, 0 }, // CIRCLED LATIN CAPITAL LETTER U
{ 0x24CB, CASEFL_C | 1, 0x24E5, 0, 0 }, // CIRCLED LATIN CAPITAL LETTER V
{ 0x24CC, CASEFL_C | 1, 0x24E6, 0, 0 }, // CIRCLED LATIN CAPITAL LETTER W
{ 0x24CD, CASEFL_C | 1, 0x24E7, 0, 0 }, // CIRCLED LATIN CAPITAL LETTER X
{ 0x24CE, CASEFL_C | 1, 0x24E8, 0, 0 }, // CIRCLED LATIN CAPITAL LETTER Y
{ 0x24CF, CASEFL_C | 1, 0x24E9, 0, 0 }, // CIRCLED LATIN CAPITAL LETTER Z
{ 0xFB00, CASEFL_F | 2, 0x0066, 0x0066, 0 }, // LATIN SMALL LIGATURE FF
{ 0xFB01, CASEFL_F | 2, 0x0066, 0x0069, 0 }, // LATIN SMALL LIGATURE FI
{ 0xFB02, CASEFL_F | 2, 0x0066, 0x006C, 0 }, // LATIN SMALL LIGATURE FL
{ 0xFB03, CASEFL_F | 3, 0x0066, 0x0066, 0x0069 }, // LATIN SMALL LIGATURE FFI
{ 0xFB04, CASEFL_F | 3, 0x0066, 0x0066, 0x006C }, // LATIN SMALL LIGATURE FFL
{ 0xFB05, CASEFL_F | 2, 0x0073, 0x0074, 0 }, // LATIN SMALL LIGATURE LONG S T
{ 0xFB06, CASEFL_F | 2, 0x0073, 0x0074, 0 }, // LATIN SMALL LIGATURE ST
{ 0xFB13, CASEFL_F | 2, 0x0574, 0x0576, 0 }, // ARMENIAN SMALL LIGATURE MEN NOW
{ 0xFB14, CASEFL_F | 2, 0x0574, 0x0565, 0 }, // ARMENIAN SMALL LIGATURE MEN ECH
{ 0xFB15, CASEFL_F | 2, 0x0574, 0x056B, 0 }, // ARMENIAN SMALL LIGATURE MEN INI
{ 0xFB16, CASEFL_F | 2, 0x057E, 0x0576, 0 }, // ARMENIAN SMALL LIGATURE VEW NOW
{ 0xFB17, CASEFL_F | 2, 0x0574, 0x056D, 0 }, // ARMENIAN SMALL LIGATURE MEN XEH
{ 0xFF21, CASEFL_C | 1, 0xFF41, 0, 0 }, // FULLWIDTH LATIN CAPITAL LETTER A
{ 0xFF22, CASEFL_C | 1, 0xFF42, 0, 0 }, // FULLWIDTH LATIN CAPITAL LETTER B
{ 0xFF23, CASEFL_C | 1, 0xFF43, 0, 0 }, // FULLWIDTH LATIN CAPITAL LETTER C
{ 0xFF24, CASEFL_C | 1, 0xFF44, 0, 0 }, // FULLWIDTH LATIN CAPITAL LETTER D
{ 0xFF25, CASEFL_C | 1, 0xFF45, 0, 0 }, // FULLWIDTH LATIN CAPITAL LETTER E
{ 0xFF26, CASEFL_C | 1, 0xFF46, 0, 0 }, // FULLWIDTH LATIN CAPITAL LETTER F
{ 0xFF27, CASEFL_C | 1, 0xFF47, 0, 0 }, // FULLWIDTH LATIN CAPITAL LETTER G
{ 0xFF28, CASEFL_C | 1, 0xFF48, 0, 0 }, // FULLWIDTH LATIN CAPITAL LETTER H
{ 0xFF29, CASEFL_C | 1, 0xFF49, 0, 0 }, // FULLWIDTH LATIN CAPITAL LETTER I
{ 0xFF2A, CASEFL_C | 1, 0xFF4A, 0, 0 }, // FULLWIDTH LATIN CAPITAL LETTER J
{ 0xFF2B, CASEFL_C | 1, 0xFF4B, 0, 0 }, // FULLWIDTH LATIN CAPITAL LETTER K
{ 0xFF2C, CASEFL_C | 1, 0xFF4C, 0, 0 }, // FULLWIDTH LATIN CAPITAL LETTER L
{ 0xFF2D, CASEFL_C | 1, 0xFF4D, 0, 0 }, // FULLWIDTH LATIN CAPITAL LETTER M
{ 0xFF2E, CASEFL_C | 1, 0xFF4E, 0, 0 }, // FULLWIDTH LATIN CAPITAL LETTER N
{ 0xFF2F, CASEFL_C | 1, 0xFF4F, 0, 0 }, // FULLWIDTH LATIN CAPITAL LETTER O
{ 0xFF30, CASEFL_C | 1, 0xFF50, 0, 0 }, // FULLWIDTH LATIN CAPITAL LETTER P
{ 0xFF31, CASEFL_C | 1, 0xFF51, 0, 0 }, // FULLWIDTH LATIN CAPITAL LETTER Q
{ 0xFF32, CASEFL_C | 1, 0xFF52, 0, 0 }, // FULLWIDTH LATIN CAPITAL LETTER R
{ 0xFF33, CASEFL_C | 1, 0xFF53, 0, 0 }, // FULLWIDTH LATIN CAPITAL LETTER S
{ 0xFF34, CASEFL_C | 1, 0xFF54, 0, 0 }, // FULLWIDTH LATIN CAPITAL LETTER T
{ 0xFF35, CASEFL_C | 1, 0xFF55, 0, 0 }, // FULLWIDTH LATIN CAPITAL LETTER U
{ 0xFF36, CASEFL_C | 1, 0xFF56, 0, 0 }, // FULLWIDTH LATIN CAPITAL LETTER V
{ 0xFF37, CASEFL_C | 1, 0xFF57, 0, 0 }, // FULLWIDTH LATIN CAPITAL LETTER W
{ 0xFF38, CASEFL_C | 1, 0xFF58, 0, 0 }, // FULLWIDTH LATIN CAPITAL LETTER X
{ 0xFF39, CASEFL_C | 1, 0xFF59, 0, 0 }, // FULLWIDTH LATIN CAPITAL LETTER Y
{ 0xFF3A, CASEFL_C | 1, 0xFF5A, 0, 0 }, // FULLWIDTH LATIN CAPITAL LETTER Z
{ 0x10400, CASEFL_C | 1, 0x10428, 0, 0 }, // DESERET CAPITAL LETTER LONG I
{ 0x10401, CASEFL_C | 1, 0x10429, 0, 0 }, // DESERET CAPITAL LETTER LONG E
{ 0x10402, CASEFL_C | 1, 0x1042A, 0, 0 }, // DESERET CAPITAL LETTER LONG A
{ 0x10403, CASEFL_C | 1, 0x1042B, 0, 0 }, // DESERET CAPITAL LETTER LONG AH
{ 0x10404, CASEFL_C | 1, 0x1042C, 0, 0 }, // DESERET CAPITAL LETTER LONG O
{ 0x10405, CASEFL_C | 1, 0x1042D, 0, 0 }, // DESERET CAPITAL LETTER LONG OO
{ 0x10406, CASEFL_C | 1, 0x1042E, 0, 0 }, // DESERET CAPITAL LETTER SHORT I
{ 0x10407, CASEFL_C | 1, 0x1042F, 0, 0 }, // DESERET CAPITAL LETTER SHORT E
{ 0x10408, CASEFL_C | 1, 0x10430, 0, 0 }, // DESERET CAPITAL LETTER SHORT A
{ 0x10409, CASEFL_C | 1, 0x10431, 0, 0 }, // DESERET CAPITAL LETTER SHORT AH
{ 0x1040A, CASEFL_C | 1, 0x10432, 0, 0 }, // DESERET CAPITAL LETTER SHORT O
{ 0x1040B, CASEFL_C | 1, 0x10433, 0, 0 }, // DESERET CAPITAL LETTER SHORT OO
{ 0x1040C, CASEFL_C | 1, 0x10434, 0, 0 }, // DESERET CAPITAL LETTER AY
{ 0x1040D, CASEFL_C | 1, 0x10435, 0, 0 }, // DESERET CAPITAL LETTER OW
{ 0x1040E, CASEFL_C | 1, 0x10436, 0, 0 }, // DESERET CAPITAL LETTER WU
{ 0x1040F, CASEFL_C | 1, 0x10437, 0, 0 }, // DESERET CAPITAL LETTER YEE
{ 0x10410, CASEFL_C | 1, 0x10438, 0, 0 }, // DESERET CAPITAL LETTER H
{ 0x10411, CASEFL_C | 1, 0x10439, 0, 0 }, // DESERET CAPITAL LETTER PEE
{ 0x10412, CASEFL_C | 1, 0x1043A, 0, 0 }, // DESERET CAPITAL LETTER BEE
{ 0x10413, CASEFL_C | 1, 0x1043B, 0, 0 }, // DESERET CAPITAL LETTER TEE
{ 0x10414, CASEFL_C | 1, 0x1043C, 0, 0 }, // DESERET CAPITAL LETTER DEE
{ 0x10415, CASEFL_C | 1, 0x1043D, 0, 0 }, // DESERET CAPITAL LETTER CHEE
{ 0x10416, CASEFL_C | 1, 0x1043E, 0, 0 }, // DESERET CAPITAL LETTER JEE
{ 0x10417, CASEFL_C | 1, 0x1043F, 0, 0 }, // DESERET CAPITAL LETTER KAY
{ 0x10418, CASEFL_C | 1, 0x10440, 0, 0 }, // DESERET CAPITAL LETTER GAY
{ 0x10419, CASEFL_C | 1, 0x10441, 0, 0 }, // DESERET CAPITAL LETTER EF
{ 0x1041A, CASEFL_C | 1, 0x10442, 0, 0 }, // DESERET CAPITAL LETTER VEE
{ 0x1041B, CASEFL_C | 1, 0x10443, 0, 0 }, // DESERET CAPITAL LETTER ETH
{ 0x1041C, CASEFL_C | 1, 0x10444, 0, 0 }, // DESERET CAPITAL LETTER THEE
{ 0x1041D, CASEFL_C | 1, 0x10445, 0, 0 }, // DESERET CAPITAL LETTER ES
{ 0x1041E, CASEFL_C | 1, 0x10446, 0, 0 }, // DESERET CAPITAL LETTER ZEE
{ 0x1041F, CASEFL_C | 1, 0x10447, 0, 0 }, // DESERET CAPITAL LETTER ESH
{ 0x10420, CASEFL_C | 1, 0x10448, 0, 0 }, // DESERET CAPITAL LETTER ZHEE
{ 0x10421, CASEFL_C | 1, 0x10449, 0, 0 }, // DESERET CAPITAL LETTER ER
{ 0x10422, CASEFL_C | 1, 0x1044A, 0, 0 }, // DESERET CAPITAL LETTER EL
{ 0x10423, CASEFL_C | 1, 0x1044B, 0, 0 }, // DESERET CAPITAL LETTER EM
{ 0x10424, CASEFL_C | 1, 0x1044C, 0, 0 }, // DESERET CAPITAL LETTER EN
{ 0x10425, CASEFL_C | 1, 0x1044D, 0, 0 }, // DESERET CAPITAL LETTER ENG
};

