/* Sample1 */
/* Initialize RexxUtil */
rc=RxFuncAdd('SysLoadFuncs','RexxUtil','SysLoadFuncs')
Call SysLoadFuncs
/* Initialize StHealth */
rc=RxFuncAdd('StHealthLoadFuncs','StHealth','StHealthLoadFuncs')
Call StHealthLoadFuncs

/* Initialize some variables */
Do i=1 To 10
 LT.i=65536
 HT.i=0
End

/* Query version of StHealth */
FullVersion=StHealthVersion("FULL")
Version=StHealthVersion("VERSION")
BuildLevel=StHealthVersion("BUILD")
CT=StHealthChip(FULL)
Do Forever
 /* Query some values */
 Do i=1 To 10
  V.i=StHealthValue(VOLT,i)
  T.i=StHealthValue(TEMP,i)
  F.i=StHealthValue(FAN,i)
  /* Min-Max check for temperatures */
  If T.i>HT.i Then HT.i=T.i
  If T.i<LT.i Then LT.i=T.i
  /* Checking error conditions and format*/
  If T.i=-255 Then T.i="N.V./ERR    "
  Else T.i=Format(T.i,9,2)
  If V.i=-255 Then V.i="N.V./ERR    "
  Else V.i=Format(V.i,9,2)
  If F.i=-255 Then F.i="N.V./ERR    "
  Else F.i=Format(F.i,12,0)
  /* Formating items */
  HT.i=Format(HT.i,9,2)
  LT.i=Format(LT.i,9,2)
 End
 /* Clear screen */
 Call SysCls
 /* Display logo */
 Say "Sample Monitoring Script for use with StHealth.dll"
 Say "Copyright(c) 1998-2001 by Stefan Milcke"
 Say ""
 Say "Version of StHealth.DLL: "FullVersion
 Say " "
 Say "Detected Chip: "CT
 Say " "
 /* Display stored values */
 Say "-----------------------------------------------------------------------"
 Say "|Nr. | Cur. Temp. | Min. Temp. | Max. Temp. | Voltage    | Fan        |"
 Say "-----------------------------------------------------------------------"
 Do i=1 To 10
  Say "|"Format(i,4)"|"T.i"|"LT.i"|"HT.i"|"V.i"|"F.i"|"
 End
 Say "-----------------------------------------------------------------------"
 /* Sleep for a while */
 Call SysSleep(1)
End
