/*
 *      SETLANG.CMD - Wireless LAN Monitor Language Setup - Netlabs WLAN Project 2003-2008
 *
 *      Syntax: SETLANG [*|xxx]
 *
 *      This program sets the language of the Wireless LAN Monitor.
 *      This is required only if the language of the operating system
 *      is either not suported yet or not suitable for you.
 *
 *       <no parameter> - displays the language currently used
 *       *              - sets up XWLAN to uses the default language (english)
 *       xxx            - specifies the identifier of the language to be used
 */
/* The first comment is used as online help text */
/*****************Module Header *******************************
*
* Module Name: setlang.cmd
*
* Batch for to override the system language
*
* Copyright (c) WLan Project 2003
*
* $Id: setlang.cmd 1117 2016-01-23 10:17:57Z andib $
*
* ===========================================================================
*
* This file is part of the WLan Project and is free software.  You can
* redistribute it and/or modify it under the terms of the GNU Library General
* Public License as published by the Free Software Foundation, in version 2
* as it comes in the "COPYING.LIB" file of the WLan Project CVS tree.
* This library is distributed in the hope that it will be useful, but WITHOUT
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
* FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
* License for more details.
*
****************************************************************************/

 SIGNAL ON HALT

 TitleLine = STRIP(SUBSTR(SourceLine(2), 3));
 PARSE VAR TitleLine CmdName'.CMD 'Info
 Title     = CmdName Info

 env          = 'OS2ENVIRONMENT';
 TRUE         = (1 = 1);
 FALSE        = (0 = 1);
 CrLf         = '0d0a'x;
 Redirection  = '> NUL 2>&1';
 '@ECHO OFF'

 /* OS/2 Error codes */
 ERROR.NO_ERROR           =   0;
 ERROR.INVALID_FUNCTION   =   1;
 ERROR.FILE_NOT_FOUND     =   2;
 ERROR.PATH_NOT_FOUND     =   3;
 ERROR.ACCESS_DENIED      =   5;
 ERROR.NOT_ENOUGH_MEMORY  =   8;
 ERROR.INVALID_FORMAT     =  11;
 ERROR.INVALID_DATA       =  13;
 ERROR.NO_MORE_FILES      =  18;
 ERROR.WRITE_FAULT        =  29;
 ERROR.READ_FAULT         =  30;
 ERROR.GEN_FAILURE        =  31;
 ERROR.SHARING_VIOLATION  =  32;
 ERROR.INVALID_PARAMETER  =  87;
 ERROR.ENVVAR_NOT_FOUND   = 203;

 GlobalVars = 'Title CmdName CrLf env TRUE FALSE Redirection ERROR.';
 SAY;

 /* dafault values */
 GlobalVars      = GlobalVars 'CallDir IniAppName IniKeyName LanguageList';
 rc              = ERROR.NO_ERROR;
 IniAppName      = 'Wireless LAN Monitor:Properties';
 IniKeyName      = 'ForceLanguage';
 fLanguageSet    = FALSE;

 LanguageList    = 'eng deu sve ita nld';

 /* eventually show help */
 ARG Parm .
 IF (POS('/?', Parm) > 0) THEN
 DO
    rc = ShowHelp();
    EXIT( ERROR.INVALID_PARAMETER);
 END;

 DO 1
    SAY Title;
    SAY;

    /* check parm */
    PARSE ARG Parm;
    Language = STRIP( LOWER( Parm));

    /* determine the language currently used */
    PARSE VALUE SysIni( , IniAppName, IniKeyName) WITH CurrentLanguage'0'x;
    IF (CurrentLanguage == 'ERROR:') THEN
       CurrentLanguage = '*';

/*       WHEN (STRIP( Parm) = '/?') THEN        // 20160123 AB changed to show always help, quick hack for ticket #31
       DO 
          SAY;  */
          SAY 'Set language for Wireless LAN Monitor';
          SAY;
          SAY 'Syntax: setlang [*|xxx]'
          SAY;
          SAY '   no parameter - displays current language'
          SAY '   *   - sets default language (english)';
          SAY '   xxx - specifies language identifier';
          SAY '         valid identifiers are:' LanguageList;
          SAY;
/*          LEAVE;
       END*/
       
    SELECT
       WHEN (Language = '') THEN
       DO
          IF (CurrentLanguage == '*') THEN
             SAY 'using default language ('WORD( LanguageList, 1)')';
          ELSE
             SAY 'using language:' CurrentLanguage;
          LEAVE;
       END;

       WHEN (Language = '*') THEN
          rc = SetAppLanguage( Language, CurrentLanguage);

       WHEN (LENGTH( Language) \= 3) THEN
       DO
          SAY 'error: invalid language identifier specified.';
          rc = 87; /* ERROR_INVALID_PARAMETER */
       END;

       OTHERWISE
          rc = SetAppLanguage( Language, CurrentLanguage);

    END;

 END;

 RETURN( rc)

/* ------------------------------------------------------------------------- */
ShowHelp: PROCEDURE EXPOSE (GlobalVars)

 /* show title */
 SAY Title;
 SAY;

 PARSE SOURCE . . ThisFile

 /* skip header */
 DO i = 1 TO 3
    rc = LINEIN(ThisFile);
 END;

 /* show help text */
 ThisLine = LINEIN(Thisfile);
 DO WHILE (ThisLine \= ' */')
    SAY SUBSTR(ThisLine, 7);
    ThisLine = LINEIN(Thisfile);
 END;

 /* close file */
 rc = LINEOUT(Thisfile);

 SAY '         valid language Identifiers are:' LanguageList

 RETURN('');

/* ------------------------------------------------------------------------- */
LOWER: PROCEDURE

 Lower = 'abcdefghijklmnopqrstuvwxyz';
 Upper = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';

 PARSE ARG String
 RETURN(TRANSLATE(String, Lower, Upper));

/* ------------------------------------------------------------------------- */
SetAppLanguage: PROCEDURE EXPOSE (GlobalVars)
 PARSE ARG NewLanguage, CurrentLanguage;

 rc  = ERROR.NO_ERROR;

 DO 1
    /* cheeck if already set */
    IF (NewLanguage = CurrentLanguage) THEN
    DO
       SAY 'warning: selected language already set.'
       LEAVE;
    END;

    SELECT
       WHEN (NewLanguage = '*') THEN
       DO
          rcx = SysIni( , IniAppName, IniKeyName, 'DELETE:');
          fResult = TRUE;
          NewLanguage = 'default ('WORD( LanguageList, 1)')';
       END;

       OTHERWISE
       DO
          rcx = SysIni(  , IniAppName, IniKeyName, NewLanguage'0'x);
          PARSE VALUE SysIni( , IniAppName, IniKeyName) WITH Language'0'x;
          fResult = (Language <> 'ERROR:');
       END;
    END;

    /* check result */
    IF (fResult) THEN
    DO
       /* display note on app restart */
       SAY 'setting language to:' NewLanguage;
       SAY;
       SAY 'Restart the Wireless LAN Monitor to make the change active.';
    END;
    ELSE
    DO
       SAY 'error setting language !';
       rc = ERROR.GEN_FAILURE;
    END;

 END;

 RETURN( rc);

