/*****************Module Header *******************************
*
* Module Name: xwlanrx.cmd
*
* Wireless LAN Monitor REXX sample script
*
* Rename this file to xwlan.cmd and palce it into the script
* directory to have it executed on (dis)connect events
*
* See the online help of the Wireless LAN Monitor for further details!
*
* Copyright (c) WLan Project 2004
*
* $Id: xwlanrx.cmd,v 1.1 2004/11/24 21:23:53 cla Exp $
*
* ===========================================================================
*
* This file is part of the WLan Project and is free software.  You can
* redistribute it and/or modify it under the terms of the GNU Library General
* Public License as published by the Free Software Foundation, in version 2
* as it comes in the "COPYING.LIB" file of the WLan Project CVS tree.
* This library is distributed in the hope that it will be useful, but WITHOUT
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
* FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
* License for more details.
*
****************************************************************************/

 /* save environment and current directory */
 CALL SETLOCAL

 /* echo the event to have it in the logfile */
 SAY  "EVENT       =" WLan._Event;
 SAY  "PROFILENAME =" WLan._Profilename;

 /* check for                       */
 /* - the access point connected to */
 /* - the event                     */

 ActionCode = WLan._Ssid'_'WLan._Event;

 SELECT

    WHEN (ActionCode = 'Netlabs_CONNECT') THEN
    DO
       SAY 'Connected to Netlabs access point !';
    END;

    WHEN (ActionCode = 'Netlabs_DISCONNECT') THEN
    DO
       SAY 'Disconnected from Netlabs access point !';
    END;

    OTHERWISE
    DO
       SAY 'No action taken on event for access point:' WLan._Ssid;
    END;

 END;

 /* reset environment and current directory */
 CALL ENDLOCAL

