@ECHO OFF
:*****************Module Header *******************************
:
: Module Name: wlancmd.cmd
:
: Wireless LAN Monitor CMD sample script
:
: Rename this file to xwlan.cmd and palce it into the script
: directory to have it executed on (dis)connect events
:
: See the online help of the Wireless LAN Monitor for further details!
:
: Copyright (c) WLan Project 2004
:
: $Id: xwlancmd.cmd,v 1.1 2004/11/24 21:23:53 cla Exp $
:
: ===========================================================================
:
: This file is part of the WLan Project and is free software.  You can
: redistribute it and/or modify it under the terms of the GNU Library General
: Public License as published by the Free Software Foundation, in version 2
: as it comes in the "COPYING.LIB" file of the WLan Project CVS tree.
: This library is distributed in the hope that it will be useful, but WITHOUT
: ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
: FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
: License for more details.
:
:****************************************************************************

: ------------- save environment and current directory
:
: NOTE:
:  - in opposite to their REXX counterparts, the CMD commands
:    SETLOCAL and ENDLOCAL cannot be nested!
:  - when ENDLOCAL is not executed, CMD.EXE executes it 
:    implicitely at the end of a script!
:  - when calling another CMD script from here, this script
:    already will execute an ENDLOCAL (explicitely or inplicitely)

 SETLOCAL

: ------------- echo the event to have it in the logfile

 ECHO EVENT       = %WLAN_EVENT%
 ECHO PROFILENAME = %WLAN_PROFILENAME%

: ------------- check for the access point connected to
: NOTE:
: - if the SSID is not handled by the script, because it does
:   not exist as a batch label, the script aborts with an error message.
:   This is less overhead than checking every single name explicitely here.

 IF .%WLAN_SSID% == . GOTO end
 GOTO %WLAN_SSID%

: ------------- connect and disconncet code for specific access points
: NOTE:
: - the System Service Identifier is case sensitive !!!
: - CMD.EXE distincts batch labes only for the first eight characters,
:   so we have to abbreviate the SSID to the shortest possible name
:   (maximum seven characters), here we use "N_"

:Netlabs
 GOTO N_%WLAN_EVENT%

:N_CONNECT
 ECHO Connected to Netlabs access point !
 GOTO end

:N_DISCONNECT
 ECHO Disconnected from Netlabs access point !
 GOTO end

:end

: ------------- reset environment and current directory
 ENDLOCAL

