/* script to display a file */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* arguments: filename   name of file to be displayed
              startline  line of file to start with (1 means from beginning)
              nrOfLines  nr of lines to display (-1 means all) 
	      showtime   0 forever, >0 time in secs, < 0 count 
              color      default is blue
              key        optional: Key for ticker */

arg filename startline nrOfLines showtime color

if ((startline = 0) | (startline = '')) then startline = 1
if (nrOfLines = '') then nrOfLines = -1
if (showtime = '') then showtime = -1
if (color = '') then color = 'blue'
if (key = '') then key = 'SHOWFILE'

/* call addTicker ' 'filename':'startline':'nrOfLines':'showtime'  ', DEBUG1, -3, black */

actline = 0

do while lines(filename) 

  actline = actline + 1; 
  aline = linein(filename)

  /* check if message should be shown*/
  if ( \(startline > actline)) then 
  do
    if ((nrOfLines = -1) | (actline < (startline + nrOfLines)) ) then
    do
      call addTicker aline'   ', key actline, showtime, color
    end
  end
end

exit


