/****************************************************************************
 *                             S Y S T R A Y / 2                            *
 *                         System TRAY sample source                        *
 *                                                                          *
 * (C) 2000, Russian Team OS/2.                        All Rights Reserved  *
 * Written by Dmitry Zaharov                http://os2.ru/projects/systray  *
 ****************************************************************************/

#define INCL_WINSTDDRAG
#define INCL_GPI
#define __IMPLEMENTATION__
#include "trayapi.h" /* API library */

//-----------------------------------------
// Definitions
//-----------------------------------------

/* Error codes */
#define ERR_INIT_FAILED                 -100
#define ERR_CREATEMSGQUEUE_FAILED       -101
#define ERR_REGISTER_FAILED             -102
#define ERR_CREATEWIN_FAILED            -103
#define ERR_LOADMENU_FAILED             -104
#define ERR_LOADPTR_FAILED              -105

/* Icon resources start */
#define ICON_RES_START              100

//-----------------------------------------
// Declarations
//-----------------------------------------

MRESULT EXPENTRY windowproc(HWND, ULONG, MPARAM, MPARAM);

//-----------------------------------------
// Static variables
//-----------------------------------------

HAB  hab = 0;
HWND hwndFrame  = 0;
HWND hwndClient = 0;
HWND hwndMenu   = 0;
HPOINTER hIcon[5] ;

static CHAR szClass [] = "Tray Example" ;

int main()
{
    ULONG fl =
            FCF_SIZEBORDER    |
            FCF_TASKLIST      |
            FCF_ICON          |
            FCF_TITLEBAR      |
            FCF_SYSMENU       |
            FCF_MINMAX        |
            FCF_SHELLPOSITION |
            0;

    HMQ hmq = 0;
    QMSG qmsg;
    LONG i;
    int rc = 0;

    do
    {
        hab = WinInitialize(0);

    	if(!hab)
        {
            rc = ERR_INIT_FAILED;
            break;
        }

        hmq = WinCreateMsgQueue(hab, 0);

        if(!hmq)
        {
            rc = ERR_CREATEMSGQUEUE_FAILED;
            break;
        }

        rc = WinRegisterClass(hab, (PSZ)szClass, (PFNWP)windowproc,
                              CS_SIZEREDRAW, 0);

        if(rc != TRUE)
        {
            rc = ERR_REGISTER_FAILED;
            break;
        }

        rc = 0;

        hwndFrame = WinCreateStdWindow(HWND_DESKTOP, WS_VISIBLE,
                    	                &fl, (PSZ)szClass, (PSZ)szClass,
                                        0, 0, 100, &hwndClient);

        if(!hwndFrame)
        {
            rc = ERR_CREATEWIN_FAILED;
            break;
        }

        hwndMenu = WinLoadMenu(hwndFrame, 0, 100);

        if(!hwndMenu)
        {
            rc = ERR_LOADMENU_FAILED;
            break;
        }

        for(i = 0; i <= 4; i++)
        {
            hIcon[i] = WinLoadPointer(HWND_DESKTOP, 0, i + ICON_RES_START);

            if(!hIcon[i])
            {
                rc = ERR_LOADPTR_FAILED;
                break;
            }
        }

        if(rc)
            break;

        while(WinGetMsg (hab, &qmsg, 0, 0, 0))
            WinDispatchMsg (hab, &qmsg);

    }
    while(0);

    WinDestroyWindow(hwndFrame);
    WinDestroyMsgQueue (hmq);
    WinTerminate (hab);

    return rc;
}

MRESULT EXPENTRY windowproc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    HPS    hps;
    RECTL  rcl;
    POINTL ptl;

	static BOOL  bauto = FALSE;
	static SHORT a = 0 ;
	static CHAR  szTextMessage[]="Hello, world!" ; /* (c) 1978 K. & R. */

	switch(msg)
	{
    	/* control tray icon specific messages */
    	case WM_TIMER:
            a++;
            a %= 5;

            if(bauto)
        	{
                WinSendMsg(hwndFrame, WM_SETICON, (MPARAM)hIcon[a], 0);
                ChangeTrayIcon(hwnd, 0);
        	}
            break;

        case WM_BUTTON2CLICK | 0x2000:

            WinQueryPointerPos(HWND_DESKTOP, &ptl); // gets mouse pointer coordinates
            WinMapWindowPoints(HWND_DESKTOP, hwnd , &ptl, 1); //Maps coordinates from desktop to client window
        	WinPopupMenu(hwnd, hwnd, hwndMenu, ptl.x, ptl.y, 0, // Shows Pop-up menu.
                        	                PU_HCONSTRAIN   | // Constrain menu horizontally.
                        	                PU_VCONSTRAIN   | // Constrain menu verticaly.
                        	                PU_MOUSEBUTTON1 | //Use menu with mouse button 1
                        	                PU_MOUSEBUTTON2 | //Use menu with mouse button 2
                        	                PU_KEYBOARD      //Use menu with keyboard
                        	                );
            break;

    	case WM_BUTTON1CLICK | 0x2000:
            a++;
            a %= 5;

            WinSendMsg(hwndFrame,WM_SETICON,(MPARAM)hIcon[a], 0);
            ChangeTrayIcon(hwnd, 0);
        	break;

    	case WM_COMMAND:
            switch((SHORT)mp1)
            {
            	case 101: // Auto
                	WinSendMsg (hwndMenu, MM_SETITEMATTR,
        	                    MPFROM2SHORT(101, 1),
                                MPFROM2SHORT(MIA_CHECKED,
                                             bauto ? 0 : MIA_CHECKED));

                    bauto = !bauto;

                    /* FALL TROUGH */

            	case 102: // Change
                    a++;
                    a %= 5;
                    WinSendMsg(hwndFrame, WM_SETICON, (MPARAM)hIcon[a], 0);
                    ChangeTrayIcon(hwnd, 0);
                    break;

            	case 104: // Show
                	WinSetWindowPos(hwndFrame, HWND_TOP, 0, 0, 0, 0,
                                	SWP_ACTIVATE |
                                    SWP_SHOW     |
                                    SWP_ZORDER   |
                                    SWP_RESTORE);
                    break;

            	case 105: // Hide
                    WinSetWindowPos(hwndFrame, HWND_TOP, 0, 0, 0, 0, SWP_HIDE);
                    break;

            	case 106: // Help

                    WinMessageBox(HWND_DESKTOP, hwndFrame,
            	                 "Application example that uses Systray",
                            	 "About Systray example",   // Message title
            	                 0,                         // MessageBox ID
                                 MB_INFORMATION | MB_OK | MB_MOVEABLE);

                   break;

            	case 107: // Exit
                    WinPostMsg(hwnd, WM_QUIT, 0, 0);
                	break;

        	}
        	break;

    	case WM_CREATE:
        	/* initialize tray api */
            InitializeTrayApi(hwnd);
        	break;

    	case WM_DDE_INITIATEACK:
        	/* aswer dde server */
            AnswerTrayApiDdeAck(mp1);
            AddTrayIcon(hwnd,
                    	(HPOINTER)WinSendMsg(hwndFrame, WM_QUERYICON, 0, 0));
            WinStartTimer(hab, hwnd, 1, 500);

            return 0;

    	case WM_PAINT:
            hps = WinBeginPaint(hwnd, 0, 0);
            WinQueryWindowRect(hwnd, &rcl);

            WinFillRect(hps, &rcl, CLR_CYAN);

        	WinDrawText(hps, -1, szTextMessage, &rcl, CLR_DARKBLUE, CLR_CYAN,
                        DT_CENTER | DT_VCENTER);

            WinEndPaint(hps);
        	break;

    	case WM_DESTROY:
        	/* delete application icon from system tray */
            return (MRESULT)DeleteTrayIcon(hwnd);
	}

    return WinDefWindowProc(hwnd, msg, mp1, mp2);
}

