/* REXX installation script for Systray/2
 * by Ilfat Kutdusov, 
 * modified by Dmitry Zakharov, Konstantin Okounkov
 * Special thanks to Dmitry A.Steklenev ;-)
 */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs



/*------------------------------------------------------------------
 * Initialization 
 *------------------------------------------------------------------*/

globalvar  = "bootdisk keyboard configsys installdir installlog msg. reboot"

installdir = directory()"\"
installlog = installdir"install.log"
parse upper value VALUE( "PATH",, "OS2ENVIRONMENT" ) with "\OS2\SYSTEM" -2 bootdisk +2

DLLdir   = bootdisk"\OS2\DLL"

'cls'
say " "
say " "

if GetYesNo( "Install Systray/2 in" installdir ) == 0 then
   exit

/*------------------------------------------------------------------
 * Create folder
 *------------------------------------------------------------------*/
say " "
say " WARNING! Close Systray II, if it works now!! " 
say " "
'@pause'

say " "
say " Unregistering older SomAgent (if exists) " 

CALL SysDestroyObject '<WP_SOMAGENT>'
CALL SysDeregisterObjectClass 'SomAgent'

say " Copying SomAget.dll to " DLLdir 

'@copy 'installdir'\somagent\*.dll 'DLLdir ' > nul '

say " SomAgent Registering" 
CALL SysRegisterObjectClass 'SomAgent', 'SOMAGENT'
CALL SysCreateObject 'SomAgent', 'SomAgent Monitor Object', '<WP_DESKTOP>',,
                     'OBJECTID=<WP_SOMAGENT>;NOTVISIBLE=Yes;REPLACE'


rc = SysCreateObject( "WPFolder","Systray/2","<WP_DESKTOP>",,
                      "OBJECTID=<WPSystrayFolder>;ALWAYSSORT=Yes" ,"REPLACE" )
if rc then call log "Systray/2 folder successfully created on desktop..."
else       call log "ERROR: Systray/2 folder creating failed!"

/*
rc = SysCreateObject("WPShadow","Sources","<WPSystrayFolder>","SHADOWID="installDir"Sources","Replace")
if rc then    call log "Sources shadow successfully created..."
   else       call log "Sources shadow  creating failed!"
*/

rc = SysCreateObject("WPShadow","Using of Tray in C","<WPSystrayFolder>","SHADOWID="installDir"trayex.c","Replace")
if rc then    call log "'Using of Tray in C' shadow successfully created..."
   else       call log "'Using of Tray in C' shadow  creating failed!"

rc = SysCreateObject("WPShadow","Using of Tray in Pascal(VP)","<WPSystrayFolder>","SHADOWID="installDir"trayex.pas","Replace")
if rc then    call log "'Using of Tray in Pascal' shadow successfully created..."
   else       call log "'Using of Tray in Pascal' shadow  creating failed!"


/*------------------------------------------------------------------
 * Create object
 *------------------------------------------------------------------*/

rc = SysCreateObject( "WPProgram", "Systray/2", "<WPSystrayFolder>",,
                      "OBJECTID=<WPSystray>;EXENAME="installdir"systray2.exe;STARTUPDIR="installdir";REPLACE" )
if rc then       call log "Systray/2 object successfully created..."
  else           call log "ERROR: Systray/2 object creating failed!"


rc = SysCreateObject( "WPProgram", "System Tray Example", "<WPSystrayFolder>",,
                      "OBJECTID=<WPSystrayTrayEx>;EXENAME="installdir"\trayex.pas\trayex.exe;STARTUPDIR="installdir";REPLACE" )
if rc then       call log "System tray Example object successfully created..."
  else           call log "ERROR: System tray Example object creating failed!"


rc = SysCreateObject( "WPProgram", "Users Guide", "<WPSystrayFolder>",,
                      "OBJECTID=<SystrayReadme>;EXENAME=view.exe;PARAMETERS="installdir"systray.inf;STARTUPDIR="installdir";REPLACE" )
if rc then    call log "Reference object successfully created..."
   else       call log "ERROR: Reference object creating failed!"

rc = SysCreateObject( "WPProgram", "Additional Programming Reference Guide (beta:)", "<WPSystrayFolder>",,
                      "OBJECTID=<SystrayDevRef>;EXENAME=view.exe;PARAMETERS="installdir"progref.inf;STARTUPDIR="installdir";REPLACE" )
if rc then    call log "Reference object successfully created..."
   else       call log "ERROR: Reference object creating failed!"


rc = SysCreateObject( "WPShadow", "Systray/2", "<WP_START>",,
                      "SHADOWID=<WPSystray>",,
                      "REPLACE" )
if rc then    call log "Systray/2 object shadow added in Startup folder..."
   else       call log "Systray/2 object shadow adding in Startup folder failed!"




/*------------------------------------------------------------------
 * Create object
 *------------------------------------------------------------------*/


if GetYesNo( "Do you want to start Systray now" ) == 1 then
   'start systray2.exe'




Exit

/*------------------------------------------------------------------
 * Get Yes or No
 *------------------------------------------------------------------*/
GetYesNo: procedure

   ok = 0

   do until ok
      call charout, arg(1) || "? "
      pull reply
      reply = left(reply, 1)
      ok = (reply = "Y") | (reply = "N")
      if \ok then do
         say 'Huh? Please enter "Y" or "N".'
      end
   end

return (reply = "Y")

/*------------------------------------------------------------------
 * Write log message
 *------------------------------------------------------------------*/
Log: procedure expose installlog; parse arg msg

   say  " "msg
   call lineout installlog, "INSTALL: "msg

return
