/*------------------------------------------------------------------*/
/* Run Java App  -- put jarfile.jar and any options for the app     */
/* in the "Parameters" field of the program object                  */
/* e.g. the program object for this script should be:               */
/* "path and file name" = location of this script                   */
/* "Parameters" = java_app.jar  java_app.init -v                    */
/* "working directory" = path to this script                        */
/* Just run this script from the same directory as the *.jar file   */
/*                                                                  */
/* Contact Cary at crenquis@pacbell.net if you have problems        */
/*------------------------------------------------------------------*/

rxload = RxFuncQuery('SysLoadFuncs')          /* load Rexx libs if  */
If rxload Then                                /* not loaded         */
   Do
      Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
      Call sysloadfuncs
   End
say ''
say ''

/* Parse the arguments (Parameters) for the jarfile and any options */
/* that may follow the jarfile */
Parse arg jar_file ' ' jar_init
say 'jar file is ' || jar_file                /* for debug purposes */
say 'options are ' || jar_init                /* for debug purposes */


/* find the location of the jarfile                                 */
jar_path = Filespec('D',jar_file) || Strip(Filespec('P',jar_file),'T','\')
say 'jar file dir is ' || jar_path            /* for debug purposes */

/* Look for the location of Java131 in the system.ini file          */
/* Since most OS/2 users don't have java13x their default java, a   */
/* standard "java -fullversion" query doesn't work                  */
jpth = SysIni(,'Java131','USER_HOME')
if jpth = "ERROR:" then do                    /* Java131 not found  */
      say "Java131 not found";
      jpth = SysIni(,'Java13','USER_HOME');   /* look for Java13    */
      if jpth = "ERROR:" then do              /* Java13 not found   */
         say "Java13 not found -- require at least Java13";
         exit 1;
      end; /* then-do */
      else
         do
         jbase =getjavabase(jpth);
         say "Java13 location is " || jbase;  /* for debug purposes */
      end; /* else-do */
   end; /* then-do */
   else do
      jbase = getjavabase(jpth);
      say "Java131 location is " || jbase;    /* for debug purposes */
   end; /* else-do */

/* launch the app                                                   */
jbase ||'jre\bin\java.exe -jar ' || jar_file ||' '|| jar_init

Exit 0

/* Where is java13x located                                         */
getjavabase: procedure
arg pth
parse upper var pth jp 'JRE' junk;
return jp


