//
//  PMTPOSD2 On-Screen-Display utility for (most) IBM Thinkpads
//           showing volume-setting, mute, LCD-brightness and
//           monitor selection external-VGA/LCD or Dual (both)
//
//  Original code Copyright (c) 2003 Serge Sterck, PMTPOSD.ZIP package
//  Enhancements and fixes: (c) 2005 Fsys Software and Jan van Wijk
//
//  =====================================================================
//
//  This package contains Original Code and/or Modifications of Original
//  Code as made available by Serge Sterck in his PMTPOSD.ZIP package.
//
//  It also derives from original work and info by JMA (www.jma.se),
//  Marko Udvanc as well as suggestions made by other people
//
//  The PMTOOSD2 package is considered OPEN SOURCE, you may use it as you
//  see fit, and make modifications, as long as the original copyright
//  statements are left intact and operational.
//
//  The Original Code and all software distributed in the pakcage are
//  distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, AND FSYS-SOFTWARE AND ALL CONTRIBUTORS
//  HEREBY DISCLAIM ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION,
//  ANY WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
//  QUIET ENJOYMENT OR NON-INFRINGEMENT.
//
//  =====================================================================
//
// JvW 2005-11-04 Combined Brightness and Volumes scale/displays in one
// JvW 2005-11-04 Created PMTPOSD2 package, to be released as open source
// JvW 2005-11-03 Fixed spurious popups due to BIOS 'spikes' of 350 msec
// JvW 2005-11-01 Moved dialog to lower center of the screen
// JvW 2005-10-31 No dialog timeout as long as changes are made
// JvW 2005-10-31 Added display of LCD/VGA/DUAL monitor setting
// JvW 2005-10-30 Fix shuwdown-hang by calling CancelShutdown()
//
#include "stdio.h"
#include "conio.h"
#include "iopl32.h"
#define INCL_DOS
#define INCL_PM
#include "os2.h"
#include "pmtposd2.h"

static HBITMAP        icon_vol;
static HBITMAP        icon_scr;
static HBITMAP        bar_off;
static HBITMAP        vbar_on;
static HBITMAP        bbar_on;
static ULONG          id_timer;
static HAB            hab;
static ULONG          timeout;
static ULONG          old = 0;                  // previous cmos state

#define iMUTING(x) ((x & 0x00000040) >>  6)
#define iVOLUME(x) ((x & 0x0000000f)      )
#define iBRIGHT(x) ((x & 0x00000700) >>  8)
#define iDISPLY(x) ((x & 0x00030000) >> 16)

// constants defining absolute/relative positions within dialog
#define PMTP_ICON_LEFT    8
#define PMTP_ICON_RIGHT 374
#define PMTP_ICON_YPOS   34
#define PMTP_BAR_XPOS    70
#define PMTP_BAR_VYPOS   30
#define PMTP_BAR_BYPOS   64
#define PMTP_BAR_XDELTA  21
#define PMTP_BAR_BDELTA  42

#ifdef __WATCOMC__
 #define _outp outp
 #define _inp  inp
#endif

ULONG pmtpCmosByte                              // RET   CMOS byte
(
   ULONG               id
)
{
   _outp(        0x70, id);
   return ( _inp(0x71) & 0xFF);
}

ULONG pmtpGetCmos                               // RET   32 bits TP BIOS info
(
   void
)
{
   ULONG               rc = 0;

   enterIOPL32();
   rc  = ((pmtpCmosByte( CMOS_BYTE_DISPLY) &0x03) << 16);
   rc += ((pmtpCmosByte( CMOS_BYTE_BRIGHT) &0x27) <<  8);
   rc += ((pmtpCmosByte( CMOS_BYTE_VOLUME) &0xcf)      );
   leaveIOPL32();
   return( rc);
}

MRESULT EXPENTRY proc_dlg
(
   HWND                hwnd,                    // handle of window
   ULONG               msg,                     // id of message
   MPARAM              mp1,                     // first message parameter
   MPARAM              mp2                      // second message parameter
)
{
   HPS                 hps;
   POINTL              ptl;
   ULONG               i;
   ULONG               tpc;

   switch(msg)
   {
      case WM_INITDLG:
         timeout = 15;                          // 15  * 200ms = 3s
         hps = WinGetPS(hwnd);
         tpc = pmtpGetCmos();

         switch (iMUTING(tpc))                  // set volume related bitmaps
         {
            case 1:  icon_vol = GpiLoadBitmap( hps, NULLHANDLE, ID_SPK_OFF, 0L,0L); break;
            default: icon_vol = GpiLoadBitmap( hps, NULLHANDLE, ID_SPEAKER, 0L,0L); break;
         }
         bar_off = GpiLoadBitmap( hps, NULLHANDLE, ID_BAR_LEDOFF, 0L,0L);
         vbar_on = GpiLoadBitmap( hps, NULLHANDLE, ID_VOL_LEDON,  0L,0L);

         switch (iDISPLY(tpc))                  // set display related bitmaps
         {
            case 1:  icon_scr = GpiLoadBitmap( hps, NULLHANDLE, ID_SCRLCD,  0L,0L); break;
            case 2:  icon_scr = GpiLoadBitmap( hps, NULLHANDLE, ID_SCRVGA,  0L,0L); break;
            default: icon_scr = GpiLoadBitmap( hps, NULLHANDLE, ID_SCRDUAL, 0L,0L); break;
         }
         bbar_on  = GpiLoadBitmap( hps, NULLHANDLE, ID_SCR_LEDON,  0L,0L);

         WinReleasePS(hps);
         id_timer = WinStartTimer(hab,hwnd,ID_TIMER,200L);
         break;

      case WM_TIMER:
         hps = WinGetPS(hwnd);
         WinInvalidateRegion(hwnd,NULLHANDLE,0);
         tpc = pmtpGetCmos();

         if (icon_vol != 0) GpiDeleteBitmap( icon_vol);
         switch (iMUTING(tpc))                  // set volume related icons
         {
            case 1:  icon_vol = GpiLoadBitmap( hps, NULLHANDLE, ID_SPK_OFF, 0L,0L); break;
            default: icon_vol = GpiLoadBitmap( hps, NULLHANDLE, ID_SPEAKER, 0L,0L); break;
         }
         if (icon_scr != 0) GpiDeleteBitmap( icon_scr);
         switch (iDISPLY(tpc))                  // set display related icons
         {
            case 1:  icon_scr = GpiLoadBitmap( hps, NULLHANDLE, ID_SCRLCD,  0L,0L); break;
            case 2:  icon_scr = GpiLoadBitmap( hps, NULLHANDLE, ID_SCRVGA,  0L,0L); break;
            default: icon_scr = GpiLoadBitmap( hps, NULLHANDLE, ID_SCRDUAL, 0L,0L); break;
         }
         WinReleasePS(hps);

         if (old == tpc)                        // no changes, keep counting
         {
            timeout--;
            if (timeout == 0)                   // and end dialog at timeout
            {
               WinStopTimer(  hab, (HWND) 0, id_timer);
               WinDismissDlg( hwnd,TRUE);
            }
         }
         else                                   // reset timeout after changes
         {
            timeout = 15;                       // 15  * 200ms = 3s
            old = tpc;                          // set previous cmos state
         }
         break;

      case WM_PAINT:
         tpc = pmtpGetCmos();
         hps = WinBeginPaint(hwnd, (ULONG) 0, 0);

         ptl.x = PMTP_ICON_LEFT;
         ptl.y = PMTP_ICON_YPOS;
         WinDrawBitmap( hps, icon_vol, NULL,&ptl,0L,0L,DBM_NORMAL);

         ptl.x = PMTP_BAR_XPOS;
         ptl.y = PMTP_BAR_VYPOS;
         for(i = 0; i < iVOLUME(tpc); i++)
         {
            WinDrawBitmap( hps, vbar_on, NULL,&ptl,0L,0L,DBM_NORMAL);
            ptl.x += PMTP_BAR_XDELTA;
         }
         for(i = iVOLUME(tpc); i < 14; i++)
         {
            WinDrawBitmap( hps, bar_off, NULL,&ptl,0L,0L,DBM_NORMAL);
            ptl.x += PMTP_BAR_XDELTA;
         }

         ptl.x = PMTP_BAR_XPOS;
         ptl.y = PMTP_BAR_BYPOS;
         for(i = 0; i < iBRIGHT(tpc); i++)
         {
            WinDrawBitmap( hps, bbar_on, NULL,&ptl,0L,0L,DBM_NORMAL);
            ptl.x += PMTP_BAR_XDELTA;
            WinDrawBitmap( hps, bbar_on, NULL,&ptl,0L,0L,DBM_NORMAL);
            ptl.x += PMTP_BAR_XDELTA;
         }
         for(i = iBRIGHT(tpc); i < 7; i++)
         {
            WinDrawBitmap( hps, bar_off, NULL,&ptl,0L,0L,DBM_NORMAL);
            ptl.x += PMTP_BAR_XDELTA;
            WinDrawBitmap( hps, bar_off, NULL,&ptl,0L,0L,DBM_NORMAL);
            ptl.x += PMTP_BAR_XDELTA;
         }

         ptl.x = PMTP_ICON_RIGHT;
         ptl.y = PMTP_ICON_YPOS;
         WinDrawBitmap( hps, icon_scr, NULL,&ptl,0L,0L,DBM_NORMAL);

         WinEndPaint(hwnd);
         break;

      default:
         return WinDefDlgProc(hwnd, msg, mp1, mp2);
         break;
   }
   return WinDefDlgProc(hwnd,msg,mp1,mp2);
}


int main(int argc,char **argv)
{
   HMQ                 hmq;
   ULONG               first;
   ULONG               last;

   hab = WinInitialize(0);
   hmq = WinCreateMsgQueue(hab,0);
   WinCancelShutdown( hmq, TRUE);               // avoid hanging shutdown; JvW

   last = pmtpGetCmos();                        // read initial last sample
   for(;;)                                      // do forever ...
   {
      WinDlgBox( HWND_DESKTOP, HWND_DESKTOP,    // show the popup dialog
                (PFNWP) proc_dlg, (HMODULE) 0,
                        ID_SOUND, NULL);        // updates 'old' value too!
      last = old;
      do                                        // wait until real value change
      {
         first = last;                          // propagate last sample
         DosSleep(400);                         // bridge typical BIOS spike
         last  = pmtpGetCmos();                 // and read next sample
      } while ((last != first) || (last == old));
   }
   return 0;                                    // no cleanup, unreachable :-)
}
