/*
 *      Copyright (C) 1997-2004 Andrei Los.
 *      This file is part of the lSwitcher source package.
 *      lSwitcher is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published
 *      by the Free Software Foundation, in version 2 as it comes in the
 *      "COPYING" file of the lSwitcher main distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#ifndef COMMON_H_INCLUDED
#define COMMON_H_INCLUDED

#include "lswitch.h"

#define BUBBLETIMERINTERVAL 100

#define AdjustItem(Item,MaxVal)\
  Item += ((SHORT)Item < 0 ? -((SHORT)Item+1)/(SHORT)MaxVal+1 :\
           -(SHORT)Item/(SHORT)MaxVal)*(SHORT)MaxVal

BOOL ChangeWindowPos(LSWDATA *plswData,SHORT iItemNum,USHORT cmd);
BOOL WndHasControl(HAB hab,HWND hwndToCheck,USHORT usControl);
BOOL MenuNeedsItem(LSWDATA *plswData,USHORT usItem,USHORT usId,UCHAR *pszTitle,USHORT usLen,BOOL bGroup);
BOOL IsMinToViewer(HWND hwnd,ULONG flopt);
VOID MinimizeHideAll(LSWDATA *plswData, BOOL bReset, HWND hwndReset);
VOID GetItemTitle(HSWITCH hsw,UCHAR *ucTitle,USHORT usLen,BOOL bSessNum);
HPOINTER GetItemIcon(HWND hwnd);
PSZ GetObjectName(USHORT usObjHandle);
VOID ShowBubble(LSWDATA *plswData,SHORT iMouseIsAtItem,USHORT usX,USHORT usY,SHORT iFunc,UCHAR *ucTitle2);
VOID InitTaskActionsMenu(HWND hwndMenu,LSWDATA *plswData,SHORT iMenuAtItem,BOOL bTaskBar,BOOL bGroup);
VOID ShowMenu(LSWDATA *plswData,SHORT iMenuAtItem,BOOL bTaskBar,BOOL bGroup);
BOOL IsDesktop(HWND hwnd);
VOID InitTaskArr(LSWDATA *plswData, BOOL bFullScreen,BOOL bTaskBar,BOOL bUseFilters);
BOOL IsInSkipList(LSWSETTINGS *pSettings,UCHAR *ucTitle,BOOL bTskBar);
BOOL IsWindowClass(HWND hwnd,UCHAR *pszClassName);
PVOID GetSwitchList(HAB hab,BOOL bInit,ULONG *ulItemCount);
ULONG MapCommand(USHORT cmd);
USHORT RunCommand(LSWDATA *plswData,UCHAR *ucCommand,UCHAR *ucErrMsg,USHORT usErrMsgLen);
VOID SetControlsFont(HWND hwnd,BOOL bDoTitleBar);
VOID GetStartupDir(UCHAR *ucDir,USHORT usLen);
BOOL queryAppInstance(VOID);
BOOL UpdateWinFlags(ULONG *OldFlags,ULONG NewFlags);
BOOL AddFilter(LSWSETTINGS *pSettings,UCHAR *ucName,BOOL bTskBar);
BOOL RemoveFilter(LSWSETTINGS *pSettings,UCHAR *ucName,BOOL bTskBar);
VOID MakeFitStr(HPS hps,UCHAR *ucStr,USHORT usStrLen, USHORT usStrWid);
USHORT FindResDll(UCHAR *ucDllName, USHORT usNameLen, UCHAR *ucLang, UCHAR *ucLangStr, USHORT usLangStrLen);
HMODULE LoadResource(UCHAR ucLang, LSWDATA *plswData, BOOL bEngOk);
BOOL WinSendMsgAsync(HWND hwnd, ULONG ulMsgid, MPARAM mpParam1, MPARAM mpParam2, MRESULT *mrRes);
USHORT ProcessAPMOffRequest(USHORT usPowerState,USHORT usDevice);
SHORT InsertMenuItem(HWND hwndMenu, HWND hwndSubMenu, SHORT iPosition, SHORT sItemId,
                     char *ItemTitle, SHORT afStyle, SHORT afAttr, ULONG hItem);
PID GetWPSPid(VOID);
HFILE OpenXF86(VOID);
BOOL Death(PID pid);
SHORT TaskArrItemFromHsw(LSWDATA *plswData,USHORT hsw,BOOL bUseFilters);
VOID FillRectGradient(HPS hps, RECTL *rcl, RECTL *rclClip, LONG RGBDark, LONG RGBLight, BOOL bReverse);
LONG CalcBrightCol(LONG lColor,UCHAR ucBright);
VOID ProcessCommand(USHORT cmd, USHORT src, LSWDATA *plswData, BOOL bTaskBar, BOOL bAll);
BOOL IsInDesktop(HWND hwnd);
LONG GetCurrDesktop(LSWDATA *plswData);

#endif

